/**
 * Copyright esukei ( http://wonderfl.net/user/esukei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zHJF
 */

/**
 * @author esukei
 * ColorTransformの挙動を確認したかっただけ。
 */
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    
    public class ColorTest extends Sprite {
        
        private var sprite:Sprite;
        private var textField:TextField;
        
        public function ColorTest() {
            
            sprite = new Sprite();
            
            sprite.x = 0;
            sprite.y = 0;
            
            sprite.graphics.beginFill(0x808080,1.0);
            sprite.graphics.drawRect(0,0,stage.stageWidth,200);
            sprite.graphics.endFill();
            
            addChild(sprite);
            
            textField = new TextField();
            textField.width = stage.stageWidth;
            textField.height = 200;
            textField.y = stage.stageHeight - textField.height;
            textField.text = 'output Logs.';
            textField.multiline = true;
            addChild(textField);
            
            addEventListener(Event.ENTER_FRAME, enterFrameHandler);
            
        }
        
        private function enterFrameHandler(e:Event):void
        {
            //直接値は変えられない
            sprite.transform.colorTransform.greenOffset += 1;
            
            //ColorTransformオブジェクト経由だったらオーケー
            //あとリファレンスにoffsetは-255～255ってかいてあるけど、数値上はがんがん足されていく。
            sprite.transform.colorTransform = new ColorTransform(1.0, 1.0, 1.0, 1.0, sprite.transform.colorTransform.redOffset + 1, 0, 0, 0);
            
            textField.text = sprite.transform.colorTransform.toString();
            
            if(sprite.transform.colorTransform.redOffset >= 512)
            {
                removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
            }
            
        }
    }
}