/**
 * Copyright hig_an ( http://wonderfl.net/user/hig_an )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zGlw
 */

package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.events.MouseEvent;
	import flash.geom.ColorTransform;
	import flash.utils.Timer
	import flash.events.TimerEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	public class Main extends Sprite {
		private var numOfCircle:Number = 30;
		private var circleList:Array;
		private var preMouseList:Array;
		private var mouseList:Array;
		private var score:Number = 0;
		private var preScore:Number = 0;
		
		private var tf:TextField;
		private var timer:Timer;
		private var colorTf:ColorTransform;
		private var bmpd:BitmapData;
		private var mt:Matrix;
		private var sp:Sprite;
		private var num:Number = 0;
		private var clicked:Boolean = false;
		private var preMousePoint:Point;
		
		public function Main():void {
			tf = new TextField();
			tf.defaultTextFormat = new TextFormat("_typeWriter", 40, 0x0, true);
			tf.autoSize = "left";
			addChild(tf);
			tf.text = "Score:"+score.toString()+"\n"+preScore.toString();
			tf.x = 0;
			
			
			timer = new Timer(1000);
			preMouseList = new Array();
			circleList = new Array()
			bmpd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x0);
			mt = new Matrix();
			sp = newFig(0, 0);
			colorTf = new ColorTransform();
			preMousePoint = new Point(stage.stageWidth / 2, stage.stageHeight / 2);
			
			reset();
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			stage.addEventListener(MouseEvent.MOUSE_UP,mouseUp);
			
			addChild(new Bitmap(bmpd));
			
			timer.addEventListener(TimerEvent.TIMER, onTimerEvent);
			timer.start();
		}
		private function mouseDown(e:MouseEvent):void {
			clicked = true;
			
			addEventListener(Event.ENTER_FRAME, loop);
		}
		private function mouseUp(e:MouseEvent):void {
			var numOfReleased:Number = num;
			mouseList = new Array();
			for (var i:int = 0 ; i < numOfCircle; i++) {
				mouseList[i] = circleList[numOfReleased++ % numOfCircle]
			}
			if (clicked)	stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
			clicked = false;
		}
		public function loop(e:Event) :void{
			bmpd.lock()
			bmpd.fillRect(bmpd.rect, 0xFFFFFF);
			if (clicked) {
				preMouseList[num].x = mouseX;
				preMouseList[num].y = mouseY;
				num = ++num % preMouseList.length;
				for (var i:int = 0; i < numOfCircle; i++) {
					circleList[i].x = preMouseList[i].x;
					circleList[i].y = preMouseList[i].y;
					mt.identity();
					mt.translate(circleList[i].x, circleList[i].y)
					bmpd.draw(sp, mt,colorTf);
				}
			}else {
				mouseList.shift();
				
				for (i = 0; i < mouseList.length; i++) {
					mt.identity();
					mt.translate(mouseList[i].x, mouseList[i].y)
					bmpd.draw(sp, mt,colorTf);
				}
				if (mouseList.length == 0) {
					reset();
					stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
					removeEventListener(Event.ENTER_FRAME, loop);
				}
			}
			bmpd.unlock();
		}
		private function onTimerEvent(e:TimerEvent) :void {
			tf.text = "Score:" + score.toString()+"\n"+preScore.toString();
			
			if (clicked) {
				preScore = Math.sqrt(Math.pow((preMousePoint.x - mouseX), 2) + Math.pow((preMousePoint.y - mouseY), 2));
				
				var dis:Number = 3
				if (preScore <= 50) {
					//So Kind
					score += 15;
					colorTf.blueOffset = 0;
					colorTf.greenOffset = 255;
					colorTf.redOffset = 255;
				}else if (( 50 < preScore) && (preScore <= 100)){
					//normal
					score += 10;
					colorTf.blueOffset = 0;
					colorTf.redOffset = 255;
					colorTf.greenOffset = 0;
				}else if ((100 < preScore)&&( preScore<= 200)) {
					//too hard
					score += 5
					colorTf.redOffset = 0;
					colorTf.blueOffset = 255;
					colorTf.greenOffset = 0;
				}else if (preScore == 0) {
					//stop
					score -= 5;
				}else {
					score -= 10;
					colorTf.redOffset = 0;
					colorTf.blueOffset = 0;
					colorTf.greenOffset = 0;
				}
			}else {
				score--;
				
			}
			preMousePoint.x = mouseX;
			preMousePoint.y = mouseY;
		}
		private function reset() :void{
			for (var i:int = 0; i < numOfCircle; i++) {
				circleList[i] =  new Circle(-100, -100);
				preMouseList[i] = new Point(-100, -100);
			}
			preScore = 0;
		}
		private function newFig(xx:Number,yy:Number) :Sprite{
			var s:Sprite = new Sprite();
			s.graphics.beginFill(0x0);
			s.graphics.drawCircle(xx, yy, 10);
			s.graphics.endFill()
			
			return s;
		}
	}
}
class Circle{
		public var x:Number;
		public var y:Number;
		public function Circle(xx:Number, yy:Number) {
			x = xx;
			y = yy;
		}
}