/**
 * Copyright Heart.Narongrit ( http://wonderfl.net/user/Heart.Narongrit )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zFtt
 */

// forked from Event's Simple MediaRSS Viewer
package {
    import flash.text.TextField;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.net.URLLoader;
    import flash.display.*;
    
    [SWF(backgroundColor="#000000")] 
    public class MediaRSSReader extends Sprite {
        
        private var media:Namespace = new Namespace("http://search.yahoo.com/mrss/");
        private var list:Vector.<ImageThumb>;
        private var kw:TextField;
        private var container:Sprite;
        private var history:TextField ;
        public function MediaRSSReader() {
            Wonderfl.capture_delay(30);
             container = new Sprite();
             history = new TextField();
             addChild(history);
             history.width = 600;
             history.y = stage.stageHeight-30;
             history.textColor = 0xFFFFFF;
 
             addChild(container); 
             container.y=30;
            kw = new TextField();
            kw.mouseEnabled = false;
            kw.textColor = 0xFFFFFF;
            kw.selectable = false;
            addChild(kw);
            kw.width = 600;
            search("cat");
            stage.addEventListener(MouseEvent.MOUSE_MOVE , onmove );
        }
        private function onmove(e:MouseEvent):void{
            if(container.width > stage.stageWidth ){
                var p:Number = mouseX/stage.stageWidth;
                var m:Number = container.width-stage.stageWidth;
                container.x = -m*p;
            }else{
                container.x = 0;
            }

        }

        private function search( q:String ):void{
            history.appendText("-->"+q.toUpperCase());
            var tmp:Array = history.text.split("-->");
            
            if(tmp.length > 7){
                tmp.splice(0,1);
                history.text = tmp.join("-->");
            }

             kw.text = "keyword = "+q;
            var _feed:String = "http://api.flickr.com/services/feeds/photos_public.gne?tags="+q+"&format=rss_200";
            var ldr:URLLoader = new URLLoader;
            ldr.addEventListener(Event.COMPLETE, function _load(e:Event):void {
                ldr.removeEventListener( Event.COMPLETE, _load);
                onImageLoaded(XML(ldr.data)..media::thumbnail.@url.toXMLString().split('\n') , XML(ldr.data)..media::title.toXMLString().split('\n')); 
            }); 
            ldr.load(new URLRequest(_feed));
        }

        private function onImageLoaded($images:Array,$title:Array):void {
            if( $images.length == 0){
                search("notfound");
                return;
            }

            var col:int = 0;
            var row:int = 0;
            list = new Vector.<ImageThumb>();
            for (var i:int = 0; i < $images.length; ++i) {
                var title:String = XML($title[i]).toString();
                var img:ImageThumb = new ImageThumb( $images[i] , title );
                list.push(img);
                container.addChild(img);
                img.addEventListener(Event.SELECT , onSelect );
                img.x = 150*col
                img.y = 99*row;
                row++;
                if(row == 4){
                   row=0;
                   col++; 
                }
            }
        }
        private function onSelect(e:Event):void{
           var title:String = e.currentTarget.title;
           if( title.length > 3 ){
           for(var i:String in list){
               list[i].removeEventListener(Event.SELECT , onSelect );
               container.removeChild( list[i] );
           }
           search(title.split(" ")[0]);
           }
        }

    }
}

import flash.display.Sprite;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.events.Event;
class ImageThumb extends Sprite{
    public var title:String;
    private var ldr:Loader;
    private var caption:TextField;
    private var tf:TextFormat = new TextFormat("Arial",11,0x6c6c6c);
    private var fl:GlowFilter = new GlowFilter(0x00FF33);
    public function ImageThumb( $url:String , $title:String ){
        title = $title;
        ldr = new Loader;
        ldr.load(new URLRequest($url));
        caption = new TextField();
        caption.selectable = false;
        caption.text = title;
        caption.setTextFormat(tf);
        caption.y = 80;
        addChild(caption);
        caption.autoSize = TextFieldAutoSize.LEFT;
        this.addEventListener(MouseEvent.MOUSE_OVER , effect );
        this.addEventListener(MouseEvent.MOUSE_OUT , effect );
        this.addEventListener(MouseEvent.CLICK , effect );
        this.buttonMode=true;
         addChild(ldr);
    }
    private function effect(e:MouseEvent):void{
        if(e.type == MouseEvent.MOUSE_OVER){
            ldr.filters = [fl]
        }else if(e.type == MouseEvent.MOUSE_OUT){
            ldr.filters = null;
        }else if( e.type == MouseEvent.CLICK){
            dispatchEvent(new Event(Event.SELECT));         
        }
    }
}





