/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zFBC
 */

// forked from Kay's 水風船ぶら下げて
/*
 * サムネールを綺麗に生成するコツを知りたい！
 */
package {
	import flash.display.*;
	import flash.events.Event;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	[SWF(width="465", height="465",frameRate="60",backgroundColor="#ffffff")]
	public class Main extends Sprite {
		private var ball:Ball;
		private var paper:Sprite;
		private var past:Point;
		private var bmd:BitmapData;
		private var bm:Bitmap;
		private var cV:Number = 0;
		
		public function Main():void {
			past = new Point();
			paper = new Sprite();
			bmd = new BitmapData(465,465);
			bm = new Bitmap(bmd);
			addChild(bm);
			ball = new Ball();
			addChild(ball);
			addEventListener(Event.ENTER_FRAME, xDraw);
		}
		private function xDraw(e:Event):void {
			cV += 0.15;
			var nV:uint = Math.floor((Math.cos(cV)+1)/2*0x33)+0xcc;
			var nColor:uint = nV * 256 * 256 + nV;
			var dx:Number = past.x - ball.x;
			var dy:Number = past.y - ball.y;
			var nSize:Number = Math.sqrt(dx*dx+dy*dy)*0.75;
			paper.graphics.beginFill(0x000000,0.5);
			paper.graphics.drawCircle(ball.x+4, ball.y+4,nSize);
			paper.graphics.drawCircle(ball.x+4, ball.y+4,nSize/2);
			paper.graphics.beginFill(nColor);
			paper.graphics.drawCircle(ball.x, ball.y,nSize);
			paper.graphics.drawCircle(ball.x, ball.y,nSize/2);
			bmd.draw(paper);
			paper.graphics.clear();
			past.x = ball.x;
			past.y = ball.y;
		}
	}
}

import flash.display.Sprite;
import flash.events.Event;
class Ball extends Sprite {
	private var vx:Number=0;
	private var vy:Number=0;
	private var circle:Sprite;
	private const FRICTION:Number = 0.97;
	private const SPRING:Number = 0.1;
	
	public function Ball():void {
		circle = new Sprite();
		//circle.graphics.beginFill(0x6666ff);
		//circle.graphics.drawCircle(0,0,10);
		//addChild(circle);
		circle.addEventListener(Event.ENTER_FRAME, xRubber);
	}
	
	private function xRubber(e:Event):void {
		/*
		 * 参考：Aquioux's Mouse stalker 001
		 */
		var dx:Number = mouseX - e.target.x;
		var dy:Number = mouseY - e.target.y;
		vx += dx * SPRING;
		vy += dy * SPRING;
		vx *= FRICTION;
		vy *= FRICTION;
		x += vx;
		y += vy;
	}
}