/**
 * Copyright lespleen ( http://wonderfl.net/user/lespleen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zF5u
 */

package {
    import flash.net.URLLoader;
    
    import flash.display.*
    import flash.filters.*;
    
    import flash.geom.Rectangle;
    import flash.geom.Point;
    
    import flash.events.Event;
    import flash.geom.Matrix;
   
    import flash.geom.ColorTransform;
    
    import flash.net.*;
    
    import flash.system.*;
    
    import flash.utils.*;
    import flash.utils.ByteArray;
    
    import net.hires.debug.Stats;
           
    [SWF(width='320',height='320',backgroundColor='#000000',frameRate='30')];
           
    public class Rorschach extends Sprite {   
         
         /* pxbender */
  
        private var shader_job:ShaderJob;
        private var shader:Shader;
        private var filter:ShaderFilter;
            
        public var bd:BitmapData;
        public var bd2:BitmapData;
        private var bd3:BitmapData;
  
        public var bmp:Bitmap;
       
        public var point:Point;
              
        public var circular_mask:Sprite;
        private var mg:Graphics;
       
        private var offs:Array;
        
        private var cw:uint;
        private var cw2:uint;
        private var ch:uint;
              
        private var perlin_seed:uint;
                    
        private var flip_matrix:Matrix;
        private var matrix:Matrix;
        
        private var seed:uint;
       
        private const blur:BlurFilter = new BlurFilter(3,3,1);
        private const ct:ColorTransform = new ColorTransform(1,1,1,.75)
        
        private var shader_loader:URLLoader;
        
        public function Rorschach( w:uint=320, h:uint=320, seed:uint=0) 
        {
           super();
           
           cw=w;
           ch=h;
           perlin_seed = seed
      
           stage ? init(): addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true)
        }
        
        private function init(e:Event=null):void
        {    
            stage.quality = "LOW"
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
                  
            cw2 = cw/2 
            
            flip_matrix=new Matrix();
            flip_matrix.scale(-1,1);
            flip_matrix.translate(cw,0);
            
            bd = new BitmapData(cw2, ch, true, 0);
            bd2 = new BitmapData(cw, ch, true, 0);
            bd3=new BitmapData(cw, ch, true, 0);
                        
            point = new Point(00);
                     
            bmp = new Bitmap(bd3);
            
            matrix =new Matrix();
            matrix.createGradientBox(cw, ch) 
            
            circular_mask=new Sprite();
            
            mg = circular_mask.graphics
                            
            offs = [new Point(), new Point()];
            
            this.addChild(bmp);
            this.addChild(new Stats())
            
            Security.loadPolicyFile("http://spleen.noo.name/crossdomain.xml");
                 
            //shader_loader = new URLLoader()
            //shader_loader.dataFormat = URLLoaderDataFormat.BINARY; 
            //shader_loader.addEventListener(Event.COMPLETE, on_load_shader,false,0,true); 
            
            //shader_loader.load( new URLRequest("http://spleen.noo.name/pbj/deformer.pbj") ); 
            this.addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }
        
        private function on_lad_shader(e:Event):void{
         
            //shader_loader.removeEventListener(Event.COMPLETE, on_load_shader);
            
            //shader = new Shader( shader_loader.data )
                                        
            //shader_job = new ShaderJob(shader, bd3, bd3.rect.width, bd3.rect.height);
                                 
            //filter = new ShaderFilter( shader )
            
         
         //this.addEventListener(Event.ENTER_FRAME, render, false, 0, true);
        }

        private var zp:Point = new Point()
        private var rnd:Function = Math.random;
        
        private var i:int = 0
        
        private function render(e:Event):void {
            
            offs[0].x+=cw2/100;
            offs[0].y+=-ch/300;
            
            offs[1].x+=-cw2/300;
            offs[1].y+=ch/450;
            
                                                                       
            //shader.data["stretch"].value=[100]
            //shader.data["imageHeight"].value=[500.0]
            //shader.data["center_x"].value=[200.0]
            //shader.data["center_y"].value=[200.0]
            
            mg.clear();
            mg.beginGradientFill(GradientType.RADIAL, [0, .5+rnd()*.5], [0,50], [ 255/2, 255], matrix); 
            mg.drawRect(0,0,cw2,ch);
            mg.endFill();
            
            bd.lock();
            bd.perlinNoise( cw2/2.5, ch/7, 3, 6000, false, true, 15, true, offs);
            bd.draw( circular_mask );
                     
            bd2.lock()         
            bd2.fillRect( bd2.rect, 0x00000000);
            bd2.threshold( bd, bd.rect, point, ">", 0x707070, 0xff000000, 0x00ffffff, false);
            bd2.draw(bd2, flip_matrix, null, null, null);
            bd2.applyFilter(bd2, bd2.rect, zp, blur);
                        
            bd3.draw(bd2);
            //bd3.applyFilter(bd3, bd3.rect, zp, filter);
            bd3.colorTransform(bd3.rect, ct);    
                            
   
            
            //shader_job.start(true); 
            
            //bmp.filters=[ filter]
                             
            bd3.unlock()         
            bd2.unlock();
                   
            
            
        }        
        
    }
}