/**
 * Copyright Kay ( http://wonderfl.net/user/Kay )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zF1P
 */

// forked from Kay's Shining Text
/*
 * テキストをアウトライン化してVector.<Point>に保存し
 * テキストの外周から線を引いて光を表現する
 * 先々を考えて、とっ散らかった処理を修正
 * -----------------------------------------------------
 * …結果的にfontSizeが小さいと、思ったラインが引けていないことを露呈
 * が、この座標データを拡大してオリジナルのサイズとラインか面でつなげば
 * fork元のShining Textより軽く、しかも美しくなりそうな予感がする
 */
package {
    import flash.display.*;
    import flash.geom.*;
    import flash.events.*;
    
    [SWF(framelate=20, backgroundColor=0x000000)]
    public class Main extends Sprite {
    	
		public const SW:Number = stage.stageWidth;
		public const SH:Number = stage.stageHeight;
		public const CX:Number = SW/2;
		public const CY:Number = SH/2;
		public var vOutline:Vector.<Point> = new Vector.<Point>();
		public var lx:Number = 0;
		public var myStage:Sprite = new Sprite();
		public var textColor:uint = 0xffff99;

		public function Main() {
			addChild(myStage);
			
        		var myText:SimpleText = new SimpleText('wonderFl','Arial',48,textColor);
        		
			var vTemp:Vector.<uint> = new Vector.<uint>();
			const TW:Number = myText.width;
			const TH:Number = myText.height;

			// Text -> BitmapData
			var bmd:BitmapData = new BitmapData(TW,TH,false,0);
			bmd.draw(myText);
			addChild(myText);
			myText.x = (SW - TW) / 2;
			myText.y = (SW - TH) / 2;
			
			// getColor
			for (var h:uint = 0; h < TH; h++) {
				for (var w:uint = 0; w < TW; w++) {
					vTemp[h*TW + w] = bmd.getPixel(w,h);
				}
			}
	
			// Gain inner Picels
			for (h = 0; h < TH; h++) {
				for (w = 0; w < TW; w++) {
					var flg:Boolean = false;
					var pos:uint = h*TW + w;
					if (h == 0 || h == TH-1 || w == 0 || w == TW-1) {
						if (vTemp[pos] == textColor) {
							flg = true;
						}
					} else {
						if (vTemp[pos] == textColor) {
							if (vTemp[pos+TW] != textColor ||
							    vTemp[pos-TW] != textColor ||
							    vTemp[pos-1]  != textColor ||
							    vTemp[pos+1]  != textColor) {
								flg = true;
							}
						}
					}
					if (flg) {
						vOutline.push(new Point(w-TW/2,h-TH/2));
					}
				}
			}
			
			// Outlineが取得できているかの検証
			var outline:BitmapData = new BitmapData(TW,TH,false,0x00000000);
			for (var i:uint = 0; i < vOutline.length; i++) {
				outline.setPixel(vOutline[i].x+TW/2, vOutline[i].y+TH/2, 0xffff0000);
			}
			var bitmap:Bitmap = new Bitmap(outline);
			addChild(bitmap);
			bitmap.x = (SW-TW)/2;
			bitmap.y = (SH-TH)/2+TH;
        }
    }
}

import flash.display.*;
import flash.text.*;
class SimpleText extends Sprite {
	public function SimpleText(message:String, fontName:String, fontSize:Number, fontColor:uint) {
		var tf:TextFormat = new TextFormat();
		tf.color = fontColor;
		tf.size = fontSize;
		tf.font = fontName;
		
		var txt:TextField = new TextField();
		txt.autoSize = TextFieldAutoSize.LEFT;
		txt.text = message;
		txt.selectable = false;
		txt.setTextFormat(tf);
		
		addChild(txt);
	}
}
