/**
 * Copyright fantasista ( http://wonderfl.net/user/fantasista )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zEv5
 */

package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BitmapDataChannel;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.filters.ColorMatrixFilter;
    import flash.filters.DisplacementMapFilter;
    import flash.filters.DisplacementMapFilterMode;
    import flash.filters.BlurFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.Timer;
    import com.flashdynamix.utils.SWFProfiler;
    
    [SWF (backgroundColor = "0x0", frameRate = "30", width = "465", height = "465")]
    
    public class BlurPerticle extends Sprite {
        
        public function BlurPerticle() {
            
            SWFProfiler.init(this);
            
            if (stage) {
                init(); 
            }else {
                addEventListener(Event.ADDED_TO_STAGE, init);
            }
        }
        
        private var _bmd:BitmapData;
        private var _canvas:Bitmap;
        private var _dispf:DisplacementMapFilter;
        private var _point:Point;
        private var _colorTf:ColorTransform;
        private var _blur:BlurFilter;
        private var _w:Number;
        private var _h:Number;
        private var _timer:Timer;
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            _canvas = new Bitmap(_bmd);
            addChild(_canvas);
            
           
            _point = new Point();
            _blur = new BlurFilter();     
            
            _w = stage.stageWidth;
            _h = stage.stageHeight;
            
            _timer = new Timer(1000, 0);
            addEventListener("_timer", setParticle);   
            addEventListener(Event.ENTER_FRAME, upDate);
            
            _timer.start();
        }
        
        private function setParticle(e:Timer):void {
            _point = new Point(Math.random()*_w, Math.random()*_h);
            _bmd.setPixel(_point.x, _point.y, 0xFFFFFF);
        }
        
        private function upDate(e:Event):void {
            _bmd.lock();
            /*
            var line:Shape = new Shape();
            line.graphics.beginFill(0xFFFFFF);
            line.graphics.lineStyle(10, 0xFFFFFF);
            line.graphics.moveTo(_x, _y);
            line.graphics.lineTo(mouseX, mouseY);
            line.graphics.endFill();
            
            _bmd.draw(line);
            */
            //_point = new Point(Math.random()*_w, Math.random()*_h);
            //_bmd.setPixel(_point.x, _point.y, 0xFFFFFF);
            _bmd.applyFilter(_bmd, _bmd.rect, _point, _blur);
            _bmd.unlock();
            
            //line = null;   
        }
        
    }
}