/**
 * Copyright codeonwort ( http://wonderfl.net/user/codeonwort )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zETa
 */

package {
    
    import flash.display.Loader
    import flash.net.URLRequest
    import flash.system.LoaderContext
    
    import flash.events.Event
    import flash.display.Shape
    import flash.display.Sprite
    import flash.display.Bitmap
    import flash.display.BitmapData
    import flash.text.TextField
    import flash.geom.Matrix
    import flash.geom.Point
    import flash.events.MouseEvent
    
    public class SunglowTest extends Sprite {
        
        private var txt:TextField
        private var dst:BitmapData
        private var src:BitmapData
        private var sun:Shape
        
        public function SunglowTest() {
            var img:Loader = new Loader
            img.contentLoaderInfo.addEventListener("ioError", load_fail)
            img.contentLoaderInfo.addEventListener(Event.COMPLETE, img_loaded)
            img.load(new URLRequest("http://clug.kr/~codeonwort/wonderfl/sea.jpg"), new LoaderContext(true))
            
            txt = new TextField
            txt.text = "loading..."
            txt.autoSize = "left"
            txt.selectable = false
            addChild(txt)
        }
        
        private function load_fail(e:Event):void {
            txt.text = "load failed"
        }
        
        private function img_loaded(e:Event):void {
            removeChild(txt)
            
            src = new BitmapData(465, 465, false, 0xff0000)
            src.draw(e.target.loader.content)
            addChild(new Bitmap(src))
            
            dst = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x0)
            addChild(new Bitmap(dst))
            
            sun = new Shape
            sun.graphics.beginFill(0xff9952, 0.04)
            sun.graphics.drawCircle(0, 0, 27)
            sun.graphics.endFill()
            
            mm()
            stage.addEventListener("mouseMove", mm)
        }
        
        private function addSun(tx:Number, ty:Number, scale:Number):void {
            dst.copyPixels(src, src.rect, new Point)
            var mat:Matrix = new Matrix
            mat.translate(tx, ty)
            var r:Number = sun.width / 2
            var maxR:Number = Math.max(dist(0, 0), dist(stage.stageWidth, 0), dist(0, stage.stageHeight), dist(stage.stageWidth, stage.stageHeight))
            while(r < maxR){
                dst.draw(sun, mat, null, "add")
                mat.translate(-tx, -ty)
                mat.scale(scale, scale)
                mat.translate(tx, ty)
                r *= scale
            }
            function dist(xx:Number, yy:Number):Number {
                return Math.sqrt(Math.pow(xx - tx, 2) + Math.pow(yy - ty, 2))
            }
        }
        
        private function mm(e:MouseEvent = null):void {
            addSun(mouseX, mouseY, 1.04)
        }
        
    }
    
}