/**
 * Copyright atsushi015 ( http://wonderfl.net/user/atsushi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zEFv
 */

package {
    import flash.display.Sprite;
    import flash.events.*;
    import Box2D.Common.*;
    import Box2D.Common.Math.*;
    import Box2D.Collision.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Dynamics.*;
    
    public class FlashTest extends Sprite {
            private var world:b2World;
            
        public function FlashTest() {
            // write as3 code here..
            [SWF(frameRate = 30)]
            var worldAABB:b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            var gravity:b2Vec2 = new b2Vec2(0, 10.0);
            
            world = new b2World(worldAABB, gravity, true);        // ワールド生成
            
            // 外枠の箱
                var bBodyDef:b2BodyDef = new b2BodyDef;
            var boxDef:b2PolygonDef = new b2PolygonDef();
            boxDef.density = 0;
            boxDef.SetAsBox(0.25, 5);
            bBodyDef.position.Set(-2.5, 0+3.5);
             var bBody:b2Body = world.CreateBody(bBodyDef);
            bBody.CreateShape(boxDef);
            
            bBodyDef.position.Set(2.5, 0+3.5);
            bBodyDef.linearVelocity.Set(0, 0.4);
            bBody = world.CreateBody(bBodyDef);
            bBody.CreateShape(boxDef);
            
            boxDef.SetAsBox(5, 0.25);
            bBodyDef.position.Set(0, -2.5+3.5);
            bBody = world.CreateBody(bBodyDef);
            bBody.CreateShape(boxDef);
   
           bBodyDef.position.Set(0, 2.5+3.5);
            bBody = world.CreateBody(bBodyDef);
            bBody.CreateShape(boxDef);

            // 箱の中に円を複数作る
            for (var i:int = 0; i < 22; i++) {
                    var cBodyDef:b2BodyDef = new b2BodyDef;
                    cBodyDef.position.Set(-2 + i % 9 * 0.5, 3 + i / 9 * 0.5);
                    
                    var circleDef:b2CircleDef = new b2CircleDef();
                    circleDef.radius = 0.25;
                    circleDef.density = 1;
                    circleDef.friction = 0.5;
                 circleDef.restitution = 0.5;
                 
                 var cBody:b2Body = world.CreateBody(cBodyDef);
                 cBody.CreateShape(circleDef);
                 cBody.SetMassFromShapes();
           }
           
           // DebugDraw
           var draw:b2DebugDraw = new b2DebugDraw;
           draw.m_fillAlpha = 1;
           draw.m_drawScale = 70;
           draw.m_sprite = this;
           draw.m_lineThickness = 1;
           draw.m_drawFlags = b2DebugDraw.e_shapeBit;
           world.SetDebugDraw(draw);
           
           addEventListener(Event.ENTER_FRAME, enterFrame);
           
            x += 256;
        }
        
        private function enterFrame(e:Event):void {
                world.Step(1 / 30, 10);
        }
    }
}