/**
 * Copyright s8t1h12akj ( http://wonderfl.net/user/s8t1h12akj )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zDTm
 */

// forked from s8t1h12akj's forked from: forked from: ParticleEffect (3)
// forked from fluxus's forked from: ParticleEffect (3)
// forked from ProjectNya's ParticleEffect (3)
////////////////////////////////////////////////////////////////////////////////
// ParticleEffect (3)
//
// [AS3.0] ParticleEffectクラスだ！ (1)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1452
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.display.StageScaleMode;
     import flash.display.StageAlign;
    import flash.events.Event;
    import flash.geom.Rectangle;
    import flash.display.BlendMode;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var effect:ParticleEffect;

        public function Main() {
            //Wonderfl.capture_delay(1);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            init();
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            //
            var label:Label = new Label(200, 60, 60, Label.CENTER);
            addChild(label);
            label.x = 132;
            label.y = 182;
            label.alpha = 0.25;
            label.textColor = 0xFFFFFF;
            label.text = "あき爺のテストです";
            //
            var rect:Rectangle = new Rectangle(-232, -232, 464, 464);
            var area:Rectangle = new Rectangle(-200, -20, 400, 40);
            effect = new ParticleEffect(rect, area);
            addChild(effect);
            effect.x = 232;
            effect.y = 232;
            effect.start(16, 6);
        }
        
    }

}


//////////////////////////////////////////////////
// ParticleEffectクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import frocessing.color.ColorHSV;

class ParticleEffect extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var area:Rectangle;
    private var particles:Array;
    private var id:uint = 0;
    private static var unit:uint = 10;
    private static var times:uint = 5;
    private var count:uint = 0;
    private var color:ColorHSV;

    public function ParticleEffect(r:Rectangle, a:Rectangle) {
        rect = r;
        area = a;
        init();
    }

    private function init():void {
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        bitmap.x = rect.x;
        bitmap.y = rect.y;
        particles = new Array();
        color = new ColorHSV(0, 0.5);
        blendMode = BlendMode.ADD;
    }
    public function start(u:uint, t:uint = 5):void {
        unit = u;
        times = t;
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    public function stop():void {
    }
    private function create():void {
        var position:int = 0;
        var distance:uint = 0;
        for (var n:uint = 0; n < unit; n++) {
            color.h = id*2%360;
            var particle:Particle = new Particle(color.value);
            particle.id = id;
            if (id < area.height) {
                position = area.x + (area.width/area.height)*id;
                distance = area.height;
            } else {
                position = 0;
                distance = area.width;
            }
            particle.x = position + distance*(Math.random() - 0.5);
            particle.y = area.height*(Math.random() - 0.5);
            particle.scale = 0.4 + 0.6*Math.random();
            particle.dx = 2*(Math.random() - 0.5);
            particle.dy = 4*(Math.random() - 0.5);
            particles.push(particle);
            id ++;
        }
    }
    private function update(evt:Event):void {
        if (count%times == 0) create();
        count ++;
        bitmapData.lock();
        bitmapData.fillRect(bitmapData.rect, 0x00000000);
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            if (particle) {
                particle.update();
                var matrix:Matrix = new Matrix();
                matrix.scale(particle.scale, particle.scale);
                matrix.translate(particle.x - rect.x, particle.y - rect.y);
                var colorTrans:ColorTransform = new ColorTransform();
                colorTrans.alphaMultiplier = particle.alpha;
                bitmapData.draw(particle, matrix, colorTrans, BlendMode.LAYER, null, true);
                if (particle.life < 0) {
                    particles.splice(0, 1);
                    particle = null;
                }
            }
        }
        bitmapData.unlock();
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;

class Particle extends Sprite {
    public var id:uint;
    private static var radius:uint = 8;
    private var bColor:uint = 0xFFFFFF;
    public var dx:Number = 0;
    public var dy:Number = 0;
    private static var acceleration:Number = 1.05;
    public var life:Number = 1;
    private static var deceleration:Number = 0.02;
    private var _scale:Number = 1;

    public function Particle(color:uint) {
        bColor = color;
        draw();
    }

    private function draw():void {
        var colors:Array = [bColor, bColor];
        var alphas:Array = [1, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(radius*2, radius*2, 0, -radius, -radius);
        graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
        alpha = 0;
    }
    public function update():void {
        x += dx*acceleration;
        y += dy*acceleration;
        life -= deceleration;
        alpha = (1 - life < 0.5) ? (1 - life)*2 : life*2;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_AR P行書体B";
    private var _width:uint = 20;
    private var _height:uint = 20;
    private var size:uint = 8;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, h:uint, s:uint = 12, align:String = LEFT) {
        _width = w;
        _height = h;
        size = s;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = size;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
