/**
 * Copyright lsd751 ( http://wonderfl.net/user/lsd751 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zCiB
 */

// forked from faseer's forked from: Metaball
// forked from faseer's Metaball
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Point;
    import flash.geom.Rectangle;
    
    /**
     * ...
     * @author hbb
     */
    public class TrickMetaball extends Sprite
    {
        private var _balls:Vector.<Ball>;
        private var _canvasSha:Shape;
        private var _canvasBmp:BitmapData;
        private var _output:BitmapData;
        
        private const _bound:Rectangle = new Rectangle(0.0, 0.0, 480.0, 480.0);
        private const _origin:Point = new Point(0.0, 0.0);
        private const _blurFilter:BlurFilter = new BlurFilter(64.0, 64.0,2);
        private const _blurFilter2:BlurFilter = new BlurFilter(8.0, 8.0, 1);
        
        public function TrickMetaball() 
        {
            createBalls(30);
            createOutput();
            addEventListener(Event.ENTER_FRAME, execute);
        }
        
        private function createOutput():void
        {
            _canvasSha = new Shape();
            _canvasBmp = new BitmapData( _bound.width, _bound.height, false );
            _output = _canvasBmp.clone();
            
            addChild( new Bitmap(_output) );
        }
        
        private function execute(e:Event):void 
        {
            _canvasSha.graphics.clear();
            
            var b:Ball;
            
            for (var i:int = _balls.length; i--; )
            {
                b = _balls[i];
                b.x += b.vx;
                b.y += b.vy;
                
                if (b.x + b.radius < 0) b.x = _bound.width + b.radius;
                else if (b.x - b.radius > _bound.width) b.x = - b.radius;
                
                if (b.y + b.radius < 0) b.y = _bound.height + b.radius;
                else if (b.y - b.radius > _bound.height) b.y = - b.radius;
                
                _canvasSha.graphics.beginFill(0x000000, 100.0);
                _canvasSha.graphics.drawEllipse(b.x, b.y, b.radius, b.radius*3
                );
                _canvasSha.graphics.endFill();
            }
            
            
            _canvasBmp.fillRect(_bound, 0xFF);
            _canvasBmp.draw( _canvasSha );
        _canvasBmp.applyFilter( _canvasBmp, _bound, _origin, _blurFilter );
            
         _output.threshold( _canvasBmp, _bound, _origin, '<', 0xe9, 0xFFffffff, 0xFF, true );
           _output.threshold( _output, _bound, _origin, '<', 0xee, 0xFF000000, 0xFF, true );
      //     _output.applyFilter( _output, _bound, _origin, _blurFilter2 );
        }
        
        private function createBalls( num:int ):void
        {
            _balls = new Vector.<Ball>();
            var b:Ball;
            for (var i:int = 0; i < num; ++i)
            {
                b = _balls[i] = new Ball();
                b.x = _bound.width * Math.random(),
                b.y = _bound.height * Math.random(),
                b.radius = 10.0 + 10.0 * Math.random();
                b.vx = 4.0 - Math.random() * 8.0;
                b.vy = 4.0 - Math.random() * 8.0;
            }
            
        }
        
    }

}

class Ball
{
    public var x:Number = 0.0;
    public var y:Number = 0.0;
    public var vx:Number = 0.0;
    public var vy:Number = 0.0;
    public var radius:Number = 0.0;
}