/**
 * Copyright phi16 ( http://wonderfl.net/user/phi16 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zCWJ
 */

// forked from mutantleg's flash on 2015-1-26
package {
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.display.BitmapData;
    import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
        
            map = new BitmapData(128,128, false, 0);
            mat = new Matrix(cw,0,0,cw);
        
            stage.addEventListener(MouseEvent.MOUSE_DOWN, onMdown);
            stage.addEventListener(MouseEvent.MOUSE_UP, onMup);
            stage.addEventListener(Event.ENTER_FRAME, onEnter);    
        }//ctor
        
        public function onMdown(e:MouseEvent):void { mdown = 1; }
        public function onMup(e:MouseEvent):void { mdown = 0; }
        
        public var mdown:int = 0;
        public var cw:Number = 8;
        public var map:BitmapData;
        public var mat:Matrix;
        public var tx:int,ty:int;
        public var bx:int,by:int;
        
        public function isWall(ax:Number, ay:Number):Boolean
        {
           var tx:int; var ty:int;
           tx = Math.floor(ax/cw);            ty = Math.floor(ay/cw);                      
           return map.getPixel(tx, ty) > 0;
        }//iswall
        
        public function onEnter(e:Event):void
        {
            graphics.clear();
            graphics.lineStyle(0,0,0);
            
            var ax:Number; var ay:Number;
            bx = tx, by = ty;
            ax = stage.mouseX; ay = stage.mouseY;
            tx = Math.floor(ax/cw);            ty = Math.floor(ay/cw);            
            ax = tx*cw;            ay = ty*cw;
                                
            var i:int; var k:int;                      
            if (mdown > 0) {
              var x0:int=tx,x1:int=bx,y0:int=ty,y1:int=by;
              var dx:int = x1-x0,dy:int = y1-y0;
              var er:Number,de:Number,xu:int,yu:int,p:int;
              if(dx==0){
                  if(dy==0){
                      map.setPixel(x0,y0,0x808080);
                  }else{
                      p=Math.abs(dy);
                      for(i=0;i<=p;i++){
                          map.setPixel(x0,(y0*i+y1*(p-i))/p,0x808080);
                      }
                  }
              }else if(Math.abs(dx)==Math.abs(dy)){
                  p=Math.abs(dy);
                  for(i=0;i<=p;i++){
                      map.setPixel((x0*i+x1*(p-i))/p,(y0*i+y1*(p-i))/p,0x808080);
                  }
              }else if(Math.abs(dx)>Math.abs(dy)){
                  if(dx<0)i=x0,x0=x1,x1=i,i=y0,y0=y1,y1=i,dx*=-1,dy*=-1;
                  er=0,de=dy/dx;
                  yu=y0;
                  for(xu=x0;xu!=x1;xu++){
                      map.setPixel(xu, yu, 0x808080); 
                      er+=de;
                      if(er>=0.5)yu++,er--;
                      if(er<=-0.5)yu--,er++;
                  }
              }else{
                  if(dy<0)i=x0,x0=x1,x1=i,i=y0,y0=y1,y1=i,dx*=-1,dy*=-1;
                  er=0,de=dx/dy;
                  xu=x0;
                  for(yu=y0;yu!=y1;yu++){
                      map.setPixel(xu, yu, 0x808080); 
                      er+=de;
                      if(er>=0.5)xu++,er--;
                      if(er<=-0.5)xu--,er++;
                  }
              }
            }
            
            graphics.beginBitmapFill(map, mat, false, false);
            graphics.drawRect(0,0,465,465);
            graphics.endFill(); 
            

            graphics.beginFill(0x404040);
            var wx:Number; var wy:Number;  var f:int;   
            for (i = 0; i < 66; i++)
            {
                wy = i * cw;
                for (k = 0; k < 66; k++)
                {
                    wx = k * cw;
                    if (isWall(wx,wy)) { continue; }
                    f = 0;
                    
                    if (isWall(wx+cw,wy)) { f|=1; }
                    if (isWall(wx-cw,wy)) { f|=2; }
                    if (isWall(wx,wy+cw)) { f|=4; }
                    if (isWall(wx,wy-cw)) { f|=8; }
                    
                    if ((f & 3) == 0) { continue; }
                    if ((f & 12) == 0) { continue; }
                    
                    
                    //if (f != 3) { continue; }
                    
                    graphics.drawRect(wx,wy,cw,cw);
                }//nextk
            }//nexti

            graphics.lineStyle(2, 0x00FF00);
            graphics.drawRect(ax,ay,cw,cw);

            
        }//onenter
        
    }//classend
}