/**
 * Copyright nicoptere ( http://wonderfl.net/user/nicoptere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zCNQ
 */

package
{
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.geom.Point;
	import shapes.shapes2D.Dot;
	import utils.GeomUtils;
	/**
	 * http://weblogs.java.net/blog/malenkov/archive/2009/02/hexagonal_tile.html
	 * https://malenkov.dev.java.net/20090226/hexagon.java
	 * 
	 * 
	 * @author Nicolas Barradeau
	 * http://en.nicoptere.net
	 */
	public class Hexagonal extends Sprite
	{
		
		static private var W:Number = 50;
		static private var R:Number = W / 2.0;
		static private var S:Number = R / Math.cos(Math.PI / 6.0);
		static private var L:Number = S / 2.0;
		static private var H:Number = S + L;

		static private var _i:int;
		static private var _j:int;

		static private var points:Vector.<Point>;

		public function Hexagonal(){}
		
		static public function distribute( size:Number = 25, width:Number = 250, height:Number = 250, jitter:Number = 0 ) :  Vector.<Point>
		{
			
			W = size;
			R = W / 2.0;
			S = R / Math.cos(Math.PI / 6.0);
			L = S / 2.0;
			H = S + L;
			
			points = new Vector.<Point>();
			
			getPoints( width, height);
			
			fRemoveDup( points );
			
			if( jitter != 0 ) jitterPoints( jitter );
			
			return points;
			
		}
		
		static private function getPoints(  width:Number = 250, height:Number = 120 ):void
		{
			var i:int = -1;
			var j:int = -1;

			var y:Number = -L;
			while (y < height)
			{
				var x:Number = i * W + R - R * j;
				while (x < width) 
				{
					points.push( 
									new Point( int(x), int(y - S) ),
									new Point( int(x + R), int(y - L) ),
									new Point( int(x + R), int(y + L) ),
									new Point( int(x), int(y + S ) ),
									new Point( int(x - R), int(y + L ) ),
									new Point( int(x - R), int(y + L ) )
									
								);
					
					
					
					var distance:Number = 0.0;
					if ((_i != i) || (_j != j)) 
					{
						var di:int = Math.abs(_i - i);
						var dj:int = Math.abs(_j - j);
						var flag:Boolean = ((_i <= i) && (_j >= j)) || ((_i >= i) && (_j <= j));
						distance = W * Number( flag ? di + dj : Math.max(di, dj));
					}
					
					x += W;
					i++;
				}
				y += H;
				j++;
				i = j / 2;
			}
		}
		
		static private function fRemoveDup(ac: Vector.<Point>) : void
		{
			var i:int, j : int;
			for (i = 0; i < ac.length; i++)
			{
				for (j = i+1; j < ac.length; j++)
				{	
					if ( ac[i].equals( ac[j] ) )
					{
						ac.splice(j, 1);
					}
				}
			}
		}
		
		static private function jitterPoints( radius:Number ):void
		{
			var rad:Number;
			var angle:Number;
			for each( var p:Point in points )
			{
				
				rad = radius * Math.random();
				angle = ( 2 * Math.PI ) * Math.random();
				p.x += rad * Math.cos(angle);
				p.y += rad * Math.sin(angle);
				
			}
		}
	}
}