/**
 * Copyright mex_takagi ( http://wonderfl.net/user/mex_takagi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zBoM
 */

// forked from mex's 【AS100本ノック】16回目：スクロール（スクローラー）
/**
 * AS100本ノック
 * 16回目のお題は「スクロール（スクローラー）」
 * あなたなりの「スクロール（スクローラー）」を表現してください。
 * 
 * iPhoneの回転UIです。んー。。
 **/
package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.filters.DropShadowFilter;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.events.TweenEvent;
    import org.libspark.betweenas3.tweens.ITween;
    import org.libspark.betweenas3.easing.Circ;
    /**
     * @author Mao Takagi
     */
    [SWF(width="465", height="465", backgroundColor="#EEEEEE")]
    public class Main extends Sprite
    {
        private var _panelW:uint;
        private var _panelH:uint;
        private var _displayW:uint;
        private var _displayH:uint;
        private var _holder:Holder;
        private var _scroll:Sprite;
        private var _mask:Sprite;
        private var _shadow:Sprite;
        private var _bg:Sprite;
        /**
         * constructor
         */
        public function Main()
        {
            _panelW = 80;
            _panelH = 80;
            _displayW = 80;
            _displayH = 320;
            setGraphics();
        }
        /**
         * setGraphics
         */
        private function setGraphics():void 
        {
            _scroll = new Sprite();
            _holder = new Holder(_displayW, _displayH, _panelW, _panelH);
            
            var dropShadowFilter:DropShadowFilter = new DropShadowFilter(0, 45, 0, 0.8, 10, 10, 1, 3, true, true);
            _mask = generateSquare();
            _shadow = generateSquare();
            _shadow.filters = [dropShadowFilter];
            _shadow.mouseEnabled = false;
            _bg = generateSquare(0xFFFFFF);
            _holder.mask = _mask;
            
            _scroll.addChild(_bg);
            _scroll.addChild(_holder);
            _scroll.addChild(_mask);
            _scroll.addChild(_shadow);
            
            _scroll.x = (stage.stageWidth - _mask.width) * 0.5;
            _scroll.y = (stage.stageHeight - _mask.height) * 0.5;
            addChild(_scroll);
            
            _holder.addListener();
        }
        /**
         * generateSquare
         * @param return Sprite
         */
        private function generateSquare(color:uint = 0):Sprite 
        {
            var square:Sprite = new Sprite();
            square.graphics.beginFill(color);
            square.graphics.drawRect(0, 0, _displayW, _displayH);
            square.graphics.endFill();
            
            return square;
        }
    }
}


import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Point;
import flash.geom.Rectangle;
import caurina.transitions.Tweener;
class Holder extends Sprite
{
    private var _container:PanelContainer;
    private var _containerH:Number;
    private var _oldY:Number;
    private var _vY:Number;
    private var _panelW:uint;
    private var _panelH:uint;
    private var _displayW:uint;
    private var _displayH:uint;
    /**
     * constructor
     * @param panelW uint
     * @param panelH uint
     */
    public function Holder(displayW:uint, displayH:uint, panelW:uint, panelH:uint)
    {
        _panelW = panelW;
        _panelH = panelH;
        _displayW = displayW;
        _displayH = displayH;
        
        _container = new PanelContainer(_panelW, _panelH);
        _container.x = (_displayW - _container.width) * 0.5;
        _containerH = _container.height - _panelH * 2;
        addChild(_container);
        
        Tweener.registerSpecialProperty("_vY", _vY_get, _vY_set);
        y = -height * 0.5;
        
        Set(5);
    }
    /**
     * _vY_get
     * @param obj
     * @param param
     * @param extra
     * @return Number
     */
    private function _vY_get(obj:Object, param:Array, extra:Object = null):Number
    {
        return _vY;
    }
    /**
     * _vY_set
     * @param obj
     * @param value
     * @param param
     * @param extra
     */
    private function _vY_set(obj:Object, value:Number, param:Array, extra:Object = null):void
    {
        _vY = value;
    }
    /**
     * addListener
     */
    public function addListener():void 
    {
        addEventListener(MouseEvent.MOUSE_DOWN, downHandler);
        addEventListener(MouseEvent.MOUSE_UP, upHandler);
    }
    /**
     * downHandler
     * @param event MouseEvnet
     */
    private function downHandler(event:MouseEvent):void 
    {
        _oldY = y;
        var rect:Rectangle = new Rectangle(x, 0, 0, -height);
        startDrag(false, rect);
        stage.addEventListener(MouseEvent.MOUSE_UP, upHandler);
        addEventListener(Event.ENTER_FRAME, enterFrameHandler);
        removeEventListener(Event.ENTER_FRAME, rollHandler);
        Tweener.removeAllTweens();
    }
    /**
     * upHandler
     * @param event MouseEvnet
     */
    private function upHandler(event:MouseEvent):void 
    {
        removeEventListener(Event.ENTER_FRAME, enterFrameHandler);
        stopDrag();
        
        y += _vY;
        Tweener.addTween(this, { _vY:0, time:1 } );
        if (!hasEventListener(Event.ENTER_FRAME)) addEventListener(Event.ENTER_FRAME, rollHandler);
    }
    /**
     * Set
     * @param id uint
     */
    private function Set(id:uint):void 
    {
        var margin:Number = (_displayH - _panelH) * 0.5;
        y = -_panelH * id + margin;
    }
    /**
     * rollHandler
     * @param event Event
     */
    private function rollHandler(event:Event):void 
    {
        if (_vY == 0)
        {
            removeEventListener(Event.ENTER_FRAME, rollHandler);
            var adjust:Number = _container.check(parent.y + _displayH * 0.5);
            Tweener.addTween(this, { y:y + adjust, time:1 } );
        }
        else
        {
            y += _vY;
            judge();
        }
    }
    /**
     * judge
     */
    private function judge():void 
    {
        if (y >= 0)
        {
            y = -_containerH * 0.5;
        }
        else if (y <= -_containerH + _displayH)
        {
            y = -_containerH * 0.5 + _displayH;
        }
    }
    /**
     * enterFrameHandler
     * @param event Event
     */
    private function enterFrameHandler(event:Event):void 
    {
        _vY = (y - _oldY) * 2;
        _oldY = y;
        judge();
    }
}


import flash.display.Sprite;
class PanelContainer extends Sprite
{
    private var _panelArray:Array;
    private var _panelW:uint;
    private var _panelH:uint;
    /**
     * constructor
     */
    public function PanelContainer(panelW:uint, panelH:uint)
    {
        _panelW = panelW;
        _panelH = panelH;
        _panelArray = new Array();
        var count:uint = 0;
        for (var i:int = 0; i < 20; i++) 
        {
            var panel:Panel = new Panel(count, _panelW, _panelH);
            panel.x = panelW * 0.5;
            panel.y = i * panelH + panelH * 0.5;
            _panelArray.push(panel);
            addChild(panel);
            count++;
            if (count == 10)
            {
                count = 0;
            }
        }
        var topPanel:Panel = new Panel(9, _panelW, _panelH);
        var bottomPanel:Panel = new Panel(0, _panelW, _panelH);
        topPanel.x = bottomPanel.x = _panelW * 0.5;
        topPanel.y = -_panelH * 0.5;
        bottomPanel.y = height + _panelH * 0.5;
        addChild(topPanel);
        addChild(bottomPanel);
    }
    /**
     * check
     * @param 
     */
    public function check(tagetY:Number):Number 
    {
        var targetID:uint = 0;
        var min:Number = 0;
        for (var i:int = 0; i < 20; i++) 
        {
            var panel:Panel = _panelArray[i];
            var point:Point = localToGlobal(new Point(panel.x, panel.y));
            
            var dist:Number = Math.abs(tagetY - point.y);
            if (i == 0)
            {
                min = dist;
            }
            else
            {
                var newMin:Number = Math.min(dist, min);
                if (newMin != min)
                {
                    min = newMin;
                    targetID = i;
                }
            }
        }
        
        var targetPanel:Panel = _panelArray[targetID];
        var targetPoint:Point = localToGlobal(new Point(targetPanel.x, targetPanel.y));
        return tagetY - targetPoint.y;
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.text.AntiAliasType;
import caurina.transitions.Tweener;
import caurina.transitions.properties.ColorShortcuts;
class Panel extends Sprite
{
    private var _panelW:uint;
    private var _panelH:uint;
    private var _id:uint;
    public function get id():uint { return _id; };
    /**
     * constructor
     * @param str String
     */
    public function Panel(id:uint, panelW:uint, panelH:uint)
    {
        ColorShortcuts.init();
        
        _id = id;
        _panelW = panelW;
        _panelH = panelH;
        
        var field:TextField = new TextField();
        var format:TextFormat = new TextFormat();
        
        graphics.beginFill(0xCCCCCC);
        graphics.drawRect(-_panelW * 0.5, -_panelH * 0.5, _panelW, _panelH);
        graphics.endFill();
        graphics.lineStyle(1, 0xFFFFFF);
        graphics.moveTo( -_panelW * 0.5, -_panelH * 0.5);
        graphics.lineTo(_panelW * 0.5, -_panelH * 0.5);
        
        format.align = "center";
        format.font = "_ゴシック";
        format.color = 0x333333;
        format.size = 50;
        
        field.selectable = false;
        field.defaultTextFormat = format;
        field.text = String(_id);
        field.width = _panelW;
        field.height = _panelH - 20;
        field.x = -_panelW * 0.5;
        field.y = -_panelH * 0.5 + 10;
        field.mouseEnabled = false;
        field.antiAliasType = AntiAliasType.ADVANCED;
        
        addChild(field);
    }
}