/**
 * Copyright yabuchany ( http://wonderfl.net/user/yabuchany )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zBB9
 */

// http://wonderfl.net/c/3abIの「VJ風にしてみた forked from: モアレっぽい感じ」を参考にBeatTimerとBetweenAS3の練習
// timerHandlerの中身の部分をBetweenAS3の練習用に変更しました。

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.net.URLRequest;
    import org.libspark.betweenas3.BetweenAS3;
    import org.libspark.betweenas3.easing.Cubic;
    import org.libspark.betweenas3.easing.Quad;
    import org.libspark.betweenas3.tweens.ITween;

    [SWF(backgroundColor = "0", frameRate = "60", width = "465", height = "465")]
         /*
     * Free Music Archive: Lee_Rosevere_-_01_-_Christmas_Eve_At_Midnight_Small_Town_Square
     * http://creativecommons.org/licenses/by-nc-nd/3.0/
     */
    public class Main extends Sprite
    {
        private var _phase:int;
        private var _gain:int;
        private var _sound:Sound;
        private var _soundChannel:SoundChannel;
        private var _beatTimer:BeatTimer;
        private var _isOnBeat:Boolean;
        private var _bpm:Number;
        private var _beatPosition:Number;
        private var _cnt:int = 0;
        private var box:Box = new Box(50,50);

        public function Main():void
        {
            addEventListener(Event.ENTER_FRAME, timerHandler);
            _beatTimer = new BeatTimer();
            _sound = new Sound();
            _sound.load(new URLRequest("http://yabuchany.com/blog/wp-content/uploads/2010/12/src/Lee_Rosevere_-_01_-_Christmas_Eve_At_Midnight_Small_Town_Square.mp3"));
            _sound.addEventListener(Event.COMPLETE, loadCompleteHandler);
            addChild(box);
        }
        private function timerHandler(e:Event):void
        {
            _cnt++;
            _beatTimer.update();
            if ((_beatTimer.beatPosition | 0) % 4 == 0) {
                if (! _isOnBeat) {
                    var itween:ITween;
                    itween = BetweenAS3.serial(
                    BetweenAS3.tween(box, {scaleX:5,scaleY:1},null,.2, Quad.easeInOut),
                    BetweenAS3.tween(box, {scaleX:5,scaleY:5},null,.2, Quad.easeInOut),
                    BetweenAS3.tween(box, {scaleX:1,scaleY:5},null,.2, Quad.easeInOut),
                    BetweenAS3.tween(box, {scaleX:1,scaleY:1},null,.2, Quad.easeInOut),
                    BetweenAS3.tween(box, {scaleX:0,scaleY:0},null,.2, Quad.easeInOut),
                    BetweenAS3.tween(box, {scaleX:1,scaleY:1},null,.001, Quad.easeInOut)
                    );
                    itween.play();


                    if (_cnt > 5) {
                        var itween1:ITween;
                        itween1=BetweenAS3.serial(
                        BetweenAS3.tween(box,{ x:Math.random()*465, y:stage.stageWidth/2 }, null, 2, Cubic.easeOut),
                        BetweenAS3.tween(box,{ x:stage.stageWidth/2, y:stage.stageWidth/2 }, null, .2, Cubic.easeOut)
                        );
                        itween1.play();
                        _cnt = 0;
                    }
                }
            } else {
                if (Math.random() > 0.5) {
                    _isOnBeat = false;
                }
            }
        }
        private function loadCompleteHandler(e:Event):void
        {
            _sound.removeEventListener(Event.COMPLETE,loadCompleteHandler);
            soundStart();
        }
        private function soundStart():void
        {
            _soundChannel = _sound.play(0);
            _beatTimer.start(120);
            _soundChannel.addEventListener(Event.SOUND_COMPLETE,soundCompleteHandler);
        }
        private function soundCompleteHandler(e:Event):void
        {
            removeEventListener(Event.ENTER_FRAME, timerHandler);
            removeEventListener(Event.SOUND_COMPLETE,soundCompleteHandler);
        }
    }

}
import flash.display.Sprite;
import flash.utils.getTimer;
class Box extends Sprite {
    public function Box(w:Number, h:Number):void
    {
        var lineColor:uint = 0xFFFFFF;
        var fillColor:uint = 0x33CCFF;
        graphics.beginFill(fillColor, .9);
        graphics.drawRect(-25, -25, w, h);
        graphics.endFill();
    }
}

class BeatTimer
{
    private var _bpm:Number;
    private var _startTime:uint;
    private var _beatPosition:Number;
    private var _phase:Number;
    private var _isOnBeat:Boolean = false;
    public function BeatTimer()
    {
        
    }
    public function get bpm():Number
    {
        return _bpm;
    }

    public function get beatPosition():Number
    {
        return _beatPosition;
    }

    public function get phase():Number
    {
        return _phase;
    }

    public function get isOnBeat():Boolean
    {
        return _isOnBeat;
    }

    public function start(bpm:Number):void
    {
        _bpm = bpm;
        _startTime = getTimer();
        update();
    }

    public function update():void
    {
        var currentTime:uint = getTimer();
        var beatInterval:Number = (60 * 1000) / _bpm;
        var oldPosition:Number = _beatPosition;

        _beatPosition = (currentTime - _startTime) / beatInterval;
        _phase = _beatPosition - int(_beatPosition);
        _isOnBeat = int(oldPosition) != int(_beatPosition);
    }
}