/**
 * Copyright rodman ( http://wonderfl.net/user/rodman )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zAu7
 */

// forked from Nekoeri88's forked from: EmitLight (4)
// Forked from ProjectNya's EmitLight (4)
////////////////////////////////////////////////////////////////////////////////
// EmitLight (4)
////////////////////////////////////////////////////////////////////////////////

package {

    import flash.display.Sprite;
    import flash.geom.Rectangle;
    import net.hires.debug.Stats;

    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="60")]

    public class Main extends Sprite {
        private var light:EmitLight;

        public function Main() {
            Wonderfl.capture_delay(5);
            init();
            addChild(new Stats());
        }

        private function init():void {
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            var rect:Rectangle = new Rectangle(0, 0, 465, 465);
            light = new EmitLight(rect);
            addChild(light);
        }

    }

}


//////////////////////////////////////////////////
// EmitLightクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.Matrix;
import flash.geom.ColorTransform;
import flash.display.BlendMode;
import flash.filters.BlurFilter;
import frocessing.color.ColorHSV;

class EmitLight extends Sprite {
    private var rect:Rectangle;
    private var bitmapData:BitmapData;
    private var bitmap:Bitmap;
    private var container:Sprite;
    private static var max:uint = 4;
    private var particles:Array;
    private var color:ColorHSV;
    private var colorTrans:ColorTransform;
    private static var blur:BlurFilter;
    private static var point:Point = new Point();
    private var id:uint = 0;
    
    private var randomx:uint = 0;
    private var randomy:uint = 0;

    public function EmitLight(r:Rectangle) {
        rect = r;
        if (stage) init();
        else addEventListener(Event.ADDED_TO_STAGE, init, false, 0, true);
    }

    private function init(evt:Event = null):void {
        removeEventListener(Event.ADDED_TO_STAGE, init);
        bitmapData = new BitmapData(rect.width, rect.height, true, 0x00000000);
        bitmap = new Bitmap(bitmapData);
        addChild(bitmap);
        container = new Sprite();
        addChild(container);
        particles = new Array();
        color = new ColorHSV(0);
        colorTrans = new ColorTransform();
        blur = new BlurFilter(8, 8, 3);
        addEventListener(Event.ENTER_FRAME, update, false, 0, true);
    }
    private function update(evt:Event):void {
        create();
        bitmapData.lock();
        for (var n:uint = 0; n < particles.length; n++) {
            var particle:Particle = particles[n];
            particle.update();
            particle.scale = particle.alpha = particle.power;
            if (particle.power < 0) {
                container.removeChild(particle);
                particles.splice(n, 1);
                particle = null;
            }
        }
        color.h = id;
        colorTrans.color = color.value;
        bitmapData.draw(container, null, colorTrans, BlendMode.SCREEN, null, true);
        bitmapData.applyFilter(bitmapData, rect, point, blur);
        bitmapData.unlock();
        id ++;
        
       
    }
    private function create():void {
        for (var n:uint = 0; n < max; n++) {
            var particle:Particle = new Particle();
            //particle.tx = randomx;
            //particle.ty = randomy;
            
            particle.tx = mouseX;
            particle.ty = mouseY;
            particle.angle = Math.random()*360;
            particle.speed = Math.random()*3 + 5;
            particle.power = 1;
            particle.setup();
            container.addChild(particle);
            particles.push(particle);
        }
    }

}


//////////////////////////////////////////////////
// Particleクラス
//////////////////////////////////////////////////

import flash.display.Shape;

class Particle extends Shape {
    private static var radius:uint = 6;
    private static var color:uint = 0xFFFFFF;
    public var angle:Number = 0;
    public var speed:Number = 0;
    public var tx:Number;
    public var ty:Number;
    private var vx:Number = 0;
    private var vy:Number = 0;
    public var power:Number = 0;
    private static var radian:Number = Math.PI/180;
    private static var friction:Number = 0.96;
    private static var deceleration:Number = 0.016;
    private static var acceleration:Number = 0.02;
    private var _scale:Number = 1;

    public function Particle() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(color);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function setup():void {
        x = tx;
        y = ty;
        vx = speed*Math.cos(angle*radian);
        vy = speed*Math.sin(angle*radian);
    }
    public function update():void {
        tx += vx;
        ty += vy;
        x += (tx - x)*acceleration;
        y += (ty - y)*acceleration;
        vx *= friction;
        vy *= friction;
        power -= deceleration;
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }

}
