/**
 * Copyright chiqui ( http://wonderfl.net/user/chiqui )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zAgy
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;

    /**
     * pure procrastination
     */
    public class Main extends Sprite 
    {
        private var ww:int;
        private var hh:int;
        
        public function Main():void {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }  

        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            ww = this.stage.stageWidth;
            hh = this.stage.stageHeight;
            this.graphics.beginFill(0x222222, 1);
            this.graphics.drawRect(0, 0, ww, hh);
            this.graphics.endFill();
            redraw();
            this.addEventListener(MouseEvent.CLICK, redraw);
            this.useHandCursor = true;
            this.buttonMode = true;
        }

        
        private function clearBooks(evt:MouseEvent = null):void {
            var numch:int = this.numChildren;
            for (var i:int = 0; i < numch; i++) {
                this.removeChildAt(0);
            }
        }
        
        private function redraw(evt:MouseEvent = null):void {
            clearBooks();
            //godraw
            var arewedoneyet:Boolean = false;
            var posx:int = 0;
            var posy:int = 70;
            var lastRot:Number = 0;
            while (!arewedoneyet) {
                var bo:book = new book();
                bo.x = posx;
                bo.y = posy;
                if (Math.random() < .2) {
                    if(Math.abs(lastRot)<2){
                        lastRot+= (Math.random() * 5) - 2.5;
                        if (bo.rotation > 0) {
                            posx += 1;
                        }else {
                            bo.x += 1;
                            posx += 1;
                        }
                    }
                }
                bo.rotation = lastRot;
                this.addChild(bo);
                posx += bo.ww;
                if (posx > ww) {
                    lastRot = 0;
                    var s:shelf = new shelf();
                    s.y = posy;
                    this.addChild(s);
                    posx = 0;
                    posy += 90;
                    if(posy > hh) arewedoneyet = true;
                }
            }
        }
    }
    
}

import flash.events.Event;

class shelf extends flash.display.Sprite {
    public var fc:uint = 0xEEEEEE;
    public var bc:uint = 0x222222;
    public function shelf() {
        this.addEventListener(Event.ADDED_TO_STAGE, onAdded);
    }

    
    private function onAdded(e:Event):void {
        removeEventListener(Event.ADDED_TO_STAGE, onAdded);
        this.graphics.lineStyle(2, bc);
        this.graphics.beginFill(fc);
        this.graphics.drawRect(0, 0, this.stage.stageWidth, 15);
        this.graphics.endFill();
    }
}

class book extends flash.display.Sprite {
    public var fc:uint = 0xEEEEEE;
    public var bc:uint = 0x222222;
    public var ww:int;
    public var hh:int;
    public function book() {
        ww = 8 + Math.random() * 10;        
        hh = 35 + Math.random() * 20;
        this.graphics.lineStyle(1, bc);
        this.graphics.beginFill(fc, 1);
        this.graphics.drawRect(0, 0, ww, -hh);
        this.graphics.endFill();
        //random label
        var lbl:flash.display.Sprite = new flash.display.Sprite();
        var labelPattern:int = Math.random() * 10;
        if(labelPattern > 1 && labelPattern < 6){
            var labelGen:int = (Math.random() * 4)-1;
            for (var i:int = 0; i < labelGen; i++) {
                lbl= new flash.display.Sprite();
                var hhLabel:int = 2+(Math.random() * (20-labelGen));
                lbl.graphics.lineStyle(1, fc)
                lbl.graphics.beginFill(bc, 1);
                lbl.graphics.drawRect(1, 1, ww-2, hhLabel);
                lbl.graphics.endFill();
                lbl.y = -hh + (Math.random() * hh - hhLabel);
                this.addChild(lbl);
            }
        }else if (labelPattern == 6) {
            var steps:int = 5+(Math.random() * 5);
            var graphicStep:int = hh / steps;
            lbl= new flash.display.Sprite();
            lbl.graphics.lineStyle(1, bc, Math.random());
            while (steps > 0) {
                steps--;
                lbl.graphics.moveTo(0, graphicStep * steps);
                lbl.graphics.lineTo(ww, graphicStep * steps);
            }
            lbl.y = -hh;
            this.addChild(lbl);
        }else if (labelPattern == 7) {
            if (Math.random() > .5) return;
            lbl= new flash.display.Sprite();
            lbl.graphics.beginFill(bc);
            var rad:int = (((ww-2) / 2) + (((ww-2) / 2) * Math.random())) / 2;
            lbl.graphics.drawCircle(ww / 2, (hh-(rad*2)) * Math.random(), rad);
            lbl.graphics.endFill();
            lbl.y = -hh+(rad*2);
            this.addChild(lbl);
        }else if (labelPattern == 8) {
            lbl= new flash.display.Sprite();
            lbl.graphics.beginFill(bc);
            var hlable:int = Math.random() * hh;
            lbl.graphics.drawRect(ww / 4, hlable / 2, ww / 2, hlable);
            lbl.y = -hh;
            this.addChild(lbl);
        }
    }
}