/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zAUP
 */

package
{ 
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class PixelCanvasExample extends Sprite
    {
        private var _pixelCanvas:PixelCanvas;
        private var _dataField:DataField;
        
        public function PixelCanvasExample() 
        {
            
            _pixelCanvas = new PixelCanvas(465, 465);
            _dataField = new DataField("Hello World!");
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        }
        
        private function addedToStageHandler(event:Event) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);   
            
            addChild(_pixelCanvas);
            addChild(_dataField);
        }
    }
}

//tracasseur.display

import flash.display.Sprite;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.events.Event;
import flash.geom.Point;
import flash.geom.Rectangle;
import flash.text.Font;
import flash.text.TextField;
import flash.text.TextFormat;

internal class PixelCanvas extends Sprite
{
    protected static var CANVAS_WIDTH:int;
    protected static var CANVAS_HEIGHT:int;
    protected static var CANVAS_COLOR:uint;
    protected static var CANVAS_ALPHA:Boolean;
    protected static var CANVAS_CLIPPING:Boolean;
    
    protected static const PIXEL_STATIC:int = 0;
    protected static const PIXEL_ACTIVE:int = 1;
    
    private var _canvas:BitmapData;
    private var _dataField:DataField;
    private var _pixelDrawBatch:Vector.<Vector.<Pixel>>;
    
    public function PixelCanvas(width:int, height:int, color:uint = 0xDCDCDC, alpha:Boolean = false, clipping:Boolean = true) 
    {
        CANVAS_WIDTH = width;
        CANVAS_HEIGHT = height;
        CANVAS_COLOR = color;
        CANVAS_ALPHA = alpha;
        CANVAS_CLIPPING = clipping;
        
        _canvas = new BitmapData(CANVAS_WIDTH, CANVAS_HEIGHT, CANVAS_ALPHA, CANVAS_COLOR);
        _dataField = new DataField();
        _pixelDrawBatch = new Vector.<*>(2);
        _pixelDrawBatch[PIXEL_STATIC] = new Vector.<Pixel>;
        _pixelDrawBatch[PIXEL_ACTIVE] = new Vector.<Pixel>;       

        addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
    }
    
    private function addedToStageHandler(event:Event) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        addEventListener(PixelEvent.COLOR_SHIFT, pixel_updateColorHandler);
        
        addChild(new Bitmap(_canvas));
        addChild(_dataField);
        
        initializeCanvas();
        //initializePixels();
    }
    
    private function initializeCanvas() :void
    {
        _canvas.lock();    
        
        _canvas.fillRect(new Rectangle(0, 0, 5, 5), 0x000000);
        
        _canvas.unlock();
    }

    
    private function initializePixels() :void
    {
        for (var $x:int = 0; $x < CANVAS_WIDTH; $x++)
        {
            for (var $y:int = 0; $y < CANVAS_HEIGHT; $y++)
            {
                _dataField.text = "Pixel: " + _pixelDrawBatch[PIXEL_ACTIVE].push(new Pixel()) as String;
            }
        }
    }
    
    protected function pixel_addedToStageHandler(event:Event) :void
    {
        var $pixel:Pixel = event.target as Pixel;   
    }
    
    protected function pixel_updateColorHandler(pixelEvent:PixelEvent) :void
    {
        var $pixel:Pixel = pixelEvent.targetPixel/*as Pixel*/;
    }

    private function enterFrameHandler(event:Event) :void
    {
    }
}

internal class Pixel
{
    public function Pixel()
    {
        
    }
}


//tracasseur.events

internal class PixelEvent extends Event
{
    public static const COLOR_SHIFT:String = "color";
    public static const FLAG_SHIFT:String = "flag";
    
    public var targetPixel:Pixel;
    
    public function PixelEvent(type:String, bubbles:Boolean = false, cancelable:Boolean = false) :void
    {
        super(type, bubbles, cancelable);
    }
}


//tracasseur.utils


class DataField extends TextField
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _data :String;
    
    public function DataField($data:String = "", $x:Number = 4, $y:Number = 2, $font:String = "Consolas")
    {
        _x = $x;
        _y = $y;
        _font = $font;
        _data = $data;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
        
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        multiline = true;
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
        
        init();
    }
        
    private function init() :void
    {
        x = _x;
        y = _y;
        text = _data;
        
        setTextFormat(new TextFormat(font, null, 0));
    }
        
    public function get font() :String
    { return _font }
    
    public function set font($:String) :void
    { _font = $; setTextFormat(new TextFormat(font, null, 0)) }
    public override function set text($:String) :void
    { super.text = $; setTextFormat(new TextFormat(font, null, 0)) }
}
/*internal class DataField extends TextField
{
    private var _x :Number;
    private var _y :Number;
    private var _font :String;
    private var _data :String;
    
    public function DataField(data:String = "", posX:Number = 4, posY:Number = 2, fontName:String = "Consolas")
    {
        _x = posX;
        _y = posY;
        _font = fontName;
        _data = data;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
    }
        
    private function addedToStageHandler($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
        
        multiline = true;
        autoSize = "left";
        selectable = false;
        mouseEnabled = false;
        
        init();
    }
        
    private function init() :void
    {
        x = _x;
        y = _y;
        text = _data;
        
        setTextFormat(new TextFormat(font, null, 0));
    }
        
    public function get font() :String
    { return _font }
    
    public function set font(fontName:String) :void
    { _font = fontName; setTextFormat(new TextFormat(font, null, 0)); }
    public override function set text(data:String) :void
    { super.text = data; setTextFormat(new TextFormat(font, null, 0)); }
}
*/