/**
 * Copyright 9re ( http://wonderfl.net/user/9re )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zA0Y
 */

// forked from aobyrne's Using WonderflApi By User Simple
package
{
    import com.adobe.serialization.json.JSON;
    import flash.display.Bitmap;
    import flash.display.Loader;
     import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    import net.wonderfl.data.APIUserCodesData;
    import net.wonderfl.data.SmallCodeData;
    import net.wonderfl.utils.WonderflAPI;
    public class UsingWonderflApiByUserSimple extends Sprite
    {
        private var apiParameters:Object={};
        private var wonderflDataLoader:URLLoader;
        static public const OPEN_API_KEY:String = "a76b80051993a7c6322bf8b4bbc457b44c3d4f5c";
        static private var console:Console;
        private var aPIUserCodesData:APIUserCodesData;
        private var imageLoader:ImageLoader;
        public function UsingWonderflApiByUserSimple() 
        {
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            console = new Console(this);
            apiParameters["open_api_key"] = OPEN_API_KEY;
            var wonderflAPI:WonderflAPI = new WonderflAPI(apiParameters);
            var a:URLRequest = wonderflAPI.apiUserCodes('aobyrne');
            var loader:Loader = new Loader();
            wonderflDataLoader = new URLLoader();
            wonderflDataLoader.addEventListener(Event.COMPLETE, onWonderflDataRecieved );//wonderflDataCompleteByCode,wonderflDataCompleteByUser
            wonderflDataLoader.load(a);
        }
        private function cTrace(msg:String):void 
        {
            traceIt(msg);
        }
        static public function traceIt(msg:String):void 
        {
            console.traceThis(msg)
            
        }
        
        private function onWonderflDataRecieved(e:Event):void 
        {
            var rawData:Object = JSON.decode(URLLoader(e.target).data);
            cTrace( "e.target : " + e.target );
            cTrace( "Trace.traceObject(rawData) : " + Trace.traceObject(rawData) );
            aPIUserCodesData = new APIUserCodesData(rawData);
            cTrace( "Trace.traceObject(aPIUserCodesData ) : " + Trace.traceObject(aPIUserCodesData ) );
            imageLoader = new ImageLoader();
            imageLoader.signal.add(imagesLoaded);
            imageLoader.base_url = '';
            var p:Array = imageLoader.preloadList;
            p.length = 0;
            var c:Vector.<SmallCodeData> = aPIUserCodesData.codes;
            var l:int = c.length;
            var item:SmallCodeData;
            for (var i:int = 0; i < l; i++) 
            {
                item = SmallCodeData(c[i]);
                p[p.length] = {name:item.title,src:item.thumbnail};
            }
            imageLoader.destroy();
            imageLoader.preload();//imagesLoaded
        }
        private function imagesLoaded():void 
        {
            cTrace( "imagesLoaded : "  );
            var imgs:Vector.<Bitmap> = imageLoader.images;
            var item:Bitmap;
            for (var i:int = 0; i < imgs.length; i++) 
            {
                item = imgs[i];
                addChild(item);
                item.x = i % 5 * 100;
                item.y = uint(i / 5) * 100;
            }
            cTrace( "imgs : " + imgs );
            var c:Vector.<SmallCodeData> = aPIUserCodesData.codes;
        }
    }
}
import com.bit101.components.PushButton;
import com.bit101.components.TextArea;
import com.bit101.components.VBox;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.display.Stage;
import flash.events.Event;
import flash.events.KeyboardEvent;
import flash.net.URLRequest;
import flash.system.ApplicationDomain;
import flash.system.LoaderContext;
import flash.system.SecurityDomain;
import flash.text.TextField;
import flash.ui.Keyboard;
import flash.utils.describeType;
import idv.cjcat.signals.ISignal;
import idv.cjcat.signals.Signal;
class Trace 
{
    static private const SEPARATOR:String = "\n";
    static private const VALUE_SEPARATOR:String = ":";
    
    public function Trace() 
    {
        
    }
    
    /**
     * http://www.learnosity.com/techblog/index.cfm/2008/2/6/AS3--Looping-over-properties-of-a-class
     * @param    objArg
     * @return
     */
    public static function traceObject(objArg:Object,separator:String="",valueSeparator:String=""):String 
    {
        separator = separator == ""?SEPARATOR:separator;
        valueSeparator = valueSeparator == ""?VALUE_SEPARATOR:valueSeparator;
        //trace( "objArg : " + objArg );
        var def : XML = describeType(objArg);
        //trace( "def : " + def );
        var output:String = "";
        //Crazy:::::
        var properties : XMLList = def..variable.@name + def..accessor.@name;
        var number:int = 0;
        //trace("accesors and variables:");
        var p:String;
        for each ( var property : String in properties ) 
        {
            p = property + valueSeparator+" " + objArg[property];
            //trace(++number + "." + p);
            output += separator + p;
        }
        
        return output;
    }
    
    public static function traceMethods(objArg:Object):void 
    {
        var v:XMLList = describeType(objArg)..method;
        var name:String;
        var returnType:String;
        trace("methods:");
        var method:Function;
        var value:*;
        for (var j:int = 0; j < v.length(); j++) 
        {
            name = v[j].@name;
            returnType = v[j].@returnType;
            method = objArg[name];
            if (returnType!='void') 
            {
                
                value = method();
            }
            else
            {
                value = "void";
            }
            
            trace((j+1)+"."+name +" : " + value);
            
        }
    }
    
}
class Console extends VBox
{
    private var _textField:TextField;
    private var _msprite:Sprite;
    public function Console(msprite:Sprite) 
    {
        super();
        _msprite = msprite;
        _msprite.addChild(this);
        addChildAt(new PushButton(null, 0, 0, "clear", doClear), numChildren);;
        var textArea:TextArea = TextArea(addChildAt(new TextArea(), numChildren));
        _textField = textArea.textField
        x = 465;
        stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDownHandler);
        textArea.setSize(465, 430);
        var sCKeyBoard:SCKeyBoard = new SCKeyBoard(stage);
        sCKeyBoard.keyAndFunction =
        {
            Q:setDebuggerVisibility,
            A:setDebuggerAlpha,
            C:clear
        }
    }
    
    private function clear():void 
    {
        _textField.text = "";
    }
    
    private function setDebuggerAlpha():void 
    {
        const debuggerAlpha:Number = 0.5;
        alpha = alpha == debuggerAlpha?1:debuggerAlpha;
    }
    
    private function setDebuggerVisibility():void 
    {
        visible = !visible;
    }
    
    private function onKeyDownHandler(e:KeyboardEvent):void 
    {
        switch (e.keyCode) 
        {
            case Keyboard.UP:
                _textField.scrollV -= 10;
            break;
            case Keyboard.DOWN:
                _textField.scrollV += 10;
            break;
            default:
                
            break;
        }
    }
    
    private function doClear(e:Event):void 
    {
        _textField.text = "";
    }
    
    public function get textField():TextField 
    {
        return _textField;
    }
    
    public function set textField(value:TextField):void 
    {
        _textField = value;
    }
    
    public function traceThis(msg:String):void 
    {
        _textField.appendText(msg + "\n");
        _textField.scrollV = textField.maxScrollV;
        
    }
}
class SCKeyBoard
{
    private var _stage:Stage;
    private var object:Object;
    public var keyAndFunction:Object;
    
    public function SCKeyBoard(stageArg:Stage) 
    {
        _stage = stageArg;
        _stage.addEventListener(KeyboardEvent.KEY_DOWN, keyDownHandler);
    }
    
    public function removeKey(key:String):void 
    {
        var k:Object = keyAndFunction;
        for (var name:String in k) 
        {
            if (name==key) 
            {
                trace( "(name==key) : " + (name==key) );
                k[name] = null;
                break;
            }
        }
    }
    
    public function addKeyAndFunction(key:String,callBack:Function):void 
    {
        keyAndFunction[key] = callBack;
    }
    
    private function keyDownHandler(e:KeyboardEvent):void 
    {
        if (!keyAndFunction) 
        {
            throw new Error("keyAndFunction should be defined");
        }
        var callBack:Function;
        if (keyAndFunction[String.fromCharCode(e.keyCode)]) 
        {
            trace( "keyAndFunction[String.fromCharCode(e.keyCode)] : " + keyAndFunction[String.fromCharCode(e.keyCode)] );
            callBack = keyAndFunction[String.fromCharCode(e.keyCode)]
            callBack();
        }
    }
    
    
}
class ImageLoader
{
    private var loader : Loader = new Loader();
    private var currentlyLoading : Object;
    private var layers : Vector.<BitmapData> = Vector.<BitmapData>([]);
    private var context:LoaderContext;
    
    public var base_url : String = "../assets/";
    public var preloadList : Array = [];
    public var images:Vector.<Bitmap> = Vector.<Bitmap>([]);
    public var signal:ISignal;
    public var columnsAmount:Number;
    
    public function ImageLoader() 
    {
        context = new LoaderContext();
        context.checkPolicyFile = false;
        //context.applicationDomain = ApplicationDomain.currentDomain;
        //context.securityDomain = SecurityDomain.currentDomain;        
        signal = new Signal();
        columnsAmount = 5;
    }
    
    public function preload() : void 
    {
        if (preloadList.length == 0) {
            proceed();
        } else {
            loadNext();
        }
    }
    
    private function proceed():void 
    {
        trace( "ImageLoader.proceed" );
        signal.dispatch();
    }

    private function loadNext() : void 
    {
        currentlyLoading = preloadList.shift();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function _hack(e:Event):void {
            loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, _hack);
            
            var prevLoader:Loader = loader;
            var ldr:Loader = new Loader;
            ldr.contentLoaderInfo.addEventListener(Event.COMPLETE, onLoad);
            
            loader = ldr;
            ldr.loadBytes(prevLoader.contentLoaderInfo.bytes);
        });

        loader.load(new URLRequest(currentlyLoading.src), context);
    }
    
    private function cTrace(arg1:String):void 
    {
        UsingWonderflApiByUserSimple.traceIt(arg1);
    }
    
    private function onLoad(event : Event) : void
    {
        loader.contentLoaderInfo.removeEventListener(Event.COMPLETE, onLoad);
        images[images.length] = Bitmap(event.target.content);
        layers[layers.length] = Bitmap(event.target.content).bitmapData;

        currentlyLoading = null;

        preload();
    }
    
    public function addTo(sprite:Sprite):void 
    {
        var i:Vector.<Bitmap> = images;
        sprite = Sprite(sprite.addChild(new Sprite));
        sprite.scaleX = sprite.scaleY = 0.9;
        for (var j:int = 0; j < i.length; j++) 
        {
            var item:Bitmap = i[j];
            item.x= (j%columnsAmount) * 105;
            item.y = Math.floor(j/columnsAmount) * 105;
            sprite.addChild(item);
            
        }
    }
    
    public function destroy():void 
    {
        var i:Vector.<Bitmap> = images;
        /*
        for (var j:int = 0; j < i.length; j++) 
        {
            var item:Bitmap = i[j];
            item.parent.removeChild(item);
        }
        */
        images.length = 0;
    }
}
