/**
 * Copyright arere ( http://wonderfl.net/user/arere )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z9mN
 */

// forked from arere's forked from: forked from: forked from: forked from: forked from: forked from: forked from: forked from: RGBCube for AS3
// forked from arere's forked from: forked from: forked from: forked from: forked from: forked from: forked from: RGBCube for AS3
// forked from arere's forked from: forked from: forked from: forked from: forked from: forked from: RGBCube for AS3
// forked from arere's forked from: forked from: forked from: forked from: forked from: RGBCube for AS3
// forked from arere's forked from: forked from: forked from: forked from: RGBCube for AS3
// forked from arere's forked from: forked from: forked from: RGBCube for AS3
// forked from arere's forked from: forked from: RGBCube for AS3
// forked from kotobuki's forked from: RGBCube for AS3
// forked from kotobuki's RGBCube for AS3
package {
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.display.BitmapData;
    import mx.core.BitmapAsset;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;


    import funnel.*;

    [SWF(backgroundColor="0x808080")]

    public class MeasuringTheTilt_Accelerometer extends BasicView {
        // 球
        
        private var sphere:Sphere;
        private const URL_OF_IMG_FILE:String = "http://veimages.gsfc.nasa.gov/1438/earth_lights.gif";
        [Embed(source="URL_OF_IMG_FILE")]
        
        private var fioSystem:Fio;
        private var fio:IOModule;

        // 加速度センサのx軸を接続したアナログピン
        private var xAxisPin:Pin;

        // 加速度センサのy軸を接続したアナログピン
        private var yAxisPin:Pin;
    
        public function MeasuringTheTilt_Accelerometer() {
            var config:Configuration = Fio.FIRMATA;

            // 必要ないアナログ入力をすべて出力にセットする
            // これによりデータの転送量が少なくなりレスポンスが良くなる
            // （ArduinoではA0、A1…はD14、D15に対応する）
            config.setDigitalPinMode(17, OUT);    // A3
            config.setDigitalPinMode(18, OUT);    // A4
            config.setDigitalPinMode(19, OUT);    // A5
            config.setDigitalPinMode(20, OUT);    // A6
            config.setDigitalPinMode(21, OUT);    // A7
            fioSystem = new Fio([1], config);
            fio = fioSystem.ioModule(1);

            xAxisPin = fio.analogPin(0);
            yAxisPin = fio.analogPin(1);

            // 2つの軸のそれぞれにフィルタをセット
            // ・細かな変動を取り除くための移動平均フィルタ
            // ・-1Gから1Gまでの変化を-1から1までにスケーリングするためのフィルタ
            xAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            xAxisPin.addFilter(new Scaler(0.30, 0.70, -1, 1));
            yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            yAxisPin.addFilter(new Scaler(0.30, 0.70, -1, 1));



            // 球体のインスタンスを生成
            var bmasset:BitmapAsset = new URL_OF_IMG_FILE();
			var bitmapMat:BitmapMaterial = new BitmapMate
            sphere = new Sphere(bitmapMat,100,24,24);
            scene.addChild(sphere);

            // カメラをセット
            camera.x = 0;
            camera.y = 0;
            camera.z = -500;
            camera.focus = 500;
            camera.zoom = 1;

            // レンダリング開始
            startRendering();
        }

        override protected function onRenderTick(event:Event = null):void {
            // 球体の角度をセット
            sphere.rotationZ = Math.asin(yAxisPin.value) / Math.PI * 180;;
            sphere.rotationX = Math.asin(xAxisPin.value) / Math.PI * 180;;

            // シーンをレンダリング
            renderer.renderScene(scene, camera, viewport);
        }
    }
}