/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z98N
 */

package {
    import flash.display.BitmapData;
    import flash.display.GradientType;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;
    import flash.geom.Vector3D;
    
    public class FlashTest extends Sprite {
        
        public static const W:int = 465;
        public static const H:int = 465;
        public static const R:int = 250;
        public static const MAX:int = 300;
        public static const SPEED:Number = 2;
        public static const COLOR:uint = 0xDACB94;
        
        private var __particles:Vector.<Particle> = new Vector.<Particle>();
        private var __sContainer:Shape = new Shape;
        
        public function FlashTest() {
            __initBg();
            __initParticles();
            addChild(__sContainer);
            addEventListener(Event.ENTER_FRAME, render);            
        }
        
        public function render(e:Event=null):void {
            __sContainer.graphics.clear();
            var p:Particle;
            var tx:Number, ty:Number, pos:Vector3D;
            var aTemp:Array = [];
            
            for each(p in __particles) {
                p.matrix.appendRotation(SPEED, Vector3D.Y_AXIS);
                p.matrix.appendRotation(SPEED*.25, Vector3D.X_AXIS);
                p.matrix.appendRotation(SPEED*.5, Vector3D.Z_AXIS);
                aTemp.push(p);
            }
            
            var mtx:Matrix = new Matrix;
            var length:Number = 0;
            var color:uint;
            aTemp.sortOn("z",Array.NUMERIC | Array.DESCENDING);
            var i:int = 0;
            for(i=0; i<aTemp.length; i++) {
                p = aTemp[i];
                pos = p.matrix.position;
                mtx.identity();
                length = getLength(pos.z);
                color = getCircleColor(p.color, pos);
                
                __sContainer.graphics.beginFill(color, 1);
                __sContainer.graphics.drawCircle(pos.x + W * .5, pos.y + H * .5, length);
                __sContainer.graphics.endFill();
            }
        }
        
        public function getCircleColor(color:uint, pos:Vector3D):uint {
            const BRIGHTNESS:Number = 1.5;
            const BRIGHTNESS_OFFSET:Number = .3;
            var ctOffset:Number = Math.sqrt(Math.pow(pos.x, 2) + Math.pow(pos.y, 2)+Math.pow(pos.z, 2))/R;
            return brightnessColor(color, (1-ctOffset)*BRIGHTNESS + BRIGHTNESS_OFFSET);
        }
        
        public function getLength(depth:Number):Number {
            const r:Number = 20;
            var sizeOffset:Number = Math.pow((1-(depth+R)/(2*R)) * .8 + .4 , 3);
            return Math.floor(r*sizeOffset * 100) / 100;
        }
        
        private function __initParticles():void {
            var i:int = 0;
            
            for(i=0; i<MAX; i++) {
                var p:Particle = new Particle();
                p.matrix.identity();
                p.matrix.appendTranslation(Math.random() * R, 0, 0);
                p.matrix.appendRotation(Math.random() * 360, Vector3D.X_AXIS);
                p.matrix.appendRotation(Math.random() * 360, Vector3D.Y_AXIS);
                p.matrix.appendRotation(Math.random() * 360, Vector3D.Z_AXIS);
                p.color = COLOR;
                __particles.push(p);
            }
        }
        
        public static function brightnessColor(color:uint, level:Number):uint
        {
            var a:uint = color >> 24 & 0xff;
            var r:uint = color >> 16 & 0xff;
            var g:uint = color >> 8 & 0xff;
            var b:uint = color &0xff;
            
            r *= level;
            g *= level;
            b *= level;
            
            if(r>0xff) r = 0xff;
            if(g>0xff) g = 0xff;
            if(b>0xff) b = 0xff;
            
            var newColor:uint = a << 24 || r << 16 | g << 8 | b;
            return newColor;
        }
        
        private function __initBg():void {
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(W, W);
            graphics.beginGradientFill(GradientType.RADIAL, [0x1e1506, 0x000000], [1, 1], [100, 255], mtx);
            graphics.drawRect(0, 0, W, W);
            graphics.endFill();
        }
    }
}

import flash.geom.Matrix3D;

class Particle {
    public var matrix:Matrix3D = new Matrix3D;
    public var color:uint;
    
    public function get z():Number {
        return matrix.position.z;
    }

}
