/**
 * Copyright hibibi ( http://wonderfl.net/user/hibibi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z8zf
 */

//ドット絵間違ってるけど・・・

package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import gs.easing.Back;
	import gs.TweenMax;
	import org.papervision3d.cameras.Camera3D;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.render.BasicRenderEngine;
	import org.papervision3d.scenes.Scene3D;
	import org.papervision3d.view.Viewport3D;
	import org.papervision3d.materials.ColorMaterial;
	
	public class Mario3D extends Sprite{
		/**
		 * 色のデータ
		 */
		private const COLORS:Array = [
			0x33CCFF,//0:背景
			0xFF3300,//1:マリオの服の色
			0x855814,//2:マリオの毛とか肌着の色
			0xFF9933,//3:マリオの肌とかボタンの色
		];
		/**
		 * ドットのデータ
		 */
		private const POSES:Array = [
			//マリオ
			[
				[0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0],
				[0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0],
				[0,0,0,0,2,2,2,3,3,2,3,0,0,0,0,0],
				[0,0,0,2,3,2,3,3,3,2,3,3,3,0,0,0],
				[0,0,0,2,3,2,2,3,3,3,2,3,3,3,0,0],
				[0,0,0,2,2,3,3,3,3,2,2,2,2,0,0,0],
				[0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0],
				[0,0,0,0,2,2,1,2,2,2,0,0,0,0,0,0],
				[0,0,0,2,2,2,1,2,2,1,2,2,2,0,0,0],
				[0,0,2,2,2,2,1,1,1,1,2,2,2,2,0,0],
				[0,0,3,3,2,1,3,1,1,3,1,2,3,3,0,0],
				[0,0,3,3,3,1,1,1,1,1,1,3,3,3,0,0],
				[0,0,3,3,1,1,1,1,1,1,1,1,3,3,0,0],
				[0,0,0,0,1,1,1,0,0,1,1,1,0,0,0,0],
				[0,0,0,2,2,2,0,0,0,0,2,2,2,0,0,0],
				[0,0,2,2,2,2,0,0,0,0,2,2,2,2,0,0]
			],
			//敵に当たったマリオ
			[
				[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],
				[0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0],
				[0,0,0,3,0,1,1,1,1,1,1,0,3,0,0,0],
				[0,3,3,3,2,3,2,3,3,2,3,2,3,3,3,0],
				[0,3,3,2,2,3,2,3,3,2,3,2,2,3,3,0],
				[0,3,3,2,2,2,3,3,3,3,2,2,2,3,3,0],
				[0,0,0,2,2,2,2,3,3,2,2,2,2,0,0,0],
				[0,0,0,0,2,3,2,2,2,2,3,2,0,0,0,0],
				[0,0,0,0,2,3,3,3,3,3,3,2,0,0,0,0],
				[0,0,0,1,1,1,3,3,3,3,1,1,1,0,0,0],
				[0,0,2,2,1,1,2,2,2,2,1,1,2,2,0,0],
				[0,0,2,2,2,1,1,2,2,1,1,2,2,2,0,0],
				[0,0,2,2,2,1,3,1,1,3,1,2,2,2,0,0],
				[0,0,2,2,2,1,1,1,1,1,1,2,2,2,0,0],
				[0,0,0,2,2,1,1,1,1,1,1,2,2,0,0,0],
				[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
			],
			//ポールにつかまるマリオ
			[
				[0,0,0,0,1,1,1,1,1,0,0,0,0,0,0,0],
				[0,0,0,1,1,1,1,1,1,1,1,1,0,0,0,0],
				[0,0,0,2,2,2,3,3,2,3,0,0,0,0,0,0],
				[0,0,2,3,2,3,3,3,2,3,3,3,0,0,0,0],
				[0,0,2,3,2,2,3,3,3,2,3,3,3,0,0,0],
				[0,0,2,2,3,3,3,3,2,2,2,2,0,0,0,0],
				[0,0,0,0,3,3,3,3,3,3,3,0,0,0,0,0],
				[0,0,0,0,1,1,2,2,2,2,2,3,3,0,0,0],
				[0,0,0,1,1,2,2,2,2,2,2,3,3,3,0,0],
				[0,0,1,1,1,2,2,2,2,2,2,3,3,3,0,0],
				[0,0,1,1,1,1,1,3,1,0,0,0,0,0,0,0],
				[0,0,1,1,1,1,1,1,1,0,0,0,0,2,0,0],
				[0,0,1,1,1,1,1,1,1,1,1,1,2,2,0,0],
				[0,0,0,1,1,1,1,1,1,1,1,1,2,2,0,0],
				[0,0,0,0,1,1,1,1,1,1,1,1,2,2,0,0],
				[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
			],
			//急な方向転換したときマリオ
			[
				[0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0],
				[0,0,0,2,1,1,1,1,1,1,1,1,1,0,0,0],
				[0,0,2,2,2,2,2,2,3,3,2,3,0,0,0,0],
				[0,3,3,2,3,3,2,3,3,3,3,3,3,3,0,0],
				[0,3,3,2,3,3,2,2,3,3,2,2,2,3,3,0],
				[0,0,3,3,2,3,3,3,3,3,3,3,2,2,0,0],
				[0,0,0,1,1,1,2,2,2,2,1,3,3,0,0,0],
				[0,0,1,1,3,3,3,2,1,1,1,2,2,2,0,0],
				[0,0,1,2,3,3,3,2,2,2,2,2,2,2,0,0],
				[0,0,1,1,1,3,3,2,2,2,2,2,2,2,0,0],
				[0,0,0,1,1,1,1,1,2,2,2,2,2,0,0,0],
				[0,0,0,1,2,2,2,1,1,1,1,1,0,0,0,0],
				[0,0,0,0,2,2,2,2,1,1,1,1,0,0,0,0],
				[0,2,0,2,1,1,1,2,2,1,1,0,0,0,0,0],
				[0,2,2,2,2,2,2,1,0,0,0,0,0,0,0,0],
				[0,0,2,2,2,2,2,0,0,0,0,0,0,0,0,0]
			],
			//歩いてるマリオ
			[
				[0,0,0,0,0,1,1,1,1,1,0,0,0,0,0,0],
				[0,0,0,0,1,1,1,1,1,1,1,1,1,0,0,0],
				[0,0,0,0,2,2,2,3,3,2,3,0,0,0,0,0],
				[0,0,0,2,3,2,3,3,3,2,3,3,3,0,0,0],
				[0,0,0,2,3,2,2,3,3,3,2,3,3,3,0,0],
				[0,0,0,2,2,3,3,3,3,2,2,2,2,0,0,0],
				[0,0,0,0,0,3,3,3,3,3,3,3,0,0,0,0],
				[0,0,2,2,2,2,1,1,2,2,0,0,0,0,0,0],
				[3,3,2,2,2,2,1,1,1,2,2,2,3,3,3,0],
				[3,3,3,0,2,2,1,3,1,1,1,2,2,3,3,0],
				[3,3,0,0,1,1,1,1,1,1,1,0,0,2,0,0],
				[0,0,0,1,1,1,1,1,1,1,1,1,2,2,0,0],
				[0,0,1,1,1,1,1,1,1,1,1,1,2,2,0,0],
				[0,2,2,1,1,1,0,0,0,1,1,1,2,2,0,0],
				[0,2,2,2,0,0,0,0,0,0,0,0,0,0,0,0],
				[0,0,2,2,2,0,0,0,0,0,0,0,0,0,0,0]
			],
			//ジャンプしてるマリオ
			[
				[0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3],
				[0,0,0,0,0,0,1,1,1,1,1,0,0,3,3,3],
				[0,0,0,0,0,1,1,1,1,1,1,1,1,1,3,3],
				[0,0,0,0,0,2,2,2,3,3,2,3,0,2,2,2],
				[0,0,0,0,2,3,2,3,3,3,2,3,3,2,2,2],
				[0,0,0,0,2,3,2,2,3,3,3,2,3,3,3,2],
				[0,0,0,0,2,2,3,3,3,3,2,2,2,2,2,0],
				[0,0,0,0,0,0,3,3,3,3,3,3,3,2,0,0],
				[0,0,2,2,2,2,2,1,2,2,2,1,2,0,0,0],
				[0,2,2,2,2,2,2,2,1,2,2,2,1,0,0,2],
				[3,3,2,2,2,2,2,2,1,1,1,1,1,0,0,2],
				[3,3,3,0,1,1,2,1,1,3,1,1,3,1,2,2],
				[0,3,0,2,1,1,1,1,1,1,1,1,1,1,2,2],
				[0,0,2,2,2,1,1,1,1,1,1,1,1,1,2,2],
				[0,2,2,2,1,1,1,1,1,1,1,0,0,0,0,0],
				[0,2,0,0,1,1,1,1,0,0,0,0,0,0,0,0]
			]
		];
		
		private const FACES:Array = ["front", "back", "left", "right", "top", "bottom"];
		private const ROT:Array = [{x:0,y:0,z:0},{x:90,y:0,z:0},{x:180,y:0,z:0},{x:-90,y:0,z:0},{x:0,y:90,z:0},{x:0,y:180,z:0}]
		
		private const AREA_W:int = 450;
		private const AREA_H:int = 450;
		private const SEG:int = 1;
		private const CUBE_SIZE:int = 30;
		
		private var _vp3d:Viewport3D;
		private var _scene:Scene3D;
		private var _camera:Camera3D;
		private var _render:BasicRenderEngine;
		private var _cameraTarg:DisplayObject3D;
		
		private var _count:int = 0;
		
		private var _cubeList:/*Cube*/Array = [];
		
		/**
		 * コンストラクタ
		 */
		public function Mario3D() {
			this.addEventListener(Event.ADDED_TO_STAGE, this._init);
		}
		
		private function _init(e:Event):void {
			
			
			//PV3Dの設定
			this._vp3d = new Viewport3D(AREA_W, AREA_H, true, false);			this._vp3d.opaqueBackground = 0xFFFFFF;
			this._vp3d.buttonMode = true;
			this._vp3d.addEventListener(MouseEvent.CLICK, _clickHandler);
			this.addChild(this._vp3d);
			this._scene = new Scene3D();
			this._camera = new Camera3D();
			this._render = new BasicRenderEngine();
			
			this._cameraTarg = new DisplayObject3D();
			this._scene.addChild(this._cameraTarg);
			
			stage.addEventListener(MouseEvent.CLICK, _clickHandler);
			
			//データの形成（一回まわしてデータ作り直してるけど、他になんかいい方法あるのかな？）
			var dataList:Array = [];
			var i:int;
			var j:int;
			var k:int;
			
			
			for (i = 0; i < POSES.length; i++) {
				var arr:Array = POSES[i];
				var n:int = 0;
				for (j = 0; j < arr.length; j++) {
					var arr1:Array = arr[j];
					for (k = 0; k < arr1.length; k++) {
						if (i == 0) {
							var data:CubeData = new CubeData();
							data.x = k - (arr1.length / 2);
							data.y = j - (arr.length / 2);
							//data.matlist.addMaterial(new ColorMaterial(COLORS[arr1[k]]),FACES[i]);
							dataList.push(data);
						}else {
							
						}
						dataList[n].matlist.addMaterial(new ColorMaterial(COLORS[arr1[k]]),FACES[i]);
						n++;
					}
				}
			}
			//this._createCubes();
			//Cubeをつくる
			for (i = 0; i < dataList.length; i++) {
				var cube:Cube = new Cube(dataList[i].matlist, CUBE_SIZE, CUBE_SIZE, CUBE_SIZE, SEG, SEG, SEG);
				cube.x = dataList[i].x * CUBE_SIZE;
				cube.y = -dataList[i].y * CUBE_SIZE;
				cube.extra = new Object();
				cube.extra.data = dataList[i];
				this._cubeList.push(cube);
				this._scene.addChild(cube);
			}
			this._update();
			this._rendering();
		}
		/**
		 * Cubeうごかす
		 */
		private function _changeCubeFace(num:int):void {
			var len:int = this._cubeList.length;
			while (len--) {
				TweenMax.to(this._cubeList[len], 3, {
						bezier:[ { x:Math.random() * 3000 - 1500, y:Math.random() * 3000 - 1500, z:Math.random() * 3000 - 1500 }, { x:this._cubeList[len].extra.data.x*CUBE_SIZE, y:-this._cubeList[len].extra.data.y*CUBE_SIZE, z:0 } ]
						,rotationX:ROT[num].x
						,rotationY:ROT[num].y
						,rotationZ:ROT[num].z
						,ease:Back.easeOut
					}
				)
			}
		}
		
		private function _rendering():void {
			this._render.renderScene(this._scene, this._camera, this._vp3d);
		}
		
		private function _update(e:Event = null):void {
			//this._cameraTarg.rotationY += .5;
			//this._camera.copyTransform(this._cameraTarg);
			//this._camera.moveBackward(1000);
			this._rendering();
		}
		
		private function _clickHandler(e:MouseEvent):void {
			if (!this.hasEventListener(Event.ENTER_FRAME)) {
				this.addEventListener(Event.ENTER_FRAME, _update);
			}
			this._count = (this._count + 1) % 6;
			this._changeCubeFace(this._count);
		}
	}
}

import org.papervision3d.materials.utils.MaterialsList;
internal class CubeData {
	public var x:Number;
	public var y:Number;
	public var matlist:MaterialsList = new MaterialsList();
	public function CubeData() {}
}
