/**
 * Copyright aass ( http://wonderfl.net/user/aass )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z8D8
 */

// forked from soundkitchen's sample 6
package
{
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.ColorShortcuts;

    [SWF(width=465, height=465, frameRate=30, backgroundColor=0xFFFFFF)]

    public class Sample extends Sprite
    {
        public static const BALL_RADIUS:uint = 10;
        public static const BALL_MARGIN:uint = 10;

        public function Sample()
        {
            //  ColorShortcuts を有効化
            ColorShortcuts.init();

            //  ball の横と横の個数を計算
            var l:uint = Math.ceil(stage.stageWidth / (BALL_RADIUS * 2 + BALL_MARGIN));
            var m:uint = Math.ceil(stage.stageHeight / (BALL_RADIUS * 2 + BALL_MARGIN));

            for (var i:int=0; i<l; i++)
            {
                for (var j:int=0; j<m; j++)
                {
                    //  ball を作成
                    var ball:Sprite = new Sprite();
                    ball.x = i * (BALL_RADIUS * 2 + BALL_MARGIN) + (BALL_RADIUS + BALL_MARGIN);
                    ball.y = j * (BALL_RADIUS * 2 + BALL_MARGIN) + (BALL_RADIUS + BALL_MARGIN);
                    ball.alpha = .5;
                    ball.blendMode = BlendMode.HARDLIGHT;
                    ball.graphics.beginFill(0xFFFFFF);
                    ball.graphics.drawCircle(0, 0, BALL_RADIUS);
                    ball.graphics.endFill();

                    addChild(ball);

                    changeColor(ball);
                }
            }
        }

        private function changeColor(ball:Sprite):void
        {
            //  ランダムで色とスケールを指定
            var color:uint = Math.random() * 255 << 16 | Math.random() * 255 << 8 | Math.random() * 255 << 0;
            var scale:Number = Math.random() * 3;

            Tweener.addTween(ball, {
                scaleX: scale,
                scaleY: scale,
                _color: color,
                time: Math.random() * 4 + 1,
                delay: Math.random() * 1 + 1,
                transition: "easeInOutSine",
                onComplete: changeColor,
                onCompleteParams: [ball]
            });
        }
    }
}
