/**
 * Copyright JM-DG ( http://wonderfl.net/user/JM-DG )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z762
 */

//--------------------------
// Mac Slider 1.1 By: JM-DG 
// Created: 14/11/2011
// Modified: 14/11/2011
//--------------------------

package{
    import flash.display.Sprite;
    import flash.events.Event;
     import com.bit101.components.PushButton;
    
    public class Main extends Sprite{
        private var slider1:Slider;
        private var slider2:Slider;
        private var slider3:Slider;
        private var slider4:Slider;
         
        public function Main(){
            /* new Slider(
            Parent,
            X position,
            Y position,
            Width,
            Height,
            Label before slider,
            Suffix placed after value slider,
            Show the slider's value,
            Show the filler,
            Minimum,
            Maximum,
            Initial value) */
            
            this.slider1 = new Slider(this, 100, 80, 100, 10,"Test1"," BPM", true, true, 10, 150, 50);
            this.slider2 = new Slider(this, 100, 130, 200, 50,"Test2","", true, true, 20, 80, 40);
            this.slider3 = new Slider(this, 100, 230, 300, 10,"Test3"," BPM", true, true, 0, 100, 120);
            this.slider4 = new Slider(this, 100, 280);
            
            new PushButton(this, 0, 0, "Set Value", updateValue);
            new PushButton(this, 0, 30, "Set X", updateX);
            new PushButton(this, 0, 60, "Set Y", updateY);
            new PushButton(this, 0, 90, "Set Width", updateWidth);
            new PushButton(this, 0, 120, "Set Height", updateHeight);
            new PushButton(this, 0, 150, "Set PreLabel", updatePreLabel);
            new PushButton(this, 0, 180, "Set Suffix", updateSuffix);
            new PushButton(this, 0, 210, "Show Number", updateShowNumber);
            new PushButton(this, 0, 240, "Show Filler", updateShowFiller);
            new PushButton(this, 0, 270, "Set MinMax", updateMinMax);
        }
        
        private function updateValue(e:Event):void{
            this.slider2.setValue(Math.random()*80);
        }
        
        private function updateX(e:Event):void{
            this.slider2.setX(Math.random()*200);
        }
        
        private function updateY(e:Event):void{
            this.slider2.setY(Math.random()*200);
        }
        
        private function updateWidth(e:Event):void{
            this.slider2.setWidth(Math.random()*100);
        }
        
        private function updateHeight(e:Event):void{
            this.slider2.setHeight(Math.random()*50);
        }
        
        private function updatePreLabel(e:Event):void{
            this.slider2.setPreLabel("LOLIPOP asdfghjkl");
        }
        
        private function updateSuffix(e:Event):void{
            this.slider2.setSuffix(" LMAO");
        }
        
        private function updateShowNumber(e:Event):void{
            var tmp:Boolean= this.slider2.getShowNumber();
            this.slider2.setShowNumber(!tmp);
        }
        
        private function updateShowFiller(e:Event):void{
            var tmp:Boolean= this.slider2.getShowFiller();
            this.slider2.setShowFiller(!tmp);
        }
        
        private function updateMinMax(e:Event):void{
            this.slider2.setMinMax(Math.random()*50,Math.random()*450);
        }
        
    }
}
 
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Rectangle;
import com.bit101.components.Label;
import com.bit101.components.Style; 

class Slider extends Sprite{
    public var myValue:Number = 0.0;
    private var bar:Sprite;
    private var myLine:Sprite;
    private var inline:Sprite;
    private var lineheight:int;
    private var max:Number = 1.0;
    private var min:Number = 0.0;
    private var spacer:int;
    private var addedSpacer:int;
    private var myParent:Sprite;
    private var suffix:String;
    private var preLabel:Label;
    private var valuePreLabel:String;
    private var valueLabel:Label;
    private var myWidth:int; 
    private var myHeight:int;
    private var showNumber:Boolean;
    private var showFiller:Boolean;
    
    public function Slider(refParent:Sprite, refX:int=0, refY:int=0, refWidth:int=100, refHeight:int=10, refLabel:String="", 
                           refSuffix:String="", refShowNumber:Boolean=true, refShowFiller:Boolean=true, min:Number = 0.0, max:Number = 1.0, refInitValue:Number= 0){
        this.myParent=refParent;
        this.x= refX;
        this.y= refY;
        this.myWidth= refWidth;
        this.myHeight= refHeight;
        this.valuePreLabel= refLabel;
        this.suffix= refSuffix;
        this.spacer= this.myHeight;
        this.showNumber= refShowNumber;
        this.showFiller= refShowFiller;
        this.min = min;
        this.max = max;
        if(this.min>this.max){
            this.min = this.max;
        }
        if(this.max<this.min){
            this.max = this.min;
        }
        this.DrawSlider(refInitValue);
    }
    
    private function DrawSlider(refInitValue:Number):void{
        this.preLabel= new Label(this, 0, (this.myHeight/2) - Style.fontSize, this.valuePreLabel);
        this.myLine = new Sprite();
        this.addChild(this.myLine);
         
        this.inline = new Sprite();
        this.addChild(this.inline);
        
        this.valueLabel = new Label(this, this.addedSpacer + this.spacer + this.myLine.width, (this.myHeight/2) - Style.fontSize, this.myValue.toFixed(1) + this.suffix);
        if(this.showNumber==false){
            this.valueLabel.visible= false;
        }
 
        this.bar = new Sprite();
        this.addChild(this.bar);
        this.bar.addEventListener(MouseEvent.MOUSE_DOWN, onMyMouseDown);
        this.UpdateDrawing();
        this.myParent.addChild(this);
        this.setValue(refInitValue);
    }
    
    private function onMyMouseDown(event:MouseEvent):void{
        this.bar.startDrag(false, new Rectangle(0, 0, this.myWidth, 0));
        var stopIt:Function = function():void {bar.stopDrag(); removeEventListener(Event.ENTER_FRAME, Loop);};
        stage.addEventListener(Event.MOUSE_LEAVE, stopIt);
        stage.addEventListener(MouseEvent.MOUSE_UP, stopIt);
        this.addEventListener(Event.ENTER_FRAME, Loop);
    }
 
    private function Loop(event:Event):void{
        this.myValue = this.min + bar.x / this.myWidth * (this.max - this.min);
        if(this.showFiller==true){    
            this.inline.x= this.lineheight+this.addedSpacer - ((this.lineheight*bar.x)/this.myWidth) - (this.addedSpacer * (bar.x+this.lineheight)/this.myWidth);
            this.inline.width= bar.x;
        }
        this.dispatchEvent(new Event(Event.CHANGE));
        this.valueLabel.text = this.myValue.toFixed(1) + this.suffix;
    }
    
    private function UpdateDrawing():void{
        this.spacer= this.myHeight;
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(this.myWidth, this.myHeight, 90 * Math.PI / 180, -6, -5);
        this.preLabel.y= (this.myHeight/2) - Style.fontSize;
                
        this.lineheight= Math.floor(this.myHeight/10);
        if(lineheight<1){
            lineheight=1;
        }
        this.addedSpacer= this.preLabel.width + this.spacer + this.lineheight;
        this.myLine.graphics.clear();
        this.myLine.graphics.lineStyle(this.lineheight, 0x939393);
        this.myLine.graphics.beginGradientFill("linear", [0xBEBEBE, 0xFFFFFF], [1.0, 1.0], [0, 255], matrix);
        this.myLine.graphics.drawRoundRect(this.addedSpacer, 0, this.myWidth, this.myHeight, 5, 5);
        this.myLine.graphics.endFill();
        
        this.inline.graphics.clear();
        this.inline.graphics.beginGradientFill("linear", [0x243f83, 0x558ac8], [1.0, 1.0], [0, 255], matrix);
        this.inline.graphics.drawRoundRect(this.addedSpacer + this.lineheight/2, this.lineheight/2, this.myWidth-this.lineheight, this.myHeight-this.lineheight, 5, 5);
        this.inline.graphics.endFill();
        
        this.valueLabel.x = this.addedSpacer + this.spacer + this.myLine.width;    
        this.valueLabel.y = (this.myHeight/2) - Style.fontSize;
        
        this.bar.graphics.clear();
        this.bar.graphics.lineStyle(this.lineheight, 0xE0E0E0);
        this.bar.graphics.beginGradientFill("linear", [0xBEBEBE, 0xFFFFFF], [1.0, 1.0], [0, 255], matrix);
        this.bar.graphics.drawCircle(this.addedSpacer, this.myHeight/2, this.myHeight-this.lineheight);
        this.bar.graphics.endFill();
        this.setValue(this.myValue);
    }
    
    public function setValue(refValue:Number):void{
        if(refValue<this.min){
            refValue=this.min;
        }
        if(refValue>this.max){
            refValue=this.max;
        }
        bar.x= (refValue - this.min) * this.myWidth / (this.max - this.min);
        this.Loop(null);
    }
    
    public function getValue():Number{
        return this.myValue;
    }
    
    public function setX(refX:Number):void{
        this.x= refX;
    }
    
    public function getX():Number{
        return this.x;
    }
    
    public function setY(refY:Number):void{
        this.y= refY;
    }

    public function getY():Number{
        return this.y;
    }

    public function setWidth(refWidth:Number):void{
        this.myWidth= refWidth;
        this.UpdateDrawing();
    }
    
    public function getWidth():Number{
        return this.myWidth;
    }
    
    public function setHeight(refHeight:Number):void{
        this.myHeight= refHeight;
        this.UpdateDrawing();
    }
    
    public function getHeight():Number{
        return this.myHeight;
    }
    
    public function setPreLabel(refLabel:String):void{
        this.valuePreLabel= refLabel;
        this.preLabel.text= this.valuePreLabel;
        this.UpdateDrawing();
    }
    
    public function setSuffix(refSuffix:String):void{
        this.suffix= refSuffix;
        this.Loop(null);
    }

    public function setShowNumber(refShowNumber:Boolean):void{
        this.showNumber= refShowNumber;
        this.valueLabel.visible= this.showNumber;
    }

    public function getShowNumber():Boolean{
        return this.showNumber;
    }

    public function setShowFiller(refShowFiller:Boolean):void{
        this.showFiller= refShowFiller;
        this.inline.visible= this.showFiller;
    }
    
    public function getShowFiller():Boolean{
        return this.showFiller;
    }

    public function setMinMax(refMin:Number,refMax:Number):void{
        this.min= refMin;
        this.max= refMax;
        if(this.min>this.max){
            this.min = this.max;
        }
        if(this.max<this.min){
            this.max = this.min;
        }
        this.Loop(null);
    }
    
    public function getMin():Number{
        return this.min;
    }
    
    public function getMax():Number{
        return this.max;
    }
    
}