/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z68D
 */

// forked from JohnBrookes's bodbot
//just messing about :)
package 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Rectangle;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.lights.PointLight3D;
	import org.papervision3d.materials.BitmapFileMaterial;
	import org.papervision3d.materials.ColorMaterial;
	import org.papervision3d.materials.MovieMaterial;
	import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
	import org.papervision3d.materials.shaders.FlatShader;
	import org.papervision3d.materials.shaders.ShadedMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.materials.utils.MaterialsList;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Cube;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.objects.primitives.Sphere;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.util.ViewportLayerSortMode;
	import org.papervision3d.view.layer.ViewportLayer;
	import org.papervision3d.view.stats.StatsView;
	
	public class Walk3 extends BasicView 
	{
		private var angleStep:int = 0;
		private var line:Line3D;
		private var treeSpirit:Lines3D;
		//private var s:Sphere;
		private var robot:DisplayObject3D;
		//private var foot_Left:Sphere;
		private var d:Number = 0;
		private var light:PointLight3D;
		private var foot_Right:Cube;
		private var foot_Left:Cube;
		private var head:Cube;
		private var shadow_foot_Left:Plane;
		private var shadow_foot_Right:Plane;
		private var arm_Left:Cube;
		private var arm_Right:Cube;
		public function Walk3():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//addChild(new StatsView(renderer));
			addEventListener(Event.ENTER_FRAME, tick);

			// entry point
			camera.z = 15000
			camera.y = 1500
			camera.zoom = 250;
			light = new PointLight3D();
			
			var facemat:MovieMaterial = new MovieMaterial(createFace());
			var faceShaderMat:ShadedMaterial = new ShadedMaterial(facemat, new FlatShader(light));
			
			var moviemat:MovieMaterial = new MovieMaterial(createEar());
			
			var shaderMat:ShadedMaterial = new ShadedMaterial(moviemat, new FlatShader(light));
			
			
			var matlist:MaterialsList = new MaterialsList( {
				front:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				back:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				right:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				left:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				top:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				bottom:new FlatShadeMaterial(light,0xfefefe, 0x333333)
			});
			
			/*
			var matlist:MaterialsList = new MaterialsList( {
				all:new WireframeMaterial
			});
			*/
			var head_matlist:MaterialsList = new MaterialsList( {
				front:shaderMat,
				back:shaderMat,
				right:faceShaderMat,
				left:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				top:new FlatShadeMaterial(light,0xfefefe, 0x333333),
				bottom:new ColorMaterial(Math.random() * 0xffffff)
			});
			
			viewport.containerSprite.sortMode = ViewportLayerSortMode.INDEX_SORT;
			
			var robotLayer:ViewportLayer = new ViewportLayer(viewport, null);
			robotLayer.layerIndex = 2;
			viewport.containerSprite.addLayer(robotLayer);
			
			robot = new DisplayObject3D();
			scene.addChild(robot);
			
			var body:Cube = new Cube(matlist, 250, 250, 500,4,4,4);
			body.y = 350;
			robot.addChild(body);
			
			arm_Left = new Cube(matlist, 50, 50, 50);
			arm_Left.z = 25 + 125;
			arm_Left.y = 200;
			body.addChild(arm_Left);
			
			var arm_Left2:Cube = new Cube(matlist, 50, 50, 200);
			arm_Left2.z = 25 + 25;
			arm_Left2.y = -75;
			arm_Left.addChild(arm_Left2);
			
			var arm_Left3:Cube = new Cube(matlist, 200, 50, 50);
			arm_Left3.x = 75;
			arm_Left3.y = -125;
			arm_Left2.addChild(arm_Left3);
			
			arm_Right = new Cube(matlist, 50, 50, 50);
			arm_Right.z = -25 - 125;
			arm_Right.y = 200;
			body.addChild(arm_Right);
			
			var arm_Right2:Cube = new Cube(matlist, 50, 50, 200);
			arm_Right2.z = -25 - 25;
			arm_Right2.y = -75;
			arm_Right.addChild(arm_Right2);
			
			var arm_Right3:Cube = new Cube(matlist, 200, 50, 50);
			arm_Right3.x = 75;
			arm_Right3.y = -125;
			arm_Right2.addChild(arm_Right3);
			
			head = new Cube(head_matlist, 200, 200, 200);
			body.addChild(head);
			head.y = 250+  100;
			
			foot_Right = new Cube(matlist,100,75,50,2,1,1);
			foot_Right.z = 50;
			robot.addChild(foot_Right);
			
			foot_Right.geometry.faces[12].material = new ColorMaterial(0x000000,0);
			foot_Right.geometry.faces[13].material = new ColorMaterial(0x000000,0);
			
			var leg_Right:Cube = new Cube(matlist, 50, 75, 100, 1,1,1,0,Cube.TOP);
			leg_Right.x = -25
			leg_Right.y = 75;
			foot_Right.addChild(leg_Right);
			
			
			foot_Left = new Cube(matlist,100,75,50,2,1,1);
			foot_Left.z = -50;
			robot.addChild(foot_Left);
			
			foot_Left.geometry.faces[12].material = new ColorMaterial(0x000000,0);
			foot_Left.geometry.faces[13].material = new ColorMaterial(0x000000,0);
			
			var leg_Left:Cube = new Cube(matlist, 50, 75, 100,1,1,1,0,Cube.TOP);
			leg_Left.x = -25
			leg_Left.y = 75;
			foot_Left.addChild(leg_Left);
			
			robotLayer.addDisplayObject3D(robot, true);
			
			var shadowLayer:ViewportLayer = new ViewportLayer(viewport, null);
			shadowLayer.layerIndex = 1;
			viewport.containerSprite.addLayer(shadowLayer);
			
			shadow_foot_Left = new Plane(new ColorMaterial(0x333333), 100, 50);
			shadow_foot_Left.rotationX = 90;
			robot.addChild(shadow_foot_Left);
			
			
			shadow_foot_Right = new Plane(new ColorMaterial(0x333333), 100, 50);
			shadow_foot_Right.rotationX = 90;
			robot.addChild(shadow_foot_Right);
			
			var robotShadow:Plane = new Plane(new ColorMaterial(0x333333,0.5), 300, 300);
			robotShadow.rotationX = 90;
			robot.addChild(robotShadow);
			
			
			shadowLayer.addDisplayObject3D(robotShadow);
			shadowLayer.addDisplayObject3D(shadow_foot_Left);
			shadowLayer.addDisplayObject3D(shadow_foot_Right);
			shadowLayer.filters = [new BlurFilter(12, 12)];
			
			robotShadow.y = -25
			
		}
		
		private function createFace():Sprite
		{
			var f:Sprite = new Sprite();
			f.graphics.beginFill(0xffffff);
			f.graphics.drawRect(0, 0, 512, 512);
			f.graphics.endFill();
			
			var le:Sprite = createCircle();
			le.x = -150;
			
			
			var re:Sprite = createCircle();
			re.x = 150;
			
			var m:Shape = new Shape();
			m.graphics.beginFill(0x000000);
			m.graphics.drawRect(50, 380, 412, 40);
			m.graphics.endFill();
			
			f.addChild(le)
			f.addChild(re);
			f.addChild(m)
			return f;
		}
		
		private function createEar():Sprite
		{
			var f:Sprite = new Sprite();
			f.graphics.beginFill(0xffffff);
			f.graphics.drawRect(0, 0, 512, 512);
			f.graphics.endFill();
			
			f.addChild(createCircle());
			
			return f;
		}
		
		
		
		private function createCircle():Sprite
		{
			var c:Sprite = new Sprite();
			c.graphics.beginFill(0x000000);
			c.graphics.drawCircle(256, 256, 80);
			c.graphics.endFill();
			
			var c2:Shape = new Shape();
			c2.graphics.beginFill(0xffffff);
			c2.graphics.drawCircle(256, 256, 50);
			c2.graphics.endFill();
			
			c.addChild(c2)
			
			return c;
		}
		
		private function tick(e:Event):void 
		{	
			//camera.orbit(65, viewport.mouseX - viewport.viewportWidth/2)
			
			
			
			var gateLength:Number = 70;
			var dAngleStep:Number = 25;
			
			arm_Left.rotationZ = -Math.sin(angleStep *Math.PI/180 ) * gateLength ;
			arm_Right.rotationZ = Math.sin(angleStep *Math.PI/180 ) * gateLength ;
			
			foot_Right.x =Math.sin(angleStep *Math.PI/180 ) * gateLength ;
			foot_Right.y = Math.max(0,Math.cos(angleStep*Math.PI/180 )* 50);
			
			
			foot_Left.x = -Math.sin(angleStep*Math.PI/180 )* gateLength;
			foot_Left.y = Math.min(0,Math.cos(angleStep*-Math.PI/180 )* 50)*-1;
			
			
			if (foot_Right.y <= 0)
			{
				robot.moveRight( (((Math.sin((angleStep - dAngleStep) * Math.PI / 180 ) * gateLength) ) - (Math.sin((angleStep) * Math.PI / 180 ) * gateLength) ) );
			}
			if (foot_Left.y <=0)
			{
				robot.moveRight( ( ( -Math.sin((angleStep -dAngleStep) * Math.PI / 180 ) * gateLength)  - ( -Math.sin(angleStep * Math.PI / 180 ) * gateLength)) );
			}
			
			robot.rotationY = viewport.mouseX - viewport.viewportWidth * 0.5;
			
			shadow_foot_Left.copyPosition(foot_Left);
			shadow_foot_Right.copyPosition(foot_Right);
			shadow_foot_Left.y = -25;
			shadow_foot_Right.y = -25;
			
			
			light.copyPosition(camera);
			light.y = 20000;
			/**/
			singleRender();
			
			angleStep+=dAngleStep;
		}
		
	}
	
}