/**
 * Copyright k3lab ( http://wonderfl.net/user/k3lab )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z64Q
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.Event; 
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.utils.getTimer;
    public class Professional extends Sprite {
        private var bmd:BitmapData;
        public function Professional() {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            var list:Array = [box1(), box2(), box3(),box4(),box5(),box6(),box7(),box8(),box9(),box10(),box11(),box12(),box13(),box14(),box15(),box16(),box17(),box18(),box19(),box20(),box21(),box22(),box23(),box24()]; 
            //generate bitmap pattern.
            var pattern:BitmapData = box2(); 
            bmd = new BitmapData(480, 480, false, 0x00)
            addChild(new Bitmap(bmd)) as Bitmap;
            //var g:Graphics = graphics;
            var sp:Sprite = addChild(new Sprite()) as Sprite;
            sp.x = stage.stageWidth / 2
            sp.y=stage.stageHeight/2
            var g:Sprite = sp.addChild(new Sprite()) as Sprite;		
            g.graphics.beginBitmapFill(pattern); 
            g.graphics.drawRect(0,0,480,480); 
            g.graphics.endFill(); 
            g.x = -240
            g.y=-240
            addEventListener(Event.ENTER_FRAME,loop); 		
            var f:uint=0; 
            function loop(e:Event):void 
            { 
                pattern = list[f]; 
                f++; 
                if(f==23)f=0; 
                var a:Number = (getTimer() / 150) 
                var scale:Number=Math.abs(Math.sin(a*Math.PI/30))+0.15
                var r:Number = Math.sin(a*Math.PI/180) *300
                var matrix:Matrix = new Matrix;
                matrix.rotate(a*Math.PI/180);
                matrix.scale(scale,scale);
                matrix.translate(r,r);
                sp.rotationY += (mouseY-sp.rotationY)/4
                sp.rotationX += (mouseX - sp.rotationX) / 4
                sp.scaleX += ((Point.distance(new Point(0, 0), new Point(mouseX, mouseY))/150)-sp.scaleX)/4
                sp.scaleY += ((Point.distance(new Point(0, 0), new Point(mouseX, mouseY)) / 150) - sp.scaleY) / 4
                g.graphics.clear(); 
                g.graphics.beginBitmapFill(pattern,matrix,true,true); 
                g.graphics.drawRect(0,0,480,480); 
                g.graphics.endFill(); 
                bmd.draw(g)

            } 
        }
        
        		public function box1():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,2,3,0,4,5,6,7,8,9,10,11,2,12,13,14,2,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,15,16,17,18,19,20,21,22,23,24,25,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,0,0,2,3,26,27,28,29,30,31,32,33,34,35,36,3,2,0,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,1,54,55,56,57,58,59,44,60,61,62,63,64,65,66,67,68,25,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,2,12,0,2,0,70,71,72,73,74,75,76,77,78,79,44,80,81,82,83,84,85,86,87,88,89,90,53,91,0,0,1,0,53,92,93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,2,0,0,4,94,95,96,97,98,99,100,101,102,80,103,79,104,105,106,107,108,109,110,111,112,37,2,0,113,70,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,53,114,115,116,117,118,119,120,121,122,123,124,125,103,44,126,127,128,129,130,131,132,133,134,135,136,53,0,53,0,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,37,112,137,138,139,140,99,141,142,143,144,145,146,147,103,44,148,149,150,151,152,129,86,153,154,155,156,157,0,0,53,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,1,0,0,158,16,159,160,161,162,141,163,164,165,166,167,168,169,170,171,60,172,173,174,128,151,175,129,176,177,178,179,180,181,3,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,2,182,183,184,185,186,187,141,188,189,190,191,192,193,194,195,196,197,198,199,200,201,202,151,129,203,151,204,205,206,207,208,24,1,0,209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,0,0,0,0,0,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,61,228,44,229,230,231,151,151,129,232,233,234,235,236,237,110,238,112,3,2,0,2,53,53,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,71,0,0,0,239,1,240,16,241,242,243,244,124,245,246,247,248,249,250,223,251,252,253,254,255,171,256,61,257,201,151,129,234,232,129,129,234,258,259,260,261,262,182,113,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,3,3,0,0,182,263,264,265,266,267,268,269,270,271,272,273,274,251,224,275,251,276,277,278,279,61,198,44,280,281,282,175,152,175,233,283,130,284,285,86,286,287,288,289,53,69,0,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,2,70,290,291,292,293,294,295,296,297,298,299,193,224,274,274,300,274,301,302,303,304,305,306,60,103,307,308,309,151,283,129,129,310,129,130,130,311,312,313,314,315,72,37,0,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,92,316,317,318,319,320,321,322,323,324,325,326,327,300,328,329,251,274,274,251,330,331,332,333,334,335,60,336,337,338,339,340,233,152,152,129,283,152,203,341,342,343,344,345,346,136,1,0,0,0,0,0,0,0,0,0,0,0], 
    [1,2,2,0,2,37,347,348,349,350,266,244,351,297,352,353,354,276,355,251,329,251,251,251,251,251,251,356,357,358,359,171,60,199,360,361,362,283,175,130,283,233,151,130,175,233,284,363,364,365,366,367,368,2,69,0,1,0,2,0,0,0,0,0], 
    [2,1,0,113,37,369,159,370,371,372,373,374,375,376,377,378,379,330,251,274,329,251,251,251,251,251,251,380,381,382,383,384,103,103,229,385,386,152,233,151,152,310,130,310,175,233,283,130,311,387,388,110,389,390,0,0,2,0,1,0,0,0,0,0], 
    [92,53,2,15,183,391,392,393,394,395,396,397,398,399,252,250,330,251,400,329,251,251,251,251,251,251,251,300,401,402,403,404,171,60,102,405,361,152,233,129,152,310,129,129,129,310,233,233,203,406,407,237,408,409,0,1,0,0,1,0,0,0,0,0], 
    [0,37,410,411,412,413,414,415,359,416,417,418,419,420,274,421,251,251,328,251,251,251,251,251,251,251,251,274,378,422,423,424,44,60,60,425,426,339,152,129,283,310,129,310,310,310,233,175,129,151,130,427,49,428,136,0,0,2,12,0,0,0,0,0], 
    [2,429,430,431,432,433,434,435,436,437,438,439,440,251,328,251,251,441,442,251,251,251,251,251,251,251,251,355,420,443,278,279,61,60,103,444,445,446,447,129,283,310,129,233,310,310,233,310,233,203,130,448,449,389,181,0,2,2,0,0,0,0,0,0], 
    [390,450,451,140,452,453,454,455,456,457,458,459,459,274,251,251,251,251,251,251,251,251,251,251,251,251,251,400,400,460,461,462,147,60,60,102,463,464,339,130,129,130,129,310,310,310,310,310,310,129,152,465,466,467,468,469,2,53,1,0,0,0,0,0], 
    [410,470,471,472,43,473,474,475,476,477,301,459,459,421,251,478,251,251,251,251,251,251,251,251,251,251,251,251,274,331,479,480,481,103,198,44,444,482,483,130,129,130,129,310,310,310,310,310,129,232,283,484,485,486,487,4,2,53,70,0,0,0,0,0], 
    [410,488,139,43,103,489,490,491,492,493,494,251,328,251,329,328,251,251,251,251,251,251,251,251,251,251,251,251,274,495,496,497,498,198,499,198,61,500,501,151,129,151,175,310,310,310,310,310,129,129,129,340,204,502,503,504,1,53,12,0,0,0,0,0], 
    [15,505,506,507,80,508,509,510,511,512,513,494,400,251,329,251,251,251,251,251,251,251,251,251,251,251,251,274,400,440,514,515,516,44,499,198,79,517,518,519,129,151,175,310,310,310,310,310,129,129,233,129,311,259,88,90,390,0,0,0,0,0,0,0], 
    [37,520,521,522,199,523,524,525,526,527,528,529,530,531,400,251,251,251,251,251,251,251,251,251,251,251,251,459,251,224,532,533,534,404,103,171,44,535,536,150,152,151,130,310,310,310,310,310,233,234,129,283,129,537,538,539,540,0,0,0,0,0,0,0], 
    [1,541,542,543,544,255,545,546,547,548,549,550,551,552,531,553,251,251,251,251,251,251,251,251,251,251,251,554,251,478,555,437,556,557,198,171,103,558,559,560,519,129,130,310,310,310,310,310,152,129,561,129,232,562,563,564,51,0,1,0,0,0,0,0], 
    [0,565,488,566,43,567,568,569,570,571,572,573,574,575,576,577,578,274,274,274,274,274,274,459,251,251,251,579,327,580,581,582,583,197,60,171,44,584,585,586,587,588,151,175,130,130,129,152,310,310,310,310,310,176,589,590,261,390,1,0,0,0,0,0], 
    [0,591,592,593,594,44,595,596,597,598,599,600,601,602,603,604,605,494,606,251,251,251,251,274,400,459,223,607,608,609,610,611,612,103,103,197,613,614,615,616,617,618,588,129,130,588,151,310,310,310,310,310,310,284,619,620,621,112,0,0,0,0,0,0], 
    [0,622,623,624,625,256,626,627,628,629,630,630,599,631,632,602,633,529,634,635,274,459,274,251,400,440,636,637,638,639,640,557,44,79,613,641,642,643,644,645,646,647,648,618,283,130,129,130,310,310,310,310,310,283,176,649,650,651,25,0,0,0,0,0], 
    [0,240,652,653,77,60,306,654,655,656,631,600,600,630,657,658,659,660,661,662,663,664,400,251,478,192,665,666,667,668,669,60,197,670,671,672,673,674,675,676,677,678,679,680,681,152,130,130,310,310,310,310,310,233,232,682,683,684,409,0,0,0,0,0], 
    [2,38,685,686,687,197,199,688,689,690,691,630,630,600,600,600,631,658,692,693,694,695,696,225,697,698,699,700,701,197,44,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,717,175,310,310,310,310,310,152,588,718,719,720,721,37,0,2,0,0], 
    [3,72,16,722,723,44,79,724,725,726,727,631,631,600,600,600,728,630,632,729,730,731,732,733,734,735,736,737,79,44,544,738,739,740,741,742,743,709,711,711,711,711,711,744,745,746,747,130,129,129,151,232,175,151,130,204,748,749,750,113,0,0,751,2], 
    [0,37,752,753,754,755,60,756,757,758,759,600,600,600,600,600,760,631,630,761,762,763,764,765,766,767,229,197,544,768,769,770,771,772,711,709,711,711,711,711,711,711,711,773,712,774,714,775,776,130,129,232,129,233,310,233,777,778,779,780,0,12,91,0], 
    [0,0,781,431,782,783,103,784,785,786,787,600,600,600,600,600,788,631,788,789,790,791,792,793,794,44,44,795,796,797,798,799,800,711,711,743,743,711,711,711,711,711,711,711,801,707,744,802,803,804,588,129,130,283,175,152,484,805,806,807,37,2,92,2], 
    [0,0,182,808,809,594,44,101,810,811,812,630,728,631,600,631,631,813,814,815,816,817,818,61,79,613,819,642,820,821,822,743,711,709,711,709,709,711,711,711,711,711,711,823,709,709,773,824,825,826,803,618,130,129,129,175,130,827,828,829,830,0,0,0], 
    [0,0,390,831,832,833,499,834,835,836,837,657,728,631,600,601,571,790,838,839,840,841,255,44,44,842,843,844,845,846,847,709,711,709,711,711,711,711,711,711,711,711,711,711,711,709,709,848,800,849,850,851,852,283,310,175,310,853,854,855,651,2,2,0], 
    [2,3,1,856,857,77,567,858,859,860,861,862,631,631,761,863,864,865,866,489,424,197,544,671,867,868,869,800,870,709,709,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,773,871,872,802,873,681,130,283,874,875,876,877,4,2,53], 
    [0,0,0,878,56,879,880,567,881,882,883,884,885,886,887,888,889,840,890,891,197,199,892,893,894,895,896,743,897,711,898,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,709,743,899,900,901,851,618,151,284,902,49,903,368,0,69], 
    [0,0,0,904,264,905,906,60,626,907,908,909,910,911,912,913,914,892,557,567,915,916,917,918,896,773,709,711,711,898,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,743,898,709,801,919,920,872,921,922,923,176,924,154,156,25,0], 
    [0,0,1,925,926,927,162,198,613,928,929,930,931,932,933,524,934,199,199,935,936,937,938,939,773,711,743,711,711,711,711,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,897,711,711,823,709,712,899,940,941,942,943,944,945,946,780,70], 
    [0,0,0,781,947,948,394,103,61,949,950,951,952,953,954,795,955,956,957,798,958,800,870,709,709,709,709,711,711,711,711,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,711,711,709,709,711,743,959,960,850,961,962,963,964,965,158], 
    [2,0,0,410,565,350,433,198,199,966,967,968,969,395,702,61,834,970,971,972,973,711,709,709,711,711,898,711,711,711,898,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,711,743,709,709,711,743,711,919,974,975,976,977,978,288,69], 
    [0,0,0,182,979,980,981,197,60,613,982,983,984,102,670,985,986,987,973,743,823,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,743,711,988,710,773,989,990,991,992,993,182], 
    [0,0,0,37,994,995,996,78,171,171,79,544,955,997,998,999,1000,677,712,709,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,1001,988,708,709,709,773,824,1002,1003,1004,368], 
    [0,2,0,1,409,1005,1006,858,60,171,44,1007,1008,917,1009,1010,712,823,709,709,1011,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,709,708,1012,1013,1014,1015,1016,368], 
    [0,2,0,1,368,1017,1018,1019,103,755,1020,936,704,1021,1022,1023,1024,823,709,709,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,823,709,709,709,1025,1026,1027,1028,1029,807,37], 
    [0,70,0,0,1030,1031,1032,162,626,614,1033,938,799,919,711,1011,711,743,897,709,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,1023,709,1034,1035,1036,1037,1038,1039,37,1040,53], 
    [1,2,0,0,390,623,1041,1042,1043,971,1044,896,712,709,1045,823,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,709,823,743,709,711,709,711,1046,1025,1047,1048,1049,1050,1051,4,0,1,0], 
    [0,0,0,2,1,369,1052,1053,1054,1055,1056,709,709,988,709,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,898,711,711,711,1057,709,709,1058,1025,1059,1060,1061,1062,409,37,2,2,0,0,0], 
    [0,0,0,2,0,1063,1064,1065,1066,1067,708,709,711,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,711,711,709,710,823,1058,1068,1069,1070,1071,1072,1073,390,0,0,1,0,0,0], 
    [0,0,0,0,0,3,1030,1074,1075,1076,1077,1078,1079,709,709,709,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,711,710,743,1046,1080,1081,1082,1083,1084,1085,1,0,1,0,0,0,0,0,1], 
    [0,0,0,0,0,70,0,1051,1086,1087,1088,1089,1090,1091,988,898,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,711,709,709,711,743,1079,1068,1092,1093,1094,1095,1096,158,0,1097,0,70,0,2,0,0,0], 
    [0,0,0,0,0,0,0,0,0,368,240,1098,1099,1100,1101,1102,1103,988,1011,897,1001,823,823,711,711,988,743,711,711,711,711,711,711,711,711,711,711,709,988,709,711,897,897,711,988,1104,1078,1105,1070,1106,1107,1030,1108,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,69,25,1109,1074,1110,1111,1112,1113,1114,988,743,711,1115,1115,711,711,711,711,711,711,711,711,711,711,711,711,711,711,1116,743,823,823,1001,1001,709,1117,1118,1119,1120,1121,1122,780,0,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,3,1,37,1073,1123,1124,1125,1126,1127,1114,1001,743,897,711,711,711,1045,711,711,711,711,711,711,711,711,711,711,709,988,711,711,898,1114,1128,1129,1130,1131,1073,1132,0,1,53,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,1,0,70,0,2,37,25,1133,1134,1135,1136,1137,1025,708,709,711,709,711,988,711,711,711,711,711,711,711,711,711,711,710,709,708,708,1138,1139,1140,1141,1142,1143,37,0,0,1,0,113,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,2,1,0,1,0,53,390,1144,1145,1146,1147,1148,1149,988,709,898,709,711,711,711,711,711,711,711,711,711,711,709,1011,1025,1150,1151,1152,1062,807,4,1,92,2,2,2,53,53,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,0,0,0,0,2,1,53,0,0,70,0,1030,1073,1050,1153,1140,1154,1155,1117,711,1045,711,711,711,711,711,711,711,711,711,711,1046,1156,1157,1158,1159,1050,830,390,53,0,69,0,0,0,113,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,4,830,1160,1161,1162,1163,1164,1079,1011,988,709,1045,709,898,709,709,1117,1025,1059,1165,1166,1142,504,4,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,1167,1144,1168,1169,1170,1035,1091,988,743,711,709,711,823,708,1171,1090,1172,1173,1174,1073,37,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1097,53,368,1175,1176,1177,1136,1157,1012,1103,708,1058,1178,1179,1180,1181,1182,830,37,0,71,70,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,37,25,156,1183,1184,1185,1186,1187,1114,1155,1188,1189,1190,1074,1167,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,53,0,2,53,0,0,1,0,113,0,25,1191,1107,1192,1193,1194,1195,1196,1174,368,390,113,71,92,1197,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666664, 0xff666668, 0xff676767, 0xff686765, 0xff696768, 0xff797a58, 0xff8b8c4a, 0xffa3a039, 0xff968e43, 0xff716e5f, 0xff6b6861, 0xff656565, 0xff646663, 0xff646665, 0xff686866, 0xff73735b, 0xff7f8350, 0xffb3b72f, 0xffccd11c, 0xffe1dc0e, 0xffd7c614, 0xffa48e3b, 0xff877c4f, 0xff6d6a61, 0xff686763, 0xff6c6c64, 0xff87864e, 0xff9ca13d, 0xffd2d919, 0xffe4ec0b, 0xfff1ed05, 0xffecdb07, 0xffc8a722, 0xffa79239, 0xff7c7356, 0xff6e6c60, 0xff676765, 0xff696a65, 0xff7c7e57, 0xff909545, 0xffc5cb21, 0xffdbe411, 0xfff1fb04, 0xfff4fe00, 0xfff5f902, 0xfff6ef01, 0xfff4ca04, 0xffebbc0e, 0xffbc9b2a, 0xff9c883f, 0xff756e5c, 0xff6c6964, 0xff676566, 0xff696a62, 0xff73725d, 0xff989b40, 0xffb1b82c, 0xffdee80e, 0xffebf509, 0xfff5ff00, 0xfff5fc01, 0xfff6f403, 0xfff9d400, 0xfff7c703, 0xffddb015, 0xffc19e26, 0xff8b7a4c, 0xff78705d, 0xff676664, 0xff656766, 0xff656668, 0xff686963, 0xff6d6e60, 0xff898f49, 0xffa6a83a, 0xffd6e010, 0xffe7f009, 0xfff2fd03, 0xfff6fd00, 0xfff5fe03, 0xfff7fe03, 0xfff8fa00, 0xfffbdf02, 0xfffed001, 0xfffac402, 0xfff2be06, 0xffcfa51f, 0xffb29432, 0xff7f7456, 0xff706d5e, 0xff666467, 0xff676568, 0xff656762, 0xff70715f, 0xff7d8053, 0xffacb131, 0xffc8cc20, 0xffeaf306, 0xfff2f705, 0xfff4f503, 0xfff1f403, 0xfff5fc00, 0xfff5ff01, 0xfffae502, 0xfffad500, 0xfffdc702, 0xfffbc501, 0xffe8b80c, 0xffd5ab1b, 0xff9b8740, 0xff857750, 0xff6a6964, 0xff656764, 0xff6b6c64, 0xff76765a, 0xffa0a33c, 0xffbbc026, 0xffe5ee0b, 0xffedf806, 0xfff1ee09, 0xffefd80e, 0xffeda51d, 0xffecaa1e, 0xfff3ec08, 0xfff5fb05, 0xfff7f100, 0xfffbdf00, 0xfffec803, 0xffffc501, 0xfffec601, 0xfffac306, 0xffe0b214, 0xffc7a122, 0xff907f49, 0xff7a7356, 0xff6a6663, 0xff777b56, 0xff8c8f48, 0xffc1c725, 0xffd8e114, 0xfff3f704, 0xffeecf12, 0xffeaa523, 0xffe96638, 0xffea7734, 0xfff3dd0d, 0xfff5f604, 0xfff5f501, 0xfff8e502, 0xfffccc00, 0xffffc702, 0xffffc700, 0xffe4b511, 0xffb29531, 0xff968446, 0xff726c5c, 0xff686961, 0xff686667, 0xff83834f, 0xffb5ba2a, 0xffcfd51b, 0xffecf506, 0xfff2dc0d, 0xfff2ba1b, 0xffec6144, 0xffe83457, 0xffeb1761, 0xffe93457, 0xffefba1e, 0xfff1e90a, 0xfff4ff01, 0xfff7f902, 0xfff9f001, 0xfffcd202, 0xffffc602, 0xfffdc401, 0xffeebb08, 0xffdbb014, 0xffa3893c, 0xff887a4d, 0xff6d6960, 0xff686964, 0xff6c6c62, 0xff848a4e, 0xff9ea43a, 0xffd4dd14, 0xffe5ee09, 0xfff4eb0a, 0xffebae20, 0xffed7f32, 0xffee2d59, 0xffed1367, 0xffee086a, 0xffed2261, 0xffeea826, 0xfff0de0e, 0xfff3fe00, 0xfff4ff00, 0xfff3fd00, 0xfff6f600, 0xfffbd601, 0xffffcc03, 0xffffc603, 0xfffcc304, 0xfff1bd07, 0xffc4a025, 0xffa98f3a, 0xff7b7156, 0xff666867, 0xff666865, 0xff686b64, 0xff7f8152, 0xff969844, 0xffc8cf21, 0xffdce510, 0xfff2f603, 0xfff3ef07, 0xfff3c017, 0xfff1952e, 0xffec3959, 0xffec1a61, 0xffef0368, 0xfff1026a, 0xfff1016c, 0xffee1065, 0xffec7639, 0xffeebf1b, 0xfff5ff02, 0xfff5fa00, 0xfffae101, 0xfffcd201, 0xffffc502, 0xffffc500, 0xfffec400, 0xfff3c005, 0xffe8b810, 0xffb89a2c, 0xff746e5e, 0xff656563, 0xff6b6b61, 0xff9c9e3d, 0xffb7bc2c, 0xffe4ea0c, 0xffeef507, 0xfff1d512, 0xffef852f, 0xfff05745, 0xffef1466, 0xfff0056a, 0xfff00169, 0xfff0006d, 0xffed0968, 0xffeb5f46, 0xffedae23, 0xfff3f901, 0xfff7fe00, 0xfff9e701, 0xfffac102, 0xffdaae17, 0xffc09d27, 0xff877a4e, 0xff76705a, 0xff6e6f5d, 0xff8d9147, 0xffa6ab37, 0xffd9e014, 0xffe9f20b, 0xfff4f104, 0xfff4e00d, 0xfff09930, 0xffec6746, 0xffed1b62, 0xffef0a65, 0xfff0006b, 0xfff2016c, 0xffee036a, 0xffed3a58, 0xffec8238, 0xfff2ee07, 0xfff6f101, 0xfff9e101, 0xfffec901, 0xfffec600, 0xfffec502, 0xfff9c300, 0xffcba423, 0xffaf9234, 0xff7d7457, 0xff6f6b5f, 0xff70725d, 0xff7e8152, 0xffaeb430, 0xffc7d01d, 0xffebf107, 0xfff1f703, 0xfff0d60d, 0xfff0b51b, 0xffed5b44, 0xffec3259, 0xffef026c, 0xffee0169, 0xffed0269, 0xffec2b60, 0xffe86a42, 0xfff2e80d, 0xfff4fa04, 0xfff6f602, 0xfff8e701, 0xffffcc01, 0xffffc600, 0xfffdc403, 0xffe7b70f, 0xffd3aa1e, 0xff998540, 0xff807853, 0xff6c6c60, 0xff747758, 0xffa0a23d, 0xffbcc327, 0xffe7ee0c, 0xfff0f505, 0xfff2e10b, 0xfff0c61a, 0xffe86a44, 0xffe93b52, 0xfff10c67, 0xfff0056c, 0xfff1006d, 0xfff1016e, 0xfff0006f, 0xffed1664, 0xffeb4553, 0xfff0ce15, 0xfff3f106, 0xfff4ff03, 0xfff6fb01, 0xfff8f102, 0xfffdd400, 0xfffecb00, 0xffffc401, 0xfffbc500, 0xfff9c205, 0xffdeb014, 0xffc5a126, 0xff8a7c4d, 0xff797258, 0xff696866, 0xff797d58, 0xff8d904b, 0xffc2c923, 0xfff0ee05, 0xffee8b2e, 0xffea345a, 0xffee1566, 0xfff2006e, 0xffed0e67, 0xffe9305a, 0xffefb921, 0xfff2e80a, 0xfff5f500, 0xfffbd800, 0xffffcc00, 0xfff6be05, 0xffe3b410, 0xffae9135, 0xff928247, 0xff6f6d60, 0xff696863, 0xff72745e, 0xffb8bd2b, 0xffd0d718, 0xffeef205, 0xfff1f103, 0xfff0c818, 0xffec9e2f, 0xffe63d50, 0xffeb1d5d, 0xffef0469, 0xfff10170, 0xfff0036b, 0xffef1664, 0xfff08f2e, 0xfff2d016, 0xfff6fb00, 0xfffae301, 0xfffbd300, 0xffedb90b, 0xffd9ad18, 0xff7f7552, 0xff676863, 0xff868a4f, 0xff9ea438, 0xffd5de15, 0xffe6ef0c, 0xfff0ee06, 0xffefdd0d, 0xffee922d, 0xffeb6147, 0xffe81863, 0xffee016b, 0xffee1067, 0xffee7639, 0xfff1bd1b, 0xfff5fb03, 0xfff7e902, 0xfffbc106, 0xfff0bb0d, 0xff948146, 0xff6a6a62, 0xff696a64, 0xff7e7f55, 0xff969942, 0xffcbce1b, 0xffdde611, 0xffeff203, 0xffeda02c, 0xffe96f40, 0xffeb255a, 0xffef0f67, 0xffef026a, 0xffee016d, 0xffea4f4b, 0xffef9a2d, 0xfff2f504, 0xfff8f301, 0xfffbe402, 0xffe3b313, 0xff756e5b, 0xff6b6b63, 0xff74745c, 0xff9b9f3e, 0xffb8be2a, 0xffe3eb0e, 0xffeaf207, 0xfff0df0d, 0xfff2c21a, 0xffed6346, 0xffea385a, 0xffec0b67, 0xffef046b, 0xfff0006e, 0xfff1006f, 0xffea3c55, 0xfff7f701, 0xfffaea01, 0xfffece02, 0xfffec900, 0xffedb90d, 0xffcca621, 0xff838351, 0xffa1a439, 0xffe8f206, 0xfff3f307, 0xfff0da13, 0xffe8763a, 0xffeb484b, 0xfff01066, 0xffed056b, 0xfff1006b, 0xffeb1f64, 0xffea554e, 0xfff0de10, 0xfff5f300, 0xfffdd501, 0xfff8c105, 0xffe6b510, 0xff988445, 0xff78705b, 0xff676662, 0xff909346, 0xffb7bc2a, 0xffeaf40a, 0xfff1ec0c, 0xffeac31e, 0xffdf4350, 0xffe61e5d, 0xfff00469, 0xffef026e, 0xffea4354, 0xfff0ce17, 0xfff3f108, 0xfffcd901, 0xfffcce00, 0xfffcc302, 0xffefbc0b, 0xffa78f37, 0xff847852, 0xff949843, 0xffeee609, 0xffdfb31c, 0xffc4284d, 0xffcb0a59, 0xffe20066, 0xffeb0069, 0xffef096b, 0xffee2261, 0xffeea824, 0xfff3df0c, 0xfff3ff00, 0xfff9e603, 0xfffcd800, 0xffcaa521, 0xffa0883e, 0xff6c6962, 0xff919443, 0xffbdc325, 0xfff0f804, 0xffefeb06, 0xffdfbd13, 0xffb8303c, 0xffb80e4d, 0xffd0005e, 0xffdd0163, 0xffef1762, 0xffee902e, 0xfff2d114, 0xfff8ea01, 0xfffcdb00, 0xffffc801, 0xff87884e, 0xffadb32f, 0xffebf405, 0xfff4f501, 0xffe8d809, 0xffb54d34, 0xffa51946, 0xffa8004e, 0xffb30051, 0xffcd005d, 0xffdb0162, 0xffe90069, 0xfff00b68, 0xffeb6542, 0xfff0b422, 0xfff6f400, 0xfffbe601, 0xffefba08, 0xffd3a81d, 0xff837653, 0xff6e6a5f, 0xff7e8154, 0xffa3a739, 0xffe8f208, 0xfff2fd01, 0xffe9e007, 0xffb85736, 0xffa31f46, 0xff9d004d, 0xffa30051, 0xffb80154, 0xffc8005b, 0xffe00065, 0xffef006c, 0xfff2016a, 0xffed0c6a, 0xfff1af23, 0xfff4fa02, 0xfff6f801, 0xfffbeb02, 0xfffccf00, 0xffffc402, 0xfff7c003, 0xffdfb211, 0xff8f8049, 0xff777858, 0xffe3eb0c, 0xfff3fc03, 0xffedea07, 0xffc17225, 0xffa93039, 0xff990249, 0xff9a004d, 0xff9d014b, 0xffa3014d, 0xffba0056, 0xffc7005b, 0xffdf0166, 0xffe80169, 0xfff2036b, 0xffec1e5f, 0xffed3c58, 0xfff0a32d, 0xfff2d515, 0xfff3f700, 0xfff2ec00, 0xfff6d200, 0xfff8cb00, 0xfffcc601, 0xfff2be08, 0xffad9334, 0xff74745a, 0xff8f9245, 0xffdde60f, 0xffeff904, 0xfff0f002, 0xffcb881f, 0xffaf3f34, 0xff9a0549, 0xff99014c, 0xff98004b, 0xff99014a, 0xffa6014e, 0xffb20054, 0xffce015e, 0xffdc0263, 0xffed006a, 0xffee066a, 0xffec1266, 0xffeb4b4b, 0xffec753d, 0xfff0d116, 0xfff5ee0a, 0xfff4fb00, 0xffedeb00, 0xffeae100, 0xffeccd01, 0xfff0c900, 0xfffbc701, 0xfff8c102, 0xffc19e2a, 0xff978346, 0xff6e6f61, 0xff848450, 0xffd1d818, 0xffe9f307, 0xfff3f903, 0xffd6a71d, 0xffb75633, 0xff99064a, 0xff97014b, 0xff980049, 0xff9b014a, 0xffb20152, 0xffd80061, 0xffec0069, 0xffec0e65, 0xffe93e51, 0xffea6a45, 0xfff0c61c, 0xfff1e20b, 0xffeded01, 0xffe7df00, 0xffdac301, 0xffd3ba00, 0xffd4b502, 0xffd8b801, 0xffe9c201, 0xffeec700, 0xffdeb215, 0xffb69a2d, 0xff736d5d, 0xff7c7d53, 0xffc9d11c, 0xffd8b01a, 0xffba632e, 0xff9b094a, 0xff970149, 0xff9c004a, 0xffa2014d, 0xffb70053, 0xffc5005a, 0xffe10063, 0xffe70068, 0xffed026b, 0xffed2959, 0xffec7638, 0xffeca726, 0xfff3eb0c, 0xfff3f702, 0xfff3fa00, 0xffeff300, 0xffe5db00, 0xffddca01, 0xffd2b501, 0xffcdaf00, 0xffcdaf03, 0xffcfb101, 0xffdbbc00, 0xffe3c300, 0xfff4c600, 0xfff9c801, 0xffe9b90d, 0xffc8a525, 0xff7a7357, 0xff757559, 0xffbdc522, 0xffdfe90c, 0xffe4cb0e, 0xffcc8720, 0xff9f1246, 0xff99034b, 0xffa1004c, 0xffb60053, 0xffc6005a, 0xffe20064, 0xffe7016b, 0xffed235d, 0xffe96e45, 0xffed9c30, 0xfff3e309, 0xfff4f303, 0xfff1fa01, 0xfff0f401, 0xffe5dd00, 0xffddce03, 0xffd2b500, 0xffcfaf02, 0xffcbaa03, 0xffccaa02, 0xffccab00, 0xffccaa00, 0xffcdad00, 0xffd1b000, 0xffdfbc02, 0xffeac201, 0xfff6c600, 0xfffbc702, 0xfff8c104, 0xffe6b512, 0xff928246, 0xff77715b, 0xffb5bd29, 0xffdbe40d, 0xffe7d80b, 0xffd09b19, 0xffa11842, 0xff9a044b, 0xff98004d, 0xffa60150, 0xffae0153, 0xffce035c, 0xffda0764, 0xffeb2e56, 0xffec5246, 0xffecac24, 0xffefd216, 0xfff5f605, 0xffefef01, 0xffe9e402, 0xffddc700, 0xffd5bc00, 0xffcdaf01, 0xffcbab00, 0xffd4b401, 0xffdcba01, 0xffecc402, 0xfff5c702, 0xffedba09, 0xffa58d37, 0xff807557, 0xff67656a, 0xff6c6e60, 0xffa3aa38, 0xffcdd61b, 0xfff3fe02, 0xffebe50b, 0xffd7af1a, 0xffa32442, 0xff990849, 0xff98014e, 0xff9a024b, 0xff9c064e, 0xffb22746, 0xffc4483e, 0xffe8a028, 0xfff1ca15, 0xfff4f504, 0xffedf001, 0xffe9e500, 0xffdac700, 0xffd5bb04, 0xffcead00, 0xffcdab01, 0xffd6b603, 0xffeec602, 0xfff6c800, 0xfff9c203, 0xffc8a223, 0xff9d8642, 0xff696961, 0xff6a6b63, 0xffc7ce20, 0xfff2fc05, 0xffece908, 0xffd9b813, 0xffa72d3c, 0xff9c0c47, 0xff98024c, 0xff9c0749, 0xff9e1648, 0xffbc5838, 0xffd08424, 0xffecd40e, 0xfff3ec06, 0xfff2fb00, 0xfff0f602, 0xffe4df01, 0xffdfd001, 0xffd1b700, 0xffcfb000, 0xffccac03, 0xffe3c100, 0xffedc501, 0xfff9c802, 0xffd6ac18, 0xffac9136, 0xff6f6c5d, 0xff909342, 0xffbcc126, 0xffe6d50b, 0xffb24934, 0xffa11846, 0xff9b064a, 0xff9f1149, 0xffb34536, 0xffc0722a, 0xffe0cd11, 0xffece707, 0xfff2f300, 0xffdfd100, 0xffd4b701, 0xffd1b001, 0xffcbab02, 0xffd0b101, 0xffd5b500, 0xffe4c302, 0xffeeba0c, 0xffd1a71f, 0xff807653, 0xff6c6960, 0xff8a8d48, 0xffb4b929, 0xffedf607, 0xfff2f804, 0xffe8de0b, 0xffb65534, 0xffa11e46, 0xffa93043, 0xffc98524, 0xffd8af15, 0xffeeed09, 0xffedf200, 0xffe9e800, 0xffdbca00, 0xffd5bd01, 0xffceae01, 0xffcfaa01, 0xffccac01, 0xffd9ba00, 0xffe2bf01, 0xfff2c601, 0xfff8c701, 0xfff5bf07, 0xffdeb015, 0xff8d7d4c, 0xff7c7f54, 0xff9da23b, 0xfff1fc02, 0xffede806, 0xffbc6d2a, 0xffa62d3c, 0xff980249, 0xff9d1249, 0xffa5253e, 0xffc07029, 0xffd2a11e, 0xffece801, 0xffdecb03, 0xffd7c000, 0xffccac00, 0xffcfae00, 0xffdabb01, 0xfff4c601, 0xfffbc407, 0xfff1bd09, 0xffab9134, 0xff847850, 0xff787957, 0xffe2ed0b, 0xfff2fb02, 0xfff0ec04, 0xffc78121, 0xffae3b38, 0xff97044b, 0xff97004f, 0xff99034a, 0xff9a094a, 0xffa83240, 0xffb75b32, 0xffe5d40b, 0xfff2f800, 0xfff1f701, 0xffe7e401, 0xffe0d500, 0xffd4ba01, 0xffd0b300, 0xffcaaa00, 0xffcba900, 0xffd1b200, 0xffdab800, 0xffeac200, 0xfff7c204, 0xff918048, 0xff71735d, 0xffdbe40f, 0xffeef804, 0xffd3a51c, 0xffb45634, 0xff9a074b, 0xff9c074b, 0xffa92940, 0xffb54b31, 0xffd4a51b, 0xffe2cd10, 0xfff2f802, 0xffeae301, 0xffe1d600, 0xffd5bb02, 0xffcdad02, 0xffd3b401, 0xffecc400, 0xfff3c702, 0xfffcc602, 0xffdbb016, 0xff6f705e, 0xff888a4b, 0xffd7de14, 0xffd7ad19, 0xffb86030, 0xff9c1246, 0xffa01846, 0xffba5d34, 0xffcd8a21, 0xffeeed05, 0xffeff500, 0xffebeb00, 0xffe0cf03, 0xffd6c200, 0xffd0b003, 0xffe0bf02, 0xffe8c400, 0xfff7c701, 0xfffac503, 0xffe7b70d, 0xffc39f25, 0xff787356, 0xff7a7c55, 0xffc8cf1f, 0xffe2c90c, 0xffcc911b, 0xffbc5c2c, 0xffc47725, 0xffe3cf10, 0xffeceb05, 0xfff4fd02, 0xfff1f500, 0xffeded00, 0xffd9c200, 0xffcfae01, 0xffd2b301, 0xffebc301, 0xfff2c208, 0xffe0b413, 0xff918146, 0xff746f5b, 0xffecde09, 0xffdeb711, 0xffd69d1a, 0xffddb714, 0xffeae601, 0xffe3d802, 0xffd6bd01, 0xffd1b400, 0xffd7b702, 0xffe0bd03, 0xffebc302, 0xffe5ba09, 0xff9f893e, 0xff73725e, 0xffb6b92a, 0xffdae310, 0xfff3f402, 0xfff3f202, 0xfff4f803, 0xffeaea00, 0xffe4d903, 0xffd5be00, 0xffcba901, 0xffd0af00, 0xffd7b700, 0xffd9b906, 0xffb49e27, 0xff8f8446, 0xff706e61, 0xffadaf34, 0xffd3db16, 0xfff1f700, 0xffeeee00, 0xffe0d501, 0xffdbc404, 0xffcaaa01, 0xffd0b204, 0xffb39f24, 0xff918740, 0xff999c41, 0xffc5cd20, 0xfff2f600, 0xffeff000, 0xffdac701, 0xffd1b202, 0xffcca903, 0xffc8a805, 0xffbe9f11, 0xffb2991b, 0xff90833f, 0xff7b7754, 0xff939743, 0xffc0c624, 0xfff0fa03, 0xfff1fb00, 0xffd8c103, 0xffd1b702, 0xffcdac00, 0xffcdab03, 0xffc7a706, 0xffc0a30a, 0xffa89225, 0xff988735, 0xff7b7253, 0xff696864, 0xff898b4a, 0xffb4b82f, 0xffe7df02, 0xffc6a606, 0xffbfa10d, 0xffa59027, 0xff958436, 0xff787155, 0xff6e6c5f, 0xff666863, 0xffa7aa39, 0xffe6eb08, 0xffedf003, 0xffdccb02, 0xffcea902, 0xffcba802, 0xffb89f11, 0xffab9621, 0xff8a7e42, 0xff7d7550, 0xff6a6a60, 0xff8b8c48, 0xffc9c116, 0xffd2c308, 0xffd1b303, 0xffcfaf04, 0xffcea903, 0xffcaa902, 0xffb89c14, 0xffaa9323, 0xff887d45, 0xff797353, 0xff6c6d5f, 0xff7c7a51, 0xffaca026, 0xffb9a715, 0xffc7aa08, 0xffc4a608, 0xffbba013, 0xff9f8c2d, 0xff8f803b, 0xff746f59, 0xff6d6b5f, 0xff777255, 0xff84794b, 0xffa18d2a, 0xffad971d, 0xffc3a509, 0xffc9a805, 0xffc3a40b, 0xffba9f14, 0xff9b8a2e, 0xff8b8040, 0xff736e5a, 0xff6c6a5e, 0xff706d5c, 0xff867b45, 0xff92843b, 0xffb0981a, 0xffbca011, 0xffc9a803, 0xffb1991b, 0xffa28f29, 0xff81794a, 0xff767056, 0xff6b6764, 0xff66656a, 0xff7e764f, 0xff8d7f40, 0xffab951e, 0xffb99e13, 0xffc8a607, 0xffc9aa02, 0xffc7a802, 0xffaf961f, 0xff7f764d, 0xff747057, 0xff666762, 0xff6e6c5d, 0xff91833c, 0xffa18d2c, 0xffba9f10, 0xffc2a30a, 0xffc9a801, 0xffcbaa00, 0xffcaac00, 0xffcaa904, 0xffbfa10b, 0xffb59a17, 0xff968533, 0xff857b46, 0xff716b5d, 0xff746e58, 0xff897f44, 0xff998731, 0xffb69b16, 0xffc1a20c, 0xffbda20d, 0xffb2991a, 0xff93823a, 0xff85784b, 0xff6b6863, 0xff75705a, 0xff80774e, 0xff9e8b2d, 0xffae951f, 0xffc2a50b, 0xffc7a704, 0xffc1a40b, 0xffaa9321, 0xff988830, 0xff7c7450, 0xff726d5a, 0xff706d5a, 0xff7a7454, 0xff958635, 0xffa59023, 0xffbca10c, 0xffc4a606, 0xffc0a20e, 0xffa69126, 0xff978435, 0xff8c7e41, 0xffb69b18, 0xffc6a605, 0xffc8a606, 0xffbb9e12, 0xffae9521, 0xff8b803e, 0xff7a7055, 0xff847a49, 0xffa48e2b, 0xffb1981a, 0xffc5a409, 0xffa99222, 0xff887e43, 0xff69695f, 0xff877c44, 0xff968736, 0xffb59a19, 0xffc6a508, 0xffa08e2c, 0xff90823b, 0xff757158, 0xff6e6a5e, 0xff83784a, 0xff8d833c, 0xffc2a408, 0xffba9d11, 0xff9c8c2d, 0xff8c8141, 0xff716f58, 0xff777254, 0xff928439, 0xffa48e28, 0xffbe9f10, 0xffc5a505, 0xffb49918, 0xffa68f27, 0xff857947, 0xff6d695e, 0xff928537, 0xffaa9520, 0xffc0a10b, 0xffb4981a, 0xff857b48, 0xff686669]
				); 
        }
		public function box2():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,2,2,0,0,3,4,3,5,6,7,8,9,10,11,12,13,14,3,15,16,0,15,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,18,0,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,18,18,34,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,0,0,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,16,0,1,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,3,0,51,52,53,54,55,56,57,58,59,60,61,61,62,63,64,65,66,67,68,69,19,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,70,21,71,72,73,74,75,76,77,78,79,80,81,80,62,82,83,84,85,86,87,88,33,16,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,19,1,34,17,34,0,16,0,1,3,0,3,0,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,61,61,106,107,108,109,110,111,112,14,17,16,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,0,0,0,1,1,3,0,0,0,16,3,113,114,115,116,117,118,119,120,121,122,123,45,124,125,126,127,128,129,130,80,131,132,133,134,135,136,137,138,139,140,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,16,140,70,89,141,115,142,143,144,145,146,121,147,148,149,150,151,152,153,154,155,156,157,158,62,62,81,61,159,160,161,162,163,164,165,166,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,3,0,0,0,0,0,3,167,168,71,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,62,61,62,61,189,190,191,192,193,110,194,195,4,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,3,0,3,5,196,197,198,199,200,201,202,203,44,78,45,204,205,206,207,208,209,210,211,212,213,214,213,215,216,217,130,130,130,79,218,219,220,221,222,223,224,225,226,113,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,227,6,228,229,230,231,232,233,28,234,99,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,99,130,130,80,252,253,161,221,254,255,256,257,258,259,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [3,0,0,70,20,260,91,261,262,263,264,265,266,104,131,267,268,269,270,271,272,273,274,275,276,277,278,278,278,278,278,277,279,280,281,282,62,61,131,283,284,221,285,222,191,223,286,287,288,89,16,1,1,0,0,0,0,0,0,0,0,0,0,0], 
    [3,1,19,52,53,289,117,290,291,292,293,45,104,294,295,296,297,298,299,300,301,302,303,245,304,305,305,278,278,278,278,277,306,307,308,99,62,62,61,309,310,311,162,222,312,220,313,314,225,315,316,3,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,113,317,318,319,320,321,322,45,132,64,323,324,325,326,327,328,329,330,213,305,331,278,278,278,305,305,278,278,278,278,278,332,333,334,335,130,62,62,336,337,338,221,162,312,162,162,339,340,341,342,5,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,343,344,345,346,44,78,104,177,347,348,349,350,351,352,353,354,276,244,277,305,278,247,278,355,355,331,278,278,278,278,278,356,357,358,335,130,81,62,359,360,338,221,192,312,221,191,223,361,362,363,113,14,0,0,0,0,0,0,0,0,0,0,0], 
    [16,364,365,366,367,81,176,368,369,370,371,372,373,374,375,376,214,355,331,246,245,305,305,355,278,214,355,278,278,278,278,278,214,377,378,379,62,81,62,83,380,381,221,162,285,220,221,285,312,382,383,384,32,0,0,0,0,0,0,0,0,0,0,0], 
    [0,364,385,386,367,81,177,387,388,389,390,330,391,355,305,277,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,392,393,394,395,61,81,62,46,252,396,397,398,398,398,398,398,162,399,400,401,402,33,3,0,0,0,34,0,0,0,0,0], 
    [0,364,385,386,367,82,64,403,404,405,406,355,355,305,305,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,407,408,409,410,45,81,62,411,412,396,285,398,398,398,398,398,312,413,255,414,415,416,417,14,0,0,0,0,0,0,0,0], 
    [0,364,385,386,367,61,418,419,420,421,422,423,331,331,331,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,392,424,425,426,45,81,130,411,283,427,285,398,398,398,398,398,161,162,312,428,429,430,431,3,1,1,0,0,0,0,0,0], 
    [0,364,385,386,367,99,100,432,433,434,435,436,406,407,437,305,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,438,439,440,235,62,130,132,441,442,443,398,398,398,398,398,192,191,192,444,445,446,447,448,14,16,34,0,0,0,0,0], 
    [0,364,385,386,367,81,45,449,450,451,452,453,454,455,456,331,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,278,355,457,458,459,235,62,62,82,460,160,461,398,398,398,398,398,220,221,312,161,462,314,463,464,33,16,34,0,0,0,0,0], 
    [0,6,198,145,465,466,45,467,468,469,470,471,472,473,474,437,305,278,278,305,278,278,278,278,278,278,278,278,278,278,278,278,475,476,477,478,103,81,81,61,479,480,338,161,398,161,398,220,398,398,398,398,398,286,481,482,483,0,0,0,0,0,0,0], 
    [3,484,485,486,487,62,45,488,468,469,489,490,471,491,492,493,456,278,278,305,494,278,278,278,278,278,278,278,278,278,278,278,355,495,496,497,498,62,62,61,411,499,500,220,398,161,398,220,398,398,398,398,398,501,502,503,504,3,0,0,0,0,0,0], 
    [3,167,505,506,507,80,45,488,508,469,489,489,509,510,511,492,512,305,305,305,214,278,278,278,278,278,278,278,278,278,278,278,278,513,514,515,516,62,62,130,411,517,518,220,285,161,398,285,398,398,398,398,398,313,519,520,521,0,34,0,0,0,0,0], 
    [0,35,522,523,524,81,235,525,526,527,489,528,509,509,529,530,531,532,456,305,305,278,278,278,278,278,278,278,278,278,278,278,305,533,534,187,535,62,62,62,411,536,537,220,285,161,398,398,398,398,398,398,398,222,538,539,540,3,17,0,0,0,0,0], 
    [0,35,522,506,541,62,235,542,543,544,528,545,509,509,509,546,547,548,549,437,305,278,278,278,278,278,278,278,278,278,278,278,305,550,373,551,552,62,62,61,106,553,554,285,220,398,398,398,398,398,398,398,398,162,399,555,556,16,557,0,0,0,0,0], 
    [0,167,71,558,146,62,147,559,560,561,528,562,562,509,509,562,546,563,564,565,423,278,278,278,278,278,278,278,278,278,278,278,407,566,215,567,568,62,61,62,132,569,570,285,220,398,398,398,398,398,398,398,398,162,571,572,573,5,0,0,0,0,0,0], 
    [0,35,522,506,574,575,45,576,577,561,509,509,509,509,509,509,509,578,579,580,581,423,407,278,278,407,305,278,278,278,331,437,475,245,582,583,584,61,62,62,82,189,585,285,191,161,285,161,398,398,398,398,398,162,313,586,447,5,0,0,0,0,0,0], 
    [0,35,522,506,574,575,176,587,577,588,562,509,509,509,509,509,509,589,590,591,564,592,423,278,278,278,305,331,593,278,278,594,595,244,596,597,598,99,62,81,61,218,599,285,191,161,398,161,398,398,398,398,398,221,313,600,601,69,0,0,0,0,0,0], 
    [0,35,522,506,574,130,104,559,577,602,589,509,509,509,509,509,509,509,545,490,603,604,605,423,247,278,305,278,355,305,606,606,392,607,608,609,610,99,81,62,61,611,499,285,312,161,398,161,398,398,398,398,398,312,444,612,613,483,14,0,0,0,0,0], 
    [0,35,522,506,574,130,45,614,615,616,589,509,509,509,509,509,589,509,509,489,617,618,619,620,456,305,305,246,278,305,277,303,621,622,623,624,625,99,81,62,61,626,627,285,161,398,191,161,398,398,398,398,398,161,162,628,629,431,630,0,0,0,0,0], 
    [0,35,522,506,574,81,235,631,632,633,470,509,509,509,509,509,562,509,489,509,509,634,635,636,637,493,638,639,640,641,642,643,644,645,646,426,647,130,81,130,62,648,649,650,398,161,191,191,398,398,398,398,398,220,221,651,652,521,630,0,0,0,0,0], 
    [0,35,522,506,507,62,132,653,654,655,470,589,509,562,562,656,657,489,658,528,528,489,617,659,660,661,662,663,664,665,666,667,668,669,670,235,130,130,81,130,61,671,672,673,398,220,398,220,398,398,398,398,398,398,221,674,164,675,35,0,1,0,0,0], 
    [0,35,522,506,507,130,99,676,677,678,679,509,509,489,489,545,680,681,682,489,470,469,683,684,685,686,687,688,689,690,691,294,335,62,62,130,575,61,104,692,693,694,695,696,162,162,220,192,398,398,398,398,398,191,191,697,698,699,483,0,1,0,0,0], 
    [0,35,522,506,507,575,104,700,677,701,656,509,681,509,509,509,489,509,528,702,703,704,705,706,707,708,709,710,711,712,98,148,130,62,62,80,131,46,713,714,715,716,717,718,719,162,162,222,398,398,398,398,398,161,191,720,721,722,723,0,0,0,0,0], 
    [0,35,522,506,507,724,148,725,726,727,470,509,509,509,681,589,728,729,730,731,732,733,734,735,736,737,294,61,61,62,130,61,82,100,738,739,740,741,742,743,744,745,746,747,748,749,162,221,398,398,398,398,398,162,221,750,382,751,752,16,0,0,0,0], 
    [0,35,522,506,507,62,45,753,754,755,634,489,489,682,682,756,757,758,759,760,761,762,763,737,100,61,62,62,62,61,99,235,692,764,765,766,767,768,769,770,771,772,773,774,747,775,776,162,398,398,398,398,398,312,285,313,777,778,779,16,0,0,0,0], 
    [0,167,522,506,524,130,130,780,781,782,783,784,785,786,787,788,789,790,791,792,793,131,61,62,62,62,61,132,794,795,796,797,798,799,800,801,802,803,803,803,803,803,803,773,804,805,806,221,221,161,398,191,191,191,191,222,807,808,809,16,0,3,0,34], 
    [0,167,522,810,524,61,130,811,812,813,814,815,816,817,818,819,820,821,737,176,131,575,130,130,62,61,822,823,824,825,741,826,827,828,829,773,803,803,803,803,803,803,803,830,802,831,832,833,834,161,162,221,398,398,312,222,571,835,836,5,0,3,0,34], 
    [0,167,837,838,839,61,61,840,841,842,843,844,845,846,29,822,61,80,130,575,131,99,177,713,847,848,849,850,851,852,770,771,853,773,772,854,854,803,803,803,803,803,803,772,772,802,855,856,857,858,162,221,162,162,859,162,750,860,288,5,34,3,0,0], 
    [0,5,260,861,862,123,61,863,864,865,866,867,868,177,99,62,81,80,80,61,104,869,870,871,872,873,874,855,770,830,830,875,854,854,854,854,772,803,803,803,803,803,803,772,772,854,802,876,877,878,879,312,221,312,413,221,313,880,881,630,882,3,0,1], 
    [0,5,260,883,862,62,81,61,61,176,99,575,130,62,62,61,104,884,885,886,887,888,889,890,891,771,772,830,830,772,772,772,803,892,803,772,772,803,803,803,803,803,803,893,854,854,854,894,895,896,897,834,162,221,398,312,162,898,899,483,34,0,0,0], 
    [0,5,260,900,862,130,575,62,130,81,62,61,63,61,61,901,902,903,904,905,906,769,907,773,803,854,854,772,772,908,892,803,854,892,772,772,803,803,803,803,803,803,803,893,893,772,772,773,894,909,910,749,220,162,220,192,162,911,912,166,3,1,882,16], 
    [0,167,260,883,913,62,62,130,575,61,61,46,738,914,871,915,873,800,916,917,918,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,919,920,921,775,221,192,162,162,922,923,924,5,0,1,0], 
    [0,35,925,926,927,81,62,130,575,46,928,739,929,741,888,930,890,802,773,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,772,803,770,931,932,933,192,162,162,934,935,936,70,0,1,0], 
    [3,5,260,345,862,822,937,764,938,939,940,941,942,770,771,803,803,772,772,803,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,854,803,772,943,944,945,946,162,162,445,947,948,196,0,0,19], 
    [0,5,260,949,950,951,914,952,953,954,800,943,894,773,830,772,892,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,854,772,772,802,955,956,957,834,221,958,959,556,960,0,0,19], 
    [1,70,961,962,963,964,965,852,894,771,772,772,772,772,803,966,803,803,803,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,772,803,771,967,968,957,969,970,971,972,464,34,1,0], 
    [0,0,484,973,974,975,976,977,772,803,978,772,854,979,803,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,976,855,877,980,981,982,983,521,0,3,1], 
    [3,0,4,483,984,985,986,987,988,803,772,875,830,772,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,966,803,769,989,897,990,991,992,0,0,3], 
    [993,1,0,5,994,995,996,997,998,830,830,803,803,803,803,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,999,772,770,1000,1001,1002,1003,1004,0,1,0], 
    [0,19,0,1,1,33,1005,1006,1007,1008,987,979,803,772,803,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,830,979,772,977,1000,1009,1010,1011,33,0,3], 
    [1,0,0,993,993,15,0,1012,1013,1014,1015,1016,830,772,772,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,1017,999,1018,1019,918,1020,1021,1022,1023,0,557], 
    [0,0,0,0,0,0,3,16,113,1024,1025,1026,1027,908,1018,803,830,966,966,875,830,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,979,803,772,803,892,908,803,772,772,854,830,803,854,772,908,1018,1028,1029,1030,1031,1032,1033,1034,1035,34,0,0], 
    [0,0,0,0,0,0,3,0,3,1036,1037,1038,1039,1040,1041,772,979,803,803,978,978,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,854,854,772,892,803,803,803,892,803,803,999,803,1019,1042,1043,1044,1045,1046,1047,1048,1049,1050,32,113,0,0,19], 
    [0,0,0,0,0,1051,0,0,3,0,5,32,1052,1053,1054,1055,908,803,854,908,1018,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,772,772,803,772,854,803,772,854,1042,1042,1056,1057,1031,1058,1059,1060,1061,1062,1063,1064,630,5,0,0,16,16,17], 
    [0,0,0,0,0,15,3,15,15,0,17,69,960,1065,1066,1067,987,875,854,772,908,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,830,830,830,830,1042,1041,1068,1027,1069,1070,1071,1072,1073,1074,166,1075,630,19,0,34,15,0,3,0,34], 
    [0,0,0,0,0,0,34,3,3,0,0,0,3,316,1076,1077,1078,1079,1055,1080,772,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,908,908,988,1081,1082,1083,1084,1085,1086,1062,936,114,69,3,0,34,34,0,0,1,1,1,1,0,0,3], 
    [0,0,0,0,0,0,1,16,0,18,16,34,34,630,113,1087,1088,1089,1090,875,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,803,1091,987,1092,1030,1093,1094,1095,1049,1096,1097,196,1098,19,1,0,0,3,0,0,3,1,1,0,16,0,0,19], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,1099,1100,1101,1102,1103,893,875,875,830,803,830,772,803,772,772,772,908,1104,1105,1082,1106,1107,1108,1109,1110,936,1111,1112,630,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,723,1113,1114,1115,1116,1042,854,803,772,771,854,830,1018,1017,987,1117,1030,1118,1119,1120,1121,1122,1123,1124,33,5,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,630,33,936,1125,1126,1102,1104,893,1042,1042,1127,1128,1129,1130,1131,1085,1110,1024,1132,1133,70,5,0,18,19,1134,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,3,69,1097,1135,1136,1128,1055,1137,1128,1138,986,1139,1140,1141,1142,166,1064,5,5,0,0,0,34,34,17,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,17,34,16,3,1143,1144,1114,1145,1146,1147,1113,936,1133,113,5,0,0,3,18,0,1,1,0,0,0,0,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666668, 0xff666563, 0xff666664, 0xff666762, 0xff676765, 0xff6c6c62, 0xff71705e, 0xff818351, 0xff939743, 0xffc9ce1a, 0xffd8db12, 0xffa2993a, 0xff7d7954, 0xff676664, 0xff676568, 0xff676566, 0xff656764, 0xff656565, 0xff676767, 0xff686963, 0xff6c6c60, 0xff787959, 0xff83864f, 0xffa3a63b, 0xffb2b830, 0xffd2da15, 0xffe1e80e, 0xffeff704, 0xfff0f304, 0xffd3bb1b, 0xffad9734, 0xff706d5c, 0xff686763, 0xff656766, 0xff686964, 0xff696a62, 0xff757559, 0xff7e8051, 0xff999e40, 0xffabb030, 0xffccd51a, 0xffdae211, 0xffeaf505, 0xffeff902, 0xfff3fc01, 0xfff3fa00, 0xffe7c90f, 0xffcaaa21, 0xff827553, 0xff6f6b60, 0xff676862, 0xff6e6f5f, 0xff76765a, 0xff8d8e4a, 0xff9ba03c, 0xffbfc525, 0xffcfd51b, 0xffe6ef0c, 0xffebf606, 0xfff1fc02, 0xfff4fe00, 0xfff5ff00, 0xfff7fe01, 0xfff4f801, 0xfff7d803, 0xfff0c507, 0xffb8992d, 0xff907f49, 0xff696864, 0xff676863, 0xff74745c, 0xff88874e, 0xff949545, 0xffb7bd29, 0xffc7ce1e, 0xffe2ea0b, 0xffeaf209, 0xfff2fd03, 0xfff2fd00, 0xfff3ff00, 0xfff4ff00, 0xfff6fd00, 0xfff4f900, 0xfff8da00, 0xfff9c903, 0xffd4ab1d, 0xffae9135, 0xff736c5c, 0xff696a64, 0xff6c6d5f, 0xff7a7c55, 0xff87884e, 0xffa6ab35, 0xffbabf27, 0xffd6df12, 0xffe3eb0c, 0xfff0f804, 0xfff2fb02, 0xfff4fd02, 0xfff4fa02, 0xfff1ef07, 0xfff1ed06, 0xfff4f805, 0xfff3fd00, 0xfff5fe03, 0xfff6fb00, 0xfffcde00, 0xfffdcf00, 0xfff5c109, 0xffe6b510, 0xff9a863f, 0xff787258, 0xff696863, 0xff6b6b61, 0xff777858, 0xff83834f, 0xff9da23c, 0xffafb52f, 0xffcfd918, 0xffdfe60d, 0xffedf605, 0xfff1fa03, 0xfff3fe02, 0xfff4f207, 0xfff2e80d, 0xffeac419, 0xffeabe1f, 0xfff0e70e, 0xfff3f905, 0xfff5ff01, 0xfff3fe00, 0xfff5fc00, 0xfffae100, 0xfffdd100, 0xfffac503, 0xfff2c00b, 0xffba9a2d, 0xff918048, 0xff6c6865, 0xff686667, 0xff70725d, 0xff909346, 0xffa0a33a, 0xffc2c921, 0xffd2d917, 0xffe7f107, 0xfff3fc03, 0xfff6fd02, 0xfff4f803, 0xfff4f008, 0xfff1d512, 0xffefbd1c, 0xffeb8835, 0xffe86a44, 0xffe7345b, 0xffe23d5f, 0xffe8ba29, 0xfff0ec0e, 0xfffae800, 0xfffdd501, 0xffffc500, 0xfffec601, 0xffebb90c, 0xffcda720, 0xff827952, 0xff6f6b5f, 0xff686866, 0xff6d6e60, 0xff8a8c4d, 0xff989c3e, 0xffbcc127, 0xffccd11d, 0xffe5eb0b, 0xffedf408, 0xfff1fc00, 0xfff2fd01, 0xfff4fb00, 0xfff4f504, 0xffefdd0f, 0xfff0c818, 0xffec932f, 0xffec703c, 0xffea3c53, 0xffea275f, 0xffeb106a, 0xffe92169, 0xffebb12b, 0xfff1e80d, 0xfff8eb00, 0xfffad701, 0xffffc602, 0xffffc603, 0xfff7c004, 0xff9b8740, 0xff7d7358, 0xff6a6a62, 0xff6e6f5d, 0xff7e7f53, 0xff8b8e49, 0xffacb131, 0xffbdc325, 0xffdbe40f, 0xffe6ec0c, 0xfff6fa03, 0xfff3eb0c, 0xfff1dd0d, 0xffeeb125, 0xffec9335, 0xffea534c, 0xffea3755, 0xffed1566, 0xffee0b67, 0xffef026a, 0xfff1016c, 0xffef1762, 0xfff3a626, 0xfff4e40b, 0xfff7eb00, 0xfffad902, 0xfffec600, 0xffffc702, 0xfffec502, 0xfffbc501, 0xffd6ac18, 0xffb09431, 0xff726c5e, 0xff686961, 0xff797b54, 0xff84874e, 0xffa3a736, 0xffb6bb2b, 0xffd4dd14, 0xffdfe90c, 0xfff1fb04, 0xfff5fc01, 0xfff4ed07, 0xfff4e30f, 0xffebbd1f, 0xffeba222, 0xffe96147, 0xffeb4752, 0xffec1a65, 0xffed0f66, 0xffee036c, 0xfff1026a, 0xfff0006f, 0xffee016d, 0xfff2036b, 0xffef1464, 0xfff39d26, 0xfff5dd0b, 0xfff6ec01, 0xfff9d703, 0xfffec504, 0xfffdc401, 0xffebb80d, 0xffcea620, 0xff817753, 0xff6d6a63, 0xff71735d, 0xff949642, 0xffa4a935, 0xffc7ce1c, 0xffd6df16, 0xffebf109, 0xffeff807, 0xfff5f404, 0xfff4ec05, 0xfff0d315, 0xffecb91f, 0xffeb7537, 0xffeb5a47, 0xffe82c5e, 0xffea1d62, 0xffee086b, 0xffef046b, 0xfff1016e, 0xfff0006d, 0xfff00d67, 0xffe87c34, 0xffecc714, 0xfff7fc00, 0xfff8ee01, 0xfffadc00, 0xffffc700, 0xfff3bf09, 0xffbb9b2c, 0xff928246, 0xff8f9148, 0xffc0c624, 0xffd0d61c, 0xffe7ee0a, 0xffeff306, 0xfff4fa04, 0xfff2f506, 0xfff3d80d, 0xfff1c117, 0xffeb8e31, 0xffe76c40, 0xffe92f54, 0xffec1e5f, 0xffec0b69, 0xffed056b, 0xffee0169, 0xfff0006b, 0xffed096a, 0xffe16b43, 0xffe8bd20, 0xfff8f102, 0xfffbdf00, 0xffffc803, 0xffffc501, 0xfffdc403, 0xffd9ad18, 0xff706f5d, 0xff696961, 0xff74735e, 0xffa5aa36, 0xffbec426, 0xffdde60f, 0xffe7f00d, 0xfff2fb04, 0xfff4e70c, 0xfff2d610, 0xfff1a825, 0xffed8e34, 0xffe84c4f, 0xffed3056, 0xffef1164, 0xffee0a69, 0xfff1006b, 0xffed046d, 0xffe75955, 0xffebaf2a, 0xfff5fb03, 0xfff8f601, 0xfffbe601, 0xffffca02, 0xfff5c205, 0xffe6b60e, 0xff9e883f, 0xff7e7556, 0xff6a6b63, 0xff7a7c57, 0xffc1c820, 0xffdce510, 0xfff3ec06, 0xfff1e00a, 0xffedb721, 0xffed972a, 0xffed5844, 0xffec4153, 0xffeb1964, 0xffed0d65, 0xfff1006d, 0xffef046d, 0xffed5552, 0xfff1ac2a, 0xfff6f801, 0xfffaea01, 0xfff4c106, 0xffbd9c28, 0xff968243, 0xff6b6d60, 0xff7f814f, 0xffd3da18, 0xffecf506, 0xfff0e210, 0xffebc11d, 0xffeb7239, 0xffe95547, 0xffe92861, 0xffec1865, 0xfff00669, 0xfff00469, 0xfff10069, 0xfff14c4a, 0xfff4a224, 0xfff5f902, 0xfff7eb01, 0xfffecb00, 0xffecba0b, 0xffcfa81f, 0xff857a4d, 0xff808253, 0xffd3db16, 0xffe8c11b, 0xffe18637, 0xffe63056, 0xffeb1c62, 0xffee066c, 0xffef026c, 0xfff1414b, 0xfff19228, 0xfff4f501, 0xfffdcd01, 0xfffec901, 0xffffc600, 0xfff8c007, 0xffe7b70f, 0xffa0883e, 0xff7f7454, 0xffdd9c1c, 0xffca4b3c, 0xffd3045c, 0xffdf0166, 0xffee016b, 0xffe62a5c, 0xffe37041, 0xfff0ed08, 0xfff5fa00, 0xfff7ed00, 0xffffc502, 0xffdbae17, 0xffb59530, 0xff756e5c, 0xff696866, 0xfff3f702, 0xffd89c18, 0xffbd4834, 0xffbf0357, 0xffcf005f, 0xffec016a, 0xffe52268, 0xffe1624f, 0xfff0eb0d, 0xfffece00, 0xffeeb90b, 0xffd0a61e, 0xff85784e, 0xff706c60, 0xffd7a619, 0xffb55034, 0xffa0034a, 0xffa9014e, 0xffce015e, 0xffef006a, 0xffec196a, 0xffeb5556, 0xfff4e70d, 0xfff8f301, 0xfffed200, 0xffffc800, 0xfffdc500, 0xfff3bf07, 0xffbd9c29, 0xff978346, 0xff6c6964, 0xffd7ab17, 0xffb65232, 0xff9d034b, 0xff9e004d, 0xffbc0158, 0xffd0005e, 0xffeb0069, 0xffed006a, 0xffef1865, 0xfff0524f, 0xfff4e50e, 0xfff7f500, 0xffffca00, 0xfffcc300, 0xffb29531, 0xff726c5c, 0xffebf508, 0xfff7fe00, 0xffd8ab1a, 0xffb65333, 0xff99034a, 0xff99014a, 0xff9e004b, 0xffab004f, 0xffcc015d, 0xffde0063, 0xfff2006e, 0xfff11461, 0xfff0454b, 0xfff3d80b, 0xfff7f900, 0xfffcd901, 0xffdaaf15, 0xff857752, 0xff6d6a61, 0xff6b6b63, 0xff7c7c56, 0xffcdd61b, 0xffeaf408, 0xffd8ac18, 0xff980049, 0xff9b014a, 0xffb80056, 0xffcb005c, 0xffe90069, 0xffef026e, 0xffef1063, 0xffec3851, 0xfff0cd11, 0xfff4f305, 0xfffad900, 0xfffecb02, 0xfff9c205, 0xffe4b50f, 0xff8d7d4a, 0xff706d5e, 0xff75755d, 0xffc7cd21, 0xffe8f10a, 0xffb65334, 0xff98004b, 0xff9d004d, 0xffa6004f, 0xffdd0062, 0xffec076c, 0xffe62369, 0xffe9b625, 0xfff0eb09, 0xfffbda01, 0xffffcc01, 0xffefba0a, 0xff978543, 0xff746f5c, 0xff72745c, 0xffc6cc22, 0xffe7f00b, 0xffd7ad1b, 0xffb45537, 0xff99034b, 0xff970149, 0xff9b004c, 0xffb60053, 0xffc9005c, 0xffe80068, 0xffec056d, 0xffe71e6c, 0xffefea0c, 0xfffcdb00, 0xffffcc00, 0xfff1bd09, 0xff9d8a3e, 0xff777159, 0xffe7f009, 0xffd2b221, 0xffb05b3e, 0xff98044e, 0xff9a004b, 0xff9c004c, 0xffa5004f, 0xffc50058, 0xffd80061, 0xfff0036d, 0xfff3aa27, 0xfff5e60d, 0xfffce001, 0xfffed000, 0xffb2952f, 0xff86794d, 0xff656567, 0xffc7ce20, 0xffd0b424, 0xffae5d40, 0xff97054e, 0xff97014b, 0xffb00051, 0xffc5005a, 0xffe70068, 0xfff2026d, 0xfff3a622, 0xfff4e30d, 0xfffce302, 0xfffdd400, 0xfff8c104, 0xffbb9b2a, 0xff8d7d49, 0xffe9f10a, 0xfff4ff01, 0xffd2b324, 0xffae5e43, 0xff9d014b, 0xffa6014e, 0xffc7005b, 0xffda0061, 0xfff10f65, 0xffef862a, 0xfff1ce10, 0xfffed700, 0xffcaa523, 0xffd2b325, 0xff96064c, 0xff99014c, 0xff9c024b, 0xffb10154, 0xffe20066, 0xfff2006b, 0xfff00169, 0xfff1006f, 0xffec0c65, 0xffe67334, 0xffebc115, 0xfffbd800, 0xffcea81f, 0xff9d8640, 0xff97054c, 0xffa2004c, 0xffc10157, 0xffd40160, 0xfff2016c, 0xffee0669, 0xffeb1168, 0xffdc704c, 0xffe6bd27, 0xfff6ec00, 0xffddb015, 0xffb09433, 0xffd2b41e, 0xffaf5f3e, 0xff98064d, 0xff9c004a, 0xffad0050, 0xffc20057, 0xffe50065, 0xffee0a6b, 0xffec1d63, 0xffe8325b, 0xffde903d, 0xffe8cc20, 0xfff8ec00, 0xfffcda00, 0xffe4b511, 0xffba9a2b, 0xff686765, 0xffdab411, 0xffba6129, 0xff9b0646, 0xff9a0049, 0xffa1004c, 0xffbe0056, 0xffd3005f, 0xffef006c, 0xffee036a, 0xffed0769, 0xffeb1865, 0xffe9285f, 0xffe9544d, 0xffe57341, 0xffefac29, 0xffedc118, 0xfff3f605, 0xfff9f001, 0xfffcde02, 0xffffc801, 0xffedb90d, 0xffc9a422, 0xffdfb60c, 0xffbf621c, 0xff9c0747, 0xff970148, 0xff97004d, 0xff960048, 0xffac0051, 0xffbd0155, 0xffe10366, 0xffeb0769, 0xffed1664, 0xffeb205f, 0xffe64e4d, 0xffe96946, 0xffeba627, 0xffebc01c, 0xfff1e40c, 0xfff2ee09, 0xfffaf102, 0xfff9e200, 0xfffdca00, 0xfff0be09, 0xff76705a, 0xffdfb509, 0xffc3621b, 0xff9d0746, 0xff980249, 0xff970048, 0xff98004d, 0xff98024c, 0xff99064a, 0xffa11448, 0xffac1e44, 0xffcf4342, 0xffdf5940, 0xffeb932f, 0xffedae23, 0xffefd80e, 0xfff1e90a, 0xfff3f700, 0xfff0f400, 0xffefe400, 0xfff1da00, 0xfffbca01, 0xfff5bf05, 0xffdbaf18, 0xff837653, 0xffdfb708, 0xff9b0745, 0xff98024a, 0xff9b054c, 0xff9f1149, 0xffa21b46, 0xffb1403a, 0xffbe5830, 0xffda9223, 0xffe9ac20, 0xfff1d613, 0xfff3e60c, 0xfff5f604, 0xfff1f500, 0xffece801, 0xffe6e101, 0xffe1cf00, 0xffe3c902, 0xfff5c700, 0xfffcc601, 0xfff8c102, 0xffe1b410, 0xff8a7c4d, 0xff6f6c5d, 0xfff6ff01, 0xffdeb908, 0xffc26619, 0xff9d0947, 0xff97044a, 0xff9d0c47, 0xffa01647, 0xffac393e, 0xffb25131, 0xffc88a23, 0xffd4a41e, 0xffe5d30d, 0xffece308, 0xfff2f504, 0xfff2f601, 0xffeeec01, 0xffe9e500, 0xffe0d200, 0xffdbca00, 0xffd4ba01, 0xffd1b400, 0xffcfae01, 0xffd2ae02, 0xffe1bb02, 0xffeec201, 0xfffcc602, 0xfffcc302, 0xff968245, 0xff746e5e, 0xffe1bf06, 0xffc57119, 0xff9b0a43, 0xff9b0b48, 0xffa01347, 0xffa92f3c, 0xffb24838, 0xffc78227, 0xffd09f1c, 0xffe1ce0f, 0xffe9df0c, 0xffeeee00, 0xffeae600, 0xffe2d400, 0xffddcb00, 0xffd4bb00, 0xffd2b501, 0xffceae01, 0xffccac01, 0xffccaa02, 0xffcdab01, 0xffd7b402, 0xfff6c602, 0xfffbc702, 0xffefbc09, 0xff9a8641, 0xff766f5c, 0xffe9d407, 0xffd1901c, 0xffa01146, 0xff9a024b, 0xff9b084e, 0xff9e0f45, 0xffa62840, 0xffae3d39, 0xffc26e26, 0xffcd8f20, 0xffe0c111, 0xffe7d60c, 0xffeff203, 0xfff2f802, 0xfff3f901, 0xffedf000, 0xffecea01, 0xffe3d802, 0xffe0cf03, 0xffd6bf01, 0xffd2b801, 0xffcfaf02, 0xffcdad02, 0xffccaa00, 0xffd1b003, 0xffe1c001, 0xffeec602, 0xfff5bf03, 0xffaa9135, 0xff827552, 0xffc6cc20, 0xffebda08, 0xffd7971b, 0xffa21a42, 0xff9f1046, 0xffa52644, 0xffab3939, 0xffbe6a2c, 0xffc98822, 0xffdfba11, 0xffe6d30d, 0xfff0ee05, 0xfff2fb00, 0xffeff300, 0xffecec00, 0xffe4db00, 0xffd5c100, 0xffd2ba02, 0xffceb000, 0xffceae03, 0xffcbab00, 0xffd8b900, 0xffe3c100, 0xfff7c901, 0xfffdc702, 0xffb49731, 0xff877a4e, 0xff72745e, 0xffc4ca20, 0xffe6ef0a, 0xffeee705, 0xffe0b913, 0xffc3702a, 0xffc67c25, 0xffd7b317, 0xffdfcc10, 0xffeee907, 0xffeeef00, 0xffe7df02, 0xffe2d701, 0xffd8c401, 0xffd5bc00, 0xffd0b101, 0xffcdac00, 0xffcbab02, 0xffd1b200, 0xffe2c402, 0xffefc801, 0xfffdc800, 0xffffc401, 0xffc8a225, 0xffc3c921, 0xffe5ee0b, 0xfff2f204, 0xffebdd0a, 0xffdfb916, 0xffe2c50f, 0xffece707, 0xffeef104, 0xfff2f603, 0xffeff000, 0xffe7e200, 0xffe2d700, 0xffd9c600, 0xffd6bd00, 0xffcaaa00, 0xffd9bb01, 0xffe4c400, 0xfff9c801, 0xfffcc700, 0xffcda521, 0xff998644, 0xff656668, 0xffc2c820, 0xfff1f701, 0xfff1f200, 0xffe8e500, 0xffe5dd00, 0xffdcc901, 0xffd8c100, 0xffd1b401, 0xffceb002, 0xffcba900, 0xffcaaa01, 0xffcdad00, 0xffd2b502, 0xffe9c402, 0xfff2c802, 0xffdaae17, 0xffab9035, 0xffc2c722, 0xfff0f902, 0xffeff500, 0xffe9e700, 0xffe6de00, 0xffdccb02, 0xffd9c202, 0xffcfb200, 0xffcba901, 0xffdebd00, 0xffeac401, 0xffe0b214, 0xffb39630, 0xffe4ed08, 0xffecea00, 0xffdcd000, 0xffd0b300, 0xffcead00, 0xffcdad04, 0xffcfae00, 0xffd5b500, 0xffecc101, 0xffe9ba0c, 0xffc4a025, 0xff716e5d, 0xff73725d, 0xffc3c823, 0xffe5ed0c, 0xfff1f700, 0xffe9e402, 0xffd3b902, 0xffe2bc03, 0xffeec102, 0xfffbc701, 0xffeebb0a, 0xffcca421, 0xff746f5b, 0xfff2f800, 0xffebe901, 0xffe4d603, 0xffdece00, 0xffd4bd00, 0xffd1b702, 0xffcfb000, 0xffd8b600, 0xffedc501, 0xfff8c603, 0xffd7ae18, 0xff7e7554, 0xffc0c721, 0xffe2e80a, 0xfff0f100, 0xffe4d903, 0xffdecf02, 0xffd5bd01, 0xffd0b100, 0xffe5c000, 0xfff0c602, 0xfff6c004, 0xffdfb115, 0xff6e6c60, 0xff6e6f61, 0xffada72b, 0xffcabf15, 0xffd5c102, 0xffd2ba00, 0xffcea900, 0xffd0b202, 0xffd8ba00, 0xfff9c802, 0xfff9c301, 0xffeab70e, 0xff918146, 0xff928c42, 0xffad9f25, 0xffc8ad08, 0xffccae02, 0xffccac03, 0xffcaab02, 0xffccab00, 0xffefc800, 0xfff9c402, 0xffeeba0c, 0xff978344, 0xff7b7255, 0xff9e8930, 0xffaf961f, 0xffc7a706, 0xffc9a801, 0xffdabd01, 0xfff0c008, 0xffa68d39, 0xff7d7457, 0xff676769, 0xff6c6a5e, 0xff817948, 0xff958538, 0xffbb9e12, 0xffc6a606, 0xffcea902, 0xffd3b300, 0xffe8c301, 0xffecc005, 0xffad9531, 0xff827950, 0xff6d6b5e, 0xff8c7d42, 0xff9f8c2e, 0xffbea30e, 0xffdbb902, 0xffb9a127, 0xff8e8248, 0xff767058, 0xff857b48, 0xffaa9520, 0xffbba110, 0xffc9aa02, 0xffcba802, 0xffcca903, 0xffcbaa03, 0xffcfb007, 0xffb19e28, 0xff8c8149, 0xff676662, 0xff7a7450, 0xff8a8140, 0xffb49b1a, 0xffc2a30b, 0xffc7a704, 0xffc4a606, 0xffbca00e, 0xffb69b18, 0xffa49226, 0xff9b8c31, 0xff837b4c, 0xff727059, 0xff6e6a5e, 0xff787154, 0xff9b8a2e, 0xffb0961d, 0xffc6a605, 0xffcaa904, 0xffcaa902, 0xffc8a704, 0xffc4a60a, 0xffbb9f0f, 0xffb59a19, 0xffa48e28, 0xff998735, 0xff867a46, 0xff7e7651, 0xff686669, 0xff7b764e, 0xffa68f29, 0xffb79b14, 0xffc9a805, 0xffc4a608, 0xffc3a40b, 0xffae951e, 0xff9b8a30, 0xff91833c, 0xff7f784a, 0xff797255, 0xff6e6c5d, 0xff6c6960, 0xff8b7c43, 0xff9e8b2f, 0xffc0a210, 0xffc6a50a, 0xffb59a17, 0xffac9521, 0xff998733, 0xff8f803f, 0xff7d754e, 0xff767154, 0xff6c6962, 0xff6f6e59, 0xff8f823e, 0xffa69124, 0xffc5a409, 0xffcbaa00, 0xffc1a40a, 0xffbfa10d, 0xffb0981e, 0xffa79225, 0xff938338, 0xff897d41, 0xff797353, 0xff8b8042, 0xffb69917, 0xffc0a20e, 0xffc8a903, 0xffc2a30a, 0xffac961f, 0xffa69126, 0xff90813e, 0xff777255, 0xff726d5a, 0xff686762, 0xff6b6861, 0xff82774a, 0xff958339, 0xffba9f10, 0xffc5a407, 0xffc9a803, 0xffc7a505, 0xffb79d14, 0xffa89225, 0xff9e8b2d, 0xff897d43, 0xff83784a, 0xff6f6d60, 0xff6a6760, 0xff7c7450, 0xffa59027, 0xffb69c14, 0xffc8a807, 0xffc5a505, 0xffb79b16, 0xffa69128, 0xff998931, 0xff887b46, 0xff7f764b, 0xff716e5b, 0xff6e6c5f, 0xff857947, 0xffaa9321, 0xffc8a607, 0xffc3a509, 0xffb89c14, 0xffaf971b, 0xff9f8c2d, 0xff6f6c5b, 0xff6d6b5f, 0xff666865, 0xff90813c, 0xffa39027, 0xffc7a707, 0xffb89c15, 0xff9b8a32, 0xff90823b, 0xff80774e, 0xff777252, 0xff6a6a5e, 0xff787355, 0xffb49c18, 0xffa08c29, 0xff92813b]
				); 
        }
        public function box3():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,1,0,2,2,1,2,0,1,0,2,0,0,0,0,0,3,4,4,0,2,5,6,1,7,8,8,4,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,2,34,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,3,3,1,0,2,0,1,7,7,4,4,35,36,37,38,39,40,41,42,43,44,45,19,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,26,62,63,64,65,66,67,68,69,2,1,33,0,0,0,0,0], 
    [0,0,0,0,0,2,70,1,1,7,4,1,4,35,71,72,11,73,40,41,74,75,17,76,77,78,79,48,80,81,82,83,84,85,86,87,88,89,59,90,91,28,28,92,62,26,27,64,27,63,63,93,94,95,96,97,98,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,1,99,100,101,102,45,77,78,103,104,105,106,107,108,84,85,55,109,88,110,59,90,111,112,28,62,62,64,64,63,63,27,27,27,27,27,27,62,113,64,114,27,115,27,63,116,117,118,119,120,121,2,32,0,0,0,0,0], 
    [0,0,0,0,0,0,4,122,123,124,125,126,127,52,53,85,86,109,128,129,130,131,111,132,61,133,26,63,64,134,134,63,27,27,63,64,113,27,27,133,135,136,137,138,139,26,64,140,63,27,64,116,141,142,143,144,145,0,146,0,0,0,0,0], 
    [0,0,0,0,0,4,147,148,149,90,111,61,61,92,113,62,27,26,26,27,150,115,115,64,63,113,136,92,151,135,28,152,153,154,155,156,157,158,159,160,161,162,163,164,165,166,64,140,64,63,115,167,168,169,170,171,172,0,0,0,0,0,0,0], 
    [0,0,0,0,0,7,72,104,173,26,133,115,26,63,27,63,174,63,63,26,115,26,26,175,176,177,178,179,180,181,157,182,183,160,184,185,186,187,188,189,190,191,192,193,194,195,26,64,64,63,115,167,196,197,198,199,200,4,1,0,0,0,0,0], 
    [0,0,0,0,0,69,12,201,109,115,115,64,92,202,203,204,205,156,157,182,183,206,207,162,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,64,27,63,27,231,232,233,234,235,236,237,1,0,0,0,0,0], 
    [0,0,0,0,0,69,238,239,240,27,27,26,241,242,243,244,184,162,245,246,247,248,249,250,251,252,253,217,254,255,220,221,256,257,258,259,260,261,260,262,263,264,265,266,267,268,136,62,27,63,27,269,270,271,272,273,274,275,276,0,0,0,0,0], 
    [0,0,0,0,0,277,278,279,280,27,27,281,282,283,284,285,218,255,286,287,288,289,258,290,291,260,292,293,226,293,263,264,294,293,293,293,293,293,264,264,263,293,262,295,296,297,61,27,27,115,27,298,299,300,301,302,303,304,305,1,0,0,0,0], 
    [0,0,0,0,0,306,307,308,91,27,115,309,310,311,312,313,314,315,260,316,292,292,293,317,317,293,263,263,263,317,263,293,318,263,318,293,293,263,263,293,293,262,292,319,320,321,230,64,27,115,26,322,323,324,301,325,326,327,328,4,0,0,0,0], 
    [1,1,0,0,0,38,45,329,61,63,27,330,331,332,333,334,335,263,263,317,317,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,263,293,293,293,263,292,336,337,338,26,27,27,27,26,117,339,272,324,272,340,341,342,343,1,1,146,1], 
    [0,1,0,0,0,344,345,346,62,63,27,347,348,349,350,351,352,263,293,353,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,263,260,354,355,167,26,27,27,27,26,356,357,234,324,358,272,359,360,361,0,0,0,1], 
    [0,1,0,0,0,278,362,280,62,113,26,363,364,365,366,367,368,335,369,293,370,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,260,371,372,137,63,63,27,27,27,373,374,301,375,358,272,376,377,378,379,0,1,0], 
    [0,0,0,2,0,380,48,381,64,115,26,382,383,384,385,386,387,388,369,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,226,389,390,175,27,27,150,27,230,391,392,301,300,272,272,393,394,395,396,0,0,0], 
    [0,0,0,0,4,45,397,398,399,113,133,400,401,402,385,403,404,405,406,292,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,293,370,225,407,408,133,63,27,26,115,409,410,411,300,272,412,412,412,413,414,415,32,33,0], 
    [0,2,1,1,4,416,417,61,418,64,151,331,419,420,421,422,423,424,425,426,293,293,293,317,317,293,317,293,293,293,293,293,293,293,293,293,293,293,293,263,293,293,427,428,429,26,64,418,134,27,230,430,431,412,300,324,324,234,432,433,434,4,146,435], 
    [1,1,0,2,277,436,437,26,27,27,137,438,439,421,440,422,422,441,367,442,335,293,293,293,293,293,262,293,293,293,293,293,293,293,293,293,293,293,294,293,293,293,443,444,445,28,26,418,27,26,116,323,446,412,324,324,324,358,272,394,447,448,1,1], 
    [1,1,0,4,449,450,85,26,27,27,241,451,452,453,454,454,455,423,386,456,457,293,293,293,293,293,262,293,293,293,293,293,293,293,293,293,293,293,294,293,293,263,458,459,460,61,27,64,27,26,116,461,446,324,324,375,324,462,462,463,464,465,35,7], 
    [1,0,0,4,466,467,109,27,27,151,468,469,470,421,385,471,471,422,472,367,473,474,263,293,293,293,226,293,293,293,293,293,293,293,293,293,293,293,294,294,293,292,287,475,476,26,27,115,63,62,477,478,479,462,462,301,462,324,375,480,481,482,483,1], 
    [484,1,0,4,238,485,486,27,27,26,487,488,489,421,385,422,422,422,455,386,490,491,474,293,293,317,293,293,293,293,293,293,293,293,293,293,293,263,294,492,317,260,493,494,495,115,115,27,63,134,116,496,497,301,462,301,462,324,324,498,499,500,501,0], 
    [2,1,0,502,503,504,505,63,115,133,506,507,508,454,454,422,422,422,422,440,509,405,334,370,370,263,263,293,293,293,293,293,293,293,293,293,293,293,317,293,264,262,510,511,512,27,63,115,63,26,513,514,515,375,375,375,375,375,375,324,498,516,517,35], 
    [1,1,0,10,518,519,381,63,27,61,520,439,521,471,422,422,422,422,455,422,522,523,456,263,317,317,265,293,293,293,293,293,293,293,293,293,293,262,317,293,317,524,525,390,512,115,64,113,64,26,526,527,528,375,375,375,375,375,375,412,234,529,530,361], 
    [0,2,0,12,45,57,26,27,27,531,532,533,534,471,422,454,440,422,422,422,422,441,535,334,335,370,293,293,293,293,293,293,293,293,293,293,293,370,293,317,294,536,537,538,539,115,27,26,64,540,541,431,271,375,375,375,375,375,375,300,358,542,543,544], 
    [0,3,484,545,345,486,26,64,115,546,547,548,549,422,454,454,455,422,422,422,422,423,550,456,457,293,293,293,293,293,293,293,293,293,293,293,293,293,293,317,294,551,552,553,554,115,115,115,64,93,555,556,557,375,375,375,375,375,375,324,301,558,464,559], 
    [7,2,7,503,560,505,62,63,115,561,562,563,420,422,472,422,422,422,422,422,422,440,564,367,565,474,293,293,293,293,293,293,293,293,293,293,293,492,263,317,263,443,566,567,568,63,63,27,115,167,196,569,358,375,375,375,375,375,375,300,358,570,571,572], 
    [573,0,1,574,575,381,115,27,418,576,577,578,366,471,422,471,471,455,422,422,422,579,455,580,581,457,335,293,293,293,293,293,293,293,293,293,293,293,369,582,293,583,584,585,586,63,64,63,27,116,196,587,272,375,375,375,375,375,375,272,272,588,199,589], 
    [0,0,4,590,81,151,26,26,115,591,592,593,594,422,422,422,422,422,422,422,422,454,595,403,596,597,598,263,263,293,293,599,293,317,293,262,293,317,264,317,293,600,601,602,139,27,418,27,63,167,117,479,358,375,375,375,375,375,375,300,272,303,603,604], 
    [0,0,4,605,485,230,26,26,115,606,607,608,609,422,422,422,422,422,422,422,422,422,422,385,423,610,456,611,264,293,317,370,293,317,293,264,264,369,263,317,293,612,613,614,540,64,27,27,63,167,196,497,358,375,375,375,375,375,375,375,272,588,615,616], 
    [1,4,617,436,279,26,27,27,28,618,619,620,422,621,422,422,422,422,422,422,422,422,455,471,455,441,367,622,369,260,292,263,226,370,369,369,369,623,624,625,626,627,628,156,26,27,27,64,27,231,629,630,358,375,375,375,375,375,375,375,272,631,632,361], 
    [0,7,633,48,634,26,27,27,28,635,636,637,422,455,471,422,422,422,422,422,422,422,422,422,455,423,638,639,640,626,641,642,643,644,645,646,647,648,649,650,651,652,653,205,26,27,27,64,27,654,655,271,358,375,375,375,375,375,375,375,656,657,658,659], 
    [1,4,13,81,329,27,27,27,116,660,661,662,471,472,422,422,422,422,422,422,422,422,422,422,471,454,564,663,664,665,666,667,668,668,669,670,671,672,673,674,675,676,677,678,133,230,27,115,27,679,680,462,358,375,375,375,375,375,375,375,272,681,682,36], 
    [0,4,14,417,683,64,418,115,177,684,685,453,686,422,422,687,440,422,422,594,688,422,454,454,422,422,421,689,690,691,692,693,694,695,696,697,696,698,699,700,701,702,703,704,27,27,115,115,27,705,706,462,324,375,375,375,375,375,375,272,707,708,709,710], 
    [0,711,278,504,505,27,27,62,712,713,714,471,471,471,422,422,688,454,454,422,422,422,422,455,455,454,385,715,716,146,146,2,2,0,0,0,0,717,1,4,35,718,719,111,27,27,64,27,62,720,721,300,412,375,375,375,375,375,375,272,272,722,723,710], 
    [724,10,725,308,90,63,115,133,726,727,728,621,422,471,422,454,621,440,422,422,422,687,471,471,454,687,729,730,731,3,732,573,7,733,69,69,69,35,71,734,735,605,106,736,27,27,63,27,62,141,721,300,300,375,375,375,375,375,375,272,234,737,738,69], 
    [0,739,45,329,398,64,113,61,740,741,742,454,472,454,687,422,421,421,421,594,366,729,637,743,744,745,746,747,748,749,750,751,752,753,754,755,756,78,103,757,758,759,760,26,27,27,63,27,27,196,357,412,462,375,375,375,375,375,375,301,761,762,763,4], 
    [0,344,605,764,61,27,63,116,765,439,766,637,767,620,768,769,770,771,772,773,578,774,775,776,777,778,779,780,781,782,783,784,785,786,81,107,787,788,789,790,634,109,791,115,27,27,63,27,26,792,793,358,462,375,375,375,375,375,375,358,761,762,763,4], 
    [724,278,794,795,63,64,115,796,797,798,799,800,801,802,803,804,805,806,807,808,809,810,811,812,813,814,815,576,816,817,59,818,111,111,28,28,62,92,62,62,62,134,63,27,27,27,27,27,26,819,820,412,412,375,375,375,375,375,375,324,761,821,68,1], 
    [7,518,104,678,27,63,27,822,823,824,825,826,827,828,829,830,831,832,520,833,834,835,726,836,837,838,477,137,112,62,62,26,115,27,27,27,27,27,26,27,27,27,27,27,27,27,27,26,65,839,840,412,358,375,375,375,375,375,375,412,498,841,842,4], 
    [7,18,50,398,115,64,115,63,27,136,135,61,61,230,230,230,115,115,115,418,27,27,27,27,27,27,418,115,27,27,27,63,27,27,27,27,115,27,27,27,27,27,27,63,63,63,63,63,93,843,844,358,462,375,375,375,375,375,375,412,845,846,847,4], 
    [35,848,239,26,27,63,115,64,63,63,63,115,27,27,27,64,63,63,63,27,27,134,63,63,63,63,63,27,27,27,63,27,27,27,27,27,27,27,27,27,27,27,27,115,26,26,26,26,116,461,197,358,301,375,375,375,375,375,375,412,498,846,847,69], 
    [711,362,504,133,27,115,27,418,418,115,27,27,63,64,115,64,63,63,63,63,63,26,26,115,27,26,133,61,137,65,116,167,132,241,849,796,796,850,850,851,852,853,853,854,855,856,857,858,859,860,479,272,358,375,375,375,375,375,375,300,498,861,862,4], 
    [306,104,85,133,27,27,63,63,62,26,418,26,26,26,230,65,65,61,863,477,116,477,241,864,849,865,178,866,867,868,868,869,870,856,871,872,873,874,875,876,877,878,879,880,881,882,883,883,884,885,886,358,358,375,375,375,375,375,375,412,887,888,889,4], 
    [38,890,891,850,892,893,894,895,855,896,871,897,898,899,900,901,902,903,904,905,906,907,908,909,909,910,910,911,912,913,914,915,915,916,917,918,918,919,919,920,920,921,921,922,922,923,924,925,926,927,928,462,462,375,375,375,375,375,375,272,480,929,930,0], 
    [10,931,932,933,934,935,936,937,880,938,882,883,939,940,910,941,912,942,914,943,944,916,917,945,946,919,919,919,947,948,948,949,950,949,949,949,949,951,951,951,951,952,952,951,951,952,953,952,954,955,956,272,412,375,375,375,375,375,375,272,957,199,958,146], 
    [343,959,960,961,962,947,954,922,922,922,922,951,951,951,952,952,963,924,924,963,952,952,952,952,952,964,964,952,952,952,952,952,952,952,952,963,924,951,951,951,951,951,951,951,951,951,951,951,924,965,966,967,968,375,375,375,375,375,375,761,302,969,970,573], 
    [0,971,972,973,974,963,924,951,951,953,951,951,951,952,952,963,952,952,951,952,952,952,952,952,952,924,924,952,951,952,952,964,953,951,951,951,951,951,951,951,951,951,951,952,952,952,952,951,952,921,975,976,977,375,375,375,375,375,375,272,302,978,979,4], 
    [980,4,981,982,983,984,985,986,951,951,987,951,951,951,951,988,951,951,951,951,951,951,951,953,952,952,952,951,951,952,952,986,951,951,951,986,952,951,951,951,951,951,951,951,951,951,951,951,951,924,925,989,990,375,375,375,375,375,375,301,991,992,993,0], 
    [980,8,573,994,995,996,997,952,951,986,988,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,952,963,952,998,999,1000,462,301,301,412,358,1001,1002,1003,172,1], 
    [32,0,0,4,1004,1005,1006,1007,988,924,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,1008,963,952,954,975,1009,1010,272,1011,272,300,272,991,1012,172,0], 
    [0,3,0,0,710,1013,1014,1015,964,952,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,963,952,951,919,1016,1017,272,1018,301,300,272,170,1019,1020,0], 
    [1,1,0,1,0,36,1021,1022,1023,953,953,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,988,924,924,952,951,1024,1025,1026,358,272,272,498,1027,1028,1021,0], 
    [0,33,2,0,0,69,659,1029,1030,1031,1032,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,924,952,951,918,1033,928,1034,272,272,234,499,1035,1036,3], 
    [0,0,0,0,0,32,2,1037,1038,1039,1040,964,963,963,963,1008,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,950,1041,1042,1043,300,324,656,376,1044,1036,3], 
    [0,0,0,0,0,3,0,573,448,1045,1046,1047,952,952,952,988,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,923,1048,1049,1050,272,412,376,763,1036,0], 
    [0,0,0,0,0,2,0,0,717,1051,1052,1053,1054,963,924,964,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,964,952,919,1055,1043,1056,656,1057,1058,1004,0], 
    [0,0,0,0,0,146,2,0,1,1059,1060,1061,1062,1063,963,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,963,952,923,917,1049,977,761,1064,1065,1066,3], 
    [0,0,0,0,0,0,1067,7,724,0,32,1068,1069,1070,1071,963,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,963,952,949,1072,1073,1074,1075,1076,1066,0], 
    [0,0,0,0,0,1,0,1,0,2,146,36,1077,1078,1079,985,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,951,987,963,952,952,1080,1081,1082,1083,1076,305,0], 
    [0,0,0,0,0,0,0,0,0,0,0,724,4,1084,1085,1086,1047,924,951,952,952,953,986,1087,1087,952,1087,951,951,951,951,951,952,951,951,952,951,924,924,952,963,952,952,952,952,952,951,924,951,951,951,951,951,986,951,1088,952,950,1089,1090,1091,1092,1004,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,0,616,1093,1094,1095,1096,952,952,1097,924,924,952,952,924,924,963,963,963,963,963,924,924,924,964,963,1032,1087,952,952,951,951,951,952,952,951,951,951,951,951,951,951,924,924,951,952,952,921,1098,812,1099,559,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,1,0,69,1100,1101,1102,1096,985,963,1032,963,953,1087,1096,1096,963,963,963,963,963,1096,1096,1103,1104,985,1047,1105,997,1106,1107,1106,1071,1015,1108,1108,1109,1109,1109,1109,1109,1109,1110,1110,1111,1095,996,996,1112,1113,1114,1115,1], 
    [0,0,0,0,0,0,0,0,0,0,0,2,3,0,0,1116,1117,1118,1119,1071,1120,1121,1106,1122,1110,1110,1110,1110,1110,1110,1110,1110,1110,1111,1123,1124,1125,1126,1126,1127,1128,1129,1130,1131,1132,1133,1134,1039,983,983,983,983,983,983,1135,1136,1137,1138,1138,1139,1140,1141,1142,3], 
    [0,0,0,0,0,0,0,0,0,0,0,146,1,2,0,7,97,1143,1144,1145,1146,1061,1147,1148,1149,1150,1151,1152,1152,1152,1152,1152,1152,1153,1154,1155,1156,1157,1155,1158,1068,1068,1159,1160,1077,1161,448,604,1162,1162,1162,1162,1162,1162,1162,396,145,1037,1037,1115,659,69,34,0]
],
[0xff666666, 0xff666664, 0xff666668, 0xff656766, 0xff676765, 0xff656563, 0xff666563, 0xff676767, 0xff666762, 0xff696a64, 0xff6d6e60, 0xff6e6f5f, 0xff70715f, 0xff70725c, 0xff75755b, 0xff7c7c58, 0xff86874b, 0xff8b8c48, 0xff909346, 0xff919447, 0xff9fa23b, 0xffb0b330, 0xffd0d715, 0xffdbe508, 0xffecf401, 0xfff0f900, 0xfff4fe00, 0xfff5ff00, 0xfff2fd01, 0xffecef08, 0xff9f983e, 0xff7a7558, 0xff676664, 0xff676568, 0xff666863, 0xff686964, 0xff6a6a62, 0xff6c6e61, 0xff6f705e, 0xff727061, 0xff70725d, 0xff757559, 0xff7a7c57, 0xff84884d, 0xff8a8d48, 0xff909247, 0xff999c41, 0xffa3a739, 0xffb4b92b, 0xffbac125, 0xffc3ca22, 0xffc4cc1f, 0xffcbd31d, 0xffd2d919, 0xffdee40e, 0xffe2ea0b, 0xffe7ef06, 0xffe8f007, 0xffeaf407, 0xffedf605, 0xfff1fa03, 0xfff3fc01, 0xfff3fe00, 0xfff4ff00, 0xfff4ff01, 0xfff5fc00, 0xfff5ef03, 0xffc5aa25, 0xff948448, 0xff676863, 0xff656565, 0xff696a62, 0xff6d6d61, 0xff6e715c, 0xff7b7c54, 0xff86874e, 0xff8f9146, 0xff919445, 0xff999d3f, 0xffa2a638, 0xffbac123, 0xffc2c921, 0xffc5cb21, 0xffcbd31b, 0xffd2d917, 0xffdce50e, 0xffe2ea09, 0xffe7f009, 0xffe8f208, 0xffebf407, 0xffeff902, 0xfff1fa01, 0xfff3fe02, 0xfff6fb01, 0xfff6ef00, 0xffd6b31b, 0xffa78e3a, 0xff6c6962, 0xff686667, 0xff6e6e62, 0xff777859, 0xff87884f, 0xff8b8e47, 0xffa2a53a, 0xffb2b92d, 0xffbbc123, 0xffc2ca1f, 0xffc5cb1f, 0xffcbd31e, 0xffe6ef08, 0xffebf308, 0xfff1fc02, 0xfff2fd00, 0xfff5fe03, 0xfff5ff02, 0xfff5ff01, 0xfff4fb00, 0xfff7ed02, 0xfff1c109, 0xffcfa81d, 0xff787059, 0xff6a6965, 0xff7e7f55, 0xff959942, 0xffb4b82d, 0xffbbc025, 0xffc2c923, 0xffc4cc21, 0xffe7f107, 0xffecf409, 0xffedf607, 0xfff0fb01, 0xfff2fb00, 0xfff4fd02, 0xfff3ff00, 0xfff4fd04, 0xfff6fd02, 0xfff5fc01, 0xfff6f801, 0xfff7f902, 0xfff7fe01, 0xfff5ee02, 0xfff7c407, 0xffdfb113, 0xff86794f, 0xff6e6c60, 0xff676566, 0xff6b6b61, 0xffa6a936, 0xffd1d819, 0xfff6ff01, 0xfff3fd00, 0xfff4f803, 0xfff3f403, 0xfff1f00a, 0xfff0ed0a, 0xfff4eb0a, 0xfff5e909, 0xfff4da0b, 0xffeecf12, 0xffe7bb27, 0xffe8b72c, 0xfff1af25, 0xfff4ac24, 0xfff4a121, 0xfff4b319, 0xfff3f605, 0xfff5fa00, 0xfff6ec00, 0xfffdc903, 0xfff6c006, 0xffa98e35, 0xff7e7554, 0xffdce510, 0xfff3ff01, 0xfff6fc04, 0xfff5fb03, 0xfff4f801, 0xfff1f502, 0xfff1f00c, 0xfff1ee0d, 0xfff3ec0a, 0xfff3da0b, 0xfff0cf12, 0xffeab52b, 0xfff3af26, 0xfff5ac22, 0xfff09425, 0xffe98530, 0xffe06253, 0xffe25a5a, 0xffee5051, 0xfff14d4b, 0xfff25147, 0xfff07b38, 0xfff4f009, 0xfff8ec00, 0xfffecb02, 0xfffac402, 0xffbc9d29, 0xff8d804b, 0xffc3ca24, 0xfff3f700, 0xfff4f504, 0xfff1ee09, 0xfff2ee09, 0xffe9bb28, 0xffe9b52d, 0xfff3ab23, 0xfff29327, 0xffec8330, 0xffdc6350, 0xffe05a5b, 0xffec514f, 0xfff14f4d, 0xffee3f4c, 0xffec3553, 0xffe31f67, 0xffe7196b, 0xffed1568, 0xffef1466, 0xfff10f63, 0xffef0c65, 0xffed066e, 0xffec056d, 0xffee026e, 0xffef026e, 0xffec166c, 0xffe95456, 0xfff1ec0e, 0xfff6fd00, 0xfff7f701, 0xfffae800, 0xffffca02, 0xfffec502, 0xffe2b214, 0xffb39632, 0xff6e6b62, 0xff73725d, 0xffc8cf21, 0xffe8f206, 0xfff3f901, 0xfff2df09, 0xffedd012, 0xffe5bb27, 0xfff4ac22, 0xfff09427, 0xffe98233, 0xffdf6152, 0xffe15959, 0xffed5152, 0xfff04e4b, 0xffef3f4c, 0xffeb3453, 0xffe7196e, 0xffee1468, 0xffef0c68, 0xffed066c, 0xffed046f, 0xffef046d, 0xffef026c, 0xfff0036b, 0xfff1016e, 0xfff0006b, 0xfff1006b, 0xfff2016c, 0xffeb176e, 0xffe65558, 0xfff4ec0d, 0xfff9f500, 0xfffbe400, 0xfffec901, 0xfffec601, 0xffedb90d, 0xffc6a323, 0xff756e5c, 0xff686763, 0xff6a6b63, 0xff7e7f53, 0xffd5dd16, 0xffeef706, 0xfff2f600, 0xffecd808, 0xffdd6030, 0xffe03b49, 0xffe41e69, 0xfff01363, 0xfff10f65, 0xfff00d69, 0xffec056b, 0xffef046b, 0xffee036a, 0xfff1016c, 0xfff0006d, 0xfff0006f, 0xffe32064, 0xffdc6348, 0xfff0ef09, 0xfff9f001, 0xfffbdd00, 0xffffc602, 0xfffec600, 0xfffbc203, 0xffe7b70d, 0xff8f7e48, 0xff726c5e, 0xff6e6f61, 0xff87884c, 0xffdce60c, 0xfff1f103, 0xffe2c40e, 0xffcb303e, 0xffd61158, 0xffeb046a, 0xffec056f, 0xfff0036f, 0xffef026a, 0xfff1006d, 0xfff10069, 0xffe8285b, 0xffe26e3d, 0xfff1f105, 0xfff8ef00, 0xfffbda00, 0xffffc500, 0xfffec401, 0xfff4bd0a, 0xff9c893d, 0xff787258, 0xffe6ef0a, 0xffebec08, 0xffd6b51a, 0xffa81a4a, 0xffb30354, 0xffe10164, 0xffed006a, 0xfff13c4d, 0xfff18e26, 0xfff5f700, 0xfffbd800, 0xfffdc403, 0xffc6a325, 0xff978545, 0xff686762, 0xff73735b, 0xff949843, 0xffe9f309, 0xffecea09, 0xffd6b01d, 0xffa1174a, 0xffa6044f, 0xffd3005f, 0xffe60067, 0xfff2006d, 0xfff3464c, 0xfff49e23, 0xfff6ec01, 0xfffbd802, 0xffffc702, 0xffdaae17, 0xffab9134, 0xff6d6a63, 0xffa7ac34, 0xffebde04, 0xffd39a17, 0xff9f1046, 0xff99034b, 0xffb30052, 0xffcb005c, 0xffee016b, 0xffee016d, 0xffef504d, 0xfff3ae23, 0xfff9ec00, 0xfffcd800, 0xffffc600, 0xfff2be08, 0xffd4a91c, 0xff797457, 0xff696961, 0xff85894e, 0xfff0fa03, 0xffe7d209, 0xffcd861a, 0xff9f0b47, 0xff98024c, 0xffa6004d, 0xffbb0057, 0xffe80167, 0xffec5053, 0xfff1af27, 0xfffcea00, 0xfffed700, 0xfff8c104, 0xffe3b311, 0xff877a4e, 0xff6d6b5e, 0xffc3cb20, 0xfff3fc03, 0xfff4ff03, 0xffdab916, 0xffb7612e, 0xff99064c, 0xff9b004c, 0xffa1004c, 0xffcd005d, 0xffe20064, 0xffe6555c, 0xffecb42b, 0xfff7fc00, 0xfffbe500, 0xfffed200, 0xffffc501, 0xfff5bf07, 0xffaa9137, 0xff807854, 0xff959945, 0xffc7d01f, 0xfff7fe00, 0xffb1583a, 0xff97044b, 0xff98024a, 0xff98004b, 0xff9c004a, 0xffbc0256, 0xffd30260, 0xffef006c, 0xffeb046e, 0xffdd5d5e, 0xffe7b82e, 0xfffddf01, 0xfffed001, 0xfffbc200, 0xffc29e26, 0xff927e49, 0xff656668, 0xffa8ac34, 0xffd4dd14, 0xffd7a619, 0xffb44b35, 0xff99014c, 0xffa2004c, 0xffe20066, 0xffed076a, 0xffdc6545, 0xffe7bd1d, 0xfffecb00, 0xffb6962f, 0xff6e6c5f, 0xff6d6e5e, 0xffb5b92e, 0xffd29719, 0xffb24133, 0xff980249, 0xff980049, 0xff9a004b, 0xffd40160, 0xffe70068, 0xffee0868, 0xffe47035, 0xffecc313, 0xfffad900, 0xffffc700, 0xffeeba0c, 0xffcaa324, 0xff75705a, 0xff71705e, 0xffc3c921, 0xffeef104, 0xffbd6d26, 0xffa6243c, 0xff97014b, 0xff9a0049, 0xffcc005c, 0xffec016a, 0xfff39524, 0xfff3db09, 0xfff3fa00, 0xfff9d800, 0xfffdca01, 0xfff9c203, 0xffe8b80c, 0xff937f4a, 0xff736d5f, 0xff656764, 0xffc7ce1e, 0xffe9f106, 0xffecee05, 0xffb46032, 0xffa01d45, 0xffbd0055, 0xffe60168, 0xfff1006f, 0xfff11265, 0xfff5a323, 0xfff3e508, 0xfffad700, 0xfffdca00, 0xfffdc401, 0xfff2be06, 0xffa68c38, 0xff7e7355, 0xff6a6c61, 0xff7e8051, 0xffd5de15, 0xffeef804, 0xffeeea05, 0xffb15138, 0xff9e1549, 0xffa4004e, 0xffee1365, 0xfff2ae25, 0xfff4ea0c, 0xfff7f900, 0xfffdd600, 0xffffcb01, 0xffcda521, 0xff9d8640, 0xff87884e, 0xffdce512, 0xffede506, 0xff9e1448, 0xff9d004c, 0xffbe0056, 0xfff20271, 0xffee146b, 0xfff7f700, 0xfffed501, 0xffffca00, 0xffdbb016, 0xffad9334, 0xfff3f402, 0xffe5cf0a, 0xffae3336, 0xff9d0c47, 0xffb60053, 0xffef036f, 0xffe7186a, 0xffebb32a, 0xfff1ec0a, 0xfff6fb00, 0xfff9f301, 0xffeebb0a, 0xffc7a124, 0xff706c60, 0xff72745e, 0xfff1f002, 0xffdec10e, 0xffa5273c, 0xff9c0749, 0xffa8004e, 0xffed0670, 0xffe31d6a, 0xffe7b727, 0xfff1ee0b, 0xfffaf102, 0xfffece02, 0xffffc803, 0xffefba0a, 0xff6f6d60, 0xffa7ad33, 0xffeeeb06, 0xffd7b41a, 0xff9d1a46, 0xff9b014a, 0xffcf005d, 0xffe5295c, 0xffe9c21d, 0xfff1f008, 0xfffccb02, 0xffeab809, 0xffc19f24, 0xff706c61, 0xff686765, 0xff85894c, 0xffb2b92b, 0xffedea07, 0xffd6b11a, 0xff9c1648, 0xff99004a, 0xffa7004e, 0xffbf0055, 0xfff00070, 0xfff00b66, 0xffec3355, 0xfff1cd15, 0xfff4f303, 0xfffbca01, 0xffe7b70f, 0xff716a60, 0xff909249, 0xffebdb09, 0xffd39818, 0xff9e0f45, 0xff99014a, 0xff97004a, 0xffa5004d, 0xffd0005e, 0xffe30165, 0xfff0006c, 0xfff01164, 0xfff3434d, 0xfff5e00b, 0xffbd9c29, 0xff6f6b60, 0xff959743, 0xffe8ce08, 0xffca811a, 0xff9e0a46, 0xff980148, 0xffbc0057, 0xffef006a, 0xfff11262, 0xfff44a4b, 0xfff4e609, 0xffbb9b2a, 0xff6f6b5f, 0xff6b6d62, 0xffd6b818, 0xffb25f33, 0xff98054b, 0xff98004d, 0xffe10066, 0xffec036c, 0xffed026b, 0xffe9046b, 0xffe8066a, 0xffe91964, 0xffe9544e, 0xfffbe901, 0xfffec900, 0xffe2b212, 0xffb29531, 0xff6c6e60, 0xffdde611, 0xffd6b41d, 0xffaf583a, 0xff98054c, 0xffa6014e, 0xffd2035e, 0xffe50367, 0xffe8066c, 0xffe5096d, 0xffe6086d, 0xffe4086c, 0xffe3086c, 0xffe3096a, 0xffe00a6a, 0xffdc0c6a, 0xffdd0d6b, 0xffd4146a, 0xffd2166a, 0xffd42d61, 0xffdc664a, 0xfff7f502, 0xfffce501, 0xfffec400, 0xffdeb015, 0xffae9133, 0xff6c6964, 0xffd6a518, 0xffb44935, 0xff9a034a, 0xffa31257, 0xffa32562, 0xffa23869, 0xffa03a69, 0xff944469, 0xff904669, 0xff904667, 0xff8f4566, 0xff8a4766, 0xff894a67, 0xff844c65, 0xff7f5267, 0xff7f5467, 0xff927354, 0xffb6a734, 0xffeff904, 0xfff7f001, 0xfffbdf00, 0xffdbaf18, 0xffa98f38, 0xffe8f205, 0xffd29119, 0xffb03e33, 0xff99014e, 0xff970149, 0xff970048, 0xff931c56, 0xff863a5e, 0xff7e5567, 0xff795765, 0xff725d66, 0xff725e67, 0xff715d66, 0xff6f5e66, 0xff6f5e64, 0xff6e5f64, 0xff6f6067, 0xff6b6267, 0xff6c6366, 0xff8b864c, 0xffb6b92a, 0xffeffa00, 0xfff9ee00, 0xfffcda00, 0xffffc502, 0xffdaaf15, 0xffa98f3a, 0xff696863, 0xff6b6b63, 0xffefef05, 0xffbc6828, 0xffa4223e, 0xff882456, 0xff77475f, 0xff656762, 0xff8e8e48, 0xffbec422, 0xfff5ee00, 0xfff9d801, 0xffd5ad1a, 0xffa28b3d, 0xff676769, 0xff86874d, 0xffeeed07, 0xffb45c36, 0xff9e1d46, 0xff97034d, 0xff882858, 0xff764a61, 0xff666865, 0xff686866, 0xff6c6c62, 0xff6d705f, 0xfff1fc00, 0xffd1aa1e, 0xff9d8642, 0xff72715f, 0xffece904, 0xffb3503b, 0xff9f144b, 0xff9a0547, 0xff9b0646, 0xff9d0e44, 0xff9e1447, 0xff8b4152, 0xff7c5f59, 0xff777858, 0xff7c7d55, 0xff82884c, 0xff898b4a, 0xff8d9147, 0xff8e9246, 0xff909545, 0xff939645, 0xffafb22f, 0xffb6bb2d, 0xffccd218, 0xffe2e80a, 0xfffdc500, 0xffcea81f, 0xff968446, 0xffe9f108, 0xffece407, 0xff9f1644, 0xff96044d, 0xff9a0545, 0xff9d0945, 0xff9d0c43, 0xff9f1344, 0xff9f1342, 0xff9e1445, 0xff991a4d, 0xff9d1b47, 0xffa41e37, 0xffa92435, 0xffb13c33, 0xffb34534, 0xffa76f3e, 0xff9b8843, 0xff9ca13b, 0xffa4a837, 0xffb0b62e, 0xffb9be24, 0xffbfc621, 0xffc7ce20, 0xffccd41e, 0xffd0d91a, 0xffd9e112, 0xffeef602, 0xfffbeb00, 0xfffed602, 0xffa8ac31, 0xffecf705, 0xfff2f802, 0xffecdf07, 0xffc47621, 0xffb65832, 0xffaf573f, 0xffad5c41, 0xffb55c32, 0xffbc5f24, 0xffc87319, 0xffd08b16, 0xffd79f18, 0xffd7a717, 0xffd7af1a, 0xffd6b21e, 0xffd4b71e, 0xffd7b61b, 0xffddb90b, 0xffdfc006, 0xffe8d606, 0xffedde07, 0xffecf006, 0xffecf506, 0xfff0f804, 0xfffbe402, 0xffffd302, 0xffcda722, 0xfff2fc00, 0xfff0ef01, 0xffdfbe0f, 0xffdab318, 0xffd4b51f, 0xffd2b720, 0xffd9b718, 0xffddb80f, 0xffe6c40a, 0xffe9d505, 0xffeee107, 0xffeeeb08, 0xffedec08, 0xffeced09, 0xfff0ed02, 0xfff2ef02, 0xfff3f702, 0xfffae100, 0xfffdd100, 0xffcca621, 0xff938347, 0xfffbda01, 0xfffdcd01, 0xfffcc300, 0xffcaa320, 0xff918146, 0xff959744, 0xfff2f800, 0xfff0f401, 0xffeef100, 0xffefef01, 0xffeeee02, 0xffecea00, 0xffebe900, 0xffe9e700, 0xffe8e500, 0xffe7e400, 0xffebe402, 0xfff8d201, 0xffc9a221, 0xff918048, 0xfff2fb02, 0xfff0f902, 0xfff1f500, 0xfff1f200, 0xfff0f100, 0xffeeee00, 0xffeaea00, 0xffecea01, 0xffe9e601, 0xffe8e301, 0xffe7e202, 0xffe7df00, 0xffe6de00, 0xffe4da00, 0xffe2d700, 0xffe2d400, 0xffe1d300, 0xffdecd01, 0xffdccb01, 0xffdac900, 0xffd9c600, 0xffddcb00, 0xfff5cc02, 0xfffcc900, 0xfffbc501, 0xffc7a122, 0xff907f49, 0xffbfc024, 0xffe3e40a, 0xfff1f201, 0xfff0ef00, 0xffefee00, 0xffedeb02, 0xffeae800, 0xffe7e401, 0xffe7e200, 0xffe8e001, 0xffe7df02, 0xffe5dc01, 0xffe3d802, 0xffe1d602, 0xffe0d501, 0xffdecf00, 0xffddce01, 0xffdbc903, 0xffd9c701, 0xffd8c401, 0xffd8c101, 0xffd7be01, 0xffd6bd01, 0xffd5bb02, 0xffd4ba01, 0xffd3b602, 0xffd1b401, 0xffd0b300, 0xffd0b101, 0xffcfb000, 0xffceaf00, 0xffcead00, 0xffccac00, 0xffccac01, 0xffcbab00, 0xffcdad02, 0xffd0b100, 0xffe7c501, 0xfff4c901, 0xffbd9c28, 0xff8d7d4c, 0xffb7b127, 0xffd8d20e, 0xffe6dd02, 0xffe5da02, 0xffe3d500, 0xffe2d401, 0xffdfcf00, 0xffdccb02, 0xffd8c500, 0xffd8c100, 0xffd6bf00, 0xffd5bc00, 0xffd1b700, 0xffd2b501, 0xffcfb101, 0xffceb000, 0xffceae01, 0xffcfae01, 0xffcdab01, 0xffcdac00, 0xffccaa00, 0xffccaa02, 0xffcba901, 0xffcdad00, 0xffddbe01, 0xffebc701, 0xfffac306, 0xff8a7c4d, 0xff898047, 0xffa59428, 0xffcbac06, 0xffcfad03, 0xffcbab02, 0xffcaaa01, 0xffd2b100, 0xffdbbc00, 0xfff6c801, 0xfffcc602, 0xffbc9b28, 0xff8a7c4b, 0xff767058, 0xff8b8042, 0xffbca00e, 0xffc7a800, 0xffd4b400, 0xffeec602, 0xfff8c901, 0xffba982c, 0xff897b4e, 0xff656567, 0xff6d6a61, 0xff90813e, 0xffab9420, 0xffc9a805, 0xffcaa902, 0xffcba900, 0xffccab00, 0xffcaaa00, 0xffdebd00, 0xffecc400, 0xfff6c004, 0xffad9032, 0xff807653, 0xff78744f, 0xff91833a, 0xffc0a20c, 0xffc8a805, 0xffd5b701, 0xffe3c100, 0xfffaca00, 0xfffcc601, 0xfff7c105, 0xffaa8f34, 0xff706d5e, 0xff9c8832, 0xffb29b19, 0xffcba804, 0xffcea900, 0xffeec302, 0xfff7c701, 0xfffdc703, 0xffa99036, 0xff847a47, 0xff9d8d2e, 0xffc6a606, 0xffe4c103, 0xfff1c701, 0xffffc603, 0xffa78f39, 0xff7d7455, 0xff76705a, 0xffa79323, 0xffbca010, 0xffd4b600, 0xffe1c001, 0xfff9c801, 0xfff4be06, 0xff9c883f, 0xff8e803f, 0xffa79225, 0xffc8a808, 0xffcbaa03, 0xffd8ba02, 0xfffbc701, 0xff988543, 0xff736d5d, 0xff6d6b5f, 0xff797552, 0xffab951e, 0xffc1a20c, 0xffcfaf02, 0xffe3c201, 0xfff1c700, 0xff978547, 0xff968537, 0xffaf961f, 0xffc8a903, 0xffdbbc01, 0xffebc500, 0xfffdc702, 0xff726d5a, 0xff817948, 0xffb49c16, 0xffc6a605, 0xffd7b901, 0xfffcc802, 0xfff2bb08, 0xff958247, 0xff6b6863, 0xff716e5d, 0xffa28f29, 0xffba9d13, 0xffc9aa02, 0xfff0bc08, 0xff948146, 0xff716e5f, 0xff66656a, 0xff777254, 0xff8d7f40, 0xffbaa00f, 0xffc7a707, 0xffdabb01, 0xffe9c402, 0xfff7c502, 0xffefbc09, 0xff948147, 0xff767056, 0xffa99222, 0xffbea00e, 0xffd3b500, 0xffdfbe01, 0xfff5c501, 0xffeebd09, 0xff7e754e, 0xff958436, 0xffc1a40b, 0xffcca903, 0xffcdab03, 0xffd2b102, 0xffe8c100, 0xffe5bc08, 0xff907f47, 0xff7e774d, 0xffb2991b, 0xffc2a30a, 0xffcba802, 0xffcea902, 0xffdebc03, 0xff8c7f4a, 0xff877c44, 0xffa3902a, 0xffc8a607, 0xffcaa701, 0xffc9a801, 0xffcaa904, 0xffc7a706, 0xffc5a806, 0xffc3a507, 0xffc5a409, 0xffc3a509, 0xffc2a408, 0xffc2a90f, 0xffbda61a, 0xff817a50, 0xff6b6b5f, 0xff757158, 0xff8a7e42, 0xffb99e11, 0xffc5a407, 0xffc7a704, 0xffc8a606, 0xffc4a608, 0xffc2a30b, 0xffbfa10b, 0xffbfa10d, 0xffc0a20e, 0xffba9d11, 0xffb89c15, 0xffb69b16, 0xffb69a15, 0xffb69b18, 0xffb5991b, 0xffac961e, 0xffaa9520, 0xffab9422, 0xffa99323, 0xffa89223, 0xffa59027, 0xffa39228, 0xff9e8f32, 0xff777358, 0xff686961, 0xff897d41, 0xff9a8931, 0xffa38d2a, 0xffa18d2a, 0xff9f8c2d, 0xff8f803b, 0xff887c42, 0xff877c46, 0xff867b45, 0xff867a46, 0xff857b48, 0xff847a49, 0xff83784b, 0xff80784a, 0xff83784a, 0xff7c7450, 0xff777252, 0xff767354, 0xff6e6c5d, 0xff6e6a5e]
				); 
        }
		public function box4():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,1,2,3,0,4,5,6,7,8,9,10,11,12,13,14,15,16,17,16,0,18,3,3,0,0,16,19,19,18,18,0,0,16,0,0,16,0,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,18,21,22,0,10,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,17,17,42,42,16,0,18,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,44,45,46,47,48,47,48,49,50,51,52,28,53,54,55,56,57,58,59,36,37,60,61,62,41,63,0,16,16,0,0,0,0,16,18,0,0,0,0,0,0,0,0,18,18,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,17,64,65,66,67,68,48,69,70,70,70,67,71,68,48,48,72,73,74,75,76,77,78,79,80,81,82,59,83,84,38,85,86,41,0,17,0,0,0,0,18,18,0,0,0,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,18,1,38,87,88,67,71,48,67,67,70,71,71,68,68,70,89,67,67,90,67,91,73,92,93,94,95,54,96,80,97,98,99,100,101,102,61,62,103,17,17,16,16,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,16,0,104,105,106,107,70,70,70,48,108,109,110,111,68,111,70,70,71,67,71,70,112,113,70,68,114,112,48,48,115,116,74,117,118,119,120,121,122,123,124,125,36,126,127,85,128,129,63,16,16,0,19], 
    [0,0,0,0,0,0,0,0,0,0,0,0,18,130,131,132,133,70,68,112,134,135,136,137,138,139,140,141,142,70,67,70,143,48,67,68,68,70,67,70,68,68,112,48,144,145,146,74,93,118,147,148,96,149,150,151,125,152,153,12,154,155,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,3,0,156,157,158,68,70,71,159,160,161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,48,67,177,48,70,70,67,112,70,71,71,70,70,69,178,178,179,180,92,181,182,183,184,185,44,0,18], 
    [0,0,0,0,0,0,0,0,0,0,0,0,186,187,188,178,70,70,112,189,190,191,192,193,194,195,196,197,198,199,200,201,202,203,204,205,206,207,208,209,210,110,72,112,112,70,70,70,71,68,68,70,70,211,67,48,90,72,212,213,214,215,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,17,216,217,218,70,70,70,70,219,220,221,222,223,224,225,226,224,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,209,247,142,67,71,71,67,70,71,67,90,248,249,250,18,0], 
    [0,0,0,0,0,0,0,0,0,0,0,186,38,251,93,67,68,70,111,252,253,254,255,256,227,257,227,258,258,259,225,260,226,261,228,262,263,264,265,266,267,163,268,269,270,271,272,273,274,171,275,276,277,68,211,71,177,70,278,279,280,44,281,3], 
    [0,0,0,0,0,0,0,0,0,0,0,282,283,284,49,67,285,286,141,287,288,289,290,291,292,258,227,258,258,258,258,258,258,258,258,258,258,227,258,258,258,261,261,293,294,295,296,297,298,299,300,301,302,67,70,68,67,70,303,304,305,43,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,306,307,93,144,70,67,48,308,309,310,311,312,313,314,259,258,258,258,258,258,258,258,258,258,258,258,227,258,258,315,315,315,258,259,224,259,316,317,318,319,320,321,67,70,70,285,111,322,323,324,43,19,18], 
    [0,0,0,0,0,0,0,0,0,0,16,325,157,47,48,211,67,326,327,328,329,330,331,332,291,258,258,258,258,258,258,258,258,258,258,258,258,224,224,258,258,258,258,258,258,226,226,224,333,334,335,336,337,48,48,70,70,338,339,340,341,16,0,3], 
    [0,0,0,0,0,0,0,16,0,0,44,307,251,112,70,211,67,342,343,344,345,330,311,346,347,227,224,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,333,227,227,227,333,227,348,349,350,351,70,70,68,68,352,353,354,355,16,0,0], 
    [0,0,0,0,0,0,18,16,0,17,86,356,218,67,67,70,68,357,358,329,359,360,361,362,363,292,227,258,258,258,258,258,258,258,258,258,258,224,224,259,364,258,258,227,227,227,365,223,258,366,367,368,369,70,89,48,67,370,371,372,355,3,0,19], 
    [0,0,0,0,0,0,42,0,42,373,374,375,376,70,67,67,68,377,378,379,360,360,311,380,381,292,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,225,382,383,384,178,67,71,385,71,386,387,388,389,0,0,0], 
    [0,0,0,0,0,21,16,18,1,13,390,284,72,67,67,70,247,391,392,393,394,360,330,361,395,291,256,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,261,396,397,398,67,67,70,48,110,399,400,401,402,0,0,0], 
    [0,0,0,0,0,0,16,18,20,403,307,404,48,70,70,48,342,405,406,407,394,360,330,408,380,409,410,259,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,411,412,413,144,68,67,70,48,110,414,415,416,402,43,0,0], 
    [0,0,0,0,0,18,3,0,16,390,417,133,68,71,71,418,327,419,420,393,421,360,360,360,289,422,423,258,224,258,258,224,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,424,425,426,71,67,70,70,48,427,428,429,416,402,0,0,0], 
    [0,0,0,0,0,16,16,0,430,431,78,144,70,67,71,342,432,310,433,360,330,360,360,360,331,434,435,223,259,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,436,437,438,67,70,70,70,439,440,441,442,443,444,0,0,0], 
    [0,0,0,0,0,445,43,1,446,447,448,71,69,67,70,449,450,451,407,452,452,360,360,360,360,362,453,454,258,455,224,258,224,258,258,258,258,258,258,258,258,258,258,227,227,333,223,456,457,458,140,113,70,70,68,352,459,415,442,460,461,0,16,0], 
    [0,0,0,0,0,0,462,463,464,120,465,113,68,67,48,466,467,468,407,469,360,360,360,330,360,470,346,471,227,258,223,333,258,258,258,258,258,258,258,258,258,258,258,258,258,224,227,472,473,474,475,68,70,67,68,476,477,478,442,479,480,0,0,0], 
    [0,0,0,0,0,481,482,483,484,485,91,67,67,486,326,487,488,331,360,360,452,360,360,360,360,331,362,291,316,258,258,227,258,258,223,258,258,258,258,258,258,258,258,489,490,259,261,382,491,492,67,48,68,67,68,493,494,495,496,497,498,0,18,16], 
    [0,0,0,0,0,481,3,499,500,501,133,67,70,111,502,503,504,393,407,330,452,360,360,360,360,331,312,347,292,258,258,333,258,258,258,258,258,258,258,258,258,258,258,258,227,505,259,506,507,175,48,508,211,67,48,509,510,511,512,513,514,0,18,16], 
    [0,0,0,0,0,0,44,515,516,115,68,177,67,326,517,518,519,330,469,452,360,520,330,360,360,360,521,522,523,261,261,227,223,258,258,224,258,258,258,258,258,258,258,411,411,258,223,524,525,526,48,70,70,67,369,371,527,511,528,513,529,0,0,0], 
    [0,0,0,0,0,42,530,531,120,532,68,70,285,533,534,535,468,330,469,360,360,520,330,330,330,360,408,536,537,538,539,540,541,223,223,258,258,258,258,258,258,258,258,333,224,258,542,543,544,545,70,48,486,67,546,547,415,511,528,513,498,18,0,0], 
    [18,0,0,0,0,43,282,548,549,508,508,48,67,449,550,329,360,360,360,360,360,360,330,360,330,360,551,552,553,554,555,556,557,558,559,560,561,562,563,294,564,227,365,258,225,316,193,565,566,70,67,67,70,567,568,441,478,511,569,570,571,19,0,18], 
    [18,0,0,0,0,44,499,572,181,70,70,71,71,573,574,575,360,360,360,360,360,360,360,360,330,360,576,577,578,579,580,581,582,583,584,585,586,587,588,589,538,563,540,590,316,294,591,592,593,68,67,70,70,338,594,527,511,511,595,596,597,19,0,0], 
    [16,18,0,0,0,216,598,599,133,71,71,285,398,600,601,360,360,360,360,360,360,330,360,520,330,408,602,603,604,3,0,21,605,0,19,606,607,608,609,610,611,612,556,613,614,615,616,617,618,70,211,67,67,619,620,621,478,511,622,623,624,0,18,0], 
    [16,0,0,18,0,625,431,465,112,177,68,48,626,627,628,407,360,360,360,360,360,330,360,520,360,629,630,631,632,3,3,19,0,0,0,0,155,3,3,633,634,609,581,635,555,636,637,638,111,70,68,67,67,639,640,641,478,641,642,643,644,0,0,0], 
    [0,0,16,18,44,5,645,179,71,70,646,647,648,649,650,651,360,360,360,360,360,360,360,360,330,652,653,654,3,18,655,19,18,0,0,18,19,16,3,0,0,18,18,18,16,656,657,133,67,70,67,70,48,658,659,660,495,511,661,662,663,0,481,0], 
    [16,0,42,664,41,665,666,112,70,70,70,140,667,668,575,469,311,330,330,452,669,670,360,452,671,672,673,674,0,0,0,481,18,0,0,0,0,0,0,0,0,0,0,675,17,131,676,48,677,70,71,48,439,678,679,660,478,680,681,682,624,0,43,18], 
    [42,0,0,63,85,683,599,68,67,70,70,684,685,686,687,688,433,689,393,330,407,408,690,520,452,691,692,20,19,0,3,3,0,16,16,0,16,0,0,0,0,0,0,17,693,694,695,211,68,68,70,67,176,696,697,698,680,680,699,700,701,16,0,18], 
    [42,18,18,41,702,703,501,71,67,67,70,704,705,706,707,708,709,710,711,712,713,714,714,715,551,716,717,718,18,19,19,19,18,0,0,0,0,0,0,0,0,0,0,17,483,719,720,68,70,48,70,48,721,722,723,698,680,724,699,725,726,0,0,18], 
    [632,0,16,727,728,729,47,71,67,71,67,90,730,342,731,732,733,734,735,736,737,738,739,740,741,742,743,103,250,0,3,43,0,0,0,0,16,0,0,0,0,0,0,41,744,745,746,70,211,70,68,747,748,415,680,698,680,680,749,750,751,0,0,0], 
    [16,0,16,702,752,92,178,177,67,71,70,67,67,211,47,326,753,754,755,756,757,758,759,760,761,324,762,763,764,85,483,41,250,22,0,0,0,0,0,0,0,0,0,693,765,66,766,48,68,70,68,352,767,723,768,698,680,680,769,355,770,0,0,0], 
    [42,16,16,771,772,145,112,70,211,67,70,71,68,48,70,48,71,68,70,285,285,90,142,773,774,376,52,775,776,79,777,778,779,780,781,782,38,282,14,44,17,0,17,783,784,785,90,70,70,68,68,786,371,495,680,478,787,788,789,790,791,0,0,19], 
    [42,0,43,792,793,794,418,747,91,90,112,68,211,67,67,68,67,68,68,70,68,70,70,48,48,71,795,796,797,798,799,800,801,802,417,803,151,804,10,805,12,806,129,126,97,146,48,71,70,70,68,807,494,511,511,788,511,442,808,809,810,18,18,481], 
    [20,43,17,811,812,813,814,815,816,817,818,819,820,647,821,47,144,211,211,67,70,68,68,68,68,67,67,70,70,67,67,67,211,133,49,746,785,799,822,823,824,217,825,826,827,110,70,68,68,48,439,828,829,660,478,768,830,831,832,833,834,0,0,0], 
    [16,0,0,835,836,837,838,839,840,841,842,843,844,845,846,847,848,849,850,48,48,67,67,70,70,70,486,67,67,70,70,70,71,211,68,70,48,47,277,851,852,853,854,855,856,67,67,48,70,48,110,857,400,680,511,768,478,858,859,860,482,0,16,0], 
    [0,0,43,44,861,862,863,864,865,866,867,868,869,870,871,872,873,874,875,876,877,878,819,753,647,145,47,48,48,67,67,70,486,89,89,68,70,68,68,68,67,70,68,71,71,67,68,48,67,48,427,510,723,768,478,680,478,879,880,881,22,18,0,0], 
    [0,16,482,481,250,882,883,884,885,866,885,865,866,865,865,886,886,887,888,889,890,891,892,893,894,895,847,896,897,144,48,48,70,71,211,71,68,48,48,70,70,67,68,71,68,48,67,211,67,439,898,441,478,478,621,698,511,899,900,43,16,0,0,0], 
    [0,0,16,18,22,901,902,903,904,885,865,865,865,865,865,865,865,865,865,865,865,905,905,870,871,906,907,908,909,910,911,912,913,914,915,747,747,90,90,71,71,68,70,70,70,68,68,68,70,916,917,723,478,768,768,511,496,918,919,22,0,0,3,19], 
    [16,0,0,18,632,920,921,922,923,924,885,865,865,865,865,865,885,885,865,865,865,865,865,885,867,905,925,870,926,927,928,929,930,931,893,846,932,933,934,145,144,112,112,71,71,71,71,211,68,476,620,723,478,787,768,478,935,936,937,0,0,0,0,21], 
    [0,0,0,0,0,3,938,939,940,885,864,865,865,865,865,865,865,865,865,865,941,885,867,885,885,885,885,924,866,865,885,942,905,943,944,945,946,947,948,949,950,951,952,953,954,647,747,439,144,955,956,478,511,680,511,511,957,958,959,0,0,0,0,18], 
    [0,0,0,16,0,16,960,961,962,963,885,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,885,885,865,865,885,885,924,941,941,885,905,925,964,888,965,841,966,967,968,969,970,847,971,972,973,768,680,680,768,442,974,975,938,0,0,0,0,18], 
    [0,16,0,18,0,18,22,976,977,978,979,865,865,865,865,865,885,885,865,865,865,865,865,865,865,865,865,885,885,924,924,866,941,865,865,885,865,884,884,865,941,885,885,943,869,980,981,907,982,983,984,680,985,478,680,986,899,987,988,0,0,0,16,0], 
    [0,0,0,0,0,482,0,989,990,991,992,865,866,885,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,905,905,981,993,994,680,768,698,660,957,995,996,1,0,0,0,0,0], 
    [0,0,0,0,0,21,16,0,997,998,999,1000,865,941,885,1001,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,1002,1003,1004,511,830,768,511,1005,1006,1007,0,0,0,0,0,0], 
    [0,0,0,0,0,19,3,0,215,1008,1009,904,865,866,924,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,941,941,905,1010,1011,680,830,787,511,1012,1013,186,19,0,0,0,0,0], 
    [0,0,0,0,0,0,3,21,43,1014,1015,1016,864,941,885,885,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,1017,1018,1019,1020,478,698,528,1021,1022,3,0,0,0,0,0,0], 
    [0,0,0,0,0,0,18,0,17,1023,1024,1025,1026,865,885,1000,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,866,1027,1028,1029,511,698,1030,1031,1032,16,22,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,16,16,1033,1034,884,1017,864,864,866,885,924,866,865,1000,1017,885,865,924,885,865,885,885,1035,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,885,1036,1037,1038,768,660,1039,1040,1041,0,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,16,1042,1043,1044,884,884,885,865,865,865,865,885,1000,1017,1000,1045,1046,865,865,866,924,924,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,964,1047,1048,478,1049,1050,444,1051,18,42,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,154,1052,1053,1054,1055,1056,903,1057,884,885,1000,1058,924,924,885,1059,865,865,865,865,1060,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,866,943,1061,1062,621,699,1063,1064,215,481,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,43,40,1065,1066,1067,1068,1069,1070,1071,1072,1073,1058,1000,885,866,866,924,924,885,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,866,1002,906,1074,641,1075,1076,996,3,1077,18,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,42,44,44,997,1078,861,1079,1080,1081,1082,1083,1084,1085,1086,1026,1087,1088,865,885,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,905,1089,1090,1091,1092,1031,1023,16,0,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,19,18,19,22,0,430,938,1093,1094,1095,1096,1097,1068,1054,1098,1016,1099,1057,884,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,865,1100,1019,1101,1102,1103,17,718,0,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,16,16,17,988,938,1104,1105,1106,1107,1108,1109,1110,1085,1055,903,1057,1111,1112,924,865,885,865,885,885,924,885,866,1017,866,1113,1114,1115,1116,1117,3,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,19,19,19,186,103,1118,1119,1065,1120,1121,1122,1054,1123,1124,1125,1057,923,1000,865,924,866,924,1000,941,1058,924,867,1126,1127,1128,1129,0,0,0,18,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,481,16,16,0,3,3,0,3,0,0,0,17,1130,881,14,1131,1106,1132,1133,1134,1135,1136,940,1137,992,923,884,866,866,865,907,1138,1139,1140,0,18,16,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,0,16,16,0,0,16,16,0,18,16,16,155,17,1078,1141,1142,1143,1144,1145,1146,1147,1148,1149,1150,1099,904,1059,1151,1152,1153,1154,0,21,20,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,18,0,0,0,0,0,0,16,0,18,16,21,18,16,16,655,0,0,0,0,834,989,1155,1156,1157,1144,1158,1159,1160,1161,1162,1163,215,3,481,281,3,0,0,0,0,0]
],
[0xff666666, 0xff666762, 0xff646663, 0xff676566, 0xff71705e, 0xff8b8e49, 0xffc2c91b, 0xffb5ba28, 0xff929642, 0xff8d9147, 0xff82854e, 0xff7a7c55, 0xff6f705e, 0xff6d6d63, 0xff6c6c60, 0xff6a6b65, 0xff666664, 0xff676765, 0xff666668, 0xff656766, 0xff656565, 0xff656668, 0xff676664, 0xffb1b82c, 0xffeef605, 0xffeef803, 0xffecf305, 0xffebf107, 0xffe1e90c, 0xffd8e011, 0xffc9d01e, 0xffc6cc22, 0xffb5ba2a, 0xffa6ab33, 0xff939444, 0xff8e8f49, 0xff86874d, 0xff7d7e54, 0xff70725d, 0xff6d6e5e, 0xff6b6b5f, 0xff696a64, 0xff676568, 0xff676767, 0xff676863, 0xff8f9346, 0xffc4cc1f, 0xfff3fc01, 0xfff4fe00, 0xfff1fc02, 0xffeff904, 0xffebf403, 0xffe9f106, 0xffd9e112, 0xffcad21c, 0xffc5cd1f, 0xffb8be2a, 0xffa9ad34, 0xff949547, 0xff8e9047, 0xff6f7060, 0xff6e6f61, 0xff6c6c62, 0xff666865, 0xff6a6c61, 0xffb4b82f, 0xffdee80d, 0xfff5ff01, 0xfff4ff00, 0xfff5ff02, 0xfff5ff00, 0xfff4ff01, 0xfff3fc03, 0xfff0fa03, 0xffecf506, 0xffe9f306, 0xffe0eb0b, 0xffd8e210, 0xffcbd31d, 0xffc6cd1f, 0xffb8be28, 0xffaaaf31, 0xff939645, 0xff84884d, 0xff7c7f52, 0xff6e6f5f, 0xff6b6c64, 0xffc5cc1e, 0xffe7f105, 0xfff6ff01, 0xfff4fd02, 0xfff1fc00, 0xffedf605, 0xffeaf306, 0xffe3eb0e, 0xffdae213, 0xffc7ce20, 0xffabb032, 0xff949844, 0xff8e9045, 0xff84874e, 0xff7e7f55, 0xff72715c, 0xff696a62, 0xff6c6d5f, 0xff848452, 0xffdde70d, 0xfff0fc04, 0xfff3f605, 0xfff2f504, 0xfff5fc01, 0xfff6fd00, 0xfff3fe00, 0xfff3ff01, 0xfff2ff00, 0xfff2fb02, 0xfff1fa03, 0xffeaf207, 0xffe2ea0b, 0xffd9e110, 0xffcbd31b, 0xffc5ce1d, 0xffb8bf24, 0xffacb130, 0xff969844, 0xff8f9148, 0xff7f8054, 0xff71735d, 0xff6c6e61, 0xff6a6b63, 0xff70725c, 0xff919445, 0xffe9f20b, 0xfff2fd01, 0xfff2f705, 0xffead115, 0xffeaca15, 0xfff5e509, 0xfff5ec09, 0xfff0f209, 0xfff1f405, 0xfff3f702, 0xfff4fa02, 0xfff2ff02, 0xfff3fd00, 0xfff2fb00, 0xfff0f804, 0xffdae30e, 0xffced41a, 0xffb9c024, 0xffadb32d, 0xff949843, 0xff85894c, 0xff7f8150, 0xff6a6964, 0xff666867, 0xff85894e, 0xffbabf25, 0xfff2fd03, 0xfff2f603, 0xffe7d00e, 0xffce3c47, 0xffdd2853, 0xfff0414e, 0xffee4854, 0xffe2555b, 0xffdd5e4d, 0xffed8a25, 0xfff3a51f, 0xffecb827, 0xffe7bd29, 0xffedce11, 0xfff4dc0a, 0xfff3f003, 0xfff3f108, 0xfff3f305, 0xfff6f801, 0xfff4ff03, 0xfff3fe02, 0xfff2fc05, 0xfff0fa05, 0xffebf405, 0xffe1ec0a, 0xffdbe411, 0xffb9bd2b, 0xff949245, 0xff686964, 0xff939743, 0xffc8d01b, 0xfff0ee05, 0xffdfb918, 0xffc31d4f, 0xffda085f, 0xfff10e67, 0xfff20f6b, 0xffe9146e, 0xffe41a63, 0xffef3451, 0xfff1434c, 0xffe5525a, 0xffdc5a5c, 0xffe87931, 0xfff19321, 0xfff1b320, 0xffebb725, 0xffe8c61e, 0xfff1d510, 0xfff3ec06, 0xfff4f008, 0xfff2f208, 0xfff3f403, 0xfff3ff00, 0xfff0f902, 0xffd2d419, 0xffa29e3a, 0xff686763, 0xff6c6e60, 0xffb9bf27, 0xffe3eb0c, 0xffe3cf0e, 0xffc37b27, 0xffad074f, 0xffc70159, 0xffee016d, 0xfff1006d, 0xfff0006f, 0xfff00169, 0xfff0006b, 0xffee026e, 0xffed046f, 0xfff00665, 0xffef0a65, 0xffef1069, 0xffe9126d, 0xffe52362, 0xffee3157, 0xffee474f, 0xffeb4b53, 0xffe05a4f, 0xffe06c3d, 0xfff4a224, 0xfff3af20, 0xffecb824, 0xffebbe1d, 0xfff3d709, 0xfff6e708, 0xfff4f009, 0xfff3f704, 0xffd6cd18, 0xffa1963c, 0xff696864, 0xffc9d11c, 0xffdaba17, 0xffb65c37, 0xffa2044e, 0xffbc0054, 0xffec006c, 0xfff00070, 0xfff0006d, 0xfff1016e, 0xffef026e, 0xffef026c, 0xffec0669, 0xffef0a67, 0xfff20e67, 0xffee0f68, 0xffe71868, 0xffe7215c, 0xffef4852, 0xffe65155, 0xffe25b48, 0xffed8a24, 0xfff4a620, 0xffefb629, 0xffeabc29, 0xfff1dd0a, 0xfff4f408, 0xfff2fb04, 0xfff5fb03, 0xffd3c51a, 0xff9e8e40, 0xff66656a, 0xff6d6d61, 0xff888a49, 0xffe3eb0a, 0xfff7fe01, 0xfff6fe00, 0xffc48423, 0xffa8303c, 0xff9c004a, 0xffab004f, 0xffe20064, 0xffed006a, 0xffed016d, 0xffec036c, 0xffef0866, 0xfff10c67, 0xffec116d, 0xffe71671, 0xffed2a56, 0xffec3b4f, 0xffe48f32, 0xffecd317, 0xfff7f902, 0xffd1b81d, 0xff938546, 0xff72715d, 0xff949643, 0xfff0f006, 0xffb76130, 0xffa01d45, 0xff9a0049, 0xffa3014d, 0xffda0061, 0xffea016a, 0xfff1006f, 0xffee016b, 0xfff0036f, 0xfff10766, 0xffee1161, 0xffe87c33, 0xffeecf14, 0xfff5f501, 0xffd1b31d, 0xff938347, 0xff888a4b, 0xfff2f804, 0xffe4d40b, 0xffa9313d, 0xff9b094a, 0xff97014b, 0xff9b014a, 0xffc80059, 0xfff1006b, 0xffee0169, 0xffec1269, 0xffeeb123, 0xfff0ed08, 0xfff5fa00, 0xfff6ec00, 0xffd2ad1e, 0xff918247, 0xffeff205, 0xffdbbf13, 0xff9f1c44, 0xff990448, 0xffbd0055, 0xffdc0062, 0xffef0568, 0xffe81c65, 0xffe8c31c, 0xfff0f306, 0xfff7f701, 0xfff9e701, 0xffd2ab1f, 0xff918249, 0xffb9c025, 0xffe4d30a, 0xffc68423, 0xff98014e, 0xff98004b, 0xff9b004c, 0xffa9014f, 0xffc8005b, 0xfff10170, 0xffef006a, 0xffec1068, 0xffea4452, 0xfff2e50a, 0xfff6fb00, 0xfff9ee00, 0xfffbd800, 0xffd3a91f, 0xff676964, 0xff73735b, 0xffcacf1a, 0xffebf308, 0xffdbc011, 0xffb56132, 0xff99064c, 0xffa1004e, 0xffbb0057, 0xffea166a, 0xffe55753, 0xfff3ef08, 0xfff6ff02, 0xfffae903, 0xfffad500, 0xffcda71e, 0xff918048, 0xff88894d, 0xffc58524, 0xffa6303c, 0xff99014a, 0xff97004c, 0xffa90051, 0xffec3853, 0xffed912c, 0xfff4f801, 0xfff9dd00, 0xfffecb00, 0xffcba51e, 0xff907f49, 0xff73725d, 0xffeaf407, 0xffb56331, 0xff9f1d43, 0xff970149, 0xff99014c, 0xffdb0162, 0xffec016a, 0xfff1016c, 0xffe74c50, 0xffefad23, 0xfffbd802, 0xfffec901, 0xffcca41e, 0xffbac126, 0xfff2f802, 0xffa7313d, 0xff9b0948, 0xff98024c, 0xffc7005b, 0xffe30167, 0xffed0767, 0xffe77537, 0xffeecc15, 0xfff7f502, 0xfffdd001, 0xfffdc500, 0xff696866, 0xff979a41, 0xffdbc116, 0xff980647, 0xffbb0155, 0xffdb0064, 0xffef0c68, 0xffef9a26, 0xfff3e007, 0xfff5fc00, 0xfff9f001, 0xfffdcd01, 0xfffdc401, 0xffcba31d, 0xff8f7e48, 0xff67656a, 0xff6f6f63, 0xffbec422, 0xffe5ed0c, 0xffe7d80b, 0xffca8921, 0xff9c0a4b, 0xff980049, 0xffc60159, 0xffed006c, 0xfff2006d, 0xffed056b, 0xffe72061, 0xffeac51e, 0xfffce501, 0xffc8a31e, 0xff8f7e46, 0xff656563, 0xff686866, 0xff73755f, 0xffebf606, 0xffddc314, 0xffb96830, 0xff9a044b, 0xff98004d, 0xffa5004d, 0xffeb0069, 0xffef0969, 0xffea3556, 0xfff0d911, 0xfff4f805, 0xfff8f301, 0xfff9e000, 0xffffc702, 0xffc5a222, 0xff8d7d49, 0xff656764, 0xff686667, 0xff6d6e60, 0xff8a8d4a, 0xffe4ed0a, 0xfff7fe00, 0xffcb8c22, 0xffa9343c, 0xfff0006c, 0xffef0068, 0xffe75653, 0xfff2f008, 0xfff8ea01, 0xfffbd601, 0xfffec502, 0xfffbc501, 0xffbd9d26, 0xff877a4d, 0xff74745c, 0xff979b3d, 0xffecf508, 0xfff0f208, 0xffbc6730, 0xffa22046, 0xffee006f, 0xffe7245e, 0xffe86e3f, 0xfff5fe03, 0xfffae502, 0xfffed102, 0xfffec601, 0xfffac400, 0xffbd9c28, 0xff88794e, 0xff8b8c4a, 0xffbec426, 0xffe7d60a, 0xffac343e, 0xff9c0b46, 0xff9a004b, 0xff9c004c, 0xffc60058, 0xffdd0364, 0xffe64d50, 0xffecaf23, 0xfff6fd02, 0xfffecb02, 0xfffdc403, 0xff887a4d, 0xff676862, 0xff969b41, 0xfff3fe04, 0xffeff203, 0xffddc213, 0xffa31f46, 0xffb70657, 0xffc90d62, 0xffe00a6a, 0xffe5096b, 0xffea056c, 0xffeb026d, 0xffed046d, 0xffe4624c, 0xffecc21e, 0xfff6fc04, 0xfff7f900, 0xfffad502, 0xffbcc325, 0xffe4ed08, 0xffca8b22, 0xff99034b, 0xff8f2556, 0xff834260, 0xff844e68, 0xff8c4968, 0xff9a3f68, 0xffa83368, 0xffbf2267, 0xffc61e69, 0xffd4146a, 0xffdd0d6b, 0xffe5076c, 0xffe7066c, 0xffed026b, 0xfff3a026, 0xfff3e30a, 0xfff6fb01, 0xfff6ef00, 0xfffac402, 0xffba9a2b, 0xff86794f, 0xffccd41c, 0xffe0c216, 0xffbb6630, 0xff9b064a, 0xff96044b, 0xff803659, 0xff715563, 0xff6c6167, 0xff6f6067, 0xff755965, 0xff7b5466, 0xff8a4a65, 0xff8e4767, 0xffa33769, 0xffb12b68, 0xffc51f6b, 0xffca1b6a, 0xffdb0e69, 0xffed0269, 0xffe91468, 0xffeeb623, 0xfff5ef05, 0xfff7eb00, 0xfff9c203, 0xffb39630, 0xff827552, 0xff8a8c4d, 0xffe6ef0a, 0xffce8f1e, 0xffad363a, 0xff920d4f, 0xff744d62, 0xff6a6166, 0xff686669, 0xff696365, 0xff6b6265, 0xff6e5f64, 0xff715d66, 0xff7f5267, 0xff854d68, 0xff944469, 0xffb42865, 0xffbf216c, 0xffcb2567, 0xffd74655, 0xffeddb0d, 0xfff3f903, 0xfff6f400, 0xfffae101, 0xfffdc702, 0xfff9c205, 0xffa98e37, 0xff7c7257, 0xff72745c, 0xfff0f302, 0xffc16929, 0xffa61f3f, 0xff97044b, 0xff8f1552, 0xff6c5662, 0xff666465, 0xff6a6468, 0xff6b6267, 0xff844e65, 0xffa1505f, 0xffbe7844, 0xffefee08, 0xfff7f001, 0xfffbda01, 0xfffcc601, 0xfff8c305, 0xffa78d38, 0xff7b7156, 0xffbec621, 0xfff6ff00, 0xfff2f800, 0xffe8dd07, 0xffae373d, 0xff9d0b49, 0xff990048, 0xff940c4e, 0xff892557, 0xff696065, 0xff676769, 0xff898b4c, 0xffbcc129, 0xfff8e800, 0xfffcd201, 0xfffec600, 0xfff8c104, 0xffa88e37, 0xff7a7356, 0xff65666a, 0xff9a9e3d, 0xffcfd519, 0xffe2c511, 0xffa72041, 0xff97004a, 0xff97004d, 0xff970148, 0xff901251, 0xff81335a, 0xff686266, 0xff656661, 0xffc6cf1a, 0xfff7ff00, 0xfffddc01, 0xfffdcf00, 0xffffc501, 0xfff7c204, 0xffa88e39, 0xffc0c922, 0xfff1eb03, 0xffdbae15, 0xffa32147, 0xff9f144d, 0xff9e0a46, 0xff9a024b, 0xff96034a, 0xff872556, 0xff754b61, 0xff6b6b61, 0xffb1b52d, 0xffdee40e, 0xfffcd400, 0xfffdca01, 0xffffc500, 0xfff7c105, 0xffa38c3c, 0xff797258, 0xff76765a, 0xffd0d718, 0xfff1ee03, 0xffe1c10e, 0xffb45a38, 0xffb24e3e, 0xffad3235, 0xffa4223c, 0xff9d124d, 0xff9e0f47, 0xff9a0849, 0xff97044a, 0xff98024a, 0xff99014e, 0xff803259, 0xff705463, 0xff646567, 0xffbfc621, 0xffe7ee0a, 0xfff6f401, 0xfffed001, 0xffffc801, 0xfffec400, 0xff9c883f, 0xff756e5b, 0xff6e6e62, 0xff8e8d4a, 0xffe7ef08, 0xfff4f803, 0xffefef05, 0xffe8d806, 0xffe3c70e, 0xffd9b41d, 0xffd9ab18, 0xffc47a23, 0xffb66233, 0xffaf4c39, 0xffaf3e36, 0xffa3223e, 0xff992049, 0xff7a555c, 0xff70675e, 0xff797a58, 0xffd4dc15, 0xffeef804, 0xfff4fb00, 0xfff7ed02, 0xfff6c006, 0xff938348, 0xff706c60, 0xff9d9f3c, 0xfff1f502, 0xffeef006, 0xffeeea03, 0xffe2ce0b, 0xffdcc213, 0xffd8b01a, 0xffd49e18, 0xffbe6b25, 0xffad6437, 0xff8e8b46, 0xff7e8250, 0xff787959, 0xff84844e, 0xfff1fb04, 0xfffae802, 0xffffc602, 0xfff6c008, 0xff6f6d61, 0xff8b8b4b, 0xffc0c521, 0xfff0f503, 0xffeef205, 0xffdbe40d, 0xffd5dc14, 0xffc0c722, 0xffa7ab32, 0xff989d3f, 0xff8d8e4a, 0xff87884c, 0xff78795a, 0xff74745a, 0xff9a9a40, 0xffecf504, 0xfff8ee01, 0xffffc700, 0xffffc502, 0xfff4bd08, 0xff91804c, 0xff6f6b62, 0xff8e8e48, 0xffc3c420, 0xffeff201, 0xfff2fd00, 0xfff0fb01, 0xffeff905, 0xffe9f307, 0xffe6ef08, 0xffd9e014, 0xffced718, 0xffc3ca22, 0xff9fa53b, 0xff898b4a, 0xff75755b, 0xff6b6d60, 0xfff9eb02, 0xffecbb09, 0xff8a7c4d, 0xff6d6a61, 0xff7e7a4d, 0xffa4962b, 0xffd2ba02, 0xffd7c000, 0xffddcc02, 0xffe0d200, 0xffe7df02, 0xffeae503, 0xffeded01, 0xffeef100, 0xfff3f901, 0xffdfe90e, 0xffced817, 0xffc8cf1d, 0xffaeb430, 0xffb1b42f, 0xffd3db16, 0xfffbdf00, 0xfffece00, 0xffffc600, 0xfff7c107, 0xffd9ad18, 0xff78705b, 0xff686765, 0xff746f5b, 0xff8f803f, 0xffc6a80a, 0xffccae02, 0xffd1b303, 0xffd1b700, 0xffd6bf00, 0xffd8c401, 0xffddce01, 0xffe1d602, 0xffe9e200, 0xffeae600, 0xffeeee00, 0xffeff300, 0xfff3fa00, 0xfff1fa00, 0xffedf703, 0xffebf407, 0xffe3ec07, 0xffdce510, 0xffdae115, 0xffe8f10a, 0xfffcd901, 0xfff5be09, 0xffd0a61e, 0xff726c5e, 0xff706d5c, 0xffa99323, 0xffbfa40b, 0xffcba901, 0xffccaa00, 0xffcbab00, 0xffcdab03, 0xffcdac00, 0xffcdad00, 0xffceae01, 0xffcfb000, 0xffd3b902, 0xffd4bc02, 0xffd9c600, 0xffdbca00, 0xffe3d800, 0xffe7df00, 0xffeae800, 0xffe4b511, 0xffb19531, 0xff6a6a62, 0xff9a8532, 0xffb89c15, 0xffcaaa01, 0xffccaa02, 0xffcdae00, 0xffcfb200, 0xffd1b401, 0xffd4ba01, 0xffd7be00, 0xffdbc800, 0xffdfce02, 0xffe6dc01, 0xffe7e300, 0xffedec00, 0xfff2f601, 0xfff2f900, 0xfff8ef00, 0xffdaae17, 0xffa28b3f, 0xff787252, 0xff978634, 0xffc7a707, 0xffcaa902, 0xffcdab01, 0xffd2b500, 0xffd5b900, 0xffd5c100, 0xffd7c500, 0xffdfd100, 0xffe4d601, 0xffe8e303, 0xffebe803, 0xffefef01, 0xfff0f400, 0xfff6f800, 0xfff8e701, 0xffc39f24, 0xff8c7c49, 0xff6e6c5d, 0xff847a45, 0xffc0a20c, 0xffc9a803, 0xffcbab02, 0xffceac02, 0xffceb000, 0xffd3b602, 0xffd6ba01, 0xffd9c200, 0xffd9c800, 0xffe3d502, 0xffecea00, 0xfff0f401, 0xfff1f701, 0xfffac306, 0xffb29531, 0xff807652, 0xff6d6b5f, 0xffa38c2c, 0xffbfa10f, 0xffcba900, 0xffccac03, 0xffcdad02, 0xffceae03, 0xffcfb101, 0xffd1b400, 0xffd5bc00, 0xffd7c002, 0xffdccb01, 0xffe0d102, 0xffe6de01, 0xffeae301, 0xffedeb00, 0xffeff000, 0xfffaea01, 0xfffdd501, 0xfff2be06, 0xff968245, 0xff6f6d5e, 0xff686963, 0xff8f803b, 0xffb1971c, 0xffcda802, 0xffcfae01, 0xffd1b702, 0xffd6c200, 0xffddcc00, 0xffe2d401, 0xffe7e200, 0xffe9e700, 0xfff1f201, 0xfff9e401, 0xfffdd100, 0xffedba09, 0xff8d7d4a, 0xff726d5a, 0xff8c7e3f, 0xffc5a40b, 0xffc9aa02, 0xffcfaf04, 0xffd0b003, 0xffd6bd00, 0xfff0cd01, 0xfffacb01, 0xffffc401, 0xfff6c004, 0xff76705a, 0xff686762, 0xff6c6962, 0xff7c7352, 0xffb89f0f, 0xffc8a606, 0xffe8cb01, 0xfff6cc00, 0xffcea71c, 0xff706d5e, 0xff6b6863, 0xff968736, 0xffb89c14, 0xffcca903, 0xffcda800, 0xffccac01, 0xffdfc003, 0xfff1c701, 0xffe4b50f, 0xffb19532, 0xff6c6964, 0xff857b48, 0xffa79124, 0xffdcba01, 0xffefc501, 0xffdaaf15, 0xffa08a3f, 0xff6d6b5e, 0xff817948, 0xffbea30c, 0xffcaaa00, 0xffd7b901, 0xffe9c801, 0xfffdc800, 0xffc7a124, 0xff8e7e4a, 0xff696961, 0xff737254, 0xffb19a1a, 0xffc6a606, 0xffd5b802, 0xffe5c802, 0xfffcc802, 0xfffcc304, 0xffb6962f, 0xff847850, 0xff8d7f3e, 0xffaf961f, 0xffccab00, 0xffd1b104, 0xffe0b902, 0xfffac600, 0xfff3bf07, 0xff978442, 0xff716e5f, 0xff7d754e, 0xff9d8a2e, 0xffc7a704, 0xffceaa00, 0xffcbaa00, 0xffdab800, 0xfff8c901, 0xfffcc300, 0xffefbc09, 0xff6e6a5f, 0xff787355, 0xffa69128, 0xffaf971d, 0xffc0a20e, 0xffc2a408, 0xffc8a704, 0xffcba802, 0xffcbaa03, 0xffcea902, 0xffd2b800, 0xfff4ca02, 0xffddb015, 0xff787258, 0xff81784d, 0xff8a7e44, 0xffa18d2a, 0xffaa9323, 0xffb2991a, 0xffb89d12, 0xffc3a509, 0xffc7a609, 0xffcaa904, 0xfff3c800, 0xfff5bf07, 0xffd2a81e, 0xff646665, 0xff6a6a60, 0xff777157, 0xff847a49, 0xff897f44, 0xff9e8b2c, 0xffa69126, 0xffb1981a, 0xffb79d14, 0xffc2a30a, 0xffc8a903, 0xffc9a900, 0xffd0af02, 0xffecc400, 0xfff9c801, 0xffe6b70f, 0xff6f6c5d, 0xff797353, 0xff80774c, 0xff8b7c41, 0xff958537, 0xffb99e13, 0xffc7a706, 0xffcfad03, 0xfff6cb02, 0xffdbb016, 0xffa78b37, 0xff6e6a5e, 0xff777254, 0xff7e764f, 0xff897d43, 0xff93823a, 0xffa79225, 0xffac9521, 0xffc8a901, 0xffcaab02, 0xffccac00, 0xffdfc300, 0xfff0c602, 0xffc6a021, 0xff8e7d49, 0xff6e6c5f, 0xff746f59, 0xff847a47, 0xff978636, 0xffa48d2d, 0xffb49916, 0xffc0a30a, 0xffc4a60a, 0xffdebc02, 0xffedc202, 0xffb7982e, 0xff857752, 0xff696863, 0xff716f5a, 0xff84794b, 0xff938338, 0xff9e8b2d, 0xffac961e, 0xffb0981a, 0xffc5a407, 0xffddc106, 0xff968442, 0xff736d5d, 0xff6c6a5e, 0xff746d5a, 0xff7b7251, 0xff867a48, 0xff897c45, 0xffa08e2c, 0xffaa9522, 0xffb59a19, 0xffbb9f10, 0xffc4a608, 0xffd0b800, 0xffd4be08, 0xff8b7f4b, 0xff6e6c60, 0xff6c6960, 0xff716e5b, 0xff777350, 0xff8d7f40, 0xffb49918, 0xffc4a308, 0xffcab003, 0xffbfac12, 0xff7c7354]
				); 
        }
		public function box5():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,3,3,4,5,6,7,8,9,10,11,10,0,12,1,13,3,14,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,15,15,16,17,18,19,20,21,22,23,24,25,26,0,0,0,27,3,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,26,28,29,30,31,32,33,34,19,35,36,37,38,39,27,40,10,3,41,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,1,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,0,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,59,3,42,60,61,33,33,33,62,63,50,50,64,65,66,67,68,69,70,71,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,3,27,3,3,0,0,42,72,73,74,49,50,75,76,47,76,77,78,49,47,79,51,80,81,82,83,84,85,0,0,3,0,86,10,3,26,15,0,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,3,0,3,0,0,13,87,88,89,90,33,33,47,91,33,77,33,62,48,47,50,92,93,94,95,96,97,98,99,100,0,15,101,0,3,0,12,10,10,10,10,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,3,0,102,103,104,48,33,49,105,106,107,108,109,110,48,49,48,49,49,50,33,111,112,113,114,115,116,117,26,27,0,0,15,0,0,27,3,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,118,119,31,47,50,47,50,120,121,122,123,124,125,126,104,47,62,127,127,50,47,33,93,128,129,130,131,70,87,1,9,132,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,13,10,3,133,134,135,45,49,49,136,137,138,139,140,141,142,143,144,145,146,147,111,50,48,47,47,50,50,47,148,149,150,151,152,30,153,154,3,3,10,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,3,10,155,156,157,158,137,76,50,48,159,160,161,162,163,164,165,166,167,168,169,170,171,48,33,48,47,49,48,50,76,172,128,173,174,175,176,177,27,10,27,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,10,0,71,178,179,180,48,49,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,62,47,199,47,33,50,47,46,200,201,202,203,204,205,118,3,0,0,0,27,0,0,10,10,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,16,206,207,208,33,48,50,209,210,211,212,213,214,215,216,216,217,218,219,220,221,222,223,224,225,226,136,47,47,48,199,48,48,48,79,65,227,228,229,230,206,154,0,0,10,1,0,0,3,0,10], 
    [0,0,0,0,0,0,0,0,0,0,0,26,3,231,232,233,104,48,47,63,234,235,236,237,238,239,187,191,217,189,191,216,216,240,217,241,242,243,244,245,246,247,248,47,199,48,49,50,50,49,76,249,66,250,251,252,205,71,27,3,3,3,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,27,253,254,255,256,62,47,180,257,258,259,260,238,239,261,191,262,164,188,218,191,190,216,216,263,264,265,266,267,268,269,234,76,48,48,47,48,49,50,48,104,270,271,272,273,274,275,0,0,12,3,0], 
    [0,0,0,0,0,0,0,0,0,0,0,10,85,276,277,33,49,47,92,278,279,280,281,282,238,283,261,188,217,217,217,188,188,216,284,188,216,188,217,285,286,287,288,289,290,291,292,46,33,199,48,47,48,77,47,293,249,294,295,296,297,0,0,132], 
    [0,0,0,0,0,0,3,10,0,3,0,9,205,298,112,48,48,47,136,299,300,301,302,303,304,305,187,188,188,188,188,188,188,188,188,188,188,306,188,188,188,307,308,309,310,311,312,313,314,50,127,76,48,47,62,47,33,315,316,317,318,26,10,0], 
    [0,0,0,0,0,10,3,0,0,27,3,319,178,320,46,62,50,33,321,322,323,324,325,303,326,327,187,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,217,217,220,328,329,330,331,196,332,333,136,47,47,47,48,50,49,334,335,0,3,155], 
    [0,0,0,0,0,3,0,0,3,0,3,336,337,200,47,48,48,338,339,340,341,325,325,303,326,327,342,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,306,164,164,218,343,344,309,345,346,347,348,49,48,33,47,47,104,349,350,10,15,0], 
    [0,0,0,0,0,1,0,3,10,132,351,352,353,48,49,50,199,354,355,212,325,325,325,260,356,327,342,188,188,188,188,188,188,188,188,188,188,216,216,188,188,188,188,190,216,240,164,190,216,357,358,359,360,76,47,47,49,361,362,363,364,0,10,10], 
    [0,0,0,0,0,0,3,3,41,365,366,129,32,49,49,49,33,367,368,301,369,325,325,260,356,327,187,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,216,216,217,188,306,370,188,371,372,373,49,47,47,49,314,374,375,376,12,0,10], 
    [0,0,0,0,0,0,377,378,0,30,379,380,136,49,181,381,382,383,384,324,369,325,325,324,385,386,187,218,188,216,306,190,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,217,216,387,388,389,390,48,49,77,62,391,392,393,0,10,1,155], 
    [0,0,0,0,0,28,10,0,26,394,395,33,77,50,48,396,397,398,399,324,325,325,325,325,304,400,342,188,217,217,401,306,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,188,306,402,403,404,111,47,48,47,199,405,406,407,0,10,3,0], 
    [0,0,0,0,0,0,3,408,319,409,410,47,50,127,33,411,412,413,369,414,415,324,369,325,416,417,418,217,190,217,188,401,188,188,188,188,188,188,188,188,188,188,188,188,188,188,306,419,401,420,421,422,47,47,48,33,423,424,425,27,41,0,3,0], 
    [0,0,0,0,0,155,3,426,427,428,293,62,48,48,93,429,430,431,369,431,415,303,325,325,432,433,434,435,164,436,188,190,188,188,188,188,188,188,188,188,188,188,188,188,188,188,306,188,220,437,438,199,33,47,49,256,439,440,441,1,1,0,0,0], 
    [0,0,0,0,0,0,3,442,443,104,50,50,47,444,445,446,341,324,302,447,448,324,303,449,450,451,452,453,454,455,456,218,164,188,188,188,188,188,188,188,188,188,188,188,188,188,188,343,457,458,313,48,47,47,76,459,460,461,393,0,0,0,10,0], 
    [0,0,0,0,0,462,71,463,464,33,50,465,63,466,467,468,469,470,471,472,324,302,302,473,474,0,2,475,476,477,478,479,480,188,188,188,188,188,188,188,188,188,188,188,188,188,188,343,481,482,483,136,50,48,33,484,485,441,407,132,0,0,10,27], 
    [132,1,3,0,11,376,486,227,45,48,48,47,33,487,488,469,325,325,325,303,325,302,489,490,491,0,40,1,1,492,493,494,495,434,496,497,217,498,190,217,188,216,188,216,188,217,218,499,500,501,47,77,50,199,502,503,504,505,3,0,0,0,0,0], 
    [506,0,3,10,1,507,508,509,46,48,47,510,511,512,513,514,325,369,325,472,325,515,516,517,518,10,15,132,132,41,1,519,520,521,522,523,524,240,217,190,216,218,525,263,526,188,527,528,529,46,33,77,50,180,530,531,532,533,0,0,0,0,0,0], 
    [10,0,0,10,42,273,61,46,50,47,49,534,535,536,537,538,415,369,325,325,325,449,539,540,132,0,541,132,0,3,3,0,0,542,543,544,545,546,547,548,218,306,217,261,285,401,549,550,120,47,75,47,33,551,552,553,554,132,3,0,0,0,0,0], 
    [10,0,10,10,555,556,557,62,50,48,48,558,559,560,414,303,369,369,325,325,260,561,562,132,2,0,0,3,3,132,132,10,1,28,12,563,564,494,565,566,496,241,218,188,567,568,569,570,571,47,48,47,33,572,573,574,575,132,0,0,0,0,0,0], 
    [3,3,10,206,576,577,79,50,50,47,33,578,579,580,324,472,325,369,325,369,581,582,583,1,1,584,0,0,1,0,0,0,0,0,1,15,0,28,492,585,586,587,588,524,589,569,590,591,48,49,76,33,592,593,594,595,596,0,0,0,0,0,0,0], 
    [12,0,0,597,115,94,598,50,47,47,338,599,600,601,602,282,472,369,603,604,605,606,607,378,1,132,41,0,0,0,0,0,0,0,0,0,0,132,1,608,609,610,611,612,613,614,615,137,33,33,33,33,616,617,618,619,620,101,0,0,0,0,0,0], 
    [132,13,376,621,622,47,48,50,50,49,49,623,624,625,626,627,628,472,324,629,630,608,10,0,10,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,631,632,633,634,48,47,33,50,635,636,637,638,639,10,0,10,0,0,0,0,0], 
    [13,3,640,641,642,47,47,50,76,47,47,48,93,643,644,645,646,560,647,648,649,59,0,3,27,10,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,132,132,376,650,651,652,48,47,33,136,653,654,655,574,376,10,41,1,0,0,0,0,0], 
    [41,656,639,657,658,659,660,180,33,47,48,47,47,77,209,661,662,663,664,665,666,667,0,41,10,0,0,0,0,0,0,0,0,0,0,0,0,1,132,0,3,132,132,43,668,669,48,33,33,199,338,670,671,672,673,26,0,59,0,0,0,0,0,0], 
    [16,132,85,674,675,676,677,623,678,33,62,48,48,47,49,77,256,679,680,681,682,683,684,26,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,656,229,685,46,127,50,48,33,686,687,688,689,690,0,0,0,0,0,0,0,0,0], 
    [10,1,154,691,692,693,694,695,696,697,660,33,33,47,47,49,49,49,48,104,32,698,699,700,701,640,42,0,59,0,0,10,0,0,3,0,0,541,10,10,1,656,702,703,704,48,75,49,199,110,705,706,707,708,620,0,28,41,0,0,0,0,0,0], 
    [0,1,42,709,710,711,712,694,713,714,715,716,717,48,48,48,77,47,50,47,48,718,719,720,721,722,274,153,26,59,28,0,0,0,10,132,132,3,10,0,0,723,7,724,718,47,47,47,199,725,726,727,728,729,656,0,28,0,0,0,0,0,0,0], 
    [10,0,0,730,731,732,733,711,711,712,734,735,736,737,738,361,199,50,49,47,48,47,739,33,90,740,741,742,743,702,133,1,0,3,0,0,41,3,0,744,0,745,272,93,48,48,48,47,746,747,748,749,750,26,0,0,0,3,15,0,0,0,0,0], 
    [0,0,3,751,752,753,733,754,754,712,755,756,757,758,759,760,717,33,33,77,47,62,50,50,49,104,45,761,762,763,764,765,154,10,10,28,0,0,12,744,26,766,767,47,75,47,49,48,483,768,769,770,771,0,0,28,0,1,10,0,0,0,0,0], 
    [0,0,0,772,773,774,733,711,733,733,775,712,711,693,756,776,777,778,779,180,33,47,47,33,47,47,50,49,64,149,780,781,782,783,784,656,0,3,0,42,785,786,704,48,62,48,49,787,788,789,790,791,792,27,0,0,0,0,1,0,0,0,0,0], 
    [15,3,10,793,794,795,796,712,797,797,775,712,798,797,712,755,799,800,801,779,802,803,50,50,47,47,127,47,47,199,90,66,741,804,805,684,85,27,0,806,807,808,148,48,48,50,49,809,810,811,812,813,814,0,3,462,0,2,10,0,0,0,0,0], 
    [0,0,0,154,815,816,817,818,711,818,711,711,711,711,711,711,712,818,819,820,821,822,823,104,49,47,47,48,49,48,47,47,47,824,825,826,827,828,829,764,827,293,47,47,50,47,180,830,831,832,833,154,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,3,0,834,835,836,733,837,818,818,711,711,711,711,711,712,712,712,712,838,839,840,841,511,33,47,50,49,47,47,75,47,48,842,843,724,844,782,82,845,33,76,47,50,47,333,846,847,848,849,0,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,132,10,3,850,851,852,818,853,711,854,711,711,711,711,711,711,797,797,853,853,712,798,855,856,857,858,422,33,199,199,50,47,48,47,62,47,180,859,860,93,33,47,75,48,333,861,671,862,863,864,10,0,0,0,0,0,0,0,0,0,0,0,0], 
    [3,28,10,28,177,865,866,818,732,711,854,711,711,711,711,711,712,818,733,712,712,712,775,867,838,868,696,869,870,871,76,50,49,47,47,47,47,49,62,33,46,33,77,47,49,635,830,872,873,874,154,10,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,132,1,10,0,875,876,818,711,711,818,711,711,711,711,711,733,818,754,712,867,711,712,711,877,712,878,713,695,715,879,880,256,48,49,47,47,48,47,47,181,33,50,50,361,881,882,883,884,408,0,744,132,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,59,26,885,886,887,818,888,712,711,733,818,712,712,712,889,711,711,711,711,711,711,711,711,711,878,890,891,758,892,760,256,33,47,47,48,47,50,50,47,510,136,90,893,894,895,896,0,132,0,132,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,897,898,899,876,900,753,818,711,711,712,901,818,733,711,712,711,711,711,711,711,711,711,711,711,711,712,902,903,904,905,717,361,47,47,47,47,50,49,338,906,894,907,908,909,1,0,10,132,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,42,177,910,911,912,913,914,754,712,712,733,711,877,711,711,711,711,711,711,711,711,711,818,733,712,712,711,819,915,916,917,779,918,33,48,47,47,47,919,920,921,922,923,365,10,0,0,28,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,155,0,0,27,924,925,926,927,866,928,711,877,711,712,711,711,711,711,711,711,711,711,711,797,733,775,877,775,711,711,757,929,930,931,932,180,47,33,933,934,935,936,376,0,28,0,0,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,3,0,27,132,937,938,939,940,941,942,943,733,889,711,711,711,711,711,711,711,711,712,775,712,775,711,711,818,712,711,756,776,800,944,945,248,333,726,831,946,947,58,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,3,0,376,505,948,949,950,951,753,775,711,754,837,877,733,889,711,818,733,712,711,711,711,711,711,711,818,853,952,953,954,955,956,957,958,959,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,28,132,26,27,960,961,962,963,964,836,732,733,712,712,732,712,712,889,733,712,754,711,711,711,711,711,877,712,818,878,965,966,967,968,969,793,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,10,132,0,0,0,132,154,407,970,971,972,973,943,753,712,733,711,711,818,711,711,711,711,711,711,711,711,818,818,711,974,975,976,977,792,978,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,3,0,3,979,980,981,982,983,942,984,732,712,712,796,797,712,711,711,711,711,711,775,818,732,818,985,986,987,988,989,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,3,132,3,3,3,27,10,177,990,991,992,993,994,995,712,712,712,711,711,711,711,711,712,733,711,996,997,998,999,1000,0,3,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,15,15,3,1001,28,3,3,0,10,13,989,793,1002,911,1003,1004,1005,818,878,711,711,711,711,711,712,733,711,1006,1007,1008,1009,393,0,10,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,0,3,15,154,960,1010,1011,1012,1013,1014,877,711,712,853,753,732,712,1015,1016,1017,980,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,10,0,3,132,41,1018,1019,1020,1021,1022,1023,1024,754,733,712,732,712,1025,1026,1027,365,1,10,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,0,0,0,0,0,11,27,0,979,1028,1029,1030,983,1031,753,853,878,1032,1033,1034,0,0,1,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,40,10,3,3,0,0,10,10,0,0,15,26,924,1035,1036,1037,1038,1039,798,1040,1041,1042,0,0,41,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,12,15,0,15,1043,10,132,154,407,885,1044,1045,1046,1047,132,1,1,132,13,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff656766, 0xff666465, 0xff666668, 0xff86874d, 0xffa7ac34, 0xff909543, 0xff7e8152, 0xff6a6a5e, 0xff666865, 0xff666664, 0xff66656a, 0xff656668, 0xff676769, 0xff646661, 0xff676664, 0xff666867, 0xff71705c, 0xffbec422, 0xffe4ec0b, 0xffe9f205, 0xffdee410, 0xffb7bd29, 0xff9fa237, 0xff7b7c54, 0xff6f705e, 0xff676765, 0xff676767, 0xff676568, 0xff686b64, 0xff7c7d55, 0xffd8e011, 0xffeff905, 0xfff4fe00, 0xfff0fa03, 0xffd5db15, 0xffa8ac34, 0xff909247, 0xff71735e, 0xff6b6b5f, 0xff656563, 0xff656764, 0xff676863, 0xff7f8054, 0xffafb52f, 0xfff0f902, 0xfff4fd02, 0xfff5ff00, 0xfff5ff01, 0xfff4ff01, 0xfff4ff00, 0xffeffb05, 0xffe9f306, 0xffcdd319, 0xffb9be26, 0xff8b8c48, 0xff787d55, 0xff696967, 0xff686866, 0xff656565, 0xff969942, 0xffc9d11c, 0xfff5fe03, 0xfff4ff03, 0xfff3fe02, 0xffedf605, 0xffe3ec09, 0xffc1c621, 0xffa5ad36, 0xff7e7f53, 0xff74745c, 0xff686964, 0xff757559, 0xffced41a, 0xffecf506, 0xfff6ff01, 0xfff3ff00, 0xfff7fe00, 0xfff7fe03, 0xfff2fd03, 0xffe0e70d, 0xffced718, 0xffa1a537, 0xff8c8d49, 0xff6f7060, 0xff6a6a62, 0xff656469, 0xff6c6c62, 0xff888a4b, 0xffe0eb0b, 0xfff1fc00, 0xfff6fe00, 0xfff5ff02, 0xfff2fb02, 0xffedf703, 0xffd6dd15, 0xffc1c624, 0xff919443, 0xff828250, 0xff6b6d62, 0xff686963, 0xff67666b, 0xff8d8e48, 0xffbec424, 0xfff3fc01, 0xfff6f800, 0xffefdf06, 0xfff1b51f, 0xffeec920, 0xfff6ef09, 0xfff6f703, 0xfff3fc03, 0xffe9f309, 0xffdee80e, 0xffbac126, 0xffa1a439, 0xff7c7e56, 0xff6f715c, 0xff696a62, 0xffa7ad33, 0xfff2e608, 0xffe4ab14, 0xffe15149, 0xffe5694f, 0xfff1b320, 0xffefce11, 0xfff5f605, 0xfff7fe01, 0xffe5ee0b, 0xffd4dd14, 0xffa9af33, 0xff929544, 0xff676566, 0xff6a6c61, 0xff7e7f55, 0xffdce210, 0xfff6fd00, 0xfff5fb03, 0xffd69d1c, 0xffc03f39, 0xffe00362, 0xffed0269, 0xffed0f66, 0xffe92057, 0xffe66c3d, 0xffea9f28, 0xffefe311, 0xfff6f004, 0xfff1fa03, 0xffebf407, 0xffd0d717, 0xffbcc127, 0xff8d8e4a, 0xff696a64, 0xff686763, 0xff656567, 0xff6f725f, 0xff929743, 0xffebf206, 0xfff0f503, 0xffbb692f, 0xffad1e49, 0xffe10161, 0xfff0006a, 0xffee016d, 0xffee0368, 0xffe71f5d, 0xffe64056, 0xffec9836, 0xffeebb22, 0xfff3ea05, 0xfff4f503, 0xffeef706, 0xffc2c921, 0xffa9b02f, 0xff818352, 0xff73755f, 0xff696863, 0xff999d3f, 0xffccd518, 0xfff3fd00, 0xfff6ff02, 0xffeff205, 0xffdcc017, 0xffa01e4c, 0xffa5054d, 0xffe40062, 0xffed006a, 0xfff0006d, 0xfff10170, 0xfff1006b, 0xfff0006f, 0xffee0a69, 0xffee1365, 0xffe8454a, 0xffe86c39, 0xffeac91a, 0xfff1e310, 0xfff8fa01, 0xfff3fe00, 0xfff1fa01, 0xffe1e80e, 0xffcfd819, 0xffa4a839, 0xff8f9146, 0xff70725c, 0xff6d6d61, 0xffb8be28, 0xffe2ea0b, 0xfff5fe05, 0xffe9dd0f, 0xffcd9327, 0xff9c0c4a, 0xffa60249, 0xffe20064, 0xffef0068, 0xfff1006d, 0xfff0006b, 0xfff1016c, 0xfff00070, 0xffef026c, 0xffec0d66, 0xffe91e5e, 0xffe06a44, 0xffe79a32, 0xfff1da10, 0xfff4ed07, 0xffd7de12, 0xffc4ca1e, 0xff949843, 0xff828550, 0xff6d6e5e, 0xff8c8d4b, 0xffe5ed0c, 0xfff3f702, 0xffc98425, 0xffa73044, 0xff9b004c, 0xffa5004c, 0xffe10164, 0xffee016b, 0xffee036c, 0xffed0c6a, 0xffec2f55, 0xffea4843, 0xffeca21f, 0xffebc717, 0xfff4f207, 0xfff5f902, 0xffecf504, 0xffbdc323, 0xffa5a837, 0xff7d8053, 0xff797957, 0xffa6a83a, 0xffeff904, 0xfff5fc00, 0xfff0e905, 0xffb74c3a, 0xff9e134a, 0xff9b014a, 0xffef006a, 0xffee006f, 0xfff2006e, 0xffef076a, 0xffee0f62, 0xffe54051, 0xffe06949, 0xfff0c020, 0xfff2db0f, 0xffe7f00b, 0xffd6df14, 0xffaeb42e, 0xff969940, 0xff777859, 0xff6c6f5e, 0xffa8ad35, 0xffd8e212, 0xffece705, 0xffd3a217, 0xff9f0e47, 0xff97004d, 0xff99014c, 0xffe00061, 0xfff3006c, 0xffee0169, 0xffed046d, 0xffec196a, 0xffec2e5a, 0xffe86e2f, 0xffe9a321, 0xfff2e411, 0xfff4f406, 0xfff1fc02, 0xffd3db14, 0xffc0c722, 0xff8e9045, 0xff797859, 0xffc8cc1f, 0xffe4c70b, 0xffc56b1d, 0xff99034a, 0xff970149, 0xff9a0049, 0xffa1004c, 0xffde0063, 0xfff1016e, 0xfff0036d, 0xfff0056c, 0xffea2158, 0xffe6414f, 0xffe79d30, 0xffedc321, 0xfff4ee04, 0xfff4f803, 0xffeef803, 0xffe8f007, 0xffbbc226, 0xff919445, 0xff75755b, 0xffecf508, 0xffeff306, 0xffbb672b, 0xffa01e44, 0xff980049, 0xff98004b, 0xffa0004b, 0xffdc0062, 0xffec0d6a, 0xffe91a68, 0xffeb4947, 0xffe96f30, 0xffefe60b, 0xfff5fa00, 0xffc8cc1d, 0xff909145, 0xff868650, 0xffb6bc28, 0xfff4fb00, 0xffe9e309, 0xffaa3e3c, 0xff9b0d49, 0xffed006c, 0xfff0036b, 0xffee0e64, 0xffe36d47, 0xffe8a12d, 0xfff3e40f, 0xfff5f507, 0xffb9b627, 0xff84814e, 0xff6f6c63, 0xffbbc224, 0xffe2ed0b, 0xffe9dd0b, 0xffcb9227, 0xff9e004b, 0xffee066a, 0xffeb0e6e, 0xffe96d47, 0xfff1c818, 0xfff5fc01, 0xffebed06, 0xff928946, 0xff6f6c5d, 0xff696864, 0xff797a58, 0xffdab61a, 0xffb85e3b, 0xff97014b, 0xfff10268, 0xffee056e, 0xffe5704d, 0xffefc91c, 0xffe4de0c, 0xff847d51, 0xff6a6964, 0xff646567, 0xff686667, 0xffa9ad34, 0xffeffa00, 0xfff6fc00, 0xffeee703, 0xffb64d37, 0xff9f1549, 0xffa1014b, 0xffdb0160, 0xffef046d, 0xffe91f68, 0xffecc623, 0xfff3f307, 0xfff0e404, 0xffcbb81c, 0xff6f6b60, 0xff929546, 0xffc4cc1f, 0xfff1f403, 0xffe5c80c, 0xffa6243e, 0xff9b054c, 0xffdb0162, 0xffef026e, 0xffed0c6c, 0xffe93b60, 0xfff2e213, 0xffe5d609, 0xffbaa528, 0xff6c6962, 0xff676964, 0xffccd21a, 0xffebf405, 0xffe2c60d, 0xffbd6825, 0xff9a0549, 0xff98024c, 0xff97004a, 0xff9e024c, 0xffd70461, 0xffe7056b, 0xffef006c, 0xffee305e, 0xffee8c35, 0xfff3f901, 0xfff5f602, 0xffcdb21d, 0xff958345, 0xff6b6d60, 0xff85864d, 0xffe1e90a, 0xffd19c1c, 0xffae3d39, 0xff98024a, 0xff9a074d, 0xffbf1963, 0xffd01468, 0xffea056c, 0xffee0270, 0xffed564d, 0xfff0b720, 0xfff4ed00, 0xffbda02a, 0xff85794f, 0xff8a8a4a, 0xffbbc123, 0xfff5fb05, 0xffeadf0b, 0xffac3b3d, 0xff95014d, 0xff95014b, 0xff940d4f, 0xff892957, 0xff705c67, 0xff785867, 0xff993e67, 0xffb22b66, 0xffda0f69, 0xffe7076a, 0xffed1168, 0xfff0b21f, 0xfff8ee01, 0xfff2d307, 0xff928247, 0xff666762, 0xffa1a43b, 0xffd4dc15, 0xfff4ff02, 0xfff1f105, 0xffdbbf16, 0xffa01b46, 0xff99034b, 0xff9a004f, 0xff98004d, 0xff9a004b, 0xff8c1952, 0xff7d3e5d, 0xff735c66, 0xff805066, 0xffad3068, 0xffc41e6a, 0xffe4086c, 0xffed016d, 0xffed2855, 0xfff3d30e, 0xfff4f801, 0xfff7e602, 0xffebc50a, 0xff7c7c56, 0xffdcb417, 0xffbb5a37, 0xff94074c, 0xff7c3f5e, 0xff6d5c64, 0xff6a6468, 0xff6f5e68, 0xff8d4867, 0xffa33768, 0xffe00a6a, 0xffeb026b, 0xfff2006b, 0xffeb2057, 0xffe96f2c, 0xfff5f604, 0xfff7f900, 0xfff3ce04, 0xffd0a91d, 0xff6f6b5f, 0xff666467, 0xff72715c, 0xff939444, 0xffe7f105, 0xfff7ff00, 0xfff2f603, 0xffcb8122, 0xffab2d42, 0xff990249, 0xff97044b, 0xff940f50, 0xff725261, 0xff686465, 0xff6f5e66, 0xff7c5567, 0xff9c3b68, 0xffb82768, 0xffda0d68, 0xffe7066c, 0xfff2016c, 0xffee026e, 0xfff00169, 0xffeb4245, 0xffeaa218, 0xfff7f200, 0xffedc00b, 0xffbd9c2b, 0xff696a65, 0xfff0f602, 0xffe4c80c, 0xffa82340, 0xff9a074b, 0xff9a004d, 0xff842f59, 0xff696365, 0xff646665, 0xff6a6466, 0xff6c6167, 0xff7f5267, 0xff91436a, 0xffc51f6b, 0xffd41268, 0xffec036c, 0xffe90f66, 0xffeca121, 0xfff8f102, 0xfffbdd01, 0xffcfa81d, 0xff948146, 0xff6e6c60, 0xffb5ba28, 0xffe0ea0d, 0xffe9e508, 0xffd29f20, 0xffa00c46, 0xff8e1d53, 0xff79425f, 0xff6c6368, 0xff715d68, 0xffa53766, 0xffd1156a, 0xfff10069, 0xffed056b, 0xffe52161, 0xffebcb16, 0xfff3f605, 0xfff7e900, 0xfffbd302, 0xffbd9c28, 0xff857a4d, 0xff87884e, 0xffe3eb0c, 0xffd7a319, 0xffb14634, 0xff99034d, 0xff97074c, 0xff76465e, 0xff6b5e65, 0xff646965, 0xff765a68, 0xff884c66, 0xffb4296a, 0xffca1b6a, 0xffee036a, 0xffe36c44, 0xfff2f508, 0xfff8fa00, 0xfffcd403, 0xfff4c305, 0xff948149, 0xff706c61, 0xff787959, 0xfff2fd01, 0xffd49a12, 0xffba4f2b, 0xff9d0d4b, 0xff98054b, 0xff970048, 0xff97034f, 0xff901251, 0xff6f5465, 0xff676364, 0xff696367, 0xff6d6067, 0xff854e65, 0xff944364, 0xffc51d68, 0xffd81068, 0xffe14552, 0xffe9a22e, 0xfff8f301, 0xfffacd00, 0xffedbb0c, 0xff86794f, 0xff6c6964, 0xffa6ab33, 0xffd6df12, 0xfff2f302, 0xffeadf09, 0xffd19b1f, 0xffbc672e, 0xffa5203f, 0xff9d0e46, 0xff921451, 0xff7f385a, 0xff716066, 0xff86605f, 0xffd1b627, 0xffedeb0a, 0xfff6f400, 0xfffae100, 0xfff6c006, 0xffd1a71d, 0xff6d6b5f, 0xff6c6c60, 0xffbec321, 0xffe6ed09, 0xffeae40a, 0xffe1c712, 0xffc26b24, 0xffb34335, 0xff9a0849, 0xff882456, 0xff76495e, 0xff807e55, 0xffdde110, 0xfff0f805, 0xfff7eb00, 0xfffbd800, 0xffecba0b, 0xff686765, 0xffb8ac1c, 0xffd8ca05, 0xffebeb01, 0xfff0f401, 0xfff3f400, 0xffefe603, 0xffd6ad15, 0xffc58724, 0xff92754d, 0xff7e7554, 0xff686b62, 0xffb1b230, 0xfff0fc04, 0xfffbd700, 0xfffdc800, 0xffcca420, 0xff927e49, 0xffae9a1f, 0xffccb207, 0xffddcc00, 0xffe4d903, 0xfff4fa02, 0xffeeee04, 0xffe4d90b, 0xffc0c024, 0xffa8a932, 0xff7d7e56, 0xff71705e, 0xffcacf1d, 0xfff5f500, 0xfffecf00, 0xfff9c402, 0xffb19333, 0xff7f7454, 0xff988830, 0xffbe9f11, 0xffcdab01, 0xffceae03, 0xffd5bc00, 0xffdcc900, 0xffeae704, 0xffdbe40f, 0xffc9ce1c, 0xff989c3e, 0xff83864f, 0xff70725d, 0xffc9d11b, 0xffebf308, 0xfffbe601, 0xfffac503, 0xffe2b60f, 0xff7e7556, 0xff8f803b, 0xffb69917, 0xffccaa00, 0xffccaa02, 0xffd0b300, 0xffdccb02, 0xffe3d800, 0xfff0f002, 0xfff2f800, 0xfff1fb04, 0xffe9f307, 0xffcdd619, 0xffb7bc2c, 0xff868b4b, 0xff6b6b63, 0xffdbe610, 0xfff6ef00, 0xfffcda00, 0xfff3c005, 0xffcfa81c, 0xff746d5a, 0xff81784d, 0xffaa9522, 0xffcbaa03, 0xffcbab00, 0xffcead00, 0xffd4ba01, 0xffd8c600, 0xffe9e500, 0xfff0f100, 0xfff6ff00, 0xffe6ef0c, 0xffd5dc14, 0xffabac34, 0xff929248, 0xff676662, 0xff808253, 0xfff7fc02, 0xfffbda03, 0xfffec900, 0xffd3aa1e, 0xff9c8841, 0xff7c7352, 0xffa18d2a, 0xffcaa902, 0xffcaaa01, 0xffcdac00, 0xffcdad02, 0xffceb000, 0xffdac701, 0xffe3d502, 0xffefef01, 0xffd9e112, 0xffc5cd1f, 0xff959743, 0xff818351, 0xff6a6b63, 0xff94993f, 0xffc7cf1a, 0xffffd300, 0xfffec601, 0xffba9a2d, 0xff867a52, 0xff6e6a5f, 0xff877c44, 0xffc8a704, 0xffcba901, 0xffd1b702, 0xffd7c300, 0xffe7e202, 0xffeeee00, 0xffdfe90e, 0xffbabf25, 0xff9da23b, 0xff797a5a, 0xff6e6f5f, 0xff72715d, 0xffc8cf1d, 0xfff8f800, 0xfffaea01, 0xfffbc501, 0xffebb90a, 0xff877a4d, 0xff6d6a61, 0xff6c6960, 0xff81794b, 0xffc5a504, 0xffc9aa01, 0xffcaaa00, 0xffccac03, 0xffd0af00, 0xffd9c202, 0xffe0d102, 0xfff1f700, 0xfff2fd00, 0xffa5a938, 0xff8d9147, 0xff6a6b65, 0xff7f8152, 0xffdce60c, 0xfff8f303, 0xfffddd00, 0xfff7c204, 0xffdbae13, 0xff766f5c, 0xff6b6764, 0xff767056, 0xffbaa00f, 0xffc9a803, 0xffcbab02, 0xffcdad00, 0xffd1b700, 0xffd6c200, 0xffe7df02, 0xffecea01, 0xfff0f804, 0xffe8f009, 0xffc7d01f, 0xffaeb430, 0xff838651, 0xff73765b, 0xfffbdf00, 0xfffecb02, 0xffdbae17, 0xffa68b3a, 0xff6f6c5b, 0xffb39b17, 0xffc8a606, 0xffcea900, 0xffceae01, 0xffd7c002, 0xffdecd01, 0xffedeb00, 0xfff4fd04, 0xffeaf505, 0xffb4bc2b, 0xffcbd31d, 0xfffcd402, 0xfffcc602, 0xffc29e26, 0xff8a7c4b, 0xff6b6861, 0xffab9420, 0xffc6a508, 0xffcca903, 0xffcea902, 0xffd3b402, 0xffd7be01, 0xffe4db00, 0xffebe803, 0xffeff703, 0xffecf602, 0xfffaea00, 0xffefbc09, 0xff8f7e4a, 0xff6e6a61, 0xffa18d2c, 0xffc1a20c, 0xffcdab03, 0xffd6bf01, 0xffebe702, 0xffeff300, 0xfff2fe00, 0xfffac304, 0xffe0b216, 0xff7c7354, 0xff867d46, 0xffb0981a, 0xffccab00, 0xffccac01, 0xffeae601, 0xfff0f900, 0xfff8e300, 0xfffdcf00, 0xffe2b212, 0xffac9136, 0xff80774c, 0xffa59323, 0xffcba804, 0xffceaa00, 0xffcba900, 0xffcdaf03, 0xffd5bb02, 0xffe8e301, 0xfffcd704, 0xfffdc903, 0xffcca621, 0xff918249, 0xff6c6a5e, 0xff797351, 0xffa08e2c, 0xffc6a606, 0xffcdaa06, 0xffd0b202, 0xffd3ba00, 0xffe1d602, 0xffe7e401, 0xfff8ec00, 0xfff2be06, 0xff968245, 0xff726c60, 0xff7d754e, 0xff8c7e3f, 0xffac961f, 0xffba9f10, 0xffc8a903, 0xffd2ba02, 0xffd9c502, 0xffe9e200, 0xfff2fc00, 0xfff6f600, 0xfff9e200, 0xfffbc405, 0xffe5b411, 0xff807555, 0xff6e6a5e, 0xff777255, 0xff948738, 0xffa79323, 0xffc7a706, 0xffd2b801, 0xffdfd301, 0xffe8e003, 0xfff1f800, 0xfffce503, 0xfffed102, 0xffe7b70f, 0xffb4982d, 0xff6a6665, 0xff747057, 0xff82774a, 0xffa28f29, 0xffb1991b, 0xffc3a507, 0xffc8a805, 0xffe8e100, 0xffeeed00, 0xffd1aa1e, 0xff9a8742, 0xff867c47, 0xff988833, 0xffbb9e12, 0xffc4a60a, 0xffcdaf01, 0xffd2b501, 0xffe1d102, 0xffedde00, 0xfffccb02, 0xfff6c103, 0xff9b8742, 0xff736e5b, 0xff6e6b5c, 0xff777254, 0xff978634, 0xffa99123, 0xffc1a10e, 0xffd4c001, 0xffe4d000, 0xfffac505, 0xffebb90c, 0xff86794d, 0xff7b7748, 0xff8d7f3e, 0xffb0961d, 0xffbca010, 0xffd6b800, 0xffeac900, 0xffedbc0a, 0xffc19e26, 0xff666563, 0xff696961, 0xff716b5d, 0xff887b44, 0xff9a8931, 0xffb99e13, 0xffcca905, 0xffdbb902, 0xffeec400, 0xffdbb016, 0xffa58c3a, 0xff686762, 0xff767058, 0xff827a4c, 0xffa58f29, 0xffb39a19, 0xffc4a608, 0xffc9a801, 0xffccac00, 0xffe3c701, 0xffecc504, 0xffa38d38, 0xff777157, 0xff636766, 0xff7f764b, 0xffae951f, 0xffbb9f10, 0xffc9aa04, 0xffceac02, 0xffe1ca02, 0xffe5c206, 0xff8d7d4c, 0xff787154, 0xff988735, 0xffa99324, 0xffc2a30b, 0xffc7a704, 0xffcfb000, 0xffe0bb08, 0xffc6a321, 0xff666962, 0xff767154, 0xff83784a, 0xffa49128, 0xffb59a17, 0xffc6a603, 0xffcaa904, 0xffcfb403, 0xffd4b411, 0xffaa9135, 0xff706d5c, 0xff897d43, 0xff9b8a32, 0xffc3a509, 0xffd1b603, 0xffa99a33, 0xff7d7757, 0xff787355, 0xff978636, 0xffaa9224, 0xffc2a30a, 0xffc9a707, 0xffcfb00a, 0xff918644, 0xff706e61, 0xff666769, 0xff978533, 0xffc3a90c, 0xffb6a615, 0xff716e5f]
				); 
        }
		public function box6():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,3,4,0,5,6,7,8,9,10,0,4,11,11,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,11,12,13,14,15,16,17,18,19,20,21,22,23,24,4,11,11,0,4,0,23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,25,0,26,0,27,28,29,30,31,32,33,34,35,36,25,37,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,38,39,40,41,42,43,44,42,45,46,47,48,49,50,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,51,52,53,54,41,42,55,42,44,56,29,57,58,59,11,4,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,60,4,0,0,0,0,61,62,63,64,43,65,66,67,43,42,41,41,68,69,70,71,0,0,23,4,4,12,72,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,4,11,11,24,75,76,77,42,43,31,78,42,65,42,79,43,43,80,81,82,83,84,11,85,11,4,4,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,87,0,88,89,90,78,42,43,42,43,91,92,93,94,42,66,43,44,30,95,96,97,59,0,0,50,0,23,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,3,98,99,100,101,44,42,79,55,102,103,104,105,106,55,107,44,79,44,32,108,109,110,98,0,11,111,25,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,112,113,114,115,54,31,42,42,116,117,118,119,120,121,122,123,41,124,42,43,125,126,127,128,129,49,0,11,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,131,132,102,31,54,41,44,42,133,134,135,136,137,138,139,140,78,64,31,141,80,43,142,143,144,145,0,0,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,0,11,98,146,147,148,149,150,42,124,18,151,152,153,154,155,155,156,157,158,159,160,78,44,44,31,65,161,162,163,164,165,166,0,11,0,0,167,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,23,0,0,23,1,168,169,170,78,42,80,44,171,172,173,174,175,176,177,178,179,180,181,182,183,184,45,185,79,42,44,186,187,188,70,98,11,25,50,60,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,11,111,0,60,10,112,189,190,42,141,191,31,66,192,193,194,195,196,197,176,180,155,198,198,156,199,200,201,93,66,44,55,31,80,102,202,203,204,85,1,111,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,111,111,11,1,205,206,207,208,43,42,41,41,209,210,211,212,213,214,155,180,176,176,215,216,217,218,219,220,221,222,54,67,80,79,42,30,223,224,225,14,11,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,73,11,0,49,226,227,78,43,44,80,44,186,228,229,230,231,232,197,233,178,234,235,180,215,197,236,237,238,239,240,241,242,41,41,43,55,66,243,244,245,36,246,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,11,0,0,0,0,0,0,14,247,248,249,125,141,42,79,65,250,251,252,253,254,255,198,217,176,176,176,176,176,176,176,218,256,257,258,259,260,41,78,31,44,43,124,261,262,263,165,4,3,0,25,4,11,0,0,0,0,0], 
    [0,0,0,0,0,0,0,73,4,0,0,0,85,264,265,30,171,31,266,43,55,267,268,269,270,271,272,176,198,198,176,176,176,176,176,176,176,156,273,176,180,274,275,276,277,278,43,42,31,41,78,279,280,281,282,0,4,0,50,0,0,0,0,0], 
    [0,0,0,0,0,11,0,0,0,0,0,10,283,284,285,43,55,80,44,43,32,286,287,288,289,290,291,176,215,176,176,198,176,176,176,176,176,155,198,215,156,155,292,293,139,294,186,42,42,31,44,30,261,295,131,296,0,72,4,0,0,0,0,0], 
    [0,0,0,0,0,4,4,11,0,4,0,48,297,298,299,42,64,42,80,300,173,301,302,303,304,305,155,198,198,198,176,176,176,176,176,176,176,180,198,197,155,155,155,306,307,308,159,116,41,43,43,31,43,309,310,311,312,60,313,0,0,0,0,0], 
    [0,0,0,0,0,0,4,11,0,23,314,315,316,186,42,54,44,41,43,317,318,319,320,321,322,323,324,198,198,176,176,176,176,176,176,176,176,234,197,176,198,176,176,198,215,325,326,105,327,125,42,55,124,41,328,248,329,330,14,0,0,0,0,0], 
    [0,0,0,0,0,12,60,4,11,331,332,333,18,42,80,55,43,334,335,211,336,337,338,339,340,341,342,343,215,155,176,344,176,176,176,198,345,176,176,176,176,176,176,176,198,215,197,346,347,348,349,79,43,31,42,32,350,265,351,38,130,4,0,11], 
    [0,0,0,0,0,10,73,167,11,352,224,353,66,55,125,44,43,354,355,356,357,358,359,360,361,362,363,364,365,155,155,217,344,198,176,366,176,176,176,176,176,176,176,367,178,235,234,368,325,369,370,63,44,31,55,43,66,371,372,373,374,11,111,87], 
    [0,0,0,0,0,0,0,85,375,52,53,41,42,42,54,171,376,377,378,379,380,381,382,50,60,111,50,383,384,385,386,155,176,198,198,215,176,176,176,176,176,176,176,197,176,198,176,155,198,387,388,389,241,390,44,31,42,171,186,391,392,247,393,0], 
    [0,0,0,0,0,4,0,394,395,396,150,54,42,141,43,397,398,399,400,401,402,403,404,405,60,0,60,405,406,407,408,345,215,176,176,176,176,176,176,176,176,176,176,155,218,237,198,178,409,306,410,220,139,411,186,42,42,44,41,412,413,414,415,416], 
    [0,0,0,0,0,13,331,417,418,79,31,43,42,55,334,419,420,421,422,423,424,425,25,74,60,0,0,111,0,426,427,428,429,179,218,215,176,176,176,176,176,176,176,198,198,176,176,176,155,430,155,216,157,431,432,67,31,43,42,54,42,433,316,434], 
    [0,0,0,0,0,22,435,436,437,80,42,66,55,278,438,439,440,380,320,441,442,73,0,0,87,111,443,25,0,60,444,384,445,446,447,176,176,176,176,176,176,176,176,178,176,198,178,176,215,156,198,198,447,448,449,107,450,41,44,80,44,451,452,453], 
    [111,60,12,3,85,169,454,171,43,42,42,42,41,455,456,457,320,458,459,460,0,0,0,0,0,0,0,0,0,60,60,461,462,463,464,465,324,176,176,217,256,345,344,176,176,176,176,176,197,180,466,467,468,469,470,42,31,42,43,31,471,417,472,25], 
    [4,11,50,473,474,475,476,107,54,54,55,41,477,478,479,480,422,481,482,483,0,0,0,0,0,0,0,60,0,0,60,0,111,484,485,486,487,198,176,218,180,345,198,176,217,176,176,176,176,180,198,488,489,490,186,43,79,31,44,18,162,491,492,11], 
    [11,10,74,131,493,471,42,80,31,43,42,494,495,496,497,498,499,500,501,0,60,0,0,0,0,0,0,0,60,0,0,0,60,87,4,502,503,504,218,156,155,197,198,176,176,176,176,217,176,505,506,507,508,42,44,31,42,80,171,509,510,511,111,60], 
    [11,60,38,512,513,43,42,55,31,43,54,514,515,516,517,518,519,361,12,111,111,0,0,0,0,0,0,0,60,0,0,111,111,12,111,520,521,522,523,217,344,176,217,176,176,176,176,176,409,524,525,526,106,41,43,43,43,80,63,392,527,24,528,60], 
    [4,529,530,531,532,31,43,41,43,66,533,41,534,535,536,537,538,539,60,12,60,0,0,0,0,0,0,0,111,0,60,0,0,0,74,540,60,541,542,543,343,180,198,176,176,217,176,544,545,546,547,548,43,141,42,55,65,549,550,551,14,0,0,24], 
    [11,552,553,554,555,78,43,43,31,43,55,31,556,557,558,559,560,10,50,60,0,60,11,0,4,11,246,0,0,0,0,0,0,0,0,0,0,12,462,561,562,345,155,273,563,156,564,565,566,567,568,569,43,44,42,124,67,570,8,205,72,4,11,4], 
    [10,571,572,573,574,575,576,80,44,42,31,31,42,577,450,578,579,580,581,540,4,11,24,0,0,0,4,0,0,0,0,0,0,0,0,0,0,3,10,582,583,584,585,176,176,586,587,588,589,590,186,42,42,42,44,101,591,592,593,4,10,4,0,0], 
    [111,594,595,596,597,598,599,600,41,43,54,31,31,42,41,601,602,603,604,49,0,0,0,11,85,4,0,0,0,0,0,0,0,0,0,0,0,25,111,111,444,605,606,607,345,608,609,610,611,186,171,43,55,42,31,612,613,614,98,0,0,0,11,4], 
    [313,615,616,617,618,619,620,621,622,623,80,44,41,79,41,31,66,624,625,626,627,25,4,0,4,416,111,0,0,0,0,0,0,0,0,0,0,87,50,111,50,111,628,629,630,631,632,633,294,41,107,42,42,41,32,62,634,11,11,0,0,11,0,11], 
    [0,635,636,619,637,618,618,638,639,640,116,43,43,43,42,171,31,41,18,641,642,643,246,11,4,0,73,0,0,0,0,0,0,0,0,0,0,539,313,60,60,0,444,644,645,646,647,648,45,80,44,42,55,299,53,649,650,4,0,0,0,0,4,0], 
    [416,651,652,618,653,618,619,653,617,654,655,656,657,41,41,149,55,42,41,80,658,659,660,205,85,0,0,0,11,50,0,25,0,0,0,0,0,4,111,0,3,11,661,662,663,664,665,124,43,42,107,44,79,666,667,205,0,4,0,0,0,0,0,0], 
    [668,669,670,617,618,618,653,619,618,671,574,672,673,41,44,42,80,42,42,41,80,261,52,674,15,85,0,0,11,4,3,0,0,0,0,0,0,11,0,4,0,675,676,677,678,679,680,43,42,31,41,31,299,280,681,85,0,4,0,0,0,0,0,0], 
    [682,683,684,685,686,618,618,619,619,619,618,687,688,689,690,43,42,42,54,42,44,171,32,77,82,691,84,0,4,111,0,0,0,0,0,0,0,111,0,416,540,403,692,693,694,695,65,44,42,66,31,696,697,698,84,11,12,4,0,0,0,0,0,0], 
    [22,699,700,620,617,653,701,619,619,619,619,619,597,702,703,192,65,44,79,31,31,42,41,657,704,705,706,14,1,130,0,10,0,0,0,0,0,0,60,12,661,707,708,709,710,43,107,31,42,42,43,711,712,713,11,85,111,0,0,0,0,0,0,0], 
    [246,714,715,716,717,619,619,619,618,701,619,701,596,620,718,719,720,721,41,42,42,43,80,43,41,722,723,724,725,0,11,4,0,0,0,0,0,111,111,726,727,728,729,490,730,80,66,41,31,41,731,732,145,0,11,11,4,3,0,0,0,0,0,0], 
    [0,733,734,735,736,617,653,619,619,653,619,737,737,685,738,739,740,741,742,42,44,80,79,41,42,41,743,744,745,283,11,85,0,0,0,0,0,3,25,746,481,747,748,115,66,41,43,43,31,749,750,751,49,25,0,0,0,130,111,0,0,0,0,0], 
    [167,10,416,752,753,754,755,618,686,756,686,619,619,619,619,619,618,757,758,759,601,80,42,44,31,42,124,45,602,76,760,761,0,25,50,72,762,763,764,677,765,766,767,149,44,191,42,31,78,768,769,14,473,0,0,0,0,0,0,0,0,0,0,0], 
    [4,50,4,770,771,772,773,774,617,653,619,618,618,619,619,618,686,775,776,777,778,186,42,31,31,42,43,41,41,29,779,780,781,444,0,60,60,782,783,784,785,786,32,43,42,43,42,450,787,788,691,0,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,10,0,111,246,789,790,791,792,793,618,619,619,618,619,619,618,794,686,620,757,795,796,43,171,42,31,31,44,43,171,797,798,165,799,25,800,801,802,803,804,41,42,44,55,31,43,805,806,330,1,111,0,0,0,0,0,0,0,0,0,0,0,0], 
    [11,25,11,246,25,24,246,807,808,809,686,619,619,618,618,685,701,686,617,618,597,810,703,811,41,41,41,171,79,41,42,812,813,814,650,520,764,815,816,817,818,141,171,42,78,80,42,819,649,85,3,85,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,87,11,11,11,13,4,25,820,821,822,823,619,619,618,686,686,618,618,824,824,619,718,825,826,827,41,66,42,31,31,42,42,828,829,830,831,832,833,657,66,31,31,42,42,18,834,263,835,25,50,0,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,3,13,836,837,838,839,823,738,685,840,794,619,701,618,841,619,618,638,810,741,811,80,44,44,31,43,842,101,170,843,844,845,804,65,171,42,43,43,42,578,280,846,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,60,111,11,87,847,848,849,736,617,653,619,618,794,685,619,617,824,618,850,851,852,853,334,42,124,80,31,42,55,854,855,856,299,124,44,42,31,31,857,858,859,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,60,111,111,10,85,860,594,822,861,701,617,653,618,619,619,617,617,619,685,671,776,862,863,41,41,42,41,42,43,41,186,186,44,124,43,124,31,18,864,865,283,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,25,0,60,3,11,0,111,246,866,867,868,869,737,596,617,618,738,701,618,618,618,793,870,871,795,872,41,43,31,42,43,43,31,44,43,42,44,41,613,873,14,111,73,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,11,111,87,87,4,4,874,4,85,36,875,876,877,618,824,619,597,618,619,619,617,617,596,617,878,879,192,41,54,44,880,42,42,42,842,42,31,696,224,435,10,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,881,882,883,774,794,597,618,877,686,618,619,619,619,617,884,885,886,887,41,42,31,44,42,42,65,53,888,474,85,73,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,98,889,890,891,618,686,824,738,619,618,619,653,619,618,617,892,893,894,811,44,44,43,43,150,171,895,896,246,73,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,11,799,897,898,700,653,793,686,774,617,617,618,619,619,618,899,900,901,902,63,42,31,115,903,144,904,24,11,0,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,60,0,905,906,907,908,823,793,909,686,701,701,619,619,653,793,910,776,911,912,125,44,298,913,247,473,0,0,85,11,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,10,874,50,914,915,916,917,618,618,619,619,618,618,653,653,899,617,910,918,919,920,921,922,3,4,0,0,0,11,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,60,4,111,923,924,925,926,793,618,618,619,619,618,685,617,899,617,618,620,927,928,929,581,313,416,85,0,0,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,405,11,930,931,699,932,701,686,619,617,686,597,619,686,869,933,934,615,847,25,50,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,282,935,936,877,794,619,618,618,620,701,700,937,938,939,940,4,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,4,12,0,941,942,943,944,945,793,946,947,948,949,930,847,11,4,111,11,73,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,0,60,11,0,111,950,951,952,953,652,954,931,942,85,0,11,11,111,540,0,111,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,111,12,24,4,86,799,955,956,957,860,11,0,3,60,540,0,50,0,11,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666865, 0xff656762, 0xff656764, 0xff666668, 0xff74775a, 0xffa1a43b, 0xffd7de12, 0xffa9ad34, 0xff6c6e61, 0xff676767, 0xff666664, 0xff676568, 0xff666563, 0xff676863, 0xff6e7160, 0xffbdc321, 0xffe4ed0a, 0xfff1fc02, 0xffecf508, 0xffb8be26, 0xff8f9346, 0xff6a6a62, 0xff656563, 0xff666762, 0xff676664, 0xff686669, 0xff6c6e60, 0xff868a4f, 0xffdee80d, 0xfff2fb02, 0xfff4ff00, 0xfff3fc03, 0xffe1ec0a, 0xffc1c820, 0xff7a7a56, 0xff6b6b5f, 0xff66656b, 0xff696a64, 0xffa2a637, 0xffcfd918, 0xfff4fe00, 0xfff5ff00, 0xfff5ff01, 0xfff4ff01, 0xfff2fd03, 0xffd4dc15, 0xffb2b92f, 0xff73765b, 0xff686964, 0xff656565, 0xff767559, 0xffc8cf1d, 0xffe9f306, 0xfff6ff01, 0xfff5fe03, 0xffeef706, 0xff969940, 0xff7a7a58, 0xff676862, 0xff656766, 0xff8c8f4a, 0xffbec422, 0xfff2fb00, 0xfff3ff01, 0xfff6fd00, 0xfff3fe00, 0xfff7fe03, 0xffebf107, 0xffd1d818, 0xff8d8e48, 0xff72725a, 0xff666467, 0xff656567, 0xff666867, 0xff6c6c60, 0xffb0b72d, 0xffdde60f, 0xfff3fd00, 0xfff4ff03, 0xfff3ff00, 0xffedf804, 0xffbdc323, 0xff949643, 0xff696a62, 0xff676765, 0xff676662, 0xff656668, 0xff797957, 0xff9fa53b, 0xffecf506, 0xffedee0a, 0xffeadf14, 0xfff5f602, 0xfff1fe00, 0xffe7f009, 0xffaaae36, 0xff87884c, 0xff686963, 0xff99993f, 0xffc6cf1c, 0xfff2fd00, 0xfff2fb04, 0xffdcb822, 0xffd98a3b, 0xfff0c80e, 0xfff1ea04, 0xfff7fe01, 0xffd8e210, 0xffb5be25, 0xff737659, 0xff676566, 0xff6e6f5d, 0xff8e8e46, 0xffe3eb0a, 0xfff1fc00, 0xfff2f601, 0xffe9ce0b, 0xffd1294c, 0xffe40965, 0xffe7215c, 0xffdf6155, 0xfff5e10e, 0xfff6f401, 0xfff7fe00, 0xfff3fe02, 0xfff1fb04, 0xffc9d11b, 0xffa4a839, 0xff72715d, 0xff676769, 0xff828550, 0xffafb52f, 0xffebde06, 0xffd7951b, 0xffdc0c58, 0xffe9026a, 0xffed066c, 0xffea1d6c, 0xffef9326, 0xffefc70d, 0xfff6ff02, 0xffeaf505, 0xffd5de13, 0xff8e9047, 0xff74745a, 0xff777859, 0xffcbd31b, 0xffeaf407, 0xfff5ff02, 0xfff2fe00, 0xffeae905, 0xffb85842, 0xffb81854, 0xffe90167, 0xfff0006b, 0xffef026c, 0xffec0962, 0xffe4245f, 0xffebab30, 0xfff5e20c, 0xfff6fd02, 0xffe3ef09, 0xffc7d01b, 0xff81844f, 0xff71705e, 0xff666769, 0xff66656a, 0xff75735a, 0xff979a3f, 0xffe9f106, 0xfff4fd02, 0xffeceb05, 0xffd5b019, 0xffab1e52, 0xffc40459, 0xfff0006d, 0xffef006a, 0xfff0006f, 0xfff00169, 0xfff1016c, 0xffee056e, 0xffe95150, 0xfff19224, 0xfff3ed03, 0xfff8ff02, 0xfff3fc01, 0xffeaf306, 0xffafb62c, 0xffb9be26, 0xffe3eb0e, 0xfff6ff04, 0xfff3f702, 0xffca811b, 0xffa92d37, 0xffbe0056, 0xffde0266, 0xfff1006b, 0xfff1006d, 0xffec0a60, 0xffe06053, 0xffebab2d, 0xffe4ec0b, 0xffa0a23d, 0xff7f8056, 0xff6b6b63, 0xff808451, 0xffdbe40f, 0xfff0fa03, 0xfff4fd06, 0xffebe00a, 0xffb34234, 0xffa01043, 0xffd1025c, 0xffe80063, 0xffee016d, 0xffef026a, 0xfff1016e, 0xffee016b, 0xffe91c69, 0xffea5052, 0xfff1c80c, 0xfff1ed06, 0xffd0d718, 0xffaab130, 0xff70725d, 0xff979e3f, 0xffccd11d, 0xffd5b021, 0xffb55b40, 0xff9c044d, 0xffad0052, 0xffe80066, 0xfff2016c, 0xfff1006f, 0xffef026e, 0xffed0068, 0xfff20070, 0xffee0169, 0xffe5235f, 0xffe26053, 0xfff7df0d, 0xfff3f704, 0xfff2f802, 0xffc1ca23, 0xff979c42, 0xff686765, 0xff74745c, 0xffc5cb1f, 0xffe8f007, 0xffedef05, 0xffb76432, 0xff9e1f4c, 0xffa2024c, 0xffbb0057, 0xffea016a, 0xfff2006e, 0xffec056d, 0xffe81d6e, 0xfff29126, 0xfff0c90c, 0xffe4f00a, 0xffccd11c, 0xff82854e, 0xff888a4b, 0xffbabf27, 0xfff2ff02, 0xffe9d908, 0xffcf8d1d, 0xff9b0c44, 0xff9a034a, 0xffba0053, 0xffdb0063, 0xfff2006b, 0xffeb0862, 0xffe6235d, 0xffeeaa2f, 0xfff5e00b, 0xfff5fc00, 0xffe2e80c, 0xffc0c722, 0xff797b56, 0xff6b6b61, 0xff6c6c62, 0xffacb133, 0xffdae211, 0xffd79f24, 0xffb5473a, 0xff980249, 0xff9b004b, 0xffc80058, 0xffe6006a, 0xffea086e, 0xffeb504e, 0xfff0ec05, 0xffa0a638, 0xff676964, 0xff979c40, 0xffe9f309, 0xfff2fd01, 0xffedea05, 0xff9d1d4e, 0xff99064d, 0xff98004b, 0xffa6014d, 0xffe10066, 0xfff1026a, 0xffed0962, 0xffe06152, 0xffeef804, 0xffdce50e, 0xff939743, 0xff76765c, 0xff646665, 0xff676860, 0xff929642, 0xffc3cb1e, 0xffdfbb0d, 0xffba6427, 0xff98074a, 0xff98024c, 0xff98064f, 0xffa31056, 0xffdb0a66, 0xffed026b, 0xffe71c6d, 0xffeb4f50, 0xfff4eb06, 0xfff1fa03, 0xff9fa239, 0xff6e6f61, 0xff6d6e60, 0xff868a4d, 0xffdfe90c, 0xfff4fa02, 0xffede308, 0xff9d1045, 0xff98014e, 0xff97044b, 0xff7c395a, 0xff715563, 0xff874b65, 0xffac3066, 0xffe5076c, 0xfff2006d, 0xffed016d, 0xffe5215f, 0xffe16154, 0xfff8e00e, 0xfff6f504, 0xffecf705, 0xff909346, 0xff808251, 0xfff0fa06, 0xffece80b, 0xffd6aa27, 0xffa21446, 0xff9a024b, 0xff97034d, 0xff92124f, 0xff725061, 0xff6b6066, 0xff6f6067, 0xff815167, 0xffc51d6a, 0xffe1096c, 0xfff3006e, 0xffee006f, 0xffea086c, 0xfff29325, 0xfff1c80a, 0xffe0ea0d, 0xffc2c921, 0xff7b7b55, 0xff6a6b63, 0xff75755b, 0xffefef05, 0xffb66432, 0xffa01e4c, 0xff950248, 0xff97014b, 0xff8a2255, 0xff784661, 0xff765a66, 0xff8e4767, 0xffd31369, 0xffe8066c, 0xffed0863, 0xffe52360, 0xffecaa2f, 0xfff5fc01, 0xffd5dd16, 0xffb5ba2c, 0xff686961, 0xff71735d, 0xff929544, 0xffe6f006, 0xfff3f402, 0xffe5ca09, 0xffa4293b, 0xff9b0648, 0xff97004d, 0xff95084d, 0xff7b3e5d, 0xff6e5a65, 0xff686465, 0xff6f5e66, 0xffa83368, 0xffcd1869, 0xffef006c, 0xffec076c, 0xfff3eb04, 0xffeff807, 0xffe1e90c, 0xff989b44, 0xff787957, 0xff686667, 0xffb3b72e, 0xffdfe60d, 0xffd89e21, 0xffb6463b, 0xff970149, 0xff99014c, 0xff91144e, 0xff823259, 0xff676364, 0xff6b6265, 0xff785865, 0xffbe2269, 0xffdd0e69, 0xfff2016a, 0xffdd6c4c, 0xffecc71e, 0xffe7f107, 0xff70715f, 0xff7c7e56, 0xffd6dd15, 0xffeff704, 0xffece80d, 0xffb55443, 0xffa1164d, 0xff842b57, 0xff744d60, 0xff646663, 0xff696564, 0xffb22a6a, 0xffe80668, 0xffee036c, 0xffe2474d, 0xffeab119, 0xfff2ff00, 0xffe9f108, 0xffc3c823, 0xff6d6d61, 0xffc6ce20, 0xffdcbe12, 0xffb76736, 0xff97064b, 0xff95084c, 0xff8b2054, 0xff6c5b65, 0xff6a6466, 0xff6d6067, 0xff983d68, 0xffc12169, 0xffeb0369, 0xfff2006f, 0xffea036b, 0xffdb1d63, 0xffe1b11f, 0xfff0e907, 0xfff0fb01, 0xff83834f, 0xff666863, 0xff73725d, 0xffc3c921, 0xffe3ef07, 0xfff3f901, 0xffc7811f, 0xffa62d3c, 0xff96034a, 0xff8d1c50, 0xff7d3e5b, 0xff696468, 0xff745866, 0xff954165, 0xffd90e68, 0xffe90469, 0xffe1135d, 0xffd94f45, 0xffede70b, 0xff8d8f46, 0xff6f7060, 0xffb2b62b, 0xfff1ed05, 0xffdeb412, 0xffa31746, 0xff97044a, 0xff99034a, 0xff921151, 0xff725261, 0xff686266, 0xff834e68, 0xffa23668, 0xffe20869, 0xffea0268, 0xffd90762, 0xffcf6d24, 0xffe7c80b, 0xffd5de15, 0xffa3a739, 0xff696967, 0xffa5a93a, 0xffd4dd14, 0xffefe605, 0xffd6a411, 0xffa11449, 0xff9c054c, 0xff940b4f, 0xff892758, 0xff696365, 0xff7b5668, 0xffc0206a, 0xffe10a68, 0xffdd0362, 0xffc41b56, 0xffdeb317, 0xff848750, 0xff666561, 0xff696866, 0xff807d52, 0xffdfe008, 0xfff1f500, 0xfff4ff02, 0xfff0f401, 0xffd4a424, 0xffb56240, 0xff814c56, 0xff6d5e63, 0xff696566, 0xff666465, 0xff715d66, 0xff8a4967, 0xffcf186b, 0xffec006b, 0xffd90260, 0xffbd3537, 0xffd5921f, 0xfff6fa03, 0xffebf407, 0xffcbd419, 0xff76745d, 0xff6a6964, 0xff847c4b, 0xffdacd03, 0xffe9e500, 0xfff4fd04, 0xffebe70a, 0xffd9c21c, 0xff928244, 0xff74725d, 0xff9f3a66, 0xffc71c68, 0xfff10170, 0xffed016f, 0xffda005f, 0xffc00657, 0xffc46c22, 0xffe5c609, 0xfff6fc04, 0xffd9e40e, 0xff75705a, 0xff9a8832, 0xffcbaa05, 0xffd0b100, 0xffe2d701, 0xffedeb02, 0xfff3ff03, 0xffe5ee0b, 0xffc7d01d, 0xff7f8054, 0xff6e6f5f, 0xff686367, 0xff735b68, 0xffb82768, 0xffd71169, 0xffee006b, 0xffde0161, 0xffb0134a, 0xffbb4e39, 0xffece908, 0xffe8f206, 0xff939647, 0xff70725c, 0xff7a7452, 0xffa69124, 0xffcca903, 0xffcdab01, 0xffd5bb02, 0xffe0cf05, 0xfff0f600, 0xfff4fb00, 0xffe9f307, 0xffaeb12e, 0xff8b8b4b, 0xff894a67, 0xffab3268, 0xffe7066c, 0xffe20066, 0xffc70158, 0xffb43735, 0xffd4911c, 0xffedf607, 0xffcdd617, 0xff75785b, 0xff82774a, 0xffb0981c, 0xffcbab02, 0xffccaa02, 0xffccaa00, 0xffccac01, 0xffdac301, 0xffe4d901, 0xfff2f900, 0xfff0fa05, 0xffe2ed0b, 0xff9a9e3f, 0xff7b7d56, 0xff6d6364, 0xff993d64, 0xffbb1964, 0xffac0452, 0xffa31e4b, 0xffd8b31a, 0xff8c8d47, 0xff877b41, 0xffb49918, 0xffcda800, 0xffcfb000, 0xffd6bd00, 0xffeae600, 0xffcdd31b, 0xffa7ac34, 0xff71705c, 0xff7b4b61, 0xff96255d, 0xffa61347, 0xffb84f3a, 0xffebe90a, 0xff969b41, 0xff72745c, 0xffa38d27, 0xffc0a20c, 0xffcba900, 0xffd2b500, 0xffdbc205, 0xffeded01, 0xfff1fa01, 0xffeef905, 0xffc0c721, 0xff9b9b41, 0xff6a5d64, 0xff8a2257, 0xff950f4c, 0xffc36b21, 0xffe4c709, 0xffe0e80b, 0xffb4b92b, 0xff696864, 0xffad941e, 0xffc7a506, 0xffccac00, 0xffe1d300, 0xffeae800, 0xff818351, 0xff6a6166, 0xff734d62, 0xff961152, 0xff9e1c4a, 0xffd7b317, 0xffefeb03, 0xff8f9245, 0xff6c6962, 0xffb19819, 0xffc9a805, 0xffccab00, 0xffcbab00, 0xffcdac00, 0xffd1b200, 0xffe4da00, 0xffedee00, 0xff76765a, 0xff8f1953, 0xffae3637, 0xffd4931f, 0xfff4fa04, 0xffeff902, 0xffd4e012, 0xff7a7b59, 0xffb29918, 0xffc9a803, 0xffcba901, 0xffd5bd01, 0xffe1d301, 0xffe6ed0b, 0xff9ca13d, 0xff7e7f57, 0xff892257, 0xff960e4e, 0xffc06d21, 0xffe5c80c, 0xffe2ea0b, 0xffb8be28, 0xff6c6c64, 0xff867b45, 0xffa19026, 0xffc8a808, 0xffcaab03, 0xffceac02, 0xffd8c401, 0xffe3da01, 0xfff3fa00, 0xffecf707, 0xffd9e110, 0xff90923f, 0xff76745b, 0xff6f5463, 0xff80345a, 0xffa01647, 0xffb45038, 0xfff5fb03, 0xffebf606, 0xff9a9e3d, 0xff716a60, 0xff80774c, 0xffb39a19, 0xffc4a608, 0xffcea902, 0xffcea900, 0xffcfb103, 0xffd6bf01, 0xffebe900, 0xfff1f701, 0xfff1f905, 0xffc1c823, 0xff979b3d, 0xff7a3f5b, 0xffae3635, 0xffd2941d, 0xfff0fb00, 0xffdbe312, 0xff7c7f52, 0xff767058, 0xff8d7f3e, 0xffc1a110, 0xffc9a506, 0xffcbaa00, 0xffcfb500, 0xffd8c602, 0xfff0ef00, 0xff8d9147, 0xff686b62, 0xff65666a, 0xff6a6164, 0xff734e60, 0xffa01c4d, 0xffd8b416, 0xffeeec03, 0xffc5cb21, 0xff959744, 0xff646963, 0xff706d5a, 0xffa38d2a, 0xffb69c13, 0xffcba802, 0xffccac03, 0xffd0b202, 0xffe3d301, 0xffece800, 0xffbec621, 0xff767a59, 0xff6a6c61, 0xff6e5663, 0xff7f345b, 0xff9f1749, 0xffb5513a, 0xffebe908, 0xffedf605, 0xffa0a33c, 0xff696961, 0xff777159, 0xffab9420, 0xffc1a40a, 0xffcaaa01, 0xffcbaa03, 0xffe5dd00, 0xffefee00, 0xffd0d519, 0xffabb02f, 0xff696863, 0xff6a5e62, 0xff892152, 0xff980d4e, 0xffc26c23, 0xffe4c707, 0xffe6ef0c, 0xffbfc523, 0xff897d43, 0xffa69126, 0xffc8a702, 0xffd7be00, 0xfff2f800, 0xffebf604, 0xffd9e310, 0xff909344, 0xff96104f, 0xffa01c4e, 0xffd8b418, 0xfff0ec04, 0xffcbd01c, 0xff6d6b5e, 0xff948439, 0xffb0961d, 0xffcaa904, 0xffcaaa00, 0xffd9c600, 0xffe4db00, 0xfff1fa00, 0xffe8f005, 0xffcbd01b, 0xff8b574a, 0xff8e234f, 0xffb03635, 0xffd0941c, 0xffe2e70f, 0xff6b6d62, 0xff666761, 0xff756f55, 0xff89803f, 0xffbea30a, 0xffcea903, 0xffcca905, 0xfff7ff00, 0xffb5752d, 0xffa2333c, 0xffc16b22, 0xff6f705e, 0xff686763, 0xff847a49, 0xff9b8a2e, 0xffcdaa04, 0xffd1b700, 0xffdcc601, 0xffeeee02, 0xfff1f002, 0xffe6da08, 0xffecee05, 0xffeefa04, 0xffa9ad32, 0xff7a7c55, 0xff6d6b5f, 0xffc3a509, 0xffe3d502, 0xffedeb03, 0xffe0eb0b, 0xff89894d, 0xff706d5e, 0xff867c47, 0xffba9d11, 0xffc6a605, 0xffceae01, 0xffd0b601, 0xfff0f100, 0xff999f3f, 0xff656469, 0xff998733, 0xffb2991a, 0xffcaa902, 0xffd7c100, 0xffe4d601, 0xfff6ff00, 0xff736f56, 0xffa89424, 0xffbca10c, 0xffcbad00, 0xffddc405, 0xffe7de03, 0xfff2fc00, 0xffc7d01f, 0xff867a48, 0xffa08c2b, 0xffc6a606, 0xffd0b300, 0xffd7c000, 0xffecec02, 0xffd2da15, 0xffa1a439, 0xff897f41, 0xffaa9520, 0xffcdab03, 0xffd3b602, 0xffdbc704, 0xffeff300, 0xffe5ee07, 0xff6d705d, 0xff706d5c, 0xff887b44, 0xffbca010, 0xffc8a704, 0xffcda801, 0xffcead00, 0xffe3d802, 0xffecec00, 0xffc8d01b, 0xff7c7352, 0xff92843b, 0xffc1a408, 0xffc9ab00, 0xffd4b701, 0xffe7df00, 0xffebee01, 0xffb3bb28, 0xff85854f, 0xff69695f, 0xff75705c, 0xffad9420, 0xffc2a30b, 0xffd4bf04, 0xffd5cc0b, 0xff8f8f45, 0xff6f6c5d, 0xff81794b, 0xffc5a505, 0xffbba110, 0xff928537, 0xff94833b, 0xffad971d, 0xffaf9719, 0xff998931, 0xff716e5b, 0xff6b685f, 0xff6b6766, 0xff726d5a, 0xff9f8d2b, 0xffb89c15, 0xffc9aa01, 0xffc9aa02, 0xffc7a707, 0xffa89326, 0xff8f833b, 0xff7d754e, 0xff968537, 0xffc2a408, 0xffcaa701, 0xffac961e, 0xff8b8040, 0xff9d8930, 0xff7a7651]
				); 
        }
		public function box7():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,2,0,5,6,2,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,2,1,7,8,9,7,7,10,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,12,13,14,15,16,17,18,1,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,0,20,21,22,23,24,25,26,7,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,28,29,30,31,32,33,34,35,2,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,2,0,0,0,4,4,0,0,36,37,38,39,40,32,41,42,43,44,45,46,18,4,4,47,48,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,49,0,0,0,50,51,52,53,54,41,41,55,56,57,58,59,60,4,4,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,10,62,63,64,65,54,56,66,32,54,54,66,32,67,68,69,2,70,71,71,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,7,0,10,72,73,74,75,41,76,54,77,43,41,78,41,53,79,80,81,4,71,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,82,83,21,84,85,43,78,32,41,66,86,87,32,32,54,43,88,89,90,2,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,7,91,92,93,94,56,43,41,41,95,43,55,96,97,32,43,41,41,43,98,99,100,101,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,61,0,0,4,0,0,0,103,104,105,106,54,54,54,107,108,56,109,110,111,112,113,114,54,32,107,66,115,116,117,2,19,4,0,4,2,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,102,4,2,0,2,0,118,119,120,98,41,56,54,41,121,41,108,122,123,124,125,126,127,96,107,42,54,32,128,129,7,3,2,2,4,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,0,2,0,2,7,130,131,132,32,54,133,41,54,41,41,88,134,135,136,137,138,139,140,141,108,142,43,66,109,143,144,69,36,71,61,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,2,7,0,1,145,146,147,148,41,41,133,41,133,32,149,150,151,152,153,154,155,154,156,157,42,32,66,66,66,158,159,160,161,47,4,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,71,10,4,162,163,164,165,55,66,54,66,32,166,96,167,168,169,170,171,172,173,174,155,175,176,177,167,42,178,41,66,179,180,181,1,71,36,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,182,0,0,4,0,3,182,10,183,184,185,186,96,54,66,187,78,42,188,189,190,191,192,192,192,192,193,194,193,195,196,197,198,43,32,32,33,199,200,130,0,48,4,0,0,2,4,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,48,48,201,0,14,104,202,203,204,32,54,95,43,41,205,206,207,208,174,192,209,192,192,209,137,209,192,153,210,211,212,56,41,108,107,76,213,214,215,2,2,2,4,61,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,1,2,0,2,216,21,217,76,96,32,54,95,66,54,77,218,219,220,221,155,192,192,193,209,209,222,223,171,193,173,224,225,226,43,133,77,41,227,30,228,3,0,2,0,0,2,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,71,91,47,7,229,230,179,114,231,56,187,54,41,87,33,143,232,233,222,192,193,192,192,209,194,192,223,193,223,194,174,192,234,196,235,133,236,77,107,33,237,238,7,4,2,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,4,7,10,239,240,241,41,77,107,41,43,54,32,32,242,243,244,245,246,173,171,192,209,209,192,173,137,223,137,247,248,249,250,251,252,96,66,56,41,77,253,254,255,0,2,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,3,71,0,0,11,36,2,256,257,258,259,42,231,107,41,77,54,54,179,260,261,262,1,263,264,265,154,153,193,192,173,193,192,192,192,192,192,192,153,174,266,267,96,41,54,66,66,268,269,270,7,0,271,11,0,0,0,0,0], 
    [0,0,0,0,0,4,1,0,272,0,4,273,274,275,276,54,55,41,54,41,41,54,32,277,278,279,4,61,4,280,281,223,154,154,173,193,193,192,192,192,192,192,192,282,248,283,284,285,56,107,41,107,88,286,287,288,2,12,2,0,0,0,0,0], 
    [0,0,0,0,0,5,4,11,1,7,289,243,290,32,88,41,32,41,43,43,32,290,105,289,70,101,0,0,291,292,293,294,295,194,171,193,171,192,192,192,192,192,192,154,209,296,297,298,299,41,55,43,56,300,301,83,103,48,102,0,0,0,0,0], 
    [0,0,0,0,0,2,2,10,0,117,302,303,33,107,66,96,41,66,304,56,305,306,35,7,307,0,0,0,0,11,308,309,310,192,311,193,194,192,192,192,192,192,192,171,296,312,193,313,314,87,133,56,43,41,179,315,59,48,0,0,0,0,0,0], 
    [0,0,0,0,0,18,4,316,317,318,319,41,66,43,54,66,54,32,32,320,321,322,0,0,7,71,7,0,0,47,3,263,323,324,174,137,192,192,192,192,192,192,192,282,171,193,192,311,325,326,327,54,32,66,41,328,329,330,331,0,0,0,0,0], 
    [0,0,0,0,0,61,10,332,333,334,335,54,54,54,32,43,54,336,165,337,117,1,331,3,0,338,339,291,0,1,3,60,340,341,342,137,223,192,192,192,192,192,192,343,154,172,171,192,195,344,345,88,346,66,41,347,348,349,17,0,0,0,0,0], 
    [1,19,0,4,2,350,351,352,336,43,66,41,41,55,54,32,353,354,72,0,355,0,0,0,0,0,0,0,0,0,0,0,36,293,356,170,193,173,154,193,192,192,194,192,192,192,192,192,194,357,358,359,88,32,41,41,32,360,361,362,102,0,0,0], 
    [11,19,61,0,363,364,365,366,96,56,41,54,41,41,96,65,367,144,130,47,2,0,0,0,0,0,0,0,0,0,0,0,4,368,369,370,312,174,193,193,371,192,192,192,192,192,192,192,372,373,374,375,226,41,54,43,41,98,99,376,102,0,82,4], 
    [182,11,11,377,378,379,380,381,382,41,43,41,41,32,32,383,384,10,71,1,6,0,0,0,0,0,0,0,0,0,0,0,36,27,182,385,386,371,222,194,171,193,193,192,192,192,192,192,192,174,387,388,389,390,54,133,55,114,391,214,50,0,0,2], 
    [4,392,393,394,395,396,397,398,399,32,66,187,32,43,66,400,302,7,2,0,48,0,0,0,0,0,0,0,0,0,0,0,1,3,18,401,402,403,404,223,173,248,193,192,192,192,192,192,193,405,193,406,407,408,32,96,54,109,54,409,410,0,2,4], 
    [411,412,413,414,415,396,416,417,418,419,96,43,77,41,66,420,421,422,28,423,11,0,0,0,0,0,0,0,0,0,0,0,0,19,102,2,424,425,426,137,192,311,427,192,192,192,192,192,193,428,153,209,248,429,430,87,107,107,66,97,431,432,162,292], 
    [433,434,435,436,436,379,437,414,438,439,440,54,41,54,66,32,441,442,443,19,0,0,0,7,71,102,11,0,0,0,0,0,0,0,0,1,1,444,445,223,192,194,192,192,194,192,192,192,171,171,192,192,137,446,447,448,32,41,54,41,23,449,83,1], 
    [450,451,452,436,436,437,453,436,454,455,456,441,107,42,32,41,43,227,457,14,7,2,2,2,4,2,4,0,0,0,0,0,0,0,0,0,0,0,340,458,324,174,174,192,192,171,193,192,174,137,153,427,138,459,460,461,462,54,56,121,87,463,464,465], 
    [466,467,468,414,414,414,436,469,437,397,470,471,76,472,41,41,32,32,179,104,473,0,4,0,0,0,474,0,0,0,0,0,0,0,0,0,0,36,368,475,476,153,404,192,137,192,193,223,223,477,248,478,479,480,481,482,483,133,96,54,41,33,421,484], 
    [10,485,486,414,487,437,436,414,437,453,437,488,489,107,54,66,66,54,95,490,237,118,1,61,0,11,0,0,0,0,0,0,0,0,0,0,0,5,19,491,492,493,170,171,193,494,495,496,497,498,499,500,501,502,503,259,33,41,41,86,54,41,33,504], 
    [2,505,506,507,452,416,436,396,416,508,437,509,510,511,54,43,43,88,43,441,253,512,513,2,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,1,514,515,516,517,518,519,520,521,522,523,524,525,526,527,528,54,54,41,304,32,43,382,529,530], 
    [36,1,531,532,533,437,487,453,487,453,534,469,397,535,536,88,41,54,41,43,109,128,537,392,2,1,4,0,61,0,0,2,61,36,0,5,355,2,0,36,538,539,540,541,542,543,544,545,546,547,548,549,550,56,42,88,56,76,66,95,551,552,484,3], 
    [4,2,11,553,554,453,436,508,487,437,436,436,469,555,556,366,41,187,32,66,54,557,217,273,0,3,10,0,0,0,0,0,0,0,7,0,49,2,0,514,558,559,560,561,562,545,563,564,565,566,567,568,569,54,54,41,204,187,107,570,571,317,572,1], 
    [36,10,4,2,573,574,575,414,437,436,508,437,414,437,576,577,578,41,54,32,54,66,335,579,261,2,423,0,0,0,0,0,2,0,19,102,102,291,580,581,582,547,564,583,584,562,564,585,586,587,588,32,32,54,107,32,41,32,589,590,591,2,592,0], 
    [47,0,4,61,11,593,594,595,414,436,469,437,414,436,453,596,597,41,598,96,41,66,66,599,600,91,61,0,0,0,0,0,27,4,47,423,5,601,602,603,604,564,562,543,543,605,605,606,607,608,609,610,41,41,41,32,54,463,611,612,91,613,4,61], 
    [4,2,0,36,71,531,614,615,379,616,436,397,414,617,414,396,618,619,620,43,41,54,54,54,621,622,623,2,0,0,0,0,1,624,0,625,626,627,628,629,561,564,562,561,543,630,631,632,633,598,133,32,86,66,32,634,303,635,636,61,7,61,102,423], 
    [0,2,0,11,1,0,256,637,638,414,436,436,414,639,640,641,642,643,644,107,43,41,304,41,33,645,484,82,2,0,0,4,18,4,5,646,647,648,562,649,562,564,544,543,563,650,651,652,77,66,66,66,41,32,55,328,34,653,37,36,47,1,0,11], 
    [0,0,0,0,0,71,1,505,654,655,437,508,508,436,396,414,396,656,657,327,32,41,107,54,54,658,659,660,661,0,182,4,47,662,663,664,665,666,667,562,544,562,561,668,669,670,671,41,54,32,54,32,66,391,672,673,674,4,7,0,0,0,0,0], 
    [0,0,0,0,0,36,292,3,675,676,677,396,508,469,437,396,453,414,678,679,680,41,681,41,41,108,682,683,684,2,0,27,685,686,687,688,561,689,690,564,562,561,691,692,693,620,187,107,43,77,77,41,107,694,695,696,36,12,2,0,0,0,0,0], 
    [0,0,0,0,0,12,36,1,11,697,698,699,700,436,487,396,396,617,396,701,702,703,56,41,56,41,43,84,704,705,3,706,707,560,544,605,544,649,543,561,563,708,709,710,87,43,66,304,41,41,54,557,711,712,256,4,5,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,4,2,91,713,714,715,639,436,437,699,453,617,453,642,455,716,158,32,54,88,32,335,67,717,718,719,720,605,561,649,604,561,547,688,721,722,723,76,66,76,41,166,77,54,76,22,724,725,0,685,726,102,0,0,0,0,0,0], 
    [0,0,0,0,0,36,0,1,1,18,6,727,728,729,640,508,469,396,437,414,414,730,731,149,54,54,43,66,109,732,733,734,547,544,605,544,544,735,665,736,737,738,96,88,86,43,95,41,41,739,740,145,741,1,0,36,3,61,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,742,743,744,453,617,436,396,437,453,453,656,745,746,96,66,88,41,166,747,748,749,584,545,561,750,584,751,752,753,754,54,41,54,41,32,41,66,551,755,72,102,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,47,392,756,757,414,436,396,453,414,436,414,508,758,759,41,187,56,41,133,259,760,761,762,543,563,763,764,765,87,54,108,66,54,88,231,107,766,767,322,36,11,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,36,592,714,768,617,769,414,453,508,436,770,453,771,772,620,41,54,41,56,88,773,774,775,584,776,777,778,779,42,107,43,32,54,66,56,65,780,781,7,3,0,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,7,0,1,782,783,784,453,414,396,414,415,414,453,454,785,786,54,107,66,66,109,787,788,789,790,791,88,43,95,54,66,43,32,158,792,337,10,0,0,2,4,7,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,793,2,2,215,794,795,437,487,453,436,396,414,437,436,745,796,420,66,32,66,32,441,797,798,799,366,43,32,43,41,66,55,335,800,361,14,2,0,272,19,4,793,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,91,801,802,379,415,436,437,437,437,453,436,803,804,703,32,41,41,43,32,32,54,41,66,32,54,43,109,805,806,807,101,11,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,808,809,575,437,810,453,453,437,437,469,811,812,813,66,43,66,41,41,41,41,41,54,41,187,346,814,815,816,817,102,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,685,818,819,820,617,437,437,437,437,453,453,811,821,822,149,41,54,41,41,41,54,32,54,53,31,823,824,0,4,36,49,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,10,825,826,827,437,437,453,437,437,416,414,678,828,829,41,41,55,54,54,41,43,41,830,831,83,832,7,7,0,47,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,1,0,833,834,451,414,416,453,437,437,453,453,417,835,836,32,41,41,41,54,56,303,837,653,0,7,19,36,2,10,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,61,0,838,839,840,379,437,453,453,453,414,414,437,701,841,842,41,41,41,77,290,843,844,392,331,0,2,71,0,71,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,4,0,36,11,845,846,453,416,397,640,436,414,453,437,847,848,33,43,682,849,816,273,5,5,36,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,19,0,0,19,850,851,852,379,853,487,452,452,396,437,854,855,856,598,857,858,859,19,11,4,19,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,7,860,861,862,863,864,865,794,866,867,868,869,870,871,872,873,1,11,272,47,71,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,19,4,182,0,291,10,2,91,838,874,875,876,877,878,879,880,18,3,102,0,19,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,4,61,1,2,4,19,0,19,182,49,1,423,36,36,0,2,4,6,10,1,1,2,102,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff676566, 0xff666664, 0xff656764, 0xff666668, 0xff676568, 0xff686765, 0xff676767, 0xff777657, 0xff74745a, 0xff676765, 0xff676664, 0xff66656a, 0xff686963, 0xff72715d, 0xffa9ae30, 0xff9da339, 0xff686964, 0xff666865, 0xff656668, 0xff6a6964, 0xff979a41, 0xffc7ce20, 0xfff1fb04, 0xffeaf306, 0xff959944, 0xff707161, 0xff636766, 0xff6b6b5f, 0xff7f8152, 0xffcbd419, 0xffebf508, 0xfff4fe00, 0xfff3fc01, 0xffc0c721, 0xff8b8c4a, 0xff656766, 0xff6b6764, 0xff6f725d, 0xffc0c521, 0xffe1e90a, 0xfff5ff00, 0xfff7fe01, 0xfff4ff00, 0xfff2fb04, 0xffd7de14, 0xff747857, 0xff666867, 0xff656563, 0xff646665, 0xff747758, 0xff959743, 0xffe7f009, 0xfff2fd03, 0xfff5ff01, 0xfff6ff02, 0xfff3fe00, 0xffecf609, 0xff979c42, 0xff6f715c, 0xff656469, 0xff656565, 0xff6c6e61, 0xff838651, 0xffd4dc15, 0xffebf604, 0xfff4ff01, 0xffe5ee07, 0xffbabf27, 0xff6b6b61, 0xff686868, 0xff656567, 0xff8c8d49, 0xffb5bd2a, 0xfff0f805, 0xfff3ff03, 0xfff3fd00, 0xfff5fe03, 0xfff6ff04, 0xffdee50c, 0xff7a7a56, 0xff686b62, 0xff666762, 0xff76765a, 0xffe8f206, 0xfff3fc05, 0xfff6ff00, 0xfff6fd02, 0xfff4fd02, 0xffc7ce1c, 0xff919244, 0xff676863, 0xff6b6c66, 0xffa0a638, 0xffccd71b, 0xfff4ff03, 0xfff6fd00, 0xfff5fc01, 0xffe7f107, 0xffbfc621, 0xff6b6d62, 0xff676662, 0xff676769, 0xff686866, 0xff909247, 0xffbfc523, 0xfff0fa03, 0xfff3ff00, 0xfff7fe03, 0xfff3fe02, 0xfff5dd07, 0xfff19d20, 0xffe36858, 0xffe6b92a, 0xfff4fd04, 0xffeefa02, 0xffa2a53a, 0xff767758, 0xff696961, 0xff757657, 0xffc3cb20, 0xfff8ff02, 0xfff3f003, 0xfff08924, 0xffef3e48, 0xffe11c6c, 0xffdb654b, 0xfff5f500, 0xffccd21a, 0xff969940, 0xff6c6c62, 0xffacb130, 0xffd4dc17, 0xfff7fe00, 0xffe6b82f, 0xffdb5f5f, 0xffee0669, 0xfff1016e, 0xffed006a, 0xffed0a64, 0xfff19b22, 0xfff5e90b, 0xfff2ff02, 0xffe6ef08, 0xff83864f, 0xff6f705e, 0xff8d8e4a, 0xffdce50e, 0xffedf804, 0xfff5fc00, 0xfff6ea0c, 0xffe15764, 0xffe21975, 0xffef026c, 0xfff2016c, 0xfff10069, 0xffed4c52, 0xffefae2c, 0xfff2fb00, 0xffa7ad33, 0xff797a58, 0xff626665, 0xff6a6965, 0xff787758, 0xffcacf1b, 0xffe7f105, 0xfff2ff00, 0xfff3f001, 0xfff19623, 0xffef4747, 0xffee036c, 0xfff1006b, 0xfff1006f, 0xfff1016c, 0xffee016b, 0xffef0371, 0xffe21a72, 0xffe5ba1d, 0xfff8ff00, 0xffecf506, 0xffc7d01d, 0xff6f7060, 0xff686667, 0xff7e7f53, 0xffa4a639, 0xffebf407, 0xfff2fe00, 0xfff6ff01, 0xfff1f00a, 0xffe5bc16, 0xffed304c, 0xfff20c66, 0xfff0006d, 0xfff0006b, 0xfff1006d, 0xffeb046e, 0xffe4662b, 0xfff0ce0a, 0xfff6fe00, 0xffe9f108, 0xff8a8a4a, 0xff68666b, 0xffe2ea09, 0xfff1fa03, 0xfff7ff00, 0xfff6fb00, 0xfff5ec0b, 0xffd95f5c, 0xffdf1e71, 0xfff0006f, 0xffee0e64, 0xffee484c, 0xfff6ed0a, 0xffd4dd12, 0xffa2a638, 0xff666863, 0xff686a65, 0xffc4ca1e, 0xfff6e708, 0xfff3ab25, 0xffe41871, 0xffec056f, 0xfff2006e, 0xffee016d, 0xffed116b, 0xffe8b32f, 0xfff2f109, 0xffecf504, 0xff70725c, 0xff85894e, 0xffaeb031, 0xfff3ff01, 0xffae7947, 0xffca2863, 0xffe21c5a, 0xfff5f904, 0xfff7fd05, 0xffb4bc28, 0xff828452, 0xff726f5c, 0xffbac125, 0xffdfe60d, 0xffdeea0c, 0xffbec621, 0xff7c655f, 0xff9c3b64, 0xffeb026f, 0xfff30070, 0xfff00169, 0xfff20070, 0xffed0666, 0xffea2f4a, 0xfff5e607, 0xffdae412, 0xffa7ac38, 0xff686961, 0xff6a6a62, 0xff9a9e3d, 0xffc8d01b, 0xfff4fb00, 0xffd1d818, 0xff7d8053, 0xff6c6e60, 0xff6c6167, 0xffb72765, 0xffe3096a, 0xffe8525b, 0xffe5b62c, 0xffecf307, 0xff8f9148, 0xff706f5d, 0xff646567, 0xff666769, 0xff6d6e60, 0xff828151, 0xffccd719, 0xffeaf407, 0xffcad21a, 0xff9ea438, 0xff69695f, 0xff8d4666, 0xffc02068, 0xffef006c, 0xffe5176c, 0xffd95f50, 0xfff2f302, 0xffbbc620, 0xff8a8c4b, 0xff666761, 0xff70725d, 0xffe2ea0b, 0xff696566, 0xff666563, 0xff745a67, 0xffd11569, 0xffea056a, 0xffef026a, 0xffef0566, 0xfff29724, 0xfff5e708, 0xfff1f905, 0xffd6df14, 0xff969b3f, 0xffe5f109, 0xfff5ff02, 0xffedf806, 0xffb2b62b, 0xff666469, 0xff696468, 0xffa63465, 0xffd5136a, 0xffef026e, 0xffee0169, 0xfff04847, 0xfff4ac26, 0xff959841, 0xff6f6d5e, 0xff87884f, 0xffd3db14, 0xffecf703, 0xffc9d31c, 0xff9fa539, 0xff6a6b63, 0xff884966, 0xffe60669, 0xffe31770, 0xffe7b91b, 0xfff1f201, 0xffe4ed0a, 0xffb6bc28, 0xff6b6a66, 0xff686669, 0xff8c9046, 0xffbac123, 0xfff0f804, 0xfff2fd01, 0xfff3fc03, 0xff969844, 0xff696768, 0xff646663, 0xff6f5e66, 0xffc71c6a, 0xffe8066a, 0xfff1026a, 0xffe9682f, 0xfff3cc0b, 0xfff8ff01, 0xfff3f903, 0xffd9e112, 0xff757956, 0xff787459, 0xff9c9e3d, 0xffe8f10a, 0xffeff904, 0xffb6bb29, 0xff666467, 0xff9f3968, 0xffef0d63, 0xffee4b46, 0xfff2ed0d, 0xffc3ce1a, 0xff909346, 0xff676661, 0xff6c6960, 0xff988e37, 0xffc6c31c, 0xfff2fc00, 0xffd5dc14, 0xff6a6464, 0xff7d5367, 0xffdd0e69, 0xffed016d, 0xfff2006f, 0xfff2026d, 0xfff01267, 0xffe6b42d, 0xff6d6a61, 0xff887b46, 0xffa99324, 0xffcaa902, 0xffcfb101, 0xffecea01, 0xfff1fc00, 0xffbcc224, 0xff84884b, 0xff8f4566, 0xffc11f68, 0xffee026e, 0xffe41d62, 0xffe4672f, 0xfff7f900, 0xffeff905, 0xff676862, 0xff706e59, 0xffad971f, 0xffc4a608, 0xffcba901, 0xffccac01, 0xffe0d001, 0xffefef03, 0xffcfd51b, 0xff725c68, 0xff934368, 0xffe70569, 0xfff2006b, 0xfff10268, 0xffee0767, 0xffee304c, 0xfff6e209, 0xffc8d219, 0xff94993d, 0xff6d6b5e, 0xff9c8b2f, 0xffb89a14, 0xffcbab02, 0xffccac03, 0xffcba900, 0xffceae01, 0xffd6bd01, 0xfff0f400, 0xfff6fc04, 0xffe8f007, 0xff898c49, 0xff666465, 0xff6b6265, 0xffad3068, 0xffd81068, 0xffee006f, 0xfff2006d, 0xffea4f57, 0xffebb32c, 0xffe5eb0b, 0xff818351, 0xff897f41, 0xffc3a10c, 0xffc9a805, 0xffcbab00, 0xffccaa00, 0xffcdaf01, 0xffe9df03, 0xfff2f900, 0xfff2fb02, 0xffb3b62b, 0xff807f51, 0xff844e66, 0xffb52968, 0xffe81773, 0xffdc5c59, 0xfff2f208, 0xffa3a736, 0xffa48c2a, 0xffcaa904, 0xffcba802, 0xffccaa02, 0xffcdab01, 0xffd0b300, 0xffdbc903, 0xffccd41c, 0xffc51d68, 0xffec0168, 0xffe60565, 0xffec9917, 0xfff1e902, 0xffeaf408, 0xffc4ca20, 0xff6d705d, 0xff7f764b, 0xffc4a20b, 0xffcda800, 0xffcaaa00, 0xffd0b601, 0xffeeec03, 0xfff8ff04, 0xff6e6f61, 0xff646466, 0xff993e69, 0xffcc196a, 0xfff0006a, 0xffe60166, 0xffe10164, 0xffd40265, 0xffce0f55, 0xffe4980f, 0xfff1e400, 0xff8a8d4a, 0xff867c47, 0xffac9521, 0xffcbaa03, 0xffd5bb02, 0xffe4da00, 0xffe2ee08, 0xff696365, 0xff7e5166, 0xffde0d6b, 0xffea0068, 0xffe50065, 0xffd80063, 0xffcf005a, 0xffb90052, 0xffb00052, 0xffa3014c, 0xff9d024e, 0xffb35345, 0xffd7a623, 0xffc8d01a, 0xff6f6b5f, 0xff8c7e41, 0xffc8a606, 0xffcca903, 0xffceaf00, 0xffd8c100, 0xfff2f601, 0xff7b7c54, 0xff6c6865, 0xff6b6066, 0xffbd2467, 0xffe10768, 0xffe20062, 0xffdd0163, 0xffcd005b, 0xffc10157, 0xffae0153, 0xffaa0050, 0xff9d014b, 0xff99014a, 0xff97044b, 0xff9b1b4c, 0xffd6b226, 0xffedeb0a, 0xffe4f006, 0xff999d3e, 0xff696863, 0xff988831, 0xffbda111, 0xffcea903, 0xffdcc901, 0xffece801, 0xff949843, 0xff676163, 0xff82345b, 0xff9f0e53, 0xffa2024c, 0xff9c004a, 0xff980049, 0xff98024c, 0xff980148, 0xff970148, 0xff99014c, 0xff9a0b43, 0xffc1641e, 0xffdbb812, 0xfff0fa05, 0xffb8bc27, 0xff7f764f, 0xffa58f2a, 0xffd0b600, 0xffdecf00, 0xffe9f307, 0xff725061, 0xff8d1650, 0xff98054c, 0xff97014b, 0xff98004b, 0xff98024a, 0xff9a004b, 0xff97004f, 0xff9d0d48, 0xffae3b34, 0xffe3c409, 0xfff0ef01, 0xffeef804, 0xffd9e110, 0xff6d6d61, 0xff706a5e, 0xffb0961d, 0xffc6a606, 0xffceac02, 0xffe2d900, 0xffeff402, 0xffb2b62e, 0xff695e64, 0xff8b2555, 0xff940b4f, 0xff9a0048, 0xff970149, 0xff970550, 0xffa01453, 0xffd8a31f, 0xfff0e205, 0xffedf406, 0xffa0a63a, 0xff7b7d56, 0xff656762, 0xff8a7f41, 0xffb09919, 0xffc8a903, 0xffd7c002, 0xffe6e101, 0xfff2fd00, 0xffd7de12, 0xffa1a838, 0xff6e5a65, 0xff79415c, 0xff99094e, 0xff96024c, 0xff9a0049, 0xff9f194e, 0xffb45748, 0xffeee907, 0xfff6fb01, 0xfff5ff04, 0xffcbd01c, 0xff787957, 0xff67656a, 0xff787154, 0xffbda10f, 0xffcfaa03, 0xffcaaa01, 0xffd0b100, 0xffebe702, 0xfff4fa02, 0xffebf405, 0xff919447, 0xff706e5f, 0xff636768, 0xff656366, 0xff6f5463, 0xff8c1952, 0xff97064b, 0xff98014e, 0xff9a0c48, 0xffa52438, 0xffd9b614, 0xffedef05, 0xfff3fe04, 0xff939645, 0xff71735b, 0xffa59025, 0xffc3a40b, 0xffcea900, 0xffccab00, 0xffcea902, 0xffcdab03, 0xffdccc00, 0xffedea00, 0xffc0c722, 0xff705161, 0xff80345a, 0xff97054e, 0xff98004d, 0xffb13a36, 0xffca811b, 0xfff0f006, 0xff72715f, 0xff8b7c43, 0xffc5a707, 0xffcdad00, 0xffd3bb00, 0xfff1fc02, 0xffdae211, 0xff7a7a54, 0xff676a63, 0xff6a5d64, 0xff77475f, 0xff940f50, 0xff97034d, 0xff970048, 0xff9b0149, 0xff9f144d, 0xffb74b3e, 0xfff0e308, 0xfff5f902, 0xffd7e10f, 0xff86874b, 0xff6e6c5d, 0xff726d5a, 0xffb1981a, 0xffc7a706, 0xffcdad02, 0xffe7dd00, 0xfff1f500, 0xfff4ff05, 0xffeff704, 0xff9ea03d, 0xff74765e, 0xff686465, 0xff7a4360, 0xff8c2054, 0xff9a024d, 0xff99034d, 0xff96004c, 0xff96064c, 0xffb25745, 0xffd8ae24, 0xffd2da13, 0xffa8ac33, 0xff6a6c61, 0xff797353, 0xff9c8c2d, 0xffc9aa02, 0xffcda801, 0xffd0b101, 0xffd8c600, 0xfff3f901, 0xffc2ca1d, 0xff6d6e5e, 0xff6f5562, 0xff793c5b, 0xffa5273d, 0xffb46135, 0xfff1ee09, 0xffc9d11b, 0xff787959, 0xff6b6861, 0xff81784d, 0xffc3a708, 0xffebea04, 0xff868a4f, 0xff6d6864, 0xff813458, 0xff911553, 0xff9e0c4a, 0xffc78018, 0xffdbc412, 0xff979a3f, 0xff686b64, 0xff696564, 0xff8c7d42, 0xffaf9719, 0xffc9a900, 0xffd6b903, 0xffe1d600, 0xffd2d115, 0xffa67441, 0xff98044e, 0xff95014b, 0xffb44a3d, 0xffd8a21c, 0xfff4fa04, 0xffe3ec09, 0xffc3c621, 0xff676966, 0xff716f5a, 0xff90813c, 0xffc5a804, 0xffd5bc00, 0xfff2f301, 0xffeced09, 0xffd4ae1b, 0xff9e0d48, 0xff97004d, 0xff96044d, 0xff991851, 0xffd6ab21, 0xffefe806, 0xffb7bd27, 0xff9e8b2d, 0xffbea30c, 0xffd8c700, 0xffe9e402, 0xffc3761e, 0xffa22341, 0xff96034a, 0xff9c0844, 0xffb06136, 0xffd3b81f, 0xffd2d816, 0xffa1a836, 0xffa89320, 0xffcaac00, 0xffcaa800, 0xffcfb200, 0xffdcc900, 0xffdec010, 0xffb45f36, 0xff97034f, 0xff9a0a47, 0xffab2e36, 0xffdbc00f, 0xffedf106, 0xffa0a33c, 0xff7a7c57, 0xff6e6c5f, 0xffb1971c, 0xffc8a704, 0xffe0d200, 0xffedf000, 0xffeeed09, 0xffb34c3d, 0xffa3214d, 0xffd89e20, 0xffebdc05, 0xffc5cc1e, 0xff67666b, 0xff90823b, 0xffb49c18, 0xffe4d901, 0xffd6a421, 0xffc37d38, 0xfff0e702, 0xffe6f006, 0xff7a754f, 0xffc1a20c, 0xffcfb000, 0xffeae301, 0xffeff902, 0xffb4b929, 0xff898b4c, 0xff6b6863, 0xffaa9323, 0xffcfaa04, 0xffccac00, 0xffdbc802, 0xffe9e601, 0xffedf605, 0xffd6e010, 0xff85864d, 0xff6c6c60, 0xff6d6b5c, 0xff8a7f3f, 0xffc7a609, 0xffd1b700, 0xffeeef00, 0xffa0a33a, 0xff797b56, 0xff726d59, 0xffb89c15, 0xffc9aa04, 0xffe2d700, 0xfff1f200, 0xffeaf505, 0xffc7d01b, 0xff696a65, 0xff7f764d, 0xffa58f22, 0xffd8c401, 0xfff3f700, 0xff909344, 0xff6c6a5e, 0xff867b45, 0xffc7a505, 0xffeae601, 0xfff1fa00, 0xffc1c622, 0xff6e6f5d, 0xff8d7f42, 0xffaf971b, 0xffd3b602, 0xffded200, 0xffd6dd15, 0xff6f6e5a, 0xff92843d, 0xffc7a802, 0xffcaab02, 0xffcaae04, 0xffd3b900, 0xffeff000, 0xffcfd916, 0xffa3a738, 0xff6a6e60, 0xff696864, 0xff7b7551, 0xff7e7651, 0xff7e774d, 0xff7d764c, 0xff887c42, 0xff9d8930, 0xffa69126, 0xffab951e, 0xffae991a, 0xffbcb11b, 0xffb7b725, 0xff767757, 0xff676964, 0xff6f6c5b, 0xff746f59, 0xff787355, 0xff797351, 0xff7d754e, 0xff827b4f, 0xff7e7c55]
				); 
        }
		public function box8():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,0,6,0,0,0,7,8,9,0,10,0,11,0,7,7,7,6,7,7,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,12,6,0,7,0,0,0,1,0,0,13,0,14,0,6,6,15,16,0,6,17,7,7,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,8,0,18,6,0,0,0,0,0,0,6,6,0,18,8,0,6,15,7,7,6,10,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7,0,19,20,21,22,23,24,25,23,26,27,28,29,30,29,31,32,33,34,35,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,36,37,38,39,40,41,42,43,44,45,46,47,48,48,49,50,51,52,53,54,55,0,4,7,7,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,57,7,11,17,18,58,4,57,8,17,59,60,61,62,63,64,65,65,64,66,67,65,68,69,70,71,72,73,74,75,76,77,4,7,7,8,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,6,4,78,79,0,7,8,80,81,82,42,66,83,69,65,69,69,84,64,66,65,85,86,87,88,89,90,91,74,92,93,94,6,95,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,8,11,0,0,6,7,97,98,99,100,66,84,69,101,66,69,64,102,69,69,103,104,105,106,91,107,108,74,74,107,74,109,110,111,0,112,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,78,6,0,95,0,113,114,115,116,117,84,66,65,83,118,119,65,69,120,84,121,122,123,124,74,125,74,124,91,126,74,74,124,127,128,10,12,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,18,8,129,130,131,132,117,133,63,63,101,119,119,84,134,135,103,136,105,137,107,126,74,108,107,108,74,138,124,74,91,74,139,140,7,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,8,129,141,142,62,143,66,69,63,69,67,144,102,66,84,145,146,105,126,124,74,124,108,74,91,91,91,91,91,74,126,108,147,148,149,150,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,8,7,4,12,36,6,151,12,0,6,152,153,154,155,156,157,64,102,63,69,69,67,84,66,158,159,160,161,91,162,163,164,107,75,74,91,165,166,167,168,169,138,170,74,90,171,172,7,0,10,0,7,0,0,0,0,0,0,0], 
    [0,0,0,0,0,112,10,7,7,11,8,57,58,4,173,174,175,176,119,69,69,101,63,66,69,69,84,84,177,178,179,180,74,124,108,124,108,74,124,108,181,182,183,184,185,186,74,91,74,187,188,189,190,0,0,6,7,6,0,0,0,0,0,0], 
    [0,0,0,0,0,11,7,6,0,10,1,149,191,192,193,194,101,119,83,66,63,64,84,101,119,195,196,179,197,108,91,125,126,125,108,91,125,107,198,199,200,201,202,203,204,205,206,74,124,125,74,207,34,6,7,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,8,11,78,208,209,210,211,212,101,67,213,214,215,66,67,63,63,118,216,217,89,108,126,91,124,124,138,89,218,169,219,220,221,222,223,224,225,226,227,228,108,124,91,74,229,230,15,6,7,0,0,6,0,0,0,0,0], 
    [0,0,0,0,0,150,4,11,231,232,233,234,63,63,69,144,213,65,213,69,65,235,236,237,238,74,74,125,124,91,125,74,239,91,165,240,241,242,243,244,245,246,247,247,224,248,249,108,107,74,125,89,250,251,208,7,0,0,0,0,0,0,0,0], 
    [12,7,57,95,2,7,10,252,98,253,254,69,84,83,83,213,69,66,255,102,256,257,258,89,108,74,108,108,107,124,74,107,74,259,260,261,262,263,263,263,263,263,263,226,264,265,266,267,108,268,74,107,269,270,173,6,0,8,0,0,0,0,0,0], 
    [6,0,1,3,149,271,272,273,274,275,69,65,83,63,84,65,65,256,276,277,238,187,126,125,74,108,91,124,91,108,163,278,279,280,281,264,282,263,263,263,263,263,263,245,283,282,284,285,286,108,91,91,124,287,288,78,0,15,0,0,0,0,0,0], 
    [57,0,5,289,290,291,132,292,65,67,63,69,144,69,65,84,135,293,294,295,125,170,74,162,124,108,74,108,124,296,297,298,299,300,301,302,303,263,263,263,263,263,263,304,282,247,305,306,307,268,90,74,108,308,309,78,0,0,310,0,0,0,0,0], 
    [5,311,312,313,234,255,213,66,255,63,64,101,83,314,276,315,316,125,126,74,124,126,126,124,108,74,74,317,318,319,320,321,14,322,323,324,282,263,263,263,263,263,263,225,325,326,327,328,329,108,330,187,126,163,331,332,11,7,0,0,0,0,0,0], 
    [333,334,335,255,68,64,63,336,337,67,65,69,213,338,339,295,91,108,108,91,126,107,125,74,89,74,340,341,342,343,0,0,2,344,345,245,247,263,263,263,263,263,263,346,245,347,202,348,349,350,125,351,125,90,352,353,18,0,354,0,0,0,0,0], 
    [355,356,357,358,359,360,361,362,363,364,365,366,367,169,218,108,74,91,124,74,74,74,187,368,369,370,371,372,15,7,0,7,321,373,374,324,375,263,263,263,263,263,263,263,263,263,263,263,376,377,124,187,74,74,108,378,379,1,6,0,0,0,0,0], 
    [380,381,382,383,384,385,386,387,388,389,390,73,90,126,107,124,126,162,74,124,368,124,124,391,392,393,394,2,6,310,0,7,0,395,396,397,245,263,263,263,263,263,263,263,263,263,263,263,398,399,400,91,218,108,162,401,402,6,0,0,0,0,0,0], 
    [403,404,405,406,407,408,409,408,409,410,411,124,124,350,74,74,74,91,126,180,412,413,414,415,112,57,7,7,0,6,6,0,0,7,416,417,263,263,263,263,263,263,263,263,263,263,263,263,264,418,419,124,124,350,108,92,420,421,6,0,0,0,0,0], 
    [6,422,423,424,424,408,406,424,409,425,426,427,126,74,124,108,125,428,107,429,430,431,432,10,433,95,4,0,0,10,7,0,57,0,0,434,435,263,263,263,263,263,263,263,263,263,263,263,224,436,437,438,108,162,74,124,439,440,6,0,0,0,0,0], 
    [8,441,442,443,424,444,445,446,409,409,409,447,448,428,108,125,449,74,450,451,452,0,7,0,4,10,8,0,0,6,6,57,0,57,4,453,454,263,263,263,263,263,263,263,263,263,263,263,324,247,455,456,169,74,108,74,91,457,458,0,0,0,0,0], 
    [95,208,459,460,409,408,409,409,409,461,462,463,464,465,125,108,239,169,466,467,7,6,0,7,10,10,0,0,0,7,0,0,4,8,0,468,469,263,263,263,263,263,263,263,263,263,263,263,303,224,470,471,448,74,124,107,125,472,473,0,0,0,0,0], 
    [18,0,474,475,476,425,477,406,409,478,409,479,480,74,74,74,74,74,91,481,482,78,4,6,2,0,17,0,0,0,0,0,0,7,0,7,483,484,247,247,263,324,485,263,263,263,263,263,302,224,247,486,487,449,124,169,108,488,392,57,36,0,0,0], 
    [8,7,7,489,490,409,491,492,409,406,409,493,494,495,74,170,89,74,91,496,497,10,7,4,95,0,7,0,0,0,0,0,8,0,78,8,498,499,500,485,485,263,485,263,263,263,263,263,246,263,263,501,502,218,162,74,125,330,503,504,4,7,0,7], 
    [6,112,8,505,506,478,445,425,478,409,424,491,493,507,330,74,91,162,74,412,508,509,8,6,4,7,0,0,0,0,0,0,151,10,0,18,78,510,511,263,282,485,304,263,263,263,263,263,512,283,282,513,514,515,91,74,124,516,517,518,519,354,10,10], 
    [8,112,0,208,520,521,409,409,409,425,408,522,408,523,186,74,187,74,74,162,524,525,13,11,8,12,0,0,0,0,0,0,433,7,7,0,6,526,527,263,247,485,282,263,263,263,263,263,375,304,224,263,528,529,218,125,107,75,74,530,531,11,17,0], 
    [78,18,8,10,532,533,534,446,424,409,409,446,409,535,536,90,75,74,125,268,218,537,393,12,58,7,8,0,0,0,0,0,10,538,6,0,6,11,539,540,247,225,263,263,263,263,263,263,263,541,542,324,223,543,544,91,89,91,107,545,546,433,0,6], 
    [7,0,7,6,547,442,548,424,549,406,550,408,551,552,553,124,74,74,108,107,108,554,555,0,4,8,151,0,0,0,0,0,6,112,0,0,4,4,556,557,558,282,485,263,263,375,263,282,559,264,247,263,224,560,561,239,124,74,268,562,563,1,3,0], 
    [0,0,7,6,6,564,565,446,409,461,462,446,462,409,493,566,180,108,74,91,124,567,568,569,0,6,0,0,0,0,0,0,8,0,0,0,0,570,7,571,572,573,283,283,247,263,485,485,263,245,485,263,375,574,575,576,89,108,91,74,577,578,403,15], 
    [0,0,0,0,6,403,579,580,408,406,478,406,406,409,445,581,137,107,350,125,124,163,582,583,7,10,0,0,0,0,0,0,4,0,0,0,78,6,584,585,586,587,588,589,590,247,247,324,263,263,263,247,247,283,591,592,108,124,74,74,162,593,594,17], 
    [0,0,6,7,7,2,113,595,405,424,408,425,406,478,409,596,597,91,74,218,74,91,124,598,599,57,57,0,0,0,0,0,78,8,4,600,601,602,603,604,605,604,606,607,608,609,610,611,612,613,614,283,283,263,263,615,616,125,124,187,125,617,618,619], 
    [0,0,0,0,0,0,3,620,621,424,462,425,424,478,446,622,623,124,108,125,74,108,125,624,625,0,0,0,0,0,0,0,619,0,57,626,627,628,629,630,631,604,632,631,631,605,633,634,635,636,637,638,639,640,263,641,642,643,108,108,108,644,645,433], 
    [0,0,0,0,0,7,0,646,647,491,424,446,406,425,408,409,648,649,125,138,74,124,169,650,651,519,13,8,4,4,7,0,14,652,653,654,655,632,632,632,632,632,632,632,655,632,631,655,631,656,604,657,658,659,660,661,662,663,124,124,268,218,664,379], 
    [0,0,0,0,0,58,0,665,666,476,406,477,409,409,408,478,409,667,427,108,74,124,449,91,668,669,0,12,95,6,8,670,671,672,673,631,674,632,632,632,632,632,632,632,674,631,632,675,632,676,677,655,655,678,679,680,681,162,74,449,126,124,448,682], 
    [0,0,0,0,0,0,12,8,149,683,684,406,408,478,409,406,446,685,686,107,107,124,91,124,124,687,688,689,690,691,692,693,694,604,655,632,695,632,632,632,632,632,632,696,632,697,655,698,629,605,699,700,701,702,703,108,170,108,74,89,74,125,74,704], 
    [0,0,0,0,0,6,17,18,2,506,705,445,478,409,444,408,462,706,707,107,91,74,107,108,108,708,518,709,710,711,712,713,631,714,631,655,715,632,632,632,632,632,632,632,631,655,697,631,694,675,716,717,718,719,75,107,125,74,91,124,90,125,163,720], 
    [0,0,0,0,0,7,57,7,547,721,442,408,722,491,723,424,406,724,725,726,74,74,74,124,108,412,727,728,729,655,730,605,715,632,675,655,631,632,632,632,632,632,632,631,676,631,675,731,732,733,734,735,108,125,239,138,350,124,108,124,269,736,737,738], 
    [0,0,0,0,0,78,4,8,8,532,739,534,409,424,461,409,406,424,550,740,163,125,125,91,91,124,741,742,674,632,674,743,744,675,632,632,632,632,632,632,632,632,632,632,697,714,745,746,747,748,186,74,108,351,91,108,107,125,124,749,750,751,752,498], 
    [0,0,0,0,0,0,6,7,0,8,665,753,754,522,409,408,522,406,522,755,507,108,74,125,124,350,162,756,757,758,759,657,632,632,632,632,632,760,677,605,674,632,632,631,761,762,763,764,765,170,350,125,125,126,125,74,124,766,767,768,452,4,7,4], 
    [0,0,0,0,0,0,6,7,0,6,57,769,770,409,424,408,408,406,492,535,771,108,91,125,124,74,125,772,773,632,696,676,632,632,632,632,632,675,675,774,775,776,697,777,778,779,780,138,126,125,169,124,124,125,91,781,782,783,784,11,6,12,0,57], 
    [0,0,0,0,0,0,0,6,0,7,10,564,785,443,462,406,522,406,408,406,786,787,125,108,74,74,125,788,772,743,674,632,632,632,632,632,632,655,789,714,674,790,791,792,793,124,138,239,108,125,125,108,108,794,795,796,797,0,17,6,57,95,57,0], 
    [0,0,0,0,0,0,0,6,6,7,7,403,579,405,462,408,406,446,406,445,798,799,163,89,126,74,74,180,800,801,743,604,632,632,632,632,632,632,743,802,803,804,805,806,807,138,808,91,124,107,124,138,809,810,811,812,0,7,15,813,0,2,10,57], 
    [0,0,0,0,0,6,0,7,0,6,0,78,814,815,460,816,424,408,424,408,424,817,818,74,108,108,819,107,107,820,757,775,632,632,632,632,632,676,821,822,823,89,108,187,74,108,107,138,91,824,644,825,826,111,0,95,7,0,0,12,79,6,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,7,8,827,828,408,477,406,409,492,408,829,830,124,90,91,108,124,108,831,773,655,676,631,632,606,629,832,833,834,835,108,125,107,91,74,90,91,330,503,836,440,372,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,4,10,564,620,406,491,409,406,409,478,551,837,838,107,74,91,107,124,839,840,604,674,699,775,841,842,843,89,138,138,286,90,74,91,138,109,844,845,846,208,6,8,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,4,0,149,847,848,425,424,424,409,409,409,849,649,368,108,91,74,350,107,850,851,655,852,853,854,855,663,330,75,124,126,108,74,107,856,857,858,859,7,0,433,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,433,4,0,208,860,580,445,408,406,444,522,409,861,862,91,74,125,74,108,124,863,864,865,866,125,74,867,350,91,126,74,108,318,868,869,870,7,7,11,57,36,79,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,57,0,8,0,871,872,444,406,406,722,408,446,873,686,91,74,90,74,138,350,874,875,427,138,643,91,124,124,90,218,876,877,878,879,17,6,6,4,6,6,17,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,57,7,111,880,881,381,424,446,409,408,882,685,495,108,187,125,74,124,91,108,108,90,91,91,91,126,883,884,555,885,17,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,886,887,888,446,406,408,406,445,889,464,124,74,124,74,124,187,218,74,162,90,91,188,890,891,892,893,433,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,57,149,0,894,895,896,848,461,424,724,897,898,74,74,74,91,74,108,91,125,899,524,900,901,902,17,7,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,903,6,15,904,905,906,476,409,424,907,908,74,108,74,108,124,125,138,188,909,910,911,403,6,0,7,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,95,150,8,912,913,914,915,493,916,267,124,125,124,807,917,918,845,190,10,0,6,17,208,8,354,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,547,8,12,112,15,919,920,921,405,922,923,108,187,90,524,857,924,925,7,6,0,1,0,151,0,310,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,12,8,403,926,927,928,898,929,930,531,931,0,17,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,932,6,7,933,934,935,936,457,937,17,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,938,0,36,0,150,931,939,321,4,0,6,0,0,6,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,4,6,18,4,7,36,1,78,13,4,0,6,6,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,10,0,1,8,6,12,18,2,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff676769, 0xff656567, 0xff666865, 0xff656766, 0xff696564, 0xff666668, 0xff666664, 0xff676566, 0xff696468, 0xff676767, 0xff676664, 0xff656764, 0xff666769, 0xff686465, 0xff66656a, 0xff626667, 0xff676765, 0xff676568, 0xff6b685f, 0xff8c7f4a, 0xffa2883b, 0xffa58c3a, 0xffa58a39, 0xffa68b3a, 0xffa48b39, 0xffa58c38, 0xffb4942d, 0xffbf9c28, 0xffc3a022, 0xffc19f21, 0xffc29e24, 0xffc2a722, 0xffbeb220, 0xff8c8f48, 0xff6f6c63, 0xff646665, 0xff766f5c, 0xff927f45, 0xffdbae13, 0xffe7b70f, 0xffebb80d, 0xffeab70c, 0xffebb80f, 0xffe9b90d, 0xffeab70e, 0xffe8b80e, 0xffefbc09, 0xfff4be06, 0xfff5bf05, 0xfff4c104, 0xfff3c706, 0xfff1df03, 0xffeeec03, 0xffbabf25, 0xff7b7e53, 0xff666563, 0xff656565, 0xff686669, 0xff86794d, 0xffa88e37, 0xffedba09, 0xfffbc201, 0xffffc702, 0xffffc600, 0xffffc501, 0xfffec600, 0xfffec502, 0xfffcc700, 0xfffec601, 0xffffcc01, 0xfffdd503, 0xfff8f200, 0xfff4fa02, 0xfff5ff00, 0xfff7ff00, 0xffe8f208, 0xffb0b729, 0xff656668, 0xff646663, 0xff6d6b5f, 0xff847850, 0xffcba71d, 0xffffc602, 0xffffc700, 0xfffdc703, 0xfffccb02, 0xfff9e200, 0xfff5f001, 0xfff6fd00, 0xfff5fe03, 0xfff4ff00, 0xfff0fa05, 0xffced718, 0xff6b6a66, 0xff656563, 0xff636862, 0xff7c7354, 0xff988342, 0xffe3b311, 0xfff7c204, 0xffffc603, 0xffffc500, 0xfffccc00, 0xfffad502, 0xfff6ef01, 0xfff4f900, 0xfff3fe00, 0xfff5ff01, 0xfff1fa03, 0xff888a4b, 0xff686964, 0xff666867, 0xff696866, 0xff777056, 0xffbc9b28, 0xffdcb013, 0xfffdc401, 0xfffec803, 0xffffc502, 0xfffec400, 0xfffcce00, 0xfffae101, 0xfff7ed02, 0xfff4fe00, 0xfff4ff01, 0xfff3ff00, 0xffa4ac33, 0xff71735b, 0xff706c60, 0xff8a794b, 0xffd4ab1d, 0xffedb90b, 0xffffc505, 0xffffc301, 0xfffec901, 0xfffbd300, 0xfff4f801, 0xfff7fe00, 0xffdde60f, 0xff9f9f3b, 0xffaa8f34, 0xffd0a61c, 0xfffbc500, 0xfffdc702, 0xfffecb00, 0xfffae204, 0xffedf605, 0xffc2ca1f, 0xff686763, 0xff686667, 0xff646567, 0xff6d6a63, 0xff7d7457, 0xffc7a220, 0xffe6b510, 0xfffec401, 0xffffc404, 0xffffc904, 0xfffed104, 0xfff8ef00, 0xfff6f600, 0xfff4fd02, 0xfff3fd00, 0xfff8ff02, 0xfff4f501, 0xfff1d706, 0xffd8733d, 0xffe28d20, 0xfff7fe01, 0xfff6ff02, 0xffedf607, 0xff7d7e54, 0xff696863, 0xff958247, 0xffbd9c28, 0xfff6c103, 0xfffec900, 0xfff9df02, 0xfff8ec00, 0xfff6fd02, 0xfff7f902, 0xffebb612, 0xffe86328, 0xffe51762, 0xffe73d48, 0xfff1f500, 0xfff4ff03, 0xfff3fc01, 0xff95983f, 0xff6c6c60, 0xff706d5c, 0xffb19430, 0xffd5ab17, 0xfffdc202, 0xfffbcb00, 0xfffcd202, 0xfff7f700, 0xfff6f20a, 0xffec8e2c, 0xffeb4859, 0xffef0868, 0xfff2006f, 0xffee006b, 0xffeb0367, 0xfff0b914, 0xfff3f800, 0xffd2dd15, 0xff676863, 0xff87784d, 0xffa88d32, 0xffeeba0e, 0xfffac100, 0xfffdc800, 0xffffc803, 0xfffdc500, 0xfff9e000, 0xfff8ec02, 0xfff3fe02, 0xffeed61e, 0xffe9a832, 0xffe72667, 0xffee0a6c, 0xffee0169, 0xffee016b, 0xffee016d, 0xffef0170, 0xffec7c2a, 0xfff0e108, 0xffe5ee09, 0xffadb52c, 0xff6e6a5e, 0xff9f883c, 0xffc8a31e, 0xfff8c104, 0xfffecb02, 0xfffcd000, 0xfffcec01, 0xfff8f601, 0xfff3ff01, 0xffe9ae24, 0xffdc644b, 0xffe8116c, 0xffec0370, 0xffef0066, 0xfff2006e, 0xffef026a, 0xfff0006b, 0xffee1f63, 0xfff08b2f, 0xffe2e90f, 0xff70745d, 0xff7c7356, 0xffe4b511, 0xfff6c006, 0xfffcc601, 0xffffca00, 0xfff9dd00, 0xfffcec00, 0xfff2e206, 0xffedb313, 0xffe5314c, 0xffe41367, 0xfff0006d, 0xfff00169, 0xffee076f, 0xffee4758, 0xfff6fb00, 0xfff7fe03, 0xfff0f902, 0xff85864d, 0xff8b7a4c, 0xffb29531, 0xfff0bc08, 0xfffdc403, 0xffffc402, 0xfffed000, 0xfffcea04, 0xffe6eb0a, 0xffdfb92a, 0xffef1961, 0xffed0666, 0xfff2016c, 0xfff1006b, 0xffe70f72, 0xfff0d41b, 0xfff6fe00, 0xffc4cc1e, 0xff828250, 0xff716f5a, 0xff89784c, 0xffd5a61c, 0xffffc300, 0xfffbdd01, 0xfffdeb03, 0xfff5fc00, 0xfff1fc00, 0xffe5f107, 0xffadaf30, 0xff9c764f, 0xffea056c, 0xffed006e, 0xffef026e, 0xfff2006b, 0xffef026c, 0xffee0271, 0xffeaa830, 0xfff0f209, 0xffdce50e, 0xff9ca13d, 0xff666762, 0xff817754, 0xffa1863f, 0xffebb70c, 0xffffc801, 0xfffceb05, 0xfff7f500, 0xffedf703, 0xffdce60c, 0xff989744, 0xff7c7a54, 0xff636766, 0xffc61c65, 0xffea036b, 0xfff1016c, 0xfff2006d, 0xfff1026a, 0xffee0267, 0xffe73164, 0xffe9a92e, 0xfff2fd00, 0xffd8e212, 0xff6f6d60, 0xff7d785a, 0xffc4a31e, 0xffe8b410, 0xffffc401, 0xffffc503, 0xfffbd800, 0xfffae802, 0xffeef804, 0xffc5cd1f, 0xff9ba03c, 0xff6e6e62, 0xffa13768, 0xffdd0e69, 0xfff10069, 0xffef006a, 0xffe60f6c, 0xffd66052, 0xfff6ff01, 0xfff7fd00, 0xffebf405, 0xff7c7d55, 0xff666467, 0xff9c9231, 0xffd5b500, 0xffdabb00, 0xffdece00, 0xffe1d203, 0xfff0ca00, 0xfff3c301, 0xfff6c801, 0xfff7cc03, 0xfffece00, 0xfffccf02, 0xfffce800, 0xfff9f203, 0xfff2fd01, 0xffeaf306, 0xffafb72d, 0xff888d4b, 0xff696a62, 0xff765a68, 0xffaa3167, 0xfff1016e, 0xffe41366, 0xffeada15, 0xffb2b62e, 0xff747758, 0xff82774a, 0xffcaa904, 0xffceac04, 0xffceb600, 0xffd1b702, 0xffd4b401, 0xffd8b501, 0xffddca01, 0xffe2d201, 0xffefd800, 0xfff7e500, 0xffd8df15, 0xffbcc224, 0xff787758, 0xff696b60, 0xff696365, 0xff894a69, 0xffed026b, 0xffeb046c, 0xffe9ac1d, 0xfff5f406, 0xffcdd619, 0xff8a8c4b, 0xff696864, 0xffad971d, 0xffc9a803, 0xffccaa02, 0xffcda800, 0xffcbab02, 0xffccaa00, 0xffcfaf02, 0xffdccb01, 0xfff2fb04, 0xffc5cc1c, 0xffa0a03c, 0xff6d6e60, 0xff6c6366, 0xffd2146a, 0xffe63154, 0xffebb016, 0xffccd21a, 0xff686963, 0xff978634, 0xffc1a20c, 0xffcbab00, 0xffccab00, 0xffd6ba01, 0xfff4fb00, 0xfff5ff02, 0xffe6ed0b, 0xffccd51a, 0xff84874e, 0xff707163, 0xff666465, 0xffb62767, 0xffe30769, 0xffeb115b, 0xffe5642a, 0xfff8fd03, 0xffe1e90a, 0xff72745e, 0xff6f6c5b, 0xff958635, 0xffcaa902, 0xffcea900, 0xffcea902, 0xffcba901, 0xffe7e401, 0xfff2fb00, 0xfff6ff00, 0xffe2e910, 0xff7b7c52, 0xff6a6a62, 0xff785666, 0xffb72868, 0xffeb115d, 0xffefd909, 0xff9e9e3c, 0xff6e705b, 0xff7f7551, 0xffcaa701, 0xffcca903, 0xffcaaa01, 0xffe1d100, 0xfff2f300, 0xfff3ff05, 0xffe8f009, 0xff76795a, 0xff6f6067, 0xff954069, 0xffef0371, 0xfff2be1a, 0xffc3c91f, 0xff7d8051, 0xff68685e, 0xffaf971b, 0xffc9a805, 0xffcbaa00, 0xffcba900, 0xffd1b400, 0xffdfd100, 0xffb0b72b, 0xff777858, 0xff6e5f66, 0xffd70f68, 0xfff1006d, 0xffeb4958, 0xfff1c51a, 0xffeaf505, 0xff968535, 0xffc0a10b, 0xffcaaa00, 0xffcbaa03, 0xffcdad00, 0xffd5bd01, 0xfff2fc00, 0xffd0d516, 0xff8b8e49, 0xff696566, 0xffc31f66, 0xffea0369, 0xffed2063, 0xffe99231, 0xffd6dd11, 0xff6c6c62, 0xff6e6d5b, 0xff968533, 0xffebe901, 0xffd1d818, 0xff6a6b63, 0xff844e66, 0xffc81d69, 0xfff00070, 0xffee0270, 0xffe62f65, 0xfff0f20b, 0xfff8fe00, 0xfff1fb04, 0xff8c8d47, 0xff6a6c61, 0xff81754d, 0xffc8a901, 0xffccac03, 0xffe3d500, 0xffe6ef08, 0xff727958, 0xff715d68, 0xffa13767, 0xffeb106e, 0xffebd51f, 0xffadb42a, 0xff767755, 0xff686765, 0xffb29619, 0xffc6a903, 0xffd2b502, 0xffe1d602, 0xffb2b42f, 0xff65666a, 0xff775965, 0xffe00a6a, 0xfff0006c, 0xfff2026d, 0xffdb615c, 0xffebd819, 0xffe0eb09, 0xffa3aa36, 0xff676662, 0xffc0a20e, 0xffcaab03, 0xffccac00, 0xffcdab03, 0xffcdad02, 0xffd8c401, 0xffd4d718, 0xff8b8e47, 0xff6b6267, 0xffca1967, 0xffed0269, 0xfff10170, 0xffe3325e, 0xffeaaf27, 0xffedf901, 0xffc7d01d, 0xff6f6b5f, 0xff948836, 0xffeeec01, 0xfff0fa03, 0xffcfd617, 0xff686b64, 0xff646867, 0xff894665, 0xffcc1263, 0xffe90069, 0xffea036d, 0xffe23455, 0xfff1f407, 0xffecf703, 0xff828151, 0xff7e774d, 0xffc9a801, 0xffe5da02, 0xffe7ec09, 0xff75785d, 0xff656366, 0xff853a5b, 0xffad1055, 0xffd2015f, 0xffdc0062, 0xffe50067, 0xffeb0069, 0xffe81367, 0xffecdb19, 0xff9b9d3c, 0xff706e5f, 0xffb0961d, 0xffd5b802, 0xffe8e001, 0xffb1b52d, 0xff76765a, 0xff686367, 0xff6c5d64, 0xff83335a, 0xff931753, 0xff98024c, 0xff99014a, 0xff9b004c, 0xffa1014b, 0xffa5004c, 0xffb00051, 0xffba0054, 0xffd1005c, 0xffdd0161, 0xffe40264, 0xffe80066, 0xffe66428, 0xffefda05, 0xffd7de12, 0xff929641, 0xff67656a, 0xff968537, 0xffbfa10d, 0xffceb002, 0xffdecb02, 0xffcfd616, 0xff8d8c49, 0xff744f61, 0xff7f395d, 0xff930c4e, 0xff96024c, 0xff9b014a, 0xff980049, 0xff98004b, 0xff9b0149, 0xffa6014d, 0xffad0050, 0xffc00055, 0xffcb005a, 0xffdb0162, 0xffe20265, 0xffeb0067, 0xffe83248, 0xffedb017, 0xfff3ff03, 0xffe7f105, 0xffb6bc28, 0xff6f6e5c, 0xff948436, 0xffd1b003, 0xfff0f100, 0xfff0fc04, 0xffd0d717, 0xff79445e, 0xff852958, 0xff98064d, 0xff97014b, 0xff990048, 0xff9a0048, 0xff9e004a, 0xffa6004c, 0xffaa0152, 0xffc72d45, 0xffd07232, 0xfff5ff04, 0xffe6ef0a, 0xff686860, 0xff81754f, 0xffe8e301, 0xffe4f008, 0xff787759, 0xff6d5c66, 0xff774963, 0xff94144f, 0xff95084c, 0xff970149, 0xff9a004b, 0xff99014c, 0xff960048, 0xff9b054c, 0xffa01f45, 0xffd99d23, 0xffe9d30e, 0xff8a8d4a, 0xffaf9719, 0xffc8a805, 0xffd7be02, 0xffece501, 0xffb0b32e, 0xff767758, 0xff636768, 0xff686463, 0xff725162, 0xff7d3a5d, 0xff960a51, 0xff96034a, 0xff95014b, 0xff99014e, 0xff98004d, 0xff97004f, 0xff970148, 0xff9b0e52, 0xffa82c37, 0xffdcb115, 0xffede305, 0xffdee907, 0xffbda20b, 0xffd1b202, 0xffe0d102, 0xffced817, 0xff686168, 0xff705661, 0xff8b2354, 0xff930e4f, 0xff9a024b, 0xff9a0049, 0xff97004a, 0xff9c0749, 0xffad553f, 0xffd2a41d, 0xfff4f303, 0xffdce00f, 0xff716b5d, 0xffceaa00, 0xffcba802, 0xffccac01, 0xffd1b303, 0xfff3f402, 0xffd0cb17, 0xff8f1955, 0xff95084d, 0xff99004a, 0xff95034c, 0xff9b0f4e, 0xffc2641a, 0xffdfb20e, 0xfff1fa01, 0xffc8cf1f, 0xffa2a53c, 0xff6b6f60, 0xff7e754a, 0xffebe900, 0xffe0d710, 0xff9b124a, 0xff98024a, 0xff950249, 0xff980051, 0xffa42445, 0xffaf5b41, 0xffe8d606, 0xffe9f306, 0xffd0d61a, 0xff85894c, 0xff70725d, 0xffad971f, 0xffcaa705, 0xffd8c200, 0xffb45f36, 0xff9b1049, 0xff970048, 0xff97004e, 0xff950248, 0xff97034d, 0xffad303e, 0xffc2631f, 0xffeeeb08, 0xfff5fb03, 0xffdee911, 0xffc1c822, 0xff7e7c56, 0xff948738, 0xffc3a00e, 0xffe4d601, 0xffd7aa1d, 0xffa52f3f, 0xff9b004b, 0xff980148, 0xff96004a, 0xff9d0a50, 0xffa12942, 0xffd6a81f, 0xffebd505, 0xfff1fa00, 0xffe3ec07, 0xff9fa539, 0xff818552, 0xff968638, 0xffd2b501, 0xfff2f802, 0xfff2f204, 0xff990249, 0xff9d0e4e, 0xffad2f3b, 0xffe0b614, 0xfff0ee05, 0xffedf502, 0xffd9e112, 0xff8e9248, 0xff73755d, 0xffcead00, 0xffeded01, 0xffe5d50c, 0xff9d0f49, 0xff99024f, 0xff990c50, 0xffb45c36, 0xffd7aa1b, 0xfff4f503, 0xfff4ff05, 0xfff8fd01, 0xffeff904, 0xffc1c91c, 0xff98983e, 0xff6b6c64, 0xff656469, 0xff686762, 0xffb0961b, 0xffcdaa04, 0xffd9c600, 0xffecef02, 0xfff2ff00, 0xffb55d35, 0xff9e104c, 0xffc6761f, 0xffdfc115, 0xfff2fb02, 0xffa8ac34, 0xff86874b, 0xff948437, 0xffc0a30a, 0xffd2b801, 0xffe7df00, 0xffd4a91c, 0xffa62d40, 0xffb46137, 0xffeae005, 0xfff3f702, 0xffb6bb29, 0xffd2ba02, 0xfff3f901, 0xffeff404, 0xffd3a81d, 0xffb13e3b, 0xffc88421, 0xfff1ef06, 0xffc6cd1f, 0xff9c9e3b, 0xff6c6d5f, 0xff7f764f, 0xffc9aa04, 0xffd0b101, 0xffe3d60e, 0xff9d0e46, 0xff990f4d, 0xffa62c3b, 0xffdaaf13, 0xffefe50a, 0xffe9f106, 0xffcdd31b, 0xff83864d, 0xff6f715c, 0xffaf971d, 0xffe0d001, 0xfff0f401, 0xffb86c3a, 0xffb65243, 0xffdecc14, 0xfff1f008, 0xfff7fc00, 0xffbfc621, 0xff787a55, 0xff6a6b66, 0xff968736, 0xffbda20d, 0xffd6bd00, 0xffe7d710, 0xffe8cf10, 0xffeff902, 0xffe3ea10, 0xff9ea03b, 0xff7f8152, 0xff83784b, 0xffbda111, 0xffcfab00, 0xffecf504, 0xffd5de15, 0xff72745c, 0xff6c6964, 0xff918338, 0xffb0981a, 0xffd1b200, 0xffeff706, 0xffbcc220, 0xff939740, 0xff6c6c64, 0xff6b6863, 0xff908140, 0xffac971a, 0xffe3d400, 0xfff1f701, 0xfff3fc03, 0xffa6ab35, 0xff868654, 0xff676964, 0xff666561, 0xff6b6b5f, 0xff807849, 0xffb89d12, 0xffd6c203, 0xffeaea00, 0xffd3dc13, 0xffb0b62e, 0xff74745a, 0xff6a6b5b, 0xff7f784c, 0xffb59a17, 0xffc9a707, 0xffd8c100, 0xffeefa04, 0xffc3cb1d, 0xff696961, 0xff8b7c43, 0xffac961f, 0xffd3b603, 0xfff5f602, 0xff84884d, 0xff6f7062, 0xff897d41, 0xffaa9321, 0xffe1db01, 0xffdde311, 0xffbcc126, 0xff6a6964, 0xff666863, 0xff6d6960, 0xff7a7452, 0xffbbb41d, 0xffd5d711, 0xff7f7e52, 0xff65666b, 0xff6b6b63]
				); 
        }
		public function box9():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,0,0,3,2,4,4,5,0,6,7,8,8,9,10,11,12,13,14,15,16,17,18,19,20,8,3,8,3,21,2,3,22,9,0,0,0,0,0,0,23,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,9,9,0,0,0,25,26,27,8,23,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,8,2,0,46,23,26,0,5,0,0,0,0,8,23,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,22,22,22,9,0,48,49,22,50,51,52,53,54,55,56,57,39,58,37,59,59,60,61,62,63,64,42,65,66,67,0,68,6,9,69,47,0,8,8,0,0,8,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,70,71,72,73,74,75,76,58,59,58,36,77,78,39,79,39,80,77,58,80,39,58,36,79,81,82,83,84,85,86,8,6,8,0,9,0,8,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22,9,10,87,88,89,90,91,35,57,77,62,62,59,80,77,62,36,80,58,77,35,60,36,37,58,58,58,79,79,92,93,94,95,85,96,22,22,0,0,0,0,0,0,0,0,0], 
    [4,97,0,9,8,8,1,0,4,98,8,22,46,98,99,18,100,101,102,103,104,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,62,62,37,77,36,36,59,39,59,105,77,77,39,39,106,107,108,84,109,110,111,22,0,0,0,0,0], 
    [24,8,9,0,0,98,6,112,49,22,9,22,111,113,114,115,116,117,118,79,62,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,105,105,37,77,77,105,105,61,62,39,119,79,35,62,36,59,120,103,121,122,123,4,0,0,0,0,0], 
    [8,27,20,4,8,8,22,124,4,125,126,127,128,75,129,62,130,37,77,77,62,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,105,105,37,77,62,62,62,58,36,37,39,35,37,36,131,132,133,134,135,136,137,9,0,0,0,0,0], 
    [22,0,47,7,9,6,26,138,139,140,141,142,143,35,58,36,59,62,39,79,36,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,105,105,37,77,105,105,39,39,77,77,39,144,131,145,146,147,148,149,150,151,152,8,0,0,0,0,0], 
    [4,0,99,153,154,155,156,157,158,57,62,62,37,39,57,60,37,37,37,39,60,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,79,36,105,37,79,60,60,159,160,161,162,163,164,165,164,149,166,165,149,167,168,169,0,0,0,0,0], 
    [28,170,171,172,173,174,175,36,36,58,36,57,59,105,59,37,36,62,36,62,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,36,36,62,37,176,177,178,179,180,181,165,149,182,166,183,150,166,150,167,184,185,186,0,0,0,0,0], 
    [187,188,189,39,190,105,105,59,57,105,59,77,77,77,77,77,77,77,77,77,77,62,62,59,39,39,39,37,37,105,59,59,58,57,59,105,62,191,192,193,194,195,196,183,149,166,166,150,150,197,197,198,198,166,150,165,199,200,201,0,0,0,0,0], 
    [202,203,204,77,79,105,39,62,144,62,37,77,77,77,77,77,77,77,77,77,77,59,105,105,62,62,59,36,205,62,62,77,35,36,36,206,207,179,208,209,148,210,211,197,184,150,211,166,199,166,212,182,166,166,165,166,197,213,214,0,0,26,0,0], 
    [215,216,217,218,219,77,62,57,35,39,57,77,77,77,77,77,77,77,77,77,77,37,77,80,39,39,80,105,62,39,220,221,132,222,223,224,182,150,149,165,166,165,166,167,165,166,166,167,211,184,150,164,225,150,166,164,165,226,227,0,0,9,8,8], 
    [228,229,230,231,232,233,36,39,105,39,39,77,77,77,77,77,77,77,77,77,77,37,62,39,62,105,39,105,234,160,235,236,163,182,167,237,165,166,184,166,166,165,183,165,166,165,165,167,167,148,238,239,212,166,165,150,237,240,241,22,0,0,0,8], 
    [9,242,243,244,245,246,247,205,36,62,37,77,77,77,77,77,77,77,77,77,77,36,234,60,248,249,250,251,209,165,165,149,166,237,150,182,166,149,165,150,165,166,166,164,150,252,253,254,255,256,257,258,259,167,166,166,166,260,261,22,9,0,0,8], 
    [2,262,263,264,265,266,267,268,269,80,79,270,57,37,36,39,37,105,59,79,37,271,272,273,274,275,276,165,165,166,165,167,184,165,237,150,148,165,237,166,150,197,167,277,278,279,280,281,282,283,284,285,286,182,182,166,166,151,287,48,0,26,0,0], 
    [288,289,290,243,291,292,293,294,295,296,297,144,37,35,39,62,79,298,299,300,301,302,196,164,166,150,164,165,166,166,166,165,303,182,167,150,166,210,166,304,305,306,307,308,309,310,311,312,313,314,315,316,317,166,166,165,166,150,318,86,8,0,3,22], 
    [0,319,320,291,321,322,291,293,265,323,324,325,36,39,105,221,326,327,146,181,197,167,166,210,150,166,166,166,166,165,166,182,149,166,166,328,329,151,330,279,331,332,333,283,334,335,314,335,336,315,315,337,338,166,166,165,166,182,339,340,8,0,3,47], 
    [22,7,341,342,293,291,293,245,291,322,291,343,344,345,346,347,150,166,149,164,150,348,166,148,166,199,237,166,166,165,166,167,149,183,349,350,351,352,353,354,315,355,356,357,356,315,358,312,311,334,334,359,360,167,165,166,165,166,349,214,47,0,0,0], 
    [26,20,361,362,244,363,364,292,291,243,365,266,366,225,182,165,167,166,166,150,166,149,167,150,149,150,166,166,166,165,166,367,368,369,370,371,372,373,374,375,376,377,314,312,358,378,315,334,375,336,335,379,380,166,165,166,150,166,252,381,8,0,0,0], 
    [0,8,24,382,383,293,293,293,293,293,293,384,385,386,182,149,150,165,166,198,210,387,167,166,164,166,166,164,388,389,390,391,392,393,22,394,395,336,376,376,358,376,376,376,376,376,376,376,315,396,314,397,398,149,182,165,167,167,166,399,400,0,22,5], 
    [0,0,5,401,402,293,293,293,293,293,293,403,404,405,166,150,167,166,166,149,165,165,150,182,165,252,406,407,408,409,410,411,9,47,46,412,413,358,376,376,358,376,376,376,376,376,376,376,335,315,283,378,414,415,165,166,166,167,148,416,417,9,8,0], 
    [23,0,0,418,419,293,293,293,293,293,293,322,291,420,368,166,165,166,182,165,167,421,422,423,424,425,426,427,2,20,4,0,4,22,0,24,428,356,358,358,376,376,376,376,376,376,376,376,336,315,336,335,429,430,167,166,199,167,166,213,431,0,1,0], 
    [432,27,0,433,434,293,293,293,293,293,293,435,243,436,437,166,182,387,165,165,167,438,439,440,441,442,7,0,68,3,9,8,26,443,8,9,444,445,376,358,376,376,376,376,376,376,376,376,334,315,446,357,447,448,164,166,166,167,166,423,449,48,9,443], 
    [0,22,9,450,451,293,293,293,293,293,293,384,435,452,453,165,182,167,165,182,164,454,455,4,0,0,26,22,9,0,0,8,47,22,0,8,48,456,315,376,376,376,376,376,376,376,376,376,335,356,315,356,457,458,166,150,165,166,166,459,460,99,9,20], 
    [9,21,47,3,461,293,293,293,293,293,293,462,243,463,464,166,165,167,165,165,150,465,466,9,26,9,0,7,0,0,3,0,467,99,46,0,9,468,315,334,376,356,376,376,376,376,376,376,376,312,469,356,312,470,224,167,166,166,166,471,472,22,0,3], 
    [3,0,0,0,473,474,475,476,322,342,293,244,291,477,478,166,165,166,166,166,479,480,214,2,0,0,26,0,0,0,0,0,0,0,0,0,8,481,482,312,376,314,358,376,376,376,376,376,315,396,358,446,376,483,484,149,237,167,149,151,485,8,0,0], 
    [0,9,49,9,124,486,321,435,230,322,293,243,244,322,246,182,165,166,165,166,166,487,488,49,9,0,23,0,0,0,0,0,22,0,0,4,8,489,490,312,376,373,313,376,376,376,376,376,376,376,378,334,336,491,492,184,198,148,493,150,494,0,9,0], 
    [9,47,26,495,0,496,497,322,498,291,291,293,435,293,499,500,166,166,165,166,166,501,502,0,8,0,9,0,0,0,0,0,0,0,0,4,22,503,504,336,505,312,506,376,376,376,376,376,376,376,376,315,358,507,508,182,165,509,164,166,510,511,0,0], 
    [4,9,9,3,0,341,512,475,513,514,243,291,322,293,515,516,166,166,166,166,166,260,517,5,5,9,0,0,0,0,0,0,0,0,0,0,22,518,519,336,358,469,356,376,376,376,376,376,336,376,334,396,358,520,521,167,165,164,149,166,522,523,47,9], 
    [0,48,19,524,0,525,526,435,291,243,435,243,243,293,243,527,528,166,166,166,166,165,438,529,26,9,0,0,0,0,0,0,22,22,4,0,0,530,531,312,532,446,315,376,376,376,376,376,376,358,376,376,336,533,534,199,167,150,166,167,277,535,47,47], 
    [0,0,0,0,0,411,536,435,537,244,514,291,293,383,293,538,500,182,165,165,165,166,539,540,26,23,4,541,0,0,0,1,24,0,0,443,4,542,543,544,354,545,396,378,378,358,312,312,376,376,376,376,376,546,547,166,184,183,548,387,182,549,550,8], 
    [0,0,0,0,0,47,551,552,322,342,293,435,322,293,498,553,554,166,167,166,165,148,555,556,557,20,5,0,0,4,49,4,49,25,558,559,560,561,562,563,564,565,356,378,566,315,315,376,376,376,376,376,376,376,567,164,150,167,165,165,165,568,417,0], 
    [0,0,0,0,0,22,569,570,435,291,291,435,322,293,498,571,572,166,149,166,182,149,573,574,46,0,575,69,99,0,9,576,577,578,579,580,581,582,583,584,585,586,587,336,315,378,336,335,376,376,376,376,376,334,588,589,184,166,165,165,149,590,591,0], 
    [0,0,0,0,0,9,23,592,593,435,435,291,243,291,291,594,595,166,167,182,198,165,164,596,597,575,22,598,599,600,601,602,603,604,604,605,606,604,605,607,607,608,609,610,611,356,358,376,376,376,376,376,376,315,612,613,149,167,167,165,166,614,615,0], 
    [0,0,0,0,0,22,8,616,617,384,363,291,537,291,291,435,618,182,165,182,150,166,164,619,620,541,621,622,601,623,624,583,605,625,626,625,583,605,582,626,583,626,625,627,628,629,356,315,376,376,376,376,376,312,630,631,148,166,632,166,149,633,634,9], 
    [0,0,0,0,0,9,4,635,636,243,322,293,293,293,293,293,637,638,166,197,639,166,166,640,641,642,643,625,605,644,644,605,605,605,605,605,605,605,605,605,605,605,605,583,583,645,646,647,358,648,336,356,396,376,649,650,196,150,166,167,184,651,652,46], 
    [0,0,0,0,0,68,8,653,654,342,655,293,293,293,293,293,656,437,165,184,166,165,164,657,658,659,626,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,660,661,583,662,663,664,376,376,665,315,566,314,666,667,166,197,149,148,668,200,0], 
    [0,0,0,0,0,4,22,49,669,383,537,293,293,293,293,293,293,670,671,166,150,166,211,672,673,604,674,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,675,607,583,583,583,676,677,678,376,356,446,377,679,680,167,211,164,197,182,681,22], 
    [0,0,0,0,0,443,47,2,682,683,684,293,293,293,293,293,342,685,686,165,149,149,237,275,687,688,689,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,690,625,605,605,625,625,691,692,693,315,694,665,695,696,166,166,164,197,165,697,698], 
    [0,0,0,0,0,0,1,22,5,699,363,293,293,293,293,293,291,700,701,150,167,167,166,166,640,702,703,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,704,644,605,690,626,626,705,706,707,708,709,710,211,165,167,150,182,711,712], 
    [0,0,0,0,0,26,26,4,24,713,714,293,293,293,293,293,342,715,716,167,165,150,167,165,717,718,719,605,605,605,605,644,605,605,605,605,605,605,605,605,605,605,605,604,604,605,605,605,626,607,720,721,662,722,723,724,725,199,167,167,150,165,726,727], 
    [0,0,0,0,0,26,20,0,124,728,729,435,322,383,322,243,293,730,731,165,166,150,164,252,182,732,604,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,733,734,660,607,605,583,644,605,721,735,583,736,737,738,199,148,164,166,150,165,739], 
    [0,0,0,0,0,8,3,0,9,28,740,741,365,475,435,244,293,265,742,150,167,149,632,165,199,743,744,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,745,583,605,644,605,703,625,583,733,625,605,746,747,748,210,150,165,165,421,182,749], 
    [0,0,0,0,0,0,8,4,0,0,1,750,751,321,291,435,435,498,752,753,167,329,182,167,165,754,755,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,704,605,605,607,661,583,625,756,757,758,759,760,761,167,197,165,165,164,182,762], 
    [0,0,0,0,0,8,9,4,763,0,23,764,765,363,537,293,435,293,656,766,167,182,767,768,347,769,770,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,733,604,771,626,626,745,720,772,773,774,775,776,165,167,182,182,421,166,166,165,777], 
    [0,0,0,0,0,778,5,22,6,9,6,28,779,780,322,435,384,291,293,453,252,167,212,166,167,781,782,604,604,644,605,605,605,605,605,605,605,605,605,605,605,605,605,605,605,659,783,784,785,786,787,788,166,166,166,166,165,150,198,165,166,165,167,252], 
    [0,0,0,0,0,0,0,0,0,0,0,47,50,789,790,244,435,435,435,791,753,149,199,166,167,776,792,690,690,745,605,604,625,626,604,721,604,583,660,736,605,604,688,735,793,794,795,796,797,798,166,197,184,167,167,165,166,166,166,165,182,212,277,799], 
    [0,0,0,0,0,0,0,0,0,0,0,8,0,433,800,291,243,230,475,801,405,639,166,148,329,212,802,690,703,733,733,661,660,582,607,659,690,660,660,733,746,803,804,805,806,807,211,166,167,166,165,149,167,148,182,167,166,182,166,808,809,810,811,812], 
    [0,0,0,0,0,0,0,0,0,0,0,9,6,813,814,815,435,291,475,816,817,150,150,165,479,150,818,819,607,690,720,583,607,583,583,583,661,606,690,820,821,822,823,824,528,182,149,165,165,150,150,165,165,150,167,166,182,471,825,826,827,828,829,47], 
    [0,0,0,0,0,0,0,0,0,0,0,8,0,0,26,830,831,435,537,832,436,166,149,548,166,166,833,834,703,736,583,703,835,605,659,836,837,838,839,840,209,164,167,182,166,148,182,184,150,182,182,150,150,841,842,843,844,845,846,9,9,0,46,22], 
    [0,0,0,0,0,0,0,0,0,0,0,8,4,0,26,814,847,291,291,848,849,199,182,548,166,167,182,850,721,851,733,690,689,852,853,854,855,856,857,164,150,167,150,165,166,166,150,165,164,167,167,151,808,858,859,860,861,6,49,0,2,6,22,6], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,862,863,384,292,752,239,165,182,164,150,165,864,865,866,867,868,869,870,871,210,166,165,150,167,167,166,197,164,199,166,182,421,406,872,873,874,875,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,876,877,402,383,878,500,167,166,150,165,166,879,880,881,882,883,884,164,166,150,165,149,150,165,182,199,479,150,182,212,349,438,885,549,886,0,49,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,887,888,293,291,817,182,166,166,167,182,889,890,671,166,165,182,165,211,165,150,150,165,167,150,165,149,891,892,893,894,895,20,2,68,9,495,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,896,897,383,898,527,798,166,165,150,165,479,165,166,166,479,237,149,167,166,167,150,165,167,164,339,899,900,488,846,20,0,4,8,8,4,541,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,27,7,901,902,402,903,904,166,165,150,184,165,165,165,166,150,149,166,212,199,167,905,906,907,908,909,411,0,0,4,5,9,47,47,829,20,20,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,910,9,24,911,912,246,913,166,165,167,639,167,184,167,914,150,149,149,211,915,916,917,918,919,920,0,8,46,0,20,0,24,1,24,0,22,9,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,111,6,46,921,764,922,923,149,182,166,166,149,149,198,199,924,925,926,927,928,861,7,22,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,9,2,929,930,931,932,164,548,149,182,167,167,573,933,934,907,935,936,47,8,5,26,9,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,47,0,8,48,99,937,938,252,165,166,939,809,940,941,201,50,68,3,8,9,8,2,8,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,46,27,112,0,0,942,943,944,528,945,946,947,948,6,46,4,0,24,49,22,47,0,0,9,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,557,26,829,48,949,950,951,952,953,26,8,68,3,27,22,0,5,3,8,9,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666867, 0xff656668, 0xff676664, 0xff656766, 0xff656567, 0xff676765, 0xff686765, 0xff666668, 0xff666664, 0xff6c6962, 0xff857750, 0xff9d8640, 0xffebb608, 0xfffdc204, 0xffdaac10, 0xffa78d36, 0xff7a7359, 0xff6f6b5f, 0xff67656a, 0xff656565, 0xff67666b, 0xff676566, 0xff676769, 0xff666865, 0xff686465, 0xff676767, 0xff666465, 0xff6a6663, 0xff706d5e, 0xff89774f, 0xffa3873d, 0xffdaaf15, 0xffe5b60e, 0xfffcc304, 0xffffc502, 0xffffc700, 0xffffc500, 0xffffc402, 0xfffec601, 0xfff6c004, 0xffe8b80e, 0xffc2a120, 0xff9f883a, 0xff7c7356, 0xff6f6a64, 0xff656764, 0xff676568, 0xff666467, 0xff646665, 0xff676862, 0xff736e5b, 0xff887a4d, 0xffa68b3a, 0xffdbb013, 0xffe9b60d, 0xfffec303, 0xffffc603, 0xfffec502, 0xffffc702, 0xfffdc800, 0xffffc401, 0xffffc501, 0xfff7c004, 0xffeab70c, 0xff9f893d, 0xff787355, 0xff6e6c60, 0xff66656a, 0xff686669, 0xff686860, 0xff72705b, 0xff8f7e4a, 0xffb39330, 0xffdfb113, 0xffedb90b, 0xfffbc600, 0xffffc600, 0xfffec504, 0xfffec600, 0xfffcc601, 0xfff9bf06, 0xffebb90c, 0xffbc9828, 0xff968442, 0xff76705a, 0xff6b6b61, 0xff77715b, 0xff927e49, 0xffb29130, 0xffe4b412, 0xffeebb08, 0xfff5bc0a, 0xffe9b40e, 0xffb99b2b, 0xff988541, 0xff6e6a5f, 0xff676662, 0xff696566, 0xff686667, 0xff797457, 0xff9f873d, 0xffbe9e27, 0xffe7b70d, 0xfff1bd09, 0xffffc602, 0xfff2be06, 0xffe6b70f, 0xffb99a26, 0xff787059, 0xff6d6a63, 0xff646663, 0xff656469, 0xff756e5e, 0xff7d7457, 0xff9e883d, 0xffc99d20, 0xffeab70e, 0xfff5be09, 0xfffcc700, 0xfff3bc09, 0xffb8a22b, 0xff938c44, 0xff696a65, 0xff666762, 0xff746e56, 0xff7e7554, 0xffad8f35, 0xffcfa51b, 0xfff9c203, 0xffffc605, 0xfffed000, 0xfffcd201, 0xfff9eb02, 0xfff3f201, 0xfff5fa00, 0xffeef603, 0xff797a58, 0xff767058, 0xff7f7753, 0xffaf942d, 0xffd3a919, 0xffeebb0a, 0xfff8c105, 0xfffdc702, 0xfffcd400, 0xfff8f102, 0xfff4f501, 0xfff6fd00, 0xfff3ff00, 0xfff4ff01, 0xfff1fc02, 0xff818052, 0xff7a7356, 0xff88774c, 0xffbe9a28, 0xffd6ac18, 0xfff2be0a, 0xfff9c301, 0xfffecb00, 0xfffbd301, 0xfffbdf00, 0xfff5f300, 0xfff5f501, 0xfff3fe00, 0xfff5ff01, 0xfff5ff00, 0xfff4ff00, 0xff878b4e, 0xff676964, 0xff7f7454, 0xff887952, 0xffc5a01e, 0xffdcad15, 0xfff1c004, 0xfffdc401, 0xffffca00, 0xffffcb01, 0xfffad600, 0xfffce501, 0xfff6f401, 0xfff7f902, 0xfff4fe00, 0xfff2ff00, 0xfff7fe00, 0xffa0a33a, 0xff726f5e, 0xffbbb517, 0xfff7c701, 0xfffdc500, 0xffffc803, 0xfffdcc03, 0xfffdd100, 0xfffcde02, 0xfff9ed01, 0xfff6f703, 0xfff5fc00, 0xfff7fe01, 0xfff5ff02, 0xfff5fe03, 0xffc3c91d, 0xff7b7b55, 0xffa69b28, 0xffead001, 0xfff4cb01, 0xfffcc900, 0xfffcce00, 0xfffbd100, 0xfff6ef01, 0xfff6f801, 0xfff4fd02, 0xfff3ff01, 0xfff3fe02, 0xffd0d715, 0xff7e7f53, 0xff7a7454, 0xffcfa802, 0xffcfb200, 0xffe9d002, 0xfff4ce01, 0xfffec901, 0xfffdcf00, 0xfff9ef02, 0xfff6f400, 0xfff5fc01, 0xfff7fd00, 0xffdbe411, 0xff8d9049, 0xff726c5c, 0xffc2a509, 0xffcea903, 0xffd6ba01, 0xffe4c802, 0xfffacc00, 0xffffc801, 0xfffcd800, 0xfff6f101, 0xfff4ff03, 0xfff5f404, 0xfff2f800, 0xffe3ee0c, 0xffa1a838, 0xffb69917, 0xffcba900, 0xffcca903, 0xffcdab03, 0xffd4bb00, 0xffe3c903, 0xffffcc01, 0xfffad500, 0xfffcdd06, 0xfff4f400, 0xfff3fd00, 0xfff2f007, 0xffeecd1c, 0xfff2aa20, 0xffe4345b, 0xffef295e, 0xffed9318, 0xfff4ec03, 0xffeffa00, 0xffccd218, 0xffa48d27, 0xffc4a705, 0xffcfaa03, 0xffccac01, 0xffccac03, 0xffcfb401, 0xffeace01, 0xfff6cd00, 0xfffec400, 0xfffec803, 0xfffdce02, 0xfffcd901, 0xfffce702, 0xfff3f702, 0xfff7f701, 0xfff3fc01, 0xfff3f204, 0xffefca17, 0xffeda328, 0xffe43465, 0xffef265a, 0xffed016d, 0xffef006e, 0xffe1582a, 0xffebdc07, 0xffd2d812, 0xff666563, 0xff7b7553, 0xffb99b17, 0xffccaa02, 0xffcda800, 0xffccaa00, 0xffcbad01, 0xffcfb500, 0xffeccb02, 0xfff6cc00, 0xfffece02, 0xfffdd003, 0xfffde102, 0xfffaef01, 0xfff6f600, 0xfff6ff00, 0xfff3fc03, 0xfff3f106, 0xfff1ca17, 0xffe9a128, 0xffe0365d, 0xffea255b, 0xffec036e, 0xffef006c, 0xfff1006b, 0xfff1006f, 0xffee016b, 0xfff0006b, 0xffdf376a, 0xffeecf1c, 0xffe0e610, 0xff767056, 0xffad9420, 0xffcba804, 0xffcbab00, 0xffd3ba00, 0xffe1ca00, 0xfffaca00, 0xfffed200, 0xfffbe901, 0xfff6ff04, 0xfff8fd01, 0xfff0e60a, 0xffeda223, 0xffe3335a, 0xffec255c, 0xfff0006f, 0xfff00169, 0xfff1016e, 0xffeb3156, 0xfff4cc14, 0xffe5ee0b, 0xff72715c, 0xff7e764f, 0xffccab00, 0xffd4bc04, 0xffe1cf01, 0xfffbef03, 0xfff6f602, 0xfff7fc00, 0xfff5ff04, 0xfff0fa03, 0xffe0d20f, 0xffe2842c, 0xffe33058, 0xffeb1a5c, 0xffed026b, 0xfff3006c, 0xffee016d, 0xfff10069, 0xfff1006d, 0xffee1e5a, 0xffee901f, 0xff797353, 0xffcba806, 0xffcda801, 0xffcfaa01, 0xffcaaa00, 0xffd7c000, 0xfff1fe00, 0xfff1fa01, 0xffdce50e, 0xffcbd415, 0xffa57e45, 0xffd32c5a, 0xffee0169, 0xffee036a, 0xffef0170, 0xfff0006d, 0xfff20070, 0xfff2006e, 0xffe70d64, 0xffd65748, 0xff808251, 0xffbd9d16, 0xffcba802, 0xffcbaa03, 0xffd0b100, 0xfff0f602, 0xfff6ff01, 0xffeff902, 0xffd8e212, 0xffc7cf19, 0xff878c4c, 0xff7d7e54, 0xff6b6b63, 0xff755968, 0xffb42964, 0xfff1016c, 0xffeb0478, 0xffe23574, 0xff999d3f, 0xff6c6d5f, 0xffb19a16, 0xffc9a801, 0xffc9a900, 0xffcdad02, 0xffeff000, 0xfff0f902, 0xffd7e111, 0xffc8d219, 0xff8a8b49, 0xff7c7d51, 0xff676a63, 0xff6a5f65, 0xff973d63, 0xffeb3160, 0xfff7fc02, 0xffacb22c, 0xff74745a, 0xff857b48, 0xffbd9e12, 0xffe7df02, 0xfff2fd00, 0xffedf901, 0xffd6dd15, 0xffc7ce1c, 0xff88894f, 0xff7c7e56, 0xff686964, 0xff7e5366, 0xffec175a, 0xfff1e505, 0xff7f8054, 0xff646569, 0xff797351, 0xffb59a17, 0xffcbab02, 0xffdfd001, 0xffeff501, 0xffd9e112, 0xffc2ca1d, 0xff86874e, 0xff7b7e53, 0xff686866, 0xff666769, 0xff795767, 0xffe7056b, 0xfff10170, 0xffe50b6c, 0xffead814, 0xff7e8154, 0xff6b685f, 0xff8c7d42, 0xffd3bb01, 0xffece801, 0xff8a9048, 0xff6b6a65, 0xffd9106c, 0xffeb026b, 0xfff2ce18, 0xffe4ec0b, 0xffa0a638, 0xff7c7450, 0xffcdaa04, 0xffd0b601, 0xffe8de00, 0xffa3ab34, 0xff73705d, 0xff646869, 0xffd4136c, 0xfff2016c, 0xfff2c512, 0xffebf407, 0xffbac125, 0xff6d6b5f, 0xffbda20b, 0xffcaaa01, 0xffc9ab00, 0xffcdad00, 0xffd9c600, 0xfff6ff02, 0xffcfd616, 0xffb72667, 0xffe7076a, 0xffdc5a29, 0xfff0db06, 0xffd1d914, 0xffb89d12, 0xffd7e013, 0xff858551, 0xff9b3c66, 0xffde0d69, 0xffcb475f, 0xffe8d717, 0xfff8ff02, 0xffd8e011, 0xff656563, 0xff948439, 0xffc0a30a, 0xffcea902, 0xffd1b200, 0xfff1f500, 0xffe7f107, 0xffadb32b, 0xff7e5468, 0xffcf1568, 0xfff2006d, 0xffee006f, 0xffea3055, 0xfff4cc15, 0xfff5ff06, 0xffe5ed0c, 0xff6f735c, 0xffba9f12, 0xffcaac00, 0xffcea900, 0xffcead00, 0xfff0f100, 0xffc4cd1a, 0xff7b5667, 0xffbf1f67, 0xfff12c59, 0xfff7c214, 0xffedf605, 0xff777b56, 0xff626669, 0xff6f6c5b, 0xff9a8931, 0xffe8e001, 0xfff2fb00, 0xff696866, 0xff6c6165, 0xff8f4566, 0xfff2016a, 0xffe60c6b, 0xffcd5c58, 0xff7f8152, 0xff81794b, 0xffcba901, 0xffe2d201, 0xffe2e90f, 0xff6e6f5d, 0xff646567, 0xff6a6164, 0xff834864, 0xffec0069, 0xffef006a, 0xffe40874, 0xffcb467b, 0xfff7fe03, 0xff85864d, 0xff666962, 0xff716c58, 0xffc2a30b, 0xffd4ba01, 0xffeeec01, 0xfff3f903, 0xff7a8052, 0xff626665, 0xff6c5b63, 0xff774560, 0xff852c58, 0xff921050, 0xff95084c, 0xffac0150, 0xffc40057, 0xffec016a, 0xfff3006e, 0xffef2f5e, 0xffafb22d, 0xff6c6761, 0xffbc9f13, 0xffd3b700, 0xffebe402, 0xfff2fd01, 0xff808451, 0xff636766, 0xff686262, 0xff6b5c63, 0xff76495e, 0xff84325a, 0xff950e50, 0xff980850, 0xff99004a, 0xff980049, 0xff9c004a, 0xffa5004d, 0xffd0005b, 0xffe60063, 0xfff32857, 0xfff5f302, 0xffc2c81e, 0xff7b7c54, 0xffa18e27, 0xffc8a607, 0xffcdaf01, 0xffdbc800, 0xffa4a935, 0xff737162, 0xff6b6265, 0xff6f5c62, 0xff75485d, 0xff83335a, 0xff921152, 0xff94094d, 0xff97014b, 0xff98004b, 0xff9a0048, 0xff970149, 0xff9b014a, 0xffa2004c, 0xffcd015a, 0xffe50065, 0xffe60a6c, 0xffe8db13, 0xffd5de15, 0xff808157, 0xff897d43, 0xffbca00e, 0xffd5bc00, 0xffbfc61e, 0xff7d7a59, 0xff6d5e65, 0xff774a61, 0xff911050, 0xff930a4e, 0xff99014c, 0xff9a004b, 0xffa7014d, 0xffbd0054, 0xffe90069, 0xffe90574, 0xffedd51d, 0xfff7fd05, 0xffdbe312, 0xff898949, 0xff757053, 0xffae931e, 0xffd2b300, 0xfff0f900, 0xfff7ff00, 0xffddd512, 0xff98584f, 0xff901450, 0xff930c4f, 0xff97004a, 0xffa6004d, 0xffbb0054, 0xffe90165, 0xffee036c, 0xffed016f, 0xfff2c315, 0xffe9f306, 0xffb4b927, 0xff6e6a5e, 0xff90823b, 0xffcaab03, 0xffcfaf02, 0xffe1d213, 0xffa24154, 0xff99014e, 0xff98024a, 0xff99014a, 0xff9c024b, 0xffc60058, 0xffdf0262, 0xffef026c, 0xffec921a, 0xfff0ec05, 0xffeefa04, 0xff767154, 0xffe9e402, 0xfff2fc00, 0xffeee705, 0xffc98218, 0xff9c004b, 0xff960048, 0xff9e004a, 0xffc50058, 0xffdd0163, 0xffc94364, 0xffe8d718, 0xffd8df13, 0xff706c60, 0xffc1a40b, 0xffcaab02, 0xffe4d601, 0xffeff800, 0xffdeb30e, 0xff97004d, 0xff95014b, 0xff98024c, 0xffa1014b, 0xffb40153, 0xffe60067, 0xfff00167, 0xffdf386e, 0xffedcf19, 0xffdfe513, 0xff696a62, 0xffb2991b, 0xffd6bd01, 0xffeded03, 0xff96054a, 0xff9a0049, 0xff96004a, 0xffa1004c, 0xffb30052, 0xffe50067, 0xffee0069, 0xffef2c58, 0xfff6bb15, 0xffebf405, 0xff787957, 0xff9f8c2e, 0xffc3a507, 0xffd4b701, 0xffeae702, 0xffeadc07, 0xffa10d3f, 0xff980249, 0xff96024c, 0xff9b004c, 0xffbf0052, 0xffd90060, 0xffed1d5b, 0xffec9222, 0xfff0fa05, 0xff7c7d53, 0xff766e57, 0xffa08c2d, 0xffcfb000, 0xffddcc00, 0xffa33444, 0xff98004d, 0xff97004c, 0xff9a004d, 0xff970148, 0xffb0085f, 0xffb6486b, 0xff86874d, 0xff80774c, 0xffcaa705, 0xffd5c100, 0xffa23e48, 0xff95044f, 0xff980148, 0xff96034a, 0xff9b0a55, 0xffb64f50, 0xff979a43, 0xffa58f29, 0xffc8a606, 0xffd2b501, 0xfff3f901, 0xffd19113, 0xffa5203d, 0xff9a0350, 0xff9f0d3e, 0xffaa4b49, 0xffc9861e, 0xffe3d711, 0xffedf003, 0xffd3dc0f, 0xff656661, 0xff837948, 0xffb2991a, 0xfff3f400, 0xfff4ff02, 0xfff8ff01, 0xffe3c412, 0xffab2d42, 0xff970048, 0xff9c0b4c, 0xffb03549, 0xffbf601e, 0xffe5d415, 0xffeee703, 0xffe6ef02, 0xff666863, 0xff777254, 0xffc7a707, 0xffe4d90e, 0xffaf503e, 0xff98074c, 0xffa82d3f, 0xffa54e3d, 0xffdec012, 0xffe6da0c, 0xfff1fc00, 0xffb59a19, 0xffc9a803, 0xffe6d803, 0xffca8319, 0xff98014e, 0xffa42a43, 0xffa9434e, 0xffdfba11, 0xffe4d70f, 0xfff4fb00, 0xffe2ea09, 0xffac961f, 0xffd8c101, 0xffe3cb13, 0xffa11a42, 0xffa73245, 0xffcf941c, 0xffe2c414, 0xfff2f301, 0xffe8f208, 0xffdae310, 0xffa5aa34, 0xff87884f, 0xff706e5f, 0xff6b6863, 0xff877c44, 0xffcaa904, 0xffd6ba00, 0xffecea00, 0xffe4d113, 0xff94074c, 0xffa3143f, 0xffa42e3e, 0xffc6871d, 0xffe0be14, 0xffeeee04, 0xffdfe50f, 0xffafb62c, 0xff8f9245, 0xff73725e, 0xff676863, 0xffac981b, 0xffc9a600, 0xffcfb101, 0xfff1f200, 0xffa6243e, 0xff990249, 0xff9b0b49, 0xffa71f45, 0xffb65329, 0xffd9a514, 0xffeae203, 0xfff1f905, 0xffe6ef08, 0xffc3cb1e, 0xffa1a338, 0xff777856, 0xff6b6d62, 0xffb79d14, 0xffcbad00, 0xffd8c100, 0xffa83343, 0xff950249, 0xff98094b, 0xffa31b43, 0xffb05238, 0xffce9417, 0xffe8d809, 0xfff3f202, 0xffc9d217, 0xffacae31, 0xff7b7b57, 0xff6f715c, 0xff7b7551, 0xffcaa701, 0xffb3512c, 0xff9e0a48, 0xff97034d, 0xff990d4a, 0xffaf3647, 0xffc25f1e, 0xffe3d512, 0xffece705, 0xffd4dd14, 0xffbec520, 0xff808452, 0xff747758, 0xff6c6960, 0xffb79b13, 0xffceb100, 0xffd39315, 0xffa3283d, 0xffa93248, 0xffb1583a, 0xffe5cb12, 0xffecdb05, 0xffc3cd1e, 0xff7a7a56, 0xff7f764d, 0xffaf971d, 0xffeef700, 0xffe7e20d, 0xffe1e90a, 0xffd0db15, 0xff919541, 0xff7f8056, 0xff686961, 0xff6d6a61, 0xff8c7e3f, 0xffcdab01, 0xffd6e010, 0xff9fa237, 0xff686762, 0xffb0981c, 0xffdbc500, 0xffefef01, 0xffeaf207, 0xffdde70d, 0xffb2b62b, 0xff939146, 0xff717459, 0xff636864, 0xff8e7e40, 0xffbda112, 0xffecec02, 0xfff6fc04, 0xffeff703, 0xffe2ea0b, 0xffb7be22, 0xff96993e, 0xff757559, 0xff6a6a62, 0xff696864, 0xffceb002, 0xffe3d301, 0xfff4fa02, 0xffe9f106, 0xffcad21a, 0xffaaae33, 0xff7b7d55, 0xff646867, 0xff6a6a5e, 0xffbea50b, 0xffd9c506, 0xffedf702, 0xffd0d717, 0xff7d7f57, 0xff72755a, 0xff84774b, 0xffb8a518, 0xfff1fa03, 0xffc7d01b, 0xff88874e, 0xff6e6c5f, 0xff9c8d38, 0xfff2f504, 0xffdde60f, 0xffcdd617, 0xff909046, 0xff7d7e52, 0xff686763, 0xff686b62, 0xff969640, 0xff84884d, 0xff6d6d61]
				); 
        }
		public function box10():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,1,2,3,3,4,5,4,6,7,8,9,10,9,11,9,9,12,11,5,13,2,14,15,3,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,12,0,35,9,12,36,9,4,9,9,9,9,9,9,9,9,9,9,9,9], 
    [1,37,9,38,39,10,4,13,10,10,36,14,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,29,58,58,59,59,58,60,60,61,58,62,63,64,65,66,67,68,15,10,68,0,3,10,9,9,9,9,9,9,9,9,9,9,9], 
    [69,70,1,4,40,1,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,57,28,60,60,88,61,89,59,90,88,60,60,88,91,59,92,93,94,95,96,97,98,99,40,36,3,10,36,9,9,9,9,9,9,9,9,9,9,9,9,9], 
    [36,100,101,102,103,104,105,106,107,108,109,95,62,88,64,60,89,92,29,95,60,61,95,60,110,111,88,61,61,59,93,93,58,94,62,59,112,88,95,113,93,114,94,62,61,115,116,5,11,5,117,118,39,9,9,9,9,9,9,9,9,9,9,9], 
    [119,120,121,108,64,88,29,92,93,95,59,29,94,88,62,59,61,60,60,61,88,29,88,94,88,92,29,88,88,60,92,61,114,88,88,58,30,57,122,29,61,114,111,29,62,64,123,124,125,118,12,126,12,9,9,9,9,9,9,9,9,9,9,9], 
    [4,127,128,129,95,122,130,60,95,63,94,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,58,61,92,131,132,133,134,135,136,137,35,2,138,15,12,9,9,9,9,9], 
    [10,139,140,141,142,58,29,93,62,57,60,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,61,61,92,29,143,144,145,146,3,3,0,147,0,4,4,9,9,9,9,9], 
    [12,148,149,150,151,62,57,64,29,92,95,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,61,95,60,152,153,154,36,68,155,118,9,156,9,9,9,9,9], 
    [9,157,158,159,160,161,162,61,88,95,61,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,58,58,58,60,62,163,164,165,166,167,5,10,168,169,9,9,9,9,9], 
    [4,170,171,159,172,173,174,175,61,94,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,61,58,88,61,93,112,176,177,126,0,67,3,9,9,9,9,9], 
    [3,178,179,180,159,181,151,111,59,57,95,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,61,58,58,92,89,93,61,94,111,182,183,184,3,7,67,9,9,9,9,9], 
    [9,157,185,159,186,159,187,188,189,58,95,92,60,93,93,59,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,92,112,190,191,34,0,9,37,2,68,14], 
    [9,157,185,159,186,192,193,194,195,88,114,95,60,93,93,61,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,88,95,64,196,197,198,199,10,126,200,15], 
    [9,157,185,159,186,186,201,202,203,204,28,60,62,60,60,60,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,57,90,29,59,205,206,207,0,3,208,9], 
    [9,157,185,159,186,209,159,202,202,210,211,89,212,60,60,59,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,59,94,90,93,95,213,214,215,118,13,216], 
    [9,157,185,159,186,159,217,218,219,181,220,221,110,95,58,60,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,61,95,111,222,223,224,225,226,227,71,67], 
    [9,157,185,159,186,186,186,186,186,186,186,228,229,59,130,58,88,60,88,130,59,93,93,59,60,60,60,95,60,60,95,59,61,61,60,59,95,60,29,29,61,61,60,60,89,60,61,58,59,61,230,231,232,233,233,234,235,236,237,238,239,240,241,9], 
    [9,157,185,159,186,186,186,186,186,186,186,242,243,88,30,88,60,60,95,60,60,60,60,92,92,60,60,60,60,58,88,93,61,58,88,58,61,57,92,230,224,223,231,244,245,246,247,248,249,250,251,252,253,254,255,254,254,256,257,253,257,258,259,260], 
    [9,157,185,159,186,186,186,186,186,186,186,181,261,262,88,59,60,93,111,93,60,88,93,88,95,95,95,59,92,94,92,92,59,230,263,264,265,266,233,267,268,269,270,271,272,273,274,255,275,254,254,255,253,276,257,277,278,257,277,257,279,280,134,156], 
    [9,157,185,159,186,186,186,186,186,186,186,186,217,281,129,58,93,61,60,59,95,60,282,224,232,283,233,284,285,286,287,288,289,290,291,277,277,254,257,277,253,276,257,278,292,257,278,276,293,254,254,254,254,254,253,277,257,254,255,294,295,296,0,260], 
    [9,157,185,159,186,186,186,186,186,186,186,297,218,298,299,93,95,222,223,300,300,301,302,303,304,238,305,272,291,294,274,306,278,253,307,277,277,277,253,278,254,253,256,254,254,294,253,275,294,257,278,278,278,253,253,253,307,257,257,306,308,309,12,36], 
    [9,157,185,159,186,186,186,186,186,186,186,310,181,180,219,311,312,313,274,254,255,253,257,257,277,254,254,277,253,254,254,254,294,314,257,257,277,255,257,253,257,274,253,306,294,254,278,253,253,315,278,316,253,257,293,257,277,278,277,278,317,318,5,9], 
    [9,157,185,159,186,186,186,186,186,186,186,310,159,181,310,319,276,257,257,253,253,278,278,278,257,278,292,278,253,277,257,277,257,278,316,293,253,320,277,277,276,257,254,255,257,254,321,274,322,323,324,325,326,327,328,277,254,277,316,255,329,330,9,9], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,202,331,253,253,253,254,254,253,257,253,257,253,277,307,257,306,253,332,253,278,255,254,254,333,334,335,336,337,338,339,340,341,342,343,344,345,346,347,348,349,350,253,257,277,253,257,351,352,10,0], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,310,353,253,253,253,254,254,292,278,306,307,253,306,254,255,293,307,276,314,354,355,356,357,358,359,360,361,362,363,364,365,366,367,368,369,370,371,372,373,374,375,257,332,376,254,315,377,0,5,0], 
    [9,157,185,159,186,186,186,186,186,186,186,202,186,378,379,380,254,253,253,253,253,276,381,354,382,383,384,385,386,387,388,389,390,391,392,393,394,348,395,396,397,395,398,396,399,348,400,399,400,397,371,348,371,401,291,402,255,293,277,403,404,9,4,3], 
    [9,157,185,159,186,186,186,186,186,186,186,202,405,180,406,238,253,253,254,254,254,407,408,409,410,411,412,413,414,415,416,9,9,417,418,369,368,419,396,395,419,420,370,421,370,394,394,396,396,371,400,422,420,423,253,256,254,275,257,424,425,5,40,117], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,379,426,253,253,253,253,253,385,427,4,10,4,9,9,9,9,9,9,3,428,429,419,370,396,396,396,396,396,396,396,396,396,396,396,396,397,396,397,430,431,254,257,257,254,253,432,433,126,9,10], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,379,426,253,253,257,253,253,434,390,4,10,0,126,9,9,9,9,9,9,435,436,394,437,396,396,396,396,396,396,396,396,396,396,396,437,397,419,419,438,439,253,254,277,254,257,440,441,9,147,9], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,379,426,253,253,257,253,253,442,443,12,4,4,37,9,9,9,9,9,126,444,445,446,396,396,396,396,396,396,396,396,396,396,396,396,398,400,447,448,449,450,451,278,256,257,253,452,413,11,117,9], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,379,426,253,253,253,253,257,453,454,9,9,9,9,9,9,9,9,9,0,455,456,396,368,396,396,396,396,396,396,396,396,396,396,396,400,457,394,400,458,459,257,278,257,253,257,460,461,126,126,10], 
    [9,157,185,159,186,186,186,186,186,186,186,186,202,159,379,426,253,253,253,253,257,462,463,9,464,9,5,9,9,9,9,9,7,465,466,419,396,396,396,396,396,396,396,396,396,396,396,396,399,419,399,467,468,469,451,254,277,306,277,470,471,10,147,7], 
    [9,157,185,159,186,186,186,186,186,186,186,180,186,186,472,473,254,294,253,294,294,474,475,3,135,0,3,3,9,476,477,478,479,480,481,396,396,396,482,395,395,398,399,396,396,396,396,396,348,348,370,396,483,484,485,277,253,254,253,486,487,9,9,40], 
    [9,157,185,159,186,186,186,186,186,186,186,180,186,186,472,473,253,274,253,278,253,488,489,490,491,492,493,494,495,496,497,498,499,500,501,502,419,348,503,437,395,419,398,396,396,396,396,396,504,395,505,506,507,291,257,253,253,254,253,508,509,126,2,0], 
    [9,157,185,159,186,186,186,186,186,186,186,180,186,186,472,473,451,253,307,254,277,510,511,512,513,514,515,516,517,500,518,518,519,520,521,522,523,419,419,398,396,419,394,396,396,396,396,396,448,397,397,524,525,276,254,257,257,253,253,526,34,8,0,135], 
    [9,157,185,159,186,186,186,186,186,186,186,180,186,186,472,473,278,253,254,253,253,527,528,529,518,530,531,521,531,532,531,533,534,518,535,536,537,394,400,420,503,396,395,396,396,396,396,396,400,396,395,538,539,253,253,257,253,253,277,413,67,352,9,126], 
    [9,157,185,159,186,186,186,186,186,186,186,180,186,186,472,473,277,253,254,253,253,540,541,516,542,531,543,544,545,546,518,535,531,500,518,547,536,548,549,397,373,467,550,396,396,396,396,396,396,348,398,551,552,253,277,254,254,253,553,554,5,5,4,10], 
    [9,157,158,186,186,186,186,186,186,186,186,187,203,186,555,473,253,253,253,253,254,556,557,518,558,544,544,531,531,531,531,531,531,531,531,531,531,559,560,419,421,348,561,395,395,370,370,395,394,370,562,563,564,277,277,316,253,253,565,566,9,9,3,10], 
    [9,567,185,186,186,186,186,186,186,186,186,202,218,187,555,568,253,253,253,253,254,569,570,532,544,518,531,531,531,531,531,531,531,531,531,531,531,531,571,572,506,396,397,396,396,400,400,396,397,348,573,574,575,257,253,278,253,257,576,577,40,9,3,9], 
    [4,157,185,202,202,186,186,186,186,186,186,201,159,201,578,328,253,253,253,253,254,579,580,581,518,544,531,531,531,531,531,531,531,531,531,531,531,531,531,582,583,394,395,396,396,396,396,467,419,348,584,585,586,253,253,278,253,316,587,588,7,126,4,4], 
    [9,157,589,202,186,186,186,186,186,186,186,202,378,202,590,315,253,253,254,253,253,556,591,542,592,544,531,531,531,531,531,531,531,531,531,531,531,520,593,518,594,595,467,395,396,396,396,396,419,596,437,597,598,277,253,254,257,293,599,4,7,67,11,9], 
    [10,600,158,601,405,186,186,186,186,186,186,310,180,310,602,315,253,253,254,253,253,603,591,544,531,532,518,531,531,531,531,531,531,531,531,531,531,544,518,516,518,604,605,446,400,396,467,395,399,606,398,607,608,255,253,253,257,553,609,137,147,2,117,126], 
    [9,610,611,310,186,186,186,186,186,186,186,186,202,186,612,613,253,253,254,253,253,614,615,616,531,532,531,531,531,531,531,531,531,531,531,531,531,515,593,617,531,536,618,619,400,396,467,396,348,397,606,620,621,254,253,253,257,553,622,5,4,0,156,9], 
    [9,623,624,625,626,186,186,186,186,186,186,186,627,186,628,277,253,253,253,253,253,629,543,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,630,631,396,397,396,397,397,399,632,633,257,254,253,253,634,635,3,10,9,4,9], 
    [135,636,637,638,218,186,186,186,186,186,186,186,627,186,628,402,253,253,253,253,253,639,531,531,532,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,640,560,348,549,419,396,422,503,641,642,257,255,253,253,643,644,1,9,9,4,9], 
    [14,7,3,645,378,186,186,186,186,186,186,310,202,186,628,402,253,253,253,253,253,646,531,531,532,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,532,581,617,647,648,400,348,399,446,649,650,256,254,257,277,651,411,4,9,9,9,4], 
    [9,67,126,652,653,186,186,186,186,186,186,201,180,186,654,257,253,254,253,253,253,655,531,531,532,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,532,531,544,656,657,467,394,370,395,658,659,257,253,254,402,660,661,9,9,9,9,4], 
    [12,10,36,662,663,186,186,186,186,186,186,202,159,159,628,253,253,254,253,253,277,664,592,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,517,665,514,666,667,396,419,668,669,277,257,316,256,377,670,10,9,9,9,9], 
    [117,671,68,672,673,674,601,378,219,180,159,310,187,186,675,254,306,277,277,255,295,676,581,531,531,531,531,531,531,531,531,531,531,531,531,531,531,581,518,516,518,531,677,544,678,518,532,679,680,419,446,681,333,276,255,277,306,682,683,9,9,9,9,9], 
    [5,10,352,3,9,684,685,180,378,201,159,186,201,186,654,254,253,253,253,257,250,686,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,516,687,545,530,518,533,688,531,518,689,532,690,691,596,692,613,315,257,257,253,693,694,9,9,9,9,9], 
    [9,0,9,4,695,696,697,186,187,698,638,186,202,186,675,278,257,253,253,257,272,686,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,521,516,533,530,500,546,592,617,517,677,515,699,700,621,257,277,254,701,253,702,703,9,9,9,9,9], 
    [3,704,3,9,10,9,705,706,378,159,378,186,201,310,654,254,257,257,253,255,707,686,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,518,617,518,518,521,521,531,617,708,512,709,710,711,712,713,293,277,315,278,307,714,715,9,9,9,9,9], 
    [10,9,716,10,134,14,717,718,719,310,202,186,186,186,720,254,256,277,253,255,250,721,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,517,722,530,514,723,724,725,726,727,728,729,730,731,732,295,277,253,253,293,278,733,9,9,9,9,9,9], 
    [9,9,9,9,9,3,352,734,735,625,180,186,217,736,737,278,257,254,257,274,738,739,514,677,740,518,543,531,741,546,546,518,617,724,513,742,743,744,745,746,747,748,749,750,250,254,278,253,253,253,277,257,751,278,253,751,752,753,4,9,9,9,9,9], 
    [9,9,9,9,9,67,67,134,754,186,218,218,187,755,756,316,315,253,307,253,757,758,531,544,515,530,558,531,759,591,760,761,762,763,764,765,766,767,732,768,769,257,293,257,256,293,278,278,316,275,275,278,253,254,253,253,295,770,39,9,9,9,9,9], 
    [9,9,9,9,9,3,68,9,7,771,378,186,186,772,773,451,257,274,254,307,774,775,776,777,778,779,780,781,782,783,784,239,273,254,785,786,315,278,253,787,293,276,257,277,293,254,257,276,257,253,277,307,277,293,257,788,789,790,4,9,9,9,9,9], 
    [9,9,9,9,9,10,4,34,36,791,792,310,186,793,794,254,278,274,292,257,795,796,797,798,799,800,801,802,277,277,276,253,276,293,257,274,276,257,316,257,277,274,254,316,278,255,254,254,277,292,278,254,253,295,803,804,805,806,807,9,9,9,9,9], 
    [9,9,9,9,9,808,138,809,6,636,754,698,810,811,812,278,255,274,254,306,276,278,307,275,253,257,316,254,253,813,276,253,257,814,278,306,292,253,253,293,293,254,257,253,257,815,816,817,818,819,820,821,822,414,463,823,824,36,9,9,9,9,9,9], 
    [9,9,9,9,9,9,12,9,200,169,241,825,405,811,826,256,256,257,278,451,278,277,306,253,293,277,253,254,306,257,255,253,275,278,253,253,255,278,277,257,307,827,424,383,828,829,830,831,832,454,833,588,8,9,1,3,200,10,0,9,9,9,9,9], 
    [9,9,9,9,9,9,9,9,9,9,9,834,835,379,836,316,253,278,254,253,257,837,257,278,293,293,278,253,253,277,277,278,293,838,789,839,840,841,842,843,844,454,566,845,5,12,11,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9], 
    [9,9,9,9,9,9,9,9,9,9,9,846,847,472,848,257,276,253,253,307,255,277,277,253,254,255,254,278,849,850,576,851,852,853,854,831,855,856,833,857,10,12,9,0,0,0,10,4,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9], 
    [9,9,9,9,9,9,9,9,9,9,9,118,858,859,860,253,316,255,254,254,752,565,789,861,862,863,864,865,258,414,866,824,118,9,9,200,352,10,12,5,138,4,4,3,3,10,9,12,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9], 
    [9,9,9,9,9,9,9,9,9,9,9,13,36,867,868,294,613,869,382,870,452,871,872,873,874,875,876,877,5,117,15,9,9,147,5,4,0,126,11,4,5,67,2,7,9,9,4,10,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9], 
    [9,9,9,9,9,9,9,9,9,9,9,1,3,878,879,880,753,463,881,4,5,9,5,8,126,10,10,352,9,10,118,9,9,10,10,5,118,118,2,34,9,6,118,1,1,10,0,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9]
],
[0xff656766, 0xff676568, 0xff666865, 0xff676566, 0xff666668, 0xff676765, 0xff646663, 0xff676769, 0xff67666b, 0xff666666, 0xff666664, 0xff656567, 0xff656565, 0xff686669, 0xff666769, 0xff666563, 0xff6b6b5f, 0xff6f6b60, 0xff73715c, 0xff79735b, 0xff7b7253, 0xff77765a, 0xff9a813e, 0xffa68c35, 0xffcca71a, 0xffddad0f, 0xfff5bb02, 0xfff9c001, 0xfffdc702, 0xffffc502, 0xfffec400, 0xffffc800, 0xffe7b80a, 0xff9c853f, 0xff676863, 0xff67656a, 0xff676664, 0xff676662, 0xff68686a, 0xff646567, 0xff66656a, 0xff6c6960, 0xff706d5e, 0xff767058, 0xff787059, 0xff7b7458, 0xff7e7554, 0xff9e863c, 0xffb09232, 0xffc9a21f, 0xffd8ab10, 0xffe6b20e, 0xffe8ba0d, 0xffefbc0b, 0xfff3bc07, 0xfff9c205, 0xfffcc206, 0xfffdc500, 0xffffc600, 0xfffec601, 0xffffc501, 0xffffc500, 0xfffec502, 0xffffc400, 0xfffdc401, 0xffb89829, 0xff807652, 0xff646665, 0xff656764, 0xff646867, 0xff646464, 0xff6b6861, 0xff6f6b62, 0xff746e5e, 0xff777159, 0xff787356, 0xff797258, 0xff837654, 0xffa88937, 0xffb3942a, 0xffd2a814, 0xffdeae10, 0xffe7b70f, 0xffebb80d, 0xfff0bb0b, 0xfff4bd0a, 0xfff7c204, 0xfffcc400, 0xffffc700, 0xffffc401, 0xfffcc602, 0xfffcc700, 0xffffc602, 0xfffec600, 0xffffc603, 0xffffc702, 0xfffdc703, 0xfff3bf07, 0xffd0a518, 0xff6d6a63, 0xff968e3d, 0xffc0a41f, 0xffdcb013, 0xffe0b010, 0xffe8ba0f, 0xffebbc0a, 0xfff0bc08, 0xfff8c206, 0xfffcc300, 0xfffdc300, 0xffffc701, 0xfffdc800, 0xffffc404, 0xfffec506, 0xfffcc601, 0xffe4b50f, 0xffa48b37, 0xff666465, 0xff656668, 0xff676661, 0xffae9c1e, 0xffe7c909, 0xffffc605, 0xffeabb0b, 0xff7f7551, 0xff6d6660, 0xff676767, 0xffb2981d, 0xffcdac05, 0xfff4c900, 0xffffc801, 0xfffbc100, 0xffdbae15, 0xff746c59, 0xff686765, 0xff666762, 0xff626866, 0xff646661, 0xff666467, 0xffae961a, 0xffc7ab02, 0xffe1cf00, 0xfff9cb03, 0xfff9c203, 0xffa28c37, 0xff76705a, 0xff676364, 0xff656563, 0xffb09718, 0xffcca603, 0xffd0ac00, 0xffd5bc00, 0xfff5bd04, 0xff8c7b47, 0xff70695f, 0xff66656b, 0xff686667, 0xffb1971c, 0xffc9a803, 0xffcbab00, 0xffceaf00, 0xfff7c701, 0xfffcc802, 0xfffec401, 0xffdeb015, 0xff998540, 0xff676964, 0xff686367, 0xff68666b, 0xff696566, 0xffaf9818, 0xffcaa902, 0xffd0ab04, 0xffd1b700, 0xffe0d602, 0xffffc503, 0xffc29e23, 0xff807750, 0xffae981e, 0xffcda704, 0xffcbab02, 0xffccac01, 0xfff6be07, 0xffd5a817, 0xff6e6c5f, 0xffc9a801, 0xffccaa00, 0xffcdab01, 0xffdfc800, 0xfff6cb02, 0xffe5b411, 0xffaa9031, 0xffccac03, 0xffcaa800, 0xffcfb602, 0xffddd100, 0xffeebb0a, 0xff827650, 0xff6b6764, 0xff666469, 0xff65666a, 0xffcba901, 0xffccaa02, 0xffcbad01, 0xfff2c700, 0xfff8c102, 0xffdead12, 0xff726f5e, 0xff626667, 0xffcdab03, 0xffdac200, 0xfff6c800, 0xffffc402, 0xfff8c303, 0xffab9132, 0xff77715b, 0xff646965, 0xffcea902, 0xffcaac00, 0xffcdac00, 0xffd3b600, 0xfffccd03, 0xfffecb00, 0xffffcc00, 0xffffcc01, 0xfffccc00, 0xfff5c606, 0xff817a4e, 0xfff0cf04, 0xfffec803, 0xfffec901, 0xfffdcd00, 0xfffece00, 0xfffdcf00, 0xfffdd501, 0xfffede00, 0xfffcf101, 0xfffbf501, 0xfff0f600, 0xfff4f600, 0xff98973d, 0xff6b6d60, 0xffd0b300, 0xffdecd01, 0xfffed001, 0xfffcd300, 0xfffce501, 0xfffdeb01, 0xfff1f700, 0xffeef801, 0xfff5f700, 0xfff7f700, 0xfff7fc00, 0xfff5ff00, 0xfff4ff00, 0xfff3ff00, 0xfff6ff02, 0xfff5ff01, 0xff7a7b59, 0xff686868, 0xff656762, 0xffd0b702, 0xfffacc04, 0xfffec900, 0xfffece02, 0xfffdcd01, 0xfffdce02, 0xfffcde00, 0xfffde801, 0xfff7f703, 0xffeff800, 0xfff3f702, 0xfff6f600, 0xfff5fc00, 0xfff6fd00, 0xfff2ff00, 0xfff7fe01, 0xfff4fe00, 0xfff4ff01, 0xfff2fd00, 0xff797b54, 0xffd9bc00, 0xffffc803, 0xfffcce00, 0xfffed201, 0xfffedc01, 0xfffcf103, 0xfff7f502, 0xffeef700, 0xfff5f602, 0xfff7f900, 0xfff6fb01, 0xfff5ff02, 0xfff3fe00, 0xfff7fe00, 0xfff2fb00, 0xff787759, 0xffc9a900, 0xffd1ad01, 0xffdcc400, 0xfffbce01, 0xfffbd100, 0xfffdd901, 0xfffdec00, 0xfffdf401, 0xffeff801, 0xfff5fe03, 0xfff6ff01, 0xfff1fa01, 0xff77755c, 0xffcba900, 0xffeeee00, 0xfff6f800, 0xfff6fb00, 0xfff0ff00, 0xfff4fd02, 0xfff4ff03, 0xffe8f206, 0xff6d6e60, 0xfff1f201, 0xfffafd00, 0xfff7fc02, 0xfff8f802, 0xfff2e304, 0xffe9e20e, 0xffefdb18, 0xfff3dc14, 0xffede40d, 0xfff3fc01, 0xffe7f00b, 0xff6b6c64, 0xffeff300, 0xfff3ff01, 0xfff4f501, 0xfff2f005, 0xffeae215, 0xffebde14, 0xfff3da0e, 0xfff4d711, 0xffef9117, 0xffcc4c41, 0xffd23687, 0xffe32682, 0xffed245b, 0xfff31e60, 0xffed0761, 0xffe4086a, 0xffee0175, 0xfff0006b, 0xffe3751e, 0xfff3eb02, 0xffdde60f, 0xff666867, 0xffeff501, 0xfff1fa03, 0xfff2f504, 0xfff2da18, 0xfff4d812, 0xfff4a40d, 0xffec8e1c, 0xffc2436c, 0xffd23689, 0xffeb2258, 0xffef225b, 0xffef165d, 0xffeb0768, 0xffe90574, 0xffee0271, 0xfff2006d, 0xffef0170, 0xffef026e, 0xfff0006a, 0xffee0270, 0xfff10069, 0xfff1970f, 0xfff6f101, 0xfff8ff01, 0xffd8e10c, 0xffcaaa01, 0xffcead00, 0xffeff500, 0xfff4fa02, 0xffedf605, 0xffe5ee0b, 0xffdee80b, 0xffd7df10, 0xffd2d812, 0xffb1b32c, 0xff9ea138, 0xff7a7c57, 0xff797a5a, 0xff7a745a, 0xff965859, 0xffee0074, 0xffee016b, 0xfff1006d, 0xfff0006d, 0xfff1016c, 0xfff2016c, 0xfff1006f, 0xfff1016e, 0xfff9ce10, 0xfff3fd00, 0xfff0f900, 0xffccd314, 0xffccab00, 0xffcdae00, 0xffeaf802, 0xffdbe50b, 0xffc7d013, 0xffb5bb25, 0xff8e9045, 0xff7c7c56, 0xff787957, 0xff767a59, 0xff6f705e, 0xff6d705f, 0xff6d6067, 0xff983d66, 0xfff1006b, 0xffef026c, 0xffed026b, 0xfff1026a, 0xfff5db12, 0xffeff902, 0xffc4cb1b, 0xfff1f500, 0xff7a7a56, 0xff735c66, 0xffba2464, 0xffee006f, 0xfff2db13, 0xffeaf00a, 0xff9ea438, 0xffd8e00f, 0xff775867, 0xffc21a65, 0xfff2006e, 0xffef0077, 0xfff2db19, 0xffe7ed0d, 0xff8d904b, 0xffd7df0e, 0xff787856, 0xff785867, 0xffd80d67, 0xffed016d, 0xffed006c, 0xfff2006b, 0xffe5076e, 0xffefe10f, 0xfff6ff00, 0xffdbe40d, 0xffd2d911, 0xff777856, 0xff795968, 0xffd80f6b, 0xfff0006f, 0xffe60771, 0xffebe012, 0xffd9e110, 0xff767a57, 0xffc9cf15, 0xff757559, 0xff656661, 0xff8b4964, 0xffe20b70, 0xffee016d, 0xffee145e, 0xfff1f002, 0xffccd112, 0xff76765c, 0xffd0b101, 0xfff3fa00, 0xffc8d116, 0xff76745b, 0xff6a6164, 0xff6b5e65, 0xff6c5d64, 0xff6f5a63, 0xff9c3564, 0xffe10768, 0xfff3006e, 0xffec195e, 0xfff3f300, 0xfff7fe03, 0xffc2cb18, 0xff75755b, 0xffc5a917, 0xff894e54, 0xff872b5a, 0xff8a2658, 0xff981154, 0xff9a0d52, 0xff910f4f, 0xff900e4e, 0xff96094e, 0xff97054c, 0xff9a044e, 0xff9a024b, 0xff98024a, 0xffa8024e, 0xffec0069, 0xfff00169, 0xfff10268, 0xfff20070, 0xffed006a, 0xfff3215e, 0xff9ca13b, 0xff6c6e61, 0xffbf5312, 0xff9a1043, 0xff96064e, 0xff97054e, 0xff99014a, 0xff9b014a, 0xff98004d, 0xff95014b, 0xff980049, 0xff980146, 0xff9c004e, 0xff9a004b, 0xffd3005d, 0xffea016a, 0xfff0036d, 0xfff02457, 0xff818054, 0xffc0430d, 0xff9e0643, 0xff9b0147, 0xff98024c, 0xff98004b, 0xff97014b, 0xff98014e, 0xff94024d, 0xff9b0049, 0xff9d014b, 0xffb10251, 0xffef0075, 0xffe7227a, 0xffb54517, 0xff9b0743, 0xff9b004c, 0xff97004d, 0xff970149, 0xff950249, 0xff970048, 0xff9b004b, 0xffdb005f, 0xffef006a, 0xffee026e, 0xffec0271, 0xffe42781, 0xfff2fd01, 0xff777858, 0xffcfb101, 0xff913b5e, 0xff960550, 0xff96004a, 0xff9e004a, 0xffbd0054, 0xfff30070, 0xfff3006c, 0xffe5086f, 0xffbf4472, 0xfff0fa03, 0xff777658, 0xffb0961b, 0xfff1fa00, 0xff913b60, 0xff930551, 0xff9c0049, 0xffe50163, 0xffec016a, 0xffe4076e, 0xffbe4564, 0xffedf703, 0xff74725d, 0xffd1b401, 0xff923a60, 0xff950453, 0xff99014c, 0xffa5004d, 0xffcb005a, 0xffec036e, 0xffef155f, 0xffed8d14, 0xffe6ef0a, 0xff6a6c61, 0xffc8a700, 0xffd3b402, 0xff950451, 0xff97004a, 0xff960048, 0xffa90051, 0xffec0168, 0xffef0068, 0xfff3185c, 0xfff2a00e, 0xffe3eb0c, 0xffb0961d, 0xffcbaa00, 0xffd2b300, 0xff953864, 0xffb10051, 0xffdb0063, 0xffef006c, 0xfff4245e, 0xfff9da10, 0xffdae00e, 0xffad921d, 0xffc8a606, 0xffd3b300, 0xfff6fd02, 0xff9b3366, 0xff980354, 0xff970148, 0xff9a0049, 0xffb10050, 0xffe9006b, 0xffef235e, 0xfff4db0d, 0xffd8dd0f, 0xff746d5b, 0xffae9521, 0xffcea900, 0xffcfaa03, 0xffcca903, 0xffd1b400, 0xffa42542, 0xffba0053, 0xffe30061, 0xffe62383, 0xfff2dd14, 0xfff1f905, 0xffc4cc16, 0xff6b6766, 0xff827646, 0xffcaab03, 0xffa52442, 0xffa0004a, 0xffde2a85, 0xfff2db1b, 0xffebf308, 0xffafb32a, 0xffb59a17, 0xffa62440, 0xffc60058, 0xffe80169, 0xffc0466f, 0xffeae213, 0xffe3ee0b, 0xff887c42, 0xffc0a20e, 0xffd2b501, 0xffa52440, 0xffa8014f, 0xffd1005c, 0xffc44e5e, 0xffeae30f, 0xffdfe811, 0xff7e7f57, 0xff68685e, 0xff80774c, 0xffa42341, 0xff9b0048, 0xffd9005e, 0xffed0068, 0xfff29810, 0xfff3f201, 0xff79795d, 0xff636768, 0xff636864, 0xff6f6b5f, 0xffc2a406, 0xffd3b602, 0xffa61e42, 0xff980148, 0xff96034a, 0xffb4004c, 0xffdc0060, 0xfff4a30c, 0xffd4dd10, 0xff787959, 0xff897d43, 0xffc0a10b, 0xffa41c40, 0xff97004c, 0xff9a024d, 0xff99034d, 0xff9e004d, 0xffe60168, 0xfff4da13, 0xffc3cb20, 0xff737659, 0xff696562, 0xff71705c, 0xffa89423, 0xffcba802, 0xffbc0152, 0xffe20062, 0xfff4ff05, 0xffa7ab33, 0xff6e6f5d, 0xff666561, 0xff6c6c60, 0xffc3a505, 0xfff3f700, 0xff990050, 0xff9f0f42, 0xffa81a40, 0xff9f2743, 0xffa0385b, 0xffede40b, 0xff87884e, 0xff686963, 0xff656469, 0xff686463, 0xffb69b18, 0xffc9a805, 0xffd4b703, 0xffa31b3f, 0xff95014f, 0xff960153, 0xff95054d, 0xff9d0f41, 0xffa61a3f, 0xffa52651, 0xff973953, 0xffc66d0f, 0xffe1ad0c, 0xffe9da0b, 0xffe6e012, 0xff7c7e57, 0xff756e5c, 0xffaa931f, 0xffcaaf00, 0xffdac301, 0xfff2f103, 0xffa41540, 0xff97004f, 0xff9c004c, 0xffa21740, 0xffa3203f, 0xff9d3363, 0xff983c55, 0xffce8407, 0xffdfb50b, 0xffebdb12, 0xffe5df0f, 0xffeeea02, 0xfff3fe02, 0xfff2fe00, 0xff797a58, 0xff7b7551, 0xffceac04, 0xffddc503, 0xffefe303, 0xff9c0940, 0xff9a004d, 0xff98054c, 0xffa61943, 0xffa42342, 0xff933d5a, 0xff983e4a, 0xffdc940a, 0xffe7c00b, 0xffe7df10, 0xfff1ee01, 0xfff5f604, 0xff777859, 0xffb29a14, 0xffcbb000, 0xffdac603, 0xffeee300, 0xff9b0c44, 0xff9c0844, 0xffa41c42, 0xffa52242, 0xff9a3756, 0xffaa3c2b, 0xffe0b10b, 0xffecd209, 0xffe5e012, 0xffe9df0b, 0xfff7fd00, 0xfff6ff06, 0xfff4fd04, 0xfff6fe00, 0xffeef804, 0xff72755a, 0xff897f44, 0xffc0a00d, 0xffcdad00, 0xffdbc404, 0xfff0ef01, 0xffa24647, 0xffbc4d16, 0xffe3b30b, 0xffead309, 0xffe5e00b, 0xffeadf07, 0xfff2f603, 0xffeff905, 0xffe5ec0a, 0xffd6df14, 0xff6c6d5f, 0xff686763, 0xff616767, 0xff616765, 0xffcbaa03, 0xffcdad02, 0xffd9c502, 0xfff3ff03, 0xfff8fd01, 0xfff1fc00, 0xffeffa00, 0xffe6ee0f, 0xffe2e910, 0xffd5df0f, 0xffc4cb19, 0xff959841, 0xff7d7e52, 0xff6c6962, 0xff686964, 0xffc3a40b, 0xffdcc700, 0xfff4fb00, 0xffe0e70e, 0xffd3dc11, 0xffc3cb1d, 0xff8e9047, 0xff7c7e56, 0xff74775a, 0xff85784b, 0xffbe9f10, 0xffdac900, 0xfff5fe05, 0xfff2fd03, 0xffe5ed0e, 0xffe0e610, 0xffd3da10, 0xffc4cc17, 0xff8f9146, 0xff7c7d51, 0xff6a6a62, 0xff706d5a, 0xffa6902b, 0xffe1d300, 0xfff3fe04, 0xfff1fc02, 0xffe0ec0e, 0xffdfe50f, 0xffcdd80f, 0xffbcc41f, 0xff7e7f55, 0xff76795a, 0xff696a64, 0xff6d6b5f, 0xffc7a90b, 0xffe5d800, 0xffe3ea10, 0xffdee712, 0xffcbd715, 0xffbcc51c, 0xff89894d, 0xff73735b, 0xffb7a117, 0xffe3d502, 0xfff0f902, 0xffe2e90f, 0xffd1d711, 0xffbdc21e, 0xff87884c, 0xff7a7c55, 0xff797859, 0xff77725f, 0xff676862, 0xff6d6f5a, 0xff91943d, 0xff808251, 0xff73725e]
				); 
        }
		public function box11():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,1,2,0,1,3,4,5,4,6,7,8,9,10,11,12,13,14,15,16,17,18,19,15,16,1,20,21,17,21,0,21,9,22,21,15,23,0,24,21,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,15,13,25,4,26,27,28,29,30,31,32,33,34,35,36,37,5,38,1,39,18,40,14,19,24,5,41,40,41,42,41,43,8,40,1,8,15,21,15,40,0,19,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,21,44,21,45,46,47,48,49,50,51,52,48,53,54,55,56,57,58,59,60,61,62,63,4,64,21,17,15,0,21,15,10,0,0,15,15,16,8,65,18,0,15,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,66,67,68,69,70,71,72,73,74,50,75,76,77,78,47,79,80,81,82,83,78,51,84,85,86,87,56,88,89,90,91,92,93,94,95,10,0,18,8,41,21,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,17,96,97,98,99,100,101,83,102,78,103,78,104,103,102,77,78,105,102,106,106,47,102,79,107,74,103,108,53,109,110,111,112,113,114,115,116,117,45,118,68,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,119,120,121,122,123,98,124,125,74,47,103,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,74,126,127,28,128,129,130,131,21,66,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,21,4,132,133,134,135,136,102,137,138,49,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,103,103,83,50,126,139,140,141,142,68,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,143,144,145,146,147,148,78,47,149,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,103,103,103,103,103,104,150,151,16,21,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,21,21,152,153,153,154,155,156,157,74,138,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,75,83,83,103,83,50,158,159,2,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,15,160,161,162,145,134,98,163,164,49,103,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,103,103,103,103,77,50,165,166,167,142,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,142,116,168,169,134,170,171,172,173,47,47,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,103,103,74,47,149,102,174,175,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,176,177,172,135,161,162,135,178,179,180,49,165,75,103,107,181,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,107,138,47,127,113,8,182,22,22,21,21,0,0,0,0,0], 
    [0,0,0,0,0,183,184,185,135,147,170,161,186,98,187,47,103,74,103,102,103,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,74,50,52,83,188,38,10,131,40,21,66,0,0,0,0,0], 
    [0,0,0,21,0,189,190,154,153,191,161,161,135,192,193,194,103,103,102,77,47,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,49,80,104,102,72,195,196,8,197,151,38,0,0,0,0,0], 
    [0,0,0,21,41,198,168,134,134,199,134,200,135,98,98,201,77,74,50,47,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,74,77,103,138,107,202,203,18,1,66,15,0,0,0,0,0], 
    [0,0,0,0,8,204,98,205,154,144,122,206,70,134,135,98,207,103,74,208,75,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,209,83,49,103,49,102,52,210,175,196,0,0,0,0,0,0], 
    [8,17,211,212,151,135,135,98,98,98,98,98,98,98,98,98,213,75,107,78,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,83,106,214,21,10,15,0,0,0,19,1], 
    [19,21,215,0,216,135,98,98,98,98,98,98,98,98,98,98,217,218,50,149,51,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,50,83,74,219,220,17,0,21,0,0,0], 
    [0,15,221,0,222,98,98,98,98,98,98,98,98,98,98,98,186,223,79,103,72,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,82,224,225,109,176,19,40,17,15,0,0], 
    [0,0,16,226,227,98,98,98,98,98,98,98,98,98,98,98,168,228,229,103,78,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,72,74,47,138,230,231,16,64,40,1,15], 
    [66,19,0,117,232,98,98,98,98,98,98,98,98,98,98,98,162,134,233,138,72,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,77,103,102,78,78,127,89,234,66,40,0,15], 
    [10,16,13,235,163,98,98,98,98,98,98,98,98,98,98,98,135,236,145,237,238,83,83,103,51,50,103,103,103,50,74,49,47,103,102,83,239,78,103,74,107,103,83,83,83,83,83,77,77,77,77,77,77,77,77,77,77,77,77,240,1,19,8,15], 
    [0,0,19,241,161,98,98,98,98,98,98,98,98,98,98,98,242,162,200,243,208,102,102,47,47,52,239,72,102,102,74,50,79,77,75,83,102,72,50,47,102,51,103,83,83,83,83,77,77,77,77,77,77,77,77,77,77,77,77,244,245,246,247,19], 
    [22,8,68,248,134,98,98,98,98,98,98,98,98,98,98,98,147,249,250,228,251,47,74,50,50,103,75,125,102,149,75,47,103,74,72,74,74,74,74,75,74,102,79,83,83,83,83,77,77,77,77,77,77,77,77,77,77,77,77,51,252,41,197,8], 
    [0,17,253,254,134,98,98,98,98,98,98,98,98,98,98,98,255,170,192,186,256,103,50,102,74,102,74,83,77,103,103,50,83,83,77,181,102,78,78,74,74,77,47,77,77,77,77,83,77,77,77,77,77,77,77,77,77,77,77,50,51,257,220,17], 
    [22,9,117,70,146,98,98,98,98,98,98,98,98,98,98,98,134,135,168,134,156,258,259,260,261,262,263,264,265,266,267,137,149,268,72,269,83,270,79,103,74,47,83,77,77,77,77,83,77,77,77,77,77,77,77,77,77,77,77,103,47,271,272,40], 
    [21,0,273,122,153,98,98,98,98,98,98,98,98,98,98,98,145,135,191,135,274,275,275,276,277,278,277,279,277,279,280,280,281,282,283,284,285,286,287,102,125,288,72,77,77,77,77,83,77,77,77,77,77,77,77,77,77,77,77,78,77,80,289,290], 
    [41,291,184,153,292,98,98,98,98,98,98,98,98,98,98,98,134,161,293,70,294,276,277,295,277,280,295,276,278,280,280,277,276,277,276,276,276,296,276,277,277,276,276,295,297,298,279,299,263,300,301,302,303,77,304,305,47,47,208,80,75,306,47,307], 
    [18,308,309,172,154,98,98,98,98,98,98,98,98,98,98,98,134,217,145,310,311,277,277,276,276,276,276,277,277,276,276,280,276,275,275,296,296,276,296,277,277,277,275,277,296,280,297,275,280,280,277,312,313,314,315,316,317,318,319,320,321,82,322,323], 
    [0,324,325,172,134,98,98,98,98,98,98,98,98,98,98,98,154,217,134,326,275,276,280,280,276,277,277,280,276,277,277,261,276,276,276,276,276,295,277,277,276,276,296,327,275,296,296,313,296,328,276,296,329,330,277,296,296,277,275,331,278,277,332,333], 
    [119,248,168,293,236,98,98,98,98,98,98,98,98,98,98,98,161,135,146,334,276,335,276,276,295,277,261,276,276,277,276,276,277,280,276,277,277,296,313,313,280,275,327,277,276,336,277,277,337,261,296,297,276,261,329,296,297,276,280,336,313,313,313,338], 
    [175,152,217,339,145,98,98,98,98,98,98,98,98,98,98,98,98,134,144,313,275,340,277,341,276,342,343,344,345,346,347,348,349,350,351,352,353,354,355,356,357,279,276,313,313,313,277,277,276,296,277,275,280,275,297,280,329,297,332,329,280,277,279,358], 
    [359,325,98,168,98,98,98,98,98,98,98,98,98,98,98,98,293,134,187,337,276,275,313,261,280,360,361,183,362,115,183,45,363,364,365,366,366,367,368,369,370,371,372,351,352,373,374,375,376,279,377,277,280,313,276,275,297,280,280,276,329,277,378,1], 
    [61,122,135,70,379,98,98,98,98,98,98,98,98,98,98,98,161,155,380,275,280,276,381,279,382,383,384,385,386,387,383,388,389,390,391,392,393,390,394,395,396,397,398,399,399,400,401,402,403,404,405,406,407,408,409,410,295,411,276,261,279,412,413,21], 
    [414,134,186,161,186,98,98,98,98,98,98,98,98,98,98,98,161,155,415,261,416,381,417,418,419,420,421,422,422,422,383,385,423,424,425,426,427,399,428,429,430,390,431,432,431,427,390,433,434,435,429,393,436,436,394,437,332,438,276,296,328,439,440,0], 
    [199,134,168,205,161,98,98,98,98,98,98,98,98,98,98,98,217,441,314,276,276,261,332,124,442,443,386,444,383,445,422,385,446,447,448,435,449,431,433,450,451,393,432,433,393,452,453,428,451,453,454,436,428,390,455,329,417,340,336,456,277,457,68,7], 
    [458,70,161,154,146,98,98,98,98,98,98,98,98,98,98,98,172,459,280,276,280,275,280,460,461,462,386,386,388,385,463,446,387,464,465,466,390,467,393,468,469,390,400,470,471,472,390,399,466,431,398,428,399,403,473,335,280,332,277,296,260,474,19,2], 
    [116,185,153,98,475,98,98,98,98,98,98,191,134,170,476,70,477,337,280,295,276,280,313,478,385,463,388,386,386,386,386,386,385,464,464,479,425,393,393,393,393,393,393,393,393,393,393,393,480,428,393,481,393,482,483,277,381,416,296,484,485,68,22,0], 
    [486,122,146,193,161,98,98,98,98,98,98,135,134,98,217,154,255,280,277,277,276,336,487,488,489,422,421,386,386,386,386,386,489,464,383,490,432,393,393,393,393,393,393,393,393,393,393,393,431,454,491,470,390,492,493,331,280,261,295,377,494,16,495,1], 
    [25,496,497,161,98,98,98,98,98,98,98,217,146,135,134,497,498,276,280,335,275,276,499,446,422,500,385,386,386,386,386,386,501,385,502,503,504,505,505,393,393,393,393,393,393,393,393,393,506,433,450,399,472,373,276,277,296,337,416,507,63,21,10,38], 
    [119,508,509,217,146,98,98,98,98,98,98,134,161,135,135,192,510,277,296,313,296,511,512,513,422,514,489,386,386,386,386,386,422,515,516,446,517,393,393,393,393,393,393,393,393,393,393,393,393,432,394,433,518,519,330,520,520,275,298,521,0,16,2,41], 
    [4,63,522,98,98,98,98,98,98,98,98,161,217,161,172,523,260,277,277,276,296,524,525,386,384,383,421,386,386,386,386,386,526,463,385,527,528,448,471,393,505,393,393,393,393,393,393,393,393,433,428,529,530,276,330,484,531,328,532,10,12,22,8,16], 
    [533,35,534,162,98,98,98,98,98,98,98,191,98,146,186,535,280,296,280,520,275,536,537,489,464,538,514,386,386,386,386,386,489,385,464,539,540,541,448,428,505,393,393,393,393,393,393,393,542,433,393,543,544,332,295,296,298,545,546,13,21,118,547,38], 
    [66,548,115,217,153,98,98,98,98,98,98,144,146,168,98,549,297,277,275,280,330,550,551,489,552,386,383,386,386,386,386,386,386,386,386,386,386,444,553,400,554,432,471,393,393,393,393,393,505,555,393,556,311,296,275,275,296,557,558,0,0,0,0,0], 
    [41,559,486,147,161,98,98,98,98,98,98,153,217,168,192,337,276,297,296,313,560,561,562,563,539,387,386,386,386,386,386,386,386,386,386,386,386,444,564,432,425,429,565,393,393,393,393,393,480,454,566,567,560,295,560,261,296,568,569,0,0,0,0,0], 
    [41,24,15,143,145,98,98,98,98,98,98,161,185,477,570,313,296,571,340,296,572,516,386,515,538,423,573,386,386,386,386,386,386,386,386,386,386,383,574,471,575,471,401,393,393,393,393,393,576,432,577,261,335,484,275,332,279,3,15,0,0,0,0,0], 
    [8,19,18,578,135,98,98,98,98,98,98,146,145,153,579,296,580,275,297,277,581,489,582,387,388,583,444,386,386,386,386,386,386,386,386,386,386,385,464,584,432,398,454,393,393,393,393,393,400,585,586,587,280,588,328,340,378,22,0,0,0,0,0,0], 
    [19,15,15,60,589,98,98,98,98,98,98,135,135,590,591,296,276,276,275,592,593,385,540,594,539,489,422,386,386,386,386,386,386,386,386,386,386,538,444,528,595,505,393,393,393,393,393,393,399,596,352,275,597,296,261,598,599,10,19,0,0,0,0,0], 
    [8,19,0,118,600,147,185,154,98,98,145,242,134,601,298,279,277,332,276,602,603,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,387,489,464,604,605,454,576,398,393,435,433,393,606,607,276,416,277,280,608,609,0,17,0,0,0,0,0], 
    [16,0,15,0,210,172,217,134,172,217,135,70,168,591,610,313,531,280,329,611,612,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,464,613,562,422,614,490,433,615,433,431,393,472,616,261,313,275,313,277,617,533,13,19,0,0,0,0,0], 
    [0,130,220,2,45,206,135,134,293,134,98,168,98,314,277,296,296,456,295,618,619,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,383,619,386,563,620,470,621,393,622,433,399,623,341,624,276,297,278,625,626,627,4,16,0,0,0,0,0], 
    [16,21,628,64,197,629,161,172,161,185,193,135,630,276,560,278,277,631,632,423,573,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,502,501,489,464,385,633,390,390,425,393,634,635,276,340,277,329,313,636,16,182,21,559,0,0,0,0,0], 
    [16,15,64,21,0,637,122,155,70,186,134,477,638,280,295,276,279,580,639,551,540,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,386,385,563,538,574,539,640,393,393,505,471,641,642,278,280,335,279,643,644,12,220,66,24,0,0,0,0,0], 
    [0,0,0,0,0,645,496,134,161,646,191,156,647,313,280,275,277,648,649,464,387,463,422,539,446,385,422,384,489,464,489,619,386,386,386,386,386,386,421,386,422,562,443,650,565,431,555,651,296,275,277,296,297,652,653,13,8,15,16,0,0,0,0,0], 
    [0,0,0,0,0,117,534,654,293,185,172,655,337,261,335,280,313,656,657,444,658,385,387,659,660,386,551,661,385,574,422,444,386,386,386,386,386,514,539,539,422,464,662,663,390,400,664,665,276,275,276,280,327,666,1,66,16,23,21,0,0,0,0,0], 
    [0,0,0,0,0,16,35,205,153,146,135,415,277,277,313,276,332,667,668,386,619,388,489,501,514,669,385,489,444,386,502,386,386,386,386,386,386,388,574,573,444,573,386,670,671,432,672,313,484,279,296,340,673,24,1,15,220,15,21,0,0,0,0,0], 
    [0,0,0,0,0,18,359,185,161,477,145,314,276,277,313,296,277,674,675,422,676,574,385,619,385,386,387,489,463,386,677,489,386,386,386,386,386,678,538,383,385,574,619,527,573,621,679,597,296,275,296,549,680,41,16,220,18,40,64,0,0,0,0,0], 
    [0,0,0,0,0,9,23,309,161,98,179,275,276,276,277,296,329,681,682,683,684,685,686,687,688,689,690,691,692,693,694,695,696,696,696,696,696,697,698,699,700,700,701,702,703,704,354,624,275,261,416,705,706,118,197,0,707,64,15,0,0,0,0,0], 
    [0,0,0,0,0,21,142,708,709,228,710,711,295,276,276,277,276,712,713,714,356,713,715,716,373,656,717,718,373,719,720,372,718,718,718,718,718,721,722,723,724,725,726,727,728,729,597,327,296,280,276,730,245,559,21,1,64,15,21,0,0,0,0,0], 
    [0,0,0,0,0,19,731,308,496,732,733,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,296,296,296,296,296,296,296,296,296,296,296,277,280,261,734,15,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,24,1,183,735,736,260,296,296,296,296,296,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,277,280,336,737,18,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,23,15,210,738,261,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,276,313,313,313,313,313,313,313,313,296,296,296,560,739,740,741,21,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,742,15,743,744,745,356,746,746,746,746,746,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,747,746,746,746,746,746,746,746,746,746,746,746,532,748,749,1,66,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,15,21,197,4,750,65,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,751,0,24,19,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff676767, 0xff666467, 0xff6b6a65, 0xff686765, 0xff686763, 0xff646661, 0xff666469, 0xff676664, 0xff67656a, 0xff676765, 0xff686463, 0xff656567, 0xff656762, 0xff66656b, 0xff666664, 0xff676568, 0xff656565, 0xff656668, 0xff656766, 0xff636564, 0xff666668, 0xff666867, 0xff646665, 0xff656764, 0xff686667, 0xffebe103, 0xfffcc602, 0xfffcc304, 0xfffbc405, 0xfff0b906, 0xffebb703, 0xffcea41a, 0xffb59328, 0xff8f7b46, 0xff6a6a60, 0xff6f6764, 0xff6a6a62, 0xff676662, 0xff686465, 0xff656563, 0xff676566, 0xff656469, 0xff656661, 0xff626763, 0xff6a6964, 0xffd5cd00, 0xffffc700, 0xfffcc300, 0xffffc603, 0xffffc602, 0xfffec400, 0xfffbc500, 0xfffac402, 0xfff8c206, 0xffecb502, 0xffeeb704, 0xffcba418, 0xff9a843b, 0xff776b55, 0xff696a62, 0xff686a5f, 0xff6a6965, 0xff686762, 0xff676769, 0xff65666b, 0xff66656a, 0xff6a6569, 0xff666865, 0xff998830, 0xffccac01, 0xffddca01, 0xffffc803, 0xffffc400, 0xfffec601, 0xfffec600, 0xffffc605, 0xffffc600, 0xffffc502, 0xfffcc700, 0xfffec502, 0xfffec804, 0xffffc800, 0xffffc500, 0xfffcc604, 0xfffac400, 0xfff9c307, 0xfffbc407, 0xffcfa417, 0xffa88d32, 0xff99853c, 0xff6c6865, 0xff6f6860, 0xff6c685f, 0xff6c6764, 0xff6a6869, 0xff656a63, 0xffbfa10b, 0xffccaa00, 0xffd0ab02, 0xfffcc900, 0xfffec506, 0xffffc702, 0xffffc501, 0xfffdc500, 0xfffec504, 0xfffdc703, 0xfffcc601, 0xfffdc202, 0xfffac304, 0xfff0bd02, 0xffe9b404, 0xffcba81a, 0xff9b853c, 0xff998540, 0xff6c6964, 0xff6c6960, 0xff696864, 0xff676863, 0xff646567, 0xff646963, 0xff756e5b, 0xffcaa902, 0xffcaab02, 0xfff3e200, 0xfffdc702, 0xfffdc401, 0xfffcc302, 0xfff5bd04, 0xff787157, 0xff666563, 0xff666465, 0xffa69128, 0xffc8a901, 0xffcbab00, 0xffccaa02, 0xffd9cc01, 0xffffc904, 0xfffec401, 0xffeab203, 0xff67666c, 0xff666560, 0xff636864, 0xffc7a704, 0xffcdab01, 0xffcba901, 0xffcaaa00, 0xffcaac00, 0xffdbca00, 0xfffdc800, 0xff877a4e, 0xff67666b, 0xffc8a805, 0xffccac03, 0xffcbaa03, 0xffcdac00, 0xffcdad02, 0xfffec803, 0xffebb807, 0xff6e6a5e, 0xff696961, 0xffcbab02, 0xffcea903, 0xffcba804, 0xfff8cf01, 0xffffc300, 0xfff8c305, 0xff6a6562, 0xffcaaa01, 0xffcbac00, 0xffcfaa03, 0xffcdaa04, 0xffcea900, 0xffdcdb04, 0xff79715a, 0xff666762, 0xff6a6663, 0xffac961e, 0xffd0aa01, 0xffcdad04, 0xffdada00, 0xffffc401, 0xff68666b, 0xff696863, 0xffc8a704, 0xffcba802, 0xffcea902, 0xffcdad00, 0xffefba08, 0xff857c45, 0xffc9a801, 0xffcca903, 0xffcdab03, 0xffcbaa00, 0xfff8d201, 0xffa58e31, 0xff676661, 0xff646663, 0xffac961f, 0xffcda802, 0xffc7ad00, 0xffdadb01, 0xfff6bc03, 0xff847b50, 0xffc7a707, 0xffcaa800, 0xffcaab03, 0xffdcdc00, 0xffffc801, 0xffffc402, 0xff686961, 0xff66676b, 0xff676966, 0xffd0ae04, 0xff927d44, 0xff636766, 0xff666960, 0xffcba900, 0xfff9cc01, 0xffcca315, 0xff666769, 0xff626667, 0xff686963, 0xffd8e000, 0xffffc505, 0xffffc503, 0xff686964, 0xffb99e13, 0xffcbad00, 0xffd5e200, 0xffd6a910, 0xff6b6a66, 0xffc6a701, 0xffd1b401, 0xff656462, 0xff978833, 0xffcbac03, 0xfff7ce02, 0xffffc301, 0xfffcc802, 0xff6c6d5f, 0xffbfa208, 0xffcda800, 0xffd7e300, 0xffbf9b23, 0xff696a64, 0xff676968, 0xff646569, 0xffc7a802, 0xffc8ac00, 0xffccab04, 0xffd6e300, 0xffe9b308, 0xff696768, 0xffcda704, 0xffceac04, 0xffd2b303, 0xff6a6760, 0xfff6fb00, 0xfff8fd01, 0xfff3fd00, 0xfff3fe00, 0xffebfc00, 0xffeafd01, 0xfffcfb01, 0xfffdf100, 0xffffdf01, 0xffffd302, 0xfffdc904, 0xfffdca00, 0xfffaca00, 0xfff1ba05, 0xff6e6a5f, 0xff81754d, 0xffd5b603, 0xfff4ff01, 0xfff5ff00, 0xfff5ff01, 0xfff6ff02, 0xfff6fd00, 0xfff4fe00, 0xfff1fe01, 0xffe8fe00, 0xfffcfd02, 0xfffdf904, 0xfffde200, 0xffffd707, 0xfffccc00, 0xffffca02, 0xffdaa811, 0xff65666a, 0xff6a675e, 0xffcbac04, 0xffcda801, 0xffede602, 0xfff5fe03, 0xfff4ff00, 0xfff7fe00, 0xfff2fd00, 0xffe8fd00, 0xfffef900, 0xfffffa01, 0xffffe100, 0xfffddf05, 0xfffec901, 0xfffdca01, 0xffffc303, 0xff777254, 0xff6b6861, 0xffc7a505, 0xffd0b300, 0xfff5fc01, 0xfff5fc00, 0xfff3ff00, 0xfff2fd01, 0xfff6fb01, 0xffebfa00, 0xffeafe00, 0xfffff802, 0xfffff300, 0xfffde101, 0xfffed700, 0xfffac902, 0xffecb804, 0xffa38e25, 0xffcaa701, 0xffe8e100, 0xfff3ff01, 0xfff8ff01, 0xfff2ff00, 0xfff5ff02, 0xfff3ff03, 0xfff7fe01, 0xffe7f200, 0xfff3f702, 0xfff6ff01, 0xfff8ff02, 0xfff4fd02, 0xffb9bd20, 0xffcfaa01, 0xfff4ff03, 0xfff5fe05, 0xffd4d90d, 0xffd3d80a, 0xffd3d710, 0xffd4d90b, 0xffe4ee02, 0xffe4ee04, 0xffe4ec03, 0xffe9eb01, 0xfff3f605, 0xfff5f604, 0xfff5f605, 0xfff2f504, 0xfff2f705, 0xfff3f806, 0xfff3f903, 0xfff5f902, 0xff6d6a65, 0xff6b6764, 0xff6f6b5f, 0xff6c6761, 0xff6a6762, 0xff7c5c61, 0xffef0969, 0xfff00965, 0xffe30a99, 0xffad3676, 0xffb23672, 0xffd83315, 0xfff0a204, 0xfffcc705, 0xfff2f506, 0xfff1f604, 0xfff2f707, 0xfff4f805, 0xfff3f905, 0xfff2fb00, 0xfff0fa03, 0xffcea805, 0xffe6de01, 0xfff8fe00, 0xffefd303, 0xff99014a, 0xff9a024f, 0xff97014b, 0xff98004b, 0xff98024a, 0xff98024c, 0xff9e004b, 0xfff0006b, 0xfff5006c, 0xfff4006f, 0xfff0006d, 0xfff1006f, 0xffef0069, 0xffef046b, 0xffef0171, 0xfff2016c, 0xfff0006f, 0xffee006f, 0xffef026e, 0xffeb026b, 0xffee026e, 0xfff10768, 0xfff00669, 0xfff00a6c, 0xffed0a66, 0xffe00897, 0xffdf0b9b, 0xfffce209, 0xfff3ff05, 0xffeffc00, 0xff8f953f, 0xff877f41, 0xfff1f500, 0xfff6ff00, 0xfff9fe02, 0xfff1fa01, 0xffc4670a, 0xff990247, 0xff9a004d, 0xff980049, 0xff99014e, 0xffea016e, 0xfff2006e, 0xffed0269, 0xfff1026a, 0xfff1016e, 0xfff1016c, 0xfff0006c, 0xfff2016a, 0xffee016b, 0xfff1006b, 0xfff3006e, 0xfff10170, 0xffef0170, 0xfff7f407, 0xfff7ff00, 0xffe4eb07, 0xff6a6d62, 0xffe1d300, 0xff9e0847, 0xff95014d, 0xff9a0049, 0xff940249, 0xff9c004c, 0xffaf0048, 0xffec006c, 0xfff40069, 0xfff00167, 0xfff3006a, 0xfff2006d, 0xfff00070, 0xfff00169, 0xffe30a59, 0xfff2fe00, 0xff6b6d5f, 0xffb0981c, 0xfff2f204, 0xffce8908, 0xff9c054a, 0xff990249, 0xff9b004c, 0xff9a004b, 0xffd6015b, 0xffef0068, 0xfff1006a, 0xfff40071, 0xffeb006b, 0xffed006a, 0xffee016d, 0xffef026c, 0xffb2379f, 0xff6a6b66, 0xffc9ab00, 0xffcfaa04, 0xffccac00, 0xff9b0b49, 0xfff00068, 0xffeb026d, 0xffef0066, 0xffdd0b90, 0xfff6f306, 0xfff6fd02, 0xffdde603, 0xff676862, 0xfff5fd00, 0xff9a0849, 0xff970149, 0xffed006e, 0xffed016f, 0xffd93319, 0xfff6f703, 0xff8f9440, 0xff686669, 0xffc6a605, 0xffccab00, 0xffdfcd01, 0xffeff404, 0xff9a024d, 0xff9c004a, 0xff960048, 0xffa6004a, 0xffed006c, 0xfff1006d, 0xfff10268, 0xffb5bf20, 0xffab951d, 0xffc9a900, 0xffebe700, 0xfff4fb00, 0xffdea404, 0xff990048, 0xff980148, 0xff9b014a, 0xff96034a, 0xffc50251, 0xffed0b6d, 0xfff7fd05, 0xfff6fe00, 0xff6c6c62, 0xffc7a706, 0xffd9c701, 0xfff1f403, 0xff9d1070, 0xff9a024b, 0xff93014a, 0xff9c014d, 0xfff30168, 0xffda3515, 0xfff9ff01, 0xffeff904, 0xff696566, 0xffad941e, 0xffebe200, 0xffefd101, 0xff9b094a, 0xff98004d, 0xff99014c, 0xff95014b, 0xffea006a, 0xffee0267, 0xffe50b59, 0xfff0ef00, 0xfff6fc00, 0xffdbe508, 0xff666863, 0xff686868, 0xfff3fc01, 0xff8e1e80, 0xff980249, 0xff9d004a, 0xffe40061, 0xfff20069, 0xfff10067, 0xfffada0b, 0xffe4ed06, 0xff676d5f, 0xff67646b, 0xfff3fe02, 0xff9e0848, 0xff970148, 0xff970047, 0xffb7014e, 0xfff20070, 0xfff00271, 0xfff4f406, 0xffb5bb23, 0xff6d6966, 0xffd4bd00, 0xfff4fd04, 0xffeef706, 0xff9a0048, 0xff970048, 0xfff0006a, 0xfff3006c, 0xffe20b59, 0xffad951b, 0xffe6dc00, 0xfff4ff05, 0xfff1ed05, 0xff9b0048, 0xff96004a, 0xffd3015c, 0xffed016d, 0xffb23c70, 0xfff1ff05, 0xfff8ff00, 0xffc3a505, 0xffd4b502, 0xfff2fc00, 0xfff1f703, 0xff922d4f, 0xff9b0149, 0xffd6005c, 0xffce21a1, 0xfff8fd03, 0xfff1fa03, 0xff909541, 0xffae941d, 0xffdfd400, 0xffecf401, 0xff9f0c5d, 0xffa3014a, 0xffef006a, 0xffe5740a, 0xfff5fa00, 0xffe4ec05, 0xff6b6b5f, 0xfff5ff04, 0xffa72026, 0xff9d0148, 0xff98014e, 0xffea016a, 0xffec006e, 0xfff2f804, 0xff6d705d, 0xff9f0d72, 0xff97004d, 0xffc70150, 0xffee0169, 0xffed026b, 0xffee0a6c, 0xfffafd00, 0xfff3fc03, 0xff676d61, 0xff686369, 0xff666761, 0xffc9a604, 0xffd1b400, 0xfff2ff02, 0xfff3f300, 0xffc0024c, 0xfff00468, 0xffe57509, 0xffdde305, 0xffab9420, 0xffe0ce02, 0xfff0f503, 0xffa1004e, 0xffe60966, 0xfff2f206, 0xfff1f906, 0xff909640, 0xff6c6962, 0xffcbad01, 0xfff1f800, 0xfff4f801, 0xffc46708, 0xffe1005e, 0xfffdda0f, 0xffb6be1d, 0xff6c6763, 0xffc9aa02, 0xffdbc500, 0xffeff704, 0xff83296f, 0xff94024b, 0xff940148, 0xff980051, 0xff960047, 0xff9b004e, 0xffb3014b, 0xffeb0370, 0xfff0f807, 0xff706c61, 0xffd18607, 0xff9b0648, 0xff950248, 0xff9b004b, 0xffad0250, 0xffe20b69, 0xfff2f802, 0xff882c5f, 0xff93004e, 0xff9a0348, 0xff9c014f, 0xff930047, 0xffc52f48, 0xffdde504, 0xffb8390c, 0xffb93409, 0xffbb3405, 0xffb93109, 0xffb83306, 0xffb7340a, 0xffb93205, 0xff902a52, 0xff852771, 0xff852775, 0xff802970, 0xff872675, 0xff83266d, 0xff822776, 0xff9d0947, 0xff9b0948, 0xff9e094d, 0xff9b0947, 0xff990746, 0xff990947, 0xff9b0a45, 0xff9c0548, 0xff9c094f, 0xff9d3479, 0xffe2eb04, 0xff6a6c5f, 0xff646464, 0xffad9322, 0xffc9aa01, 0xffd6bd01, 0xfff6ff04, 0xfff0f900, 0xfff2f800, 0xfff2f900, 0xfff3f700, 0xfff4f900, 0xfff0f805, 0xfff2f603, 0xfff0f804, 0xffeff703, 0xfff0f602, 0xfff6f101, 0xfff0c306, 0xfff0c401, 0xffedc501, 0xfff3c204, 0xffedc504, 0xffeec302, 0xfff2e302, 0xffb8bb26, 0xff666561, 0xffceae01, 0xfff2f101, 0xff6a6c61, 0xffb0961f, 0xffd3b600, 0xffeffa00, 0xffecea00, 0xfff0fa06, 0xff8e9640, 0xff65685f, 0xff65646a, 0xff656364, 0xff6d6865, 0xfff0f505, 0xfff0fa05, 0xffeffb05, 0xffe0eb08, 0xff6b6c64, 0xff696564, 0xff686367]
				); 
        }
		public function box12():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,5,6,7,8,9,5,4,1,10,11,0,12,0,0,13,0,1,14,15,16,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,10,5,18,4,19,20,21,22,23,24,23,25,26,27,28,0,15,12,11,29,12,0,14,30,1,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,12,0,16,4,0,31,32,33,23,34,35,34,35,36,37,38,1,12,3,39,12,1,13,17,18,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,40,12,1,5,41,42,43,44,45,36,46,35,36,47,48,47,49,36,50,51,14,1,39,16,52,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,4,3,28,53,32,54,55,56,57,58,24,23,46,49,7,24,24,23,35,23,59,60,61,17,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,18,0,18,62,63,43,64,65,66,36,48,48,48,48,48,48,48,48,48,48,48,46,23,35,67,68,69,19,4,70,4,14,71,0,72,12,19,1,10,10,14,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,73,13,74,56,56,55,75,76,77,49,48,48,48,48,48,48,48,48,48,48,48,47,35,36,46,36,78,79,0,80,81,0,28,17,18,1,1,12,1,1,1,12,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,15,0,44,82,82,75,83,64,32,57,48,48,48,48,48,48,48,48,48,48,48,46,48,47,48,23,49,35,36,84,85,86,11,14,28,5,87,0,14,12,14,71,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,88,0,89,65,32,76,75,75,90,91,48,48,48,48,48,48,48,48,48,48,48,58,34,24,49,34,35,23,49,92,23,93,94,95,1,19,73,4,1,0,19,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,96,56,64,63,56,64,64,56,21,97,48,48,48,48,48,48,48,48,48,48,48,92,98,49,36,35,36,24,35,49,49,46,35,7,46,23,99,100,12,101,102,2,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,103,56,21,104,65,105,65,89,44,106,48,48,48,48,48,48,48,48,48,48,48,34,36,24,23,107,47,48,23,23,57,98,107,35,34,34,35,46,108,109,70,19,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,13,110,14,0,16,0,41,111,112,113,21,32,114,21,21,21,34,49,46,107,45,34,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,36,49,115,46,116,1,0,0,4,102,1,0,0,0,0,0], 
    [0,0,0,0,0,14,0,12,13,2,117,111,64,90,64,64,21,64,118,75,44,24,34,49,46,36,46,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,49,49,46,92,119,12,12,1,2,12,0,0,0,0,0,0], 
    [0,0,0,0,0,87,0,16,120,111,75,44,90,42,21,54,56,56,21,121,56,122,34,34,46,57,24,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,36,48,24,48,36,123,28,69,1,4,124,0,0,0,0,0], 
    [0,0,0,0,0,1,5,12,71,82,65,125,56,21,126,21,56,44,21,56,44,127,49,107,35,24,107,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,35,24,34,57,128,2,17,12,73,10,12,0,0,0,0,0], 
    [0,0,0,0,0,13,5,0,129,76,56,75,64,130,21,75,75,75,65,43,64,56,131,45,34,23,132,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,36,23,48,24,46,133,12,71,12,12,0,0,0,0,0,0], 
    [134,18,1,12,0,16,13,20,64,21,135,21,21,21,21,21,21,21,21,21,21,114,136,24,49,35,23,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,23,137,1,0,3,4,0,0,0,0,0], 
    [18,138,1,0,12,12,10,89,55,32,65,21,21,21,21,21,21,21,21,21,21,63,118,92,24,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,34,139,15,0,18,19,0,0,0,0,0], 
    [1,1,16,1,1,16,2,42,121,65,121,21,21,21,21,21,21,21,21,21,21,89,56,46,23,49,92,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,34,35,4,138,140,141,0,0,0,0,0], 
    [12,0,1,13,12,142,65,64,65,75,55,21,21,21,21,21,21,21,21,21,21,65,75,49,23,47,36,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,143,24,144,70,4,145,0,0,0,0,0], 
    [0,12,1,12,72,146,64,147,56,75,56,21,21,21,21,21,21,21,21,21,21,64,82,148,107,36,35,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,149,7,150,145,1,12,0,0,0,0,0], 
    [16,3,0,151,152,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,121,153,154,107,34,46,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,35,49,48,155,0,0,0,0,0,0,0], 
    [71,138,4,1,156,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,56,114,56,157,35,23,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,23,35,132,158,14,0,0,0,0,0,0], 
    [0,10,15,159,56,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,160,161,34,107,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,49,162,47,163,19,1,0,0,0,0,0], 
    [73,19,28,44,56,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,32,65,56,164,36,23,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,23,47,23,24,165,5,0,0,0,0,0], 
    [12,166,167,121,168,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,32,56,75,42,98,36,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,34,162,48,35,169,16,0,0,0,0,0], 
    [0,0,21,56,76,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,121,118,75,55,170,47,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,92,23,23,24,171,172,0,0,0,0,0], 
    [0,173,121,118,44,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,75,174,175,176,46,34,57,170,35,46,177,143,107,178,34,36,46,23,23,35,36,48,48,48,48,48,48,48,48,48,48,35,24,46,107,179,180,73,2,4,5,4], 
    [1,63,21,75,56,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,64,64,118,181,182,36,57,23,36,57,49,34,143,107,35,24,23,34,34,35,107,48,48,48,48,48,48,48,48,48,48,36,107,7,7,183,36,14,0,30,0,184], 
    [1,185,114,21,64,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,56,65,65,186,187,188,189,190,191,192,193,23,163,23,23,48,46,46,24,57,46,49,48,48,48,48,48,48,48,48,48,48,46,57,36,35,46,49,194,3,0,70,16], 
    [5,195,44,112,44,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,64,55,168,196,187,197,198,189,188,199,188,191,200,201,24,163,35,49,23,34,36,47,48,48,48,48,48,48,48,48,48,48,36,48,36,92,34,34,202,19,1,0,123], 
    [13,203,75,42,64,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,56,32,204,205,206,205,187,207,197,187,188,208,205,207,197,197,209,210,211,128,49,35,48,48,48,48,48,48,48,48,48,48,46,57,46,107,23,48,23,212,0,19,4], 
    [1,5,21,56,147,21,21,21,21,21,21,21,21,21,21,21,75,75,63,153,64,105,121,207,208,205,197,187,187,187,207,187,190,213,187,187,188,191,206,188,214,215,107,57,36,23,107,23,36,23,34,7,107,216,23,36,34,7,34,23,217,0,2,5], 
    [0,73,75,64,56,21,21,21,21,21,21,21,21,21,21,21,44,64,64,174,21,218,207,207,187,197,207,197,219,206,187,188,220,219,197,207,221,220,220,222,205,187,197,197,187,223,224,35,36,23,35,35,36,35,35,163,24,46,170,225,34,70,5,19], 
    [0,1,226,32,63,21,21,21,21,21,21,21,21,21,21,21,121,147,64,126,153,227,228,187,197,188,229,197,230,231,187,220,187,205,220,219,219,197,187,232,220,188,197,187,220,233,234,235,191,236,178,107,45,24,49,57,23,23,7,35,49,237,123,14], 
    [0,1,238,64,21,21,21,21,21,21,21,21,21,21,21,21,111,118,56,239,240,188,187,219,188,197,207,241,242,242,243,244,245,246,247,187,228,188,248,207,249,220,187,234,207,207,205,208,206,188,191,220,191,250,251,46,49,24,34,57,57,252,19,73], 
    [16,0,253,21,21,21,21,21,21,21,21,21,21,21,21,21,75,90,32,254,255,220,207,228,197,207,205,256,242,242,257,258,259,260,261,262,246,263,197,220,264,233,265,220,197,187,197,232,220,187,220,188,205,208,188,266,267,45,268,36,23,269,270,53], 
    [0,12,73,64,75,21,21,21,21,21,21,44,82,42,64,64,65,63,90,205,189,220,197,188,219,271,272,256,256,256,256,256,256,261,273,274,274,275,274,276,277,278,279,188,207,188,187,205,197,197,228,205,219,207,188,188,207,219,234,220,280,281,282,16], 
    [12,1,110,21,147,21,21,21,21,21,21,42,56,56,21,44,44,56,283,208,219,213,220,191,221,284,285,256,256,256,256,256,256,286,274,277,287,286,286,288,289,274,274,290,291,292,220,207,187,197,187,197,187,222,207,208,197,265,187,232,293,233,294,0], 
    [295,13,1,21,42,21,21,21,21,21,21,63,21,42,135,21,56,296,297,207,220,206,265,187,298,242,242,256,256,256,256,256,299,273,262,286,261,274,276,275,274,300,301,302,274,287,276,286,303,304,305,187,188,188,207,306,307,197,308,191,197,309,12,5], 
    [0,0,18,44,21,21,21,21,21,21,21,56,44,135,21,82,105,220,197,220,187,187,188,310,311,312,312,256,256,256,256,256,256,313,314,287,276,315,276,288,302,316,286,286,276,317,318,261,287,316,274,319,320,321,322,220,232,187,188,220,187,134,12,0], 
    [1,1,16,76,56,21,21,21,21,21,21,75,56,21,147,323,324,188,325,207,249,206,207,299,242,326,327,256,256,256,256,256,312,328,260,314,287,261,289,315,277,315,317,287,301,274,286,274,318,318,317,329,330,208,265,232,205,207,219,331,138,3,145,73], 
    [12,12,1,44,75,21,21,21,21,21,21,32,56,82,332,333,197,187,265,207,205,208,334,335,336,256,256,256,256,256,256,256,256,337,338,286,314,276,276,301,317,276,274,276,316,314,274,274,317,277,276,339,340,205,208,205,187,265,187,341,3,1,4,18], 
    [341,10,0,342,65,21,21,21,21,21,21,44,82,64,44,197,188,219,213,189,207,343,344,345,257,337,299,256,256,256,256,256,258,258,346,347,276,274,274,274,274,274,274,276,274,277,314,287,260,276,274,213,265,187,297,213,207,348,349,17,0,0,13,0], 
    [350,0,0,351,114,21,21,21,21,21,21,64,105,42,352,234,325,187,265,220,219,258,353,354,355,356,312,256,256,256,256,256,312,272,357,318,276,274,274,274,274,274,274,274,318,287,286,277,276,358,359,187,197,187,248,249,187,360,12,0,11,1,0,0], 
    [16,14,0,361,362,21,21,21,21,21,21,56,75,363,188,187,197,188,187,364,365,256,327,312,312,258,356,256,256,256,256,256,335,312,256,274,276,274,274,274,274,274,274,277,287,277,262,288,301,366,222,187,213,219,187,220,367,19,0,0,1,368,12,145], 
    [369,0,1,5,55,21,21,21,21,21,21,21,90,233,234,197,234,370,264,371,372,256,335,242,256,312,373,256,256,256,256,256,242,344,242,317,286,274,274,274,274,274,274,314,286,262,374,375,376,207,188,207,208,197,197,377,151,14,1,13,0,12,12,11], 
    [15,378,5,379,44,21,21,21,21,21,21,380,381,187,188,208,206,205,382,383,384,242,299,385,256,384,256,256,256,256,256,256,256,386,387,388,287,274,274,274,274,274,274,287,277,288,375,389,390,187,197,187,220,187,391,0,16,1,4,0,0,145,11,16], 
    [1,10,12,3,392,75,75,56,21,64,21,393,197,308,219,220,206,394,395,242,344,256,256,256,256,256,256,256,256,256,256,256,242,242,396,397,317,274,274,274,274,274,274,398,399,274,274,400,205,187,207,401,197,402,403,12,145,1,0,0,0,0,0,0], 
    [18,4,5,151,404,55,42,75,405,118,406,220,187,220,407,188,207,384,327,258,242,256,256,256,256,256,256,256,256,256,256,256,312,299,258,344,408,274,274,274,274,274,274,303,286,316,305,206,207,188,207,308,197,0,409,4,368,0,0,0,0,0,0,0], 
    [0,18,1,1,410,118,174,411,56,42,412,190,205,188,265,197,413,336,384,335,396,256,256,256,256,256,256,256,256,256,256,256,414,415,256,242,416,274,274,274,274,274,274,274,286,417,187,187,221,205,233,265,418,12,18,1,71,12,0,0,0,0,0,0], 
    [73,71,145,5,19,56,118,21,83,188,219,325,205,207,207,298,242,256,326,354,242,256,256,256,256,256,256,256,256,256,256,256,243,242,312,337,384,274,274,274,274,274,274,398,419,213,220,187,232,187,187,19,11,14,1,5,0,1,0,0,0,0,0,0], 
    [14,0,71,11,71,21,56,75,420,220,205,221,208,206,325,421,299,256,396,422,423,256,256,256,256,256,256,256,256,256,256,256,243,299,258,424,258,274,274,274,274,274,274,425,426,197,188,265,188,220,427,0,4,1,4,12,4,14,0,0,0,0,0,0], 
    [110,0,17,110,10,75,65,428,197,234,187,188,205,188,429,242,258,299,396,299,430,242,312,256,256,336,242,285,414,242,326,256,258,356,312,387,337,431,432,301,286,314,301,264,228,188,219,205,188,433,102,102,1,0,0,0,0,0,0,0,0,0,0,0], 
    [14,70,151,13,40,63,111,434,187,197,435,197,205,197,436,437,438,430,384,353,383,299,335,383,243,243,384,439,335,385,383,384,440,387,256,441,285,442,276,315,289,274,443,207,208,207,187,187,197,10,13,5,134,0,0,0,0,0,0,0,0,0,0,0], 
    [0,14,151,4,3,106,444,197,207,234,206,197,219,197,187,308,187,220,197,264,220,445,446,387,447,384,257,257,242,415,383,336,337,242,257,242,256,448,301,374,274,449,207,188,205,219,219,450,451,16,1,53,18,0,0,0,0,0,0,0,0,0,0,0], 
    [0,5,19,12,40,452,265,198,249,207,191,232,208,249,189,197,188,234,197,205,232,232,188,187,453,454,455,258,243,335,242,258,383,312,336,242,242,258,456,457,287,188,197,264,308,220,213,295,458,4,12,12,12,0,0,0,0,0,0,0,0,0,0,0], 
    [12,4,379,102,110,0,0,3,459,460,461,197,187,190,197,207,205,462,233,197,187,187,197,221,187,187,197,197,187,220,207,463,464,465,243,243,466,335,467,468,197,469,233,206,187,470,360,12,4,40,10,123,70,0,0,0,0,0,0,0,0,0,0,0], 
    [13,19,14,12,295,4,0,10,12,14,12,360,471,472,473,187,187,207,189,205,249,233,187,220,233,189,220,233,205,197,197,207,234,188,474,475,476,242,335,207,191,206,207,208,325,477,1,0,5,478,0,102,5,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,12,0,0,0,4,70,30,479,480,481,207,188,206,206,188,207,220,207,187,249,188,197,187,233,191,219,197,207,220,188,220,206,187,482,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,12,1,5,102,12,19,4,3,17,483,484,485,486,205,188,207,188,187,208,187,197,187,220,187,187,205,229,190,264,197,191,487,0,0,0,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,12,5,0,0,4,10,3,5,151,0,0,15,3,102,16,488,12,4,489,490,219,205,187,187,188,233,207,234,191,208,249,491,19,5,17,28,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,1,1,0,16,73,145,53,0,5,11,2,1,16,12,13,1,12,16,1,12,1,477,367,492,207,187,197,188,187,191,493,494,0,12,73,102,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,5,0,19,16,14,12,0,1,0,4,1,1,1,1,3,0,16,10,70,12,70,1,488,0,0,14,4,495,496,19,5,12,1,10,4,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666668, 0xff696566, 0xff656764, 0xff676566, 0xff656766, 0xffc9a900, 0xfffec400, 0xffbf9d21, 0xff7f7456, 0xff676664, 0xff676765, 0xff666664, 0xff676767, 0xff656668, 0xff666465, 0xff656565, 0xff656567, 0xff676769, 0xff676568, 0xff716b5b, 0xffccaa00, 0xffd6e300, 0xffffc501, 0xffffc502, 0xffffc803, 0xffddad0d, 0xff8d7947, 0xff676863, 0xff646464, 0xff666865, 0xffba9f12, 0xffcaaa01, 0xffd4c301, 0xfffec601, 0xffffc702, 0xffffc700, 0xffd9ad0c, 0xff9a813e, 0xff67666b, 0xff65666a, 0xffcfa900, 0xffcca903, 0xffcaab02, 0xffcba901, 0xffffc402, 0xfffec600, 0xfffec502, 0xffffc600, 0xffffc500, 0xffeab300, 0xffa78e34, 0xff6a6665, 0xff666563, 0xffcdac00, 0xffcea902, 0xffccaa02, 0xffffc603, 0xfffcc602, 0xffe7b604, 0xffb4932c, 0xff666863, 0xffba9d13, 0xffcba900, 0xffcbab02, 0xffcea900, 0xfff4e003, 0xffedb603, 0xffb29329, 0xff67656a, 0xff686667, 0xff666769, 0xff666469, 0xff666867, 0xff7a7150, 0xffcbab00, 0xffcba802, 0xffd3e902, 0xfff0ba00, 0xffc09c21, 0xff696468, 0xff646869, 0xffcdab01, 0xffcba804, 0xfffbc501, 0xfff3be00, 0xffc29c1f, 0xff686465, 0xff626667, 0xffcda801, 0xffccab00, 0xffeded00, 0xfffdc702, 0xfffcc802, 0xfff8bd00, 0xffdcac0a, 0xff7b734f, 0xffd2c500, 0xffffc401, 0xfff8bf00, 0xffdbab09, 0xff656366, 0xff646567, 0xffc9aa02, 0xffc8ac03, 0xffcea903, 0xffcfaa03, 0xffffc602, 0xfff9c300, 0xffe9b402, 0xff646665, 0xffcaa902, 0xffcaa800, 0xffcaac00, 0xffccac03, 0xffffc605, 0xffaa8a33, 0xffaf971d, 0xffcaaa00, 0xffebb701, 0xff646466, 0xffcda800, 0xffd6e601, 0xff636766, 0xff65666b, 0xffcbad01, 0xffcfaa01, 0xffd6ce01, 0xfffdc500, 0xffb2961b, 0xffceaa00, 0xffebee01, 0xfffec401, 0xffeeb702, 0xff666467, 0xffcdab03, 0xffd9e200, 0xff7f7752, 0xff66656a, 0xfff7be00, 0xff6a6569, 0xff636864, 0xff6e6c5d, 0xfffcc601, 0xff7e7451, 0xff656563, 0xffc1a506, 0xffcbaa03, 0xfff2e501, 0xfffdc703, 0xffdbae0d, 0xff686765, 0xff626665, 0xffc9aa01, 0xffd4c400, 0xffb3922b, 0xff998731, 0xfff9cc00, 0xfff1b900, 0xffbc9d0f, 0xffc9ab00, 0xffdbe000, 0xfffec803, 0xfffcc700, 0xffd4ba01, 0xff69676a, 0xff68686a, 0xff8e813b, 0xffcbac04, 0xffefb900, 0xfffdc800, 0xffffc800, 0xff827457, 0xffc8a901, 0xffcda802, 0xffcbac03, 0xfff4e601, 0xfffdc401, 0xfffbc500, 0xffffc801, 0xfff9c500, 0xffe4ec01, 0xfffff000, 0xffffc404, 0xff626763, 0xffb99c14, 0xffceb002, 0xfff5ff00, 0xfff4ff01, 0xfff8ff01, 0xfff3fe02, 0xfff2ff00, 0xffe9fe01, 0xffffdf02, 0xff7e764f, 0xffab971e, 0xffefe802, 0xfff5ff01, 0xfff3ff03, 0xfff6fd02, 0xfffef502, 0xfffeda02, 0xffddab0c, 0xff78744f, 0xfff2fb04, 0xfff3ff00, 0xfff7fe01, 0xfff4ff00, 0xfff7fe00, 0xffeaff00, 0xfff7fb04, 0xfffcd000, 0xffb2922b, 0xfff6ff02, 0xffedfd04, 0xffffe102, 0xffffc503, 0xfff4bd00, 0xffd7c002, 0xfff3fe00, 0xfff4fe00, 0xfff7ff00, 0xfff8fd01, 0xfff0fd00, 0xfffcf700, 0xfffcc604, 0xffbd9e12, 0xfff3f800, 0xfff8fe00, 0xfff5fe05, 0xffd58804, 0xfff3dd00, 0xfff3ff01, 0xfff4ff03, 0xfff5fe03, 0xffeffe01, 0xffffd502, 0xff6f6c5b, 0xff8e7f3e, 0xffcca905, 0xffdbc500, 0xff9c0061, 0xff980049, 0xff97004a, 0xff980150, 0xffd9005b, 0xffdf02a0, 0xffa9307d, 0xfff3fc01, 0xfff4fd02, 0xfffffc00, 0xfffee002, 0xfff6bf02, 0xff787353, 0xffceae01, 0xfff6fb01, 0xff98004b, 0xff9b004e, 0xff970149, 0xffb90048, 0xffed006a, 0xfff1016c, 0xffee016b, 0xffffcb01, 0xfff6ff01, 0xfff6fd00, 0xffebff00, 0xfffff500, 0xfffec506, 0xffffc400, 0xff897b4a, 0xfff4dc00, 0xff9a0048, 0xffed006c, 0xfff0006d, 0xffef026c, 0xfff0006b, 0xfff00169, 0xffc617b0, 0xffbc244a, 0xffefff00, 0xfffde700, 0xfffccb04, 0xffd4bb00, 0xff9a067e, 0xff97004d, 0xfff1006b, 0xfff1006d, 0xfff1006f, 0xfff1016e, 0xffe1005c, 0xffc71ab1, 0xfffdcc03, 0xfff7fc00, 0xffeaf400, 0xff666762, 0xffe9dc01, 0xfff5ff04, 0xffd18900, 0xff9a004b, 0xffef0170, 0xfff10069, 0xfff0036d, 0xfff2016a, 0xffa72fab, 0xffd4290d, 0xfff7fd05, 0xfff6ff08, 0xfff8ff02, 0xff8d9240, 0xfff7eb00, 0xff9b0062, 0xff97014b, 0xffd3015c, 0xfff2016c, 0xffef026e, 0xfff0006f, 0xfff2006e, 0xffee016d, 0xffe3006c, 0xffa62cb2, 0xfffee705, 0xfff3fc05, 0xffcbad00, 0xfff1e803, 0xfff7fe03, 0xff970148, 0xff9b014a, 0xff9e0146, 0xfff1026a, 0xffe30059, 0xffe2ea01, 0xffcaa904, 0xffe0c504, 0xfff1ca01, 0xff9a0049, 0xff98024a, 0xff99014a, 0xffe20064, 0xffee006f, 0xffd32910, 0xff646663, 0xffc2a404, 0xff7e2263, 0xff95014b, 0xff9c004c, 0xffb0004b, 0xfff3006e, 0xfff2fb00, 0xff8d9145, 0xff696564, 0xffb99e13, 0xffe7d803, 0xff9a004d, 0xff960047, 0xff940145, 0xff970048, 0xff99034a, 0xfff3026d, 0xffe00084, 0xff8d9242, 0xff827b44, 0xffccab04, 0xfff6f602, 0xfffcfd02, 0xff8b1689, 0xffe27300, 0xffd4da08, 0xff656661, 0xff636768, 0xfff4fd04, 0xff9f1522, 0xff96004c, 0xff96024c, 0xfff10170, 0xfff20067, 0xfff10071, 0xffe2ec02, 0xff686763, 0xff676662, 0xffcdaf01, 0xfff8fa01, 0xfff7ec00, 0xff9b004c, 0xff98004d, 0xff960048, 0xff980146, 0xff99014c, 0xffc70150, 0xffe40385, 0xfffef802, 0xffe9f402, 0xffc5a407, 0xfff0ea02, 0xfff2ff02, 0xff7f1f79, 0xff98024c, 0xffaa0047, 0xfff20070, 0xfff2006d, 0xfffdf701, 0xfff5ff02, 0xfff1fc00, 0xff8f9044, 0xff93803c, 0xffccac00, 0xffd2b404, 0xfff5ff06, 0xffd40057, 0xff646661, 0xff857b46, 0xffcaab03, 0xfff4f400, 0xfffafc03, 0xff99014e, 0xff980148, 0xffb6004a, 0xff9f2d8c, 0xffd5db09, 0xffe20185, 0xffcfaf02, 0xff9b005e, 0xff9b0149, 0xff970246, 0xff980249, 0xffe4015a, 0xfffecb00, 0xffebf500, 0xffdbc402, 0xffa21526, 0xff950249, 0xffe90069, 0xfff2006b, 0xff8d903f, 0xfff3fc03, 0xfff6ff00, 0xfff0c900, 0xff8d2354, 0xff8d168a, 0xff9a034a, 0xff9a024d, 0xff9b0049, 0xffd10058, 0xffaa2cb1, 0xffe2d300, 0xffce8900, 0xffa31724, 0xff9c014d, 0xffa2004c, 0xfffde805, 0xffe1e900, 0xff6a6464, 0xffd5bb02, 0xfff3db00, 0xff9f1524, 0xff7d2176, 0xffdd0060, 0xffef0368, 0xff646867, 0xff8e9144, 0xffe0e800, 0xffe9f100, 0xfff3fd00, 0xffe2a900, 0xffb82c08, 0xff9e005f, 0xff96034a, 0xffa7014b, 0xffa82cae, 0xfff6fe00, 0xfff2fb02, 0xffb9bd20, 0xffe7f200, 0xfff1fa01, 0xfffaea00, 0xffb82f05, 0xff7e2368, 0xff8d9041, 0xff686669, 0xff73735b, 0xffd2dc0a, 0xffe8f000, 0xffd2db06, 0xff74735e, 0xff9ea234, 0xffe3eb02, 0xffebf501, 0xffe3eb00, 0xff656762, 0xffb8be1e, 0xffdee700, 0xffebf700, 0xffeaf103, 0xfff2fc00, 0xff8a9143, 0xff9ba137, 0xffd2db08]
				); 
        }
		public function box13():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,1,3,4,5,6,7,8,9,10,7,11,0,12,12,12,13,0,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,14,0,12,15,11,2,0,16,17,18,19,20,21,22,0,23,24,25,0,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,0,11,0,26,27,28,9,29,30,31,32,33,34,26,35,0,26,0,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,12,11,7,4,35,36,37,9,38,18,39,40,41,42,41,41,43,0,27,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,15,0,4,23,44,45,30,46,18,47,39,48,33,41,49,32,50,51,27,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,53,52,12,26,11,23,23,7,54,55,46,46,46,46,46,46,39,42,56,42,19,42,57,58,32,59,13,60,35,61,0,12,24,62,63,23,52,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,12,0,23,7,27,25,15,64,30,46,46,46,46,46,46,42,56,65,49,31,41,66,67,39,41,68,69,61,70,62,35,12,0,14,60,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,7,71,25,23,0,26,28,72,30,37,46,46,46,46,46,46,42,73,56,74,57,56,75,74,56,73,73,32,76,77,78,0,12,35,0,52,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,23,26,52,79,7,27,80,18,81,46,46,46,46,46,46,46,74,82,83,48,84,73,40,31,56,42,48,42,65,84,85,0,23,23,52,12,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,70,23,86,0,87,88,18,89,30,18,46,46,46,46,46,46,90,57,48,91,41,31,73,92,57,31,73,91,75,41,65,41,93,26,14,11,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,94,52,95,27,38,18,96,30,46,96,46,46,46,46,46,46,97,48,41,39,42,42,98,39,56,56,73,99,65,100,49,42,41,101,23,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,102,86,11,24,0,27,103,104,30,9,46,46,46,46,46,46,46,46,46,46,46,105,73,41,39,31,73,73,73,73,73,73,73,73,73,73,73,106,107,108,109,13,12,27,23,24,0,12,52,102,27,5,12,0,0,0,0,0], 
    [0,0,0,0,0,27,26,110,111,7,71,12,112,46,113,18,46,46,46,46,46,46,46,46,46,46,46,114,39,73,74,41,73,73,73,73,73,73,73,73,73,73,73,74,39,41,41,115,116,23,7,62,24,11,62,35,117,4,0,0,0,0,0,0], 
    [0,0,0,0,0,79,26,15,102,24,12,80,104,104,37,45,46,46,46,46,46,46,46,46,46,46,46,118,74,31,39,41,73,73,73,73,73,73,73,73,73,73,73,41,65,119,19,33,48,120,121,70,15,52,60,122,23,7,27,0,0,0,0,0], 
    [0,0,0,0,0,26,110,23,2,95,123,46,124,37,124,18,46,46,46,46,46,46,46,46,46,46,46,125,32,48,56,39,73,73,73,73,73,73,73,73,73,73,73,32,48,73,75,65,42,20,73,126,11,62,23,127,0,60,23,0,0,0,0,0], 
    [0,0,0,0,0,24,63,13,35,46,81,128,37,81,124,89,46,46,46,46,46,46,46,46,46,46,46,18,56,31,56,73,73,73,73,73,73,73,73,73,73,73,73,129,41,48,56,31,41,39,57,91,65,130,43,23,12,12,27,0,0,0,0,0], 
    [4,71,35,23,7,111,12,131,30,9,132,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,37,133,65,42,65,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,39,134,0,0,0,52,0,0,0,0,0], 
    [0,2,1,11,52,26,135,136,88,9,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,38,137,41,39,39,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,56,129,0,2,11,27,0,0,0,0,0], 
    [5,11,26,138,2,139,17,47,37,9,132,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,9,140,48,41,31,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,74,91,13,0,12,141,0,0,0,0,0], 
    [14,70,7,63,142,88,143,46,96,144,124,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,18,145,41,39,49,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,41,129,146,7,26,12,0,0,0,0,0], 
    [0,15,61,147,30,148,143,46,9,38,18,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,149,150,42,74,19,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,56,151,15,0,152,0,0,0,0,0], 
    [0,0,0,46,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,37,118,48,65,57,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,41,83,65,52,11,15,0,0,0,0,0], 
    [0,0,0,46,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,30,153,39,39,19,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,31,42,65,154,52,0,0,0,0,0,0], 
    [0,0,0,46,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,17,30,41,48,83,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,58,42,73,155,62,0,0,0,0,0,0], 
    [0,0,0,46,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,30,29,74,33,41,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,56,39,156,26,2,0,0,0,0,0], 
    [0,0,0,46,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,81,157,41,39,42,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,158,48,73,20,62,0,0,0,0,0,0], 
    [0,0,0,46,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,37,104,20,48,42,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,48,31,48,41,12,15,0,0,0,0,0], 
    [0,111,1,46,124,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,124,56,159,65,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,48,56,57,56,2,0,0,0,0,0,0], 
    [0,110,12,160,161,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,162,32,58,74,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,39,42,19,92,0,0,0,0,0,0,0], 
    [5,63,62,104,18,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,30,88,83,163,41,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,65,39,73,56,164,26,0,0,0,0,0], 
    [13,0,11,30,30,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,18,30,32,165,74,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,56,65,48,48,166,26,0,0,0,0,0], 
    [27,7,12,167,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,162,37,32,57,42,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,73,41,39,32,56,109,52,0,0,0,0,0], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,37,46,168,37,46,144,18,132,169,83,19,73,19,32,48,33,73,42,83,74,39,66,73,73,73,73,73,73,73,73,73,73,20,41,65,42,57,63,11,52,61,152,11], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,30,30,170,37,167,37,30,171,172,173,174,84,41,65,74,57,33,74,48,73,129,42,73,73,73,73,73,73,73,73,73,73,65,56,39,56,42,175,11,5,24,11,0], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,30,9,45,37,37,96,176,173,173,177,178,179,57,73,65,39,56,42,41,57,74,74,73,73,73,73,73,73,73,73,73,73,65,33,56,48,41,180,11,11,0,12,26], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,30,45,37,81,181,182,173,173,183,184,178,185,186,179,187,48,65,92,159,92,75,56,73,73,73,73,73,73,73,73,73,73,20,39,159,39,31,31,11,13,26,26,7], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,124,37,38,96,188,179,186,189,190,172,191,191,191,191,192,193,194,91,56,39,42,74,73,73,73,73,73,73,73,73,73,73,39,39,39,33,75,82,71,0,52,0,11], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,195,30,157,30,104,37,132,196,183,173,178,191,172,192,191,179,191,197,173,191,179,179,173,173,198,39,39,74,57,41,73,48,32,129,31,74,42,73,73,73,73,73,73,4,12,2,0,0], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,46,113,168,38,37,18,199,200,183,185,201,202,173,203,204,205,173,173,189,190,188,173,183,188,197,206,57,83,74,73,91,65,41,73,65,39,74,73,73,73,73,73,73,26,27,26,2,0], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,9,88,88,81,207,208,172,172,177,179,186,172,209,210,211,212,213,214,178,191,172,173,215,216,191,190,172,217,218,129,39,75,32,57,56,41,32,73,73,73,73,73,73,219,6,0,26,12], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,30,88,96,220,179,178,221,222,190,191,197,223,224,225,226,227,228,229,230,188,173,191,178,184,177,215,179,231,232,233,234,48,73,56,56,48,48,73,73,73,73,73,73,235,61,61,26,0], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,18,171,236,191,201,178,191,232,191,237,238,239,240,241,242,243,244,245,244,245,244,246,247,191,221,189,191,173,179,178,172,173,248,48,31,48,65,73,73,73,73,73,73,249,26,52,2,0], 
    [0,26,11,37,46,46,46,46,46,46,46,46,46,46,46,46,88,183,183,190,178,183,178,173,250,226,251,252,253,254,255,229,229,227,256,257,227,244,258,259,215,191,179,191,178,190,201,179,172,260,261,42,32,73,73,73,73,73,73,262,71,263,11,15], 
    [0,12,52,30,46,168,104,37,81,128,264,37,104,30,18,182,183,177,179,215,197,173,265,226,266,267,254,226,268,254,269,244,229,229,229,229,229,270,228,212,257,271,272,191,232,190,177,172,191,190,183,191,190,273,75,42,33,31,56,73,164,15,71,35], 
    [26,274,2,38,46,37,104,46,37,9,132,18,144,37,275,173,191,232,276,277,179,278,279,252,238,252,211,226,268,254,211,280,229,229,229,229,229,229,227,244,281,257,282,246,192,201,172,178,283,215,179,284,179,285,190,66,73,66,48,74,286,35,11,23], 
    [71,0,2,38,88,30,30,37,46,18,18,30,181,172,191,179,172,201,172,287,288,226,252,289,269,290,239,269,269,254,269,291,229,229,229,229,229,292,293,294,295,257,227,296,282,297,298,191,197,172,299,232,173,190,191,192,173,300,39,73,301,71,302,274], 
    [0,26,52,37,18,303,38,124,30,96,304,305,178,173,200,284,178,179,191,306,226,307,308,238,266,309,268,226,269,252,241,310,229,229,229,229,229,229,282,311,312,257,313,314,244,315,244,316,272,197,173,221,179,191,178,172,191,192,317,92,39,15,138,24], 
    [0,15,62,47,18,128,45,30,96,318,319,191,191,172,186,178,179,320,211,211,254,226,254,308,267,211,266,226,226,226,254,321,229,229,229,229,229,229,322,229,281,256,323,227,280,229,257,227,256,324,325,326,191,188,183,190,190,191,173,327,328,329,5,23], 
    [11,23,11,30,18,168,18,38,9,201,173,178,215,179,172,191,330,331,242,241,226,226,226,226,226,226,226,226,269,332,226,333,229,229,229,229,229,229,229,229,229,229,229,312,229,334,334,335,257,229,336,173,172,183,184,191,172,191,191,337,94,338,27,26], 
    [11,11,12,9,37,46,89,339,179,183,177,184,190,172,340,226,341,266,342,226,308,226,226,226,226,226,226,226,226,254,226,343,229,229,229,229,229,229,229,229,229,229,229,311,344,244,282,245,345,173,179,191,215,183,173,183,346,2,0,24,13,27,5,11], 
    [263,11,12,18,45,18,347,192,184,173,284,348,188,349,350,226,307,351,352,211,252,226,226,226,226,226,226,226,226,226,226,353,229,229,229,229,229,229,229,229,229,229,229,244,281,244,354,355,191,177,173,178,191,178,172,356,357,23,12,7,78,26,2,0], 
    [11,13,1,47,358,178,172,359,191,178,197,360,361,238,267,362,268,254,268,267,332,226,226,226,226,226,226,226,254,226,254,363,229,229,229,229,229,229,229,229,229,229,229,257,313,364,215,178,191,179,172,178,191,365,26,329,15,0,12,71,0,11,1,52], 
    [2,329,12,347,191,366,276,173,172,191,197,299,367,268,350,254,211,226,252,332,238,226,226,226,226,226,226,226,254,226,241,268,229,229,229,229,229,229,229,229,229,229,229,256,368,232,369,179,191,197,173,173,370,1,35,52,79,27,26,63,52,7,371,274], 
    [1,0,35,61,372,373,173,179,191,178,191,178,191,197,190,374,375,308,376,241,253,376,269,254,308,351,269,241,226,242,226,268,377,281,244,312,256,296,244,281,378,379,380,215,191,197,173,284,178,201,381,27,15,0,0,0,0,0,0,0,0,0,0,0], 
    [63,6,23,12,53,24,382,383,173,173,179,191,179,173,191,215,179,384,385,332,341,238,308,226,376,254,268,308,241,350,254,269,386,282,229,229,344,229,244,294,282,387,191,179,190,178,172,179,178,388,12,23,2,0,0,0,0,0,0,0,0,0,0,0], 
    [4,35,11,0,263,23,1,389,71,390,391,173,221,173,173,191,178,191,192,232,201,392,393,226,254,226,394,267,395,254,226,396,397,244,297,294,398,399,400,277,172,173,179,179,179,183,179,401,15,71,110,2,11,0,0,0,0,0,0,0,0,0,0,0], 
    [402,11,111,0,0,26,0,302,61,70,11,403,404,179,405,173,215,201,184,359,184,191,215,406,289,308,269,407,408,409,410,226,411,228,282,228,212,412,413,201,178,179,173,191,183,414,415,26,27,0,26,27,1,0,0,0,0,0,0,0,0,0,0,0], 
    [26,23,0,0,52,11,35,416,1,71,0,102,35,2,52,417,418,193,190,186,179,201,192,185,190,215,419,420,269,376,421,409,422,294,423,424,425,184,348,178,172,172,426,427,428,23,2,11,11,26,26,24,95,0,0,0,0,0,0,0,0,0,0,0], 
    [11,11,0,11,0,13,2,26,26,26,11,0,15,26,26,11,26,429,427,178,179,191,232,186,179,192,186,172,430,226,307,268,431,292,432,188,191,191,191,190,184,178,327,0,11,26,26,23,26,14,7,274,12,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,62,15,23,141,433,434,215,179,191,183,435,191,173,173,436,437,232,191,359,178,178,177,179,438,439,440,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,0,102,71,62,23,61,441,442,183,179,178,179,191,178,191,191,443,185,179,177,172,179,444,27,53,26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,52,0,11,12,15,52,12,2,445,188,179,173,191,197,446,173,173,179,447,27,24,274,102,35,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,7,62,0,70,0,263,52,138,3,448,449,173,178,173,231,172,450,451,0,0,13,12,416,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,62,2,2,35,11,62,12,0,15,35,26,26,12,1,0,452,453,454,53,263,0,52,53,7,111,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff676769, 0xff656565, 0xff68666b, 0xff66656a, 0xff666762, 0xff656762, 0xff676664, 0xff706d5c, 0xffcba901, 0xff9b823f, 0xff666668, 0xff656766, 0xff666465, 0xff67666b, 0xff656764, 0xff7b734f, 0xffcda802, 0xffcbab00, 0xfffdc702, 0xfffec502, 0xffd0a51b, 0xff716b5d, 0xff676566, 0xff666867, 0xff646569, 0xff666664, 0xff656668, 0xff857945, 0xffcdab01, 0xffcbab02, 0xfffec600, 0xffffc502, 0xfffec400, 0xfff8bf00, 0xff676568, 0xffa68f25, 0xffccaa02, 0xffcba900, 0xffffc501, 0xffffc801, 0xffffc702, 0xfffec601, 0xff726a5d, 0xffaf971d, 0xffccab00, 0xffccaa00, 0xffcba802, 0xffffc700, 0xffffc803, 0xfffcc400, 0xffbf9b20, 0xff676767, 0xff646567, 0xff6f6e5a, 0xffc8a901, 0xffffc603, 0xfffcc601, 0xffffc503, 0xffeeb704, 0xff646663, 0xff646665, 0xff656563, 0xff696566, 0xffcda700, 0xffffc500, 0xfffdc703, 0xfffac400, 0xffcba514, 0xff756c5b, 0xff686669, 0xff676765, 0xffc8a900, 0xffffc600, 0xffffc602, 0xfffcc700, 0xfff0ba02, 0xff897945, 0xff676863, 0xff656469, 0xffcaa800, 0xffcaaa00, 0xfffcc602, 0xffffc401, 0xffffc505, 0xff736c5c, 0xff666769, 0xffba9f14, 0xffcca903, 0xffcea903, 0xfff3e604, 0xfffdc800, 0xffffc402, 0xff97833c, 0xff636766, 0xff666563, 0xffcea902, 0xfff0e801, 0xfffec504, 0xfffbc701, 0xfffbc501, 0xfff1b602, 0xff686667, 0xff6a6663, 0xffcaaa01, 0xffd9e603, 0xffffc301, 0xfffdc401, 0xffffc400, 0xfff6bf02, 0xff65666a, 0xff666865, 0xff847a45, 0xffcdab03, 0xffdce101, 0xfff1b902, 0xff9b833d, 0xff676364, 0xffd8cd02, 0xfffcc604, 0xfffac402, 0xffcfa616, 0xff686367, 0xffa69126, 0xffcbaa03, 0xffd8c405, 0xff98843f, 0xff686763, 0xffccac03, 0xfffdc500, 0xffcea515, 0xff716b5b, 0xffcea900, 0xfffacd00, 0xfffbc200, 0xff857947, 0xffcea800, 0xfff3e700, 0xff686765, 0xff857a44, 0xffd9ed02, 0xff6a6665, 0xffa69128, 0xffcfab00, 0xffcda801, 0xffd7e500, 0xffc09c21, 0xffbfa508, 0xffcaab02, 0xffcaac00, 0xffdbdf02, 0xffe8b400, 0xff696564, 0xffcfb200, 0xff8a7a49, 0xffdcaa0d, 0xfff1bb01, 0xffcdaa04, 0xffffc605, 0xfffbc600, 0xffccac00, 0xffc9aa01, 0xffc9ab00, 0xfffec901, 0xff9a833d, 0xfffec401, 0xffcfa618, 0xffccac01, 0xffcaa902, 0xffefe601, 0xffcfaa04, 0xffd9c600, 0xfff4fe00, 0xfff4ff00, 0xffffd301, 0xffb7922a, 0xffeadd02, 0xfff5fe03, 0xfff4ff01, 0xfff5ff01, 0xffdcac0a, 0xffdbc500, 0xfff4fb00, 0xfff7fe00, 0xfff6ff02, 0xfff8ff02, 0xfff4ff03, 0xfffcef02, 0xfff3ff01, 0xfff7fd00, 0xfff3ff00, 0xfff5ff00, 0xfff6ff01, 0xfff1fe00, 0xfffece00, 0xffcba804, 0xfff2fb00, 0xfff7fe01, 0xfffeda02, 0xffe8db00, 0xfff3fe02, 0xfff6fd00, 0xfff6ff06, 0xfffbfa02, 0xfff2c800, 0xfff8ff00, 0xffffde03, 0xffd9c800, 0xfff8fd01, 0xffa31426, 0xff99034d, 0xff99014c, 0xfff0006f, 0xffe4015a, 0xfffee606, 0xfff3fe00, 0xfff2fe00, 0xffefff00, 0xfffef301, 0xff736b5e, 0xffe6dc00, 0xfff5ff02, 0xfff5fe05, 0xff8a1887, 0xff940148, 0xff9a004d, 0xff98004b, 0xfff1006b, 0xfff10069, 0xfff0006d, 0xffa82fae, 0xfff8ff01, 0xfff2ff00, 0xfffff901, 0xffffd304, 0xff9b853c, 0xfff1fb06, 0xff8b2356, 0xff98004d, 0xff99034b, 0xff96004a, 0xff9a004b, 0xff98024c, 0xffee016b, 0xfff0006b, 0xfff2016c, 0xffd3280e, 0xfffff905, 0xffebfe02, 0xffebb701, 0xfff4db02, 0xff980249, 0xff9b004c, 0xff95014b, 0xff980049, 0xff970048, 0xfff1006d, 0xfff1016e, 0xffe40059, 0xffffe404, 0xffeafd01, 0xffffef03, 0xfff7bd01, 0xff676662, 0xffccab04, 0xfff9fa00, 0xff970148, 0xff98024a, 0xff9a0049, 0xff97014b, 0xfff3016f, 0xffe2009f, 0xfff3a602, 0xfffdcf00, 0xff656567, 0xffe7dd00, 0xfff7fe03, 0xfff6ff00, 0xfff2c900, 0xff9a0060, 0xfff3006e, 0xfff00169, 0xffee016d, 0xfff4fd04, 0xfff7ff00, 0xfff2fd00, 0xffc29c1f, 0xfff6eb03, 0xff8e1888, 0xff94004a, 0xff960048, 0xffee036c, 0xfff1016c, 0xfff1006a, 0xfff2016a, 0xfff3006a, 0xfff1026a, 0xffee006f, 0xffa72eb1, 0xfff6fd02, 0xffffe701, 0xfff1b900, 0xff636864, 0xffcaab03, 0xffcda800, 0xffebde04, 0xff9b0060, 0xff97004d, 0xff970149, 0xff9a024b, 0xffe90167, 0xffed006c, 0xfff2006e, 0xffef026a, 0xffef006c, 0xfff00070, 0xffc619b1, 0xffeeff00, 0xffd9c701, 0xfff4fa02, 0xff8c1887, 0xffd5005c, 0xffed016d, 0xfff2026d, 0xfff2026f, 0xffe5006c, 0xfffff802, 0xffecf800, 0xffa9af2b, 0xff636768, 0xffc46200, 0xff9c004c, 0xff980148, 0xffc5004f, 0xfff20070, 0xffee0169, 0xffe5005d, 0xff75735a, 0xff67656a, 0xfff1fa01, 0xfff3c903, 0xff9b004b, 0xff99014a, 0xffbb014c, 0xffef026e, 0xffe10185, 0xfff0fa03, 0xffe7dd01, 0xfff3fd00, 0xffb82e07, 0xff97004a, 0xff99014e, 0xff99004a, 0xffb1014a, 0xffed026b, 0xffbb244d, 0xffe3eb00, 0xff74725d, 0xffdcc600, 0xfff4fd02, 0xffe3ab00, 0xff9b0161, 0xff950249, 0xffa10149, 0xfff3a600, 0xffd3db0a, 0xfff9ff00, 0xffd18900, 0xffa9317b, 0xfff6ff04, 0xffe4ef00, 0xff666467, 0xff8e9142, 0xffedf600, 0xfff4dc00, 0xff8d2354, 0xff9b014a, 0xffdb0061, 0xfff10170, 0xffe4005a, 0xffbb254a, 0xffd2dc0c, 0xff9c9f38, 0xfff1fb00, 0xffe2a900, 0xff7c2367, 0xffd7005d, 0xfffff704, 0xff8d9242, 0xff6a6667, 0xff75735c, 0xffb7bf1c, 0xffa21325, 0xffa00263, 0xff9b0048, 0xff970047, 0xff99004c, 0xffbd014e, 0xfff2006d, 0xffed0068, 0xffed006e, 0xff74745a, 0xff686868, 0xff83834d, 0xffc5ca15, 0xfff5fc00, 0xff7f2366, 0xff990249, 0xff98004f, 0xff9a0048, 0xff96024c, 0xffc3004e, 0xffdf02a0, 0xffffe605, 0xffebf501, 0xff9da037, 0xff666469, 0xff9ba137, 0xffe3eb02, 0xfff5db00, 0xff9d057e, 0xff980146, 0xffab014a, 0xfff1006f, 0xff9c2d8c, 0xfffff503, 0xfff9ff01, 0xffe5ee00, 0xff828550, 0xffa9ae2e, 0xffe4aa01, 0xffaa0047, 0xffe10283, 0xffc3cd14, 0xffecf602, 0xfff8ff04, 0xfffaea01, 0xffbb2d05, 0xffe7f000, 0xff646965, 0xff626665, 0xffdcea00, 0xffedf702, 0xfff0ff00, 0xffa8af2b, 0xffe2ea00, 0xfff3ff03, 0xff8b9244, 0xff72745c, 0xffe5ec00, 0xfff0fb00, 0xffc4cb19, 0xff818351, 0xffe8f100, 0xff9ba133]
				); 
        }
		public function box14():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,0,5,1,1,6,7,8,9,10,11,12,8,0,4,13,0,9,14,3,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,16,0,17,18,3,2,19,3,20,21,0,22,23,24,25,26,27,28,29,3,30,1,4,0,4,31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,33,19,21,0,29,34,30,21,0,35,36,37,38,24,39,40,41,42,43,0,0,16,8,0,44,34,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,16,30,1,20,1,45,9,46,47,48,49,50,51,47,52,53,54,55,56,57,30,58,21,16,4,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,3,1,3,0,30,59,46,24,50,49,60,61,60,62,51,40,63,26,40,53,64,44,20,58,65,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,29,30,13,14,29,66,8,4,0,13,0,19,67,68,51,69,24,24,24,24,24,50,50,49,70,70,71,71,71,71,71,71,72,73,17,74,3,15,4,3,21,65,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,13,20,3,58,0,34,75,2,1,4,19,14,76,62,77,78,24,24,24,24,24,79,50,24,78,78,71,71,71,71,71,71,40,56,0,21,3,16,1,80,45,33,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,13,1,14,81,3,30,3,4,82,83,50,84,50,24,37,79,24,24,24,24,24,24,24,24,24,49,71,71,71,71,71,71,85,56,54,86,3,13,81,31,9,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,87,58,4,4,3,87,18,88,89,79,78,60,69,70,24,49,24,24,24,24,24,24,24,50,90,78,71,71,71,71,71,71,55,91,55,92,35,0,58,29,7,32,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,29,93,20,0,94,84,95,70,24,79,52,47,46,70,51,96,24,24,24,24,24,50,24,79,47,79,71,71,71,71,71,71,97,63,55,97,98,99,100,21,3,13,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,21,3,101,84,24,24,79,50,49,24,46,78,24,51,50,24,24,24,24,24,24,70,46,50,24,50,71,71,71,71,71,71,102,54,56,26,26,53,103,0,14,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,13,15,21,4,16,104,105,96,50,106,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,47,50,46,83,38,71,71,71,71,71,71,71,71,71,71,71,55,107,92,108,75,109,19,30,7,16,30,0,0,0,0,0], 
    [0,0,0,0,0,87,30,1,3,110,83,69,51,79,24,78,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,70,24,46,47,47,71,71,71,71,71,71,71,71,71,71,71,102,111,112,113,114,30,4,3,7,21,115,0,0,0,0,0], 
    [0,0,0,0,0,4,21,47,78,37,116,79,46,70,78,95,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,117,49,78,78,118,71,71,71,71,71,71,71,71,71,71,71,40,54,119,112,54,120,3,29,4,75,9,0,0,0,0,0], 
    [0,0,0,0,0,19,3,47,47,70,83,50,47,47,50,38,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,79,50,50,50,121,71,71,71,71,71,71,71,71,71,71,71,53,26,71,26,55,97,122,123,124,4,125,0,0,0,0,0], 
    [0,0,0,0,0,16,19,24,24,24,50,48,51,39,47,106,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,83,126,49,60,127,71,71,71,71,71,71,71,71,71,71,71,97,54,26,40,63,26,71,128,129,19,21,0,0,0,0,0], 
    [0,0,0,0,0,19,8,130,70,84,49,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,83,78,78,50,131,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,98,63,132,72,1,8,8,0,34,2,0], 
    [0,0,0,0,0,0,21,47,78,62,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,47,47,46,130,133,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,111,97,27,63,55,134,3,81,75,29,13], 
    [0,0,0,0,0,4,135,47,136,50,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,83,51,60,117,137,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,97,111,26,71,55,40,29,3,13,0,3], 
    [0,0,0,0,0,0,138,130,130,83,130,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,52,78,139,50,140,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,98,26,55,63,85,54,71,141,123,87,30], 
    [0,0,0,0,0,4,89,24,79,50,130,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,47,47,142,47,143,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,144,97,26,85,71,27,56,145,13,9], 
    [29,33,1,0,0,146,147,70,47,95,47,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,46,79,84,47,148,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,97,54,97,149,4], 
    [0,1,0,1,0,150,118,46,49,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,38,49,50,51,27,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,56,54,112,151,13], 
    [0,0,21,4,0,152,50,46,51,47,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,50,38,24,37,153,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,85,154,58], 
    [0,0,1,3,0,51,70,50,47,83,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,47,47,47,155,26,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,56,53,119,156,29], 
    [0,0,34,13,0,77,47,49,77,83,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,51,50,50,157,63,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,63,98,71,158,19], 
    [0,0,0,1,0,24,46,49,24,48,78,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,78,50,78,159,53,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,97,63,160,1], 
    [0,21,0,5,0,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,78,50,50,161,26,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,26,102,40,162,0], 
    [9,66,19,30,125,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,49,46,50,163,26,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,26,40,40,164,0], 
    [81,30,16,3,165,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,49,50,90,166,54,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,40,26,63,167,0], 
    [1,13,0,0,168,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,46,50,50,169,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,26,40,63,170,0], 
    [30,1,16,0,51,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,46,50,78,143,55,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,40,97,171,1], 
    [13,4,3,29,106,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,52,38,38,40,102,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,54,55,0,0], 
    [87,65,13,172,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,50,50,51,40,55,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,54,55,0,0], 
    [16,0,13,173,47,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,50,174,49,97,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,54,55,0,0], 
    [8,34,13,106,70,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,51,52,24,55,107,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,54,55,0,0], 
    [0,0,21,24,51,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,50,90,51,56,54,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,54,55,0,0], 
    [4,1,9,47,130,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,51,24,46,50,49,47,130,69,78,79,38,49,47,50,27,132,56,54,97,56,97,26,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,71,97,0,0], 
    [1,4,14,78,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,39,49,83,24,78,136,51,47,69,49,70,89,69,175,63,63,27,63,56,176,55,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,54,40,91,16,0], 
    [0,0,29,47,47,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,46,78,70,90,46,79,50,78,177,178,179,180,181,182,183,119,53,55,54,97,111,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,53,98,184,21,0], 
    [0,4,185,46,50,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,50,24,49,49,186,70,70,187,188,189,181,182,190,182,190,191,192,193,153,55,54,98,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,53,98,194,0,0], 
    [33,0,195,61,139,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,49,69,69,196,197,179,198,199,179,179,179,200,179,190,179,201,182,190,202,71,97,54,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,55,26,203,0,16], 
    [13,1,78,70,49,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,78,204,205,181,190,180,179,179,181,180,182,182,179,189,180,179,179,190,179,206,56,98,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,71,55,56,184,16,0], 
    [4,123,139,70,24,24,47,39,76,24,50,46,50,78,106,51,130,177,207,208,209,189,210,211,181,212,181,180,189,179,199,213,214,215,216,179,182,190,217,189,182,190,218,40,219,220,55,97,53,40,92,40,119,71,71,71,71,71,71,55,221,222,0,13], 
    [0,223,50,61,70,24,78,83,47,39,47,186,24,24,50,224,225,200,180,191,189,180,226,227,212,198,179,189,180,228,229,230,231,232,233,234,235,180,189,236,237,200,180,238,112,53,239,40,240,53,40,241,40,71,71,71,71,71,71,53,56,242,13,0], 
    [29,243,60,51,50,83,50,79,24,47,24,244,245,181,190,182,226,180,246,212,179,191,247,182,248,249,250,251,252,253,251,231,254,255,215,256,230,257,258,182,182,259,260,180,261,262,27,54,263,112,97,40,92,71,71,71,71,71,71,54,219,264,0,0], 
    [58,50,51,47,49,50,78,50,50,265,266,200,180,180,189,267,189,181,237,182,191,182,268,269,270,271,272,273,274,275,272,276,256,277,255,277,277,215,278,182,180,191,236,179,191,246,279,40,91,280,112,53,40,71,71,71,71,71,71,98,241,281,7,21], 
    [13,48,130,48,46,282,283,190,182,180,180,261,199,261,179,179,181,237,284,285,286,271,287,251,288,289,290,291,251,274,292,232,231,232,293,294,230,231,295,254,296,189,190,180,182,179,189,199,297,91,263,240,53,71,71,71,71,71,71,54,54,298,3,1], 
    [4,69,90,282,299,180,226,180,212,267,180,180,180,182,180,300,301,302,303,251,286,251,251,251,251,251,251,286,304,272,305,231,231,231,231,231,231,306,307,308,215,309,189,182,181,189,180,182,179,310,97,40,40,71,144,56,40,112,111,53,63,311,0,13], 
    [1,312,313,189,314,190,182,315,260,190,316,317,318,319,251,320,270,271,321,320,272,251,251,251,251,251,251,251,286,322,323,307,231,231,231,231,231,231,308,324,325,294,294,326,190,182,190,212,181,212,191,327,328,54,280,26,63,26,40,54,55,311,0,0], 
    [0,21,329,236,200,179,190,179,179,191,330,286,271,331,251,251,286,332,288,272,271,251,251,251,251,251,251,333,320,334,335,232,231,231,231,231,231,306,336,215,337,232,338,307,339,179,182,179,200,246,179,182,340,55,98,40,55,53,26,53,112,341,7,13], 
    [8,0,30,29,342,343,181,344,345,260,180,182,346,291,275,275,347,348,251,349,271,251,251,251,251,251,251,350,271,351,231,230,231,231,231,231,231,254,277,294,307,230,256,294,352,353,354,180,316,314,199,181,200,355,356,56,56,55,112,54,97,357,4,13], 
    [14,0,15,14,3,358,359,180,179,189,267,189,212,360,361,362,304,252,304,363,270,251,251,251,251,251,251,270,251,364,231,230,231,231,231,231,231,365,232,231,366,338,230,231,277,215,256,367,182,180,260,190,200,189,179,368,98,40,85,71,97,369,34,0], 
    [0,0,0,0,0,13,18,19,370,212,182,182,190,182,371,372,373,253,272,374,272,251,333,331,272,375,271,251,251,376,230,377,231,231,231,231,231,230,366,231,254,277,378,308,277,231,231,232,306,379,212,200,179,190,190,210,180,97,54,98,97,380,29,3], 
    [0,0,0,0,0,31,0,3,0,381,382,179,181,190,217,179,383,384,289,348,319,385,271,272,272,386,386,271,251,387,232,232,231,231,231,231,231,277,256,306,276,388,230,232,366,389,390,378,256,391,392,393,189,180,190,191,260,394,395,26,176,396,3,21], 
    [0,0,0,0,0,0,0,29,29,13,13,397,398,190,180,182,190,180,180,399,271,400,401,289,271,271,271,272,251,402,307,306,231,231,231,231,231,215,231,232,308,254,231,308,403,254,294,294,232,256,378,404,181,267,199,189,247,261,180,405,406,407,34,29], 
    [0,0,0,0,0,3,16,100,13,8,0,408,13,409,191,179,316,182,180,180,410,411,272,412,251,289,322,272,251,338,231,231,231,231,231,231,231,231,232,256,413,308,256,414,415,254,416,417,418,419,180,179,180,179,190,212,371,190,212,180,420,421,0,30], 
    [0,0,0,0,0,0,422,13,16,423,19,423,16,0,21,424,425,189,181,181,315,180,426,271,385,272,251,251,251,232,231,256,231,231,231,231,231,352,231,230,427,294,428,429,430,199,261,190,189,191,182,217,267,236,191,180,431,432,433,65,1,1,0,14], 
    [0,0,0,0,0,16,21,146,0,4,3,30,100,0,74,21,434,435,247,267,179,180,181,436,437,302,251,251,270,230,366,232,231,231,231,231,231,256,338,438,234,193,200,182,180,199,180,199,180,180,179,261,212,439,440,34,0,1,0,13,65,0,29,408], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,21,0,441,189,260,179,212,179,442,443,350,270,232,256,352,325,336,278,444,379,191,181,445,236,180,182,189,182,180,179,446,447,8,0,342,13,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,34,3,0,448,267,180,181,190,247,190,449,333,231,232,450,451,452,212,179,190,179,189,189,190,180,212,453,454,455,0,4,18,4,115,6,21,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,8,33,1,109,16,456,181,179,190,180,189,199,179,189,199,181,180,189,189,180,457,458,459,16,16,0,19,0,15,13,14,0,0,14,32,13,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,0,4,29,14,1,460,461,462,180,189,267,217,179,182,200,190,260,463,464,465,30,466,1,3,29,21,13,0,0,87,13,13,0,58,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,19,0,1,16,4,146,423,0,1,467,182,468,469,470,0,0,0,13,0,66,0,4,125,471,14,472,0,3,1,1,14,16,34,66,81,1,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff656766, 0xff666563, 0xff676566, 0xff666668, 0xff696564, 0xff686765, 0xff676769, 0xff676568, 0xff656567, 0xff79734f, 0xffd2dc02, 0xff736b60, 0xff666664, 0xff666465, 0xff646663, 0xff676767, 0xff656762, 0xff666467, 0xff656764, 0xff686667, 0xff656565, 0xffa39125, 0xffcea701, 0xffccaa00, 0xffc9ab00, 0xfffec601, 0xfffdc800, 0xff8b7947, 0xff656668, 0xff676664, 0xff696468, 0xff676662, 0xff646567, 0xff666867, 0xff6f6c5d, 0xffbe9f13, 0xffcda800, 0xffcaac00, 0xffccac01, 0xffffc702, 0xfffbc800, 0xfffdc300, 0xffa78c35, 0xff656469, 0xff666769, 0xffcba900, 0xffcbab02, 0xffcbaa03, 0xffcbab00, 0xffccaa02, 0xffcaaa01, 0xffcaab02, 0xffffc602, 0xffffc501, 0xffffc500, 0xfffec600, 0xffe9b402, 0xff676765, 0xffa39029, 0xffccac03, 0xffcea903, 0xffcfaa03, 0xfffec502, 0xfff1b900, 0xff696566, 0xff666762, 0xff636967, 0xff857945, 0xffccab00, 0xffcca903, 0xffffc600, 0xfffcc300, 0xff8e7a47, 0xff686465, 0xff646867, 0xffcaa800, 0xffccab04, 0xffcba901, 0xffcea902, 0xff686763, 0xff646665, 0xff797353, 0xffcaaa00, 0xffcaa902, 0xfffdc702, 0xffe9b605, 0xff66656a, 0xff8e813d, 0xffc9aa01, 0xffcdab03, 0xfffcc602, 0xfffdc500, 0xff636864, 0xffb89e13, 0xffceaa00, 0xffcfa900, 0xffffc700, 0xffffc603, 0xfffbc300, 0xff666865, 0xff857a44, 0xffffc803, 0xffb4932a, 0xff6f6c5b, 0xffc9a803, 0xffcba802, 0xffffc605, 0xff716b5d, 0xff646965, 0xffc5a206, 0xfffcc601, 0xffffc502, 0xfff5be01, 0xff8c7b47, 0xff676863, 0xffcdaa04, 0xffcda801, 0xffccac00, 0xfffcc700, 0xffb3922b, 0xffd3c200, 0xffdcac0a, 0xff6a6667, 0xff686461, 0xff636766, 0xffcaab03, 0xffd7cc00, 0xfff7bd01, 0xff716c59, 0xffcea900, 0xffd9cd00, 0xffffc400, 0xffd9e401, 0xffc09c22, 0xff797550, 0xffcdab01, 0xffd6e504, 0xffb89f11, 0xffcdac00, 0xfff3e800, 0xfff4bf00, 0xffcbaa00, 0xfff3e700, 0xffffc401, 0xff8e7a48, 0xff686669, 0xffcaa904, 0xfff4e005, 0xffd3a416, 0xff8b833a, 0xffcca814, 0xffc3a507, 0xfffdc703, 0xffcfa515, 0xffd1bb03, 0xffd0a815, 0xffd8cc00, 0xff9a813f, 0xffd8cd01, 0xff9c8340, 0xffd9e402, 0xff9a843b, 0xffd6e800, 0xff9a833d, 0xff8c823b, 0xffedef08, 0xff9a8439, 0xffa58f22, 0xfff3e802, 0xff9b8637, 0xff907848, 0xff8e7f3a, 0xffb99e11, 0xffcea805, 0xffcfaf04, 0xffffc503, 0xffd2b502, 0xfff3f402, 0xfff5ff01, 0xfff5ff00, 0xfff3ff00, 0xfff4ff00, 0xfff0ff02, 0xfff1ba00, 0xff6e6a5e, 0xffc9a900, 0xffd4bb00, 0xfff4f501, 0xfff4fe00, 0xfff4ff01, 0xfff6fd00, 0xfffdfe03, 0xfffdcd00, 0xfff0b801, 0xffb99d15, 0xffddc405, 0xfff5f700, 0xfff3fe02, 0xfff3fe00, 0xfff7fe01, 0xfff6ff04, 0xfffffb01, 0xfff0b800, 0xffdbc404, 0xfff5fa00, 0xffedfe00, 0xffdece00, 0xfff0ff00, 0xfff7fc00, 0xfff3ff01, 0xfff5ff04, 0xfff7fe00, 0xffbf244c, 0xffe50085, 0xfff1016e, 0xffe4005a, 0xfff7ff00, 0xffeaff00, 0xffffc402, 0xffffc801, 0xfffec901, 0xffefb900, 0xff817c45, 0xffd1b400, 0xffe1d100, 0xfff7fe03, 0xfff8fe00, 0xffa11424, 0xff8c178a, 0xffee016b, 0xfff0006d, 0xfff0006b, 0xfff1026a, 0xffc719b0, 0xfffcf801, 0xfff8ff01, 0xfff3fd00, 0xfffeef00, 0xfffec401, 0xfffbc701, 0xfffdc401, 0xfff1bb00, 0xffb99e13, 0xffd3bb01, 0xffe7de03, 0xfff5ff02, 0xfff2ff00, 0xfff9fc00, 0xff7e2265, 0xff9a0062, 0xff98004b, 0xff960048, 0xff97004a, 0xfff00169, 0xfff0006f, 0xfff1006b, 0xffa62cb3, 0xfffff905, 0xfff1ff03, 0xfff4ff03, 0xfff6ff02, 0xffffe500, 0xfffcc900, 0xfff0ba00, 0xffd9c600, 0xffebe103, 0xfff5fe03, 0xfff7eb00, 0xff7e217a, 0xff9a004b, 0xff980049, 0xff970149, 0xff99004a, 0xff9a0048, 0xff9b004e, 0xffef026c, 0xfff1016c, 0xffe1006a, 0xfff9ff01, 0xfffec400, 0xffd2a41a, 0xffdecd01, 0xfff0e903, 0xffe1ab00, 0xff9b0161, 0xff9a0049, 0xff970048, 0xff96004a, 0xff98024a, 0xff96004c, 0xff980148, 0xffaa0049, 0xffef0170, 0xfff2006e, 0xfff3006a, 0xffe20185, 0xfffffa00, 0xffcca617, 0xfff0e801, 0xfffbfa00, 0xffcf8a01, 0xff9b004c, 0xff95014d, 0xff98024c, 0xffb50045, 0xffee016d, 0xfff1006d, 0xfff2016c, 0xffbd254c, 0xfffddb00, 0xffcfa616, 0xffc4cc16, 0xfff1fb04, 0xfff8ff02, 0xfff6ff00, 0xfff8fd01, 0xfff5dd01, 0xff9f1725, 0xff98004d, 0xff9b014a, 0xff990249, 0xff9c004c, 0xffd00056, 0xfff20271, 0xfff10069, 0xffe67100, 0xfffcd300, 0xffffc302, 0xff717656, 0xfff7eb03, 0xff98014e, 0xff9c0050, 0xff97014b, 0xff97004c, 0xffda005f, 0xfff10170, 0xffed026b, 0xffed006a, 0xffc518b0, 0xfffef600, 0xffcea519, 0xff656563, 0xffeef602, 0xfff4fd02, 0xfff6ff01, 0xfff3da01, 0xff9b0049, 0xff99014a, 0xff990050, 0xff99014c, 0xff9b0149, 0xfff2016a, 0xfff20069, 0xff9c2c90, 0xfff2ff02, 0xffffe502, 0xffd0a812, 0xff646569, 0xffb7bf1e, 0xffd38902, 0xff9e005f, 0xff96034a, 0xff950248, 0xffab0049, 0xffef026e, 0xfff3006e, 0xffffcb01, 0xfffece00, 0xffcca51a, 0xff83814e, 0xfff5fe05, 0xfff3dd00, 0xff7e1f79, 0xff960047, 0xff950249, 0xffc1014e, 0xfff0006a, 0xfff1006f, 0xffffe605, 0xff9b8240, 0xff9ba137, 0xffebf500, 0xfff6fd02, 0xff990261, 0xff94004a, 0xff97004d, 0xffc70051, 0xfff00167, 0xfff3006c, 0xffee0169, 0xffe30157, 0xffd4290d, 0xfff4ff05, 0xffeeff01, 0xfffcd901, 0xff98843f, 0xff72745c, 0xffd6db0b, 0xff7d2079, 0xff99014e, 0xff970148, 0xffe40062, 0xffef006a, 0xffbb244f, 0xffe9ff00, 0xfffed404, 0xff97833c, 0xff636768, 0xffe3eb00, 0xffd18901, 0xff940148, 0xff95014b, 0xffec016a, 0xfff2006b, 0xfff2026f, 0xfff0036f, 0xffe50158, 0xffe1019f, 0xfff1a600, 0xfff1fe01, 0xff9b833d, 0xff67666b, 0xff65666a, 0xffb9bd1e, 0xffeff402, 0xfff2df00, 0xfff20070, 0xffe3005a, 0xffbc234f, 0xffffca00, 0xffe8f102, 0xffbbbc20, 0xff828349, 0xff737359, 0xfff2fb02, 0xffd18800, 0xff9b0163, 0xffe2006c, 0xffe3ea06, 0xffc3cb13, 0xffebf000, 0xfff4db02, 0xff7e2076, 0xffd22a0d, 0xfff2fd00, 0xffe0e703, 0xffa7ae2a, 0xffaaaf2e, 0xff9d0060, 0xffe10186, 0xff9d2e8d, 0xfffee705, 0xffecf400, 0xffe2ea01, 0xff8c9044, 0xff73735b, 0xffe8f100, 0xffe1e700, 0xff84834d, 0xff686868, 0xff82804f, 0xffe8f301, 0xffe9f702, 0xffc5cd18, 0xff8c9141, 0xff656364, 0xffc6cb16, 0xffe6f100, 0xffa9af2b, 0xff83834f, 0xff67656a, 0xff626665]
				); 
        }
		public function box15():BitmapData{  
             return BitmapPatternBuilder.build( 
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,3,4,5,4,0,4,4,2,6,7,0,8,0,9,10,5,11,12,13,14,15,16,17,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,18,9,19,4,9,15,14,8,20,21,22,23,0,8,17,24,17,0,2,25,0,26,27,28,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8,8,0,0,0,0,17,20,20,28,19,29,29,19,4,30,31,4,2,0,19,32,19,20,1,5,0,33,24,34,19,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,28,0,0,0,0,22,17,35,11,36,2,6,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,7,53,22,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,9,11,54,55,43,52,42,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,9,52,1,71,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,19,11,40,39,72,41,73,74,72,42,75,76,77,78,48,79,80,80,81,81,64,67,67,67,67,67,67,67,67,67,67,67,82,83,84,64,85,86,87,88,0,2,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,5,89,90,56,91,92,93,94,95,79,80,96,97,98,99,100,101,102,102,67,67,67,67,67,67,67,67,67,67,67,67,67,67,103,104,105,99,106,107,108,109,110,22,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,111,112,104,104,113,67,81,81,114,115,99,102,82,102,82,115,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,116,67,117,118,119,120,107,121,122,123,0,0,0,5,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,124,67,82,65,81,125,64,126,64,127,64,64,81,115,125,117,102,102,67,67,67,67,67,67,67,67,67,67,67,67,67,67,84,64,117,128,129,130,120,131,132,133,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,4,134,135,104,117,136,137,64,115,64,117,138,139,140,116,138,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,141,115,115,142,143,86,144,106,120,145,134,4,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,4,37,146,81,147,115,100,82,139,125,127,105,82,125,148,67,115,149,67,67,67,67,102,67,67,67,67,67,67,67,67,67,67,67,115,150,66,151,106,152,119,143,86,130,153,134,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,5,1,39,5,154,125,102,67,67,102,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,125,67,155,152,120,156,156,156,157,106,158,159,8,32,36,35,0,0,0,0,0], 
    [0,0,0,0,0,27,28,39,4,160,161,102,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,125,148,162,86,163,156,156,156,156,157,156,164,89,11,1,30,0,0,0,0,0], 
    [0,0,0,0,0,4,20,17,1,92,165,67,67,67,67,82,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,115,149,166,156,130,157,167,106,156,156,119,129,168,9,5,4,0,0,0,0,0], 
    [0,0,0,0,0,0,14,20,37,169,148,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,64,170,171,143,172,157,106,167,156,156,130,107,173,88,8,0,0,0,0,0,0], 
    [0,0,0,0,0,22,27,28,174,140,115,102,82,67,67,115,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,103,175,176,130,120,157,157,157,156,156,167,120,119,177,178,17,0,0,0,0,0], 
    [0,0,0,0,0,179,180,11,43,181,114,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,182,183,184,130,156,157,157,157,157,157,129,185,186,120,88,8,28,9,2,28,0], 
    [0,0,0,0,0,0,9,52,187,117,105,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,188,189,120,166,119,157,157,157,157,157,143,156,190,172,191,192,16,31,0,5,0], 
    [0,0,0,0,0,193,134,194,195,102,82,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,196,197,130,198,143,157,157,157,157,157,86,199,157,86,166,200,28,201,1,110,0], 
    [0,0,0,0,0,28,28,202,139,67,81,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,203,156,129,130,197,157,157,157,157,157,86,204,205,197,198,206,207,42,8,8,208], 
    [0,0,0,0,0,209,19,210,125,99,115,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,121,171,129,130,120,157,157,157,157,157,143,156,211,106,121,157,212,213,17,9,21], 
    [0,0,0,0,0,27,41,125,83,84,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,115,115,64,101,149,83,157,214,157,129,130,157,157,157,157,157,157,157,157,157,157,157,215,216,134,22,28], 
    [0,0,0,0,0,22,217,81,141,64,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,64,115,139,84,139,218,106,205,156,106,156,157,157,157,157,157,157,157,157,157,157,157,143,130,219,31,17], 
    [0,0,0,0,0,220,221,84,101,84,222,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,84,115,223,104,64,224,172,106,129,130,86,157,157,157,157,157,157,157,157,157,157,157,185,86,215,225,4], 
    [0,0,0,28,0,226,49,117,67,115,102,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,125,139,140,102,227,228,129,156,163,204,130,157,157,157,157,157,157,157,157,157,157,157,129,129,121,229,201], 
    [0,0,0,0,201,230,231,84,67,127,140,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,103,102,102,64,232,143,107,106,130,130,172,157,157,157,157,157,157,157,157,157,157,157,106,167,167,106,233], 
    [0,0,1,0,201,234,117,115,82,102,81,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,115,102,235,140,236,197,152,130,106,156,130,157,157,157,157,157,157,157,157,157,157,157,130,106,86,204,215], 
    [71,7,8,237,73,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,105,64,102,64,143,156,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,106,156,167,238], 
    [123,21,15,28,239,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,115,100,235,240,241,152,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,86,205,143,86,242], 
    [20,30,14,90,243,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,244,115,99,245,86,130,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,106,198,246,86,247], 
    [17,248,180,249,234,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,101,104,250,251,246,252,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,166,253,167,254,255], 
    [22,256,201,195,102,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,102,148,103,257,205,120,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,130,166,185,258,259], 
    [31,0,21,62,115,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,148,260,261,163,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,130,86,156,262,123], 
    [4,2,73,125,139,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,102,64,263,120,106,167,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,129,107,130,264,4], 
    [201,209,265,105,64,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,266,84,130,143,197,106,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,252,86,254,267,20], 
    [0,268,269,115,81,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,64,102,204,143,143,120,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,130,156,270,271,272], 
    [0,273,243,115,147,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,67,99,227,86,106,156,107,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,120,163,274,275,179], 
    [4,78,99,104,137,67,67,67,67,67,67,67,82,67,67,102,67,67,67,67,67,67,67,125,102,67,67,67,67,67,67,67,115,115,101,115,115,102,276,130,163,156,206,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,130,214,277,37,28], 
    [123,96,278,66,147,67,67,67,67,67,67,82,102,125,125,82,102,102,102,102,102,103,136,67,67,67,82,67,67,67,67,67,102,102,103,125,125,100,279,246,143,86,163,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,172,205,280,201,1], 
    [281,83,282,67,127,115,115,115,115,115,115,64,64,117,117,102,102,102,102,102,102,64,64,115,115,125,103,115,115,115,115,115,82,67,82,67,140,251,120,163,152,283,205,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,156,284,73,19,134], 
    [285,102,139,115,102,64,64,64,64,64,64,82,67,115,115,64,67,67,67,67,67,116,116,67,67,222,140,67,67,67,67,67,64,64,81,64,100,286,252,130,129,163,106,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,152,108,287,19,28], 
    [288,289,290,291,292,293,293,293,293,293,293,292,294,295,296,297,297,297,297,297,297,295,295,298,299,300,301,302,302,302,302,302,303,302,302,300,303,253,120,129,121,130,252,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,106,304,305,0,4], 
    [217,306,307,308,309,310,310,310,310,310,310,311,312,310,310,308,310,310,310,310,310,310,307,307,310,313,313,313,313,313,313,313,310,310,313,307,313,314,129,205,86,86,315,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,157,143,316,179,30,2], 
    [0,317,318,319,320,310,321,322,307,323,324,308,325,326,308,327,307,307,307,307,307,327,307,327,307,328,320,321,329,320,320,328,307,328,323,325,307,329,330,86,331,131,152,167,156,129,167,167,157,157,157,157,157,157,157,157,157,157,157,332,333,5,15,1], 
    [17,134,17,334,335,320,320,310,328,336,336,337,338,339,340,341,342,342,342,342,342,343,343,344,345,344,345,346,346,346,347,346,338,348,349,308,310,320,350,351,107,166,106,167,156,129,129,129,157,157,157,157,157,157,157,157,157,157,157,352,353,15,4,4], 
    [1,22,6,21,41,354,310,355,327,356,357,358,359,360,361,362,363,363,363,363,363,360,363,360,363,364,365,366,367,368,367,366,369,370,371,372,323,320,307,311,373,331,167,106,130,130,156,120,157,157,157,157,157,157,157,157,157,157,157,374,375,8,30,6], 
    [37,28,0,20,22,376,377,378,379,380,381,382,362,383,384,385,386,386,386,386,386,386,387,388,389,388,390,391,392,392,392,392,393,394,395,396,397,328,310,321,398,399,206,106,143,106,156,120,157,157,157,157,157,157,157,157,157,157,157,400,31,8,2,28], 
    [8,401,5,13,14,24,27,402,403,310,379,404,405,406,407,387,386,386,386,386,386,385,386,385,385,408,409,391,410,411,394,411,392,412,413,414,415,416,417,320,321,307,418,419,106,130,197,167,157,157,157,157,157,157,157,157,157,157,157,420,421,201,14,17], 
    [0,0,0,0,0,39,180,422,423,307,320,424,425,426,359,427,428,386,383,389,429,363,383,389,362,430,431,367,367,367,367,367,367,367,367,367,392,432,433,320,434,328,435,436,437,246,130,130,120,130,106,106,106,163,119,106,106,86,166,90,19,39,8,401], 
    [0,0,0,0,0,71,26,0,20,438,439,308,320,440,441,365,406,428,442,385,443,444,389,388,389,445,367,367,367,367,367,367,367,367,367,367,367,391,446,447,327,448,307,322,449,211,166,156,106,106,106,166,106,205,106,86,163,315,450,1,180,11,23,6], 
    [0,0,0,0,0,2,30,7,19,259,451,435,310,350,452,453,363,454,386,362,387,386,383,362,385,455,456,367,367,367,367,367,367,367,367,367,367,457,456,458,440,312,459,460,309,436,171,156,143,106,106,156,106,130,106,211,167,197,461,8,28,30,0,20], 
    [0,0,0,0,0,8,0,462,28,201,6,463,464,379,324,310,465,466,364,389,467,385,468,386,469,470,367,367,367,367,367,367,367,367,367,367,367,367,411,455,471,397,311,327,472,308,473,474,130,130,106,106,130,167,157,167,86,475,476,28,39,19,4,22], 
    [0,0,0,0,0,193,477,27,28,478,30,7,479,480,481,435,328,482,483,484,386,385,383,485,408,486,392,367,367,367,367,367,367,367,367,367,367,414,487,488,456,489,433,309,378,307,307,490,171,130,167,106,129,106,129,106,106,191,491,19,4,110,1,9], 
    [0,0,0,0,0,0,0,0,0,0,0,201,492,493,494,313,321,330,495,496,497,498,388,386,499,488,411,391,500,501,411,391,502,392,413,503,504,414,392,504,500,367,505,433,320,310,322,320,506,507,197,130,106,129,198,130,86,508,249,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,1,509,36,26,510,313,511,512,513,514,497,497,515,516,517,518,367,367,392,367,367,519,520,366,486,367,521,522,391,367,456,392,523,524,525,310,526,323,527,143,130,120,120,106,86,156,528,42,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,9,28,1,28,529,530,531,378,307,310,532,533,534,535,411,521,536,537,367,456,393,486,411,538,367,487,367,410,367,413,414,392,367,539,540,321,320,308,321,506,167,86,143,120,130,86,541,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,28,4,7,17,509,248,542,543,310,327,544,545,546,547,548,366,549,414,410,391,487,413,456,367,456,550,413,456,551,521,367,503,552,536,553,554,307,481,321,321,555,167,556,86,157,119,557,1,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,28,28,134,0,89,9,2,39,558,308,320,323,559,347,338,560,561,562,214,563,564,565,566,567,568,569,570,571,572,573,574,575,576,577,366,578,579,307,307,472,327,580,86,106,106,581,39,9,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,4,110,582,28,14,4,28,22,583,584,308,329,312,320,327,327,328,321,309,449,313,585,341,342,340,586,587,588,589,590,591,592,564,593,594,595,596,321,323,311,511,435,597,106,143,581,16,598,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,22,179,134,599,600,600,600,601,602,603,604,605,606,607,608,609,610,611,612,611,473,613,308,311,614,310,307,307,310,310,321,321,379,481,312,320,615,121,616,5,31,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,617,4,618,619,17,19,9,30,0,18,134,620,621,622,623,624,623,557,625,626,627,628,629,630,631,632,633,634,635,636,335,637,638,308,308,310,310,474,639,27,17,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,19,5,17,640,641,37,5,4,37,28,0,19,0,180,22,22,6,134,0,0,4,1,0,30,4,0,4,9,0,0,0,39,52,37,642,643,644,600,645,646,28,180,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,557,4,0,28,0,4,28,28,0,0,0,5,37,27,0,110,9,9,4,4,4,0,19,237,2,1,19,0,0,0,0,8,1,9,509,201,14,647,2,9,35,201,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,19,4,0,0,0,0,0,0,28,0,28,17,27,28,0,0,0,0,0,8,28,0,22,9,17,0,32,28,0,19,28,0,9,28,4,28,648,649,15,11,8,0,0,0,0,0]
],
[0xff666666, 0xff656766, 0xff656764, 0xff636564, 0xff666664, 0xff656565, 0xff656563, 0xff666467, 0xff676566, 0xff676767, 0xff626665, 0xff666563, 0xff62676a, 0xff636862, 0xff66656a, 0xff646663, 0xff656762, 0xff656668, 0xff676862, 0xff676769, 0xff666465, 0xff65666a, 0xff676568, 0xff646569, 0xff686765, 0xff636864, 0xff68686a, 0xff666867, 0xff666668, 0xff656469, 0xff656567, 0xff696566, 0xff67666b, 0xff65646a, 0xff636466, 0xff666865, 0xff676662, 0xff676863, 0xff686762, 0xff666762, 0xff676860, 0xff696863, 0xff6b6764, 0xff686963, 0xff8d833c, 0xff91803a, 0xffb69c13, 0xffb99d16, 0xffc9a708, 0xffc7a506, 0xffcaa906, 0xffe4bb07, 0xff686763, 0xff636969, 0xff6b6766, 0xff686964, 0xff746d5a, 0xff917e3a, 0xffac961f, 0xffc0a206, 0xffc8a606, 0xffc5a806, 0xffc8a903, 0xffc6a903, 0xffcbab02, 0xffcea701, 0xffccab04, 0xffccaa00, 0xffceac04, 0xffd7c300, 0xfffbc200, 0xff656661, 0xff686866, 0xff696961, 0xff6a6762, 0xff8f8138, 0xff998733, 0xffba9b0f, 0xffc8a704, 0xffc8a805, 0xffc9a801, 0xffcaaa01, 0xffcba900, 0xffcdab01, 0xffcea900, 0xfff1dd00, 0xffffc700, 0xffe9b509, 0xff6a6c5e, 0xff686669, 0xff686860, 0xff8e813b, 0xffa48f26, 0xffb79b14, 0xffc7a603, 0xffcca607, 0xffcaa904, 0xffcba806, 0xffcba804, 0xffcbaa03, 0xffccac03, 0xffcaac00, 0xffccaa02, 0xffcdab03, 0xffcea902, 0xffcda800, 0xffffc501, 0xfffdc800, 0xfffcc506, 0xffc09c22, 0xff686667, 0xff867d42, 0xffc7aa06, 0xffceaa00, 0xffcda802, 0xffcbab00, 0xffccab00, 0xffcca903, 0xffcbad00, 0xfffcc700, 0xfffec600, 0xfffdc500, 0xff6b6c5c, 0xff696564, 0xffc29e0c, 0xffcba901, 0xffccab06, 0xffcaa902, 0xffcdad00, 0xffffc702, 0xfffec601, 0xffffc803, 0xffcda31d, 0xff6c6865, 0xff676765, 0xffc9a900, 0xffcaa800, 0xffcfab00, 0xffcda801, 0xffcaab02, 0xffcaaa00, 0xffcdac00, 0xffdbe302, 0xffffc603, 0xfffdc705, 0xfff1b807, 0xffcbaa05, 0xffcaa701, 0xffcba802, 0xffcbac03, 0xffcfa802, 0xfff4da00, 0xffffc401, 0xff696a65, 0xff998731, 0xffdddd03, 0xffffc500, 0xffffc600, 0xfff4be04, 0xff7a6f59, 0xff6a6c61, 0xffc9a205, 0xffe3e600, 0xffffc502, 0xffe7b506, 0xffc6aa00, 0xfffec400, 0xffffc602, 0xff85784c, 0xffc7a305, 0xffcbad01, 0xfffec901, 0xfffdc702, 0xffeab409, 0xff686868, 0xffcfb500, 0xffffc704, 0xfff5bf05, 0xff696562, 0xff636766, 0xff67656a, 0xffc9ae00, 0xffccac00, 0xffdcd200, 0xffffc503, 0xffffc301, 0xfffcc604, 0xffa59025, 0xffceac02, 0xfff6d400, 0xffffc703, 0xfffcc304, 0xff8e7f46, 0xff666769, 0xff6c6763, 0xffc6a605, 0xffd5c300, 0xfffcc601, 0xffffc402, 0xffffc400, 0xfff1b902, 0xff676664, 0xffad9322, 0xfff2e304, 0xfffcc602, 0xfffec502, 0xffffc801, 0xff9a873b, 0xff65685f, 0xff646567, 0xffc7a505, 0xffffc800, 0xfff0b904, 0xff7a7055, 0xffffc404, 0xfffec504, 0xfffbc503, 0xff696a64, 0xffcdaf03, 0xff777255, 0xff67675f, 0xffbfa208, 0xffccac01, 0xffcbaa00, 0xffdbe000, 0xffc29b22, 0xff686b60, 0xffcead00, 0xffefe200, 0xfff3c204, 0xffbfa10d, 0xffcfa900, 0xffd9d301, 0xffcfa712, 0xffc7a802, 0xffcea800, 0xffe0e600, 0xff646462, 0xfff7bd02, 0xff69695f, 0xffcdad02, 0xfffdc903, 0xffdcac0c, 0xffc7a706, 0xffcea903, 0xffd2b301, 0xffffc300, 0xff85794f, 0xff676661, 0xff6c6962, 0xffcdac05, 0xffdcd000, 0xfffdc703, 0xffffc605, 0xfffbc500, 0xff6d6a61, 0xff61696b, 0xfff6d200, 0xfffdc405, 0xff696866, 0xffd4bc04, 0xfffcc705, 0xfff8c301, 0xffefe900, 0xffe9b603, 0xff746e56, 0xffcda900, 0xffcda418, 0xff67695e, 0xffc5a907, 0xfff9c404, 0xff6b6a68, 0xff626763, 0xff7d754e, 0xffeeb704, 0xff6a6a62, 0xffe0de00, 0xffa88f32, 0xffc9ab00, 0xffebeb00, 0xff786d5b, 0xff696c65, 0xffc9a803, 0xfffbc701, 0xfffbc501, 0xff8b7b3f, 0xffd4e501, 0xff6a686b, 0xffb2a824, 0xffeff000, 0xffeeeb00, 0xffefed02, 0xfff0ed00, 0xfff0ed02, 0xffede602, 0xffe3d800, 0xffe6d803, 0xffe5d800, 0xffe7d801, 0xffe4d402, 0xffd7c000, 0xffd8c004, 0xffd8c101, 0xffd9c200, 0xfff1bb03, 0xff646368, 0xffeaf209, 0xfff5ff01, 0xfff3fe00, 0xfff7fe01, 0xfff4fe00, 0xfff5fe03, 0xfff6ff02, 0xfff3fd00, 0xfffbee01, 0xfffec900, 0xffe5b105, 0xff666761, 0xff7c7e59, 0xfff3fc03, 0xfff5ff00, 0xfff4ff00, 0xfff3ff01, 0xfff6fd00, 0xfff3fe02, 0xfff6ff01, 0xfff8ff01, 0xfff4ff01, 0xfff3ff00, 0xfff7fe00, 0xfff5fe05, 0xfffbca01, 0xfffac306, 0xff8d7c44, 0xffdbe008, 0xfff2fb00, 0xfff0f805, 0xffeff706, 0xfff2f504, 0xfff5f406, 0xfff2f705, 0xfff1f604, 0xfff1f703, 0xffeff704, 0xffeff703, 0xfff2f804, 0xfff3f607, 0xfff6f507, 0xfff5f507, 0xfff5f700, 0xfff1fe00, 0xfffeee05, 0xfff6c004, 0xff6e6b64, 0xffeaf505, 0xfff2fe00, 0xffcd8807, 0xffa00c48, 0xff950250, 0xff97004d, 0xff98024c, 0xff970246, 0xff97014b, 0xff98014e, 0xff99014e, 0xff9a024d, 0xffee016d, 0xfff0006d, 0xffed016d, 0xfff3006e, 0xffec006e, 0xfff00468, 0xfff4ef00, 0xfff1fd00, 0xffcea519, 0xff6a6663, 0xff949740, 0xffe3eb00, 0xfff5ff02, 0xfff4ff03, 0xfff3f903, 0xffdea203, 0xff9c024a, 0xff9a004b, 0xff95034c, 0xff980049, 0xff98004b, 0xff99014c, 0xff99014a, 0xff970149, 0xffa7014b, 0xfff1016c, 0xfff0006b, 0xffed006a, 0xffef026c, 0xffef006e, 0xffda3313, 0xfff5ef03, 0xfff9fe02, 0xfffedc00, 0xff99853c, 0xff636768, 0xffdbe10b, 0xfff1fd03, 0xfff2eb05, 0xff92237f, 0xff9b014a, 0xff980148, 0xff99034b, 0xffd9035b, 0xfff2016c, 0xfff1006b, 0xfff20271, 0xfff00169, 0xfff2006e, 0xffef0368, 0xfff3f100, 0xfff3fe04, 0xfff1fc00, 0xfffaca00, 0xff6d6862, 0xff646869, 0xff6e6b62, 0xffb7bd1f, 0xfffafd00, 0xfff0ee06, 0xff9a034a, 0xff9c004c, 0xff990249, 0xff950248, 0xffa5004d, 0xffeb0069, 0xffd93416, 0xfff2f101, 0xfff6fe00, 0xfff7fe03, 0xfffedc01, 0xfffac900, 0xff909545, 0xffe6ee05, 0xfff3f202, 0xffd08707, 0xff98024a, 0xff970148, 0xff9a0049, 0xffd9005b, 0xffeb0464, 0xfff2f100, 0xfff4fd02, 0xfff4fb00, 0xfffbc105, 0xff7a7d52, 0xfff8fa01, 0xff9e105c, 0xff990050, 0xfff0006c, 0xfff1016e, 0xfff10070, 0xffd93617, 0xfff8fe00, 0xfff7fc00, 0xfff2ba05, 0xff676966, 0xff6d705b, 0xffc1c81a, 0xfff1ed08, 0xff96024c, 0xff96004a, 0xff96034a, 0xff9b004e, 0xffee016b, 0xffee0467, 0xfff2ff00, 0xfff1fc02, 0xfffbc604, 0xfffcc300, 0xffb49129, 0xff666561, 0xff66656b, 0xff6a6c5f, 0xffecf602, 0xfff8ff02, 0xff962f4d, 0xff9a0549, 0xff9a024f, 0xff9b0049, 0xfff10170, 0xfff0006f, 0xfff10069, 0xffd83516, 0xfffed201, 0xff857754, 0xff626667, 0xff666863, 0xff7b7c52, 0xfff0f600, 0xffa40c57, 0xff98004d, 0xff95014b, 0xffc90157, 0xfff2016a, 0xffee006f, 0xffee0169, 0xfff1006f, 0xffef006c, 0xffee0264, 0xffecfb00, 0xfffcc803, 0xffe8b705, 0xff6a6665, 0xffdde305, 0xfff7ff00, 0xfff5ff04, 0xffedd008, 0xffa41157, 0xff9e004f, 0xffe60065, 0xfff3006a, 0xfff00070, 0xfff2006d, 0xfff10071, 0xfff1026a, 0xfff1006d, 0xffd83315, 0xfff7ef06, 0xfff8ff00, 0xfff7fd00, 0xfffecf03, 0xffc19d22, 0xff616564, 0xff6a6d62, 0xffedf804, 0xff892d5e, 0xff960250, 0xffc3004f, 0xffef0066, 0xfff3016f, 0xfff2006b, 0xfff20267, 0xffee0266, 0xfff0f100, 0xff716b5f, 0xff8f9440, 0xffebf405, 0xffe9f205, 0xff962e4f, 0xffe50067, 0xffee026e, 0xfff20070, 0xfff0006a, 0xffee0267, 0xfff2026f, 0xffef006a, 0xffd83514, 0xfff1f103, 0xfffdd001, 0xffffc505, 0xff6a6965, 0xffe0e809, 0xfff1f606, 0xfff6f505, 0xfff7f608, 0xfff5f602, 0xfff0a305, 0xfff1a104, 0xffe77208, 0xffae3874, 0xffb3367a, 0xffc823a5, 0xffde0a9a, 0xffe20a99, 0xffe6087f, 0xfff00967, 0xfff0086b, 0xfff00969, 0xffed0767, 0xfff2076c, 0xfff20668, 0xffea0464, 0xfff2f800, 0xfff0fb00, 0xfffac304, 0xff64646c, 0xff716f60, 0xffdce407, 0xfff3fa00, 0xfff5f509, 0xfff6f705, 0xfff2f707, 0xfff7f605, 0xfff3f605, 0xfffedc08, 0xfff2a203, 0xfff09e0a, 0xffaf3777, 0xffac3974, 0xfffbf106, 0xffffca02, 0xff666469, 0xff6a6a60, 0xff6b6b61, 0xff6e6c60, 0xff767757, 0xff9ca236, 0xff9ea234, 0xffcfd80b, 0xffd3d70e, 0xffdde303, 0xffe5ef05, 0xffe4eb07, 0xffe8f007, 0xfff1fb04, 0xffeff807, 0xfff2fc05, 0xfff6fd02, 0xfff2fc00, 0xffd7ab0e, 0xff656366, 0xff626669, 0xff65666b, 0xff696a62, 0xff696b60, 0xff696b68, 0xff6b6b63, 0xff6b6a66, 0xff6c6c62, 0xff9c9f36, 0xff9ca238, 0xffa0a235, 0xffcdd90d, 0xffd0d809, 0xffd1da0d, 0xffe5ed04, 0xffe4ec03, 0xfff0f908, 0xfff0fa06, 0xfff0fa05, 0xfff2fb02, 0xfff3fc05, 0xffaa8c34, 0xff656364, 0xff68666b, 0xff696969, 0xff6b6a65, 0xff686a5f, 0xff686c5e, 0xff696b5e, 0xff676968, 0xff626962, 0xff6a6466]
				); 
        }
		public function box16():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,1,17,13,19,0,0,0,15,20,13,0,1,21,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,13,1,13,0,0,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,21,0,15,18,0,16,37,38,39,13,40,0,41,0,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,1,1,42,43,44,28,45,43,46,47,5,29,27,48,49,50,51,52,35,53,54,17,0,55,15,56,57,58,54,1,0,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,59,60,16,37,61,62,63,64,65,28,66,28,67,25,24,28,68,69,70,26,71,25,24,72,73,74,75,76,77,78,57,79,0,61,79,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,13,18,81,1,82,83,84,26,26,25,25,67,47,64,25,29,65,85,86,47,87,28,28,28,88,47,89,90,91,92,93,94,95,96,81,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,97,16,38,98,99,100,25,25,47,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,101,102,103,104,105,106,107,108,109,1,16,17,110,59,0,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,38,37,79,111,112,113,25,25,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,27,114,115,116,117,118,119,119,96,79,41,120,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,15,41,121,122,123,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,67,26,25,5,5,85,29,29,88,124,125,31,126,127,57,59,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,1,13,128,129,86,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,64,25,28,44,130,67,25,45,26,29,130,131,132,133,98,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,41,16,134,135,47,25,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,136,26,28,28,28,5,137,68,26,24,137,138,139,140,79,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,81,141,142,86,87,25,47,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,65,25,65,25,25,28,136,25,47,25,26,143,144,145,146,147,0,0,0,0,0], 
    [0,0,0,0,0,0,0,16,56,41,148,53,149,150,151,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,28,152,26,28,47,153,154,155,156,157,158,1,41,19,60,37], 
    [0,0,0,0,0,21,0,13,21,81,19,159,160,24,161,28,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,44,88,162,64,87,163,164,165,166,167,168,1,0,0,39,0], 
    [0,0,0,0,0,109,109,21,18,16,169,170,87,65,162,88,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,143,26,143,26,137,171,172,173,174,175,176,0,60,177,13,57], 
    [0,0,0,0,0,41,1,177,177,81,178,179,5,65,25,85,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,87,136,180,181,25,182,183,165,184,185,186,14,187,0,1,1], 
    [0,0,0,0,0,177,16,39,13,188,189,47,137,162,45,6,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,65,26,135,190,191,192,193,173,194,195,196,106,81,59,21,81], 
    [0,0,0,0,0,54,16,79,56,197,142,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,26,47,65,198,199,166,166,166,166,166,166,200,41,201,16,16], 
    [0,0,0,0,0,80,202,38,203,204,71,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,47,150,85,205,192,166,166,166,166,166,166,206,207,0,2,13], 
    [0,0,0,0,0,13,148,208,209,27,87,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,65,210,70,211,195,166,166,166,166,166,166,212,213,81,79,0], 
    [0,0,0,0,0,16,39,214,215,29,67,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,87,216,217,218,219,166,166,166,166,166,166,220,221,0,0,16], 
    [0,0,0,0,0,222,41,223,224,26,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,28,225,226,227,228,166,166,166,166,166,166,229,230,21,41,222], 
    [41,1,59,231,39,38,232,130,28,28,88,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,233,47,85,47,64,5,234,145,235,166,166,166,166,166,166,166,236,237,238,41,59], 
    [60,239,13,240,61,241,242,47,47,26,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,87,143,67,26,88,216,243,145,183,244,166,166,166,166,166,166,183,245,178,202,18], 
    [21,38,18,246,54,247,248,28,47,249,28,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,47,124,85,250,251,252,183,229,219,166,166,166,166,166,166,183,253,254,255,81], 
    [256,59,39,257,258,259,137,44,28,28,65,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,65,68,28,181,260,261,262,263,165,264,166,166,166,166,166,166,193,183,265,266,13], 
    [246,13,267,268,269,27,28,25,47,181,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,88,88,136,6,270,218,165,271,184,272,166,166,166,166,166,166,273,194,274,275,1], 
    [37,98,41,276,42,25,47,87,47,130,65,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,87,181,277,278,279,219,262,273,235,165,166,166,166,166,166,166,263,244,280,281,201], 
    [16,59,39,282,283,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,46,65,284,285,194,166,166,166,166,166,166,166,166,166,166,166,263,195,262,286,39], 
    [41,16,287,288,47,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,67,26,289,290,244,166,166,166,166,166,166,166,166,166,166,166,263,166,244,291,292], 
    [16,82,293,5,181,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,6,136,294,295,183,166,166,166,166,166,166,166,166,166,166,166,264,235,166,195,296], 
    [297,298,7,5,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,67,299,300,219,219,166,166,166,166,166,166,166,166,166,166,166,195,262,229,194,301], 
    [302,303,130,29,65,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,304,305,166,227,166,166,166,166,166,166,166,166,166,166,166,166,262,194,165,273,306], 
    [307,308,86,309,5,67,28,25,5,46,25,46,25,137,150,85,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,6,25,309,24,152,310,311,236,312,263,166,166,166,166,166,166,166,166,166,166,166,165,185,227,183,313], 
    [314,315,316,317,143,87,181,46,29,153,26,26,26,65,137,87,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,87,70,47,46,318,181,144,219,185,244,319,166,166,166,166,166,166,166,166,166,166,166,244,262,235,320,321], 
    [322,323,324,325,326,327,181,28,28,25,47,25,5,25,5,28,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,29,65,5,137,162,328,329,156,272,165,173,166,166,166,166,166,166,166,166,166,166,166,252,264,330,331,41], 
    [37,332,333,334,335,336,337,338,339,340,341,26,26,25,47,65,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,181,28,24,24,342,343,219,344,173,165,264,166,166,166,166,166,166,166,166,166,166,166,173,252,345,346,0], 
    [13,347,348,349,350,335,335,351,352,353,354,355,356,25,27,28,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,47,88,47,47,357,358,194,173,194,262,262,166,166,166,166,166,166,166,166,166,166,166,273,262,359,292,39], 
    [13,79,80,360,361,335,362,363,334,364,365,366,367,368,369,370,371,123,5,67,162,123,29,28,25,85,5,28,5,25,25,87,25,65,65,25,25,25,27,46,136,372,264,166,166,166,166,166,166,166,166,166,166,165,194,244,262,263,194,229,373,374,109,59], 
    [148,17,16,375,376,377,378,379,380,381,382,383,364,384,385,386,387,388,389,341,29,26,47,65,47,151,24,5,47,28,181,390,65,25,25,25,25,391,150,88,392,393,183,166,166,166,166,166,166,166,166,166,166,173,166,173,166,165,165,183,394,395,19,257], 
    [0,17,17,19,396,397,398,334,399,400,401,402,403,404,405,406,335,407,408,409,410,411,412,413,181,26,137,150,46,27,5,5,25,65,25,25,25,67,152,414,415,183,173,166,166,166,166,166,166,166,166,166,166,166,165,262,262,165,166,416,417,1,21,16], 
    [81,59,61,418,39,419,420,421,366,422,423,424,425,426,427,428,429,350,430,431,379,336,432,261,433,434,435,28,87,28,87,46,25,25,25,25,25,25,277,436,437,244,195,166,166,166,166,166,166,166,166,166,166,166,262,166,173,262,166,438,140,38,41,41], 
    [0,13,79,79,439,440,441,442,334,443,444,445,446,447,448,449,450,451,452,453,454,384,455,456,334,408,457,458,459,460,461,85,46,25,25,25,25,5,250,462,174,227,252,166,166,166,166,166,166,166,166,166,166,183,263,173,165,264,463,464,41,202,81,0], 
    [0,13,17,465,1,81,466,467,468,335,469,470,471,472,473,474,473,475,476,477,478,479,480,481,350,334,335,482,483,484,485,486,328,25,65,25,25,87,327,487,252,166,262,166,166,166,166,166,166,166,166,166,166,183,183,173,173,488,489,141,38,79,15,13], 
    [0,0,0,0,0,14,15,490,491,379,378,492,493,494,495,473,448,447,448,447,474,496,497,498,499,500,501,502,503,365,334,362,443,504,505,412,506,340,507,166,344,166,194,166,166,166,166,166,166,166,166,166,166,184,508,194,165,509,510,59,16,59,1,0], 
    [0,0,0,0,0,38,109,511,512,513,364,514,515,516,517,473,447,494,446,473,447,518,519,520,521,522,523,524,525,526,527,456,363,528,408,529,530,531,532,488,173,252,263,166,166,166,166,166,166,166,166,166,166,235,252,264,219,212,533,13,109,13,1,41], 
    [0,0,0,0,0,0,177,60,13,534,535,363,536,537,538,539,447,539,540,474,541,542,543,544,545,546,543,547,543,548,549,550,551,552,553,363,334,363,554,165,185,555,264,166,166,166,166,166,166,166,166,166,166,263,262,195,556,557,558,1,0,1,16,0], 
    [0,0,0,0,0,202,60,1,13,559,560,364,364,561,562,472,563,540,539,473,564,565,566,566,547,543,567,568,546,546,569,570,571,572,573,379,362,365,408,574,264,174,263,166,166,166,166,166,166,166,166,166,166,183,244,165,575,576,16,0,177,1,0,0], 
    [0,0,0,0,0,0,1,13,41,577,287,578,579,456,580,581,471,473,582,583,584,544,585,544,586,587,547,588,586,589,587,590,591,587,592,593,365,335,594,595,596,263,165,166,166,166,166,166,166,166,166,166,166,194,244,597,598,0,97,13,81,0,41,0], 
    [0,0,0,0,0,0,0,0,0,0,0,599,600,601,602,603,604,605,474,606,607,543,566,608,585,543,588,544,544,544,544,544,546,609,587,610,611,335,456,612,613,227,264,262,194,194,183,166,166,166,166,166,166,264,614,615,616,15,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,241,617,618,406,619,620,621,622,623,543,624,546,625,567,609,546,544,544,544,544,544,626,545,627,628,629,377,364,379,367,630,165,263,194,262,227,173,166,166,166,166,166,263,244,631,287,18,13,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,109,632,633,634,379,503,635,636,627,637,638,625,586,565,585,587,544,544,544,544,544,547,639,543,640,641,642,468,456,643,644,194,165,263,262,165,263,166,166,166,166,166,271,645,140,646,59,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,56,177,647,648,456,334,649,650,651,652,653,585,654,627,588,655,544,544,544,544,544,587,544,546,656,639,657,658,601,362,612,659,165,165,219,194,194,166,166,166,166,166,660,661,79,16,98,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,177,18,61,559,662,663,365,664,665,525,666,667,668,627,546,543,544,544,544,544,544,566,567,587,669,588,670,671,672,594,366,673,235,227,183,264,185,166,166,166,166,166,674,510,1,59,1,13,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,1,1,13,0,675,676,677,678,679,680,430,681,682,683,684,685,686,687,626,588,544,587,655,543,626,543,688,689,690,335,365,379,691,264,264,252,228,166,264,692,166,219,693,694,21,0,16,38,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,1,13,13,268,0,695,676,696,697,698,699,700,701,702,703,704,705,706,707,708,543,709,625,567,544,608,710,711,430,365,377,712,713,227,262,263,183,262,194,165,183,714,41,80,715,109,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,13,59,81,13,716,717,718,719,535,663,379,349,720,721,722,723,724,725,546,726,566,725,727,728,350,334,729,730,156,263,166,227,166,194,183,731,39,13,1,1,13,38,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,13,0,1,1,61,16,1,13,38,21,39,732,733,734,491,698,352,362,364,735,736,737,738,739,740,655,543,741,742,407,379,602,681,156,252,264,174,264,227,743,744,37,38,21,256,15,13,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13,79,18,109,59,59,14,38,111,61,59,41,745,746,747,748,749,750,363,379,502,751,752,753,754,755,756,482,334,379,757,758,235,252,185,183,759,760,1,256,187,41,16,16,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,17,256,13,1,109,1,148,177,60,37,222,13,20,761,762,763,764,765,766,455,335,767,768,551,769,770,771,334,335,772,773,166,194,264,183,774,775,41,16,59,109,81,187,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,39,14,776,777,778,779,780,781,456,379,430,365,377,335,379,782,145,263,783,784,785,201,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,17,13,54,776,786,787,788,789,790,363,335,536,379,335,406,791,262,792,793,97,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,79,0,0,0,1,16,16,13,18,81,79,395,794,795,796,797,781,362,798,799,800,801,802,79,803,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,39,0,21,41,240,13,41,804,805,806,807,808,809,810,811,812,813,16,21,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,1,0,59,1,18,81,14,17,1,37,79,120,814,815,816,817,818,0,97,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666664, 0xff686465, 0xff696961, 0xff817948, 0xffcba901, 0xffcda800, 0xffba9e0e, 0xff9c8831, 0xff747055, 0xff756f59, 0xff6c6960, 0xff666863, 0xff666668, 0xff676769, 0xff656567, 0xff656766, 0xff656563, 0xff656565, 0xff656762, 0xff666563, 0xff656668, 0xff887d45, 0xffc29f0f, 0xffcaac00, 0xffccaa00, 0xffcbab02, 0xffcba802, 0xffcbab00, 0xffcbaa03, 0xffc5a409, 0xffbea00e, 0xffb29b17, 0xff9a8931, 0xff757154, 0xff746f59, 0xff6c6962, 0xff666865, 0xff676664, 0xff676765, 0xff63666b, 0xff676566, 0xffb39b17, 0xffcba804, 0xffcbad01, 0xffc9aa01, 0xffccab00, 0xffccaa02, 0xffc3a505, 0xffbd9e10, 0xffbc9c13, 0xff928439, 0xff777252, 0xff706c60, 0xff666762, 0xff6a656b, 0xff666769, 0xff676662, 0xff69646a, 0xff676568, 0xff666465, 0xff686669, 0xff777254, 0xffc9a900, 0xffcea900, 0xffcba900, 0xffcfaa01, 0xffcaaa00, 0xffcaa800, 0xffcbaa05, 0xffccac00, 0xffcfaa03, 0xffc5a707, 0xffbda10f, 0xffba9f12, 0xff978732, 0xff80774e, 0xff756d56, 0xff736b5e, 0xff676767, 0xff686763, 0xff656764, 0xff6e6c5d, 0xff998731, 0xffcdad04, 0xffcea902, 0xffceaa00, 0xffcaaa01, 0xffcda801, 0xffc7a304, 0xffc0a00d, 0xffb89c14, 0xffaa901f, 0xff797353, 0xff736e58, 0xff6f6b5f, 0xff6b6764, 0xff686667, 0xff646663, 0xffa39027, 0xffc8a500, 0xffc7a706, 0xffbea409, 0xffba9d13, 0xffb0961f, 0xff7c744f, 0xff76705a, 0xff6f6c5d, 0xff6a6964, 0xff666867, 0xff656462, 0xff696562, 0xffbda20d, 0xffcaa701, 0xffc8a903, 0xffbfa10f, 0xffbba10e, 0xffa58d29, 0xff8a7e42, 0xff727059, 0xff636768, 0xff6c6761, 0xff897d43, 0xffcdac00, 0xffc9a801, 0xffc2a30d, 0xffa99222, 0xff93873d, 0xff767058, 0xffb39c18, 0xffcaa902, 0xffcbac04, 0xffc8be0f, 0xff6a6a62, 0xffb39b13, 0xffcaab03, 0xffccac03, 0xffcca903, 0xffe3cc02, 0xfff9c801, 0xff7c7257, 0xff6d6b5f, 0xffc3a509, 0xffcdab03, 0xffefcf00, 0xfffcc900, 0xff927e49, 0xff696863, 0xff666467, 0xffa08d27, 0xffcdab01, 0xffc9ab00, 0xffcfa900, 0xffcbac03, 0xffd3b603, 0xfffec901, 0xfffdc800, 0xffd9ae12, 0xff79715a, 0xff83784a, 0xffbc9d0e, 0xffc8ac00, 0xffcaab02, 0xffceb002, 0xffe1cc00, 0xffffc501, 0xffffc600, 0xffeab80b, 0xff8c7951, 0xff6d6865, 0xffbfa10d, 0xffe2cb01, 0xfffaca04, 0xffffc602, 0xfffcc601, 0xfffcc302, 0xffd5a915, 0xff66656a, 0xff767056, 0xffcaa705, 0xffcca700, 0xffccac01, 0xfff2cc00, 0xfffec601, 0xffffc701, 0xfffdc500, 0xffe8b50a, 0xff696566, 0xff7a7057, 0xffb49d13, 0xffcbad00, 0xffd7b901, 0xfffcc802, 0xffffc300, 0xffffc700, 0xfffec502, 0xfff9c203, 0xff958337, 0xffcdb200, 0xffddd300, 0xff7b7555, 0xff636864, 0xff646567, 0xff6f6c5b, 0xffc4a705, 0xffded202, 0xffbd9a26, 0xff726f5e, 0xff6a6663, 0xff827749, 0xffcea702, 0xfff1cb00, 0xffdeb012, 0xff7a7359, 0xff887e41, 0xffc0a10b, 0xffccae00, 0xffd6ba01, 0xfffdca01, 0xfffdc702, 0xfff5be09, 0xffb39330, 0xff646867, 0xffb59d17, 0xffcca701, 0xffceb300, 0xffdfd003, 0xffffc401, 0xffffc503, 0xfffec401, 0xffd7ac12, 0xff646965, 0xff7a6e54, 0xffcfab00, 0xffe1d602, 0xfffcc700, 0xffffc704, 0xfff1bf0a, 0xff6e6a5e, 0xff626667, 0xff686367, 0xff6a6965, 0xff948436, 0xfff5c700, 0xffffc502, 0xfffbc201, 0xff636766, 0xff9e8b2d, 0xffc6a606, 0xffcaa904, 0xffcdad02, 0xffd6bd00, 0xffffc603, 0xfffec700, 0xff9b843e, 0xff6e6a61, 0xff65666a, 0xff646665, 0xff686765, 0xffbe9f11, 0xffd2b303, 0xffe2d401, 0xffffc500, 0xfffec600, 0xffffc702, 0xffc69e24, 0xff756e5b, 0xff636564, 0xff676863, 0xff837948, 0xffe2d402, 0xffffc703, 0xffffc801, 0xfffec400, 0xffeab809, 0xff928246, 0xff756f55, 0xffcda802, 0xffcbb000, 0xfff6cc00, 0xfff7bf06, 0xffba9928, 0xffb69a15, 0xffc9a602, 0xffccb102, 0xffdbc800, 0xffe8b80e, 0xff6b6b61, 0xffc3a40b, 0xffd3b401, 0xffeed500, 0xfff2bf02, 0xff726c5e, 0xff9f8c2e, 0xffedd500, 0xfffbca03, 0xff827552, 0xff65666b, 0xff7e7a4a, 0xffcfaf02, 0xfff6cb00, 0xffad8e31, 0xff656a64, 0xffbca10c, 0xffceb000, 0xffddc600, 0xffdeae0c, 0xff727057, 0xffc9a803, 0xffc8ac02, 0xffd4b502, 0xffedd103, 0xfffdc401, 0xff98883d, 0xff8f8b42, 0xffdac700, 0xffd2b801, 0xffd0af00, 0xffc8aa00, 0xffffc505, 0xffedbb06, 0xff6e6963, 0xff7a7557, 0xffe9ec07, 0xffefee00, 0xffdfcf00, 0xffd7be00, 0xffd0b100, 0xffd1b003, 0xfffac902, 0xfffbc203, 0xffd8ad13, 0xff8c8b48, 0xffd5de11, 0xfff5ff01, 0xfff5ff00, 0xfff4f900, 0xfff3f400, 0xffe7dd01, 0xffdac802, 0xffcfb401, 0xffceaf00, 0xffceae01, 0xffdfcd01, 0xffffc402, 0xffdeb110, 0xff7d7757, 0xff706e5f, 0xff9b9d3c, 0xfff3fd00, 0xfff6fd00, 0xfff0fb00, 0xffeff801, 0xffeae301, 0xffe0cf03, 0xffd3b600, 0xffcfb000, 0xffd3b700, 0xffeece01, 0xffb4902f, 0xffc7d11a, 0xffeff703, 0xfff3fe00, 0xfff2ff00, 0xfff4ff01, 0xfff3ff00, 0xfff5fc00, 0xfff2fb00, 0xffefed02, 0xffe5e000, 0xffd5bb02, 0xffd1b400, 0xfff2cd02, 0xfff9bd07, 0xff736d5d, 0xff86854f, 0xffd0da17, 0xfff7fe01, 0xfff4ff03, 0xfff4fe00, 0xfff5f902, 0xffece204, 0xfff4f600, 0xfff7fe03, 0xfff6fd02, 0xfff5fc01, 0xffedf202, 0xffe8e301, 0xffd8c004, 0xffd2b404, 0xffcbaa00, 0xffcda900, 0xffd1b200, 0xfffaca00, 0xffe7b40d, 0xff686964, 0xff70725d, 0xffe6ee07, 0xfff2fd01, 0xfff0f602, 0xffa82537, 0xffa51d41, 0xffa54841, 0xffd49a15, 0xffe7e00b, 0xffefef05, 0xfff4fd04, 0xfff3ff01, 0xfff4fb00, 0xffeef602, 0xffefef01, 0xffdfce04, 0xffd6bf01, 0xffd0af02, 0xffd0b300, 0xffe0d104, 0xffeabb0b, 0xff948244, 0xff646466, 0xffbbc026, 0xffebf604, 0xfff6ff04, 0xffbc5513, 0xff9b0d49, 0xff99064c, 0xffa21741, 0xff9d4448, 0xffc98615, 0xffe9dd0d, 0xffede604, 0xfff4fd02, 0xfff6ff00, 0xfff0f100, 0xffd8c103, 0xffd0b101, 0xffcead00, 0xffd3ba00, 0xfff1cc02, 0xffd2a71a, 0xff666561, 0xff6a6b65, 0xff8a8d48, 0xfff2fd00, 0xfff2fb02, 0xffe0c619, 0xff9c044d, 0xff96004a, 0xff98004b, 0xff980148, 0xff95034c, 0xff9b0a43, 0xffa32958, 0xffa94748, 0xffe5d30f, 0xffe9e009, 0xfff5fe03, 0xfff4ff00, 0xffeef700, 0xffe7e300, 0xffded000, 0xffd2b502, 0xffd1b001, 0xfff1cc01, 0xfff9c205, 0xff7a7356, 0xff656469, 0xff6e6f61, 0xffe1e90c, 0xfff2ff02, 0xfff4f503, 0xffa9253c, 0xff9a044c, 0xff98024a, 0xff97014b, 0xff970149, 0xff99034d, 0xff99084d, 0xffa0284c, 0xff9e434c, 0xffe5cf0a, 0xffeddc13, 0xfff2f601, 0xfff3fc01, 0xfff2f802, 0xffede902, 0xffe2d400, 0xffd3b602, 0xfffac900, 0xfffcc602, 0xfff3bb06, 0xff7e7f53, 0xffc8d116, 0xffdfd409, 0xffa04d49, 0xff99014e, 0xff97004d, 0xff9e024b, 0xffc9025d, 0xffef1d5c, 0xffe12764, 0xffe57e22, 0xfff2cc11, 0xfff0e309, 0xfff6f703, 0xffeeef00, 0xffe8e303, 0xffd1b700, 0xffded204, 0xfffbc800, 0xfff2be06, 0xffb2922d, 0xff686963, 0xff848450, 0xfff1fa03, 0xfff2fd03, 0xffdec717, 0xff9a0650, 0xff9b004c, 0xffb10051, 0xffe50067, 0xffee0070, 0xffeb0170, 0xffef1060, 0xffed2564, 0xffd45147, 0xfff3b91a, 0xffebe410, 0xfff4f104, 0xfff8fd03, 0xffeff402, 0xffeeea02, 0xffe1cc03, 0xfff3cf01, 0xff827650, 0xffa3a834, 0xffe6ed09, 0xfff7fe00, 0xffcd8516, 0xff9d1843, 0xff980049, 0xff9a0049, 0xff9d004a, 0xffe60065, 0xfff0006b, 0xfff0006d, 0xfff10069, 0xfff1006b, 0xfff1016e, 0xffe7096c, 0xffeb185d, 0xffc64274, 0xffdd5629, 0xfff2e10f, 0xfff5f602, 0xfff1f200, 0xfffbc500, 0xfffdc403, 0xff847651, 0xff6a6569, 0xff7a7a58, 0xffb8c225, 0xffe4d70c, 0xffa74e40, 0xff9a004b, 0xffa6014e, 0xffef006c, 0xfff1026a, 0xfff2016c, 0xffef0170, 0xfff2006d, 0xffea0471, 0xffec0a5e, 0xffed3a62, 0xfff3bc24, 0xfffec803, 0xfff6c004, 0xff746f5b, 0xff66656b, 0xffd6dd11, 0xfff2fc05, 0xfff5f403, 0xffa82c46, 0xff9c004c, 0xffa9014e, 0xffdb0162, 0xffee016b, 0xffef026c, 0xfff1016c, 0xfff2006e, 0xfff3006c, 0xfff0006f, 0xfff20069, 0xffea1263, 0xfff6eb03, 0xfff7ff00, 0xfffcec01, 0xfffecb00, 0xfff7c202, 0xffcea817, 0xff9a9e3d, 0xffdeea0c, 0xfff6ff02, 0xfff7fd00, 0xffcb8515, 0xffa3143f, 0xff980249, 0xffc00151, 0xffeb0067, 0xfff10170, 0xffef026e, 0xfff0c41d, 0xfff3fc03, 0xfff5f700, 0xfffdd501, 0xfffec504, 0xffecbb09, 0xff978145, 0xff7f7e50, 0xffeef905, 0xfff4fa02, 0xffe0ca14, 0xff9b084f, 0xffa0004a, 0xffec016a, 0xfff2006f, 0xfff00169, 0xfff1006f, 0xfff1006d, 0xffe71f68, 0xfff2a926, 0xfffbcb00, 0xff9d853d, 0xff686762, 0xffd0dd13, 0xfff3f903, 0xffaf3045, 0xffb6014e, 0xfff30269, 0xfff2006b, 0xffee0169, 0xffef046d, 0xffe9336e, 0xfff6fa03, 0xfff2fe04, 0xfffad000, 0xfffcc304, 0xff6a6665, 0xff72715f, 0xffa4a933, 0xfff7ec06, 0xffedb11d, 0xffe02760, 0xffec205d, 0xffed016f, 0xfff00070, 0xffee016d, 0xfff00068, 0xfff0c31f, 0xfff2fb04, 0xffffd800, 0xfffdc202, 0xffdbb013, 0xffe4f008, 0xfff0fa03, 0xfff3f702, 0xfff4d812, 0xffe72667, 0xffed1e62, 0xffe80473, 0xfff2016a, 0xffcf5176, 0xffecdc15, 0xfff7fc00, 0xfffcf103, 0xfff4bc05, 0xff6d6f61, 0xff777859, 0xffa9ad32, 0xffd1d713, 0xffe9f108, 0xfff3fa00, 0xfff4f801, 0xffefdd19, 0xfff5c412, 0xffd93478, 0xffee2363, 0xffe90872, 0xffed026b, 0xffee0368, 0xffe73255, 0xfff1fa01, 0xfffccf00, 0xfffec900, 0xffb79927, 0xff716e5b, 0xff6f715c, 0xffa3a736, 0xffcdd415, 0xffe8ef0b, 0xfff0fb01, 0xfff8ff02, 0xfff5fa00, 0xffeedf14, 0xfff7cb12, 0xffc84672, 0xffe5265a, 0xffe90870, 0xffed006a, 0xfff0006c, 0xffed006c, 0xffe70a69, 0xfff0e112, 0xfffae202, 0xffffc902, 0xff8e794c, 0xff686463, 0xff6d6e60, 0xff767757, 0xff9ba03c, 0xffc9d215, 0xffeae213, 0xfff4d614, 0xffc55062, 0xffe2275e, 0xffeb0768, 0xffed016d, 0xffee026e, 0xffe7396e, 0xfff0d114, 0xfff8fe00, 0xfffbeb00, 0xffe8b90b, 0xff6e6c5f, 0xff747857, 0xff9d9f3a, 0xffede20e, 0xfff1d710, 0xffd74c47, 0xffe52763, 0xffe90a67, 0xffeb0369, 0xffeb1261, 0xffec7718, 0xfff8c102, 0xffcda915, 0xff6a6c61, 0xff74745c, 0xff919644, 0xffbdc323, 0xffe6ec0c, 0xffebf906, 0xfff6db10, 0xffe15226, 0xffd93677, 0xffea0a60, 0xffe00f74, 0xffecdb11, 0xfffbdf00, 0xfffdca00, 0xffd7ab17, 0xff797256, 0xff6d6a65, 0xff71735b, 0xff919541, 0xffbbc11f, 0xffe4ec0d, 0xffedf703, 0xfff1e507, 0xfff1de15, 0xffc44072, 0xfff1b00e, 0xfff3f500, 0xfff2f302, 0xfffbd100, 0xffa38837, 0xff6e6b62, 0xff6a6b63, 0xff72755a, 0xff939444, 0xffbac123, 0xffe2ea0b, 0xffecf506, 0xfff7f701, 0xfffdc703, 0xfff1bd09, 0xff716b5f, 0xff75755b, 0xff8a8a4a, 0xffb3b725, 0xffdfeb0d, 0xffedf607, 0xffffcf01, 0xfffcc300, 0xffdeb014, 0xff717155, 0xff878c4a, 0xffb2b727, 0xffe4e910, 0xfff1fe01, 0xfff4f102, 0xfffcd000, 0xffe5b513, 0xff837751, 0xff646869, 0xff686a65, 0xff70715f, 0xff8b8b4d, 0xffb3b627, 0xffdde70c, 0xffeaf207, 0xfff1fa00, 0xfffce001, 0xffc19e26, 0xff726f5c, 0xff646963, 0xff6f705e, 0xff7f8351, 0xffacaf2e, 0xff73705d]
				); 
        }
		public function box17():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,5,6,7,8,9,10,2,11,12,13,0,0,0,14,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,14,17,18,19,20,21,22,23,24,25,26,27,0,10,10,10,10,2,0,28,29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,30,28,31,32,33,34,35,36,35,37,38,39,40,14,15,10,3,28,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,17,0,42,43,44,45,21,46,47,48,21,49,50,51,52,53,2,2,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,54,55,56,57,58,48,21,59,47,60,47,35,61,62,51,63,40,13,2,10,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,15,64,65,15,66,67,45,68,49,69,69,69,69,69,69,69,35,35,47,70,71,72,73,74,0,75,2,10,17,76,17,10,0,0,15,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,74,31,0,0,77,78,79,21,69,80,61,69,69,69,69,69,69,69,69,69,49,81,82,83,84,12,28,85,17,13,0,0,9,15,0,2,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,16,2,86,87,88,47,49,49,47,35,69,69,69,69,69,47,35,69,69,35,21,47,89,90,91,92,73,14,12,16,3,15,10,28,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,28,76,0,93,94,95,21,69,49,47,69,69,69,69,69,69,69,69,21,69,69,49,35,61,80,90,96,97,98,14,85,12,10,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,99,66,100,48,49,69,59,47,69,49,69,69,69,69,69,47,69,69,47,69,49,22,47,69,61,89,49,101,102,103,104,105,106,16,15,15,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,41,107,108,59,35,61,47,90,47,69,109,69,69,69,69,69,47,69,69,69,69,35,49,47,35,46,45,110,69,70,111,112,113,54,0,0,9,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,114,15,2,10,115,116,117,44,49,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,47,69,21,61,118,119,120,55,14,15,28,10,121,12,28,10,10,15,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,16,122,123,16,124,125,126,47,36,48,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,35,69,47,69,127,69,68,128,129,130,12,28,0,10,2,28,0,0,0,0,76], 
    [0,0,0,0,0,0,0,0,0,0,0,131,132,28,75,133,134,135,49,48,136,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,69,69,69,47,137,69,49,35,138,139,140,141,12,13,142,10,0,0,15,10], 
    [0,0,0,0,0,0,0,0,0,0,0,10,10,17,143,144,101,47,49,47,145,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,47,69,146,35,147,47,48,135,47,148,149,150,151,41,15,15,0,0,15,13], 
    [0,0,0,0,0,0,0,0,0,0,0,3,41,152,153,90,69,45,80,154,136,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,69,35,69,49,47,35,155,22,59,156,109,157,126,158,159,160,28,0,0,0], 
    [0,0,0,0,0,17,0,0,161,15,0,28,162,163,88,48,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,135,147,147,164,100,165,152,166,10,0,2], 
    [0,0,0,0,0,28,9,15,13,2,15,167,168,110,69,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,135,110,47,44,156,169,170,171,16,2,3], 
    [0,0,0,0,0,0,0,15,172,2,14,173,174,35,89,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,48,47,47,47,36,175,176,177,132,0,0], 
    [0,0,0,0,0,13,9,1,9,40,178,179,110,47,69,49,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,110,135,154,69,180,181,182,183,0,10,2], 
    [0,0,0,0,0,29,184,3,11,185,186,48,187,90,109,61,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,48,154,47,188,189,190,191,9,15,172], 
    [10,0,192,28,0,28,16,13,193,194,195,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,35,47,47,47,135,21,95,196,197,198,199,191,0,0,0], 
    [0,0,12,106,0,28,15,200,201,70,47,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,22,110,202,203,204,205,199,191,0,0,0], 
    [15,28,172,2,0,15,124,206,37,61,44,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,69,69,69,69,135,207,208,209,210,198,199,191,0,0,0], 
    [0,10,29,122,192,211,212,88,35,49,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,47,175,213,214,215,205,216,199,191,0,0,0], 
    [28,16,15,0,105,42,217,80,95,21,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,69,69,48,135,188,218,219,198,220,221,199,191,0,0,0], 
    [13,17,0,15,222,116,126,49,135,69,59,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,49,69,69,135,223,224,225,220,210,220,226,199,191,0,0,0], 
    [15,10,41,227,228,229,47,35,90,21,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,49,47,69,230,231,232,233,210,219,219,210,234,191,2,0,0], 
    [10,15,13,235,236,69,22,58,35,89,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,49,47,21,237,238,219,210,219,219,210,210,234,191,2,0,0], 
    [11,85,239,240,241,242,243,69,21,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,58,244,245,246,219,210,219,210,210,219,234,191,2,0,0], 
    [0,2,76,247,248,249,250,187,69,136,22,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,49,251,231,252,205,233,219,210,210,210,219,234,191,2,0,0], 
    [41,3,15,253,254,255,256,257,258,230,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,58,224,259,219,220,219,210,219,219,210,210,234,191,2,0,0], 
    [3,16,28,76,260,261,262,263,264,265,266,69,154,267,69,47,47,21,69,49,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,21,47,46,47,268,269,270,226,198,210,210,210,210,210,210,271,272,9,192,0], 
    [15,10,28,15,54,273,274,275,276,277,278,279,280,21,281,89,69,22,47,21,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,22,36,282,283,216,284,198,285,210,210,210,210,210,210,286,183,10,28,192], 
    [16,106,12,172,28,287,288,289,290,291,292,293,294,295,58,47,69,22,47,47,47,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,109,47,21,296,225,220,284,210,284,210,210,210,210,210,210,297,298,0,15,2], 
    [3,0,17,10,41,299,300,301,289,302,303,304,305,306,307,308,309,69,310,35,22,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,47,69,180,311,233,226,270,198,270,270,210,210,210,210,210,210,312,313,16,15,28], 
    [3,0,41,2,17,31,314,315,316,317,318,319,320,321,322,323,237,324,22,22,22,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,69,48,44,237,325,326,219,220,198,205,327,210,210,210,210,210,210,328,329,0,15,0], 
    [0,0,0,0,0,114,40,330,331,332,333,334,335,336,337,338,339,340,341,49,49,61,154,95,80,69,229,69,69,69,69,35,69,69,69,69,69,21,147,90,21,46,89,95,342,343,205,216,210,210,210,210,210,220,220,252,284,284,344,345,346,28,172,2], 
    [0,0,0,0,0,0,13,347,348,349,350,351,352,353,354,355,356,357,358,359,360,44,109,44,21,21,61,69,69,69,69,69,69,69,69,69,69,47,48,49,49,48,147,251,203,233,361,220,210,210,210,210,210,362,361,216,327,363,364,365,0,41,1,0], 
    [0,0,0,0,0,10,0,366,367,276,289,368,369,370,352,371,372,373,374,375,376,377,378,69,69,136,46,69,69,69,69,69,69,69,69,69,69,69,44,89,22,58,207,379,380,205,326,226,210,210,210,210,210,198,210,381,362,382,383,384,385,41,10,0], 
    [0,0,0,0,0,0,0,162,386,387,316,388,389,390,391,392,393,394,395,396,397,398,399,400,61,21,137,69,69,69,69,69,69,69,69,69,69,21,137,59,69,243,401,245,219,198,402,226,210,210,210,210,210,219,252,226,403,404,405,0,122,0,0,17], 
    [0,0,0,0,0,3,192,17,8,406,256,407,408,409,352,409,410,411,412,413,414,415,416,417,418,419,109,69,69,69,69,69,69,69,69,69,69,21,59,21,22,420,325,285,270,198,219,221,210,210,210,210,210,198,326,421,422,14,10,13,16,10,10,12], 
    [0,0,0,0,0,10,423,76,16,424,425,375,426,427,393,428,391,429,430,431,432,433,434,435,436,437,438,58,69,69,69,35,69,69,69,69,69,44,49,21,47,439,440,226,220,198,198,210,210,210,210,210,210,198,362,441,442,28,16,3,184,10,2,13], 
    [0,0,0,0,0,15,75,15,75,443,444,445,446,447,393,448,449,450,451,452,453,454,455,456,457,458,459,460,461,229,135,47,21,47,47,135,69,22,169,400,203,462,198,210,210,210,210,210,226,221,219,219,226,463,464,465,74,161,10,0,0,0,0,0], 
    [0,0,0,0,0,85,0,15,466,467,468,255,316,469,470,471,472,473,474,475,476,477,451,478,479,480,481,482,483,484,485,59,90,69,47,49,48,147,229,486,487,220,362,210,210,210,210,210,285,210,205,220,326,488,489,74,41,13,10,0,0,0,0,0], 
    [0,0,0,0,0,28,14,10,12,85,490,491,492,493,494,495,475,475,496,496,497,498,499,451,500,501,502,503,504,505,506,507,508,21,21,49,35,69,213,509,510,219,511,210,210,210,210,210,216,510,270,221,512,513,514,41,0,515,184,0,0,0,0,0], 
    [0,0,0,0,0,13,14,384,10,1,516,517,518,519,520,521,522,475,523,524,475,451,451,453,475,476,525,526,527,528,529,530,531,58,110,61,47,180,532,361,285,198,270,210,210,210,210,210,220,221,205,533,534,535,54,10,12,76,28,0,0,0,0,0], 
    [0,0,0,0,0,0,172,85,28,2,17,3,536,537,538,539,540,541,542,497,477,452,543,451,452,500,477,497,544,545,546,547,548,549,550,243,109,551,225,210,210,402,226,210,210,210,210,210,284,511,205,298,552,0,29,2,3,192,13,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,553,554,555,556,557,558,559,525,543,560,561,562,475,563,500,452,564,565,566,567,263,519,568,569,214,570,402,511,220,226,210,198,198,511,210,233,220,344,571,346,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,0,0,76,572,573,574,575,576,577,578,497,579,498,477,454,523,452,451,454,580,581,316,316,582,583,219,511,226,216,511,220,220,210,326,220,270,511,584,585,586,2,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,17,16,122,0,64,162,587,588,589,590,591,592,499,593,497,563,543,563,543,543,594,595,289,316,316,446,596,511,226,216,220,198,198,219,597,226,210,326,598,599,600,41,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,10,75,14,12,15,75,2,41,601,602,603,604,605,606,524,477,593,543,476,607,524,608,609,316,610,316,611,361,220,511,220,198,216,220,220,402,216,534,612,162,12,85,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,41,13,0,28,106,12,192,613,614,615,348,616,617,618,619,476,454,475,454,476,620,621,610,289,622,623,361,270,270,270,210,220,220,326,216,624,625,626,10,627,28,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,628,629,630,631,632,633,634,524,497,607,563,635,636,637,638,276,639,640,284,198,205,220,219,219,326,284,641,642,161,0,41,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,643,644,645,646,647,648,496,476,452,649,650,651,301,316,652,653,198,216,205,270,198,270,198,654,655,656,15,0,15,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,106,114,64,657,468,658,659,660,661,662,525,663,664,610,316,665,666,285,226,198,205,198,226,667,668,29,15,10,10,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,14,28,28,31,669,670,671,672,673,674,675,676,677,301,678,679,680,198,233,326,205,362,512,681,682,9,85,0,41,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,1,41,10,76,15,31,683,684,685,686,687,688,689,482,690,289,691,216,205,205,205,692,693,694,85,15,0,15,15,0,15,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,114,28,106,385,41,85,85,695,696,697,698,699,700,701,702,703,349,665,210,285,252,326,704,705,28,17,0,15,0,0,0,15,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,75,3,706,707,708,261,263,316,582,709,710,361,234,711,712,54,2,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,85,0,54,713,714,715,716,610,610,349,717,284,718,719,54,17,2,75,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,15,15,0,41,720,0,626,721,722,723,724,623,284,725,726,0,172,13,15,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,10,0,0,184,17,76,2,727,314,728,729,730,731,732,54,0,106,0,17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,0,28,3,123,0,85,41,28,10,733,734,735,736,2,76,131,16,29,2,85,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff656563, 0xff656766, 0xff676568, 0xff6d695e, 0xff8d7d41, 0xffbca20f, 0xff948238, 0xff6a6a60, 0xff676769, 0xff666664, 0xff686669, 0xff676765, 0xff676664, 0xff686667, 0xff666668, 0xff656764, 0xff656668, 0xff676860, 0xffaf971d, 0xffc8a807, 0xffcbab00, 0xffcba901, 0xffbfa10f, 0xffa99323, 0xff776f58, 0xff696a62, 0xff656762, 0xff676566, 0xff676662, 0xff696564, 0xff676863, 0xff797255, 0xffc4a606, 0xffcda802, 0xffcba900, 0xffcea902, 0xffc8a805, 0xffa79124, 0xff877c46, 0xff6b6863, 0xff676767, 0xff91833c, 0xffb89d12, 0xffccab00, 0xffc9aa01, 0xffcaac00, 0xffccaa02, 0xffcaaa01, 0xffcbab02, 0xffba9f10, 0xffa79225, 0xff727155, 0xff696a64, 0xff686765, 0xff6d6a61, 0xffb39b15, 0xffcaa703, 0xffcdab01, 0xffcba802, 0xffcbac03, 0xffcbaa03, 0xffc6a605, 0xff877948, 0xff666563, 0xff666769, 0xff7d7550, 0xffaf961f, 0xffcca905, 0xffccaa00, 0xffc9a803, 0xffb69b16, 0xff9e8b2d, 0xff716e5b, 0xff686763, 0xff666762, 0xff666867, 0xff66675f, 0xff9f8c2d, 0xffc1a40b, 0xffcaab02, 0xffcbaa05, 0xffc2a607, 0xff9c8c2d, 0xff80774c, 0xff656565, 0xff6d6b5f, 0xff8b7f43, 0xffc9a805, 0xffcca903, 0xffcaa902, 0xffb29c15, 0xff9d8a2e, 0xff877b49, 0xffb19817, 0xffccac03, 0xffc5a407, 0xff978732, 0xff7c784b, 0xff6a6762, 0xffc7a506, 0xffcaa906, 0xffb29918, 0xff968432, 0xff6e6c5d, 0xff6a6665, 0xff656567, 0xff757158, 0xff9c8c2c, 0xffccac01, 0xffcea900, 0xffc4a20b, 0xff958635, 0xff797550, 0xff646567, 0xff6b685f, 0xffb39b17, 0xffc9aa04, 0xffc9aa02, 0xffb09917, 0xff938637, 0xff666467, 0xff656469, 0xff646663, 0xff696961, 0xff847a49, 0xffcaa904, 0xffcbac00, 0xffc4a20d, 0xff8e8043, 0xff777252, 0xff686465, 0xff656661, 0xffa08b2e, 0xffc4a608, 0xffcaaa00, 0xffccab04, 0xffceaa00, 0xffc9a906, 0xffb0981e, 0xff8f7f41, 0xff6c6960, 0xff696566, 0xff716f58, 0xffbfa012, 0xffcdaa04, 0xffcbaa00, 0xffcdab03, 0xffc8a903, 0xffc0a00d, 0xff8e813b, 0xff777254, 0xff887b44, 0xffb49916, 0xffcda801, 0xffcfa900, 0xffcea903, 0xffcba804, 0xffa69126, 0xff877a43, 0xff6c6a5e, 0xff67656a, 0xff686964, 0xffb0981a, 0xffcbac04, 0xffbb9e12, 0xff737158, 0xff747055, 0xff9e8b2f, 0xffcda900, 0xffd4bc00, 0xffc4b618, 0xff666465, 0xff93823d, 0xffba9f12, 0xffccac00, 0xffe1cc03, 0xffd2b416, 0xff827a4c, 0xffc6a905, 0xffcfb000, 0xffdcc100, 0xfff8c700, 0xffdaab15, 0xff66656a, 0xff82764c, 0xffab971e, 0xffcdac00, 0xffd5bc00, 0xffefcc00, 0xfffac400, 0xffd9ac13, 0xff646665, 0xff736e58, 0xffc0a109, 0xffc8a900, 0xffd1b400, 0xfff5cc00, 0xfffec601, 0xfffcc300, 0xff6f6b5f, 0xff90813c, 0xffcdaf00, 0xffdbc301, 0xfff9c801, 0xffffc702, 0xffae991a, 0xffcbad01, 0xffe6cd01, 0xfff7cc01, 0xffffc600, 0xff696864, 0xff7d7350, 0xffd0b202, 0xfff6cb00, 0xfffec804, 0xffffc500, 0xffb9a00f, 0xffedce02, 0xffffc700, 0xffffc501, 0xfffcc602, 0xff716b5f, 0xffccad00, 0xffe2d000, 0xfffacd02, 0xfffec600, 0xff81794b, 0xffaf971b, 0xffcda800, 0xffceae01, 0xffddc200, 0xfffac900, 0xfffdc800, 0xfffdc403, 0xffa69627, 0xffcaa705, 0xffd7be01, 0xffeece01, 0xff636768, 0xffadae2c, 0xffdcdb07, 0xffd5b900, 0xffcdad02, 0xffd0b300, 0xfff4ce01, 0xfffac902, 0xff878c4c, 0xffd0d90e, 0xffe9df04, 0xffd9c600, 0xffcfaf02, 0xfffdc702, 0xff6a6b66, 0xff8f9349, 0xfff3fd00, 0xfff3fc01, 0xffeae600, 0xffddcc02, 0xfff7ce02, 0xff7c7c58, 0xffecf504, 0xfff3ff01, 0xfff5fc00, 0xfff0f100, 0xffd9c300, 0xffd2b301, 0xffcfa802, 0xffd1b401, 0xfff6cd01, 0xffffc602, 0xfffcc400, 0xffdaab13, 0xffc2ca1c, 0xffeef803, 0xfff4ff03, 0xfff4ff00, 0xfff7fb04, 0xfff0f400, 0xffddca02, 0xffd2b501, 0xffcaab03, 0xffd5be00, 0xffeece00, 0xfffec502, 0xffffc603, 0xfffcc302, 0xff989e3e, 0xffe0e70e, 0xfff4fe00, 0xfff7ff00, 0xfff2f900, 0xfff7fe01, 0xffecef00, 0xffe4d903, 0xffd2b303, 0xffe4cf02, 0xfffbc500, 0xffd9ac15, 0xff6d6d61, 0xff9c9c3c, 0xfff3fe00, 0xffcc8312, 0xffb5663d, 0xffebdb02, 0xfff1f700, 0xfff2f301, 0xffe9e200, 0xffd2b500, 0xffd0ab02, 0xffcbad00, 0xffddc201, 0xfffdc300, 0xffd8ab10, 0xff807f51, 0xffeff902, 0xfff5ff01, 0xffdcb915, 0xffa83846, 0xffbf611b, 0xffe2bc13, 0xfff1fc02, 0xfff2fa06, 0xffe4d700, 0xffcfaa01, 0xffeecd02, 0xffffc502, 0xffffc701, 0xfff5bf03, 0xffc4a21d, 0xffced418, 0xfff1fa03, 0xfff1f502, 0xffd6ae19, 0xff96024c, 0xff9a094e, 0xffad5547, 0xffd7ad1b, 0xfff3f702, 0xfff5fc01, 0xffe7df02, 0xffd7c400, 0xffd2b404, 0xfff4ce00, 0xfffec303, 0xff9d8a3b, 0xff706c60, 0xffaaaf2e, 0xffe4ed0a, 0xfff6fd00, 0xffe9d60e, 0xff9b0a4b, 0xff98004b, 0xff980b4f, 0xffab2941, 0xffe1bc13, 0xfff1ef06, 0xfff2f802, 0xffefed04, 0xffd8bd00, 0xffcdaf03, 0xfffcc700, 0xfffcc601, 0xfffac600, 0xffefbd08, 0xff7f7154, 0xff727558, 0xffaeb52b, 0xffab4e46, 0xff990a4c, 0xff9a0049, 0xff9c094f, 0xffa52643, 0xffd8ae1e, 0xffeadb06, 0xfff2fb00, 0xffeef100, 0xffd7c002, 0xffceb302, 0xffe4ce00, 0xfff8ce00, 0xffffc803, 0xffd8aa17, 0xff948147, 0xff646661, 0xff666865, 0xff8b8b4f, 0xfff1fc00, 0xffce931f, 0xffa22147, 0xff980049, 0xff98024a, 0xff960048, 0xff98024c, 0xffac2d40, 0xffc2611c, 0xfff2eb09, 0xfff1fa00, 0xffecec00, 0xffdfd400, 0xffcdaf01, 0xffcfb500, 0xfffec400, 0xfffbc407, 0xffa3893c, 0xff706d5e, 0xffd9e20f, 0xffece803, 0xffca821e, 0xff96004c, 0xff99014c, 0xffa90051, 0xffc9015a, 0xffeb1f64, 0xffe35263, 0xffedda12, 0xfff3f605, 0xfff0ef00, 0xffe3d900, 0xffceb100, 0xffd6bd00, 0xfff6bf03, 0xffcba51c, 0xff646869, 0xffbec321, 0xffedf502, 0xffdfc20f, 0xff9d014b, 0xff99014e, 0xffc50058, 0xffe60168, 0xffed016f, 0xffeb0b6c, 0xffd4614f, 0xffe9bc21, 0xfff5f902, 0xffeff800, 0xffdecd01, 0xffd2ba00, 0xffe3ce01, 0xfff6cd00, 0xffd8ac15, 0xff918146, 0xff807e57, 0xffc4cc1e, 0xfff8ff02, 0xfff6f600, 0xffa82e45, 0xffa2024a, 0xffbd0052, 0xffed006c, 0xfff1006b, 0xfff0006d, 0xfff10170, 0xfff1006d, 0xffee0765, 0xffe35166, 0xffeeab29, 0xfff2f705, 0xfff4fb00, 0xffe0d500, 0xffd4bd00, 0xfff9c800, 0xfffdc500, 0xfff1ba08, 0xff7d7159, 0xff686866, 0xff6d6e5e, 0xff999d3f, 0xffb4593a, 0xff9d0c4d, 0xffbc0055, 0xffe00062, 0xffed026b, 0xfff00068, 0xfff0006b, 0xfff2016c, 0xfff1016c, 0xffea0c71, 0xffe62a5a, 0xffe8bc25, 0xfff6eb05, 0xfff4f503, 0xffe9e700, 0xffd5b700, 0xffccae00, 0xffd3bf00, 0xffedce01, 0xfff8c007, 0xffcba41b, 0xff6f6e5c, 0xffd3de15, 0xffeff904, 0xffe9da0d, 0xffc45e36, 0xffeb0464, 0xffee016d, 0xfff1006f, 0xffef026c, 0xfff2006b, 0xfff20070, 0xffed066c, 0xffe62463, 0xffecb429, 0xffefda0f, 0xfff0f900, 0xffecec02, 0xffd5bb02, 0xffd0af02, 0xfff6cc00, 0xfffcc802, 0xffffc401, 0xfffdc401, 0xffa38a38, 0xff726c5e, 0xff636766, 0xff6a6667, 0xff9d9f3c, 0xffcfd51b, 0xfff1f403, 0xffe9ca0d, 0xffe93649, 0xffe7106d, 0xfff2006e, 0xffee0169, 0xffef026e, 0xffe52d51, 0xffde5d3d, 0xfff3ed05, 0xfff3fa00, 0xffebe400, 0xffdbca00, 0xffdac102, 0xffffc402, 0xfff3bc09, 0xff7a7356, 0xff696a65, 0xff989e3c, 0xffcbd01e, 0xfff1f309, 0xffebd118, 0xffe93c4f, 0xffe5106a, 0xfff1016e, 0xffef006c, 0xffe72365, 0xffd85c66, 0xffeddc0a, 0xfff1f703, 0xffecea01, 0xffdfd100, 0xffe4d000, 0xff938048, 0xff6c6f5a, 0xff83874c, 0xffd6dd13, 0xffecf307, 0xffedba20, 0xffd85e4f, 0xffef076b, 0xffef0368, 0xfff2026d, 0xfff00169, 0xffee016b, 0xffee0270, 0xffe90d6f, 0xffde6339, 0xfff0d60d, 0xffdcc304, 0xffd8bc00, 0xfffec901, 0xffa0893b, 0xff6b6d60, 0xff7d8450, 0xffd1d818, 0xffedf104, 0xffebbd21, 0xffdc5b3b, 0xfff0086c, 0xfff2006f, 0xffea0f6b, 0xffd35d53, 0xfff4fd02, 0xfff3f201, 0xfffac005, 0xffcda61d, 0xff686963, 0xff8c8d47, 0xffbcc222, 0xffeef007, 0xffefd80c, 0xffea465e, 0xffe91a60, 0xfff0006f, 0xffeb026f, 0xffe53563, 0xffffca02, 0xfffec401, 0xffdbae17, 0xff968044, 0xff666561, 0xff85894c, 0xffb9bb29, 0xffeff205, 0xfff0e205, 0xffd85b61, 0xffe62260, 0xfff10069, 0xffed0f62, 0xfff0db08, 0xfff5ff00, 0xfffdd001, 0xff7b7457, 0xff6d6a65, 0xff777858, 0xffc8cc1d, 0xffead21a, 0xfff09022, 0xffe40f6b, 0xffec0370, 0xffec056f, 0xffefd21c, 0xfff2ff00, 0xfffbd301, 0xfff3c005, 0xffcda61b, 0xff6a6964, 0xff666469, 0xff676964, 0xff76745b, 0xffc1ca1f, 0xffe4e80b, 0xffecd513, 0xfff29f27, 0xffe5106c, 0xfff00167, 0xffe6802e, 0xffefe603, 0xfff5fe03, 0xfffce300, 0xffffcc01, 0xffaa8c32, 0xff706f5d, 0xff7e8051, 0xffa0a338, 0xffecf005, 0xfff4ee04, 0xffd75f4e, 0xffe12a5a, 0xfff0006e, 0xffd05164, 0xffead81c, 0xfff9ef04, 0xfffed001, 0xfff1bf08, 0xff7d7455, 0xff686860, 0xff7b7e51, 0xffe7ec09, 0xfff1ef07, 0xffe55d29, 0xffeb2d4f, 0xffee026e, 0xffec255c, 0xffeea324, 0xfff3f500, 0xfffdd400, 0xffdcaf14, 0xff978145, 0xff6d6f61, 0xffabb230, 0xffd8da14, 0xffefda03, 0xfff0b126, 0xffec1f64, 0xffef0566, 0xffe60f6a, 0xffd65a58, 0xfff6ff02, 0xfff8f800, 0xffffdf01, 0xffa78f37, 0xff746d5d, 0xff6d6f62, 0xffa5aa34, 0xffd0d813, 0xfff6e706, 0xffeab821, 0xffe72762, 0xffef2e5a, 0xfff2fd00, 0xfff5f300, 0xfff9bf03, 0xffcfa51b, 0xff6c6962, 0xff696468, 0xff6f725d, 0xff8a8d4a, 0xffdee80d, 0xffedf009, 0xfff39e27, 0xffea5245, 0xfff0e102, 0xfff6ff01, 0xffdbae15, 0xff938045, 0xff726f60, 0xff898b4c, 0xffd9e110, 0xfff6fb01, 0xfffdcd01, 0xfff1be03, 0xff827553, 0xff6a6a62, 0xff929544, 0xffc6cd1d, 0xfff4fa04, 0xfffad000, 0xfffac004, 0xffcea71c, 0xff68666b, 0xff919443, 0xffc5c91c, 0xffeefb00, 0xfff5fe05, 0xffa78f39, 0xff736d5d, 0xff6c6e63, 0xffcbd415, 0xffecf508, 0xffffdf00, 0xfff5c408, 0xff7c7654, 0xff6b6b61, 0xff7a8052, 0xffc9c919, 0xff958d42]
				); 
        }
		public function box18():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,0,5,6,3,7,8,9,10,4,4,11,12,13,0,0,13,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,4,5,0,5,14,15,16,17,18,19,20,21,22,0,14,0,0,0,3,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,4,0,0,5,14,23,24,25,26,27,28,29,30,3,14,13,13,13,11,3,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,3,0,3,32,33,34,35,27,36,37,38,39,40,41,42,3,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,43,4,44,45,46,47,48,26,49,27,50,27,51,48,52,53,15,54,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,56,57,0,0,0,0,58,59,60,37,49,49,49,49,49,49,61,49,62,63,64,65,14,31,66,67,13,0,0,0,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,3,3,0,4,68,70,71,72,73,61,49,49,49,49,49,49,73,61,27,74,75,76,77,13,14,14,69,4,0,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,13,0,78,55,79,80,81,82,82,49,49,49,49,49,49,82,27,27,49,83,61,28,84,85,86,87,14,68,69,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,66,14,0,88,89,90,27,91,61,92,49,49,49,49,49,61,27,27,61,62,62,39,93,94,42,0,0,68,4,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,95,96,76,97,73,98,49,99,100,27,49,49,49,49,49,49,48,27,49,49,61,37,101,101,102,103,14,4,14,55,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,96,104,105,106,61,39,49,107,62,39,49,49,49,49,49,108,73,73,49,49,49,109,83,37,110,111,112,66,31,66,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,3,57,0,14,113,114,115,82,116,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,49,49,49,27,48,117,118,22,119,56,0,6,3,14,120,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,56,56,13,0,121,122,28,123,124,125,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,27,125,126,33,127,128,0,13,13,129,11,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,78,14,32,130,131,19,82,49,82,61,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,124,61,132,133,134,13,0,14,87,119,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,56,135,136,81,37,27,125,92,109,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,27,36,137,138,121,1,56,0,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,139,140,141,82,61,37,142,92,49,48,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,27,27,62,37,143,110,144,145,22,31,78,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,3,128,3,56,0,146,147,148,61,51,149,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,81,150,151,69,31,14,3,0,57,3,152,0,0,0,0,0], 
    [0,0,0,0,0,13,4,14,14,153,154,19,108,62,61,61,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,125,39,155,156,157,0,0,66,0,86,56,0,0,0,0,0], 
    [0,0,0,0,0,3,3,2,158,159,160,37,124,73,61,62,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,61,39,107,161,162,4,0,0,0,14,4,0,0,0,0,0], 
    [0,0,0,0,0,163,70,164,165,48,61,166,167,62,83,92,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,123,48,108,61,168,169,170,5,14,56,0,0,0,0,0,0], 
    [0,0,0,0,13,96,171,172,19,27,100,61,61,49,61,61,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,92,173,49,125,61,174,175,176,14,66,4,0,0,0,0,0], 
    [0,3,55,86,177,89,178,143,91,27,62,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,61,19,179,180,14,0,0,0,181,152,182], 
    [0,119,3,139,53,183,61,49,61,82,108,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,92,27,184,185,186,2,68,187,4,0,69], 
    [13,70,188,189,190,49,27,61,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,99,62,109,92,191,192,0,0,87,56,14], 
    [0,193,194,195,27,196,73,109,49,82,61,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,82,82,62,92,197,198,199,13,31,4,14], 
    [11,0,200,201,202,49,108,82,73,48,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,37,27,107,37,99,124,203,204,57,0,13], 
    [86,0,205,206,207,208,37,27,27,27,62,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,109,108,26,49,209,210,211,13,66,3], 
    [55,13,212,213,214,215,216,83,27,101,217,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,61,48,61,109,218,219,220,221,14,56,3], 
    [119,129,222,223,224,225,226,208,49,227,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,49,61,37,228,229,230,231,14,11,152], 
    [66,187,232,233,234,235,236,207,237,49,37,49,49,82,49,82,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,61,37,74,238,239,240,241,3,87,119,13], 
    [11,0,95,242,243,214,214,244,215,245,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,37,125,246,247,248,249,250,0,0,14,181], 
    [68,0,0,251,252,253,254,255,256,257,237,98,82,49,49,27,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,258,259,260,261,262,199,4,31,86,31,5], 
    [13,14,4,263,264,265,266,267,268,269,215,270,37,125,73,62,49,49,82,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,82,124,26,61,37,271,272,273,274,275,66,0,0,0,0,0], 
    [0,13,13,276,277,224,278,279,280,281,282,283,216,92,48,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,82,49,284,285,286,287,288,289,119,86,0,0,0,0,0], 
    [0,57,66,290,291,243,292,293,294,295,296,225,297,208,49,26,49,49,82,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,298,108,299,300,301,302,303,304,0,57,0,0,0,0,0], 
    [0,0,119,305,306,307,243,308,309,310,311,268,312,313,314,218,82,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,315,316,317,318,318,319,320,11,1,3,0,0,0,0,0], 
    [0,13,0,321,322,323,324,325,326,327,328,329,330,206,297,208,98,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,331,332,333,318,334,335,336,337,6,66,3,0,0,0,0,0], 
    [14,4,338,339,340,324,341,342,343,344,345,346,347,348,349,215,216,62,116,92,62,49,49,82,49,49,49,49,49,49,49,49,49,49,49,49,49,49,82,49,49,49,27,124,124,350,125,351,352,317,353,354,355,356,357,4,4,4,13,0,0,0,0,0], 
    [0,13,11,358,359,360,214,361,362,363,364,365,366,367,368,369,370,371,98,37,92,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,82,49,49,49,82,27,27,27,99,208,372,373,374,287,301,375,376,377,0,68,4,0,0,0,0,0,0], 
    [56,0,13,66,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,298,27,49,49,82,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,49,99,393,394,301,395,396,397,398,399,157,400,14,3,0,152,0,0,0,0,0], 
    [87,0,0,78,152,401,402,403,404,405,406,407,408,409,410,367,411,412,391,413,100,49,49,82,82,49,82,49,49,49,49,49,49,49,49,49,49,49,49,49,82,27,27,350,414,415,416,302,355,355,318,417,418,152,78,0,86,0,129,0,0,0,0,0], 
    [14,66,11,0,66,419,420,421,422,423,424,425,426,427,428,429,430,431,432,433,434,98,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,82,49,27,73,435,436,300,397,301,354,353,437,438,439,440,5,0,0,13,13,0,0,0,0,0,0], 
    [3,87,14,4,0,12,441,442,443,367,444,409,445,409,387,446,428,447,448,412,449,245,98,49,49,49,49,49,49,49,49,49,49,49,49,49,49,27,92,27,27,435,450,451,452,396,301,302,301,317,453,454,13,0,187,2,3,3,0,0,0,0,0,0], 
    [0,0,0,0,0,55,5,455,456,457,458,459,460,461,408,409,462,385,463,464,465,313,314,48,61,48,36,49,49,49,49,49,37,61,49,27,27,83,26,27,218,247,466,355,467,468,301,397,355,469,470,95,3,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,11,86,471,472,473,474,475,476,462,446,424,409,477,478,479,480,215,481,482,107,49,49,49,49,49,49,92,82,92,27,27,36,73,483,351,484,452,354,302,302,485,287,318,486,487,0,488,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,338,489,6,56,490,491,492,493,494,425,428,409,462,495,496,497,498,499,500,434,83,92,49,49,82,49,82,82,27,27,82,82,124,501,502,503,485,287,287,354,504,354,353,505,506,128,4,5,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,3,69,14,31,119,507,508,509,510,511,385,512,461,462,409,385,513,514,412,207,413,27,49,49,49,49,49,49,27,49,109,39,515,516,517,485,437,353,317,302,301,355,518,519,96,181,13,12,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,68,5,13,187,0,520,521,522,498,523,524,407,409,424,462,428,475,525,526,226,216,98,82,49,49,27,49,26,61,38,527,528,529,467,302,396,354,397,287,530,531,532,533,0,0,0,31,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,3,534,535,536,513,537,409,538,387,428,539,424,540,541,542,297,543,142,107,109,27,83,61,49,544,436,261,396,318,396,545,354,546,396,547,548,127,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,489,187,534,549,550,551,552,553,554,555,424,556,462,386,557,558,297,559,98,49,61,37,218,560,561,562,301,467,334,287,397,318,335,563,564,11,87,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,11,152,119,565,566,567,568,569,409,462,385,570,556,462,571,572,369,207,573,48,37,109,246,574,485,287,334,318,317,397,353,467,399,575,176,14,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,13,0,5,129,576,577,578,579,580,496,409,524,408,386,581,582,243,583,207,216,371,584,585,317,302,467,467,353,301,586,587,588,589,56,78,182,68,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,590,5,0,13,0,591,592,593,594,595,476,596,424,597,598,599,214,600,601,297,602,603,604,301,318,397,334,318,301,605,606,607,68,3,14,55,55,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,608,609,610,557,611,425,428,425,612,613,614,243,224,615,616,301,397,318,397,545,302,318,617,618,619,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,69,4,620,621,622,623,595,624,512,625,626,600,324,627,324,628,287,318,396,301,374,629,630,631,632,11,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,0,119,633,634,635,636,637,425,638,639,214,224,224,640,641,397,301,642,355,287,643,644,22,14,5,3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,3,645,646,647,648,649,650,651,652,214,214,615,653,355,354,354,397,485,398,654,655,4,6,5,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,5,13,3,119,656,657,658,659,660,661,243,224,236,662,354,334,353,354,663,664,665,87,3,666,43,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,129,56,31,645,182,667,668,669,670,671,600,672,673,674,302,396,334,274,675,16,3,676,14,182,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,31,677,678,679,680,243,615,243,681,682,683,684,685,607,11,488,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,86,182,96,686,687,688,224,214,689,690,691,692,693,157,11,56,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,68,14,0,14,694,695,696,600,697,698,699,700,56,55,13,78,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,3,0,152,701,702,703,324,704,705,706,533,0,11,5,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,5,66,78,489,3,707,708,709,710,0,69,14,56,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff646665, 0xff686765, 0xff666668, 0xff656766, 0xff656565, 0xff666467, 0xff6b6863, 0xff82764e, 0xff857b46, 0xff6f6c59, 0xff676767, 0xff656762, 0xff666664, 0xff676566, 0xff676661, 0xff726c5c, 0xffab971e, 0xffc7a707, 0xffc8a903, 0xffb69917, 0xff767056, 0xff696864, 0xff726d59, 0xff8f823c, 0xffc7a704, 0xffcdab03, 0xffccaa02, 0xffc9a803, 0xff9e8b2f, 0xff7c744f, 0xff676568, 0xff6c6964, 0xff7e774d, 0xffba9d11, 0xffcba806, 0xffcea903, 0xffcbab02, 0xffccab04, 0xffcaa902, 0xffc5a409, 0xff857b48, 0xff6d6a61, 0xff696566, 0xff67656a, 0xff6a6665, 0xff857949, 0xffa99323, 0xffcca903, 0xffccaa00, 0xffcfaa01, 0xffc9ab00, 0xffae961a, 0xff897c45, 0xff666563, 0xff676769, 0xff656764, 0xff666762, 0xff706e59, 0xff8b803e, 0xffc9a805, 0xffcbab00, 0xffccab00, 0xffc5a806, 0xff90823b, 0xff716f5a, 0xff676765, 0xff67666b, 0xff676664, 0xff656668, 0xff686964, 0xff93823a, 0xffb39a1b, 0xffcaaa00, 0xffcbad01, 0xffb59a17, 0xff938338, 0xff6a6760, 0xff66656a, 0xff847a49, 0xffa99421, 0xffcaa904, 0xffcba900, 0xffcea902, 0xffa08c29, 0xff7f764d, 0xff666867, 0xff656563, 0xff6e6a5f, 0xffaf941f, 0xffc3a705, 0xffcbaa00, 0xffcba901, 0xffc4a308, 0xffaa9321, 0xff676863, 0xff696863, 0xffb0981a, 0xffcdab01, 0xffccac01, 0xffcda802, 0xffcaab02, 0xffb0981e, 0xff887e41, 0xff7b7650, 0xffba9d13, 0xffc9a801, 0xffcaac00, 0xffcea900, 0xffcaaa01, 0xffc8a704, 0xffb4981a, 0xff756e5b, 0xff6d6b5e, 0xffac961f, 0xffc4a608, 0xffccac03, 0xffb89f11, 0xff9b8b2c, 0xff656567, 0xff666469, 0xff706d5c, 0xff8b7c41, 0xffcda800, 0xffcbaa03, 0xffcba802, 0xffbfa10f, 0xff686963, 0xff676662, 0xff686669, 0xff7d7550, 0xffb99e0f, 0xffc8a805, 0xffb0961d, 0xff6e6c5f, 0xff81784d, 0xffa6902a, 0xffc8a606, 0xff897d43, 0xff6e6d5b, 0xff887e43, 0xffc8a702, 0xffceaa00, 0xffcda801, 0xffb49c18, 0xff757154, 0xff6b6764, 0xff91823d, 0xffb19819, 0xffcdac00, 0xff9c8b2f, 0xff797351, 0xff686667, 0xff82764c, 0xffa28f29, 0xffc2a408, 0xff847a45, 0xff6b6b5f, 0xff6c6960, 0xffaa9522, 0xffc6a30b, 0xffac961c, 0xff867d44, 0xff646867, 0xff90843c, 0xffb29b19, 0xffcba804, 0xffcaa703, 0xffc5a802, 0xff8d7f40, 0xff736c5a, 0xff787154, 0xffb79d14, 0xffcca905, 0xffb29a16, 0xff92813b, 0xff6a6663, 0xff6d695e, 0xffc1a40a, 0xffa08c2b, 0xff7e774b, 0xff646567, 0xff666865, 0xffc5a707, 0xffbea30a, 0xffaa9425, 0xff6b685f, 0xff666465, 0xff75705a, 0xffb69a15, 0xffc9a906, 0xffaf971d, 0xff877c46, 0xff6c6c64, 0xff8a8448, 0xffc9ad04, 0xffccac00, 0xffc6a701, 0xffb3971a, 0xff736e5b, 0xff868950, 0xffeae002, 0xffdac305, 0xffb49c14, 0xff948836, 0xff84844e, 0xfff2f802, 0xffeae301, 0xffcdaf01, 0xffcdaa04, 0xffcaae02, 0xffb3a11b, 0xff7d7f50, 0xffeef602, 0xfff5ff00, 0xffe8e400, 0xffd9c202, 0xffcaa800, 0xffcdad02, 0xffd1b202, 0xffc9ae19, 0xff918843, 0xff797b56, 0xffe9f205, 0xfff5ff01, 0xfff2f800, 0xffe9e402, 0xffcaab03, 0xffd2b500, 0xffddbf00, 0xffac9434, 0xff75705c, 0xff6d705f, 0xffdde60f, 0xfff5ff02, 0xfff4fd02, 0xfff6fd02, 0xffd9c300, 0xffcfb903, 0xfff0ca05, 0xffdfb513, 0xff706c60, 0xffd6df16, 0xfff4ff00, 0xfff1fa01, 0xffd0ae04, 0xffd3bb01, 0xffe1ca00, 0xffedbf09, 0xffbe9a2c, 0xff6b6766, 0xffcdd716, 0xfff1fc00, 0xfff6fd00, 0xffe8d608, 0xffdbba17, 0xfff1f405, 0xffe8e500, 0xffceac02, 0xffd1bd00, 0xfff3cf01, 0xfffbc701, 0xffaa8f36, 0xffccd115, 0xfff0f902, 0xfff3ff01, 0xffe8cf03, 0xffb45a3f, 0xffdbb924, 0xfff3f901, 0xffcdaf00, 0xffd9bc00, 0xffebcc00, 0xfffaca00, 0xfff6c004, 0xff84784e, 0xffaeb42c, 0xffe6ef0a, 0xfff1eb01, 0xffa92441, 0xff9a1155, 0xffdbb826, 0xffeff107, 0xffe8e303, 0xffd0b101, 0xffdcbd00, 0xfff9cc00, 0xffffc603, 0xfff0bb0b, 0xffb6962f, 0xff9ca33c, 0xffdee90f, 0xfff6f504, 0xffa82e3d, 0xff99014e, 0xffae5350, 0xffd7b923, 0xffe8e301, 0xffcfa802, 0xffdcbf01, 0xffeec700, 0xffffc700, 0xffffc702, 0xffcfa81d, 0xff8d7b4b, 0xff83864f, 0xffd1dc16, 0xfff6fe00, 0xffab3943, 0xff96024e, 0xff990251, 0xff991257, 0xfff0f306, 0xffebe400, 0xffd8c100, 0xffd1b900, 0xffdfc800, 0xfffcc601, 0xffffc501, 0xfff3bc09, 0xff807652, 0xff818351, 0xffcfd616, 0xfff8ff04, 0xfff3ff00, 0xffa54257, 0xff940555, 0xff98004d, 0xff98014e, 0xffad524d, 0xffd8b825, 0xffcbad00, 0xffe1c700, 0xfff2cd02, 0xfffec502, 0xfffbc203, 0xffdaae17, 0xff6d6a65, 0xff65666a, 0xff807f53, 0xffc1c91e, 0xfff7fc00, 0xffb3472b, 0xff990745, 0xff97004a, 0xff97004d, 0xffa70153, 0xffc50f5c, 0xfff4b226, 0xfff7f109, 0xffcfaa03, 0xffd1bc01, 0xffe2ce00, 0xfffec601, 0xffffc502, 0xffffc600, 0xffcda51f, 0xff887950, 0xff787758, 0xffb1b52d, 0xfff3fe02, 0xffc15f16, 0xffa00f3a, 0xff9b0149, 0xffa0004a, 0xffcf005d, 0xffe60065, 0xffee4957, 0xfff4b125, 0xfff4f801, 0xffe9e500, 0xffceaf00, 0xffe3cc00, 0xfff6cb00, 0xfffdc800, 0xfff8c301, 0xff9f883c, 0xff726c60, 0xff77755c, 0xffd3db14, 0xffeefa02, 0xffdeab11, 0xffaf2c3c, 0xffc10059, 0xffdc015f, 0xfff00169, 0xffee0169, 0xfff1016c, 0xffed0b6f, 0xfff4b325, 0xfff6f306, 0xffe9e200, 0xffd8c500, 0xffdabd01, 0xffeecb00, 0xfffcc604, 0xfffec600, 0xffffc602, 0xfff7c204, 0xffd7aa19, 0xff626669, 0xff9fa539, 0xffd7de16, 0xffe6c013, 0xffc43247, 0xffe20167, 0xffed0269, 0xfff2016c, 0xffef026e, 0xfff1006d, 0xfff3006e, 0xfff4af23, 0xfff3f702, 0xffcfaf02, 0xffd1b001, 0xffeeca02, 0xfffacb01, 0xffe8b810, 0xffac8d3a, 0xff686a65, 0xff7f7e52, 0xffdfdb17, 0xfff2ae27, 0xffed0b6d, 0xffee016d, 0xfff1016e, 0xfff2026f, 0xfff1026a, 0xfff0006d, 0xfff20070, 0xffef0866, 0xfff69f1a, 0xfff8e606, 0xffece302, 0xffdac102, 0xffcdae00, 0xffddc000, 0xfffbc500, 0xfffbc503, 0xff9f873d, 0xff6f6b5f, 0xff696a62, 0xffb3b72e, 0xffdfdc15, 0xffec0a6c, 0xfff10170, 0xfff0006f, 0xffee3f46, 0xfff59e1d, 0xffe7e400, 0xffd4b704, 0xfff1ca01, 0xfffcc802, 0xffedbc0a, 0xff7a7359, 0xff696c63, 0xff80834e, 0xffe1d912, 0xfff1ae22, 0xffec0965, 0xfff10267, 0xfff1006f, 0xfff0006b, 0xffed0a66, 0xfff69f1c, 0xfff4e502, 0xfff1ca00, 0xffffc500, 0xffffc701, 0xffe7b70b, 0xffa78f35, 0xff6a6965, 0xffb3b72c, 0xffe4d615, 0xffef3e48, 0xffef0864, 0xffef026c, 0xffed006a, 0xffee3e41, 0xfff59e1b, 0xfff3f403, 0xffcfae00, 0xffcfa900, 0xffcdad00, 0xfff2cc00, 0xfffdc702, 0xffc6a321, 0xff82794e, 0xff666769, 0xff646663, 0xff686b62, 0xff868b4b, 0xffeadc09, 0xfff19e1c, 0xffef095f, 0xfff2006f, 0xffed006c, 0xffee0b65, 0xfff4a01c, 0xfff7e505, 0xffeae203, 0xffcfad03, 0xffe9cc02, 0xfff6cd01, 0xffffc703, 0xffebb70b, 0xff777159, 0xff6c6c62, 0xffc3c91f, 0xffebdb09, 0xfff13d46, 0xffed0962, 0xfff2016a, 0xffef3e46, 0xfff69f1e, 0xffccb100, 0xffdabb00, 0xfff8cd02, 0xffefbd08, 0xffc3a020, 0xff6a6c61, 0xff8b8e49, 0xffe9da0d, 0xffef0963, 0xfff10069, 0xffe86225, 0xffebbe09, 0xffd1b200, 0xfff1c502, 0xfff9c903, 0xfffac503, 0xffe5b411, 0xff837751, 0xff6b6861, 0xff6c6c60, 0xffc5c71c, 0xffeeda09, 0xffed0a63, 0xfff1006b, 0xfff2006d, 0xffea154f, 0xffe55c28, 0xfff2ef02, 0xffcfaf04, 0xffd0b702, 0xffffc401, 0xfffec504, 0xffe3b313, 0xffb4942f, 0xff8b9245, 0xfff1de08, 0xfff5981f, 0xffee0266, 0xffef006c, 0xffee006f, 0xffef0170, 0xfff2006e, 0xffe65a25, 0xffedbf0a, 0xffdac200, 0xffd2b801, 0xfff3cc02, 0xfffcc900, 0xffd9ae14, 0xff787059, 0xff6d6e60, 0xffcbcf1a, 0xffe8cb0f, 0xffea174e, 0xfff20168, 0xfff0006a, 0xffea1650, 0xffe56526, 0xffd0af00, 0xffe1ca02, 0xffa08a3e, 0xff71705c, 0xff939742, 0xffe4b609, 0xffe45b24, 0xfff00167, 0xffee0074, 0xffe53a6e, 0xfff4fe00, 0xffd8bc00, 0xfff4ce00, 0xfffdc401, 0xfff5bf05, 0xffd2a91d, 0xff716b5f, 0xff696468, 0xff6e6f5d, 0xffc9c91d, 0xffe5b40f, 0xffe9164b, 0xffef0368, 0xfff40269, 0xfff10067, 0xffe8057b, 0xffd94575, 0xfff4ff01, 0xfff4f900, 0xffdec000, 0xffeccd00, 0xfffec900, 0xfffdc500, 0xffcda61b, 0xff958047, 0xff6f715c, 0xff939844, 0xffe7b70d, 0xfff10268, 0xffe8105b, 0xffe05e2d, 0xfff7fe03, 0xfff3fe00, 0xfffcd400, 0xffeebc05, 0xffc7a220, 0xff6c6a5e, 0xff72745e, 0xffd0d114, 0xffe8b90b, 0xffe81751, 0xfff3026d, 0xfff12155, 0xffef8f17, 0xfff7fe00, 0xfffed102, 0xfffcc700, 0xfffdc202, 0xffbc9e26, 0xff8c7b4d, 0xff777755, 0xffa1a43b, 0xffe6b713, 0xffdc5a40, 0xffed046f, 0xffef375b, 0xfff4c91b, 0xfff7f500, 0xfffecb00, 0xffffc503, 0xffdfb211, 0xffb19331, 0xff636766, 0xff75785b, 0xffd0d11b, 0xffdfb926, 0xffdf1676, 0xffeb026f, 0xffe63a72, 0xfff0ca21, 0xfff4f400, 0xffa28b3b, 0xff7d7157, 0xff767758, 0xffa3a537, 0xffe0bc34, 0xffd15d6a, 0xffd0515c, 0xffead017, 0xfff8ec00, 0xffd3a919, 0xffa3893e, 0xff696866, 0xff64656a, 0xff7c7d55, 0xffdcdd15, 0xffdebf30, 0xffda7a2e, 0xffecdc0a, 0xfff7fe01, 0xfff8f802, 0xfffbe201, 0xff978145, 0xff636864, 0xff656469, 0xff838151, 0xffb0b729, 0xfff5f902, 0xfff3f201, 0xfffad200, 0xfffcc602, 0xfffbc501, 0xffcaa41f, 0xff808251, 0xffdee80b, 0xfff2fb00, 0xfff8f102, 0xfffbd100, 0xfffec401, 0xfff3bd05, 0xff8f8049, 0xff818352, 0xffb3bb2a, 0xfff2ff00, 0xfffddb00, 0xfffbc702, 0xffb9992a, 0xff897b4e, 0xff6a6964, 0xff86874b, 0xffeaf304, 0xfff9d002, 0xffe5b50d, 0xff83774f, 0xff919242, 0xffd3d913, 0xffb09a34, 0xff7d7457]
				); 
        }
		public function box19():BitmapData{  
             return BitmapPatternBuilder.build(
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,0,5,6,5,5,7,8,9,10,11,4,12,13,13,14,4,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,17,0,0,18,19,20,21,22,23,24,25,26,27,28,16,0,5,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,13,15,5,0,29,30,31,32,33,34,35,36,37,0,13,0,5,18,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,38,14,39,0,40,41,42,43,44,44,45,46,47,48,49,50,15,51,14,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,52,53,54,55,56,57,24,34,58,45,59,60,44,61,62,63,14,64,16,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,4,0,0,7,4,7,0,65,0,66,67,68,69,44,44,44,44,44,44,34,44,59,70,71,72,73,39,1,16,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,13,13,5,0,13,5,5,74,75,76,77,78,79,44,44,44,44,44,59,44,59,59,34,80,81,82,5,19,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,5,17,0,5,5,13,17,83,84,85,86,87,59,44,44,44,44,44,44,44,59,44,44,59,70,58,88,89,90,7,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18,28,38,4,39,38,51,91,41,62,92,93,94,61,70,61,44,44,44,44,44,70,87,70,44,59,70,95,96,97,39,28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,16,5,98,4,99,100,101,102,70,61,70,59,61,46,44,44,44,44,44,44,44,44,44,70,44,59,59,34,103,104,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,5,105,106,107,108,24,109,59,70,110,59,44,111,61,44,44,44,44,44,44,44,87,59,44,61,59,59,112,113,38,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,114,53,4,16,0,14,115,116,117,118,119,34,58,44,44,58,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,59,44,34,120,121,54,1,1,1,51,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,16,39,0,122,123,124,125,126,94,61,61,44,44,44,58,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,59,71,94,127,128,19,13,18,13,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,38,37,113,129,130,24,47,45,44,59,44,44,44,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,79,59,61,131,23,132,133,5,12,134,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,28,53,135,136,137,92,44,44,70,45,59,59,44,58,44,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,111,138,33,34,139,140,53,19,19,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,141,142,32,35,143,144,59,94,61,145,61,44,44,59,44,70,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,146,34,44,144,145,94,147,148,4,16,0,0,0,0,0,0,0,0,0,0,0], 
    [6,149,13,0,13,13,13,150,0,151,152,132,153,70,44,70,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,61,25,154,39,13,51,7,64,5,134,4,0,0,0,0,0], 
    [5,53,5,5,4,6,0,155,156,157,72,44,47,109,59,158,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,47,44,159,160,161,0,13,0,16,0,53,0,0,0,0,0], 
    [5,0,162,5,0,17,163,142,164,130,59,87,87,34,165,34,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,61,59,87,166,167,64,0,13,0,0,13,0,0,0,0,0], 
    [5,12,19,168,169,170,171,165,109,24,44,44,61,165,45,165,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,165,34,61,172,173,174,0,0,51,13,16,0,0,0,0,0], 
    [13,6,0,175,176,177,178,34,61,59,109,59,70,34,61,24,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,179,24,59,45,180,73,181,0,13,0,5,0,0,0,0,0], 
    [13,64,182,183,184,185,79,44,34,44,33,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,178,117,186,5,19,5,18,0,0,0,0,0], 
    [64,0,53,187,188,189,190,44,24,87,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,70,59,44,44,34,191,192,193,16,0,13,0,0,0,0,0], 
    [194,1,195,196,197,198,199,61,34,59,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,70,102,200,201,51,0,0,0,0,0,0], 
    [0,39,202,203,204,205,206,207,34,59,34,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,61,44,44,44,44,61,59,68,208,0,5,0,0,0,0,0], 
    [5,209,210,211,204,204,212,213,214,34,61,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,87,59,47,44,92,215,216,64,0,0,0,0,0], 
    [0,217,218,219,220,204,220,221,222,223,109,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,59,44,44,59,44,61,58,87,224,225,133,0,0,0,0,0], 
    [64,226,227,219,228,220,204,229,230,231,44,59,47,70,34,46,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,145,61,58,70,232,233,0,5,134,1,53], 
    [39,234,235,236,228,237,238,239,240,241,242,59,59,87,34,34,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,165,61,242,87,243,244,245,13,19,6,2], 
    [246,247,248,249,250,251,252,253,254,255,256,146,60,59,59,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,59,257,258,29,0,13,39], 
    [259,260,261,236,220,262,263,264,265,266,267,268,59,59,47,61,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,34,44,34,58,145,269,148,53,0,122], 
    [270,271,197,272,273,274,275,276,277,278,279,280,281,33,59,34,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,45,59,59,61,179,70,282,283,284,4,51], 
    [285,286,287,288,289,290,291,292,293,294,211,295,185,179,296,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,297,298,299,13], 
    [0,300,301,302,303,304,305,306,307,308,309,310,311,312,87,93,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,165,36,10,122], 
    [12,313,314,315,316,317,318,306,319,320,321,322,323,324,111,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,59,70,325,326,327], 
    [0,51,328,329,330,331,332,333,334,335,336,337,237,338,339,34,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,34,340,341,342], 
    [0,0,4,343,344,345,346,347,334,348,349,350,351,352,353,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,354,355,356,357], 
    [0,13,4,358,359,360,361,362,363,364,365,366,367,204,368,369,370,47,179,34,268,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,47,34,94,34,109,87,87,58,59,46,214,371,372,373,123,14], 
    [0,53,0,28,374,375,376,377,378,379,319,380,381,382,383,384,385,165,59,61,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,145,61,70,94,61,34,45,242,386,387,388,389,168,6,12], 
    [28,0,16,5,16,390,391,392,393,394,305,395,396,397,398,399,400,268,61,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,61,87,145,70,58,94,401,402,403,404,405,406,4,0,0,7], 
    [18,1,14,5,13,407,408,409,410,411,412,413,414,415,416,417,418,419,59,87,61,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,59,47,24,58,109,354,420,421,422,423,424,150,16,134,0,14], 
    [53,0,0,13,64,4,425,426,398,427,428,429,364,430,431,382,239,432,433,70,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,434,61,231,435,436,437,438,439,134,53,440,64,0,0,5], 
    [0,1,6,14,4,7,441,442,443,444,445,365,446,447,448,449,450,451,452,44,87,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,34,453,454,455,456,457,458,38,51,51,51,162,459,1,0], 
    [0,0,0,0,0,16,0,460,461,462,463,464,364,465,466,467,468,383,469,385,79,44,44,87,44,87,70,44,44,44,44,44,44,44,44,44,44,44,70,44,44,44,70,59,44,179,470,79,190,471,472,473,474,475,476,477,16,0,3,0,0,0,0,0], 
    [0,0,0,0,0,5,18,478,479,480,481,482,483,318,484,485,486,204,487,454,488,87,58,59,44,59,44,44,44,44,44,44,44,44,44,44,44,268,44,44,44,44,44,45,87,70,59,386,489,490,491,492,493,28,494,4,13,53,150,0,0,0,0,0], 
    [0,0,0,0,0,1,0,5,20,495,496,497,498,499,306,500,501,502,237,503,504,59,59,110,87,44,70,44,44,44,44,44,44,44,44,44,44,44,44,44,59,59,59,61,61,505,506,507,508,509,510,511,65,64,0,13,0,1,28,0,0,0,0,0], 
    [0,0,0,0,0,0,51,13,114,512,513,514,515,516,517,291,518,519,520,521,522,523,59,44,59,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,59,34,61,46,420,455,524,525,526,527,201,14,150,18,149,0,0,51,39,0,0,0,0,0], 
    [0,0,0,0,0,51,53,28,2,528,529,480,530,531,532,318,305,533,534,211,229,535,190,58,44,59,70,44,44,44,44,44,44,44,44,44,44,34,44,44,44,536,537,538,539,540,541,542,543,0,5,51,53,0,14,0,14,544,4,0,0,0,0,0], 
    [0,0,0,0,0,0,0,5,5,52,545,546,547,548,501,549,550,551,552,398,204,553,554,555,34,268,59,44,44,44,44,44,179,44,87,46,61,34,61,87,419,556,557,558,559,560,561,27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,5,13,12,562,563,564,565,566,319,517,567,568,569,570,571,419,572,70,59,44,44,44,44,44,24,34,87,87,87,34,190,573,574,575,576,577,578,39,0,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,5,0,13,579,580,581,582,583,517,584,333,585,586,204,587,588,47,87,44,44,44,44,44,44,59,61,70,165,59,433,589,590,591,592,593,594,123,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,1,13,5,0,0,595,596,597,598,599,600,291,601,602,603,219,604,605,44,34,44,44,44,44,44,61,59,111,386,606,607,608,609,610,611,612,134,51,38,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,13,0,0,13,27,613,203,614,615,616,549,318,617,618,254,323,400,44,34,44,44,44,44,44,44,619,185,620,621,622,623,624,625,150,4,5,626,0,16,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,5,0,627,628,629,630,631,632,334,633,634,635,636,637,638,619,44,47,48,639,385,640,641,539,642,643,644,645,39,150,0,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,5,0,528,646,647,648,427,649,446,650,651,652,653,211,654,655,34,59,59,207,589,557,656,657,658,659,660,4,182,6,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,13,134,0,54,661,662,663,664,665,666,667,228,668,249,669,670,46,619,573,538,671,672,673,674,675,0,4,4,149,0,64,14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,1,544,676,677,521,678,679,680,204,236,220,250,278,681,682,683,684,685,686,687,688,689,0,19,1,0,13,5,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,53,19,16,16,328,690,691,239,692,693,694,695,696,228,653,697,698,699,700,701,702,703,704,5,19,0,12,14,16,0,53,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,13,5,3,459,18,705,706,707,236,220,696,250,236,204,237,708,709,710,711,712,357,38,13,713,0,39,51,5,51,64,5,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,494,714,715,204,204,694,694,236,278,716,717,718,719,720,7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,51,721,722,450,723,724,237,278,725,726,727,728,729,0,13,19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14,5,730,731,732,204,733,734,735,736,737,13,13,16,51,13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6,51,27,738,739,740,741,742,743,105,7,5,6,16,4,744,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13,19,5,745,746,747,748,476,5,0,53,13,150,13,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff656565, 0xff646665, 0xff666467, 0xff676664, 0xff666664, 0xff656563, 0xff686667, 0xff7b7650, 0xff978634, 0xff8e803f, 0xff6b6c5e, 0xff676769, 0xff666668, 0xff676568, 0xff65666a, 0xff676566, 0xff666762, 0xff656764, 0xff656567, 0xff6a6964, 0xff827b47, 0xff9d8930, 0xffc5a407, 0xffcaaa01, 0xffbfa10f, 0xff998934, 0xff686964, 0xff666867, 0xff6e6c5f, 0xff7c784b, 0xffaf971b, 0xffc2a30b, 0xffcaab02, 0xffcbab02, 0xffc8a901, 0xffb59a19, 0xff6f6c5d, 0xff686765, 0xff676765, 0xff716f5a, 0xff857b46, 0xffb89c15, 0xffc7a408, 0xffccaa00, 0xffcea900, 0xffccac01, 0xffcea902, 0xffcca905, 0xff9f8c2d, 0xff787252, 0xff656766, 0xff676863, 0xff676767, 0xff676862, 0xff6f6c5b, 0xff928735, 0xffb0981c, 0xffccab00, 0xffccaa02, 0xffcbad01, 0xffcbab00, 0xffb69b16, 0xff92803e, 0xff656668, 0xff696566, 0xff6a6a5e, 0xff767154, 0xffa48e28, 0xffba9d13, 0xffcba900, 0xffcaa902, 0xffc4a30a, 0xff7b7253, 0xff696863, 0xff83784a, 0xff9d8932, 0xffc2a509, 0xffc9aa04, 0xffcaac00, 0xffc9a707, 0xff948439, 0xff706d5c, 0xff6a6a60, 0xff8b8040, 0xffaa9323, 0xffc7a704, 0xffcba901, 0xffc2a408, 0xffa28f28, 0xff696866, 0xff736e5a, 0xffc7a707, 0xffcba804, 0xffcba802, 0xffc9a900, 0xffb99e0f, 0xff726c5c, 0xff646567, 0xff797550, 0xff91833c, 0xffbfa011, 0xffc7a706, 0xffa48e29, 0xff7e754e, 0xff686762, 0xff756f55, 0xffa39029, 0xffbb9b14, 0xffcaaa00, 0xffcaa800, 0xffcdab03, 0xffbb9e14, 0xff968537, 0xff686669, 0xff6e6a5e, 0xff7d7550, 0xffac961e, 0xffbda20b, 0xffcbaa05, 0xffc4a608, 0xff7d764a, 0xff676662, 0xff696961, 0xff8c7e41, 0xffa49224, 0xffc8a607, 0xff968535, 0xff716f58, 0xffb0961d, 0xffc9a803, 0xffcbad00, 0xffaa9522, 0xff686961, 0xff66656a, 0xff7a7452, 0xff90813e, 0xffbba110, 0xffc9aa01, 0xffbfa10d, 0xff75705c, 0xff7f784e, 0xff978636, 0xffcea800, 0xffcda800, 0xffcbaa03, 0xffccac03, 0xffa9941f, 0xff7f784c, 0xff666563, 0xff666465, 0xff6d6b5e, 0xff797552, 0xffbda111, 0xff998830, 0xff736e5b, 0xff847a47, 0xffb39a19, 0xffceaa00, 0xffc7a505, 0xff847a49, 0xff6b685f, 0xff656661, 0xff6e6c60, 0xffaf951c, 0xffcca903, 0xff9e8e2f, 0xff777254, 0xff686763, 0xff746d5a, 0xffa08b2e, 0xffb39b13, 0xffc7a506, 0xffab951e, 0xff6d6862, 0xff73715c, 0xff948c39, 0xffc2a30a, 0xffc9a801, 0xffcda801, 0xffc1a20c, 0xff6a6663, 0xff656762, 0xffa2a439, 0xffd7d510, 0xffd1b401, 0xff867a48, 0xffbec621, 0xffe9f004, 0xffdac102, 0xffceae01, 0xffc4a20b, 0xffa28f29, 0xff686860, 0xff646663, 0xff6e6f5d, 0xffdae213, 0xfff2fd01, 0xffebeb00, 0xffddca02, 0xff877b47, 0xff6c6960, 0xff7a7c55, 0xffe5ee09, 0xfff4fe00, 0xfff0f900, 0xffe9e102, 0xffcdad00, 0xff7c7450, 0xff6c6c64, 0xff909247, 0xfff3fd00, 0xfff2fb00, 0xffdac700, 0xffceb100, 0xffae981e, 0xff6e6c5d, 0xff777856, 0xffa9b02e, 0xfff4fd02, 0xfff4ff01, 0xffe5dc03, 0xffd5bb04, 0xffcaab03, 0xffc6a508, 0xff7e754c, 0xff8b8e4b, 0xffd0d61a, 0xfff5ff00, 0xfff3f901, 0xffe8e600, 0xffcdaf01, 0xffae991c, 0xff897e3e, 0xff9d9f3c, 0xffdce111, 0xfff5ff01, 0xfff5fc01, 0xfff6f801, 0xfff3fc01, 0xfff0f602, 0xffd1b800, 0xffcdac00, 0xffc4a606, 0xffa89022, 0xff696864, 0xff686a67, 0xffc9ce19, 0xffedf901, 0xfff7fe01, 0xfff5fe03, 0xfff4c91b, 0xffe76b49, 0xffeed010, 0xfff4fa02, 0xffe8e400, 0xffd6bf01, 0xffc5a804, 0xff8a7f3f, 0xff6b6d5f, 0xffd5dc12, 0xfff0fd00, 0xffeaa331, 0xffe9345f, 0xffeca12e, 0xfff2ed0d, 0xfff2f302, 0xffe3d600, 0xffcdab01, 0xffa99323, 0xff70725c, 0xffd9e311, 0xfff3fe02, 0xfff2ee06, 0xffe43657, 0xffe8066c, 0xffeb2860, 0xffed8b2a, 0xfff5fc00, 0xfff1f604, 0xffd4bd00, 0xffceac02, 0xffcaa701, 0xffb29b17, 0xff6e6b5c, 0xff6b6a65, 0xffc1ca21, 0xffeef205, 0xfff1fe00, 0xffeed310, 0xffe91561, 0xffee016b, 0xffef0c65, 0xffea464d, 0xfff2f109, 0xffe0d200, 0xffc9ab00, 0xffc6a605, 0xff817649, 0xff69695f, 0xff838151, 0xffb8be26, 0xfff4f805, 0xfff3bf1d, 0xffed066c, 0xfff1006d, 0xfff10069, 0xfff0056a, 0xffee972d, 0xfff2e80c, 0xfff1f502, 0xffe8db01, 0xffcfab00, 0xff6f6d61, 0xff919242, 0xffedf408, 0xffebd216, 0xffe6186a, 0xfff0006b, 0xfff1006b, 0xffea4a52, 0xffedb11b, 0xfff6fd00, 0xffecef00, 0xffd1b200, 0xffc6a907, 0xffab951d, 0xff6b6861, 0xff6a6b63, 0xffc1c622, 0xffe9ef05, 0xffee8c29, 0xffed2860, 0xffef026c, 0xfff2016c, 0xffee0463, 0xffe9364c, 0xfff1f00c, 0xffe1d600, 0xffd4b600, 0xffccae02, 0xffc3ab0b, 0xff777356, 0xff999d3e, 0xffd2da13, 0xffefc61c, 0xffe65d57, 0xffed016d, 0xffee006f, 0xffe61769, 0xffeac91c, 0xfff6f703, 0xffecec02, 0xffdcca00, 0xffcaaf00, 0xffbcac0f, 0xffa89d29, 0xff6d6b5f, 0xff6d6e60, 0xff8f904c, 0xffedf406, 0xfff2d20b, 0xffeb185b, 0xffef026e, 0xfff00169, 0xfff1016c, 0xffe94754, 0xffeab126, 0xffeef100, 0xffd1b700, 0xffcead00, 0xffccb60a, 0xffb6a821, 0xff74725b, 0xff777658, 0xffdee50c, 0xfff2ef04, 0xffee4f54, 0xfff00f6b, 0xfff0006f, 0xffe71866, 0xffde664b, 0xfff5f902, 0xfff4fb00, 0xffd9c502, 0xffcfb000, 0xffd2b500, 0xffd3bb03, 0xffac9c2d, 0xff8a814a, 0xff98983e, 0xffd3d915, 0xffebd118, 0xffde684c, 0xffed0269, 0xfff2016a, 0xffec1068, 0xfff1bb1b, 0xfff4f503, 0xffefef03, 0xffdecf02, 0xffccad00, 0xffd5b900, 0xffdcbf03, 0xffbea620, 0xff968742, 0xff6b6764, 0xff7b7b55, 0xffafb52d, 0xffedf009, 0xffe9af27, 0xffed0c6a, 0xfff3026d, 0xfff2006e, 0xfff00271, 0xffed7c2c, 0xfff4da09, 0xfff1fa00, 0xffe7e600, 0xffcfae01, 0xffd3b401, 0xffe0c504, 0xffd5b514, 0xff8d7d49, 0xff716b5f, 0xff73765b, 0xffdbe40f, 0xffdb644e, 0xffe61968, 0xfff20070, 0xffe51668, 0xffde684e, 0xffdecd01, 0xffd0b300, 0xffcbaa00, 0xffd5b701, 0xffe4c302, 0xffe1bc0b, 0xff978442, 0xff766e59, 0xff67666b, 0xff696a62, 0xffbdc61f, 0xffe8f206, 0xffebad26, 0xffe84148, 0xffee016d, 0xffed056b, 0xffe62f5f, 0xfff6e60a, 0xfff3fc03, 0xffeae301, 0xffd7c002, 0xffceae03, 0xffd9be00, 0xffe3c704, 0xffdbb316, 0xffb49a2c, 0xff726b61, 0xff686367, 0xff797b54, 0xffaeaf30, 0xfff0f302, 0xffedc01f, 0xffea146c, 0xffef026a, 0xffee026e, 0xffe1663c, 0xffebd30f, 0xffebeb01, 0xffcdaa04, 0xffdfc300, 0xffeac900, 0xffe4b90a, 0xffc4a322, 0xff776f5a, 0xff6b6766, 0xff696564, 0xff6a6c61, 0xff8b8b4b, 0xffebf407, 0xfff3eb0e, 0xffe73452, 0xffed0666, 0xfff2026f, 0xffe83552, 0xffeba52b, 0xfff4f801, 0xffceac04, 0xffd9bc00, 0xffeec900, 0xfff2c206, 0xffb1962d, 0xff8a7c4b, 0xff666769, 0xffbbc025, 0xffe6f004, 0xffeab221, 0xffeb4a50, 0xfff1026a, 0xffec056d, 0xffeb295e, 0xfff2e209, 0xffece801, 0xffd9c600, 0xffd3b902, 0xffdec302, 0xfff1ca00, 0xfff3c204, 0xffbc9b28, 0xff918048, 0xff6b6663, 0xff96993e, 0xffcfd51b, 0xfff4e80a, 0xfff0942d, 0xffec056b, 0xfff1016e, 0xffed0d65, 0xffeaaf23, 0xfff2f208, 0xfff3f402, 0xffe4db02, 0xffccac00, 0xffefca00, 0xffebb70b, 0xffcca41e, 0xff817851, 0xff6b6b61, 0xff888d4d, 0xfff2f007, 0xffeb454f, 0xffee0c62, 0xffe7345c, 0xfff09e2e, 0xffdbbf03, 0xffceaf00, 0xffd2b502, 0xffeacb01, 0xfff5ca01, 0xffe6b80b, 0xffc9a41f, 0xff7e7652, 0xff6e6963, 0xff666865, 0xff70735e, 0xffd7de14, 0xffeffa00, 0xffef8b2d, 0xfff0006d, 0xfff0006c, 0xffee0f6c, 0xffee5256, 0xffe6d803, 0xffd4b703, 0xffc9aa02, 0xffd8bc03, 0xffe2c800, 0xfff8c901, 0xfff1c004, 0xffb09431, 0xff897b4c, 0xff8f9444, 0xffcad318, 0xfff2ef0c, 0xffeca62c, 0xffed0569, 0xffee0a63, 0xffeaac27, 0xfff1f00a, 0xfff2f800, 0xffe6e103, 0xffcfaa01, 0xffdcc102, 0xffebc905, 0xfff6c602, 0xffeebb0a, 0xffac8e34, 0xff867c4b, 0xff75785d, 0xffa8ad35, 0xfff4fa04, 0xffedd213, 0xffe71765, 0xffef006f, 0xffe0634d, 0xffeac918, 0xfff1f201, 0xffd3b603, 0xffd8bc00, 0xffefcc00, 0xfff7c800, 0xffdfb115, 0xffbf9b29, 0xff7a6f59, 0xff71735d, 0xffd8df15, 0xfff1fb06, 0xffef9e32, 0xffe7345e, 0xfff10268, 0xffed0d66, 0xffe9484e, 0xfff2f103, 0xffe3de00, 0xffd5bc00, 0xffddbf00, 0xfff7c901, 0xfffac600, 0xffdcaf16, 0xffb6972b, 0xff766e5b, 0xff686963, 0xffb9be26, 0xffead216, 0xffdf694b, 0xffef0170, 0xffe51761, 0xfff0cf0e, 0xffcdad02, 0xffe3c501, 0xfff0c900, 0xfff5c405, 0xffe8b80c, 0xffa2883d, 0xff7f7454, 0xff646661, 0xff757859, 0xffa5ad36, 0xfff2fb02, 0xfff4e109, 0xffe32c5c, 0xffec036c, 0xffee0467, 0xffdd7f3f, 0xffebdf11, 0xfff4ff05, 0xffeff501, 0xffd2b800, 0xffcea903, 0xffd3b402, 0xffeac902, 0xfff8c104, 0xffe4b50d, 0xff97853d, 0xff7d7254, 0xff88884c, 0xffe9f307, 0xfff5f604, 0xffe61566, 0xffef0566, 0xffe69e25, 0xfff2ea0b, 0xfff3fe00, 0xffddcc00, 0xffd1b202, 0xfff9c800, 0xfffac601, 0xffd3a919, 0xffad8f35, 0xff736c5a, 0xffb2b92b, 0xffe4ec0b, 0xfff2da06, 0xffeb7d28, 0xffe71870, 0xffdc5c59, 0xfff3f001, 0xfff7fe00, 0xfff2f301, 0xffe2d703, 0xfff8c701, 0xfffbc201, 0xffcda71e, 0xffa38d38, 0xff6f6d5e, 0xff8f9146, 0xffcacf1b, 0xffefbd1e, 0xffeb5a55, 0xffecb42d, 0xffecea01, 0xffd2b801, 0xffd7bb02, 0xffefcc01, 0xfff9cc00, 0xfff4bd08, 0xffdeb015, 0xff908045, 0xff76705a, 0xff86874d, 0xffe8f205, 0xfff7f504, 0xfffafa02, 0xfff4ff00, 0xfff7fe03, 0xfff6ff02, 0xfff7f902, 0xfff7d303, 0xfff9ca00, 0xfff4be06, 0xffdaae17, 0xff8e7d49, 0xff71705b, 0xff67656a, 0xff6f7060, 0xffd2da15, 0xfff0f902, 0xfff7ee00, 0xfffcc802, 0xfff7c003, 0xffc8a223, 0xff9c853f, 0xff636864, 0xff8c8d47, 0xffc5cd1f, 0xfffad703, 0xfff6c506, 0xffc29d28, 0xff988344, 0xff6c6761, 0xff75755b, 0xffa2a637, 0xfff8ff01, 0xfff3ff00, 0xfff8ed00, 0xffecbf0c, 0xffd0a71b, 0xff887a4d, 0xff6f6b60, 0xff70725d, 0xffd0d715, 0xffeef804, 0xfff2fd03, 0xffe5cd09, 0xffc7aa20, 0xff827552, 0xff6e6a61, 0xffaeb130, 0xffdfe90e, 0xfff1fa03, 0xffe9e708, 0xffb49e2f, 0xff8d7d4a, 0xff636766, 0xff72745c, 0xffa0a735, 0xffbbb426, 0xff8e8647]
				); 
        }
		public function box20():BitmapData{  
             return BitmapPatternBuilder.build( 
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,2,3,4,0,5,0,6,7,1,1,8,1,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,1,1,10,10,10,0,4,0,5,7,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,11,1,5,0,12,12,5,13,14,0,5,1,5,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,5,1,8,15,16,17,18,19,20,8,6,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,11,13,21,22,23,18,24,25,26,27,28,2,4,12,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,5,5,0,0,1,6,5,2,0,0,29,30,31,32,18,33,34,35,36,37,37,38,39,40,13,41,42,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,5,5,0,5,0,0,0,0,42,4,0,13,43,44,45,46,47,48,49,50,51,51,52,52,37,53,54,30,9,12,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,4,5,0,0,5,55,44,56,57,58,34,35,36,59,59,38,60,61,52,52,37,37,37,62,63,0,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,42,0,9,5,13,64,31,17,57,65,25,66,50,67,37,37,60,52,52,52,37,37,37,37,59,68,17,8,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,12,14,69,40,70,57,24,39,71,72,73,74,75,51,37,37,76,77,78,74,52,52,52,52,52,52,79,80,81,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,13,82,83,84,85,86,87,88,36,52,37,59,61,59,37,51,89,67,59,51,90,52,52,37,37,37,74,91,92,93,2,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,5,5,5,0,5,42,5,42,0,1,11,29,29,94,95,96,97,98,99,100,50,51,51,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,77,51,101,102,103,0,5,1,5,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,0,1,10,9,10,0,0,11,0,29,8,94,104,105,106,107,108,91,73,60,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,37,91,109,110,12,5,0,0,1,0,0,0,0,0,0], 
    [0,0,0,0,0,12,0,0,42,0,10,111,112,93,113,114,115,116,25,91,36,37,37,52,37,52,38,52,52,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,38,67,117,118,0,0,5,0,0,5,0,0,0,0,0], 
    [0,0,0,0,0,1,5,12,7,10,81,94,40,119,120,121,122,123,36,76,76,76,51,38,37,52,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,38,51,99,124,112,0,0,0,0,5,0,0,0,0,0], 
    [0,0,0,0,0,4,6,82,83,125,126,127,128,91,76,129,37,52,52,52,52,51,37,37,61,51,130,52,52,52,52,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,129,50,52,35,131,132,111,0,0,0,1,0,0,0,0,0], 
    [4,42,12,1,1,5,133,134,135,136,122,137,73,52,52,38,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,129,60,52,38,128,138,8,1,4,4,9,0,0,0,0,0], 
    [0,0,5,5,12,139,140,141,142,89,51,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,52,59,143,144,145,146,29,0,1,5,0,0,0,0,0], 
    [11,0,1,8,147,148,149,150,151,152,50,52,52,52,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,52,59,37,153,154,155,0,5,9,4,0,0,0,0,0], 
    [0,29,156,157,158,159,160,161,162,163,164,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,51,37,52,59,51,99,165,111,1,10,0,0,0,0,0,0], 
    [1,112,166,167,168,169,170,161,171,172,173,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,51,52,52,59,51,174,175,176,5,0,177,0,0,0,0,0], 
    [178,179,180,181,182,183,184,169,161,185,186,74,52,37,187,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,51,188,189,190,0,0,0,0,0,0,0], 
    [191,192,193,161,194,170,194,195,196,197,198,37,59,37,52,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,59,35,23,176,0,0,0,0,0,0,0], 
    [199,200,200,161,194,183,201,202,203,204,205,206,52,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,73,207,208,10,12,0,0,0,0,0], 
    [209,210,169,161,196,211,212,213,214,215,216,217,78,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,218,105,8,0,0,0,0,0,0], 
    [219,220,161,221,222,223,224,225,226,227,228,229,230,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,50,231,232,176,9,0,0,0,0,0], 
    [233,234,235,236,237,238,239,240,241,242,243,244,245,51,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,51,52,137,246,247,29,0,0,0,0,0], 
    [248,249,250,251,252,253,254,255,256,257,222,258,259,50,52,38,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,50,37,101,118,43,7,1,1,9,0], 
    [260,261,262,263,264,265,266,267,268,269,270,271,272,67,52,76,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,51,37,36,273,44,4,1,5,5,12], 
    [9,274,275,276,277,278,267,266,279,280,281,282,283,284,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,51,52,51,285,20,286,0,1,1,2], 
    [0,287,288,289,290,291,292,293,294,295,296,297,298,299,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,51,52,50,128,300,13,11,4,4,12], 
    [0,301,302,303,304,305,306,307,293,308,309,310,311,312,313,61,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,59,37,37,52,61,314,22,29,1,1,0], 
    [0,315,316,317,318,319,320,266,321,322,323,324,236,325,326,327,38,52,52,52,61,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,129,37,61,76,328,155,329,42,0,5], 
    [11,3,330,331,332,333,334,266,335,255,336,337,338,339,340,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,38,52,37,61,59,36,126,104,0,341,3], 
    [3,4,13,342,343,344,345,346,293,347,348,349,350,162,351,352,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,52,37,52,52,37,353,354,3,4,9], 
    [355,12,9,356,357,358,359,360,361,294,292,362,363,243,364,365,164,61,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,61,61,26,366,112,5,0], 
    [1,5,0,367,368,369,370,371,265,266,266,372,373,374,375,376,284,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,38,61,71,377,378,0,341], 
    [42,0,42,379,380,381,358,382,292,335,361,383,384,385,236,386,387,60,37,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,67,388,389,390,4], 
    [4,1,0,7,391,392,393,394,322,266,395,396,397,398,399,400,401,37,37,37,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,50,91,402,93,42], 
    [4,0,0,4,330,403,317,404,382,405,406,407,320,408,409,410,411,77,38,61,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,50,412,413,1], 
    [4,0,5,12,7,414,415,416,323,361,335,406,347,417,418,419,420,421,51,61,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,38,37,422,109,0], 
    [1,0,4,1,5,423,424,425,426,396,266,361,427,428,429,430,162,431,421,52,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,49,432,21], 
    [5,1,11,9,0,433,434,435,436,437,266,335,395,438,439,440,171,229,441,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,60,36,442,443], 
    [0,0,0,0,0,29,444,445,446,447,448,361,266,396,449,450,451,452,376,50,59,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,37,52,52,37,37,37,52,60,75,453], 
    [0,0,0,0,0,0,454,455,456,457,458,335,459,255,460,461,462,463,464,465,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,67,59,50,51,52,164,37,61,37,73,466], 
    [0,0,0,0,0,5,0,467,468,469,470,471,472,473,294,417,474,475,476,477,59,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,37,38,52,52,51,90,123,478,116,479,96], 
    [0,0,0,0,0,8,4,480,481,482,483,306,266,292,294,484,485,486,487,488,59,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,59,50,37,37,35,174,98,489,490,491,492], 
    [0,0,0,0,0,2,8,493,494,495,496,396,294,395,395,497,498,499,500,501,465,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,144,502,503,489,490,491,504,190,8,5,5], 
    [0,0,0,0,0,11,341,505,506,507,508,509,347,294,406,371,510,385,171,511,512,52,52,52,52,38,52,52,52,52,52,52,52,52,52,52,52,59,37,52,37,51,59,67,37,37,59,61,37,51,90,144,231,513,514,515,516,517,518,0,0,0,0,0], 
    [0,0,0,0,0,0,3,111,519,520,521,522,347,265,361,265,523,461,524,525,526,52,38,52,52,52,52,52,52,52,52,52,52,52,52,52,52,421,59,59,51,37,52,51,37,59,51,35,328,127,514,119,491,132,103,4,0,0,12,0,0,0,0,0], 
    [0,0,0,0,0,5,0,527,528,529,530,531,532,335,533,266,534,408,535,536,537,52,37,52,52,52,52,52,52,52,52,52,52,52,52,52,52,74,61,59,52,52,52,37,78,538,174,127,539,540,541,132,190,10,0,0,12,0,0,0,0,0,0,0], 
    [0,0,0,0,0,542,12,0,7,543,544,545,546,292,265,306,361,547,548,549,550,551,67,61,52,52,52,52,52,52,52,52,52,52,52,52,52,51,51,60,74,35,502,552,353,490,541,132,553,5,0,5,0,1,0,5,9,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,9,0,5,554,555,556,557,293,558,266,266,559,560,374,561,562,59,37,52,52,52,52,52,52,52,52,52,52,52,52,52,61,61,35,53,563,564,565,566,567,568,8,12,9,5,0,177,1,0,0,4,7,286,0,0,0,0,0], 
    [0,0,0,0,0,0,0,5,12,569,570,571,572,573,574,575,576,577,578,579,580,581,488,67,52,76,51,52,52,59,37,52,51,52,51,91,582,583,584,585,586,587,178,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,5,0,1,518,588,589,590,591,592,593,594,595,596,597,598,599,600,52,38,37,59,52,37,59,52,36,59,137,601,602,353,603,604,492,605,12,606,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,0,0,0,0,30,607,608,609,610,611,612,243,210,613,196,614,511,51,59,74,52,38,38,36,100,503,615,616,516,93,133,5,0,0,0,9,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,8,5,5,329,617,618,619,620,194,196,169,161,621,170,622,623,164,59,37,76,88,624,552,625,626,566,627,103,12,0,0,5,1,1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,5,0,0,0,1,0,628,629,620,161,169,620,183,630,183,161,243,631,488,53,552,632,633,634,635,518,13,8,1,1,3,177,4,4,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,42,1,0,0,1,636,637,638,221,630,196,161,210,181,639,640,641,642,412,643,644,635,133,41,12,1,11,9,4,1,177,0,5,5,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,330,645,646,647,648,649,650,651,652,653,654,655,656,378,5,11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,8,657,658,659,660,661,662,663,664,665,666,330,8,5,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,5,7,8,13,0,0,0,0,0,0,0,0,0,42,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,5,1,0,1,5,0,0,0,0,9,42,1,1,2,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,1,29,5,1,7,41,1,0,0,0,42,42,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666668, 0xff676664, 0xff676769, 0xff656766, 0xff666664, 0xff666762, 0xff656764, 0xff676765, 0xff676566, 0xff676568, 0xff656668, 0xff676767, 0xff676863, 0xff676862, 0xff6d6a61, 0xff75705a, 0xff877c46, 0xff988831, 0xffa89024, 0xff8e813b, 0xff6d6960, 0xff747057, 0xff877d42, 0xffb59a19, 0xffbfa10f, 0xffc2a30b, 0xffa79121, 0xff696961, 0xff686765, 0xff6a6a62, 0xff747055, 0xff887b47, 0xffb69917, 0xffbe9f10, 0xffc9a803, 0xffcaa902, 0xffccaa02, 0xffcba901, 0xffbea00e, 0xff777255, 0xff686667, 0xff656565, 0xff6d695e, 0xff767056, 0xff8a7b40, 0xff998830, 0xffb49916, 0xffbea00c, 0xffc8a805, 0xffcaaa01, 0xffcbab02, 0xffccaa00, 0xffc7a706, 0xff83774d, 0xff6b6b61, 0xff887b46, 0xff998733, 0xffb2991a, 0xffcbab00, 0xffcca903, 0xffcba900, 0xffa69128, 0xff7a7452, 0xff6c6a5d, 0xffb39b17, 0xffc9a805, 0xffcaaa00, 0xffb29b1b, 0xff706a5e, 0xff877c44, 0xffc8a702, 0xffc9aa04, 0xffcba802, 0xffcea902, 0xffcba804, 0xffcbaa03, 0xffcdab03, 0xffcea900, 0xffc4a705, 0xffaa9321, 0xff6a6663, 0xff6f6b60, 0xff767154, 0xff8d7d41, 0xff9b8a2e, 0xffb39a19, 0xffbca00e, 0xffc9aa02, 0xffcdac00, 0xffcaab02, 0xffcaa904, 0xffb79c17, 0xff6f6c5d, 0xff6e6a5e, 0xff777254, 0xff8e7e40, 0xff9c8c2d, 0xffb69b18, 0xffbfa10d, 0xffc8a903, 0xffc8a807, 0xff847a49, 0xff69695f, 0xff777157, 0xff8d7f40, 0xff9d8930, 0xffb49c18, 0xffbda30e, 0xff958538, 0xff736e5a, 0xff676662, 0xff686763, 0xff787155, 0xff8a7e44, 0xff9f8a2f, 0xffb49c16, 0xffb59a17, 0xff887e43, 0xff8c7e41, 0xff9d8932, 0xffb89b19, 0xffc0a00d, 0xffc8a901, 0xff9a8a32, 0xff8d7d3f, 0xff9c8b2f, 0xffb69b16, 0xffc0a20c, 0xffccab00, 0xffc9ab00, 0xffb89d12, 0xff6e6c5f, 0xff6a6964, 0xff8a8448, 0xff9f8f2f, 0xffb69c14, 0xffcaa703, 0xff787451, 0xff7c7d51, 0xff9fa539, 0xffe1e20a, 0xffdecd03, 0xffceaa00, 0xffcaa701, 0xff978636, 0xff756f59, 0xff6e6f61, 0xffa4a935, 0xffcdd51d, 0xfff0f503, 0xffe4df01, 0xffcbad01, 0xffcda801, 0xffa99323, 0xff7f764f, 0xff686868, 0xff8b8e47, 0xffb3b828, 0xffedf605, 0xfff3fe00, 0xfff4fe00, 0xfff0f100, 0xffd3b500, 0xffcdab01, 0xff9a892f, 0xff73725e, 0xffbbc322, 0xffdde70d, 0xfff5ff01, 0xfff4ff00, 0xfff2f800, 0xffd6be02, 0xffcbac03, 0xffc6a605, 0xffad941e, 0xff6c6960, 0xff66656a, 0xff6c6964, 0xff949a42, 0xffc2c921, 0xfff1fb04, 0xfff3fe02, 0xfff5ff00, 0xfff6ff02, 0xffe2d701, 0xffd5b900, 0xffcbaa00, 0xffc4a20b, 0xff7c7450, 0xff696863, 0xff7b7e53, 0xffc7cb1f, 0xffe6ed0b, 0xfff4ff01, 0xfff5ff02, 0xfff3ff00, 0xffe8e400, 0xffd8bf02, 0xffd9de12, 0xfff2fd00, 0xfff2ff02, 0xfff3f402, 0xfff5f902, 0xfff0f600, 0xffe3da03, 0xffcdad02, 0xffaa9522, 0xff7f784e, 0xffd6de0d, 0xfff3fd00, 0xfff3fc03, 0xffebee09, 0xffe2c110, 0xfff0e308, 0xfff3f901, 0xffe9e500, 0xffceaf00, 0xffb79b13, 0xff929544, 0xffeef803, 0xfff7fe03, 0xfff4fa04, 0xffd7b025, 0xffbd5e42, 0xffca2547, 0xffdf7029, 0xfff5fa00, 0xffeff801, 0xffd5bc00, 0xffcead00, 0xffc7a603, 0xffaf9620, 0xff818351, 0xffe8ef0b, 0xfff4fd02, 0xfff3fa00, 0xfff0e007, 0xffcc584b, 0xffc41e5c, 0xffdf0b5f, 0xffe64b46, 0xfff5f406, 0xfff4fb00, 0xffd8c401, 0xffcfaf02, 0xffba9f12, 0xff716f58, 0xff6c6c60, 0xffc9ce1a, 0xffebf403, 0xffedaa15, 0xffe9513c, 0xffea0467, 0xfff0006c, 0xffef026e, 0xffe71a67, 0xffebce1a, 0xffe8de02, 0xffd5bd01, 0xff686866, 0xffb5ba2a, 0xffe3eb0a, 0xfff4a41b, 0xffeb3a4e, 0xffee016b, 0xfff0006b, 0xffee006f, 0xffeb0b6b, 0xffebae20, 0xfff1ef04, 0xffedeb00, 0xffd9ca00, 0xff9b8a30, 0xff8a8c4b, 0xffc5cc1e, 0xffeacd1a, 0xffe06748, 0xffef036f, 0xffee036c, 0xffe15b50, 0xffebc61d, 0xfff0fa03, 0xffe8e301, 0xffceac02, 0xffb79d14, 0xff656762, 0xff7c7c56, 0xffb0b42c, 0xffeee30f, 0xffeb952e, 0xffec056b, 0xfff1016c, 0xfff2016c, 0xfff1016e, 0xffe93a5b, 0xffeea228, 0xfff2fb02, 0xffeded01, 0xffd0b101, 0xffa08d2e, 0xff6b6b63, 0xff878948, 0xffe7ee0a, 0xffe8cd1a, 0xffe61964, 0xfff2006e, 0xfff0006f, 0xffef0a65, 0xffe8484a, 0xfff5f403, 0xfff1fa01, 0xffd9c001, 0xffceae01, 0xffbc9f13, 0xff686964, 0xff7a7b59, 0xffdee20f, 0xffede40b, 0xffea315a, 0xfff0036b, 0xfff1006f, 0xffee066a, 0xffec345a, 0xfff2e80c, 0xffdfcd01, 0xffd1b303, 0xffcaac00, 0xffc7a505, 0xff686963, 0xff696a64, 0xffbec225, 0xffe7ec0b, 0xffdf664b, 0xffe71963, 0xfff1006b, 0xffeb096b, 0xffeaad1f, 0xfff4ee02, 0xffebe900, 0xffd9c502, 0xff656563, 0xffa4a837, 0xffd9e112, 0xffe99630, 0xffe8325b, 0xffed006c, 0xffef026c, 0xfff0056a, 0xffe68236, 0xffeddb0d, 0xffe1d100, 0xffccab04, 0xffac961f, 0xff83784a, 0xff666465, 0xff7f8351, 0xffb8bf24, 0xffeccc17, 0xffe86940, 0xfff10268, 0xfff0006d, 0xffe63c57, 0xffeca323, 0xffeaea00, 0xffcfb000, 0xffa39027, 0xff737659, 0xffa0a338, 0xffeee50a, 0xffef9b27, 0xfff0056c, 0xffea1c5a, 0xffed6c32, 0xfff4f801, 0xffeef301, 0xffd1b700, 0xffb29918, 0xff6c6962, 0xff676a61, 0xff7c7e57, 0xffe0e50d, 0xffe91a62, 0xffef046b, 0xffeb3659, 0xfff1e90c, 0xffdbca01, 0xffd0b202, 0xffc7a60b, 0xff7f784c, 0xff686762, 0xff72715f, 0xffd3d915, 0xffede20a, 0xffed3358, 0xfff1006d, 0xffef046d, 0xffe71a65, 0xffe9cf1a, 0xfff3f903, 0xffe5d800, 0xffd2b800, 0xff8b803e, 0xffadb231, 0xffe7683f, 0xffef006c, 0xfff00169, 0xfff0006a, 0xffe68234, 0xffeedc10, 0xffecef00, 0xffdfcd00, 0xffaf971d, 0xff85784b, 0xff959743, 0xffd1d617, 0xffef9b2b, 0xffe05b52, 0xffebc61f, 0xfff4f600, 0xffe7da00, 0xffccac01, 0xffba9e0f, 0xff787a55, 0xffaab032, 0xffeaca13, 0xffe6693d, 0xfff10170, 0xffed1b5a, 0xffed6b31, 0xfff4fa02, 0xffd0b600, 0xffb29a16, 0xff706e5f, 0xff939444, 0xffece10b, 0xffef9b29, 0xffec056d, 0xffef0c68, 0xffeb484d, 0xfff4f504, 0xffcdad00, 0xffbda20d, 0xff757156, 0xff76765a, 0xffd8dd11, 0xffe8ca14, 0xffe71b64, 0xffee0169, 0xffe51b67, 0xffeacc1c, 0xfff5f602, 0xffe3d301, 0xff958635, 0xff6d6e60, 0xffc9ce1c, 0xffe9df0c, 0xffec3458, 0xfff00669, 0xfff1026a, 0xffea0b68, 0xffecae1f, 0xfff4ee04, 0xffe9e200, 0xffd4c001, 0xffccac03, 0xffac981b, 0xff9ca13a, 0xffd6d717, 0xffe6683f, 0xffea1b61, 0xffee016d, 0xffef006e, 0xfff2016a, 0xffecc61d, 0xffeff300, 0xffe4d601, 0xffccac00, 0xffc6a606, 0xffaa951e, 0xff888e48, 0xffc7cb1e, 0xffed9929, 0xffec3257, 0xffe83b57, 0xffeda225, 0xfff1f700, 0xffeae301, 0xffceae03, 0xffac9521, 0xff8a7f41, 0xff7f764b, 0xff6f6c5b, 0xff70745d, 0xff979c42, 0xffe9ca18, 0xffe76a3e, 0xffee0b65, 0xffec474d, 0xfff5f507, 0xffeff500, 0xffd6ba01, 0xffc7a707, 0xffb89c15, 0xff6b6c5e, 0xff6a6b63, 0xff87884c, 0xffe8de0d, 0xffeca12c, 0xffef076d, 0xffea345a, 0xffdac400, 0xffceb002, 0xffb79b16, 0xffab9420, 0xff8a7f3d, 0xff80784a, 0xff6f6b5f, 0xff696864, 0xff6e6e62, 0xffcfd31a, 0xffe9cb11, 0xffed1c5d, 0xffe80b6a, 0xfff5ef03, 0xffe4de02, 0xffd4bc00, 0xff696564, 0xff696a65, 0xffbdc325, 0xffe7da0f, 0xffed3859, 0xffed086d, 0xfff2006d, 0xffec046a, 0xffefda0f, 0xffecea02, 0xffdbc500, 0xffc9a801, 0xffae951f, 0xff8b7c41, 0xff80774e, 0xff656567, 0xff909048, 0xffccd01b, 0xffe76e37, 0xffea1d5e, 0xffe83c56, 0xffeda222, 0xfff2f802, 0xffe6e300, 0xffcdae00, 0xffb89c14, 0xff686961, 0xff838150, 0xffbbbe25, 0xffeea024, 0xffea3956, 0xfff10069, 0xffe61c56, 0xffe36b2e, 0xffeeed00, 0xffd1b200, 0xffb79b14, 0xffb0961f, 0xff8f803b, 0xff82774a, 0xff6e6c5d, 0xff6a6965, 0xff6e6c60, 0xff898f49, 0xffe8c815, 0xffe76f33, 0xffee0765, 0xffeb0769, 0xffd50f66, 0xffc81058, 0xffc2303d, 0xffcb682d, 0xfff3f704, 0xfff3f800, 0xffd5c102, 0xffc8a606, 0xffb99c14, 0xffae961c, 0xff8f823e, 0xff81794a, 0xff706d5c, 0xff7e7f53, 0xffe0d90d, 0xffefab1a, 0xffef3e50, 0xffe6414f, 0xffc64f53, 0xffc1553b, 0xffd38a17, 0xffe1b411, 0xfff6fa05, 0xfff5fc01, 0xffdecb02, 0xffd1b202, 0xffc8a607, 0xffb79d12, 0xff8e803f, 0xff847846, 0xff6b6861, 0xff666867, 0xffc4ca20, 0xffebec08, 0xfff6f004, 0xfff5f605, 0xfff0fa05, 0xfff0f902, 0xfff6ff01, 0xffe9e601, 0xffb0961d, 0xff8e813d, 0xffb1b52d, 0xffe2e80c, 0xfff6fd02, 0xfff7fe01, 0xfff5fe03, 0xffeeee00, 0xffe0d000, 0xffc7a704, 0xffad971d, 0xff917f3f, 0xff6e6d5b, 0xff85894c, 0xffc1c822, 0xfff6fd00, 0xffeae702, 0xffaf971b, 0xff92803e, 0xff83784b, 0xff706d5e, 0xff797a58, 0xffa9ae2e, 0xfff1fc00, 0xffeffb03, 0xffedf502, 0xffe4e606, 0xffc0a613, 0xff8f803d, 0xff84774d, 0xff81844f, 0xffd2da15, 0xffd7e015, 0xffcbd31b, 0xffc8d01b, 0xffbcc224, 0xffafb52d, 0xff969942, 0xff8d9049, 0xff88894d, 0xff82854e, 0xff726f5c, 0xff71705c, 0xff9a9f3b, 0xff9a9e3f, 0xff8a8c4d, 0xff8a8a4c, 0xff838351, 0xff7c7d55, 0xff6e6f5f, 0xff6b6c64, 0xff696a62]
				); 
        }
		public function box21():BitmapData{  
             return BitmapPatternBuilder.build( 
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,2,2,0,0,2,0,3,0,4,5,6,0,0,0,0,0,4,2,2,7,8,0,9,10,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,4,4,0,0,0,0,2,8,0,0,0,0,2,2,3,0,0,0,0,0,0,0,2,11,4,4,0,0,4,4,8,0,0,8,4,3,4,2,4], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,4,0,0,0,0,0,0,0,0,2,0,4,4,13,4,0,0,0,0,8,0,0,0,4,13,0,0,12,12,14,14,12,0,0,2,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,12,8,8,15,16,16,17,18,19,19,20,21,21,22,23,24,25,26,27,28,29,30,31,15,0,4,8], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,7,0,0,4,15,17,17,32,33,19,20,34,20,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,25,17,55,0,0], 
    [0,2,9,0,0,1,4,2,13,0,4,2,9,2,0,0,56,2,0,15,57,58,34,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,91,90,92,93,94,2,95,0], 
    [2,4,4,1,0,8,12,2,3,2,8,0,0,5,15,96,97,59,59,98,99,100,101,102,103,104,105,106,107,108,109,110,111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,126,127,128,129,129,130,130,131,132,132,131,133,134,135,0,0,4], 
    [14,2,0,12,4,57,58,136,20,60,137,138,139,140,141,142,143,144,145,146,147,148,149,150,151,152,153,154,155,156,157,158,159,160,161,162,163,129,129,89,91,130,164,131,165,166,166,164,131,131,131,166,166,132,166,132,166,132,167,168,169,0,0,4], 
    [17,21,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,193,194,195,196,197,198,128,199,200,130,130,130,166,166,90,131,166,166,132,132,166,132,164,132,132,201,132,132,132,166,132,166,132,202,203,204,0,2,0], 
    [205,206,207,208,209,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,129,128,91,130,164,130,132,132,131,166,165,132,132,132,166,132,131,131,166,166,165,165,166,166,132,132,164,132,132,132,164,164,132,166,132,166,132,166,226,227,2,9,0], 
    [228,229,230,231,232,233,234,235,236,237,238,238,239,240,241,242,89,89,130,130,164,243,166,166,166,243,132,165,132,166,132,166,131,166,132,166,166,132,132,166,166,132,244,131,131,166,166,131,132,132,132,132,132,132,166,243,166,132,166,245,246,0,8,0], 
    [247,248,249,250,251,249,249,249,252,252,248,252,253,254,255,243,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,256,257,0,4,2], 
    [258,248,251,252,252,252,252,252,252,252,252,252,253,259,222,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,260,261,0,0,0], 
    [262,263,251,252,251,251,252,252,252,252,252,252,251,264,265,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,266,267,11,1,268], 
    [269,270,249,271,271,251,249,249,252,272,252,252,251,273,274,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,275,276,16,0,8], 
    [277,278,279,280,281,282,283,284,285,286,287,288,263,289,290,91,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,291,292,17,0,2], 
    [293,294,295,296,297,298,299,300,301,302,303,304,305,306,307,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,308,309,97,0,0], 
    [310,311,312,313,314,315,316,317,318,319,320,321,322,323,324,91,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,325,326,33,1,0], 
    [327,328,329,330,331,332,333,334,333,335,336,337,338,339,340,341,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,325,342,18,0,0], 
    [343,344,345,346,347,348,349,332,350,350,347,351,352,247,353,341,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,133,354,355,0,2], 
    [356,357,358,359,348,348,331,331,331,347,360,361,362,363,273,199,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,92,364,365,7,0], 
    [366,367,368,369,370,331,331,331,331,331,331,371,372,373,289,374,164,132,132,132,243,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,202,375,204,15,4], 
    [376,377,378,379,380,331,331,331,331,331,331,381,382,383,384,224,164,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,202,385,386,17,0], 
    [171,387,388,389,330,331,331,331,331,331,331,390,391,392,393,394,130,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,243,395,396,18,4], 
    [21,397,398,399,400,331,331,331,331,331,331,401,402,403,404,405,129,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,406,325,93,33,0], 
    [97,407,408,409,410,331,331,331,331,331,331,410,411,412,413,274,129,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,414,325,415,33,7], 
    [15,416,417,418,419,331,331,331,331,331,331,420,421,422,423,424,425,243,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,131,426,427,428,95], 
    [2,429,377,430,431,331,331,331,331,331,331,432,433,434,435,436,224,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,131,437,438,439,0], 
    [0,440,441,442,443,331,331,331,331,331,331,444,445,446,383,447,448,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,202,449,450,0], 
    [2,451,397,452,453,331,331,331,331,331,331,335,454,455,456,457,196,132,132,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,406,458,459,0], 
    [460,461,462,463,421,331,331,331,331,331,331,331,464,465,466,467,468,132,132,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,166,469,470,0], 
    [0,471,472,473,474,331,331,331,331,331,331,331,475,476,477,478,479,132,132,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,164,480,481,0], 
    [0,482,483,484,485,486,348,334,331,331,331,348,487,488,489,490,491,166,164,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,492,164,493,93,2], 
    [7,494,495,496,497,498,348,499,331,331,331,347,500,501,502,503,504,91,164,166,131,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,164,266,505,506], 
    [0,171,507,508,509,510,348,331,331,331,331,347,511,512,513,514,515,91,164,131,131,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,516,438,506], 
    [0,517,518,519,520,521,331,347,499,331,499,522,335,523,524,525,526,89,166,164,244,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,166,527,528,16], 
    [4,17,529,530,531,532,499,347,331,533,331,349,534,535,338,536,537,129,166,164,164,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,166,538,539,17], 
    [2,15,540,541,542,543,544,347,545,331,348,347,350,546,547,239,548,425,166,166,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,549,164,550,256,33], 
    [0,11,376,551,552,553,554,349,348,331,348,331,533,555,556,557,558,126,132,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,131,550,256,33], 
    [0,3,559,560,561,562,563,564,565,347,349,348,331,566,297,423,567,255,341,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,131,92,354,568], 
    [1,3,569,570,571,572,573,347,533,347,347,331,331,574,575,576,577,241,130,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,131,167,578,579], 
    [8,0,580,581,582,583,532,333,347,331,347,331,335,584,585,284,586,468,129,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,131,437,587,588], 
    [589,95,15,590,591,592,593,331,347,331,347,533,594,595,596,284,363,597,129,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,164,167,527,598], 
    [0,4,8,599,377,600,601,347,331,347,564,347,347,602,603,412,288,604,605,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,406,166,131,606,607], 
    [0,0,12,608,609,610,611,612,331,347,331,613,331,614,615,616,288,617,618,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,164,131,550,257], 
    [0,2,2,619,620,621,622,623,624,625,626,627,628,629,630,631,632,633,255,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,131,166,133,634], 
    [1,0,2,635,636,637,638,639,640,641,642,643,644,645,646,647,648,457,394,166,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,166,166,133,649], 
    [2,4,4,650,416,651,652,653,654,655,656,657,658,659,660,661,662,663,468,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,406,132,131,664,665], 
    [666,0,0,667,668,669,670,671,672,673,674,675,676,657,677,678,662,679,680,132,165,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,164,166,132,406,166,132,166,166,131,132,406,681], 
    [2,0,2,682,495,683,248,248,684,685,686,687,688,689,690,691,692,693,694,132,166,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,695,132,132,132,696,166,166,243,697,695,132,166,132,549,406,698], 
    [0,0,0,699,700,701,271,251,702,703,423,704,705,706,707,708,709,710,711,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,166,132,166,166,201,132,131,132,201,201,166,166,167,712,713], 
    [0,0,0,580,714,715,716,717,252,251,252,249,718,719,720,709,721,577,722,130,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,166,201,132,131,414,92,133,723,724,260,245,276,725,726], 
    [4,0,2,727,728,729,730,684,252,731,251,249,249,251,732,288,248,525,733,91,696,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,132,734,735,395,736,737,738,739,740,741,742,743,135,94], 
    [0,0,0,4,744,745,746,747,748,749,253,252,702,251,250,271,249,750,679,199,166,201,201,243,132,132,132,132,697,166,166,164,166,132,166,695,166,132,166,132,132,166,131,166,406,751,92,752,753,754,755,756,757,758,759,760,59,761,761,0,0,0,0,0], 
    [0,0,0,0,4,580,762,763,764,748,765,250,251,249,271,252,703,288,766,128,132,164,131,131,131,132,132,132,132,767,166,165,166,131,767,406,165,131,131,414,414,734,768,395,736,769,480,770,771,772,758,773,579,58,774,4,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,775,0,0,776,777,778,779,780,781,250,703,703,684,306,782,164,492,166,132,132,166,166,166,132,166,492,166,164,131,414,92,550,783,784,354,326,785,786,758,759,579,787,57,16,5,4,1,1,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,10,11,0,4,788,789,790,636,791,792,271,252,253,793,794,90,243,243,132,166,164,164,131,132,165,406,795,92,712,538,796,797,798,665,799,800,801,802,803,17,15,0,1,0,4,0,2,775,4,0,0,0,4,4,0,0,0,0,0], 
    [0,0,0,0,0,804,4,0,0,4,805,744,428,806,807,808,809,810,811,812,130,132,132,132,132,437,712,813,814,815,469,816,817,93,818,819,31,820,17,1,0,0,2,0,2,0,775,2,7,0,0,4,0,2,0,0,13,1,1,0,0,0,0,0], 
    [0,0,0,0,0,2,0,4,2,821,1,0,13,428,822,823,824,825,826,827,828,414,437,712,829,830,831,832,833,834,835,836,819,17,820,15,15,1,2,4,4,0,8,0,0,4,15,821,837,0,2,0,2,7,1,0,0,0,5,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,0,0,2,32,838,839,840,841,842,843,844,481,607,845,31,58,761,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,2,4,0,1,744,482,846,847,481,598,848,33,820,11,7,8,8,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,3,0,0,2,775,0,8,1,7,4,4,1,0,8,2,0,0,0,0,8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,5,4,0,0,0,0,15,15,2,4,2,95,4,4,0,1,0,0,2,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,9,9,0,3,849,11,11,95,1,4,55,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff676566, 0xff666668, 0xff656565, 0xff666664, 0xff676767, 0xff646665, 0xff676664, 0xff656766, 0xff656668, 0xff666465, 0xff686765, 0xff656764, 0xff656563, 0xff656567, 0xff676765, 0xff686763, 0xff696863, 0xff696961, 0xff6c6962, 0xff6d6a63, 0xff6b6b61, 0xff6e6c5f, 0xff75705a, 0xff787258, 0xff7a7452, 0xff807851, 0xff83804d, 0xff84814c, 0xff858049, 0xff807a48, 0xff6d6b5e, 0xff6a6964, 0xff6a6a62, 0xff6c6960, 0xff6f6b60, 0xff746e5e, 0xff787157, 0xff7b7158, 0xff847852, 0xff867b4e, 0xff897d4b, 0xff8a7e4c, 0xff8b7d4c, 0xff8e7e4b, 0xff8d8449, 0xff908945, 0xff98903d, 0xff9c9138, 0xffa49132, 0xffa89829, 0xffafa522, 0xffb1a81f, 0xffb1a31e, 0xffab9c1f, 0xff66656a, 0xff696566, 0xff696864, 0xff6b6861, 0xff6d6a61, 0xff736e5b, 0xff7e7355, 0xff84784e, 0xff8d7d49, 0xff907f47, 0xff9c883f, 0xffa38d3a, 0xffad9034, 0xffb7962b, 0xffbea026, 0xffc3a125, 0xffcca51c, 0xffcda61b, 0xffd1a71d, 0xffd0ab1e, 0xffceb31a, 0xffcfb518, 0xffd5b314, 0xffd7b112, 0xffdbb60d, 0xffdbbe0b, 0xffd5c405, 0xffd5c206, 0xffd4b704, 0xffd2b104, 0xffd1b303, 0xffd0b504, 0xffceb503, 0xffcdb304, 0xffcdad02, 0xffccac03, 0xffcdab01, 0xffc9a805, 0xff837948, 0xff6b685f, 0xff676568, 0xff696866, 0xff686963, 0xff746d5b, 0xff7b7156, 0xff867851, 0xff8a7c4b, 0xff937f4a, 0xff998642, 0xffb09431, 0xffbc9b27, 0xffcea620, 0xffd0a91d, 0xffdbaf18, 0xffdeb215, 0xffe1b413, 0xffe6b60c, 0xffe5c109, 0xffe4c208, 0xffe8c104, 0xffe8bf05, 0xffe7bd06, 0xffe5c206, 0xffddc906, 0xffdbc905, 0xffdbbf04, 0xffdaba05, 0xffd7b402, 0xffd5b701, 0xffd1b901, 0xffcfb601, 0xffd0b101, 0xffd0ab02, 0xffcead00, 0xffcdad00, 0xffccac01, 0xffcbab02, 0xffccaa00, 0xffc8a704, 0xff877c44, 0xff6e6a5e, 0xff6c6964, 0xff787155, 0xff86794d, 0xff8c7c4b, 0xff91804a, 0xff988445, 0xffaf9330, 0xffbd9c29, 0xffcba71d, 0xffd0aa1b, 0xffdbaf1b, 0xffdfb314, 0xffeabd0a, 0xffecc305, 0xffedc605, 0xffeec604, 0xffedc202, 0xffecc101, 0xffeac902, 0xffe6cb00, 0xffdfca01, 0xffdfc401, 0xffdcb500, 0xffd9b401, 0xffd5b900, 0xffd2ba00, 0xffd0b601, 0xffd1b401, 0xffcbab00, 0xffcca903, 0xffccaa02, 0xffcaa904, 0xff978636, 0xff767056, 0xff6b6b63, 0xff6c6c62, 0xff6f6d5e, 0xff7a7357, 0xff817954, 0xff8b7f4d, 0xff8e814a, 0xff9d8940, 0xffa6903a, 0xffbf9f28, 0xffcaa520, 0xffd1aa1e, 0xffd3ad1c, 0xffe2b60f, 0xffe6bd0d, 0xffebc606, 0xffeac602, 0xffeec305, 0xffedc001, 0xffeac400, 0xffe9ca00, 0xffe1cc03, 0xffe1c701, 0xffddbb01, 0xffd9b700, 0xffd7b702, 0xffd6ba01, 0xffd1b702, 0xffd1b400, 0xffceac02, 0xffccac00, 0xffcea900, 0xffcba802, 0xff9e8b2d, 0xff797353, 0xffa9ad32, 0xffbfc026, 0xffc7c41f, 0xffcfc71e, 0xffd3c719, 0xffded00f, 0xffe6d70a, 0xfff0e406, 0xfff4e705, 0xfff7ea06, 0xfff7eb01, 0xfff9eb02, 0xfff8eb00, 0xffe8ce00, 0xffe0bf00, 0xffdbb401, 0xffd7b901, 0xffd3b902, 0xffd1b700, 0xffd1b200, 0xffcfb000, 0xffaa9321, 0xff7f784e, 0xffdae50f, 0xffeaed0a, 0xffecee05, 0xffeff205, 0xfff1f105, 0xfff5f203, 0xfff5f501, 0xfff6fb01, 0xfff6fc00, 0xfff7fc02, 0xfff7fc00, 0xfff5fa00, 0xffdecc00, 0xffd4b701, 0xffcdad04, 0xffcba900, 0xffcaaa00, 0xffac961f, 0xff80794b, 0xfff0f902, 0xfff4fe00, 0xfff4ff00, 0xfff3fe00, 0xfff5ff01, 0xfff5ff00, 0xfff3fc01, 0xffe0d102, 0xffd3b602, 0xffad971d, 0xff83784a, 0xffebf500, 0xffe1d602, 0xffb0981c, 0xff857947, 0xffdbe508, 0xfff4fd02, 0xffe4df01, 0xffd5bd01, 0xffb69b16, 0xff90813c, 0xff666867, 0xffced513, 0xfff1fc02, 0xfff4ff01, 0xfff7fe00, 0xffe8e301, 0xffd4c001, 0xffbb9e12, 0xff978634, 0xffa6ab33, 0xffede806, 0xffead40f, 0xffe9ca18, 0xfff0d60d, 0xfff3e803, 0xfff4ee04, 0xfff4f406, 0xfff3f305, 0xfff3f609, 0xfff1f606, 0xfff4fb00, 0xffecea01, 0xffd9c502, 0xffc2a30b, 0xffa58f29, 0xff979a43, 0xffe2ce15, 0xffd98d2b, 0xffdb6b45, 0xffeb832e, 0xfff39b1d, 0xfff2ae1f, 0xfff0b71f, 0xffedb927, 0xffebbd29, 0xffe2c424, 0xffefe20a, 0xfff4f504, 0xffecec00, 0xffdbc903, 0xffc3a509, 0xffaa9323, 0xff888d4b, 0xffddc01e, 0xffd96345, 0xffec0669, 0xfff1056a, 0xfff20867, 0xffee0b65, 0xffef0b6c, 0xffec0b71, 0xffe51271, 0xffdf176f, 0xffdb6c4e, 0xffe9c821, 0xffeff000, 0xffe2d401, 0xffc7a704, 0xffaf961f, 0xff8a8d4a, 0xffe4c711, 0xffe77830, 0xffef0568, 0xfff0006d, 0xfff2016c, 0xffee016d, 0xffee006f, 0xffef026e, 0xffeb026f, 0xffe2505d, 0xffedbb28, 0xffeff300, 0xffe4d903, 0xffcdac00, 0xffb09720, 0xff808250, 0xffe3d70f, 0xfff3a720, 0xfff00969, 0xfff0006b, 0xfff1006d, 0xfff1006b, 0xfff1016c, 0xffed4755, 0xfff4b721, 0xffeae100, 0xffb2991b, 0xff6b6c5e, 0xff787d54, 0xffdad613, 0xfff1b322, 0xfff00a6a, 0xffef006a, 0xfff24350, 0xfff4b01f, 0xfff3fa00, 0xffb79b14, 0xff716e5b, 0xff706f5d, 0xffcfcb21, 0xffe5b62a, 0xffe80d71, 0xffee036c, 0xffee2e55, 0xffed862a, 0xfff2f601, 0xffd0b202, 0xffc0a011, 0xff6d6d63, 0xffc8ca21, 0xffdcb92b, 0xffe4136e, 0xffee026e, 0xffe61e5f, 0xffde693d, 0xfff1f403, 0xffeeee00, 0xffc2a30d, 0xff7d754e, 0xffc6c51f, 0xffe4c714, 0xffea2656, 0xffe31371, 0xffda5661, 0xfff0f409, 0xfff1f103, 0xffd3b900, 0xffc6a605, 0xff82774a, 0xffbdc122, 0xffe4d20e, 0xffef344f, 0xffef0868, 0xffe90d71, 0xffe54d64, 0xfff1f309, 0xfff1f502, 0xffd4bb00, 0xffcba901, 0xffa9ad34, 0xffdbd714, 0xfff14553, 0xffef0c68, 0xffec4650, 0xfff4f305, 0xfff3f700, 0xffcaaa01, 0xff857949, 0xff9da23e, 0xffd4d319, 0xffec465a, 0xffee0c6e, 0xfff20965, 0xfff14050, 0xfff1ee03, 0xfff3f903, 0xffd9c200, 0xffceae01, 0xffc7a802, 0xff877c46, 0xff6c6c60, 0xff8e8f49, 0xffd9565c, 0xffe1156e, 0xfff20668, 0xffed2a54, 0xfff1d60b, 0xfff2f804, 0xffdcc900, 0xffc9a803, 0xff958537, 0xff747057, 0xff8a8c4b, 0xffc6c81f, 0xffda6448, 0xffe41c65, 0xfff0036b, 0xffe71c5e, 0xffebc816, 0xffdfcf00, 0xffd2b501, 0xff9b8a30, 0xff787154, 0xff85894e, 0xffef911f, 0xffef354d, 0xffe41472, 0xffe5c22a, 0xfff3f307, 0xffe3d800, 0xffa99421, 0xff80774c, 0xff686669, 0xff80834e, 0xffb3bb28, 0xfff1a81e, 0xffe90e72, 0xffe9bd29, 0xfff4f207, 0xffe7dd01, 0xffd6bd01, 0xffac961e, 0xff83784b, 0xff72755a, 0xff9fa13c, 0xffebb426, 0xffeb4859, 0xffee0a6b, 0xfff3b522, 0xfff5f207, 0xffe8e600, 0xffd8c101, 0xffb0981e, 0xff84794b, 0xff716f60, 0xff959346, 0xffe6b528, 0xffe04c62, 0xffed016d, 0xfff10a68, 0xfff4ab1e, 0xfff5ed04, 0xffebe901, 0xffd8c500, 0xffcea902, 0xffb1971e, 0xff6b6d62, 0xff8b8e4b, 0xffdebe1e, 0xffd96347, 0xffef046d, 0xfff0006f, 0xfff1076a, 0xffe9832e, 0xfff1d80c, 0xffecef00, 0xffdecd01, 0xff8e803f, 0xff676863, 0xff8a8a4a, 0xffe3c612, 0xffe87830, 0xfff0056a, 0xffec036e, 0xffdd6c44, 0xffe9cc19, 0xffedf001, 0xffe0d200, 0xffb99e13, 0xff696a62, 0xff818351, 0xffe1d811, 0xfff2a821, 0xffef0969, 0xfff10067, 0xffdf5062, 0xffe7bf2a, 0xfff1f500, 0xffe5dc01, 0xffc0a30a, 0xffa28f28, 0xff7a7c55, 0xffdbd817, 0xfff1b324, 0xffef0b6a, 0xfff1016e, 0xfff10170, 0xffe84b60, 0xfff3f702, 0xffe7e202, 0xffc3a507, 0xffa99323, 0xff6d6f61, 0xffcecc21, 0xffe8b42a, 0xffe70f72, 0xffef0170, 0xfff2006e, 0xfff14750, 0xfff2b71f, 0xffeae800, 0xffcdab03, 0xffc8a606, 0xffc8c923, 0xffdfb82c, 0xffe5136e, 0xffee0270, 0xfff3414f, 0xfff4ac1c, 0xfff4fa02, 0xffebe900, 0xff6b6c64, 0xffc4c61d, 0xffe5c613, 0xffe82658, 0xffef0469, 0xfff10069, 0xfff1006f, 0xffec2b58, 0xffeeef00, 0xff6a6a60, 0xff6a6b63, 0xffbfc122, 0xffe7d00e, 0xfff0334f, 0xfff10768, 0xffe51e63, 0xffde6a43, 0xfff1f604, 0xffeef200, 0xffb69b18, 0xff706d5c, 0xff686964, 0xffa9ad35, 0xffdcd817, 0xfff04653, 0xffe70f70, 0xffe24d60, 0xfff2f800, 0xffbea00c, 0xff787250, 0xff686667, 0xff9fa13e, 0xffd4d21b, 0xffeb4958, 0xffec0c6c, 0xffef026c, 0xffed0d6e, 0xffea465e, 0xffd8bf02, 0xff7c744f, 0xff8e9248, 0xffd9565b, 0xffe3126e, 0xfff00b68, 0xffef454e, 0xffd8c401, 0xffcfaf02, 0xffc7a707, 0xff80784a, 0xff898e4b, 0xffc6c721, 0xffd86644, 0xffe41a64, 0xffee016b, 0xffed026b, 0xffed0968, 0xffed3e4d, 0xfff5ed06, 0xffdcc901, 0xffd1b202, 0xff88884c, 0xffbfc120, 0xffed9122, 0xffee3350, 0xffe80066, 0xffe40064, 0xffdb0162, 0xffd60062, 0xffc70158, 0xffc00056, 0xffb10750, 0xffba283d, 0xffead605, 0xfff2f802, 0xffe1d300, 0xff827a49, 0xff81844f, 0xffb5ba28, 0xffeead1f, 0xffe4454a, 0xffd1045f, 0xffc60159, 0xffb80153, 0xffb20054, 0xffa7014d, 0xffa5004d, 0xff9d0349, 0xffa61a3d, 0xffe4c90a, 0xfff2f603, 0xff887e41, 0xff75755d, 0xffeee50a, 0xffe7c21b, 0xffba6433, 0xffae3c3b, 0xff9e0e49, 0xff9c0548, 0xff98004d, 0xff980049, 0xff98014e, 0xff98104e, 0xffd7be1b, 0xfff0f304, 0xffe7df02, 0xffcaa705, 0xff9e8b2c, 0xff666865, 0xff6e7160, 0xff939645, 0xfff0f505, 0xfff3f108, 0xffdcc112, 0xffd19a1b, 0xffb44436, 0xffa92942, 0xff9c074b, 0xff96044b, 0xff9b0c4e, 0xffd7ba18, 0xffe8e500, 0xffd7c002, 0xffad9420, 0xff6a6c61, 0xffecf504, 0xfff3fd00, 0xfff0ec04, 0xffe7d40c, 0xffc88d25, 0xffb45f36, 0xffa01f46, 0xffa01745, 0xffdaa615, 0xffefeb03, 0xffebeb01, 0xffdac701, 0xffccab00, 0xffcda800, 0xffcbaa00, 0xffc1a40b, 0xff6a6c5f, 0xff8a8d48, 0xffe9f306, 0xfff7fe01, 0xfff3ff00, 0xffe7dd0a, 0xffdcc118, 0xffba6b33, 0xffb34a37, 0xffdca610, 0xffede600, 0xffebee00, 0xffddcc02, 0xffc7a706, 0xffc1a307, 0xff7f8150, 0xffdfe511, 0xfff1fa03, 0xfff5fe03, 0xfff6fd00, 0xfff0f503, 0xffeeea03, 0xfff3f402, 0xffe3d500, 0xffc1a30d, 0xffba9f14, 0xff8a7f41, 0xff82764c, 0xff666863, 0xff74775a, 0xffc2ca1d, 0xffe0ea0d, 0xfff5ff02, 0xfff6fc04, 0xffe6dc01, 0xffcaa902, 0xffc8a805, 0xffc2a30a, 0xffb69917, 0xffb09719, 0xffa48e29, 0xff9a8534, 0xff847a47, 0xff807849, 0xff756f57, 0xff686866, 0xff767758, 0xff888a4b, 0xffbfc525, 0xffd7e111, 0xfff0fa03, 0xfff2f900, 0xffc9a707, 0xffc4a30a, 0xffbba110, 0xffb0961b, 0xffae951f, 0xff998731, 0xff8d803c, 0xff81794b, 0xff7d7550, 0xff726c5c, 0xff686762, 0xff6d6d61, 0xff8c8d47, 0xffa7ab32, 0xffe8f206, 0xffeae704, 0xffcbaa03, 0xffc9a602, 0xffb69b1a, 0xffa79124, 0xff958935, 0xff857b46, 0xff767154, 0xff6b6863, 0xff676769, 0xff696a65, 0xff7c7d51, 0xff919443, 0xffc9d01e, 0xffdfe90c, 0xfff2fb02, 0xffd0b300, 0xffc5a409, 0xffbfa10d, 0xff9b8b33, 0xff8f823e, 0xff6c6a5e, 0xff696a64, 0xff70725c, 0xff979a41, 0xffe3eb0a, 0xffedf703, 0xffeded00, 0xffd2b502, 0xffc9aa04, 0xffb89c15, 0xffb1981a, 0xffa89222, 0xff877b47, 0xff827749, 0xff787353, 0xff706d5a, 0xff69695f, 0xff656762, 0xff67656a, 0xff87884e, 0xffa0a338, 0xffd4dc15, 0xffe4f00a, 0xfff2fd01, 0xffeff201, 0xffd4ba03, 0xffc5a40b, 0xffbea00e, 0xffb1971c, 0xff9f8b2c, 0xff8f823c, 0xff7e774d, 0xff736e5a, 0xff686961, 0xff666762, 0xff787758, 0xff9fa539, 0xffc0c425, 0xffe7f107, 0xffedf104, 0xffd5bd03, 0xffccae02, 0xffc4a606, 0xffb89c14, 0xffb4981b, 0xffa89223, 0xff9f8a2d, 0xff867a46, 0xff81794a, 0xff787355, 0xff65666a, 0xff6e6f5f, 0xff909346, 0xffa8ac31, 0xffb5a51c, 0xffae981e, 0xffa08e2a, 0xff948437, 0xff746f5b, 0xff7a7c54, 0xff857e4a, 0xff756f59, 0xff656661]
				); 
        }
		public function box22():BitmapData{  
             return BitmapPatternBuilder.build( 
			 [
    [0,1,2,3,4,5,2,6,5,5,7,8,8,5,5,9,5,2,5,7,5,5,6,5,2,5,5,5,5,5,5,5,5,5,5,8,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5], 
    [9,5,6,5,5,10,5,11,5,4,4,5,5,5,5,1,9,5,5,1,1,5,5,5,5,4,4,9,5,5,5,6,5,2,2,5,5,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5], 
    [5,5,12,13,14,15,16,17,18,19,19,20,5,6,6,5,2,4,4,5,2,5,5,9,9,2,5,5,5,4,5,5,6,6,5,5,5,2,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5], 
    [2,5,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,38,39,15,40,13,5,5,5,6,5,5,5,2,5,5,5,5,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5], 
    [2,5,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,29,58,59,60,61,62,63,64,64,64,65,15,40,16,66,5,5,5,9,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5], 
    [4,12,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,56,57,99,100,101,102,103,40,19,9,9,6,66,6,5,5,2,5,5,2,5,0,5,5,5,5,5,5,5,5], 
    [12,6,104,105,106,107,107,108,109,73,110,111,112,113,113,113,114,113,113,115,76,116,117,118,119,120,121,84,122,123,124,125,126,127,128,129,130,131,132,133,134,135,136,18,6,2,5,137,4,2,2,6,4,6,6,6,5,5,5,5,5,5,5,5], 
    [2,138,139,140,141,142,142,143,143,144,71,145,146,147,148,149,114,113,112,150,150,151,112,112,112,152,152,153,149,114,149,114,113,113,113,77,76,154,78,120,155,156,157,158,159,160,161,17,162,5,5,5,6,5,5,5,5,5,5,5,5,5,5,5], 
    [1,21,163,164,165,166,167,142,168,142,143,169,170,171,172,148,152,149,149,150,113,149,149,114,114,114,150,112,112,151,112,152,114,151,151,149,152,152,152,173,173,120,174,175,176,177,178,179,180,19,12,1,2,0,0,6,6,5,5,5,5,5,5,5], 
    [66,181,182,183,184,185,142,166,142,167,166,168,168,186,187,188,189,190,148,114,113,149,149,151,113,151,151,150,150,152,151,149,153,150,114,149,114,151,149,191,152,114,113,113,76,192,193,194,195,196,58,35,180,197,66,2,5,6,6,5,5,5,5,5], 
    [66,198,199,200,201,202,203,107,142,142,142,142,166,167,167,204,205,146,206,207,208,209,209,112,152,114,114,153,153,113,113,150,151,151,112,113,114,173,149,150,114,114,112,112,151,114,210,211,212,213,214,215,216,217,180,19,5,5,5,5,5,5,5,5], 
    [218,219,220,221,222,223,224,225,226,227,166,168,167,167,166,107,166,70,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,76,244,243,245,75,243,243,209,209,113,114,113,149,152,151,243,210,121,246,90,247,248,249,250,65,66,5,5,5,5], 
    [251,252,253,254,255,256,257,258,259,260,261,166,166,107,166,168,166,107,262,263,264,265,266,267,268,269,270,271,272,273,274,275,276,277,278,279,280,281,282,239,283,284,285,115,115,113,113,286,209,75,75,75,244,287,288,289,290,291,292,293,65,8,6,1], 
    [294,295,296,297,298,299,300,301,302,303,304,305,306,307,107,167,308,107,309,310,311,312,313,312,312,314,314,315,315,316,316,317,317,318,318,319,320,321,322,265,266,267,323,324,269,325,326,327,328,329,275,330,331,332,333,280,334,335,336,337,338,339,340,341], 
    [5,342,343,344,345,346,347,348,349,350,351,352,353,354,355,107,166,356,357,358,359,360,360,360,360,360,360,312,312,360,360,361,360,360,314,362,362,363,316,364,365,359,366,317,367,368,369,370,322,371,372,373,374,375,376,377,378,379,380,381,382,383,384,385], 
    [386,387,388,389,390,391,392,393,394,348,395,396,397,398,399,400,401,402,403,404,316,314,314,360,360,360,360,360,312,360,360,360,360,405,405,405,406,314,314,405,405,405,314,360,360,314,405,405,314,405,312,407,408,362,312,409,410,316,366,366,317,411,412,413], 
    [20,182,414,389,415,416,417,394,418,419,419,420,421,422,423,424,425,261,426,427,411,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,314,360,312,428,101], 
    [429,430,431,432,433,434,435,419,419,419,419,419,435,436,437,438,439,203,440,320,314,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,361,441,442], 
    [4,443,444,445,446,447,435,419,419,419,419,448,394,449,436,450,451,309,452,453,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,454,455,456], 
    [457,458,459,460,461,462,418,419,419,463,419,464,419,465,465,466,467,468,469,470,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,471,472,473], 
    [19,474,475,476,477,478,418,419,419,463,435,394,479,348,480,481,482,483,484,470,485,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,312,428,486,38], 
    [138,487,488,489,490,419,419,419,419,419,419,394,435,491,492,493,494,495,496,316,497,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,498,499,500,501,502], 
    [503,504,505,506,507,419,419,419,419,419,419,418,435,465,508,509,510,511,512,362,407,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,312,513,514,515], 
    [516,517,518,519,520,419,419,419,419,419,419,419,394,465,521,522,523,524,525,315,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,312,472,526,12], 
    [527,528,529,530,531,419,419,419,419,419,419,435,418,465,532,533,534,535,536,315,498,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,537,538,539,9], 
    [527,540,541,542,543,419,419,419,419,419,419,393,435,544,545,546,547,548,549,314,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,312,550,551,66], 
    [104,552,553,554,555,419,419,419,419,419,419,556,393,478,555,557,558,559,560,314,314,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,537,361,561,562,5], 
    [563,564,565,566,567,419,419,419,419,419,419,568,435,569,570,571,483,512,369,312,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,572,573,574,5], 
    [575,576,577,578,579,419,419,419,419,419,419,435,394,580,581,582,583,584,319,360,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,312,428,585,586,5], 
    [587,588,589,590,591,419,419,419,419,419,419,435,418,532,592,593,357,594,359,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,361,595,596,597,2], 
    [598,599,600,601,602,419,419,419,419,419,419,435,435,603,604,534,605,606,359,360,485,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,607,608,609,610,2], 
    [611,612,613,614,615,419,419,419,419,419,419,463,436,616,617,618,619,620,366,360,406,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,621,622,623,12,5], 
    [624,625,626,627,628,419,419,419,419,419,419,394,417,629,630,631,632,633,634,312,312,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,635,636,136,251,137], 
    [637,638,639,640,544,419,419,419,419,419,419,419,417,641,642,643,440,644,314,360,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,428,645,15,5,5], 
    [646,647,648,649,348,419,419,419,419,419,419,491,393,650,651,652,653,311,405,360,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,654,655,15,5,6], 
    [656,657,658,659,464,419,419,419,419,419,419,419,480,660,661,662,663,366,405,406,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,664,665,18,6,5], 
    [666,667,668,602,419,419,419,419,419,419,419,419,669,670,671,672,673,366,405,406,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,472,674,19,5,5], 
    [675,676,677,678,348,419,435,435,419,394,394,435,679,680,681,682,683,634,314,406,361,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,314,360,485,312,684,685,5,2,6], 
    [686,687,688,689,393,394,394,435,435,435,435,393,690,691,692,693,512,362,312,405,312,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,314,360,405,607,694,695,6,5,6], 
    [696,557,697,478,698,464,699,419,419,419,419,435,700,701,702,524,703,312,312,405,312,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,405,704,705,706,5,6,2], 
    [707,708,709,710,711,712,713,714,714,698,435,699,715,716,593,717,310,405,314,360,312,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,314,572,718,719,5,5,2], 
    [356,720,721,722,723,724,725,726,727,728,729,730,731,732,733,734,549,405,314,360,312,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,405,405,360,312,428,685,38,5,5,5], 
    [168,261,735,736,737,738,739,740,741,742,743,744,745,746,747,748,371,405,314,360,361,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,405,405,360,312,595,749,750,5,2,4], 
    [167,142,107,751,752,753,754,755,756,757,758,759,760,761,357,762,763,360,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,314,405,405,704,764,765,766,9,6,5], 
    [767,185,166,402,631,768,769,770,771,772,773,774,775,776,652,777,320,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,314,314,778,779,574,780,9,66,9], 
    [781,782,783,142,167,784,785,786,787,788,758,789,790,791,652,310,792,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,428,538,39,6,5,5,6], 
    [793,794,795,167,168,402,796,797,798,799,800,801,802,803,605,804,792,405,405,406,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,314,405,405,360,805,645,502,6,5,5,6], 
    [806,807,808,809,707,810,166,796,811,812,813,814,815,816,817,371,410,406,314,360,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,408,312,312,455,818,819,6,5,66,9], 
    [138,820,807,821,822,168,167,823,824,825,826,827,828,829,830,831,315,405,406,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,499,360,314,832,833,17,5,2,2,6], 
    [5,457,834,487,835,836,107,837,107,838,839,840,841,483,842,843,315,405,406,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,360,312,844,845,5,2,5,5,5], 
    [6,251,846,847,848,849,850,168,107,356,851,852,853,357,854,855,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,498,312,856,857,5,2,5,5,5], 
    [218,12,5,846,858,859,860,184,107,168,142,107,107,861,862,470,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,312,360,360,863,864,865,6,5,5,5,6], 
    [2,6,866,294,846,220,867,69,355,166,868,810,185,869,484,316,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,312,360,360,870,871,872,0,5,5,5,6], 
    [5,5,5,5,5,13,873,874,875,107,167,166,167,632,876,312,405,405,405,405,405,360,360,360,360,360,360,405,405,405,405,405,360,360,360,360,360,360,360,360,360,537,537,405,405,405,405,405,405,405,405,405,360,405,360,360,877,878,879,5,5,5,5,5], 
    [5,5,5,5,5,66,880,881,882,883,107,142,166,884,885,886,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,314,314,314,314,314,360,312,312,314,314,405,360,314,887,888,14,5,5,5,5,5], 
    [5,5,5,5,5,2,6,503,889,890,891,107,107,653,892,405,360,360,360,360,360,314,314,314,314,314,314,405,405,405,405,405,405,405,405,405,405,405,405,406,405,405,405,405,405,405,405,405,405,405,405,405,405,485,360,863,893,894,895,5,5,5,5,5], 
    [5,5,5,5,5,2,5,2,597,896,897,141,898,899,900,314,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,405,360,360,360,360,360,405,405,537,537,405,405,405,405,405,405,405,405,405,405,405,405,312,360,901,902,872,40,5,5,5,5,5], 
    [5,5,5,5,5,8,5,5,5,903,904,905,906,673,907,312,360,360,360,360,360,405,405,405,405,405,405,405,405,360,360,360,312,312,312,312,312,312,314,314,312,361,607,537,537,537,537,537,361,454,908,572,572,909,909,910,911,912,19,5,5,5,5,5], 
    [5,5,5,5,5,6,137,5,7,8,913,914,915,916,917,314,607,607,607,607,607,901,901,901,901,901,901,572,471,471,471,887,428,428,428,428,428,428,918,471,918,595,595,441,441,441,441,441,919,920,921,922,832,922,832,472,923,610,6,5,5,5,5,5], 
    [5,5,5,5,5,5,5,5,5,5,5,913,163,924,925,926,927,926,926,928,929,930,930,931,931,930,930,932,933,685,685,934,888,888,888,888,888,888,685,888,888,551,551,442,442,442,442,442,935,936,937,938,937,939,940,941,942,943,5,5,5,5,5,5], 
    [5,5,5,5,5,5,5,5,5,5,5,12,944,945,946,935,442,947,442,442,948,939,939,939,939,939,939,949,879,502,502,39,502,502,502,502,502,502,502,502,502,502,15,15,15,15,15,15,610,40,457,138,13,766,138,18,19,5,66,5,5,5,5,5], 
    [5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,2,6,5,5,5,5,5,5,5,5,5,4,4,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,5,2,137,5,4,2,5,6,5,5,5,5,5,5], 
    [5,5,5,5,5,5,5,5,5,5,5,2,5,2,2,66,5,5,5,9,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,2,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,6,9,9,5,137,5,5,5,5,5], 
    [5,5,5,5,5,5,5,5,5,5,5,5,950,6,4,6,6,137,2,2,2,2,2,5,5,5,5,6,5,5,4,12,5,5,5,5,5,2,5,6,5,5,5,5,5,5,5,5,5,2,5,5,2,950,9,5,5,9,6,5,5,5,5,5]
],
[0xff656764, 0xff676568, 0xff666668, 0xff646663, 0xff656766, 0xff666666, 0xff666664, 0xff656565, 0xff676767, 0xff676566, 0xff656661, 0xff656563, 0xff676765, 0xff696864, 0xff6b6b63, 0xff6c6962, 0xff6b6764, 0xff686762, 0xff686763, 0xff686765, 0xff686667, 0xff696a64, 0xff989840, 0xffb0aa2e, 0xffb4a02f, 0xffac9631, 0xff9f893e, 0xff988543, 0xff928247, 0xff907f47, 0xff8d7d49, 0xff897b4a, 0xff857951, 0xff807653, 0xff787157, 0xff746f5b, 0xff6e6c60, 0xff6e6b62, 0xff6d6b5f, 0xff6c6a5e, 0xff696863, 0xff6c6c62, 0xffb4b929, 0xffd7d812, 0xffe1cf0d, 0xffddc410, 0xffd7b219, 0xffd3ad1e, 0xffcfa81d, 0xffcea71e, 0xffc9a221, 0xffc29e23, 0xffb8992d, 0xffb09431, 0xffa38d38, 0xff9c8843, 0xff948147, 0xff918048, 0xff8e7e4a, 0xff877a4e, 0xff837751, 0xff7c7356, 0xff777159, 0xff706c61, 0xff6f6b60, 0xff6d6a61, 0xff676664, 0xff6d6f61, 0xffc7ce1e, 0xffeaf306, 0xfff5fc00, 0xfff7f900, 0xfff9e900, 0xfff9e000, 0xfffdce02, 0xfffdc702, 0xfffdc401, 0xfffec401, 0xfffac402, 0xfffbc203, 0xfff7c105, 0xfff8c206, 0xfff4c008, 0xfff3bf07, 0xfff1bd07, 0xfff0bb09, 0xffe8b80c, 0xffe6b60e, 0xffdeb215, 0xffdbaf18, 0xffd3aa1e, 0xffcfa81f, 0xffcba520, 0xffc8a31f, 0xffc09d25, 0xffba9a2b, 0xffad8f35, 0xffa38d3a, 0xff988445, 0xff8f8049, 0xff897d4d, 0xff867a4a, 0xff7a7359, 0xff706d5e, 0xff6e6f61, 0xffcad11f, 0xffecf506, 0xfff4fe00, 0xfff4f801, 0xfff5f302, 0xfffbd700, 0xfffdca00, 0xffffc700, 0xfffec601, 0xffffc501, 0xfffdc500, 0xfffdc403, 0xfffac304, 0xfff9c205, 0xfff7c204, 0xfff6c004, 0xfff5bf05, 0xfff0bc08, 0xffebb90a, 0xffe8b80e, 0xffe0b214, 0xffdbb016, 0xffd4ab1d, 0xffd1aa1f, 0xffcda61d, 0xffcba51e, 0xffc29f27, 0xffbd9c28, 0xffa58c3a, 0xff958146, 0xff797256, 0xff6f6d5e, 0xff656668, 0xff686963, 0xff75755b, 0xffd1d819, 0xffeef804, 0xfff5ff01, 0xfff7fe00, 0xfff7fc02, 0xfffbe901, 0xfffcde00, 0xfffece00, 0xfffec901, 0xffffc602, 0xffffc500, 0xfffec600, 0xffffc702, 0xffffc600, 0xfffec504, 0xfff3bd05, 0xffd9ad18, 0xffcba421, 0xffa28b3b, 0xff908148, 0xff787059, 0xff726b61, 0xff696564, 0xff7a7a56, 0xffd6df16, 0xffeff904, 0xfff5ff00, 0xfff4ff00, 0xfff4ff01, 0xfff7f700, 0xfffaf100, 0xfffbdd00, 0xfffdd501, 0xfffec502, 0xffefbd08, 0xffdaae1a, 0xffcaa523, 0xffa28b3d, 0xff937f4a, 0xff75705a, 0xff6e6c5f, 0xff6b6d62, 0xff86874e, 0xffe2ea0d, 0xfff2fb00, 0xfff7fe01, 0xfff6fb01, 0xfff7f701, 0xfffae800, 0xfffddc01, 0xfffdcf00, 0xffffc603, 0xfff6c006, 0xffefbc09, 0xffd5ab19, 0xffc5a224, 0xff9f873d, 0xff6a6663, 0xff6c6c60, 0xff8a8b49, 0xffe5ee0b, 0xfff1fa00, 0xfff5f602, 0xfff3f901, 0xfff8f800, 0xfff9f000, 0xfffed403, 0xfffdca01, 0xfffcc900, 0xfffdc800, 0xfffbc503, 0xfff7c004, 0xffeebb08, 0xffd6ac18, 0xffc4a121, 0xff9a8641, 0xff8b7d4e, 0xff716e5d, 0xff646665, 0xff6d6d61, 0xff8d8e48, 0xffe8ee08, 0xfff1e107, 0xffee872b, 0xfff18f2a, 0xfff4d812, 0xfff3ef0a, 0xfff4fd02, 0xfff5f500, 0xffe8d902, 0xffe1cf01, 0xffe4ca01, 0xffe6cb00, 0xffedc700, 0xffeec400, 0xffefc000, 0xfff2c200, 0xfff4c601, 0xfff3c702, 0xfff2cb01, 0xfff2cc00, 0xfff7cd00, 0xfff9cc00, 0xfffcc601, 0xfffbc501, 0xfffcc602, 0xffecba0b, 0xffc39f25, 0xff998642, 0xff877a4d, 0xff736d5f, 0xff666762, 0xff6c6e60, 0xff8e9047, 0xffe7ec09, 0xffedd012, 0xffec434a, 0xffee3e55, 0xffef9036, 0xffedbb24, 0xfff3f108, 0xfff4fa02, 0xfff3fa00, 0xffdecf00, 0xffd4c000, 0xffd2ba00, 0xffd4bb00, 0xffd8b900, 0xffd9b500, 0xffdcb500, 0xffdeb702, 0xffdfc101, 0xffe0c401, 0xffe1ca02, 0xffe2cb01, 0xffe7cc01, 0xffebca01, 0xffeec201, 0xfff0bf01, 0xfff1c202, 0xfff1c502, 0xfff2c800, 0xfff4ca02, 0xfff5cc00, 0xfff9cc01, 0xfffacb01, 0xfffbc701, 0xfff6be05, 0xffedba09, 0xffcea91c, 0xffbb9c28, 0xff958345, 0xff887a4d, 0xff726c5e, 0xff676769, 0xff70725d, 0xff949746, 0xffeaea0e, 0xffe6bf26, 0xffe3196b, 0xffec056b, 0xffeb1168, 0xffe72468, 0xffe46f43, 0xffea9d27, 0xfff2e208, 0xfff3f400, 0xfff6fd02, 0xfff3ff00, 0xfff2f800, 0xffd8c101, 0xffcfaf02, 0xffcbab02, 0xffcaaa00, 0xffcbab00, 0xffcdab01, 0xffcdad02, 0xffceac02, 0xffd0ab02, 0xffd0b101, 0xffd0b300, 0xffd0b601, 0xffd2b801, 0xffd9b700, 0xffdbb401, 0xffdfbe01, 0xffe1c000, 0xffe0c600, 0xffdecb02, 0xffe2cd00, 0xffebc701, 0xffedc202, 0xfff0c101, 0xfff2c301, 0xfff0c602, 0xffe6c309, 0xffdfbf0c, 0xffc6ad1d, 0xffb4a12b, 0xff908146, 0xff817851, 0xff6b6b5f, 0xff76765c, 0xff9b9f41, 0xffebeb0f, 0xffe8b92b, 0xffe7156e, 0xffef036f, 0xffef026c, 0xffec0869, 0xffe6275d, 0xffea4645, 0xffefa220, 0xfff0cd0f, 0xfff4f503, 0xfff3fc01, 0xfff6fd00, 0xfff2f601, 0xffd7be01, 0xffceae01, 0xffccaa02, 0xffcaaa01, 0xffccac01, 0xffcdab03, 0xffccae00, 0xffcdaf01, 0xffcead00, 0xffcfae01, 0xffd1b200, 0xffd1b400, 0xffd0b800, 0xffd4ba01, 0xffd6ba01, 0xffd7b700, 0xffd9b403, 0xffdbb701, 0xffddba00, 0xffdfc300, 0xffdfc401, 0xffdfc902, 0xffdfc904, 0xffdfc307, 0xffd4bd0f, 0xffb9a022, 0xffa79030, 0xff7b7555, 0xff696566, 0xff7f8152, 0xffacb22e, 0xfff0eb0b, 0xffefb525, 0xffed116b, 0xfff10170, 0xfff1016c, 0xfff1006b, 0xffee036a, 0xffed175f, 0xffee2e57, 0xffec8934, 0xffeebb22, 0xfff0f208, 0xfff4fb00, 0xfff3fd00, 0xfff0f100, 0xffd3bb00, 0xffccaa00, 0xffcba900, 0xffcea900, 0xffcea902, 0xffccac00, 0xffcdae00, 0xffccac03, 0xffc6a50a, 0xff8a7e42, 0xffb7bd25, 0xfff4b122, 0xfff01068, 0xffef026e, 0xfff1006d, 0xfff0006d, 0xfff0036b, 0xffee0a6b, 0xffe93a59, 0xffe56750, 0xffecc61b, 0xfff2e80d, 0xffecef00, 0xffd4b703, 0xffc6a606, 0xff666865, 0xff8c8d49, 0xffc1c91e, 0xfff2dd0a, 0xfff29724, 0xffef0a65, 0xfff0006b, 0xffef026a, 0xfff1066d, 0xffec5449, 0xfff0b21f, 0xffeae800, 0xffc2a30a, 0xff80774c, 0xff8d8f46, 0xffc4ca1e, 0xffefd208, 0xffec8425, 0xffef0868, 0xffef006e, 0xffee0169, 0xfff04a4c, 0xfff3b021, 0xffeae600, 0xffd0b003, 0xffc9a801, 0xffbca00e, 0xff7c7450, 0xff676863, 0xff8f9347, 0xffcbcf20, 0xffe5bf1e, 0xffdc6044, 0xffec046a, 0xfff0006f, 0xffee016b, 0xfff1016e, 0xffe54f5b, 0xffeeb729, 0xfff3f402, 0xffe8e003, 0xffceae03, 0xffc7a706, 0xffb2991a, 0xff6f6c5b, 0xff959744, 0xffced41c, 0xffe5bc26, 0xffdd5853, 0xffec036c, 0xfff1006f, 0xffee036c, 0xffe2555e, 0xffeaba28, 0xfff0f302, 0xffe5db00, 0xffccab00, 0xffae961c, 0xffa2a937, 0xffd6dd13, 0xffefb627, 0xffec4c58, 0xfff2006e, 0xffee0669, 0xffe06c3d, 0xffe9c916, 0xffeeec03, 0xffe1d102, 0xffceaa00, 0xffcca903, 0xffcbaa03, 0xffc5a409, 0xffaa9321, 0xff6c6960, 0xff6a6b63, 0xffabb231, 0xffdce210, 0xfff0b422, 0xffec4b50, 0xfff00967, 0xffeb862c, 0xfff0d610, 0xffecea01, 0xffddcc02, 0xffbfa10d, 0xffa28f29, 0xff69695f, 0xff6c6d5f, 0xffbec424, 0xffe6eb0a, 0xfff5a71f, 0xfff2444d, 0xfff00e64, 0xfff4ad21, 0xfff6eb05, 0xffeae601, 0xffd8c401, 0xff8e803f, 0xff6d6e60, 0xffc1c820, 0xffe8eb08, 0xfff49624, 0xfff13a4e, 0xffee1067, 0xfff2b423, 0xfff3ef07, 0xffe9e200, 0xffd7c000, 0xffcba901, 0xffae961a, 0xff887b44, 0xffc6cd1d, 0xffe7e909, 0xffe06b3f, 0xffe7215c, 0xffee026e, 0xffe6166e, 0xffe9bb2a, 0xfff2f008, 0xffe6d900, 0xffd5bc00, 0xffaa9323, 0xff83784a, 0xffcacf1d, 0xffe9e90d, 0xffda5e52, 0xffe31a68, 0xfff1026a, 0xffe6be21, 0xfff2f005, 0xffe4d500, 0xffd3b900, 0xffa68f27, 0xff7f764d, 0xff737659, 0xffd1d61a, 0xffece90e, 0xffe45163, 0xffe81274, 0xfff00169, 0xfff00965, 0xffef3252, 0xfff0d60d, 0xffc7a704, 0xff92813b, 0xff736f56, 0xff797b56, 0xffd6dd15, 0xffeeea0c, 0xffeb4d5c, 0xffec1070, 0xfff00c65, 0xfff23d4c, 0xfff3e307, 0xfff3f700, 0xffdac804, 0xff897c45, 0xff6e6c5d, 0xff83874c, 0xffe2e70e, 0xfff1e90c, 0xfff2474d, 0xffef0f67, 0xffea4c4d, 0xfff5ef07, 0xffd8c100, 0xffc5a407, 0xff81794a, 0xff6a6a60, 0xff898c49, 0xffe5ea09, 0xfff4e408, 0xfff1414c, 0xfff00d66, 0xffe9126d, 0xffe4515b, 0xfff1f502, 0xffd6bf00, 0xffcaa902, 0xffc2a30b, 0xff7e774d, 0xff6a6a62, 0xff8d9049, 0xffe7e90a, 0xffeecc12, 0xffe92a56, 0xfff00669, 0xffe41c65, 0xffda614c, 0xffeff107, 0xffeff000, 0xffd4ba03, 0xffc8a702, 0xffb79d15, 0xff766f5c, 0xff8d9147, 0xffe7e70b, 0xffe8c31d, 0xffe1205f, 0xffef046b, 0xffeb2258, 0xffe56f32, 0xfff1f103, 0xffeded01, 0xffd3b700, 0xffcdad00, 0xffc8a606, 0xffb0981a, 0xff999943, 0xffebe80f, 0xffe8b92d, 0xffe61571, 0xfff0414e, 0xfff4a222, 0xfff1f700, 0xffcfb101, 0xffab9420, 0xffa4a839, 0xffede90c, 0xffeeb62b, 0xffeb116f, 0xffee494f, 0xfff3ae22, 0xfff2f802, 0xffe8e600, 0xffc3a509, 0xffa89225, 0xffc1c71b, 0xffefea0a, 0xfff2b121, 0xffee0f68, 0xffe3515c, 0xffecb72b, 0xfff0f602, 0xffe7df00, 0xffb89c14, 0xff968537, 0xffd3da0e, 0xfff2e50a, 0xfff4a81f, 0xffed046d, 0xffdd585b, 0xffe8bb2c, 0xffeff300, 0xffe4d901, 0xff8d7f42, 0xffe5ef02, 0xffefd20a, 0xffef8227, 0xffef0a67, 0xffed0569, 0xffe46d35, 0xffedc60f, 0xffeded03, 0xffe0d001, 0xffac961e, 0xff847a49, 0xffebf403, 0xffecc510, 0xffe56c33, 0xffef076a, 0xffee0966, 0xfff08825, 0xfff3d70a, 0xffecea00, 0xffa99421, 0xff81794b, 0xfff2fc00, 0xffda5c50, 0xffed006a, 0xffee016d, 0xffee1065, 0xfff3af20, 0xfff3ec06, 0xffd8c403, 0xffc9a803, 0xff988831, 0xff777255, 0xfff3fe00, 0xffedc01d, 0xffde6248, 0xffe00561, 0xffe30262, 0xffe70068, 0xffe90069, 0xffec016a, 0xffec1067, 0xfff2b421, 0xffe8e301, 0xff8f803b, 0xff736e5b, 0xfff2ec04, 0xffe7c00d, 0xffbd4233, 0xffb31746, 0xffb00150, 0xffb10051, 0xffbb0054, 0xffc00055, 0xffc9015a, 0xffcd005b, 0xffd60362, 0xffd2185f, 0xffe5bc24, 0xfff1f008, 0xffe4db00, 0xfff0e903, 0xffcc831c, 0xffb64331, 0xff9e074e, 0xff9e024c, 0xffa3014d, 0xffa5004c, 0xffab004f, 0xffaf0050, 0xffb80354, 0xffbf1e48, 0xffe4c312, 0xfff2f101, 0xffe1d600, 0xff83784b, 0xff6a6a5e, 0xffefed05, 0xffe6ca0e, 0xffba5237, 0xffa62043, 0xff97044b, 0xff97014b, 0xff97004d, 0xff980049, 0xff9e0a46, 0xffb23835, 0xffeddf04, 0xffdccd02, 0xffd2b501, 0xffbba011, 0xff797351, 0xff696961, 0xfff4ff05, 0xffd29a1f, 0xffba5636, 0xff990849, 0xff970149, 0xff98004d, 0xff980148, 0xff9d0d48, 0xffb24236, 0xffeee701, 0xffd9c800, 0xffc8a807, 0xffb69b16, 0xff676862, 0xffd7db15, 0xffeffb03, 0xfff2fd01, 0xfff3f307, 0xffead40d, 0xffb95438, 0xffa61f47, 0xff980249, 0xff9b104b, 0xffb24b3c, 0xffefef05, 0xffceaf00, 0xffa6ab35, 0xffe2ed0b, 0xfff0fa03, 0xfff2f204, 0xffd49a1d, 0xffba5235, 0xff9c0749, 0xff99034b, 0xff9c1250, 0xffae5142, 0xffedef06, 0xffd7c002, 0xffc4a608, 0xff6d705f, 0xffa3a738, 0xffc8d11e, 0xfff1fb04, 0xfff5fe03, 0xffe7d40b, 0xffbb5839, 0xffa42447, 0xff9c1a48, 0xffb1573c, 0xffefee06, 0xfff0ef01, 0xffa08c2d, 0xff6b6863, 0xff828453, 0xffe4ec0b, 0xfff1fa01, 0xfff5fb03, 0xfff3f403, 0xffd4a424, 0xffb85d40, 0xffa42542, 0xffbb6125, 0xffefef03, 0xffeeed00, 0xffd1b700, 0xffb89c15, 0xff938638, 0xff6e6f5d, 0xffcad21d, 0xfff0fb00, 0xfff5ff02, 0xfff1f604, 0xffe4de10, 0xffca8c29, 0xffd7a214, 0xffece801, 0xffd0b202, 0xffaf971d, 0xff877a46, 0xff686964, 0xff828452, 0xffa8ab36, 0xffe9f307, 0xfff2fd03, 0xfff3f704, 0xffe7d215, 0xffeada0b, 0xffe9e601, 0xffcfb000, 0xffab9621, 0xff85784b, 0xff72715c, 0xffb1b42f, 0xffd5db17, 0xfff4f501, 0xffe8e001, 0xffcaa701, 0xffa18f2b, 0xff7d764c, 0xff656567, 0xffb2b62e, 0xfff6fe00, 0xfff1f200, 0xffc8a704, 0xff978636, 0xff777254, 0xff71735b, 0xffb1b82a, 0xffd8df13, 0xffe0d200, 0xffc7a408, 0xff887b46, 0xff6f6c5d, 0xff696a62, 0xff919244, 0xffbbbf2a, 0xffeef801, 0xffebeb01, 0xffddcc00, 0xffcdac00, 0xffc7a707, 0xff847a47, 0xff777954, 0xffbcc328, 0xffdce50e, 0xffd8c500, 0xffc1a20c, 0xff7e754e, 0xff6c6964, 0xff969942, 0xffbcc325, 0xfff3fc03, 0xffe8e400, 0xffd6c200, 0xffc9a805, 0xffbb9e12, 0xff6b6a65, 0xff787959, 0xffbdc524, 0xffdde70d, 0xffd6bd01, 0xffc8a903, 0xffc8a805, 0xffc1a40b, 0xffac961f, 0xff6d6b5e, 0xff6b6b61, 0xff999d3e, 0xffc0c523, 0xffddd103, 0xffd3b805, 0xffc6a605, 0xffc0a20c, 0xffbb9f10, 0xffb99e13, 0xffb79b14, 0xffa08c2b, 0xffa29930, 0xffa79726, 0xffa69124, 0xffa79227, 0xffa69128, 0xffa08e2c, 0xff958635, 0xff958537, 0xff8c823d, 0xff887e43, 0xff847a45, 0xff7f784c, 0xff797353, 0xff767154, 0xff757154, 0xff767056, 0xff757158, 0xff756f57, 0xff726c5c, 0xff666769, 0xff6a6c61, 0xff7c7853, 0xff7f7750, 0xff80784a, 0xff7d7550, 0xff716f5a, 0xff666465]
				); 
        }
		public function box23():BitmapData{  
             return BitmapPatternBuilder.build( 
			 [
    [0,0,0,0,0,0,0,0,1,0,0,2,3,4,5,0,6,1,0,0,7,0,0,0,4,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,0,0,0,0,0,8,9,10,11,12,13,2,14,0,15,6,6,1,1,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,4,16,17,18,19,20,21,22,23,24,0,0,0,0,0,4,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,1,0,0,25,26,27,28,29,30,31,32,33,34,35,36,37,38,24,0,0,1,1,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,1,0,0,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,5,7,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,4,4,0,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,24,79,80,7,1,3,4,4,0,0,1,0,81,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,4,7,1,82,83,84,85,86,61,87,88,89,90,91,92,92,93,94,95,96,97,98,99,100,101,102,103,104,105,0,5,1,0,14,14,7,7,106,0,15,15,15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,4,107,108,109,110,111,112,86,113,114,88,115,90,66,116,117,118,118,118,119,120,121,122,48,123,124,125,126,53,127,55,104,107,3,0,128,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,129,130,131,132,133,112,134,135,111,136,137,138,90,139,117,140,118,141,142,118,118,143,144,95,145,146,147,148,149,150,151,103,152,24,105,2,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,4,24,153,154,155,156,157,158,159,111,160,161,162,163,164,90,140,139,165,165,165,140,118,139,117,141,92,92,166,167,168,169,170,171,172,173,174,54,175,176,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,177,178,179,180,181,182,183,184,135,185,135,111,186,187,188,189,66,66,139,117,141,117,141,118,140,66,141,66,118,190,191,192,193,194,195,196,197,198,199,200,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,8,201,202,203,204,205,206,207,208,209,111,112,210,114,211,164,90,118,165,165,141,141,165,141,139,141,141,141,141,141,117,117,165,165,93,144,212,213,214,215,216,13,7,0,4,2,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,7,4,217,218,219,220,221,222,223,224,225,226,86,210,209,111,227,228,188,65,141,141,140,66,165,165,139,141,141,141,141,141,141,141,117,165,141,117,229,230,193,231,232,233,107,107,0,15,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,234,235,236,237,238,239,240,240,241,242,243,226,244,135,135,185,62,245,246,90,141,117,141,141,142,140,141,141,141,141,141,141,117,117,165,141,118,165,141,92,143,247,248,249,250,105,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,2,251,252,253,254,255,256,257,258,259,260,261,262,263,162,264,185,111,265,211,266,267,165,165,165,165,139,141,141,141,141,141,118,140,142,165,117,139,118,117,92,118,94,268,269,270,176,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,271,272,273,274,275,276,277,278,279,280,281,282,283,284,285,111,112,112,112,62,211,286,287,288,118,140,66,141,141,141,141,141,165,165,117,139,117,140,289,118,141,66,118,229,122,290,291,292,0,0,0,0,0,0,0,0,0,0,0], 
    [7,293,4,4,4,294,295,296,297,298,299,300,301,301,301,278,302,303,304,305,285,111,210,86,112,306,307,308,309,310,311,140,140,118,140,117,141,117,139,118,140,141,66,139,117,141,165,66,118,68,312,313,314,175,79,7,3,3,315,4,4,0,4,316], 
    [0,0,4,0,4,317,318,319,320,321,322,279,323,301,301,280,278,324,325,326,327,227,111,210,135,328,329,330,331,332,333,334,335,336,337,337,338,118,140,139,139,142,140,118,118,117,139,118,118,139,118,339,340,341,342,343,39,0,3,0,1,0,4,2], 
    [1,4,107,0,107,344,345,346,347,348,349,301,323,301,301,301,279,350,351,352,353,354,355,210,61,356,357,358,359,360,361,362,363,364,365,366,367,337,338,140,140,142,140,117,139,165,141,142,142,139,140,67,368,369,370,233,371,0,0,4,0,0,0,0], 
    [0,0,0,372,177,373,374,375,376,377,378,301,301,301,301,301,301,379,279,380,381,382,383,162,384,385,386,387,388,389,390,391,392,393,358,394,395,396,333,397,335,367,337,398,65,142,117,117,92,118,139,399,92,400,401,402,403,404,176,1,0,4,0,4], 
    [0,0,0,2,405,406,407,408,409,410,279,301,301,278,301,301,279,379,323,411,412,413,414,244,415,416,417,418,418,389,387,388,388,418,419,420,393,421,422,423,424,364,425,426,309,337,399,118,92,66,140,91,399,427,428,429,430,174,431,5,1,4,0,0], 
    [0,7,0,432,433,434,435,436,437,278,438,301,301,301,301,301,439,301,440,378,441,442,443,444,445,446,447,418,418,418,418,418,418,418,418,418,418,418,418,390,448,449,450,451,452,453,454,455,456,336,337,399,399,457,142,92,458,459,460,461,462,0,3,0], 
    [0,7,0,463,464,465,466,467,468,301,469,301,301,301,301,301,470,378,469,471,472,473,474,475,476,477,478,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,479,449,480,481,482,423,483,484,485,426,486,399,311,118,91,487,488,489,490,105,4,15], 
    [4,0,107,491,492,493,494,495,496,280,497,301,301,301,301,301,498,499,278,500,501,502,503,504,505,419,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,506,506,418,389,390,448,507,508,509,331,510,511,512,513,514,515,516,517,518,519,24], 
    [4,0,129,520,521,522,523,524,525,526,470,301,301,301,301,301,440,301,300,527,528,529,136,530,531,387,532,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,388,533,388,388,387,390,420,507,481,509,534,535,536,537,538,539,540,541,55], 
    [4,107,542,345,543,544,204,240,301,526,498,301,301,301,301,301,545,279,471,546,547,548,549,550,551,388,388,418,418,418,418,418,418,418,418,418,418,506,506,418,418,506,506,418,418,389,389,389,388,387,388,389,552,553,387,390,420,359,551,482,554,555,556,557], 
    [2,39,558,559,560,561,562,563,469,301,470,301,301,301,301,301,301,545,564,565,566,567,568,569,570,418,418,418,418,418,418,418,418,418,418,418,418,533,388,418,418,418,418,388,387,388,388,506,388,389,418,387,553,418,388,388,571,391,420,572,480,573,574,575], 
    [0,576,58,577,578,579,527,301,300,280,279,301,301,301,301,301,279,525,580,581,156,582,583,358,387,418,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,418,584,585,586], 
    [2,82,587,588,589,501,590,301,379,498,526,301,301,301,301,301,280,591,592,593,594,595,596,420,387,418,533,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,388,597,598,127], 
    [599,600,109,601,602,524,277,279,301,301,301,301,301,301,301,301,379,603,604,605,606,607,608,418,388,418,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,571,609,610,611,56], 
    [129,130,612,613,614,615,469,301,301,301,301,301,301,301,301,301,469,616,617,618,619,505,620,418,418,388,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,609,621,622,623,107], 
    [624,625,626,627,628,300,301,498,301,379,498,301,301,301,301,301,591,629,630,631,445,361,420,387,418,388,552,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,632,633,634,404,2], 
    [635,636,637,638,639,545,280,301,279,279,279,379,438,279,279,258,640,641,642,549,476,643,644,418,388,418,506,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,506,552,645,388,533,418,646,647,648,649,1], 
    [587,650,651,652,653,654,655,378,279,301,301,301,469,278,279,656,657,658,618,659,660,419,506,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,506,418,506,418,389,387,661,662,649,107,316], 
    [663,664,665,666,667,668,669,670,671,672,672,673,279,280,498,674,675,676,677,583,678,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,533,388,552,388,418,609,679,680,105,315,0], 
    [681,682,297,683,684,685,686,687,688,689,690,691,692,669,693,694,695,696,549,697,551,418,418,506,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,506,698,418,418,506,597,699,700,0,3,0], 
    [701,111,702,703,704,705,706,707,708,709,710,711,712,713,714,715,716,677,717,718,719,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,552,698,389,418,621,720,721,722,0,15,4], 
    [723,724,162,725,726,727,728,729,730,731,732,733,734,735,736,737,297,738,530,507,739,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,698,389,387,740,741,77,107,2,15,7], 
    [742,743,744,745,746,747,748,749,750,732,732,733,733,751,752,753,754,595,755,448,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,418,387,609,756,757,758,0,2,3,5], 
    [759,760,761,210,762,763,764,765,734,733,730,766,750,767,768,769,415,770,771,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,389,418,532,772,773,774,0,15,0,0,0], 
    [775,776,777,61,111,778,779,780,781,733,732,732,782,783,784,785,786,787,620,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,387,388,788,789,790,791,0,0,0,4,1], 
    [39,792,793,794,111,795,796,797,798,799,732,734,800,801,802,803,804,805,719,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,389,418,806,807,808,809,0,1,0,0,0], 
    [0,810,811,812,813,159,814,815,816,817,732,782,818,819,820,821,822,823,419,824,645,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,387,506,825,826,23,5,4,4,4,80,5], 
    [0,107,8,827,828,135,210,829,830,831,832,833,834,835,836,837,787,419,418,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,388,388,387,838,622,839,107,0,0,0,0,0,0], 
    [0,0,840,841,842,85,209,285,843,844,845,780,846,847,60,848,849,388,418,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,506,388,388,388,506,850,851,852,4,15,0,0,0,0,0], 
    [7,0,4,853,854,855,856,112,606,857,858,859,860,263,549,861,862,388,388,388,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,506,418,418,418,772,863,864,56,6,1,0,0,0,0,0], 
    [14,1,0,865,866,867,868,61,869,870,815,871,872,567,873,874,572,388,388,388,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,388,418,418,479,389,633,875,77,39,6,1,0,0,0,0,0], 
    [7,3,14,4,251,876,179,877,112,878,879,880,881,882,883,507,387,418,387,388,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,389,388,388,389,884,885,886,105,80,4,0,0,0,0,0,0], 
    [0,0,0,1,176,887,888,889,209,114,762,890,891,804,892,447,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,893,388,646,894,895,24,1,0,0,0,0,0,0,0], 
    [0,0,4,1,81,896,897,898,743,210,210,111,899,900,874,387,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,506,418,388,901,902,903,55,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,1,129,904,905,906,111,112,114,786,907,908,389,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,389,479,388,850,610,909,56,0,0,1,1,0,0,0,0,0], 
    [4,0,0,0,4,4,176,910,911,912,111,762,804,394,719,506,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,389,506,553,913,851,914,0,80,0,4,4,0,0,0,0,0], 
    [0,0,0,0,4,0,4,915,916,917,744,549,918,862,739,388,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,418,479,389,919,920,921,24,4,1,0,7,1,0,0,0,0,0], 
    [0,0,0,0,0,0,4,922,923,559,924,925,926,644,388,927,388,388,388,388,388,388,388,418,506,418,418,418,418,418,418,506,418,388,388,418,418,418,418,418,418,418,418,418,418,388,388,418,928,884,633,929,37,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,57,930,931,932,933,387,387,389,387,387,388,418,388,418,418,388,388,388,418,418,418,418,388,388,698,418,418,418,418,418,418,418,418,418,418,418,418,388,388,418,418,934,935,936,649,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,1,107,937,938,939,940,941,941,838,942,532,532,387,387,388,388,388,418,389,389,418,418,418,418,388,418,418,418,418,389,418,418,418,418,418,418,418,418,418,418,418,609,661,943,944,315,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,1,1,945,946,947,948,949,950,951,952,953,953,772,954,788,532,387,389,506,418,418,418,418,418,506,388,388,388,418,418,418,418,418,418,418,418,418,418,418,418,388,884,955,680,176,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,1,1,0,0,2,39,956,957,103,958,959,721,960,961,962,963,964,965,966,913,967,968,953,969,646,919,533,609,553,389,418,418,418,418,418,418,418,418,418,388,418,418,927,969,611,970,0,7,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,4,0,1,106,3,0,5,7,105,104,152,23,971,972,970,973,974,634,975,976,977,978,949,979,661,980,981,982,772,934,609,609,418,418,418,418,418,418,418,388,418,418,927,983,984,972,0,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,7,5,985,985,39,104,55,957,405,808,986,987,988,989,611,990,991,965,598,992,980,993,953,850,994,995,632,532,996,997,250,39,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,3,3,0,0,107,105,177,55,103,972,998,648,999,988,1000,1001,1002,1003,807,949,1004,720,1005,981,1006,1007,1008,105,0,4,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,15,4,0,0,4,4,3,0,0,0,0,1,1,0,5,24,105,56,343,722,972,37,864,1009,974,988,1010,958,3,1,0,7,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,1,1,1,0,0,0,0,0,0,7,0,0,0,0,0,0,0,0,2,107,39,1008,956,1011,1011,1012,1013,0,1,4,7,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,4,4,0,0,0,0,3,3,3,0,0,0,0,0,128,0,7,0,0,4,0,1,1,107,372,315,0,0,4,2,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff666668, 0xff676767, 0xff656766, 0xff666664, 0xff676664, 0xff656565, 0xff676566, 0xff73725e, 0xff817e51, 0xff7f7a52, 0xff787258, 0xff6e6b62, 0xff6c6964, 0xff686667, 0xff656764, 0xff84854c, 0xffa4a138, 0xffaa9d34, 0xff9e8d3d, 0xff877a4e, 0xff7f7458, 0xff6f6d60, 0xff6b6b5f, 0xff686765, 0xff6c6d5d, 0xffadb432, 0xffd5de13, 0xffefe605, 0xffeed507, 0xffe5b912, 0xffd9b018, 0xffc29f27, 0xffb29432, 0xff978344, 0xff8a7d49, 0xff76715d, 0xff706d5c, 0xff6a6965, 0xff686763, 0xff717459, 0xffc0c722, 0xffe3eb0a, 0xfff5f500, 0xfff6ea00, 0xfff4cd04, 0xfff4c506, 0xffebb90a, 0xffe1b411, 0xffcba520, 0xffbc9d29, 0xff9b8843, 0xff918146, 0xff7d7457, 0xff766f5c, 0xff6d6a61, 0xff696863, 0xff6d6e5e, 0xff87884e, 0xffdbe40f, 0xfff0f804, 0xfff3fe00, 0xfff5fc00, 0xfff6ec01, 0xfffade01, 0xfffdc800, 0xffffc700, 0xfffdc401, 0xfffbc203, 0xfff2be0a, 0xffedb90b, 0xffd9ad18, 0xffd0a620, 0xffb09433, 0xffa28b3d, 0xff897b4c, 0xff7e7556, 0xff706d5e, 0xff6e6a61, 0xff676862, 0xff676568, 0xff656567, 0xff75755b, 0xff939743, 0xffe3ef09, 0xfff2fb02, 0xfff4ff01, 0xfff2f800, 0xfff7eb01, 0xfffccf00, 0xfffec901, 0xfffcc602, 0xfffec502, 0xfffbc503, 0xfff3bf07, 0xffefbc09, 0xffdfb113, 0xffd4ac19, 0xffbb9b2e, 0xffaa8f38, 0xff8f7e46, 0xff86794f, 0xff746f5c, 0xff6f6b5f, 0xff696864, 0xff676863, 0xff656563, 0xff676765, 0xff8b8c4a, 0xffb8be28, 0xfff0fa03, 0xfff4fe00, 0xfff5ff00, 0xfff6ff02, 0xfff3fd00, 0xfff9dd00, 0xffffc603, 0xffffc501, 0xfffec601, 0xfffbc501, 0xfff9c203, 0xfff5bf05, 0xffebb90c, 0xffcca621, 0xffbd9c2b, 0xffa0893d, 0xff928247, 0xff746f5b, 0xff656668, 0xff686964, 0xff989c3e, 0xffc6cf1c, 0xfff1fc00, 0xfff3fe02, 0xfff6ff01, 0xfff4ff00, 0xfff5f700, 0xfff6ec00, 0xfffed000, 0xffffc602, 0xffffc702, 0xffffc600, 0xfffec600, 0xfffcc304, 0xfff9c205, 0xffe8b80e, 0xffd2a91b, 0xffc5a126, 0xffa88e39, 0xff998641, 0xff847852, 0xff7c7259, 0xff6a6a62, 0xff6f715b, 0xffbdc325, 0xffe3e90d, 0xfff2e10b, 0xfff4d614, 0xfff5f308, 0xfff3fc01, 0xfff4ff03, 0xfff3ff00, 0xfff6fd00, 0xfff7eb00, 0xfffadc00, 0xffffc500, 0xfffcc302, 0xfff6c004, 0xfff0be07, 0xffe0b310, 0xffd6ac1a, 0xffbb9b2a, 0xffac9138, 0xff907f47, 0xff86794d, 0xff706c61, 0xff686963, 0xff6a6964, 0xff787a55, 0xffcad21d, 0xffebec0a, 0xfff1b51f, 0xffef9831, 0xfff3d618, 0xfff5f207, 0xfff7fe01, 0xfff7f703, 0xfffaea01, 0xfffdce02, 0xfffdca01, 0xfffdc500, 0xfff8c105, 0xfff5be09, 0xffe7b70f, 0xffdcaf16, 0xffc3a125, 0xffb6962f, 0xff9a8542, 0xff8d7c4e, 0xff767058, 0xff6d6960, 0xff919646, 0xffe3e90b, 0xfff1e40c, 0xffed5748, 0xffeb2560, 0xffeb6252, 0xffeca436, 0xfff2f40a, 0xfff4fd02, 0xfff5ff01, 0xfff9e802, 0xffefbd08, 0xffe8b80c, 0xffc4a025, 0xffa78d38, 0xff756e5b, 0xff7b7b55, 0xffa2a53a, 0xffe6ed0b, 0xffefd713, 0xffed3f56, 0xffee1367, 0xffe52e66, 0xffe16853, 0xffedda1c, 0xfff3f307, 0xfff5f602, 0xfff6ea02, 0xfffdc403, 0xfffac304, 0xffd0a61e, 0xff8f8049, 0xff797258, 0xff686866, 0xff969844, 0xffc6c920, 0xffefdf0e, 0xffeca225, 0xffea1764, 0xffef046d, 0xffe9126f, 0xffe16a56, 0xffe3aa36, 0xfff6fb00, 0xfff8ea01, 0xfffcdb02, 0xffddb017, 0xffbe9e27, 0xff7f7454, 0xff6f6c5d, 0xff6b6c64, 0xffa6ab37, 0xffd2d919, 0xffecce16, 0xffe78335, 0xffec0d68, 0xfff0036d, 0xffee036c, 0xffed046d, 0xffe33269, 0xffdf6b54, 0xffecdd12, 0xfff1f502, 0xfff7fe00, 0xfff6f600, 0xfffed001, 0xfffec900, 0xffe3b410, 0xffa28b3b, 0xff847850, 0xff696a62, 0xff747758, 0xffc9ce1c, 0xffe8e909, 0xffeb9929, 0xffe94850, 0xffee036a, 0xfff1016e, 0xfff0006b, 0xfff1006d, 0xfff0056e, 0xffeb1167, 0xffe66933, 0xffecaa18, 0xfff3f403, 0xfffad900, 0xfffbcb00, 0xfffcc900, 0xffffc502, 0xffd2a91d, 0xff948244, 0xff7a7356, 0xff66656a, 0xff6c6c60, 0xff808251, 0xffd5dc14, 0xffece908, 0xffed7133, 0xffec2b57, 0xffef026c, 0xfff0006d, 0xffec0468, 0xffea324c, 0xffea6a2b, 0xfff2da06, 0xfff8f400, 0xfff6e500, 0xfff3cd00, 0xfff7c902, 0xfff9c801, 0xfffbc800, 0xfff1bc0a, 0xffbd9c28, 0xff9a8742, 0xff666762, 0xff666465, 0xff767a57, 0xff9da23e, 0xffe8ea0b, 0xffedd513, 0xffec3c53, 0xffef0f68, 0xfff1006f, 0xfff00469, 0xffef115e, 0xffeb6b2a, 0xffedac12, 0xffeff300, 0xffe6dd02, 0xffd6bd00, 0xffd8ba00, 0xffdebf02, 0xffe4c302, 0xffeac600, 0xfff0c602, 0xfff8c901, 0xfffbc701, 0xfffdc702, 0xfff8c102, 0xffe5b50d, 0xffa78f39, 0xff8a7c4f, 0xff6c6960, 0xff818650, 0xffaeb430, 0xffece80b, 0xffebbe1d, 0xffe9265e, 0xffed096a, 0xffee0169, 0xfff00466, 0xffea3546, 0xffeb7229, 0xfff5e806, 0xfff5f902, 0xffedea00, 0xffe1cf00, 0xffd0b101, 0xffcfaf02, 0xffd2b301, 0xffd5b802, 0xffdabb00, 0xffdfbe01, 0xffe9c501, 0xffeec400, 0xfff3c901, 0xfff7c901, 0xfff5c207, 0xffcfa81d, 0xffb09431, 0xff6b6b61, 0xff676769, 0xffa1a43b, 0xffcfd617, 0xffeecc15, 0xffe98235, 0xffef0c66, 0xffee016b, 0xffee016d, 0xffee0763, 0xffec1f57, 0xfff29925, 0xfff6d611, 0xfff2fb00, 0xffe1d600, 0xffd3bc00, 0xffcbab02, 0xffccaa02, 0xffcbab00, 0xffcdab01, 0xffcfaa03, 0xffceac02, 0xffceaf00, 0xffd4b701, 0xffd7b900, 0xffe0bf00, 0xffedc503, 0xfffcc700, 0xfffcc601, 0xfffcc206, 0xfff1bd07, 0xffc19e28, 0xff9d8a3e, 0xff706c60, 0xff6f6d5e, 0xffb1b82c, 0xffdce210, 0xffefb223, 0xffec6049, 0xffee066a, 0xfff1026a, 0xffef0b64, 0xffef6d3b, 0xfff3be18, 0xfff2f900, 0xffdcc900, 0xffd2b500, 0xffccaa00, 0xffccac01, 0xffcdad00, 0xffd1b401, 0xffd4b703, 0xffddbb02, 0xffe1be02, 0xffeec302, 0xfff4c901, 0xffffc505, 0xfffcc300, 0xffe4b511, 0xffc6a325, 0xff716e5f, 0xff6a6b63, 0xff7c7f54, 0xffd1d914, 0xffe9e60b, 0xffeb6f3b, 0xffea285a, 0xfff2006e, 0xfff0006a, 0xfff00169, 0xffee086a, 0xffe67442, 0xffefc41d, 0xfff4f801, 0xffecea01, 0xffd2b801, 0xffcdae00, 0xffcead00, 0xffcfae01, 0xffd0af02, 0xffd6b802, 0xffd9b902, 0xffdfc101, 0xffe4c400, 0xffedc501, 0xffefc800, 0xffffc801, 0xfff7c105, 0xffd3aa1c, 0xffb59331, 0xff7c7257, 0xff6d6a63, 0xff6f705e, 0xff898f49, 0xffe0e50f, 0xfff0e00e, 0xffea5446, 0xffec1960, 0xfff1016c, 0xfff0006f, 0xffef046b, 0xffed1367, 0xffec9534, 0xfff3d913, 0xfff0f400, 0xffe6e101, 0xffd0b202, 0xffcdaa04, 0xffccab00, 0xffd0af00, 0xffd3b401, 0xffd6b800, 0xffe0c200, 0xffe9c402, 0xffecc400, 0xfff7c800, 0xffeebd0b, 0xffdbb016, 0xff9b8740, 0xff7e7652, 0xff818352, 0xffa9af33, 0xffe9e60d, 0xffecbb21, 0xffea2761, 0xffee086b, 0xfff00070, 0xfff1006b, 0xfff2006f, 0xffee0d69, 0xffe93457, 0xffefcd14, 0xfff3f204, 0xffe9e404, 0xffddca01, 0xffcba900, 0xffcfb000, 0xffd1b200, 0xffd5b900, 0xffe1c000, 0xffe3c600, 0xffefc501, 0xfff1c600, 0xfff7c703, 0xfff7c502, 0xffe4b811, 0xffcaa523, 0xff897b4a, 0xff76705a, 0xff8e9248, 0xffbbc226, 0xffefd80c, 0xffed9929, 0xffea1565, 0xffef0469, 0xfff10069, 0xffeb1964, 0xffe84f4a, 0xfff2e10d, 0xffe4d901, 0xffd7c002, 0xffcba802, 0xffcba901, 0xffdbbc01, 0xffdfc100, 0xffebc502, 0xfff0c600, 0xffedc504, 0xffe4ba0c, 0xffad9731, 0xff8d8345, 0xff6c6e60, 0xffdadd12, 0xffefad23, 0xfff2016c, 0xffea4355, 0xffec9633, 0xfff3f605, 0xfff0f401, 0xffdbc402, 0xffd0b300, 0xffcaaa00, 0xffcaaa01, 0xffd9ba00, 0xffd4b908, 0xffc5b015, 0xff8d8441, 0xff71735b, 0xffbfc525, 0xffe3e40c, 0xffed9333, 0xffeb3f55, 0xfff2036b, 0xffed076a, 0xffea5f4a, 0xffeeb424, 0xfff2f802, 0xffedee00, 0xffd7bb02, 0xffceae03, 0xffcbaa03, 0xffceae01, 0xffceb501, 0xffc8af0a, 0xff998735, 0xff706e62, 0xffdbde11, 0xffeddb0f, 0xffe8514a, 0xffeb1764, 0xffeea324, 0xffeef100, 0xffe4db00, 0xffc8a606, 0xffb89d10, 0xff7f764d, 0xff949841, 0xffe3e30f, 0xffedca16, 0xffed0c6a, 0xffec0b69, 0xffe82c5f, 0xffedc21d, 0xfff1ef07, 0xffebe900, 0xffdecf00, 0xffc3a40b, 0xffac961e, 0xff666865, 0xff8a8d4a, 0xffeed70f, 0xffed9728, 0xffe92662, 0xffe96849, 0xfff1ec0a, 0xfff4f803, 0xffe2d400, 0xffd4bc00, 0xffcaa902, 0xffb0981a, 0xff90823b, 0xffc7ce1e, 0xffefc114, 0xffed7332, 0xffef0c68, 0xffeb3953, 0xffec8833, 0xfff1f403, 0xfff4f503, 0xffd2b501, 0xffc8a903, 0xffa48e28, 0xff84794b, 0xff70725d, 0xffbdc027, 0xffe1e10f, 0xffe88f31, 0xffea3c53, 0xffe9723a, 0xffeec217, 0xfff2f601, 0xffcba804, 0xffc0a20c, 0xff867a48, 0xff797a5a, 0xffccd11d, 0xffe4e30d, 0xffe66d42, 0xffe8295c, 0xffec1266, 0xffeb992d, 0xfff0db0e, 0xffd1b104, 0xffccac00, 0xffcea902, 0xffc8a704, 0xffb69b16, 0xff797353, 0xff6c6962, 0xffe2e30c, 0xffebcd15, 0xffe03851, 0xffe60d64, 0xffea016a, 0xffeb0069, 0xffee0e66, 0xffea3955, 0xfff0d315, 0xffeae503, 0xffdccb01, 0xffb99d15, 0xff9a8931, 0xffaeb42e, 0xffe8e80a, 0xffe9ca18, 0xffd1324e, 0xffd30c5d, 0xffda0061, 0xffdc0062, 0xffe60065, 0xffe80068, 0xffec016a, 0xffed006a, 0xffeb1763, 0xffeb5149, 0xfff3e40b, 0xfff3f700, 0xffd7c000, 0xffac9521, 0xff8b8040, 0xffe4ed08, 0xfff0f902, 0xffc16c35, 0xffab2945, 0xffa6014d, 0xffa7014d, 0xffb00051, 0xffb30052, 0xffc00056, 0xffc40057, 0xffcd005f, 0xffd2015f, 0xffde0262, 0xffe54851, 0xffe89a2d, 0xfff2f504, 0xffd7c702, 0xffcbaa00, 0xff8f803d, 0xff746f59, 0xffeff902, 0xfff1f701, 0xffce9c21, 0xffb35134, 0xff9d0649, 0xff9b0149, 0xff9e004d, 0xff9e004b, 0xffa5004d, 0xffa8004e, 0xffb10154, 0xffb40152, 0xffbe0056, 0xffc30859, 0xffdc6d42, 0xffeabc20, 0xffefee00, 0xffd3bb00, 0xffcdad02, 0xffbc9f13, 0xff81794b, 0xff6d6b5f, 0xffdbe512, 0xfff3fc03, 0xffebe207, 0xffd5ad18, 0xffa32942, 0xff9e094d, 0xff96004a, 0xff980049, 0xff9a004b, 0xff98004b, 0xff97014b, 0xff99014a, 0xff9c0749, 0xffa81d46, 0xffdbaf1b, 0xffeef200, 0xffccac03, 0xffbda20d, 0xffa3902a, 0xffbac123, 0xffebf606, 0xfff2fd01, 0xfff0f602, 0xffe6d40e, 0xffb34d36, 0xffa21b44, 0xff98024c, 0xff98004d, 0xff9c0c49, 0xffab313e, 0xffe2c80f, 0xfff1f105, 0xffdecf02, 0xffb29a16, 0xff958337, 0xff6b6861, 0xff7f8152, 0xffcdd319, 0xffe9f108, 0xfff3f901, 0xffd6ae1b, 0xffba6435, 0xff9b094a, 0xff9a0049, 0xffa32441, 0xffba6830, 0xffedec06, 0xffe1d301, 0xffd5bb02, 0xffc6a606, 0xff978837, 0xff797351, 0xff6f735c, 0xffb6bb2d, 0xffdae211, 0xffe7d60d, 0xffce9522, 0xffa11846, 0xff9c054a, 0xff99034b, 0xffad3a3d, 0xffc98925, 0xffeff402, 0xfff0f600, 0xffdac900, 0xffcaa701, 0xffc0a30a, 0xff897c45, 0xff726d5a, 0xff868650, 0xffacb131, 0xffecf508, 0xfff2f603, 0xffe9e009, 0xffb96036, 0xffa22543, 0xff98024a, 0xff9c0a48, 0xffc47226, 0xffe2c20d, 0xfff3f704, 0xffebe901, 0xffd1b702, 0xffc2a50b, 0xffab951e, 0xff716f5a, 0xff696562, 0xff73765b, 0xff929642, 0xffe0ea0f, 0xfff1fa03, 0xffeef303, 0xffd09120, 0xffb24832, 0xff980549, 0xff9d1547, 0xffd1971c, 0xffe9db09, 0xffeff501, 0xffe7df00, 0xffcfb101, 0xffcea903, 0xffbba013, 0xffa08c2d, 0xffb9bd2a, 0xffdce50e, 0xffecdf07, 0xffd6a71b, 0xffa52443, 0xff9a094a, 0xff9d0f4b, 0xffac393c, 0xffe4d20c, 0xfff0f304, 0xffebe304, 0xffc9a805, 0xff83784a, 0xff6a6c61, 0xff9ea03b, 0xffc8cf1f, 0xffe5d30f, 0xffb44635, 0xffa01743, 0xffb55137, 0xffece407, 0xffe5d800, 0xffd6bf00, 0xffc5a407, 0xff948437, 0xff787157, 0xff76765a, 0xff969940, 0xffe2ea0b, 0xfff1f905, 0xffd6a51a, 0xffbd5c31, 0xffb24b38, 0xffce9521, 0xffd7c304, 0xffd1b202, 0xffb69b18, 0xff777254, 0xff6d6d63, 0xff828250, 0xffd2d917, 0xffeaf306, 0xfff5fc01, 0xffe6cf0d, 0xffbf7629, 0xffdab818, 0xffeeec03, 0xffd4bb00, 0xffa79323, 0xff9fa53b, 0xfff1fb04, 0xfff3f903, 0xffebe803, 0xffe8dc0a, 0xfff0ee05, 0xffedf300, 0xffe3da01, 0xffcaa904, 0xffac9223, 0xff8b7c41, 0xff898c49, 0xffb2b92b, 0xffedf605, 0xfff2f600, 0xfff3fa00, 0xffdfcf00, 0xffcda800, 0xff9a8a33, 0xff7d7551, 0xff6d6d61, 0xff848452, 0xffd3db16, 0xfff1fa00, 0xffe2d401, 0xffc8a702, 0xffb99e0f, 0xff80774e, 0xff74745a, 0xffbcc325, 0xffdfe90c, 0xffdbc800, 0xffd2b300, 0xff767056, 0xff8d8e4a, 0xffb7bd29, 0xffeff905, 0xffb39a19, 0xff6b6863, 0xff7a7c57, 0xff9ca13b, 0xffe5ee0b, 0xffe6de01, 0xffc9a803, 0xffa49128, 0xff857b48, 0xff696a65, 0xff77775b, 0xffe3e80f, 0xffe7e202, 0xffdbc802, 0xffcca903, 0xffcea900, 0xff877d42, 0xffa7aa37, 0xffced418, 0xffded702, 0xffd6bf01, 0xffc7a706, 0xffb69c14, 0xff7c7450, 0xff7e7c56, 0xff979b3c, 0xffc1b113, 0xffc6aa0b, 0xffc4a608, 0xffcaa703, 0xff998931, 0xff6a6a5e, 0xff706e61, 0xff807d52, 0xffa2952d, 0xffa99524, 0xffac961f, 0xffaf971b, 0xffbb9e12, 0xffbfa10d, 0xffc3a507, 0xffc8a607, 0xffae951f, 0xff6c6a5e, 0xff6e6a5f, 0xff736e5b, 0xff7b7551, 0xff867a46, 0xff887b46, 0xff928439, 0xff9a8b30, 0xffaa9321, 0xffab9422, 0xffaf971d, 0xffbea00e, 0xffc2a30b, 0xffc4a606, 0xff757156, 0xff6d6b5e, 0xff6e6c5d, 0xff7a7452, 0xff847a47, 0xff8c7e41, 0xff948439, 0xffa28f28, 0xffa99323, 0xffb0981e, 0xffbca00e, 0xffc3a509, 0xffc6a50a, 0xffbda10f, 0xff837948, 0xff676662, 0xff797552, 0xff7e774d, 0xff857b46, 0xff877c44, 0xff988833, 0xffa79124, 0xffb1991b, 0xffc1a40b, 0xffc7a704, 0xffc8a805, 0xffbfa10f, 0xffa79028, 0xff747057, 0xff827a49, 0xff897f42, 0xff90833d, 0xffa18d2c, 0xffa79225, 0xffb79d15, 0xffc4a30a, 0xffb3971a, 0xff968638, 0xff696961, 0xff7d754e, 0xff7d7550, 0xff6e6c60, 0xff6a6a60, 0xff6c6867]
				); 
        }
		public function box24():BitmapData{  
             return BitmapPatternBuilder.build( 
			 [
    [0,0,0,0,0,0,0,0,0,0,0,0,1,0,2,0,0,3,4,5,6,7,8,9,10,11,11,0,10,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,10,0,0,1,13,14,15,16,17,18,19,20,21,22,23,0,0,0,2,24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,0,2,0,25,26,27,28,29,30,31,32,33,34,35,36,9,0,0,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,0,0,25,37,38,39,40,41,42,43,44,45,46,47,48,49,35,50,51,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,2,10,0,25,52,27,53,54,55,56,57,58,59,60,46,61,62,63,64,65,66,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,67,68,69,70,71,72,73,74,55,75,42,76,77,78,79,79,80,46,81,82,83,64,84,85,10,86,0,10,10,0,2,0,0,0,0,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,87,88,26,4,89,53,73,90,74,91,74,92,93,94,79,95,96,60,46,97,98,99,35,100,101,12,2,87,0,2,67,102,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,25,103,104,71,105,106,107,108,109,110,111,74,112,113,114,115,116,115,79,117,80,118,119,120,121,35,50,9,122,122,0,12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,101,123,124,125,126,127,128,129,130,131,111,56,132,133,134,114,95,135,136,95,137,138,118,139,33,63,140,100,9,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,142,14,143,144,145,146,147,148,149,150,74,151,56,92,152,153,115,154,155,155,155,155,95,156,157,118,158,82,159,64,50,9,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,160,161,53,162,163,164,165,166,167,168,169,170,74,90,171,172,115,95,115,115,116,155,95,116,173,174,175,176,82,177,140,8,178,66,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,10,10,0,0,179,37,180,72,181,182,183,184,185,186,187,188,189,190,151,74,191,192,193,136,116,136,135,194,194,194,194,194,135,154,80,195,196,98,49,35,22,9,197,87,0,67,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,10,26,198,199,200,201,202,203,204,185,205,206,207,208,209,210,74,211,212,213,214,116,79,135,194,194,194,194,194,116,79,117,174,215,216,217,218,35,219,220,0,2,2,10,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,179,221,222,223,224,225,226,227,228,229,230,231,232,233,234,110,74,151,42,171,235,236,236,95,194,194,194,194,194,95,135,136,95,79,237,157,238,239,240,241,50,242,141,0,243,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,243,244,245,246,247,248,249,250,251,252,229,230,252,253,254,255,256,170,91,257,112,258,259,136,136,194,194,194,194,194,79,115,115,115,79,236,260,261,262,263,264,265,266,141,10,24,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,25,12,267,268,269,223,270,271,272,273,228,252,274,185,275,276,277,278,279,280,91,41,42,212,281,214,116,194,194,194,194,194,136,135,194,194,79,115,115,194,282,283,284,34,285,9,0,24,0,0,0,0,0,0,0,0,0,0,0], 
    [51,2,2,0,0,87,66,286,287,288,289,290,254,253,205,185,252,252,252,252,252,291,292,293,294,74,91,170,295,296,297,135,135,79,194,96,79,194,194,194,194,194,194,79,116,135,298,299,300,301,26,87,266,0,0,2,0,10,86,0,0,0,0,0], 
    [0,10,10,0,0,101,302,303,304,305,306,307,308,205,252,252,252,252,252,252,252,309,310,311,312,313,56,151,74,314,258,315,236,95,95,95,95,194,194,194,194,194,194,236,115,95,135,60,316,317,318,178,86,0,0,10,0,0,0,0,0,0,0,0], 
    [10,10,0,0,0,319,320,321,322,323,324,325,253,252,274,185,252,252,252,252,252,326,327,328,329,330,331,111,151,332,333,297,236,154,95,95,95,194,194,194,194,194,194,236,116,136,95,95,334,335,336,337,25,0,0,10,0,0,0,0,0,0,0,0], 
    [10,0,0,25,66,338,339,340,341,342,343,344,345,229,274,230,252,252,252,252,252,346,185,347,348,349,350,151,151,56,351,352,353,95,95,95,95,194,194,194,194,194,194,95,79,115,115,116,155,354,355,356,357,141,0,0,0,0,10,0,0,0,0,0], 
    [51,10,0,25,26,358,359,360,361,362,363,252,364,229,365,230,252,252,252,252,252,252,366,367,368,369,370,111,91,111,371,171,44,236,79,95,136,194,194,194,194,194,194,135,135,236,115,115,79,138,372,373,374,22,141,25,10,0,0,0,0,0,0,0], 
    [12,0,10,70,375,376,377,378,379,380,381,252,252,252,252,252,252,252,252,252,252,228,366,185,382,383,384,385,386,387,74,388,389,390,391,392,79,79,79,194,136,79,135,115,116,135,95,79,95,393,79,394,395,396,397,0,0,0,0,0,0,0,0,0], 
    [398,0,141,399,400,401,402,403,404,405,345,252,252,252,252,252,252,252,252,252,252,185,366,230,406,407,408,409,170,41,386,410,411,412,413,414,415,79,95,79,79,115,194,236,79,95,95,136,136,393,79,354,61,416,417,266,2,1,2,0,0,0,0,0], 
    [12,51,302,418,304,419,420,421,422,228,185,252,252,252,252,252,252,252,252,252,252,275,365,252,423,424,425,426,427,428,429,430,431,432,433,434,435,436,437,392,79,155,155,95,79,236,95,194,194,136,236,79,438,439,440,441,85,0,0,0,0,0,0,0], 
    [141,26,320,442,443,444,445,446,327,185,230,252,252,252,252,252,252,252,252,252,252,276,252,423,204,447,448,449,74,450,451,452,453,454,455,456,457,458,459,460,461,392,79,135,135,115,116,236,95,135,116,79,156,462,395,463,464,0,10,0,0,0,0,0], 
    [66,375,465,466,467,447,468,469,470,185,252,252,252,252,252,252,252,252,252,252,252,471,472,473,474,475,476,110,477,478,479,480,481,482,481,483,482,484,485,486,487,488,489,461,490,116,116,95,79,79,154,136,95,138,491,82,492,493,24,0,0,0,0,0], 
    [26,494,495,496,497,498,499,185,366,205,500,252,252,252,252,252,252,252,252,252,252,366,501,502,503,504,131,505,506,507,508,509,510,482,482,483,511,454,454,512,513,514,515,516,414,116,116,95,194,236,79,116,236,517,60,263,518,65,493,0,0,0,0,0], 
    [519,520,521,522,523,524,228,185,252,252,185,366,366,185,185,252,470,252,185,252,185,525,526,527,528,529,530,531,532,533,483,481,482,482,482,482,482,482,483,483,534,535,432,457,434,536,537,538,392,79,79,136,95,136,79,45,539,540,541,51,0,0,10,67], 
    [542,543,544,545,546,547,548,549,549,550,185,252,252,252,185,205,551,185,552,252,252,553,554,555,556,557,558,559,560,480,482,483,482,482,482,482,482,482,483,483,483,534,534,533,456,561,562,563,437,564,392,136,136,95,95,173,354,565,566,567,10,2,67,0], 
    [340,568,256,569,570,571,572,573,574,575,576,274,252,252,252,185,205,252,366,406,577,578,579,580,557,581,582,583,584,483,481,483,482,482,482,482,482,482,482,482,482,482,482,482,483,454,453,585,586,587,588,589,461,79,236,115,79,590,591,592,593,2,87,10], 
    [594,595,596,597,598,599,600,601,602,603,604,605,606,607,228,185,205,252,366,608,526,609,610,611,612,613,614,533,483,481,481,510,482,482,482,482,482,615,483,482,482,482,482,483,483,483,534,453,616,617,618,619,436,415,620,135,79,621,622,177,623,0,67,10], 
    [624,313,74,625,626,627,628,629,629,630,631,632,602,633,634,575,606,346,423,635,636,637,190,638,639,640,641,483,482,483,511,483,482,482,482,482,482,482,482,482,482,482,482,482,483,483,483,615,482,482,454,642,643,644,645,437,646,392,647,648,649,650,651,25], 
    [652,653,74,450,654,655,656,657,658,659,660,661,662,663,664,665,666,667,668,669,670,671,110,672,673,674,454,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,454,484,675,676,677,678,646,679,46,680,681,441,243], 
    [682,683,54,684,685,686,687,688,689,690,691,692,657,659,693,694,662,695,696,697,698,596,699,700,701,481,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,702,482,482,702,482,703,703,704,705,706,707,708,709,710,711,712], 
    [713,714,715,595,716,717,718,719,720,658,692,692,657,658,721,722,723,724,725,726,190,727,728,729,616,483,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,483,703,730,456,731,732,733,734,735,736], 
    [37,737,738,75,739,740,741,742,743,690,690,692,744,744,722,745,746,747,748,749,612,750,751,455,703,482,615,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,481,483,482,482,483,511,484,752,753,754,755], 
    [319,756,143,757,74,758,759,760,761,690,692,690,690,690,762,763,764,765,766,612,450,767,768,534,481,483,615,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,510,483,482,481,483,482,482,584,769,770,771], 
    [51,772,773,774,386,477,775,776,777,688,658,778,720,779,780,781,782,783,427,784,785,704,786,483,615,483,702,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,787,788,482,482,788,789,790,791,792], 
    [10,320,793,794,73,596,795,796,797,798,690,692,689,799,800,801,802,386,783,803,804,453,534,483,483,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,510,510,510,481,615,805,806,807,22], 
    [2,808,268,809,810,111,211,811,812,813,689,762,814,815,816,817,612,818,819,820,533,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,821,822,482,534,615,823,824,825,826,10], 
    [0,827,828,829,830,831,170,832,833,834,835,719,836,837,838,449,110,410,839,840,703,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,702,702,534,483,481,841,842,843,844,9,86], 
    [10,51,808,339,845,371,74,817,846,847,848,849,850,765,851,852,429,853,583,483,615,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,702,854,821,855,856,857,858,10,86,0], 
    [0,87,859,860,861,862,74,863,864,865,866,867,868,869,870,871,872,873,874,482,482,482,482,482,534,702,702,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,789,482,875,789,876,877,65,878,2,87,141], 
    [0,0,25,879,880,881,371,56,882,883,884,885,886,90,887,888,889,703,483,481,481,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,483,482,482,483,482,890,891,892,893,9,2,0,0,10], 
    [0,0,2,894,895,896,897,74,568,898,899,900,162,385,901,902,903,483,483,481,483,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,904,483,481,482,482,905,906,907,908,909,50,2,2,10,0,0], 
    [910,2,86,911,912,913,830,74,74,428,914,749,90,915,916,917,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,702,822,905,482,918,919,920,921,68,0,0,10,0,2,0], 
    [0,0,0,179,922,923,924,74,41,595,925,371,477,926,479,480,483,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,702,482,511,822,927,928,929,858,0,10,0,0,2,0,10], 
    [0,0,2,10,23,930,829,931,831,111,111,932,933,431,453,482,788,534,483,822,822,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,788,482,821,934,935,936,937,68,2,24,10,0,0,938,939], 
    [2,0,0,0,51,940,941,942,75,111,943,944,945,533,481,534,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,481,481,946,947,948,949,51,10,10,24,0,0,0,0,0], 
    [0,0,0,0,0,950,951,952,953,477,954,640,512,482,483,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,702,483,483,483,483,789,955,842,956,957,51,0,958,87,2,0,0,0,0,0], 
    [0,2,2,0,2,959,960,961,962,963,964,903,455,534,482,534,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,482,482,702,534,965,966,967,968,101,67,141,24,0,0,0,0,0,0,0], 
    [0,2,0,0,25,878,969,970,971,972,973,480,481,534,482,483,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,904,822,481,974,975,976,977,101,2,2,0,87,0,2,0,0,0,0,0], 
    [0,0,0,0,0,51,978,979,980,981,982,534,482,481,702,821,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,482,483,702,534,983,984,985,986,878,0,10,0,67,10,2,1,0,0,0,0,0], 
    [0,0,0,0,0,141,66,987,988,989,990,907,991,974,992,483,534,482,702,993,483,482,483,481,481,702,481,482,483,482,822,483,482,482,482,482,482,482,482,482,482,482,482,482,822,510,615,994,995,996,22,10,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,2,0,957,792,997,998,999,1000,1001,1002,890,1003,534,788,481,483,702,702,1004,1004,483,615,483,483,482,482,483,482,482,482,482,482,482,482,482,482,482,482,483,483,510,1005,908,1006,50,51,10,87,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,2,66,9,1007,1008,1009,1010,935,1011,1012,1013,841,992,1004,482,483,483,481,483,482,534,534,482,904,482,482,482,482,482,482,482,482,482,482,482,481,483,1014,1015,1016,1017,0,51,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,67,0,0,10,0,0,141,9,337,1018,1019,1020,1021,1022,1023,1013,890,1024,906,483,481,822,483,483,483,483,483,482,482,482,482,482,482,482,482,482,482,482,615,1025,856,1026,593,9,2,0,2,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,10,0,938,0,2,0,10,0,0,0,10,101,1027,1028,1029,1030,877,995,790,1014,1031,1032,789,534,482,702,534,482,482,482,482,482,482,482,482,482,483,483,1033,1034,1035,1008,141,0,0,10,0,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,10,2,1,0,0,0,10,0,0,10,2,0,141,9,50,1036,1037,1035,1038,1039,790,1014,805,1040,821,615,534,482,482,482,482,482,482,482,482,482,483,483,1041,1042,1043,23,2,1,11,2,12,10,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,25,51,50,593,1044,986,1045,1046,1047,1012,1031,841,821,510,482,482,483,482,482,483,955,1048,1049,968,51,0,10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,141,141,51,50,593,1050,1009,1051,935,1052,1053,1054,890,906,483,483,483,822,906,1055,1056,1057,84,266,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,67,87,0,0,87,0,10,68,937,1027,949,1019,1058,1059,1060,1061,1062,805,1063,1064,1065,1066,9,10,0,10,86,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,24,12,0,2,2,25,2,10,51,22,1067,949,1068,1069,1070,1071,1072,1073,1047,1074,1008,68,2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0], 
    [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,87,0,0,24,12,10,0,0,0,2,1075,12,68,178,826,1076,1077,1078,1079,50,141,0,10,51,51,141,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]
],
[0xff666666, 0xff656668, 0xff666668, 0xff6c6e60, 0xff7b7b55, 0xffa6a433, 0xffa19937, 0xff7c7654, 0xff726c5c, 0xff686763, 0xff666664, 0xff66656a, 0xff676566, 0xff676862, 0xff84844e, 0xffa7ab33, 0xffe3e20c, 0xffe9da0d, 0xffcead20, 0xffb99b2d, 0xff8c7f4b, 0xff7b7457, 0xff6a6a62, 0xff696863, 0xff676568, 0xff676767, 0xff6b6b61, 0xff999d3f, 0xffc2c725, 0xffeff306, 0xfff5ed04, 0xffecc60b, 0xffdfb513, 0xffb89a2c, 0xffa18a3c, 0xff7d7457, 0xff716e5d, 0xff6f7060, 0xff828452, 0xffccd51a, 0xffe7f009, 0xfff4ff01, 0xfff5fa00, 0xfff9e302, 0xfffcd400, 0xfff7c105, 0xffedbc0a, 0xffcda720, 0xffb69a2d, 0xff8d7d4a, 0xff6c6960, 0xff676765, 0xff7a7c54, 0xffe1e80e, 0xffeff904, 0xfff4ff03, 0xfff6fd00, 0xfff7ed00, 0xfffbdf00, 0xfffcc802, 0xfffac402, 0xffe0b214, 0xffb8992d, 0xffa18c3d, 0xff7d7455, 0xff736d5d, 0xff686765, 0xff656764, 0xff686667, 0xff676966, 0xff6e7062, 0xffa7aa35, 0xffced41c, 0xfff2fb02, 0xfff4fe00, 0xfff3fe02, 0xfff7f001, 0xfffcd201, 0xffffca02, 0xfffec601, 0xfff6c004, 0xffcea620, 0xffb9982d, 0xff8e7e4a, 0xff6c6962, 0xff6a6665, 0xff656565, 0xff656766, 0xff696468, 0xffc2c722, 0xfff4fb00, 0xfff4ff00, 0xfff6f600, 0xfffcd901, 0xfffece00, 0xffffc501, 0xfffec400, 0xffe0b312, 0xffba982c, 0xffa08b3c, 0xff736d5f, 0xff676863, 0xff646663, 0xff686866, 0xff828550, 0xffe7ee0a, 0xfff0f306, 0xffecc716, 0xffedc116, 0xfff2f005, 0xfff5fc01, 0xfff5ff01, 0xfff8ec00, 0xfffade00, 0xfffdc800, 0xffffc700, 0xfffec600, 0xfffdc401, 0xffeeba0c, 0xffcda71e, 0xffb89a2a, 0xff8b7e4a, 0xff646665, 0xff6b6d60, 0xff9c9d3f, 0xffc2c723, 0xffeff108, 0xfff1e40c, 0xffe68b2e, 0xffe8842f, 0xfff1dc09, 0xfff5f604, 0xfff6f401, 0xfffae802, 0xffffcc01, 0xffffc500, 0xffffc602, 0xfffbc500, 0xfffcc302, 0xffe2b214, 0xff7b7555, 0xff676664, 0xff6e6f5f, 0xffcbd31d, 0xffe6ef0c, 0xfff0d610, 0xffed9d2c, 0xffeb265b, 0xffec2359, 0xffea982a, 0xfff1d711, 0xfff5ff00, 0xfffbda01, 0xfffcce00, 0xffffc502, 0xffffc603, 0xfffdc500, 0xfff6c006, 0xffcca61f, 0xff8c7f4a, 0xff7a7b59, 0xff999d3e, 0xffeef104, 0xffedaf26, 0xffeb6b44, 0xffea1066, 0xffeb1064, 0xffe7713f, 0xffedbb1e, 0xfff5fb03, 0xfff4fd02, 0xfff9e401, 0xfffdd400, 0xfffec401, 0xfffcc300, 0xffefba0a, 0xffe1b015, 0xffa1893f, 0xff696864, 0xff686964, 0xffa5ad36, 0xfff0ed08, 0xfff0ce15, 0xffed5047, 0xffec1f60, 0xfff0006b, 0xffee026e, 0xffe82e60, 0xffe77048, 0xfff3e90e, 0xfff5f904, 0xfff9f500, 0xfff9e701, 0xfffccc00, 0xffffc600, 0xffeebb0a, 0xffcda722, 0xff646661, 0xff7a7c55, 0xffc1c823, 0xffe0e70d, 0xfff3d910, 0xffeea42b, 0xffed285d, 0xfff00b66, 0xfff1016c, 0xffec1767, 0xffe94857, 0xfff3d118, 0xfff4f207, 0xfff7fe00, 0xfff5f902, 0xfff7f002, 0xfffbd100, 0xfffec901, 0xffedbb0c, 0xffe1b113, 0xffb8992f, 0xffa08a3e, 0xff746c5f, 0xff666863, 0xff848450, 0xffa4ac35, 0xffe6ed0b, 0xffefec09, 0xffef8c2f, 0xffec474d, 0xfff00669, 0xffee016b, 0xfff10069, 0xfff1006b, 0xfff0036b, 0xffef1464, 0xffef8434, 0xfff2c718, 0xfffcd402, 0xffffc702, 0xfffcc602, 0xffefbc0b, 0xffcba520, 0xffb19532, 0xff78725a, 0xff666762, 0xff676769, 0xff6c6c64, 0xff989c3e, 0xffc0c722, 0xffefee0a, 0xffefd711, 0xffe95d44, 0xffec255c, 0xffee036c, 0xfff0006d, 0xffef0868, 0xffed5748, 0xfff0a025, 0xfff3f704, 0xfff6fd02, 0xfffbdd01, 0xffffc801, 0xfffbc501, 0xfffbc503, 0xffebb80d, 0xffd5ab19, 0xff8e7e4d, 0xff746e5e, 0xff666867, 0xff6f6d60, 0xff808251, 0xffcad21c, 0xfff0c618, 0xffec8832, 0xffeb1764, 0xffed066e, 0xffee016d, 0xfff0006c, 0xfff2016c, 0xffec195e, 0xffe74e46, 0xffeed910, 0xfff5f605, 0xfffed102, 0xfffdc403, 0xfff9c205, 0xffc9a221, 0xff6f6b60, 0xff787957, 0xff969b3f, 0xffdfe40e, 0xffedeb0a, 0xffed9d2e, 0xffef0c68, 0xffe63059, 0xffeabd1c, 0xfff3eb0c, 0xfff6f602, 0xfffad900, 0xfffdcd01, 0xfffbc600, 0xffe7b311, 0xffc19e26, 0xff797359, 0xff6d6f61, 0xffa2a83a, 0xffc8cf1d, 0xfff0e80b, 0xffefc318, 0xffeb3e52, 0xffec1467, 0xffee036a, 0xffed0d66, 0xffe96e42, 0xffedba23, 0xfff2fb04, 0xfff8ee01, 0xfffecb02, 0xffefbc09, 0xffad9334, 0xff897b4e, 0xff6b6b63, 0xff797a58, 0xffbdc426, 0xffdee412, 0xffeed018, 0xffed962f, 0xffec1e5e, 0xffef026c, 0xfff0056c, 0xffe84d53, 0xffea9636, 0xfff4f406, 0xfff7fe01, 0xfff7f502, 0xfffbe601, 0xfff8c104, 0xffcca722, 0xffa48d3d, 0xff6e6c60, 0xff808250, 0xffa3a738, 0xffe3eb0a, 0xffeee30d, 0xffe8753c, 0xffe93558, 0xffef0368, 0xfff1026a, 0xffee0169, 0xffec1865, 0xffec4757, 0xfff3cf17, 0xfff4f305, 0xfff6f801, 0xfff8da00, 0xfffdcd00, 0xfff5bf07, 0xffdfb115, 0xff938347, 0xff777157, 0xff989b44, 0xffbdc325, 0xffecea0b, 0xffefca17, 0xffec494c, 0xffec1862, 0xfff1016e, 0xffef006c, 0xfff1006d, 0xffef0b6c, 0xffed2860, 0xfff0ac25, 0xfff3e20c, 0xfff3fc01, 0xfff0be09, 0xffb2952f, 0xff8d7d49, 0xff838252, 0xffccd11d, 0xffe5ea0a, 0xffedb71f, 0xffea7240, 0xffee0f68, 0xffef046d, 0xffee086a, 0xffee5742, 0xffeda320, 0xfff2f802, 0xfff3fd00, 0xfff3ff01, 0xfff3ee00, 0xfff3dd00, 0xfff5ca02, 0xfff8c901, 0xfffcc601, 0xfffec502, 0xffe9b60f, 0xffc9a223, 0xff7f7753, 0xff70695f, 0xff666865, 0xff7a7a56, 0xff979a41, 0xffdde30f, 0xffede90b, 0xffeb8c30, 0xffeb474e, 0xffed076a, 0xfff00469, 0xffec364d, 0xffec7b2f, 0xfff2f007, 0xffeae601, 0xffe5d400, 0xffe7c502, 0xffedc503, 0xfff7c701, 0xfffbc701, 0xff978545, 0xff7b7158, 0xffa3a736, 0xffefdd0f, 0xffecaf21, 0xffe83258, 0xffed0f66, 0xffef046b, 0xffe7395a, 0xffe57b3d, 0xfff1ef06, 0xfff2fd01, 0xfff3f903, 0xffefed02, 0xffd8c500, 0xffd0b601, 0xffcfb000, 0xffd3b402, 0xffddbb01, 0xffe6c101, 0xfff2c601, 0xfff5c700, 0xfffcc304, 0xffd0a91e, 0xffaa8f38, 0xff726c5e, 0xffbec225, 0xffdee211, 0xfff0c217, 0xffeb8030, 0xffea1764, 0xffe96147, 0xffeca62d, 0xfff3f702, 0xffeef102, 0xffe8de02, 0xffd1b700, 0xffcdad00, 0xffcdab01, 0xffcdad02, 0xffd1b200, 0xffd6b600, 0xffe3c100, 0xffe9c300, 0xfff7c800, 0xfff9c801, 0xffe7b810, 0xff807653, 0xff6e6b62, 0xffa4a839, 0xffe4e50e, 0xffedd712, 0xffec2c5d, 0xfff2026d, 0xfff2006e, 0xfff20070, 0xfff10170, 0xffec1562, 0xffea3f4f, 0xfff0c016, 0xfff3ea07, 0xfff2f603, 0xffe1d203, 0xffd5be00, 0xffccac01, 0xffcbab02, 0xffccaa00, 0xffccaa02, 0xffcfae01, 0xffd1b000, 0xffdabb00, 0xffe1c001, 0xffedc501, 0xfff1c700, 0xfffdc702, 0xfff4bd0a, 0xff928247, 0xff6b6863, 0xff989b42, 0xffbdc323, 0xffece012, 0xffedb81e, 0xffe93757, 0xffed1169, 0xfff1006f, 0xffed0569, 0xffea345c, 0xffe86f42, 0xfff1e00c, 0xfff0f902, 0xffeaec02, 0xffd9c204, 0xffcfb401, 0xffcda900, 0xffcbaa03, 0xffcea900, 0xffd0b100, 0xffd3b500, 0xffdfbe00, 0xffe3c300, 0xfff1c701, 0xfffcc700, 0xffac9136, 0xff838651, 0xffc9d01e, 0xffe3e70e, 0xffe6a726, 0xffe56343, 0xffeb0c65, 0xffef096b, 0xffee235b, 0xffef982e, 0xfff2d017, 0xfff3fc03, 0xfff1fc00, 0xffe6e100, 0xffdccc00, 0xffceae01, 0xffcbab00, 0xffcdae00, 0xffeac302, 0xfff1c703, 0xfff9c800, 0xffe2b512, 0xff9b873e, 0xff7a7356, 0xffa0a638, 0xffdee50c, 0xffeaeb07, 0xffdf872e, 0xffdb3f4d, 0xffe40465, 0xffeb006b, 0xffef006a, 0xfff0006f, 0xfff3006e, 0xfff2016a, 0xffee1764, 0xffea434d, 0xfff1c615, 0xfff4ed09, 0xfff5fc00, 0xfff2f300, 0xffdfd001, 0xffd4bc00, 0xffdabb01, 0xffe2bf01, 0xffeec700, 0xfff9c802, 0xffbb9b2c, 0xff948147, 0xff6a6964, 0xfff1fa01, 0xffd69b1d, 0xffc04d38, 0xffb60651, 0xffbd0156, 0xffd1005e, 0xffda0061, 0xffe60168, 0xffe90167, 0xffec0e65, 0xffe86547, 0xffeca42b, 0xfff5f404, 0xffecef02, 0xffe3da01, 0xffd2b501, 0xffceac02, 0xffd3b602, 0xffd8ba00, 0xffe5c302, 0xffebc500, 0xfff6c600, 0xffebb90c, 0xffcea71b, 0xff86794f, 0xff6f6c5d, 0xffedf702, 0xfff3fe00, 0xfff2fb00, 0xffdbb814, 0xffc16c2c, 0xffa40b4c, 0xffa7024f, 0xffb60053, 0xffc00056, 0xffd40160, 0xffd90260, 0xffe60067, 0xffeb0069, 0xffed006a, 0xfff00969, 0xfff19c2f, 0xfff1d218, 0xfff4fa04, 0xfff3f901, 0xffe5e002, 0xffdcc900, 0xffcba901, 0xffcfaf02, 0xffd7b901, 0xffdcbd00, 0xffeac401, 0xfffdc703, 0xfff8c007, 0xffe7b70f, 0xff7f7456, 0xffd8e20f, 0xffe9e50a, 0xffd7ae1e, 0xffa42244, 0xff9d0848, 0xff9b004c, 0xffa5004c, 0xffa70050, 0xffb30052, 0xffd3005d, 0xffdb0162, 0xffe73952, 0xffed7334, 0xfff4e506, 0xfff2f600, 0xffeaea00, 0xffd6bf00, 0xffd0b101, 0xffd1b001, 0xffd6b601, 0xffe2bf03, 0xffe7c501, 0xfff8c802, 0xfffac400, 0xffd8af17, 0xffb29531, 0xff746f5c, 0xff686762, 0xffbbc224, 0xffecf602, 0xffe2ca12, 0xffac383b, 0xff9e0e4b, 0xff98004d, 0xff9a004b, 0xff9b014a, 0xff9c004a, 0xffa2004b, 0xffa80151, 0xffb70253, 0xffbf0157, 0xffd3005f, 0xffdc0060, 0xffe70365, 0xffea0e68, 0xffe56945, 0xffebab25, 0xfff5f403, 0xffedeb00, 0xffe5d800, 0xffd1b401, 0xffd4b600, 0xffdaba03, 0xffe6c401, 0xffecc601, 0xfffac600, 0xffcfa721, 0xff86794d, 0xff8e8f49, 0xffdbe610, 0xfff2fd00, 0xffefeb06, 0xffc16f26, 0xffa72d3c, 0xff98024a, 0xff980049, 0xff97014b, 0xff98024c, 0xff98004b, 0xff9c004e, 0xffa3004f, 0xffc01f49, 0xffd44f3c, 0xfff0cc14, 0xfff5ec07, 0xffeef200, 0xffddca01, 0xffd5b802, 0xffcba900, 0xffccac03, 0xffd0b003, 0xffd2b301, 0xffdcbd02, 0xffe2c102, 0xffefc501, 0xffefc207, 0xffbea028, 0xff988742, 0xff6d6a63, 0xff7f8152, 0xffced718, 0xffebf407, 0xfff1f403, 0xffcf9323, 0xffaf4839, 0xff9a044b, 0xff9a0049, 0xff9a004d, 0xff99014c, 0xff9c054c, 0xffb93f3c, 0xffd37f25, 0xfff2e908, 0xffeef602, 0xffe8e500, 0xffd5bc00, 0xffccae02, 0xffd5b701, 0xffe3c002, 0xffe8c104, 0xffd4b115, 0xffb39b2d, 0xff76715e, 0xffb2b530, 0xffd9e112, 0xfff4fd04, 0xffe5ce10, 0xffc88729, 0xff9d124b, 0xff99034b, 0xff970149, 0xff9c0c4a, 0xffa72b47, 0xffcfa221, 0xffe5d80e, 0xfff4fa02, 0xffe5db00, 0xffd9c600, 0xffd1b202, 0xffd2b704, 0xffc8b010, 0xff8c8244, 0xffa2a53c, 0xfff2fd03, 0xffece109, 0xffd4a61c, 0xffa21e43, 0xff990748, 0xff99014e, 0xffa32042, 0xffb55139, 0xffe4cf12, 0xffefef05, 0xffdcc901, 0xffd2b800, 0xffcdae06, 0xffc1a810, 0xff8e8041, 0xff83864f, 0xffabb231, 0xffecf504, 0xffe8d70b, 0xffb54d34, 0xffa01846, 0xff99014a, 0xff980549, 0xff9e104c, 0xffbe6f2d, 0xffd5b218, 0xfff2f800, 0xffeae901, 0xffe1d300, 0xffccac00, 0xffcaab03, 0xffcaaa00, 0xffcaa902, 0xffb69b16, 0xff9f8c2e, 0xff72705b, 0xff9b9f3e, 0xffe6ef0a, 0xffece906, 0xffbe6d2c, 0xffa62c41, 0xff99034d, 0xff9a0f4a, 0xffa62a46, 0xffd3a323, 0xffe7d710, 0xffe3d804, 0xffd8c403, 0xffc6a606, 0xffa28f28, 0xff897d41, 0xff6c6c60, 0xffcfd916, 0xffeaf407, 0xffd8b01b, 0xffba6433, 0xff9d084a, 0xff98054b, 0xffaf3f3b, 0xffca8123, 0xffeeeb06, 0xffeff201, 0xffe6e101, 0xffd2ba00, 0xffcaaa01, 0xffccab00, 0xffba9f10, 0xffa49321, 0xff787154, 0xff6d6a61, 0xff6a6965, 0xff767758, 0xffc2ca1f, 0xffe3ef09, 0xfff3ff00, 0xffe1c911, 0xffc58227, 0xff9f1048, 0xff99034a, 0xff9c1148, 0xffbd6d2e, 0xffd7b017, 0xffded000, 0xffcfb103, 0xffc8a606, 0xffa89223, 0xff8f833b, 0xff6d6960, 0xffcdd61b, 0xffdebc12, 0xffa62d3c, 0xff9c0c49, 0xffa31f44, 0xffb55235, 0xfff0f006, 0xfff2f900, 0xffdbc500, 0xffc9aa01, 0xffc0a30a, 0xffad971d, 0xff82764c, 0xff6f6c5b, 0xff696a65, 0xff939743, 0xffc0c624, 0xfff0fa03, 0xfff2f504, 0xffe5d50c, 0xffb04936, 0xffa21b43, 0xffaf4039, 0xffc78225, 0xffeee907, 0xfff4f803, 0xffeef100, 0xffe8df00, 0xffd2b801, 0xffcdaf00, 0xffc9ab00, 0xffb59a17, 0xff9d8930, 0xff686963, 0xff7c7d55, 0xffa0a23d, 0xffe9f108, 0xfff0f302, 0xffcb9626, 0xffba6934, 0xffd4a523, 0xffe7d70e, 0xfff1f700, 0xffdfd400, 0xffd6bf01, 0xffc7a706, 0xffba9d13, 0xff8d7f40, 0xff777255, 0xff73735b, 0xff929347, 0xffe2e70e, 0xfff0f804, 0xffddc318, 0xffd1a624, 0xffe5d415, 0xffecec00, 0xffd7c302, 0xffd1b400, 0xffcbaa00, 0xffcea902, 0xffcba802, 0xffbc9f13, 0xffa79026, 0xff787252, 0xff656567, 0xff696a64, 0xff7a7a58, 0xffc7ce20, 0xfff2f506, 0xffeae301, 0xffddcc00, 0xffceaf00, 0xffc8a903, 0xffbfa10d, 0xff938338, 0xff7d7550, 0xff73725e, 0xffb8be2a, 0xffdce512, 0xfff2ff02, 0xffe0d200, 0xffc1a40a, 0xffaf951c, 0xff7e754c, 0xff959942, 0xfff1fb04, 0xffeeee02, 0xffe6db03, 0xffc4a608, 0xff9e8b2d, 0xff867b45, 0xff696961, 0xff656563, 0xff67656a, 0xff888a4b, 0xffb1b82e, 0xffeef804, 0xfff1fc02, 0xffe5e000, 0xffddca02, 0xffc7a505, 0xffba9f12, 0xff887e43, 0xff767154, 0xff73755d, 0xff919642, 0xffe2ea0d, 0xfff0f900, 0xffebe702, 0xffc5a707, 0xff8e813b, 0xff6a6a60, 0xff666467, 0xff6e6f61, 0xff84884d, 0xffd8df13, 0xffebf403, 0xffeded03, 0xffe3d900, 0xffc8a807, 0xffbba110, 0xff90823b, 0xff797351, 0xff71735b, 0xffb8bc27, 0xffd9db0e, 0xffdccb01, 0xffd5b900, 0xffc9a805, 0xffb0981a, 0xff978634, 0xff6e6d5b, 0xff6d6e60, 0xffa3a537, 0xffc4c11c, 0xffd1bb05, 0xffceb002, 0xffc9a803, 0xffc3a507, 0xff9c8b31, 0xff84794b, 0xff787457, 0xff898349, 0xffa49226, 0xffac961f, 0xffc2a30b, 0xffcaa904, 0xffcdab03, 0xffb99f14, 0xffa69128, 0xff757156, 0xff847a47, 0xff8a7e42, 0xffa08e2c, 0xffab9420, 0xffbca010, 0xffc1a40b, 0xffcba804, 0xffcca903, 0xffc8a704, 0xff8e7e40, 0xff6e6a5e, 0xff736e5a, 0xff81794b, 0xff8a7e44, 0xffa99324, 0xffb99e11, 0xffc0a20e, 0xffbda10f, 0xffab9422, 0xff7a754d, 0xff6b6c5e, 0xff736e5b, 0xff7f764d, 0xff897c47, 0xff9c8c2d, 0xffa89225, 0xffb99d15, 0xffc9a801, 0xffcaa705, 0xff968638, 0xff6d6b5f, 0xff706d5e, 0xff7e764f, 0xff877c44, 0xffc6a508, 0xffcaa703, 0xffc3a60a, 0xffb79c19, 0xff857b46, 0xff716b5b, 0xff7b7551, 0xff998735, 0xffa6902a, 0xffc8a805, 0xffb89f0f, 0xffa58f29, 0xff756f57, 0xff7c7450, 0xff968537, 0xffa18d2a, 0xffb29918, 0xffbb9f10, 0xff8f803b, 0xff797255, 0xff928536, 0xffb1971c, 0xffb99e13, 0xffc3a708, 0xffbba10e, 0xffaa9323, 0xff7b7253, 0xff91833a, 0xff9d8a2e, 0xffb0981e, 0xffb89c15, 0xffc2a607, 0xffc9a604, 0xffc2a30d, 0xff988833, 0xff82774a, 0xff6d6b5e, 0xff7e774d, 0xff90813c, 0xff9d8932, 0xffaf971b, 0xffb89c14, 0xffbca10c, 0xff857b4a, 0xff66676b, 0xff747057, 0xff7c744f, 0xff847848, 0xff7e7651]
				); 
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}