/**
 * Copyright xshige ( http://wonderfl.net/user/xshige )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z5r6
 */

// forked from yuuganisakase's Fermat's Spiral
//
//you perceive that particles move to center but this is just illusion.
//move the slider to change the roatation speed.
//
//超高速回転させると吸い込んでいるように見える！
//

package 
{
	import com.bit101.components.Slider;
	import com.flashdynamix.motion.effects.core.ColorEffect;
	import com.flashdynamix.motion.effects.core.FilterEffect;
	import com.flashdynamix.motion.layers.BitmapLayer;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;


	[SWF(width=465, height=465, frameRate=60, backgroundColor=0x111111)]
	public class Spiral extends Sprite
	{
		private var theta:Number;
		private var holder:Sprite;
		private var layer:BitmapLayer;
		private var slider:Slider;
		private var g:Shape;
		private var rotationSpeed:Number = 0.05;
		private const BmSize:Number = 700;
		
		public function Spiral():void 
		{
 Wonderfl.capture_delay(9);
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);

			layer = new BitmapLayer(BmSize, BmSize,1,0x111111,false,true);
			layer.clearOnRender = false;
			//var bl:BlurFilter = new BlurFilter(4,4);
			//layer.add(new FilterEffect(bl));
			//layer.add(new ColorEffect(new ColorTransform(1, 1, 1, 0.9)));
			//addChild(layer);
			//layer.x = layer.y = - (BmSize / 10);
			holder = new Sprite();
			holder.x = holder.y = 465 / 2;
			
			addChild(holder);
			holder.addChild(layer);
			
			g = new Shape();
			
			slider = new Slider(Slider.HORIZONTAL, this, 10, 440, onClick);
			slider.setSize(150, 15);
			slider.value = 60;
			slider.backClick = true;
						
			theta = 0;
			onClick();
			addEventListener(Event.ENTER_FRAME, onEnter);
			stage.addEventListener(MouseEvent.MOUSE_UP, onClick);
		}
	
		private function drawFermat(c:Number = 0):void
		{
			
			if (c > 120) return;
			var r:Number;
			var p:Point;
			if (c >= 0) {
				r = 32 * Math.sqrt(c);
				p = Point.polar(r, c);
			}
			g.graphics.lineStyle(3, 0xffffff);
			g.graphics.drawCircle(p.x, p.y, 1);
			g.graphics.drawCircle( -p.x, -p.y, 1);
			layer.bitmapData.draw(g, new Matrix(1,0,0,1,BmSize/2, BmSize/2));
			g.graphics.clear();
		}
		private function rotate():void
		{
			holder.rotation += rotationSpeed;
		}
		private function onClick(e:Event = null):void 
		{
			
			layer.x = layer.y = -(BmSize)/2;
			//layer.bitmapData.fillRect(layer.bitmapData.rect, layer.bgColor);
			rotationSpeed = slider.value * 0.1;
			//theta = 0;
			
			g.graphics.clear();
			g.graphics.lineStyle(3, 0xffffff);
		}
		
		private function onEnter(e:Event):void 
		{
			drawFermat(theta);
			rotate();

			if (theta < 1) theta += 0.02;
			else theta += 0.1;
			
			
		}

	}
	
}