/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z5VI
 */

// forked from siouxcitizen's 「ツイート」ボタンと「リスタート」ボタンを追加しました
// forked from siouxcitizen's 今度は鋼板破壊できるようにしてみました
// forked from siouxcitizen's 某鋼板は256回攻撃しても破壊できないので避けてください
// forked from heart_thai's Roku Shooting Version
// forked from buccchi's オッス、おらロク！（墨エフェクト）
// forked from buccchi's オッス、おらロク！
//「ツイート」ボタンと「リスタート」ボタンを追加しました
//ごまかし？当たり判定付きでROKUに復活してもらいました
//当たり判定のために、プレイヤーROKUを囲むような形で当たり判定用ワイヤーフレームCubeを設定しました
//Zボタンでそのワイヤーフレーム表示のON・OFFができます
//
//操作方法
//・マウス左右操作で操作PaperPlaneオブジェクとが左右に移動
//・左クリック押下で攻撃弾発射
//・Zボタンで当たり判定用ワイヤーフレーム表示のON・OFFができます
//攻撃弾で鋼板を破壊？する毎にSCOREに100ポイント加算となります
//
//powers.splice(int(j), 1)のコメントアウトでエラーはなくなったようだけど、これでいいのだのうか。。。
package {
    import flash.display.Sprite;
    import flash.events.*;
    import flash.utils.Timer;
    import net.hires.debug.Stats;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.render.BasicRenderEngine;
    import org.papervision3d.lights.PointLight3D;
    import flash.text.*;
    import flash.net.URLRequest;
    import flash.net.navigateToURL;
    import flash.utils.escapeMultiByte;
    public class FlashTest extends Sprite {
        private var mountens:Vector.<DAE>;
        private var steelPlates:Vector.<Cube>;
        private var powers:Vector.<Sphere>
        private var player:DAE;
        private var playerCube:Cube;
        private var scene:Scene3D;
        private var camera:Camera3D;
        private var vp:Viewport3D;
        private var rd:BasicRenderEngine;
        private var tm:Timer;
        private var gameOver:Boolean = false;
        private var light:PointLight3D;
        private var flatShadeMate:FlatShadeMaterial;
        private var materials:MaterialsList;
        private var score:int = 0;
        private const PLATE_SIZE : int = 120; //鋼板Cubeの一辺のサイズ
        private const PLATE_THICK : int = 5; //鋼板Cubeの厚さ
        private var scoreTxt : TextField;//スコアテキスト
        private var scoreTxtFormat : TextFormat;//スコアテキストフォーマット
        private var gameOverTxt : TextField;//「ゲームオーバー」表示テキスト
        private var gameOverTxtFormat : TextFormat;//「ゲームオーバー」表示テキストフォーマット
        private var tweetBtn : CustomButton; //「ツイート」ボタン
        private var restartBtn : CustomButton; //「リスタート」ボタン
        private var wireframeState : Boolean = true; //
        public function FlashTest():void {
            addChild( new Stats() );
            scene = new Scene3D();
            camera = new Camera3D();
            rd = new BasicRenderEngine();
            vp = new Viewport3D(stage.stageWidth , stage.stageHeight );
            addChild(vp);
            camera.zoom = 50;
            
            //スコア文字列設定
            scoreTxt = new TextField;
            scoreTxt.text = "ButtonTest!";
            scoreTxt.x = 370;
            scoreTxt.y = 10;
            scoreTxt.width = 100;
            scoreTxt.multiline = true;
            scoreTxt.text = "SCORE: " + score;
            addChild(scoreTxt); 
            //スコア字列用フォーマット設定(デフォルト設定)
            //scoreTxtFormat = new TextFormat();
            //scoreTxtFormat.font = "Courier New";
            //scoreTxtFormat.bold = true;
            //scoreTxtFormat.size = 13;
            //scoreTxt.setTextFormat(scoreTxtFormat);
            //「GAME OVER」文字列設定
            gameOverTxt = new TextField;
            gameOverTxt.x = 55;
            gameOverTxt.y = 170;
            gameOverTxt.width = 400;
            gameOverTxt.height = 200;
            gameOverTxt.multiline = false;
            gameOverTxt.text = "GAME OVER";           
            //addChild(gameOverTxt);  
            //「GAME OVER」字列用フォーマット設定
            gameOverTxtFormat = new TextFormat();
            gameOverTxtFormat.font = "Courier New";
            gameOverTxtFormat.bold = true;
            gameOverTxtFormat.size = 70;
            gameOverTxt.setTextFormat(gameOverTxtFormat);

            //光源設定
            light = new PointLight3D();
            light.y = -8000;
            light.x = -8000;
            light.z = -8000;
            //鋼板用マテリアル設定
            flatShadeMate = new FlatShadeMaterial(light, 0xdddddd, 0x555555);
            flatShadeMate.doubleSided = true;
            materials = new MaterialsList(
                {front:flatShadeMate,back:flatShadeMate,right:flatShadeMate,left:flatShadeMate,top:flatShadeMate,bottom:flatShadeMate});

            createMouten();
            createSteelPlate();
            createPlayer();
            
            camera.y = 100; 
            
            powers = new Vector.<Sphere>();
            tm = new Timer(200);
            tm.addEventListener(TimerEvent.TIMER , shotting );
            
            tweetBtn = new CustomButton("Tweet");
            tweetBtn.x = 110;
            tweetBtn.y = 130;
            tweetBtn.addEventListener(MouseEvent.MOUSE_DOWN,onTweetBtnDown);
            restartBtn = new CustomButton("Restart");
            restartBtn.x = 260;
            restartBtn.y = 130;
            restartBtn.addEventListener(MouseEvent.MOUSE_DOWN,onRestartBtnDown);

            this.addEventListener(Event.ENTER_FRAME , loop);
            stage.addEventListener(MouseEvent.MOUSE_DOWN , shot );
            stage.addEventListener(MouseEvent.MOUSE_UP , stopShot );
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onKeyDown);
        }
        private function onTweetBtnDown(e:MouseEvent):void {
            var tweetMesseage:String = "SCORE: " + (score*100);
            var post:String = tweetMesseage + " " + "http://wonderfl.net/c/z5VI/" + " " + "#wonderfl ";
            navigateToURL(new URLRequest("http://twitter.com/home?status=" + escapeMultiByte(post)), "_blank");
        }
        private function onRestartBtnDown(e:MouseEvent):void {
            score = 0;
            scoreTxt.text = "SCORE: " + (score*100);  
            gameOver = false;
            removeChild(gameOverTxt);//「GAME OVER」文字列非表示
            removeChild(tweetBtn);
            removeChild(restartBtn);
        }
        private function shot(e:MouseEvent):void {
            tm.start();
        }
        private function stopShot(e:MouseEvent):void {
            tm.stop();
        }
        private function onKeyDown(e:KeyboardEvent):void {
            //Zコード押下時処理
            //プレイヤーROKUを囲むのワイヤーフレームON・OFFを行う
            if (e.keyCode == 90) {
                if (wireframeState) { //ワイヤーフレームON→ワイヤーフレームOFF
                    var wMate:WireframeMaterial = new WireframeMaterial(0xFF0000,0.0);
                    playerCube.material = wMate;
                    wireframeState = false;
                } else { //ワイヤーフレームOFF→ワイヤーフレームON
                    var wMate:WireframeMaterial = new WireframeMaterial(0xFF0000);
                    playerCube.material = wMate;
                    wireframeState = true;
                }
            }
        }
        private function shotting(e:TimerEvent):void {    
            var c:ColorMaterial = new ColorMaterial(0xFF0000,0.5);
            var p:Sphere = new Sphere( c , 50 );
            p.x = player.x;
            p.y = player.y + 50;
            p.z = player.z
            scene.addChild(p);
            powers.push(p);
        }
        private function createMouten():void {
            mountens = new Vector.<DAE>();
            for(var i:int = 0 ; i<=20 ; i++){
                var mountain:DAE = new DAE();
                mountain.load("http://7980.oui-imja.com/wonderfl/201002/mountain.dae");
                scene.addChild(mountain); 
                mountain.y = -100;
                mountain.scale = 10;
                mountain.x = 1000-(Math.random()*2000);
                mountain.z = 1000 - (Math.random() * 2000);
                mountens.push(mountain);
            }
                    
        }
        private function createSteelPlate():void {
            steelPlates = new Vector.<Cube>();
            for(var i:int = 0 ; i<=1 ; i++){
                var steelPlate:Cube = new Cube(materials,PLATE_SIZE,PLATE_THICK,PLATE_SIZE,1,1,1);
                scene.addChild(steelPlate); 
                steelPlate.y = 100;
                steelPlate.x = 1000-(Math.random()*2000);
                steelPlate.z = 1000 - (Math.random() * 2000);
                steelPlates.push(steelPlate);
            }
        }
        private function createPlayer():void{
            player = new DAE();
            player.load("http://7980.oui-imja.com/wonderfl/201002/roku.dae");
            scene.addChild(player);
            player.scale = 20;
            player.rotationY = 90;
            player.z = -700;
            
            var wMate:WireframeMaterial = new WireframeMaterial(0xFF0000);
            var mList:MaterialsList = new MaterialsList({front:wMate,back:wMate,right:wMate,left:wMate,top:wMate,bottom:wMate});

            //当たり判定のために、プレイヤーROKUを囲むような形で当たり判定用Cubeを設定
            playerCube = new Cube(mList,70,150,120,1,1,1);
            playerCube.x = player.x-10;
            playerCube.y = player.y+70;
            playerCube.z = player.z
            scene.addChild(playerCube);
        }
        private function loop(event:Event):void {
            if(gameOver){return;} //ゲームオーバー時は処理をストップ
            var sx:Number = (mouseX-(stage.stageWidth/2)) - player.x;
            player.x += sx/10;
            playerCube.x = player.x-10;
            for (var i:String in mountens) {
                mountens[i].z -= 50;
                if (mountens[i].z < -1000) {
                    mountens[i].z = 1000;
                    mountens[i].x = 1000-(Math.random()*2000);
                }
            }
            for (var j:uint=0;j<powers.length;j++){
                powers[j].z += 150;
                if (powers[j].z > 5000) {
                    scene.removeChild(powers[j]);
                    //powers.splice(int(j), 1);
                }
                for (var k:uint=0;k<steelPlates.length;k++){
                    if(powers[j].hitTestObject(steelPlates[k])) {
                        scene.removeChild(powers[j]);
                        //powers.splice(int(j), 1);
                        steelPlates[k].z = 1000;
                        steelPlates[k].x = 1000-(Math.random()*2000);
                        score++;
                        scoreTxt.text = "SCORE: " + (score*100);  
                    }
                }
            }
            for (i in steelPlates) {
                steelPlates[i].z -= 50;
                steelPlates[i].rotationX -= 20;
                //if (player.hitTestObject(steelPlates[i])) {
                if (playerCube.hitTestObject(steelPlates[i])) {
                    steelPlates[i].z = 1000;
                    steelPlates[i].x = 1000-(Math.random()*2000);
                    gameOver = true;
                    addChild(gameOverTxt);//「GAME OVER」文字列表示
                    addChild(tweetBtn);
                    addChild(restartBtn);
                    return;
                }
                if (steelPlates[i].z < -1000) {
                    steelPlates[i].z = 1000;
                    steelPlates[i].x = 1000-(Math.random()*2000);
                }
            }
            rd.renderScene(scene , camera, vp);
        }
    }
}

//■■■カスタムボタンクラス■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■■
import flash.display.*;
import flash.system.*;
import flash.text.*;
//カスタムボタン
class CustomButton extends SimpleButton {
    private var btnName : String = "";//ボタン名
    private var btnNo : int = 0;//ボタン番号
    //コンストラクタ    
    public function CustomButton(label:String="",no:int=0) {
        btnName = label;
        btnNo = no;
        //状態
        upState = makeSprite(label,0x00ff00);
        overState = upState;
        downState = makeSprite(label,0x0000ff);
        hitTestState = upState;
    }
    public function getBtnName():String {
        return btnName;
    }
    public function getBtnNo():int {
        return btnNo;
    }
    //ボタン用スプライト作成
    private function makeSprite(text:String,color:uint):Sprite{
        //ボタン用ラベル作成
        var label : TextField = new TextField();
        label.text = text;
        label.autoSize = TextFieldAutoSize.CENTER;
        label.selectable = false;
        //ボタン用スプライト作成
        var sp:Sprite = new Sprite();
        sp.graphics.beginFill(color);
        sp.graphics.drawRoundRect(0, 0, 100, 20, 15);
        sp.graphics.endFill();
        sp.alpha = 0.8;            
        sp.addChild(label);
        //ラベル用フォーマット設定
        var format:TextFormat=new TextFormat();
        format.font = "Courier New";
        format.bold = true;
        format.size = 13;
        label.setTextFormat(format);
        return sp;
    }
}