/**
 * Copyright ekis ( http://wonderfl.net/user/ekis )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z4g5
 */

// forked from rect's HoToPePaPiPuPo
//SiON noteOn Event
package
{
    import flash.display.*;
    import flash.events.*;
    import flash.utils.*;

    import org.papervision3d.*;
    import org.papervision3d.events.*;
    import org.papervision3d.view.*;
    import org.papervision3d.core.math.*;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.typography.*;
    import org.papervision3d.typography.fonts.HelveticaBold;
    import org.si.sion.*;
    import org.si.sion.events.*;
    import gs.*;

    [SWF(width="465", height="465", backgroundColor=0x000000, frameRate="60")]

    public class main extends BasicView
    {
        private const RADIAN:Number = Math.PI/180;
        private var driver:SiONDriver = new SiONDriver();
        private var setAlpha:Number = 0;
        private var letterMat:Letter3DMaterial;
        private var letterFont:HelveticaBold;
        private var typos:Vector.<Text3D> = new Vector.<Text3D>();
        private var bindNote:Vector.<int> = Vector.<int>([0,1,2,3,4,5,2,3,4,2,3,2,3,4,5,2,6,4,0,1,2,3,4,5,2,3,4,2,3,2,3,4,5,2,6]);
        private var words:Vector.<String> = Vector.<String>(["你", "好", "Pe", "Pa", "Pi", "Pu", "Po"]);
        private var wordsCount:int = 0;
        private var totalTypo:Number = 0;
        private const MAXLETTER:int = 15;

        public function main()
        {
            super (0,0,true,false,"Target");
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }

        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.quality = StageQuality.LOW;

            init3D();
            startRendering();
            TweenMax.from(this, 5,{ alpha:0});
            sionInit();
        }

        private function sionInit():void
        {
            var mml:String;
            mml ="#REV;t111;";
            mml +="#TABLE1{(128,100,20)10};";
            mml +="%9s32na1 v12 l8 %t0 $ec+ec+16ee16c+eg+ f+d+f+d+16f+f+16d+f+d+ <bg+bg+16bb16g+b>d+ ec+ec+16ee16c+er;";
            mml +="%6 @20 o5 v4 @v40 l8 @f60 [r1]4 $q2aaq6a.q2aa.q6a4 q2bbq6b.q2bb.q6b4 q2g+g+q6g+.q2g+g+.q6g+4 >q2c+c+q6c+.q2c+c+.q6c+4;";
            mml +="%6 @20 o5 v5 @v40 l8 @f60 k-2 [r1]4 $q2eeq6e.q2ee.q6e4 q2f+f+q6f+.q2f+f+.q6f+4 q2d+d+q6d+.q2d+d+.q6d+4 q2g+g+q6g+.q2g+g+.q6g+4;";
            mml +="%6 @20 o5 v5 @v40 l8 @f60 k2 [r1]4 $q2c+c+q6c+.q2c+c+.q6c+4 q2d+d+q6d+.q2d+d+.q6d+4 <q2bbq6b.q2bb.q6b4> q2c+c+q6c+.q2c+c+.q6c+4;";
            mml +="%6 @0 o3 v12 @v70 l8 [r1]3 r2.q8 a32a16*>a64&a8*<a64 q4 $aaq6a.q4aaa16aa bbq6b.q4bbb16bb g+g+q6g+.q4g+g+g+16g+b >c+c+c+c+16c+c+c+16<bb;";
            mml +="%6 @1 o3 v13 @v90 l8 q7 [r1]3 r2.c4 $ccr.cc16cr4;";
            mml +="%6 @2 o3 v22 @v30 l8 q8 [r1]3 r2r8(4e32)4e32e16e4 $r4e4r4e4;";
            mml +="%6 @3 @v40 v19 l16 o6 [r1]4 $c8cc c8cc;";
            mml +="%6 @5 @v60 v15 l8 o7 %t1 p5 [r1]3 r2.p3c4p5 $e1[r1]3 e1[r1]r2.p3c4p5;";
            mml +="#OPM@0{4, 7, 31, 11,  2,  0,  2, 28, 0, 0, 1, 0, 0, 31, 28,  2,  8,  0,  0, 0, 1, 0, 0, 0, 31, 18,  2,  0,  3, 20, 0, 0, 0, 0, 0, 31, 12,  2,  8,  1,  0, 0, 0, 1, 0, 0};";
            mml +="#OPM@1{5,  5, 31, 22, 10,  7, 10, 12, 0, 0, 0, 3, 0, 31, 15, 10,  0, 10,  0, 0, 0, 3, 2, 0, 31,  3, 10,  0,  8,  0, 0, 0, 0, 1, 0, 31, 15,  9,  0, 10, 10, 0, 0, 0, 0, 0} @lfo63 mp-200,-2000,1;";
            mml +="#OPM@2{4,  9, 31,  0, 10,  0,  0,  8, 1, 2, 7, 1, 1, 31, 18, 17, 15,  0,  0, 0, 9, 3, 0, 0, 31, 19,  0,  0, 10,  0, 0, 0, 7, 0, 0, 26, 10, 10,  5, 10,  0, 0, 0, 3, 1, 1} @lfo10 ma2,32,0,30;";
            mml +="#OPM@3{0,  7, 31,  8, 10, 10,  1, 38, 2,15, 0, 3, 0, 31,  8, 10, 14,  1, 38, 1,11, 0, 1, 0, 31,  5, 10, 14,  1,  8, 1, 9, 7, 1, 0, 31, 20, 10, 10, 10,  5, 1, 9, 3, 2, 0};";
            mml +="#OPM@5{4,  7, 31,  0,  2,  0,  1,  7, 0,  1, 7, 1, 2, 31,  9,  9,  1,  1,  5, 1,  1, 0, 0, 2, 31, 10,  5,  1,  1,  0, 0,  0, 3, 2, 1, 31, 10,  9,  1,  8,  9, 1,  8, 0, 0, 1} @lfo11 ma2,18,0,20;";
            mml +="#OPM@20{7,  5, 28,  2,  6,  8,  5,  5,  1,  2,  2, 0, 1, 28, 15,  6,  8,  3,  0,  0,  2,  5, 0, 2, 28,  0,  2,  8,  4,  2,  3,  6,  3, 0, 2, 28, 18,  0,  8,  0,  0,  0,  1,  7, 0, 3} @lfo13 ma3,48,4;";

            var playData:SiONData = driver.compile(mml);
            driver.addEventListener(SiONTrackEvent.NOTE_ON_FRAME, createTypo);
            driver.play(playData);
        }

        private function init3D():void
        {
            camera.fov = 55;
            var ct:DisplayObject3D = camera.target;
            ct.y = 300;
            
            var pixels:ByteArray = new ByteArray();
            pixels.writeInt(0xFFFFFF);
            pixels.writeInt(0x333333);
            pixels.writeInt(0x333333);
            pixels.writeInt(0xFFFFFF)
            pixels.position = 0;
            
            var bmd:BitmapData = new BitmapData(2,2,false);
            bmd.setPixels(bmd.rect, pixels);
            
            var floorMat:BitmapMaterial = new BitmapMaterial(bmd,true);
            floorMat.tiled = true;
            floorMat.maxU = 6, floorMat.maxV = 6;
            
            var objPlane:Plane = new Plane(floorMat, 1000, 1000, 2,2);
            scene.addChild(objPlane);
            objPlane.pitch(90);
            objPlane.meshSort = DisplayObject3D.MESH_SORT_FAR;
        }

        private function createTypo(e:SiONTrackEvent):void
        {
            if (e.note == 84)
            {
                for (var i:int = 0; i < totalTypo; i++)
                {
                    typos[i].extra.vy = 50;
                    typos[i].material.fillAlpha = 1;
                }
                setAlpha = 1;
            }
            else if (e.eventTriggerID == 0)
            {
                var r:Number = getTimer() * 2 * RADIAN;
                var vy:Number = (Math.random() * 0.08 + 0.92);
                var vx:Number = Math.sqrt(1 - vy * vy) * Math.cos(r);
                var vz:Number = Math.sqrt(1 - vy * vy) * Math.sin(r);
                var accel:Number = Math.random() * 3 + 42;
                vx *= accel * 0.4, vy *= accel, vz *= accel * 0.4;

                letterFont = new HelveticaBold();
                letterMat = new Letter3DMaterial(0x00CCFF, setAlpha);
                letterMat.doubleSided = true;
                var letter:Text3D = new Text3D(words[bindNote[Math.floor(wordsCount%35)]], letterFont, letterMat);
                letter.letterSpacing = -10;
                scene.addChild(letter);
                letter.y = 60, letter.scale = 1.2, letter.scaleX = -1.2;
                letter.extra = {vx:vx, vy:vy, vz:vz};
                typos.push(letter);
                
                wordsCount++;
                totalTypo++;
            }
        }

        private function updateTypo():void
        {
            for (var i:int = 0; i < totalTypo; i++)
            {
                typos[i].extra.vy -= 2;
                if (typos[i].y + typos[i].extra.vy < 50)
                {
                    typos[i].extra.vy = -typos[i].extra.vy * 0.5;
                    typos[i].x += typos[i].extra.vx;
                    typos[i].y += typos[i].extra.vy;
                    typos[i].z += typos[i].extra.vz;
                }
                typos[i].x += typos[i].extra.vx;
                typos[i].y += typos[i].extra.vy;
                typos[i].z += typos[i].extra.vz;
                
                typos[i].lookAt(camera);
                
                var rgb:int = typos[i].material.fillColor;
                typos[i].material.fillAlpha -= 0.005;
                
                if (totalTypo > MAXLETTER)
                {
                    scene.removeChild(typos[0]);
                    typos.shift();
                    totalTypo--;
                }
            }
        }

        override protected function onRenderTick(event:Event = null):void
        {
            var t:Number = getTimer();
            var s:Number = Math.max(-80,Math.min(-t*0.01,-30));
            camera.z = Math.sin(t * 0.001) * 200 + 800;
            camera.orbit(s, t*0.02, true, camera.target);
            
            updateTypo();
            super.onRenderTick(event);
        }
    }
}

