/**
 * Copyright amashio ( http://wonderfl.net/user/amashio )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z4aY
 */

/**
 * Copyright clockmaker ( http://wonderfl.net/user/clockmaker )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/c0Gi
 */
 
/**
 * Beatifl Code 1_11 P34
 */

package{
    
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.Rectangle;
    import flash.utils.Timer;
    import flash.events.TimerEvent;
    import flash.events.Event;
    import flash.display.Stage;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.geom.Point;
    import flash.geom.Matrix;
    
    import net.hires.debug.Stats;
    
    [SWF(width="465", height="465", backgroundColor="0xFFFFFF")]
    public class Main extends Sprite{
        
        private const NUM_PARTICLE:uint = 1000;
        private const ROT_STEPS:int = 120;//矢印の回転の数
        
        private var forceMap:BitmapData = new BitmapData( 233, 233, false, 0x000000 );
        private var randomSeed:uint = Math.floor( Math.random() * 0xFFFF );
        //particleを持っている配列
        private var particleList:Vector.<Arrow> = new Vector.<Arrow>(NUM_PARTICLE, true);
        private var rect:Rectangle = new Rectangle( 0, 0, 465, 465 );
        private var seed:Number = Math.floor( Math.random() * 0xFFFF );
        private var offset:Array = [new Point(), new Point()];
        private var timer:Timer;
        private var world:Sprite = new Sprite();
        //矢印を取り込んでいる配列
        private var rotArr:Vector.<BitmapData> = new Vector.<BitmapData>(ROT_STEPS, true);//Vector.<Class>(length, fixed)
        //fixedがtrueだと以下ができなくなる: 
        //length プロパティの直接的な設定,インデックス位置 length への値の割り当て,length プロパティを変更する以下のメソッドの呼び出し[pop(),push(),Shift(),unshift(),splice()]
        
        public function Main(){
            
            stage.align = StageAlign.TOP_LEFT;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.frameRate = 60;
            
            addChild(world);
            
            //
            resetFunc();
            
            //
            addEventListener(Event.ENTER_FRAME, loop);
            
            //
            var timer:Timer = new Timer(1000);
            timer.addEventListener(TimerEvent.TIMER, resetFunc);
            timer.start();
            
            //
            var dummy:Sprite = new Sprite();
            dummy.graphics.beginFill(0xFFFFFF, 1);
            dummy.graphics.lineStyle(1, 0x000000, 1);
            dummy.graphics.moveTo(2, 4);
            dummy.graphics.lineTo(8, 4);
            dummy.graphics.lineTo(8, 0);
            dummy.graphics.lineTo(20, 7);
            dummy.graphics.lineTo(8, 14);
            dummy.graphics.lineTo(8, 10);
            dummy.graphics.lineTo(2, 10);
            dummy.graphics.lineTo(2, 4);
            
            var matrix:Matrix;
            var i:int = ROT_STEPS;
            while(i--){
                matrix = new Matrix();
                //左上中心点を回転の中心にするためにズラす
                matrix.translate(-11, -11);//translate:(行列を x 軸と y 軸に沿って、dx パラメータと dy パラメータで指定された量だけ平行移動します)
                //回転させる
                matrix.rotate((360 / ROT_STEPS * i) * Math.PI / 180);
                //もとにもどす
                matrix.translate(11, 11);
                //「台紙」用意して　配列にいれる
                rotArr[i] = new BitmapData(22, 22, true, 0x000000);
                //描き出す
                rotArr[i].draw(dummy, matrix);
            }
            
            //初期配置
            for(i = 0; i < NUM_PARTICLE; i++){
                var px:Number = Math.random() * 465;
                var py:Number = Math.random() * 465;
                particleList[i] = new Arrow(px, py);
                world.addChild(particleList[i]);
            }
            
            //力場の確認
            addChild(new Bitmap(forceMap));
            
            addChild(new Stats());
        }
        
        //
        private function loop(event:Event):void{
            
            var len:uint = particleList.length;
            var col:Number;
            
            //particleのArrowの数だけ繰り返す
            for(var i:uint = 0; i < len; i++){
                
                //
                var arrow:Arrow = particleList[i];
                
                //今の位置を　古い値として　おいておく
                var oldX:Number = arrow.x;
                var oldY:Number = arrow.y;
                
                //力場の　矢印位置該当の色をとる
                col = forceMap.getPixel(arrow.x >> 1, arrow.y >> 1);
                //取得した色を計算して　加速度を求めて足し合わせる
                arrow.ax += ((col & 0xff) - 0x80) * 0.0005;
                arrow.ay += ((col >> 8 & 0xff) - 0x80) * 0.0005;
                //加速度を速度に足し合わせる
                arrow.vx += arrow.ax;
                arrow.vy += arrow.ay;
                //速度を位置に足し合わせる
                arrow.x += arrow.vx;
                arrow.y += arrow.vy;
                
                //位置を 別の値におく
                var _posX:Number = arrow.x;
                var _posY:Number = arrow.y;
                
                //今の位置と前回の位置を計算して方向を決めて　矢印の回転順を指定
                var rot:Number = - Math.atan2((_posX - oldX), (_posY - oldY)) * 180 / Math.PI + 90;
                //角度を導く
                var angle:int = rot / 360 * ROT_STEPS | 0;
                
                //角度から該当するBitmapDataを引く
                angle = (angle ^ (angle >> 31)) - (angle >> 31);
                arrow.rot += (angle - arrow.rot) * 0.2;
                arrow.bitmapData = rotArr[arrow.rot];
                
                //減衰させる
                arrow.ax *= 0.96;
                arrow.ay *= 0.96;
                arrow.vx *= 0.92;
                arrow.vy *= 0.92;
                
                // あと配置座標を整数化しておきます
                arrow.x = arrow.x | 0;
                arrow.y = arrow.y | 0;
                
                //ロールアップ
                ( _posX > 465 ) ? arrow.x = 0 :
                    ( _posX < 0 ) ? arrow.x = 465 : 0;
                ( _posY > 465 ) ? arrow.y = 0 :
                    ( _posY < 0 ) ? arrow.y = 465 : 0;

            }
            
            
        }
        
        
        private function resetFunc(event:Event = null):void{
            
            forceMap.perlinNoise(117, 117, 3, seed, false, true, 6, false, offset);
            
            offset[0].x += 1.5;
            offset[1].y += 1;
            seed = Math.floor(Math.random() * 0xFFFFFF);
        }
    }
}

import flash.display.Bitmap;

class Arrow extends Bitmap{
    
    public var rot:int = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var ax:Number = 0;
    public var ay:Number = 0;
    
    public function Arrow(x:Number, y:Number){
        this.x = x;
        this.y = y;
    }
}