/**
 * Copyright ohisama ( http://wonderfl.net/user/ohisama )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z47a
 */

//blog-imgs-24.fc2.com/n/i/d/nidacreblog
package 
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.Point;
    import flash.utils.Timer;
    import Box2D.Collision.*;
    import Box2D.Collision.Shapes.*;
    import Box2D.Common.Math.*;
    import Box2D.Dynamics.*;
    import Box2D.Dynamics.Joints.*;
    [SWF(width = "475", height = "475", frameRate = "30", backgroundColor = "#FFFFFF")]
    public class Main extends Sprite 
    {
        static private const ITERATION : Number = 10;       
        static private const TIME_STEP : Number = 1.0 / 30.0;
        static private const PHYS_SCALE : Number = 30;     
        static private const BALL_NUM : int = 9;           
        private var world : b2World;   
        private var centerX : Number;
        private var centerY : Number;
        private var canvas : Sprite = new Sprite();
        private var bmd : BitmapData;
        public function Main() : void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        private function init(e : Event = null) : void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.frameRate = 30;
            initBox2D();
            addChild(canvas);
            bmd = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0x00FFFFFF);
            bmd.draw(canvas);
            var bm : Bitmap = new Bitmap(bmd);
            addChild(bm);
            addEventListener(Event.ENTER_FRAME, enterframeHandler);
        }
        private function initBox2D() : void 
        {
            centerX = stage.stageWidth / 2 / PHYS_SCALE;
            centerY = stage.stageHeight / 2 / PHYS_SCALE;
            var worldAABB : b2AABB = new b2AABB();
            worldAABB.lowerBound.Set(-100, -100);
            worldAABB.upperBound.Set(100, 100);
            var gravity : b2Vec2 = new b2Vec2(0, -0.1);
            world = new b2World(worldAABB, gravity, true);
            makeFrameBox();
            var timer : Timer = new Timer(50, BALL_NUM);
            timer.addEventListener(TimerEvent.TIMER, makeBall);
            timer.start();
        }
        private function enterframeHandler(e : Event) : void 
        {
            for (var bb : b2Body = world.m_bodyList; bb; bb = bb.m_next) 
            {
                if (bb.m_userData is Sprite) 
                {
                    bb.m_userData.x = bb.GetPosition().x * PHYS_SCALE;
                    bb.m_userData.y = bb.GetPosition().y * PHYS_SCALE;
                    bb.m_userData.rotation = bb.GetAngle() * (180 / Math.PI);    // ラジアンを度に変換
                }
            }
            bmd.draw(canvas);
            bmd.applyFilter(bmd, bmd.rect, new Point(0, 0), new BlurFilter(8, 8, 2));
            world.Step(TIME_STEP, ITERATION);
        }
        private function makeFrameBox() : void 
        {
            var bodyTop : b2BodyDef = new b2BodyDef();
            bodyTop.position.Set(centerX, 0);
            var topShapeDef : b2PolygonDef = new b2PolygonDef();
            topShapeDef.SetAsBox(centerX, 0.2);
            topShapeDef.density = 0;    
            var bodyBottom : b2BodyDef = new b2BodyDef();
            bodyBottom.position.Set(centerX, centerY * 2);
            var BottomShapeDef : b2PolygonDef = new b2PolygonDef();
            BottomShapeDef.SetAsBox(centerX, 0.2);
            BottomShapeDef.density = 0; 
            var bodyRight : b2BodyDef = new b2BodyDef();
            bodyRight.position.Set(centerX * 2, centerY);
            bodyRight.angle = Math.PI;
            var rightShapeDef : b2PolygonDef = new b2PolygonDef();
            rightShapeDef.SetAsBox(0.2, centerY);
            rightShapeDef.density = 0;  
            var bodyLeft : b2BodyDef = new b2BodyDef();
            bodyLeft.position.Set(0, centerY);
            bodyLeft.angle = Math.PI;
            var leftShapeDef : b2PolygonDef = new b2PolygonDef();
            leftShapeDef.SetAsBox(0.2, centerY);
            leftShapeDef.density = 0;   
            var top : b2Body = world.CreateBody(bodyTop);
            top.CreateShape(topShapeDef);
            var bottom : b2Body = world.CreateBody(bodyBottom);
            bottom.CreateShape(BottomShapeDef);
            var right : b2Body = world.CreateBody(bodyRight);
            right.CreateShape(rightShapeDef);
            var left : b2Body = world.CreateBody(bodyLeft);
            left.CreateShape(leftShapeDef);
        }
        private function makeBall(e : TimerEvent) : void 
        {
            var bodyDef : b2BodyDef = new b2BodyDef();
            var adjustX : Number = Math.random() * 3 - 1.5;
            var adjustY : Number = Math.random() * 3 - 1.5;
            bodyDef.position.Set(centerX + adjustX, centerY + adjustY);
            var shapeDef : b2CircleDef = new b2CircleDef();
            shapeDef.radius = Math.max(Math.random() * 2.4, 1);
            shapeDef.density = 1;   
            shapeDef.restitution = 0.8; 
            bodyDef.userData = makeBallGraphics(shapeDef.radius);
            bodyDef.userData.x = bodyDef.position.x * PHYS_SCALE;
            bodyDef.userData.y = bodyDef.position.y * PHYS_SCALE;
            var ball : b2Body = world.CreateBody(bodyDef);
            ball.CreateShape(shapeDef);
            ball.SetMassFromShapes();
        }
        private function makeBallGraphics(radius : Number) : Sprite 
        {
            var sp : Sprite = new Sprite();
            var color : uint = Math.random() * 0x999999 + 0x666666;
            sp.graphics.lineStyle(1.0, color);
            sp.graphics.drawCircle(0, 0, radius * PHYS_SCALE);
            sp.graphics.endFill();
            canvas.addChild(sp);
            return sp;
        }
    }
}
