/**
 * Copyright 883108 ( http://wonderfl.net/user/883108 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z3jF
 */

package {
    import flash.display.Sprite;
    public class SinWaveDocument extends Sprite {
		public function SinWaveDocument() {
			init();
		}


		private function init():void {
			addChild(new StageLine(stage));

			for (var i:Number = 0; i<= 2 * Math.PI; i += 0.1) {
				var pointX:Number = i / (2 * Math.PI) * stage.stageWidth;
				var pointY:Number = Math.sin(i) * (stage.stageHeight/2) + (stage.stageHeight/2);
				var point:Sprite = new Sprite();
				addChild(point);
				point.graphics.beginFill(0x888888);
				point.graphics.drawCircle(pointX, pointY, 2);
				point.graphics.endFill();				
			}
		}
    }
}

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFormat;
import flash.display.Stage;

class StageLine extends Sprite {
	private var _line:Sprite;
	function StageLine($stage:Stage) {
		init($stage);
	}

	internal function init($stage:Stage):void {
		var stageWidth:Number=$stage.stageWidth;
		var stageHeight:Number=$stage.stageHeight;

		graphics.beginFill(0xcccccc);
		graphics.lineStyle(0, 0xaaaaaa);
		graphics.moveTo(0, stageHeight/2);
		graphics.lineTo(stageWidth, stageHeight/2);
		graphics.moveTo(0, 0);
		graphics.lineTo(0, stageHeight);
		graphics.endFill();

		for (var i:uint=0; i<=4; i++) {
			var tex:TextField = new TextField();
			tex.x = (stageWidth / 4) * i;
			tex.y=stageHeight/2;
			tex.text = (i * 90) + '°';
			addChild(tex);
		}
		var texTop:TextField = new TextField();
		texTop.x=0;
		texTop.y=0;
		texTop.text=(-Math.sin(Math.PI/2)).toString();
		addChild(texTop);

		var texBottom:TextField = new TextField();
		texBottom.x=0;
		texBottom.y=stageHeight;
		texBottom.text=(-Math.sin(Math.PI*3/2)).toString();
		addChild(texBottom);
		
		var caution:TextField = new TextField();
		caution.x = 20;
		caution.width = stageWidth - 20;
		caution.text = 'flashにおいて、y系の座標は上がマイナスな事に注意してください。'
		
		addChild(caution);
		var caution_format:TextFormat = new TextFormat();
		caution_format.color = 0xc20000;
		caution.setTextFormat(caution_format);
	}
}