/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z3Hr
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class PentagonalStar extends Sprite
	{
		private var _star:Sprite;
		
		public function PentagonalStar()
		{
			_star = new Sprite();
			_star.graphics.lineStyle(2,0xFF0000,0.6);

			_star.x = 200;
			_star.y = 200;
			_star.graphics.moveTo(100 * Math.cos(72 * Math.PI / 180),
													100 * Math.sin(72 * Math.PI / 180));
			// 順番に角度72の倍数ずつ、順番に頂点をずらしていくと正五角形になるが、ここで欲しいのは
			// 星型なので、頂点を一つ飛ばしでラインを書いていく。なのでfor文のインクリメントは2の倍数
			for (var i:int = 0; i < 5; i += 2)
			{
				_star.graphics.lineTo(100 * Math.cos((72 + 72 * i) * Math.PI / 180 ),
										100 * Math.sin((72 + 72 * i) * Math.PI / 180));
			}
			// 上記の理由によりfor文のインクリメントは奇数
			for (var i:int = 1; i < 6; i += 2)
			{
				_star.graphics.lineTo(100 * Math.cos((72 + 72 * i) * Math.PI / 180 ), 
										100 * Math.sin((72 + 72 * i) * Math.PI / 180));	
			}
			
			addChild(_star);
			
			addEventListener(Event.ENTER_FRAME, rotate, false, 0, true);
		}
		
		private function rotate(e:Event):void
		{
			this._star.rotation += 3;
		}
	}
}