/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z3F3
 */

package
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(frameRate=60, width=465, height=465)]
    public class Main extends Sprite
    {
        protected var dataField :DataField;
        
        internal var panelA :Panel;
        internal var buttonA :Button;
        
        public function Main()
        {
            graphics.clear();
            graphics.beginFill(0xDDDDDD);
            graphics.drawRect(0, 0, stage.stageWidth, stage.stageHeight);
            graphics.endFill();
            
            dataField = new DataField("-");
            
            panelA = new Panel();
            buttonA = new Button();
            
            addEventListener(Event.ADDED_TO_STAGE, addedToStage);
        }
        
        private function addedToStage($e:*) :void
        {
            removeEventListener(Event.ADDED_TO_STAGE, addedToStage);

            addChild(panelA);
            panelA.addChild(buttonA);
            
            addChild(dataField);
            
            init();
        }
        
        private function init() :void
        {
            Util.centerSprite(panelA);
            Util.centerSprite(buttonA);
            
            //dataField.text = "";
        }
    }
}

import flash.display.Sprite;
import flash.events.*;
import flash.text.*;

class Util
{
    public static function centerSprite($obj:Object) :void
    {
        var $parent :Object = $obj.parent;
        
        $obj.x = (($parent.width/2) - ($obj.width/2));
        $obj.y = (($parent.height/2) - ($obj.height/2));
    }
}

class Panel extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _w :Number;
    protected var _h :Number;
    protected var _c :Number;
    protected var _a :Number;
        
    public function Panel($x:Number = 0, $y:Number = 0, $w:Number = 400, $h:Number = 300, $c:Number = 0xAAAAAA, $a:Number = 1)
    {
        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        _c = $c;
        _a = $a;
            
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
        
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        init();
    }
        
    private function init() :void
    {
        graphics.clear();
        graphics.beginFill(color, alpha);
        graphics.drawRoundRect(x, y, width, height, 16, 16);
        graphics.endFill();
    }
        
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get width() :Number
    { return _w }
    public override function get height() :Number
    { return _h }
    public function get color() :Number
    { return _c }
    public override function get alpha() :Number
    { return _a }
        
    public override function set x($:Number) :void
    { _x = $; init() }
    public override function set y($:Number) :void
    { _y = $; init() }
    public override function set width($:Number) :void
    { _w = $; init() }
    public override function set height($:Number) :void
    { _h = $; init() }
    public function set color($:Number) :void
    { _c = $; init() }
    public override function set alpha($:Number) :void
    { _a = $; init() }
}

class Button extends Sprite
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _w :Number;
    protected var _h :Number;
    protected var _c :Number;
    protected var _a :Number;
        
    public function Button($x:Number = 0, $y:Number = 0, $w:Number = 100, $h:Number = 30, $c:Number = 0xCCCCCC, $a:Number = 1)
    {
        _x = $x;
        _y = $y;
        _w = $w;
        _h = $h;
        _c = $c;
        _a = $a;
            
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
        
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
            
        init();
        
        addEventListener(MouseEvent.MOUSE_OVER, mouseOver);
        addEventListener(MouseEvent.MOUSE_OUT, mouseOut);
        addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
        addEventListener(MouseEvent.MOUSE_UP, mouseUp);
    }
        
    private function init() :void
    {
        graphics.clear();
        graphics.beginFill(color, alpha);
        graphics.drawRoundRect(x, y, width, height, 8, 8);
        graphics.endFill();
    }
    
    private function mouseOver($e:MouseEvent) :void
    { color ^= (color/4) }
    private function mouseOut($e:MouseEvent) :void
    { color = 0xCCCCCC }
    private function mouseDown($e:MouseEvent) :void
    {}
    private function mouseUp($e:MouseEvent) :void
    {}
        
    public override function get x() :Number
    { return _x }
    public override function get y() :Number
    { return _y }
    public override function get width() :Number
    { return _w }
    public override function get height() :Number
    { return _h }
    public function get color() :Number
    { return _c }
    public override function get alpha() :Number
    { return _a }
        
    public override function set x($:Number) :void
    { _x = (parent.x + $); init() }
    public override function set y($:Number) :void
    { _y = (parent.y + $); init() }
    public override function set width($:Number) :void
    { _w = $; init() }
    public override function set height($:Number) :void
    { _h = $; init() }
    public function set color($:Number) :void
    { _c = $; init() }
    public override function set alpha($:Number) :void
    { _a = $; init() }
}

class DataField extends TextField
{
    protected var _x :Number;
    protected var _y :Number;
    protected var _font :String;
    protected var _data :String;
    
    public function DataField($data:String = "", $x:Number = 4, $y:Number = 2, $font:String = "Consolas")
    {
        _x = $x;
        _y = $y;
        _font = $font;
        _data = $data;
        
        addEventListener(Event.ADDED_TO_STAGE, addedToStage);
    }
        
    private function addedToStage($e:*) :void
    {
        removeEventListener(Event.ADDED_TO_STAGE, addedToStage);
        
        multiline = true;
        autoSize = "left";
        selectable = false;
        
        init();
    }
        
    private function init() :void
    {
        x = _x;
        y = _y;
        text = _data;
        
        setTextFormat(new TextFormat(font, null, 0));
    }
        
    public function get font() :String
    { return _font }
    
    public function set font($:String) :void
    { _font = $; setTextFormat(new TextFormat(font, null, 0)) }
    public override function set text($:String) :void
    { super.text = $; setTextFormat(new TextFormat(font, null, 0)) }
}