/**
 * Copyright mesomeso ( http://wonderfl.net/user/mesomeso )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z2Jj
 */

// forked from Aquioux's graphics.drawPath の練習(7)
// forked from Aquioux's graphics.drawPath の練習(6)
package {
	
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.display.GraphicsPathCommand;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.geom.Point;
	import caurina.transitions.Tweener;
	[SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#FFFFFF")]
	
	/**
	 * graphics.drawPath を使った作品もどき 2
	 * ステージクリックで変形
	 * @author Yoshida, Akio
	 */
	public class Main extends Sprite {
		
		private var canvasShape:Shape;			// キャンバス
		private var commandVector:Vector.<int>;		// drawPath の第1引数
		private var dataVector:Vector.<Number>;		// drawPath の第2引数
		private var coordinateVector:Vector.<Coordinate>;	// Tweener 用
		private const NUM_OF_LINE:uint = 7;		// 線数（実際に引きたい線の数+1）
		
		
		public function Main() {
			mouseChildren = false;
			
			init();
			
			stage.addEventListener(MouseEvent.CLICK, clickHandler);
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		
		// 初期化
		private function init():void {
			// キャンバス生成
			canvasShape = new Shape();
			addChild(canvasShape);
			
			// drawPath 第1引数
			var num:uint = NUM_OF_LINE;
			commandVector = new Vector.<int>(num, true);
			// commandVector の要素を定義
			commandVector[0] = GraphicsPathCommand.MOVE_TO;
			for (var i:uint = 1; i < num; i++) {
				commandVector[i] = GraphicsPathCommand.CURVE_TO;
			}
			
			// drawPath 第2引数
			// X、Y 座標なので線の数の二倍の二倍
			// ただし最後の二つは最初の二つと同じ
			num = NUM_OF_LINE * 4;
			dataVector       = new Vector.<Number>(num, true);
			coordinateVector = new Vector.<Coordinate>(num, true);

			// coordinateVector の要素を初期化
			num = NUM_OF_LINE * 2;
			var angle:Number = 360 / (num - 2);
			var longDistance:uint  = 250;
			var shortDistance:uint = 100;
			var distance:uint;
			var cx:uint = stage.stageWidth  / 2;
			var cy:uint = stage.stageHeight / 2;
			for (i = 0; i < num - 1; i++) {
				var coordinateX:Coordinate = coordinateVector[i * 2]     = new Coordinate();
				var coordinateY:Coordinate = coordinateVector[i * 2 + 1] = new Coordinate();
				distance = (i % 2) ? longDistance : shortDistance;
				var radian:Number = angle * i * Math.PI / 180;
				coordinateX.value = Math.cos(radian) * distance + cx;
				coordinateY.value = Math.sin(radian) * distance + cy;
			}
			coordinateVector[i * 2]     = coordinateVector[0];
			coordinateVector[i * 2 + 1] = coordinateVector[1];
		}
		
		
		// マウスクリックハンドラ
		private function clickHandler(event:MouseEvent):void {
			var w:uint = stage.stageWidth;
			var h:uint = stage.stageHeight;
			var margin:uint = 25;
			var num:uint = (NUM_OF_LINE - 1) * 2;
			for (var i:uint = 0; i < num; i++) {
				var idxX:uint = i * 2;
				var idxY:uint = i * 2 + 1;
				var coordinateX:Coordinate = coordinateVector[idxX];
				var coordinateY:Coordinate = coordinateVector[idxY];
				var valueX:Number = Math.random() * (w - margin * 2) + margin;
				var valueY:Number = Math.random() * (h - margin * 2) + margin;
				Tweener.addTween(coordinateX, {
					value:valueX,
					time:2.5,
					delay:idxX * 0.02,
					transition:"easeOutElastic"
				});
				Tweener.addTween(coordinateY, {
					value:valueY,
					time:2.5,
					delay:idxY * 0.02,
					transition:"easeOutElastic"
				});
			}
		}
		
		// ENTE_FRAME ハンドラ
		private function enterFrameHandler(e:Event):void {
			draw();
		}
		
		// 描画
		private function draw():void {
			// dataVector 定義
			var num:uint = NUM_OF_LINE * 2;
			for (var i:uint = 0; i < num; i++) {
				var idxX:uint = i * 2;
				var idxY:uint = i * 2 + 1;
				dataVector[idxX] = coordinateVector[idxX].value;
				dataVector[idxY] = coordinateVector[idxY].value;
			}
			// 描画
			canvasShape.graphics.clear();
			canvasShape.graphics.beginFill(0xFF6699, 1);
			canvasShape.graphics.drawPath(commandVector, dataVector);
			canvasShape.graphics.endFill();
		}
		
	}
	
}

class Coordinate {
	public var value:Number = 0.0;
	public function Coordinate() {}
}

