/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z1NM
 */

// forked from wh0's resource uncompress
// forked from wh0's minimalcomps procedural console
package {
    import flash.display.*;
    import flash.events.*;
    import flash.geom.*;
    import flash.net.*;
    import flash.system.*;
    import flash.text.*;
    import flash.utils.*;
    
    import com.actionscriptbible.Example;
    import com.bit101.components.*;
    public class FlashTest extends Example {
        
        private static const VERSION:String = '0.42.4';
        private static const BASE:String = 'http://static-cdn.playfish.com/game/cooking/swf/';
        private static const PATH:String = BASE + VERSION + '/';
        private static const HERE:LoaderContext = new LoaderContext(false, ApplicationDomain.currentDomain);
        
        private const FORMAT:TextFormat = new TextFormat();
        private var bars:Sprite;
        private var xmlRemain:Boolean = true;
        private var swfRemain:int = 0;
        private var items:XMLList;
        
        public function FlashTest() {
            loaderInfo.uncaughtErrorEvents.addEventListener(UncaughtErrorEvent.UNCAUGHT_ERROR, error);
            FORMAT.align = 'center';
            FORMAT.font = 'Calibri';
            FORMAT.size = 10;
            addChild(bars = new Sprite());
            new Label(bars, 108, 0, VERSION);
            
            var p:ProgressBar = new ProgressBar(bars, 4, 4);
            var x:URLLoader = new URLLoader(new URLRequest(PATH + 'restaurant.bin'));
            x.dataFormat = URLLoaderDataFormat.BINARY;
            x.addEventListener(Event.COMPLETE, xml);
            x.addEventListener(ProgressEvent.PROGRESS, function(e:ProgressEvent):void { p.maximum = e.bytesTotal; p.value = e.bytesLoaded });
            
            loadSwf('indoor_asset.swf');
            loadSwf('indoor_asset2.swf');
            loadSwf('indoor_asset3.swf');
        }
        
        private function loadSwf(name:String):void {
            var p:ProgressBar = new ProgressBar(bars, 4, 4 + 14 * ++swfRemain);
            var s:URLLoader = new URLLoader(new URLRequest(PATH + name));
            s.dataFormat = URLLoaderDataFormat.BINARY;
            s.addEventListener(Event.COMPLETE, swf_data);
            s.addEventListener(ProgressEvent.PROGRESS, function(e:ProgressEvent):void { p.maximum = e.bytesTotal; p.value = e.bytesLoaded });
        }
        
        private function error(e:UncaughtErrorEvent):void {
            trace(e.error);
        }
        
        private function xml(e:Event):void {
            var data:ByteArray = e.target.data as ByteArray;
            data.uncompress();
            items = new XML(data.toString())..item;
            xmlRemain = false;
            if (!swfRemain) render();
        }
        
        private function swf_data(e:Event):void {
            var data:ByteArray = e.target.data as ByteArray;
            var s:Loader = new Loader();
            s.contentLoaderInfo.addEventListener(Event.COMPLETE, swf);
            s.loadBytes(data, HERE);
        }
        
        private function swf(e:Event):void {
            if (!--swfRemain && !xmlRemain) render();
        }
        
        private function render():void {
            removeChild(bars);
            bars = null;
            stage.addEventListener(MouseEvent.MOUSE_WHEEL, function(e:MouseEvent):void { y += 31 * e.delta });
            var i:int = 0;
            var row:int = 0;
            while (true) {
                for (var col:int = 0; col < 5; col++) {
                    if (i >= items.length()) return;
                    var item:XML = items[i++];
                    try {
                        var C:Class = ApplicationDomain.currentDomain.getDefinition(item.@className) as Class;
                        var d:MovieClip = new C();
                        d.stop();
                        d.x = col * 93 + 46;
                        d.y = row * 93 + 40;
                        addChild(d);
                    } catch (e:Error) {}
                    var t:TextField = new TextField();
                    t.width = 93;
                    t.height = 20;
                    t.text = item.@name;
                    t.setTextFormat(FORMAT);
                    t.x = col * 93;
                    t.y = row * 93 + 73;
                    addChild(t);
                }
                row++;
            }
        }
        
    }
}