/**
 * Copyright wakuworks ( http://wonderfl.net/user/wakuworks )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/z0QE
 */

/**
 * URL を解析します。
 * 
 * IDNA 制作時の副産物。と言っても単なる移植
 * 
 * URLParser is freely distributable under the terms of an MIT-style license.
 *
 * The orignal code: https://code.poly9.com/trac/browser/urlparser/urlparser.js
 *
 * http://poly9.com
 * http://www.twinapex.com
 * 
 * @see http://snipplr.com/view/10139/urlparse--pythonlike-url-parser-and-manipulator/ 
 */
package
{
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.text.TextFieldType;
    import flash.events.Event;
    
    public class FlashTest extends Sprite
    {
        public static const DEFAULT_URL:String = "http://user:pass@hoge.jp:80/hoge?a=1#top";
        public static const PADDING:uint = 10;
        public static const DIF:uint = 4;
        
        private var _textWidth:Number;
        private var _url_txt:TextField;
        private var _url_label_txt:TextField;
        private var _result_txt:TextField;
        private var _result_label_txt:TextField;
        private var _parser:URLParser;
        
        public function FlashTest()
        {
            _textWidth = stage.stageWidth - PADDING * 2;
            _createURLText();
            _createResultText();
            _parser = new URLParser(DEFAULT_URL);
            _displayResult();
        }
        
        private function _createURLText():void
        {
            _createURLLabel();
            
            var _txt:TextField = new TextField();
            _txt.text = DEFAULT_URL;
            _txt.type = TextFieldType.INPUT;
            _txt.border = true;
            _txt.borderColor = 0xCCCCCC;
            _txt.x = PADDING;
            _txt.y = PADDING + _url_label_txt.textHeight + DIF;
            _txt.width = _textWidth;
            _txt.height = _txt.textHeight + DIF;
            _txt.addEventListener(Event.CHANGE, _changeHandler);
            addChild(_txt);
            _url_txt = _txt;
        }
        
        private function _createURLLabel():void
        {
            var _txt:TextField = new TextField();
            _txt.selectable = false;
            _txt.text = "URL:";
            _txt.x = PADDING;
            _txt.y = PADDING;
            _txt.width = _textWidth;
            _txt.height = _txt.textHeight + DIF;
            addChild(_txt);
            _url_label_txt = _txt;
        }

        private function _createResultText():void
        {
            _createResultLabel();
            
            var _txt:TextField = new TextField();
            _txt.border = true;
            _txt.borderColor = 0xCCCCCC;
            _txt.x = PADDING;
            _txt.y = _result_label_txt.height + _result_label_txt.y + DIF;
            _txt.width = _textWidth;
            _txt.height = stage.stageHeight - _txt.y - PADDING;
            addChild(_txt);
            _result_txt = _txt;
        }
        
        private function _createResultLabel():void
        {
            var _txt:TextField = new TextField();
            _txt.selectable = false;
            _txt.text = "結果：（上で入力された URL の解析結果を表示します）";
            _txt.x = PADDING;
            _txt.y = 60;
            _txt.width = _textWidth;
            _txt.height = _txt.textHeight + DIF;
            addChild(_txt);
            _result_label_txt = _txt;
        }
        
        private function _displayResult():void
        {
            var result:String = "";
            result += "スキーマ\t\t：" + _parser.scheme + "\n"
            result += "ホスト\t\t：" + _parser.host + "\n";
            result += "ポート\t\t：" + _parser.port + "\n";
            result += "ユーザー名\t：" + _parser.user + "\n";
            result += "パスワード\t：" + _parser.pass + "\n";
            result += "パス\t\t\t：" + _parser.path + "\n";
            result += "クエリ\t\t：" + _parser.query + "\n";
            result += "フラグメント\t：" + _parser.fragment;
            _result_txt.text = result;
        }
        
        private function _changeHandler(e:Event):void
        {
            _parser.url = e.target.text;
            _displayResult();
        }
    }
}

class URLParser
{
    private static const _fields:Object = {
        "scheme": 2,
        "host": 6,
        "port": 7,
        "user": 4,
        "pass": 5,
        "path": 8,
        "query": 9,
        "fragment": 10
    };
    private static const _regex:RegExp = /^((\w+):\/\/)?((\w+):?(\w+)?@)?([^\/\?:]+):?(\d+)?(\/?[^\?#]+)?\??([^#]+)?#?([^#]*)/;
    
    public var scheme:String;
    public var host:String;
    public var port:String;
    public var user:String;
    public var pass:String;
    public var path:String;
    public var query:String;
    public var fragment:String;
    
    public function get url():String { return _getURL(); }
    public function set url(u:String):void { _parse(u); }
    
    public function URLParser(_url:String = "")
    {
        url = _url;
    }
    
    public function toString():String
    {
        return _getURL();
    }
    
    private function _init():void
    {
        scheme = "";
        host = "";
        port = "";
        user = "";
        pass = "";
        path = "";
        query = "";
        fragment = "";
    }
    
    private function _parse(url:String):void
    {
        _init();
        
        if (url) {
            var r:Array = _regex.exec(url);
            if (r) {
                var value:String = "";
                for (var f:String in _fields) {
                    value = r[_fields[f]];
                    if (value) {
                        this[f] = value;
                    }
                }
            }
        }
    }
    
    private function _getURL():String
    {
        var s:String = "";
        if (scheme) {
            s += scheme + "://";
        }
        if (user) {
            s += user;
        }
        if (pass) {
            s += ":" + pass;
        }
        if (user || pass) {
            s += "@";
        }
        s += host;
        if (port) {
            s += ":" + port;
        }
        s += path;
        if (query) {
            s += "?" + query;
        }
        if (fragment) {
            s += "#" + fragment;
        }
        return s;
    }
}