/**
 * Copyright tkinjo ( http://wonderfl.net/user/tkinjo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yyQw
 */

// forked from tkinjo's wonderfl から外部のモジュールを読み込む
package  
{
	/**
	 * 自作ライブラリ（開発中）をモジュール経由で使用することに成功
	 * 
	 * ちなみに自作ライブラリは以下のライブラリ版
	 * http://wonderfl.kayac.com/code/188750688526f86d0177f342bb28224dc254281d
	 * 
	 * 
	 * ついでに Base64 ストリングでの埋め込み版もあり
	 * モジュールの Base64 ストリングでの埋め込みと、そのモジュール経由でライブラリを使う方法 
	 * http://wonderfl.kayac.com/code/e917c00d8f297bb8b50e8f9f7880c883dbf1c906
	 */
	
	import flash.display.DisplayObject;
	import flash.display.Sprite;
	import flash.events.Event;
	import mx.modules.IModuleInfo;
	import mx.modules.ModuleManager;
	
	[SWF(width="465", height="465", frameRate="60", backgroundColor="0xffffff")]
	/**
	 * ...
	 * @author tkinjo
	 */
	public class ModuleParent extends Sprite
	{
		private const MODULE_URL:String = "http://cross.gentenzero.com/wonderfl/module/constraintworldmodule.swf";
		
		private var constraintWorld:Object;
		private var mousePointer:Object;
		
		private function init():void {
			
			constraintWorld = new module.constraintWorld( 0.9 );
			
			mousePointer = new module.particle( mouseX, mouseY );
			
			//*
			var preCircle:Object;
			for ( var i:Number = 0; i < 5; i++ ) {
				
				var circle:Object = new module.circle();
				circle.friction = 0.9;
				constraintWorld.addParticle( circle );
				
				if( i == 0 )
					constraintWorld.addConstraint( new module.springConstraint( mousePointer, circle, 0.1, 20 ) );
				
				else if ( i < 3 ) {
					
					circle.friction = 0.5;
					constraintWorld.addConstraint( new module.followConstraint( preCircle, circle, 20 ) );
					
				} else
					constraintWorld.addConstraint( new module.springConstraint( preCircle, circle, 0.1, 20 ) );
				
				addChild( circle as DisplayObject );
				
				preCircle = circle;
			}
			//*/
			
			addEventListener( Event.ENTER_FRAME, enterFrameHandler );
		}
		
		/**
		 * 
		 * @param	event
		 */
		private function enterFrameHandler( event:Event ):void {
			
			mousePointer.x = mouseX;
			mousePointer.y = mouseY;
			
			constraintWorld.step();
		}
		
		
		
		
		
		/** --------------------------------------------------
		 * Module Load
		 */
		
		private var assetModule:IModuleInfo;
		private var module:Object;
		
		public function ModuleParent() 
		{
			assetModule = ModuleManager.getModule( MODULE_URL );
			assetModule.addEventListener("ready", getModuleInstance);
			assetModule.load();
		}
		
		private function getModuleInstance(event:Event):void {
			module = assetModule.factory.create() as Object;
			init();
		}
	}
}

/*
外部モジュールのソース

package  
{
	import com.tkinjo.constraintworld.constraint.*;
	import com.tkinjo.constraintworld.data.*;
	import com.tkinjo.constraintworld.world.*;
	import mx.modules.ModuleBase;
	
	public class ConstraintWorldModule extends ModuleBase
	{
		
		public function ConstraintWorldModule() 
		{
			
		}
		
		public function get iConstraint():Class { return IConstraint; }
		public function get constraint():Class { return Constraint; }
		public function get followConstraint():Class { return FollowConstraint; }
		public function get springConstraint():Class { return SpringConstraint; }
		
		public function get circle():Class { return Circle; }
		public function get iParticle():Class { return IParticle; }
		public function get particle():Class { return Particle; }
		
		public function get constraintWorld():Class { return ConstraintWorld; }
	}
	
}
*/