/**
 * Copyright kinoppy ( http://wonderfl.net/user/kinoppy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yyQT
 */

// forked from Albert's forked from: forked from: 003:forked from: [PV3D] Field of Blur
// forked from hacker_dgd_jz8f's forked from: 003:forked from: [PV3D] Field of Blur
// forked from umhr's 003:forked from: [PV3D] Field of Blur
package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.geom.ColorTransform;
    import flash.geom.Rectangle;
    
    [SWF(backgroundColor="0x000000")]
    public class Main extends Sprite{
        private var _red:Sample5;
        private var _blue:Sample5;
        private var _bitmapData:BitmapData;
        public function Main():void {
            _red = new Sample5(-50);
            this.addChild(_red);
            _blue = new Sample5(50);
            //this.addChild(_blue);
            
            _bitmapData = new BitmapData(stage.stageWidth,stage.stageHeight,false,0x000000);
            addChild(new Bitmap(_bitmapData))
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function loop(e:Event):void {
            _red.loop(null);
            _blue.loop(null);
            
            _bitmapData.lock();
            _bitmapData.fillRect(new Rectangle(0,0,stage.stageWidth,stage.stageHeight), 0x000000);
            _bitmapData.draw(_red, null,new ColorTransform(1,0,0,1,0,0,0,0));
            _bitmapData.draw(_blue, null,new ColorTransform(0,0,1,1,0,0,0,0), "add");
            _bitmapData.unlock();
        }
    }
}

/**
 * Papervision3Dで被写界深度
 * 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
 */
import flash.display.*;
import flash.events.*;
import flash.filters.*;

import org.papervision3d.view.*;
import org.papervision3d.materials.*;
import org.papervision3d.objects.*;
import org.papervision3d.objects.primitives.*
    
    [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]

class Sample5 extends BasicView 
{    
    // const vars
    static private const OBJ_LENGTH   :int = 20;
    static private const CIRCLE_RANGE :int = 500;
    
    // 3d vars
    private var list :Array = []
    private var wrap :DisplayObject3D;
    
    /**
     * Constructor
     */
    public function Sample5(dX:Number)
    {
        //camera
        camera.x         = -dX;
        camera.y         = 200;
        camera.z         = 1000;
        camera.rotationX = 5;
        
        // wrap
        wrap = new DisplayObject3D();
        scene.addChild(wrap);
        wrap.x = -dX / 3;
        
        for (var i:int = 0; i < OBJ_LENGTH; i++)
        {
            var rot:Number = 360 * i / OBJ_LENGTH ;
            
            var m:ColorMaterial = new ColorMaterial(0xFFFFFF);
            m.doubleSided = true;
            
            var o:Plane = new Plane(m, 100, 100);
            o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
            o.y = 0;
            o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
            o.rotationY = rot;
            o.useOwnContainer = true; //ココ重要
            
            // 配列に追加　＆　wrapの子供にする
            list.push(wrap.addChild(o));
        }
        
        //addEventListener(Event.ENTER_FRAME, loop);
        startRendering(); 
    }
    
    // loop
    public function loop(event:Event):void
    {
        wrap.yaw(-1);
        
        // 被写界深度
        for (var i:int = 0; i < list.length; i++)
        {
            var o:DisplayObject3D = list[i] as DisplayObject3D;
            var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 50); 
            o.filters = [new BlurFilter(blur, blur, 2)];
        }
    }
}
