/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yxzy
 */

package 
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.media.SoundTransform;
    import flash.net.URLRequest;
    import flash.system.Security;
    import flash.utils.ByteArray;
    
    /**
     * ...
     * @author gaina
     */
    [SWF(width = 465, height = 465)]
    public class Main extends Sprite 
    {
        private var _containerArray:Array;
        private var _sp:Sprite;
        private var _canvas:BitmapData;
        private var _bmp:Bitmap;
        private var _array:Array;
        
        private const MAX:int = 64;
        private var _sound:Sound;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            Security.allowDomain("*");
            _sound = new Sound();
            _sound.addEventListener(Event.COMPLETE, SoundLoaded);
            _sound.load(new URLRequest("http://www.takasumi-nagai.com/soundfiles/sound004.mp3"), new SoundLoaderContext(1000, true));
            
            _sp = new Sprite();
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, true, 0xFF000000);
            _bmp = new Bitmap(_canvas);
            addChild(_bmp);
            
            _containerArray = [];
            for (var i:int = 0; i < MAX; i++)
            {
                var _ball:Ball = new Ball(Math.random() * 100 + 300, Math.random() * 100 + 300, Math.random() * 8 - 4 , Math.random() * 8 - 4 , Math.random() * 10 + 30);
                _sp.addChild(_ball);
                _containerArray.push(_ball);
            }
            
            _array = [];
            for (var j:int = 0; j < 256; j++)
            {
                if (j < 200) {
                    _array.push(0xFF000000);
                }else {
                    _array.push(0xFFFFFFFF);
                }

            }
            addEventListener(Event.ENTER_FRAME, loop);
        }
        
        private function SoundLoaded(e:Event):void 
        {
            _sound.play(0, 100, new SoundTransform(0.3, 0));
        }
        
        private function loop(e:Event):void 
        {
            _canvas.lock();
            //_canvas.fillRect(_canvas.rect, 0x00000000);
            _canvas.draw(_sp);
            _canvas.paletteMap(_canvas, _canvas.rect, new Point(), null, null, null, _array);
            //_canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(4, 4));
            _canvas.unlock();
            
            
            var _bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(_bytes, false, 2);
            for (var i:int = 0; i < MAX; i++)
            {
                var p:Number = 0;
                for (var num:int = 0; num < 512 / MAX; num++)
                {
                    p += _bytes.readFloat();
                }
                var _ball:Ball = _containerArray[i] as Ball;
                _ball.x += _ball.dx;
                _ball.y += _ball.dy;
                
                _ball.scaleX = _ball.scaleY = Math.max(1, p);
                
                if (_ball.x < _ball.rad / 2 || _ball.x > stage.stageWidth - _ball.rad / 2) _ball.dx *= -1;
                if (_ball.y < _ball.rad / 2 || _ball.y > stage.stageHeight - _ball.rad / 2) _ball.dy *= -1;
            }
            
            
        }
        
    }
    
}

import flash.display.Sprite;
import flash.filters.BlurFilter;

class Ball extends Sprite
{
    public var rad:Number;
    public var dx:Number;
    public var dy:Number;
    
    public function Ball(x:Number, y:Number, dx:Number, dy:Number,rad:Number )
    {
        this.x = x;
        this.y = y;
        this.dx = dx;
        this.dy = dy;
        this.rad = rad;
        
        this.graphics.beginFill(0);
        this.graphics.drawCircle(0, 0, rad);
        this.graphics.endFill();
        this.filters = [new BlurFilter(32, 32)];
    }
}