/**
 * Copyright Cheshir ( http://wonderfl.net/user/Cheshir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yxv2
 */

package {
    import flash.geom.Point;
    import flash.events.Event;
    import flash.text.TextField;
    // let's do this http://www.flashandmath.com/advanced/simple3d/
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var canvas:Sprite = new Sprite();
        
        private var vertexArray:Array = [new Point3D(50,50,50), new Point3D(50,-50,50), new Point3D(-50,50,50), new Point3D(-50,-50,50),
                                        new Point3D(50,50,-50), new Point3D(50,-50,-50), new Point3D(-50,50,-50), new Point3D(-50,-50,-50)];
        private var facesArray:Array = [[0,1,2],[2,3,1],[0,4,6],[0,4,5],[3,5,1]];
        
        public function FlashTest() {
            drawGrid();    // I need more time... 15 minutes I did not get
            
            addChild(canvas);
            stage.addEventListener(Event.ENTER_FRAME, rotate);
        }
        private function rotate(e:Event):void{
            theta+=0.01;
            phi+=0.005;
            canvas.graphics.clear();
            for(var i:int=0; i<vertexArray.length; i++){
                drawPoint(vertexArray[i]);    
            }
            for(i=0; i<facesArray.length; i++){
                drawFace(facesArray[i]);
            }
        }

        public function drawGrid():void{
            var w:Number = stage.stageWidth;
            var h:Number = stage.stageHeight;
            this.graphics.beginFill(0xcccccc);
            this.graphics.drawRect(0,0,w,h);
            this.graphics.endFill();
            this.graphics.lineStyle(1);
            this.graphics.moveTo(w/2, h-30);
            this.graphics.lineTo(w/2, 30);
            createSignature(w/2+10, h-50, "Y");
            this.graphics.moveTo(30, h/2);
            this.graphics.lineTo(w-30, h/2);
            createSignature(w-40, h/2, "Z");
            this.graphics.moveTo(w/1.5,h/3);
            this.graphics.lineTo(90,h-90);
            createSignature(90,h-90, "X");
            canvas.x = w/2; canvas.y = h/2;
        }
        private function createSignature(x:Number,y:Number,signature:String,scale:Number = 1.5):void{
            var sig:TextField = new TextField();
            sig.text = signature;
            sig.textColor = 0xdd3333;
            sig.scaleX = sig.scaleY = scale;
            sig.x = x;
            sig.y = y;
            addChild(sig);
        }
        
        private var theta:Number = 0;
        private var phi:Number = 0;
        private function drawPoint(p:Point3D):void{
            canvas.graphics.beginFill(0x33dd33+p.z*0xdd);    // I can draw point, but I need calculate offset before;
            // похоже, что это позволяет производить сещение для осей Y и Z и это выглядит правильно, но ось Х у меня выпадает
            p.calcVisual(theta,phi);
           
            canvas.graphics.drawCircle(p.visualX, p.visualY, 3);
            canvas.graphics.endFill();
        }
        private function drawFace(face:Array):void{
            canvas.graphics.beginFill(0x33dd33,0.4);
            canvas.graphics.lineStyle(1,0x33dd33);
            canvas.graphics.moveTo(vertexArray[face[0]].visualX, vertexArray[face[0]].visualY);
            canvas.graphics.lineTo(vertexArray[face[1]].visualX, vertexArray[face[1]].visualY);
            canvas.graphics.lineTo(vertexArray[face[2]].visualX, vertexArray[face[2]].visualY);
            canvas.graphics.endFill();
        }
        /*
        private function createPlane():Object{
            var p_0:Point3D = new Point3D(0,0,0);
            var p_1:Point3D = new Point3D(25,0,0);
            var p_2:Point3D = new Point3D(25,25,0);
            var p_3:Point3D = new Point3D(0,25,0);
            var plane:Object = {points:[p_0,p_1,p_2,p_3], conect:[0,1,3]};
            return plane;
        } */
    }
}
import flash.geom.Point;

Class {
    class Point3D extends Point{
        public var visualX:Number;
        public var visualY:Number;
        public var z:Number;
        public var color:uint;
        public function Point3D(x:Number=0, y:Number=0, z:Number=0, color:uint=0xdd3333){
            this.x = x; this.color = color;
            this.y = y;
            this.z = z;
        }
        public function calcVisual(theta:Number, phi:Number):void{
            this.visualX = x*Math.cos(theta)*Math.sin(phi) + y*Math.sin(theta)*Math.sin(phi) + z*Math.cos(phi);
            this.visualY = -x*Math.sin(theta)+y*Math.cos(theta);
        }
    }
}
