/**
 * Copyright mutantleg ( http://wonderfl.net/user/mutantleg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yxmK
 */

package {
    import flash.events.KeyboardEvent;
    import flash.events.Event;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
       
       public var pic:Bitmap;
       public var screen:BitmapData;
       
       public var myMap:cMap;
       
        public function FlashTest() {
            // write as3 code here..
            
            screen = new BitmapData(200, 200, false, 0);
            pic = new Bitmap(screen);
            addChild(pic);
            pic.scaleX = 2;
            pic.scaleY = 2;
            
            myMap = new cMap(500, 500);
            myMap.drawMap(screen, 0, 0);
            
            stage.addEventListener(Event.ENTER_FRAME, onEnter);
              stage.addEventListener(KeyboardEvent.KEY_DOWN, kdown);
                  stage.addEventListener(KeyboardEvent.KEY_UP, kup);
        }//ctor
        
         public function kdown(e:KeyboardEvent):void
        {  cKeyMan.setKey(e.keyCode, true);     }//kdown
        
        public function kup(e:KeyboardEvent):void
        {  cKeyMan.setKey(e.keyCode, false);    }//kup
        
        public var camx:Number = 0;
        public var camy:Number = 0;
        public var myPlayer:cPlayer = new cPlayer();
        
        public function onEnter(e:Event):void
        {
            
            
            myPlayer.update();
            
            var tx:Number = myPlayer.cx - 100;
            var ty:Number = myPlayer.cy - 100;
            
            camx += (tx - camx) * 0.2;
            camy += (ty - camy) * 0.2;
            
             //keyref
         //http://www.dakmm.com/?p=272
         /*
              if (cKeyMan.isKeyDown(39) ) { camx -= 1;}
            if (cKeyMan.isKeyDown(37) ) { camx += 1;}
             if (cKeyMan.isKeyDown(38) ) { camy += 1;}
            if (cKeyMan.isKeyDown(40) ) { camy -= 1;}
          */  
            
            screen.lock();
                screen.fillRect(screen.rect, 0x010140); //clear screen
                myMap.drawMap(screen, camx, camy);
                
                myPlayer.drawScroll(screen, camx, camy);
                
            screen.unlock();
        }//onenter
        
        
    }//classend
}//package

import flash.geom.Point;
import flash.geom.Rectangle;
import flash.display.BitmapData;

internal class cPlayer
{
   public var cx:Number = 125;
   public var cy:Number = 125; 
    
    public var vx:Number = 0;
    public var vy:Number = 0;
    
   public var xrad:Number = 8;
   public var yrad:Number = 8; 
    
    public function cPlayer()
    {
        cx = 50;
        cy = 50;
       }//ctor
      
      public var rect:Rectangle = new Rectangle(); 
      public function drawScroll(to:BitmapData, sx:Number, sy:Number):void
      {
          rect.x = (cx - sx)-xrad;
          rect.y = (cy - sy)-yrad;
          rect.width = xrad + xrad;
          rect.height = yrad + yrad;
         to.fillRect(rect, 0xFF0000); 
          
      }//drawscroll
         
      public function update():void
      {
               //keyref
         //http://www.dakmm.com/?p=272
         
         vy += 0.125;
         
              if (cKeyMan.isKeyDown(39) ) { vx += 1;}
            if (cKeyMan.isKeyDown(37) ) { vx -= 1;}
            if (cKeyMan.isKeyDown(38) ) { vy -= 1;}
            if (cKeyMan.isKeyDown(40) ) { vy += 1;}
            
            if (vx > 8) { vx = 8;}
            if (vx < -8) { vx = -8;}
            if (vy > 8) { vy = 8;}
            if (vy < -8) { vy = -8;}
           
      //     if (cx < 0) { cx = 0;}
      //     if (cx >= MAP.width) {cx = MAP.width -1;}
           
            
           vx *= 0.9;
          // vy *= 0.9;
            
            if (vy < 0 && cMap.MAP.isObstacle(cx,cy-yrad) ){ vy = 0;}
            if (vy > 0 && cMap.MAP.isObstacle(cx,cy+yrad) ){ vy = 0;}
            if (vx < 0 && cMap.MAP.isObstacle(cx-xrad,cy) ){ vx = 0;}
            if (vx > 0 && cMap.MAP.isObstacle(cx+xrad,cy) ){ vx = 0;}
           
           if (cMap.MAP.isObstacle(cx,cy+yrad))
           {
               var i:int;
               for (i = 0; i < 8; i++)
               {
                    if (!cMap.MAP.isObstacle(cx,cy+yrad-1)) { break;}
                    if (cMap.MAP.isObstacle(cx,cy-yrad-1)) { break; }
                    cy -=1;
                }//nexti               
            }//endif 
           
            
            cx += vx;
            cy += vy;
            
            
          
        }///update
    
    
}//classendcplayer




internal class cMap
{
    public var map:BitmapData;
    //public var mask:BitmapData;
    
    public var width:Number = 250;
    public var height:Number = 250;
    
    public static var MAP:cMap;
    
    public function cMap(w:Number=250, h:Number=250)
    {
        MAP = this;
        
        width = w;
        height = h;
        
        map = new BitmapData(w, h);
     //   mask = new BitmapData(w,h,false,0);
       
        
        map.noise(1);
       map.fillRect(new Rectangle(16,16,width-48,height-48), 0);
       drawRect(0, 120, 120, 40, 0xFFFFff00);
    }//ctor
    
    public var tmpRect:Rectangle = new Rectangle();
    public var destPoint:Point = new Point();
    public function drawMap(to:BitmapData, sx:Number, sy:Number):void
    {
        tmpRect.x = sx;
        tmpRect.y = sy;
        tmpRect.width = to.width;
        tmpRect.height = to.height;
        
        to.copyPixels(map, tmpRect, destPoint);
        
    }//drawmap
    
    public function isObstacle(x:Number, y:Number):Boolean
    {
        if (x < 0) { return false; }
        if (y < 0) { return false;}
        if (x >= width) { return false; }
        if (y >= height) { return false; }
        
        return (map.getPixel32(x,y) != 0x000000);
    }//isobstacle
    
    public function drawRect(x:Number,y:Number,w:Number,h:Number, c:uint):void
    {
        tmpRect.x = x;
        tmpRect.y = y;
        tmpRect.width = w;
        tmpRect.height = h;
        map.fillRect(tmpRect, c);
         
    }//drawrect
    
    
}//classendmap



internal class cKeyMan
   {
       public function cKeyMan() {}//ctor (unused)
       
       public static var vecKey:Vector.<Boolean> = new Vector.<Boolean>(512,true);
       
       public static function setKey(k:int, b:Boolean):void
       {
           if (k < 0) return;
           if (k >= 512) return;
           vecKey[k] = b;
       }//setkey
       
       public static function isKeyDown(k:int):Boolean
       {
           if  (k < 0) return false;
           if (k >= 512) return false;
           return vecKey[k];
       }//iskey
       
   }//keyman 