/**
 * Copyright siouxcitizen ( http://wonderfl.net/user/siouxcitizen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yxdB
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
 
    import org.papervision3d.view.Viewport3D;
    import org.papervision3d.scenes.Scene3D;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.cameras.Camera3D;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.render.BasicRenderEngine;
 
    [SWF(width="500", height="500", frameRate="60", backgroundColor="#66CCFF")]
 
    public class MoviePlane extends Sprite
    {
        private var container : Sprite;
        private var viewport  : Viewport3D;
        private var scene     : Scene3D;
        private var camera    : Camera3D;
        private var material  : ColorMaterial;
        private var planeObj  : Plane; 
        private var renderer  : BasicRenderEngine;

        private var planeSize : int = 300;//Planeオブジェクト1辺の長さ
        private var segment   : int = 1;  //面の分割数

        //MoviePlaneクラスのコンストラクタ
        public function MoviePlane():void
        {          
            //ビューポート生成
            viewport = new Viewport3D(500, 500, false, true);
            addChild(viewport);

            //シーン生成
            scene = new Scene3D();

            //レンダリングエンジン生成
            renderer = new BasicRenderEngine();

            //マテリアル設定
            material = new ColorMaterial( 0x000033, 1 );
            material.oneSide = false;

            //Planeオブジェクト生成
            planeObj= new Plane(material, planeSize, planeSize, segment, segment);
            scene.addChild(planeObj);

            //カメラ設定
            camera = new Camera3D();
            camera.z = -planeSize;
            camera.focus = 50;
            camera.zoom = 1;
 
            //マウスイベント処理用リスナを設定
            stage.addEventListener(Event.ENTER_FRAME, _enterframe);
        }

        //マウスイベント処理
        private function _enterframe(e:Event):void{
            planeObj.rotationX=viewport.mouseX;
            planeObj.rotationY=viewport.mouseY;
            renderer.renderScene(scene, camera, viewport);
        }
    }
}
