/**
 * Copyright wh0 ( http://wonderfl.net/user/wh0 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yx9B
 */

// forked from wh0's social grapher
// you can click on an icon to restart it
package {
	import flash.display.Sprite;
	public class FlashTest extends Sprite {
		
		public function FlashTest() {
			Hacker.init(this);
			Hacker.restart(loaderInfo.parameters['viewer.displayName']);
		}
		
	}
}

import flash.display.*;
import flash.events.*;
import flash.net.*;
import flash.system.*;
import flash.text.*;
internal class Hacker extends Loader {
	
	private static var PROXY:String = 'http://5ivestar.org/proxy/';
	private static var MAX:int = 30;
	private static var CONT:Sprite;
	private static var MX:Number;
	private static var MY:Number;
	private static var R:Number;
	private static var debug:TextField = new TextField();
	
	public static function init(cont:Sprite):void {
		Security.loadPolicyFile(PROXY + 'crossdomain.xml');
		CONT = cont;
		MX = cont.stage.stageWidth / 2;
		MY = cont.stage.stageHeight / 2;
		R = Math.min(MX, MY) - 50;
		debug.width = cont.stage.stageWidth;
		debug.height = cont.stage.stageHeight;
		debug.selectable = false;
		cont.addChild(debug);
	}
	
	private static var count:int = 0;
	private static var map:Object = {};
	private static var loading:int = 0;
	
	public static function restart(o:String):void {
		for each (var h:Hacker in map)
			CONT.removeChild(h);
		CONT.graphics.clear();
		CONT.graphics.lineStyle(0, 0, 0.25);
		count = 0;
		loading = 0;
		map = {};
		new Hacker(o);
	}
	
	private static function finish():void {
		for each (var h:Hacker in map)
			h.enable();
	}
	
	private var displayName:String;
	private var following:Vector.<String>;
	
	public function Hacker(n:String) {
		if (map.hasOwnProperty(n))
			throw new ArgumentError();
		if (count >= MAX)
			throw new Error();
		displayName = n;
		following = new Vector.<String>();
		map[n] = this;
		x = MX + R * Math.cos(2 * Math.PI * count / MAX);
		y = MY + R * Math.sin(2 * Math.PI * count / MAX);
		scaleX = 0.4;
		scaleY = 0.4;
		rotation = 360. * count / MAX;
		CONT.addChild(this);
		count++;
		debug.text = (++loading).toString();
		var profile:URLLoader = new URLLoader(new URLRequest(PROXY + 'http://wonderfl.net/user/' + displayName));
		profile.addEventListener(Event.COMPLETE, populate);
	}
	
	private function populate(v:Event):void {
		// yes I have heard of regular expressions, thank you very much.
		var d:String = v.target.data;
		var s:int, e:int, f:int;
		s = d.indexOf('<div class="user_img">');
		s = d.indexOf('<img src="', s) + 10;
		e = d.indexOf('" alt="', s);
		load(new URLRequest(PROXY + 'http://wonderfl.net' + d.substring(s, e)));
		e = d.indexOf('<div class="box" id="following_box">', e) + 36;
		if (e >= 36) {
			f = d.indexOf('<div class="box"', e);
			while (true) {
				s = d.indexOf('<a href="http://wonderfl.net/user/', e) + 34;
				if (s < 34 || s > f)
					break;
				e = d.indexOf('" title="', s);
				var c:String = d.substring(s, e);
				following.push(c);
				try {
					new Hacker(c);
				} catch (x:ArgumentError) {
				} catch (x:Error) {
					break;
				}
				CONT.graphics.moveTo(x, y);
				CONT.graphics.lineTo(map[c].x, map[c].y);
				e = d.indexOf('</span>', e);
			}
		}
		debug.text = (--loading).toString();
		if (loading <= 0)
			finish();
	}
	
	private function enable():void {
		addEventListener(MouseEvent.CLICK, center);
	}
	
	private function center(e:MouseEvent):void {
		restart(displayName);
	}
	
}	