/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yvkn
 */

package {
    import com.actionscriptbible.Example;
    public class FlashTest extends Example {
        public function FlashTest() {
            var frac1:Fraction = new Fraction(4, 6);
            var frac2:Fraction = new Fraction(1, 12);
            trace("(" + frac1.toString() + ")" + "+" + "(" + frac2.toString() + ")" + 
                  "=" + Fraction.add(frac1, frac2).toString());
            
            trace("(" + frac1.toString() + ")" + "-" + "(" + frac2.toString() + ")" + 
                  "=" + Fraction.subtract(frac1, frac2).toString());
                  
            trace("(" + frac1.toString() + ")" + "*" + "(" + frac2.toString() + ")" + 
                  "=" + Fraction.multiply(frac1, frac2).toString());
                  
            trace("(" + frac1.toString() + ")" + "/" + "(" + frac2.toString() + ")" + 
                  "=" + Fraction.divide(frac1, frac2).toString());
                  
            trace(frac1.toNumber(5));
            
            trace(new Fraction(26, 0));
            
            trace(new Fraction(-22, -45));
        }
    }
}

//分数クラス
class Fraction {
    //分子
    private var _numerator:int;
    public function get numerator():int {
        return _numerator;
    }
    
    //分母
    private var _denominator:int;
    public function get denominator():int {
        return _denominator;
    }
    
    //コンストラクタ（引数は分子、分母）
    public function Fraction(numerator:int, denominator:int) {
        _numerator = numerator;
        _denominator = denominator;
        //負の数の場合分子にマイナスをもたせる（分子分母ともにマイナスがつくのを避けるため）
        if(_denominator < 0) {
            _numerator *= -1;
            _denominator *= -1;
        }


        reduction();
    }
    
    //約分（分子・分母を、それらの最大公約数で割る）
    //参考→　ユークリッドの互除法 http://wonderfl.net/c/jM0Q
    private function reduction():void {
        var larger:int = _numerator > _denominator ? _numerator : _denominator;
        var smaller:int = _numerator < _denominator ? _numerator: _denominator;
        var remainder:int = larger % smaller;
        while(remainder > 0) {
            larger = smaller;
            smaller = remainder;
            remainder = larger % smaller;
        }
        
        _numerator /= smaller;
        _denominator /= smaller;
    }
    
    //同じ分数インスタンスをつくる
    public function clone():Fraction {
        return new Fraction(_numerator, _denominator);
    }

    
    //文字として出力
    public function toString():String {
        if(_denominator != 0) {
            return String(_numerator) + "/" + String(_denominator);
        } else {
            return "NaN";
        }
    }
    
    //小数（Number）として出力（引数：小数点以下桁数）
    public function toNumber(digit:int):Number {
        var num:int = Math.pow(10, digit);
        return Math.round(_numerator / _denominator * num) / num;
    }

    
    //足し算
    public static function add(frac1:Fraction, frac2:Fraction):Fraction {
        var den:int = frac1.denominator * frac2.denominator;
        var num1:int = frac1.numerator * frac2.denominator;
        var num2:int = frac2.numerator * frac1.denominator;
        return new Fraction(num1 + num2, den);
    }
    
    //引き算
    public static function subtract(frac1:Fraction, frac2:Fraction):Fraction {
        var den:int = frac1.denominator * frac2.denominator;
        var num1:int = frac1.numerator * frac2.denominator;
        var num2:int = frac2.numerator * frac1.denominator;
        return new Fraction(num1 - num2, den);
    }
    
    //掛け算
    public static function multiply(frac1:Fraction, frac2:Fraction):Fraction {
        return new Fraction(frac1.numerator * frac2.numerator, frac1.denominator * frac2.denominator);
    }
    
    //割り算
    public static function divide(frac1:Fraction, frac2:Fraction):Fraction {
        return new Fraction(frac1.numerator * frac2.denominator, frac1.denominator * frac2.numerator);
    }


}
