/**
 * Copyright WLAD ( http://wonderfl.net/user/WLAD )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yvAJ
 */

// forked from Vladik's Simple Component Slider
package 
{
    
    import flash.display.Shape;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite {
        
        private var component:Container;
        
          private var list:List;      
        
        public function FlashTest() {
            // write as3 code here..
            
            component = new Container(180, 320);
            
            addChild(component);
            
            component.y = 50;
            
            
            
            addCircle( 20, 50 );
            addCircle( 60, 100 );
            addCircle( 120, 300 );
            addCircle( 20, 250 );
            addCircle( 120, 360 );
            addCircle( 70, 420 );
            
            list = new List(180,320);
            
            addChild(list);
            
            list.x = 250;
            list.y = 50;
            
            
        }
        
        public function addCircle( x:int = 0, y:int = 0 ):void
        {
            var c:Shape = new Shape();
            
            component.addChild( c );
            
            c.x = x;
            c.y = y;
            
            c.graphics.beginFill( 0xFFFFFF * Math.random() );
            c.graphics.drawCircle( 40, 40, 80 );
            c.graphics.endFill();
        }
    }
}
import flash.display.DisplayObject;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.filters.DropShadowFilter;

/* //////////////////////////////////
/////////////////////////////////////

Component Container

    classes that extend : Panel, List, Graph.

/////////////////////////////////////
////////////////////////////////// */

class Container extends Sprite
{
    public var skinBorderColor:uint = 0x8B8B8B;
    public var skinBackgroundColor:uint = 0xEEEEEE;
    public var skinSliderBackgroundColor:uint = 0xE7EBE8;
    public var skinSliderColor:uint = 0xA6B5AA;
    
    private var w:int;
    private var h:int;
    
    private var sliderMax:int;
    public var slider:Sprite;
    
    private var _container:Sprite;
    
    public function Container( w:int = 100, h:int = 100)
    {
        // Set size
        this.h = h;
        this.w = w;
        
        // Init slider handel
        slider = new Sprite();
        super.addChild( slider );
        slider.addEventListener(MouseEvent.MOUSE_DOWN, startSliding);
        slider.visible = false;
        slider.buttonMode = slider.useHandCursor = true;
        
        //Init container & mask
        _container = new Sprite();
        super.addChild( _container );
        
        cMask = new Shape();
        super.addChild( cMask );
        _container.mask = cMask;
        
        updateSlider();
    }
    
    override public function addChild(child:DisplayObject):DisplayObject 
    {
        updateSlider();
        
        _container.addChild(child);
        
        return child;
    }
    
    private function updateSlider():void 
    {
        slider.visible = _container.height > h;
        
        slider.y = sliderMax * ( _container.y / ( _container.height - h ) );
        
        render();
    }
    
    override public function removeChild(child:DisplayObject):DisplayObject 
    {
        updateSlider();
        
        _container.removeChild(child);
        
        return child;
    }
    
    private var mouseStart:int = 0;
    private var sliderValue:Number;
    
    private function startSliding(e:MouseEvent):void 
    {
        mouseStart = int( slider.mouseY );
        
        slider.addEventListener(Event.ENTER_FRAME, slide);
        stage.addEventListener(MouseEvent.MOUSE_UP, stopSliding);
    }
    
    private function stopSliding(e:MouseEvent):void 
    {
        slider.removeEventListener(Event.ENTER_FRAME, slide);
        stage.removeEventListener(MouseEvent.MOUSE_UP, stopSliding);
    }
    
    private function slide(e:Event):void 
    {
        // Change slider y position relative to mouseY
        slider.y = mouseY - mouseStart;
        
        // Prevent the slider from leaving the component bounds
        if ( slider.y < 0 ) slider.y = 0;
        if ( slider.y > sliderMax ) slider.y = sliderMax;
        
        sliderValue = slider.y / sliderMax;
        
        _container.y = -(_container.height - h) * sliderValue;
    }
    
    // Container mask
    private var cMask:Shape;
    
    public function render():void
    {
        graphics.clear();
        
        // Position slider
        slider.x = w;
        
        // Draw background
        graphics.beginFill( skinBackgroundColor );
        graphics.drawRect( 0, 0, w, h );
        graphics.endFill();
        
        // Resize container mask
        cMask.graphics.clear();
        cMask.graphics.beginFill(0xFF0000);
        cMask.graphics.drawRect(0, 0, w, h);
        
        // Draw slider
        if ( slider.visible )
        {    
            // Slider
            slider.graphics.beginFill( skinSliderColor );
            slider.graphics.drawRect( 0, 0, 15, 30 );
            slider.graphics.endFill();
            
            // Slider background
            graphics.beginFill( 0xE1E1E1 );
            graphics.drawRect( w, 0, 15, h );
            graphics.endFill();
            
            sliderMax = h - slider.height;
            
            graphics.lineStyle( 1, skinBorderColor);
            graphics.drawRect( 0, 0, w + 15, h);
            
            graphics.moveTo(w + 15, 0);
            graphics.lineTo(w + 15, h);
        }
        else 
        {
            graphics.lineStyle( 1, skinBorderColor);
            graphics.drawRect( 0, 0, w, h);
        }
    }
}

class List extends Container
{
    private var _data:Vector.<ListItem>;
    
    public function List(w:int = 100, h:int = 100)
    {
        super( w, h );
        
        _data = new Vector.<ListItem>();
    }
    
    public function addItem( item:ListItem ):void
    {
        
    }

    
}


class ListItem extends Sprite
{
    public var w:int = 0;
    public var h:int = 0;
    
    public function ListItem()
    {
        addEventListener(Event.ADDED_TO_STAGE, init);
    }    
    
    protected function init():void
    {
        removeEventListener(Event.ADDED_TO_STAGE, init);
    }

    
    protected function get list():List
    {
        return List(parent);
    }
    
    protected function render():void
    {
        
    }
}
