/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yv2d
 */

// use mouse context menu to change drawing tool
//
// inpspired by 
// http://mrdoob.com/projects/harmony/

package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.ContextMenuEvent;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.ui.ContextMenu;
    import flash.ui.ContextMenuItem;
    
    [SWF(width="465", height="465", frameRate="30", backgroundColor="#FFFFFF")]
    
    public class Sketch extends Sprite
    {
        private var drawing:Boolean = false;
        private var bitmap:Bitmap = new Bitmap();
        private var tool:GenericTool = new Sketchy();
        private var tools:Object = {
            Sketchy:new Sketchy(),
            Shaded:new Shaded()
        };
        
        public function Sketch()
        {
            super();
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseDown);
            stage.addEventListener(MouseEvent.MOUSE_MOVE, mouseMove);
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUp);
            
            var type:String = ContextMenuEvent.MENU_ITEM_SELECT;
            
            var sketchyItem:ContextMenuItem = new ContextMenuItem("Sketchy");
            sketchyItem.addEventListener(type, changeTool);
            
            var shadedItem:ContextMenuItem = new ContextMenuItem("Shaded");
            shadedItem.addEventListener(type, changeTool);
            
            var cm:ContextMenu = new ContextMenu();
            cm.builtInItems.zoom = false;
            cm.builtInItems.quality = false;
            cm.builtInItems.print = false;
            cm.builtInItems.save = false;
            cm.builtInItems.play = false;
            cm.builtInItems.loop = false;
            cm.builtInItems.rewind = false;
            cm.builtInItems.forwardAndBack = false;
            cm.customItems.push(sketchyItem);
            cm.customItems.push(shadedItem);
            
            contextMenu = cm;
            
            addChild(bitmap);
            bitmap.bitmapData = new BitmapData(465, 465, true);
        }
        
        private function changeTool(event:ContextMenuEvent):void
        {
            var caption:String = ContextMenuItem(event.target).caption;
            tool = tools[caption];
        }
        
        private function mouseDown(event:MouseEvent):void
        {
            drawing = true;
            GenericTool(tool).init(mouseX, mouseY);
        }
        
        private function mouseMove(event:MouseEvent):void
        {
            if(!drawing)
                return;
            tool.draw(graphics, mouseX, mouseY);
            bitmap.bitmapData.draw(this);
            graphics.clear();
        }
        
        private function mouseUp(event:MouseEvent):void
        {
            drawing = false;
        }
    }
}

internal class GenericTool
{
    public function init(x:Number, y:Number):void
    {}
    
    public function draw(graphics:Graphics, x:Number, y:Number):void
    {}
}

import flash.display.Graphics;
import flash.geom.Point;
import __AS3__.vec.Vector;

internal class Sketchy extends GenericTool
{
    private var points:Vector.<Point>;
    private static const PADDING:Number = 0.3;
    private static const MIN_DISTANCE:Number = 2000;
    private static const MAX_DISTANCE:Number = 4000;
    
    public function Sketchy():void
    {
    }
    
    override public function init(x:Number, y:Number):void
    {
        points = new Vector.<Point>();
        points.push(new Point(x, y));
    }
    
    override public function draw(graphics:Graphics, x:Number, y:Number):void
    {
        var d:Number, xd:Number, yd:Number;
        var point:Point = points[points.length - 1];
        graphics.lineStyle(1, 0, 0.02);
        graphics.moveTo(point.x, point.y);
        graphics.lineTo(x, y);
        graphics.lineStyle(1, 0, 0.02);
        for each(point in points)
        {
            xd = point.x - x;
            yd = point.y - y;
            d = xd * xd + yd * yd;
            if(d < MAX_DISTANCE && Math.random() > d / MIN_DISTANCE)
            {
                graphics.moveTo(x + xd * PADDING, y + yd * PADDING);
                graphics.lineTo(point.x - xd * PADDING, point.y - yd * PADDING);
            }
        }
        points.push(new Point(x, y));
    }
}

import flash.display.Graphics;
import flash.geom.Point;
import __AS3__.vec.Vector;

internal class Shaded extends GenericTool
{
    private var points:Vector.<Point>;
    private static const MAX_DISTANCE:Number = 1000;
    
    public function Shaded():void
    {
    }
    
    override public function init(x:Number, y:Number):void
    {
        points = new Vector.<Point>();
        points.push(new Point(x, y));
    }
    
    override public function draw(graphics:Graphics, x:Number, y:Number):void
    {
        var d:Number, xd:Number, yd:Number;
        var point:Point = points[points.length - 1];
        graphics.lineStyle(1, 0, 0.05);
        graphics.moveTo(point.x, point.y);
        graphics.lineTo(x, y);
        for each(point in points)
        {
            xd = point.x - x;
            yd = point.y - y;
            d = xd * xd + yd * yd;
            if(d < MAX_DISTANCE)
            {
                graphics.lineStyle(1, 0, (1 - d / 1000) * 0.01);
                graphics.moveTo(x + xd, y + yd);
                graphics.lineTo(point.x - xd, point.y - yd);
            }
        }
        points.push(new Point(x, y));
    }
}