/**
 * Copyright Test_Dept ( http://wonderfl.net/user/Test_Dept )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yub6
 */

package {

	import flash.display.Sprite;
	
	/**
	 * GeomTest II
	 * @author Test Dept
	 */
	[SWF(backgroundColor="#ffffff", width="465", height="465")]
	public class GeomTestII extends Sprite {
		public function GeomTestII() {
			addChild(new GeomTestImpl() );	
		}		
	}
}

import flash.display.Graphics;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.Matrix;
import flash.geom.Point;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFieldType;

class GeomTestImpl extends Sprite {
		
	private var _a1 : UIPoint;
	private var _a2 : UIPoint;
	private var _b1 : UIPoint;
	private var _b2 : UIPoint;
	private var _c : UIPoint;

	public function GeomTestImpl() {
		addEventListener(Event.ADDED_TO_STAGE, addedToStageHandler);
	}
	
	private function addedToStageHandler(event : Event) : void {

		addChild(_a1 = new UIPoint(0x000000, 10, 20, "a1", true) );
		addChild(_a2 = new UIPoint(0x000000, 50, 390, "a2", true) );
		addChild(_b1 = new UIPoint(0x000000, 80, 50, "b1", true) );
		addChild(_b2 = new UIPoint(0x000000, 390, 50, "b2", true) );
		addChild(_c = new UIPoint(0x000000, 0, 0, "c") );

		addEventListener(Event.ENTER_FRAME, enterFrameHandler);
	}
	
	private function enterFrameHandler(event : Event) : void {

		var a1 : Point = new Point(_a1.x, _a1.y);
		var a2 : Point = new Point(_a2.x, _a2.y);
		var b1 : Point = new Point(_b1.x, _b1.y);
		var b2 : Point = new Point(_b2.x, _b2.y);
				
		var c : Point = GeoUtil.getCrossPoint(a1, a2, b1, b2);
		_c.x = c.x;
		_c.y = c.y;


		var g : Graphics = graphics;
		g.clear();

		g.lineStyle(1, 0x000000);
		g.moveTo(a1.x, a1.y);
		g.lineTo(a2.x, a2.y);
		g.moveTo(b1.x, b1.y);
		g.lineTo(b2.x, b2.y);

		g.lineStyle(1, 0x00ff00);
		g.moveTo(a2.x, a2.y);
		g.lineTo(c.x, c.y);
		g.lineTo(b2.x, b2.y);

		g.lineStyle(1, 0x0000ff);
		g.moveTo(a2.x, a2.y);
		g.curveTo(c.x, c.y, b2.x, b2.y);
	}
}

class GeoUtil {

	public static function getCrossPoint(
		a1 : Point, a2 : Point,
		b1 : Point, b2 : Point
	) : Point {
		
		var a12 : Point = a2.subtract(a1);
		var b12 : Point = b2.subtract(b1);

		var mat : Matrix = new Matrix(
			-a12.y, a12.x,
			-b12.y, b12.x);
		
		mat.invert();
		
		var st : Point = mat.transformPoint(b2.subtract(a2) );
		
		var s : Number = st.x;

		return new Point(
			a2.x - a12.y * s,
			a2.y + a12.x * s);
	}
}

class UIPoint extends Sprite {

	private var _pressed : Boolean;
	private var _dragX : Number;
	private var _dragY : Number;
	
	public function UIPoint(
		color : uint, x : Number, y : Number, label : String,
		movable : Boolean = false
	) {

		var g : Graphics = graphics;
		g.clear();
		g.beginFill(color, 0.5);
		g.drawCircle(0, 0, 5);
		g.endFill();
		
		var labelField : TextField = new TextField();
		labelField.type = TextFieldType.DYNAMIC;
		labelField.autoSize = TextFieldAutoSize.LEFT;
		labelField.selectable = false;
		labelField.text = label;
		labelField.x = 4;
		labelField.y = 4;
		addChild(labelField);

		this.x = x;
		this.y = y;
		
		buttonMode = movable;
		useHandCursor = movable;

		if (movable) {
			_pressed = false;
			addEventListener(MouseEvent.MOUSE_DOWN, mouseDownHandler);	
		}
	}
	
	private function mouseDownHandler(event : MouseEvent) : void {

		if (_pressed) return;
		
		stage.addEventListener(MouseEvent.MOUSE_UP, stage_mouseUpHandler);
		stage.addEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMoveHandler);
		stage.addEventListener(Event.MOUSE_LEAVE, stage_mouseLeaveHandler);

		_dragX = mouseX;
		_dragY = mouseY;
		_pressed = true;
	}

	private function stage_mouseMoveHandler(event : MouseEvent) : void {
		x += (mouseX - _dragX);
		y += (mouseY - _dragY);
	}
	
	private function stage_mouseUpHandler(event : MouseEvent) : void {
		releaseMouse();
	}
	
	private function stage_mouseLeaveHandler(event : Event) : void {
		releaseMouse();
	}

	private function releaseMouse() : void {

		if (!_pressed) return;

		stage.removeEventListener(MouseEvent.MOUSE_UP, stage_mouseUpHandler);
		stage.removeEventListener(MouseEvent.MOUSE_MOVE, stage_mouseMoveHandler);
		stage.removeEventListener(Event.MOUSE_LEAVE, stage_mouseLeaveHandler);
		
		_pressed = false;
	}
}