/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yuXr
 */

// forked from yd_niku's flash on 2010-5-28
package {
    import flash.display.Sprite;
    import frocessing.display.*;
    import flash.geom.*;
    public class FlashTest extends F5MovieClip2DBmp{
        public function FlashTest() {
            super();
        }
        private var _points:Vector.<ControlPoint> = new Vector.<ControlPoint>();
       
        public function setup():void{
            size( stage.stageWidth, stage.stageHeight);
            background(0);
            noFill();
            stroke( 255, 0.1 );
            
            var ctrl:ControlPoint = new ControlPoint(10,232,-90);
            addChild(ctrl);
            _points.push(ctrl);
            
            for( var i:int=1; i<=3; ++i ) {
                ctrl = new ControlPoint(445/4*i+10,Math.random()*300+10, Math.random()*360);
                addChild(ctrl);
                _points.push(ctrl);
            }
            
            ctrl  = new ControlPoint(455,232,-90);
            addChild(ctrl);
            _points.push(ctrl);
        }
        
        private var _t:Number = 0;
        public function draw():void{
            background(0);
            
            beginShape();
            for( var i:int=0,l:int=_points.length-2; i<l; ++i) {
            moveTo( _points[i].x, _points[i].y );
            bezierTo(
                _points[i].handleB.x, _points[i].handleB.y,
                _points[i+1].handleA.x, _points[i+1].handleA.y,
                _points[i+1].x,_points[i+1].y );
                
            bezierTo(
                _points[i+1].handleB.x, _points[i+1].handleB.y,
                _points[i+2].handleA.x, _points[i+2].handleA.y,
                _points[i+2].x,_points[i+2].y );
            }
            
            endShape();
            _t += 0.05;
        }
    }
}


import flash.display.*;
import flash.events.*;
import flash.geom.*;
class Ball extends Sprite{
    public function Ball(sx:Number,sy:Number,color:uint=0xFFFFFF){
        graphics.beginFill(color);
        graphics.drawCircle(0,0,4);
        graphics.endFill();
        
        x = sx;
        y = sy;
        addEventListener(MouseEvent.MOUSE_DOWN,mouseDown);
    }
    private function mouseDown(e:Event):void{
        startDrag();
        addEventListener(MouseEvent.MOUSE_UP,mouseUp);
        addEventListener(MouseEvent.MOUSE_MOVE,mouseMove);
        stage.addEventListener(MouseEvent.MOUSE_UP,mouseUp);
    }
    private function mouseMove(e:Event):void{
        dispatchEvent(new Event("update"));
    }
    private function mouseUp(e:Event):void{
        stopDrag();
        dispatchEvent(new Event("update"));
        removeEventListener(MouseEvent.MOUSE_UP,mouseUp);
        removeEventListener(MouseEvent.MOUSE_MOVE,mouseMove);
        stage.removeEventListener(MouseEvent.MOUSE_UP,mouseUp);
    } 
    
}

class ControlPoint extends Sprite{
    private var _handleA:Sprite;
    private var _handleB:Sprite;
    private var _base:Sprite;
    
    private var _angle:Number = 0;
    private var _handleALength:Number = 50;
    private var _handleBLength:Number = 50;
    
    public function ControlPoint( sx:Number, sy:Number, angle:Number= 0 ){
        super();
        x = sx;
        y = sy;
        _angle = angle/180*Math.PI;
        
        _handleA = new Ball(0,0,0x9999ff);
        addChild(_handleA);
        _handleB = new Ball(0,0, 0xFF9999);
        addChild(_handleB);
        
        _base= new Ball(0,0);
        _base.mouseEnabled = false;
        addChild(_base);
        
        _handleA.addEventListener("update",updateAngle);
        _handleB.addEventListener("update",updateAngle);
        
        update(true,true);
    }
    public function update(a:Boolean,b:Boolean):void{
        if(a){
            _handleA.x = Math.sin(_angle)*_handleALength;
            _handleA.y = Math.cos(_angle)*_handleALength;
        }
        if(b){
            _handleB.x = Math.sin(_angle+Math.PI)*_handleBLength;
            _handleB.y = Math.cos(_angle+Math.PI)*_handleBLength;
        }
        
        graphics.clear();
        graphics.lineStyle(0,0xFFFFFF);
        graphics.moveTo(_handleA.x,_handleA.y);
        graphics.lineTo(_handleB.x,_handleB.y);
    }
    
    
    private function updatePosition(e:Event):void{
        update(true,true);
    }
    private function updateAngle(e:Event):void{
        switch(e.currentTarget){
            case _handleA:
                _handleALength = Math.sqrt( _handleA.x*_handleA.x+_handleA.y*_handleA.y );
                _angle = Math.PI*0.5-Math.atan2( _handleA.y, _handleA.x );
                update(false,true);
                
            break;
            case _handleB:
                _handleBLength = Math.sqrt( _handleB.x*_handleB.x+_handleB.y*_handleB.y );
                _angle = Math.PI*0.5-Math.atan2( -_handleB.y, -_handleB.x );
                update(true,false);
            break;
        }
    }
    
    public function get handleA():Point{ return new Point(_handleA.x+x,_handleA.y+y );}
    public function get handleB():Point{ return new Point(_handleB.x+x,_handleB.y+y );}
}