/**
 * Copyright 7kamura ( http://wonderfl.net/user/7kamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/yuAc
 */

package {
    import flash.display.Sprite;
    import flash.display.*;
    import flash.geom.Rectangle;
    import flash.events.Event;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFieldAutoSize;
    public class Main extends Sprite {
		public static const WIDTH:Number = 465;
		public static const HEIGHT:Number = 465;
		public static const GRAVITY:Number = 0.3;
    		private var rect:Rectangle;
    		private var canvas:BitmapData;
    		private var textBmd:BitmapData;
    		private var particleList:Array;
    		
    		// アニメーション用の設定をしておくよ
    		[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
    		
        public function Main() {
        		if(stage) init();
        }
        private function init():void {
        		// ここにParticleを描画していくよ
        		canvas = new BitmapData(WIDTH, HEIGHT, false, 0x0);
        		addChild(new Bitmap(canvas));
        		
        		// Particle達はここに入れておくよ
        		particleList = new Array;
        		
        		// Particleで彩られる予定の文字データを用意するよ
        		createText();
        		
        		// 毎フレームごとに描画を更新してもらうよ
        		addEventListener(Event.ENTER_FRAME, update);
        }
        private function update(e:Event):void {
        		canvas.fillRect(canvas.rect, 0x0);
        		
        		// Particleを10個つくるよ
        		var p_num:Number = 10;
        		while(p_num--) {
        			createParticle(Math.random()*WIDTH, 0);
        		}
        			
        		canvas.lock();
        		var n:Number = particleList.length;
        		while(n--) {
        			var p:Particle = particleList[n];
        			p.vy += GRAVITY; // 重力加速度
        			p.vx *= 0.95; // 空気抵抗
        			p.vy *= 0.95;
        			p.x += p.vx; // 移動
        			p.y += p.vy;
        			canvas.setPixel(p.x, p.y, p.c);
        			
        			// 画面外に出たParticleを抹消するよ
        			if (p.x > WIDTH || p.x < 0 || p.y > HEIGHT || p.y < 0) {
        				particleList.splice(n, 1);
        			}
        		}
        		
        		canvas.unlock();
        }
        
    		private function createText():void {
    			var tfmt:TextFormat = new TextFormat();
    			tfmt.size = 50;
    			var tfld:TextField = new TextField();
    			tfld.autoSize = TextFieldAutoSize.LEFT;
    			tfld.defaultTextFormat = tfmt;
    			tfld.text = "Gakuweb";
    			tfld.x = (canvas.width - tfld.width) / 2;
    			tfld.y = (canvas.height- tfld.height)/ 2;
    			
    			/* For Debug
    			tfld.background = true;
    			tfld.backgroundColor = 0xFFFFFF;
    			addChild(tfld);
    			*/
    		}
    		
    		private function createParticle(x:Number, y:Number, vx:Number = 0, vy:Number = 0, c:uint = 0xFFFFFF):void {
    			var p:Particle = new Particle();
    			p.x = x;
    			p.y = y;
    			p.vx = vx;
    			p.vy = vy;
    			p.c = c;
    			particleList.push(p);
    		}
    }
}

class Particle {
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
	public var c:uint;
	
	public function init():void {
		x = 0;
		y = 0;
		vx = 0;
		vy = 0;
		c = 0xFFFFFF;
	}
}